/*
 * Decompiled with CFR 0.152.
 */
package zeph.buffer;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class BufferPool
implements AutoCloseable {
    private final Arena arena;
    private final int bufferSize;
    private final int poolSize;
    private final ConcurrentLinkedQueue<PooledBuffer> available;
    private final AtomicInteger allocated;
    private final AtomicInteger inUse;

    public BufferPool(int bufferSize, int poolSize) {
        this.bufferSize = bufferSize;
        this.poolSize = poolSize;
        this.arena = Arena.ofShared();
        this.available = new ConcurrentLinkedQueue();
        this.allocated = new AtomicInteger(0);
        this.inUse = new AtomicInteger(0);
        for (int i = 0; i < poolSize; ++i) {
            MemorySegment segment = this.arena.allocate(bufferSize, 64L);
            this.available.offer(new PooledBuffer(segment, this, i));
            this.allocated.incrementAndGet();
        }
    }

    public PooledBuffer acquire() {
        PooledBuffer buffer = this.available.poll();
        if (buffer != null) {
            buffer.reset();
            this.inUse.incrementAndGet();
        }
        return buffer;
    }

    public PooledBuffer acquireOrAllocate() {
        PooledBuffer buffer = this.acquire();
        if (buffer == null) {
            MemorySegment segment = this.arena.allocate(this.bufferSize, 64L);
            buffer = new PooledBuffer(segment, this, this.allocated.getAndIncrement());
            this.inUse.incrementAndGet();
        }
        return buffer;
    }

    void returnBuffer(PooledBuffer buffer) {
        this.available.offer(buffer);
        this.inUse.decrementAndGet();
    }

    public int getAvailable() {
        return this.available.size();
    }

    public int getAllocated() {
        return this.allocated.get();
    }

    public int getInUse() {
        return this.inUse.get();
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public void close() {
        this.available.clear();
        this.arena.close();
    }

    public String toString() {
        return String.format("BufferPool[size=%d, allocated=%d, inUse=%d, available=%d]", this.bufferSize, this.allocated.get(), this.inUse.get(), this.available.size());
    }

    public static class PooledBuffer {
        private final MemorySegment segment;
        private final BufferPool pool;
        private final int id;
        private volatile boolean returned = false;

        PooledBuffer(MemorySegment segment, BufferPool pool, int id) {
            this.segment = segment;
            this.pool = pool;
            this.id = id;
        }

        public MemorySegment segment() {
            return this.segment;
        }

        public int id() {
            return this.id;
        }

        public int size() {
            return (int)this.segment.byteSize();
        }

        public void release() {
            if (!this.returned) {
                this.returned = false;
                this.pool.returnBuffer(this);
            }
        }

        void reset() {
            this.returned = false;
        }
    }
}

