(ns silvur.data
  (:gen-class)
  (:require [clojure.tools.cli :refer (parse-opts)]
            [clojure.string :as str]
            [next.jdbc :as jdbc]
            [next.jdbc.sql :as sql]))

(def dbspec  {:dbtype "postgres" :dbname "postgres" :password "GNU%Emacs29%root" :user "postgres"
              :host "172.18.1.33"})

(defn truncate [table]
  (let [ds (jdbc/get-datasource dbspec)]
    (jdbc/execute! ds [(str "truncate table " table) ])))

(defn count-rows [table]
  (let [ds (jdbc/get-datasource dbspec)]
    (jdbc/execute! ds [(str "select count(*) from " table) ])))

(defn generate [n unit]
  (let [ds (jdbc/get-datasource dbspec)]
    (loop [i (quot n unit)]
      (println i)
      (when (< 0 i)
        (->> (range 0 unit)
             (mapv #(hash-map :id (+ (* i unit) %)
                              :name (subs (str (random-uuid)) 0 8)
                              :email (str (subs (str (random-uuid)) 0 8) "@sample.io")))
             (sql/insert-multi! ds :accounts ))
        (recur (dec i))))))
