(ns silvur.jwt
  (:require [clojure.java.shell :refer [sh with-sh-dir with-sh-env]]
            [clojure.tools.cli :refer (parse-opts)]
            [clojure.string :as str]
            [clojure.java.io :as io]
            [clojure.java.process :as proc]
            [silvur.util :as util]
            [silvur.datetime :refer [datetime datetime*] :as sd]
            [buddy.core.keys :as keys]
            [buddy.sign.jwt :as jwt]
            [babashka.fs :as fs]))


(def specs [["-h" "--help" "This help"]
            ["-P" "--private-key <path>" "A path to the private key file to use"]])

(defn usage [summary]
  (println (->> ["Usage:"
                 ""
                 " - sign [options]"
                 ""
                 "Command options: (+: arguments, =: keyval, -: hyphen options)"
                 ""
                 " - sign:"
                 "    - private-key"
                 ""
                 "hyphen options:"
                 summary
                 ""]
                (str/join \newline))))


(defn sign* [{:keys [sub exp aud] :as claims} & {:keys [opts arg]}]
  (let [{:keys [private-key alg]} opts]
    (-> {:exp (or exp (* 1000 (datetime* (sd/+time (datetime) (sd/hour 20) ))))
         :sub sub}
        (merge claims)
        (jwt/sign  (keys/private-key private-key) {:alg (or alg :rs256)}))))

(defn main [& args]
  (let [{:keys [arguments options summary]} (parse-opts args specs)
        [op & cmd-args] args
        merged-opts (util/merge-options arguments options)]
    (if (:help options)
      (usage summary)
      (try
        (proc/exec "which" "openssl")
        ;; (binding [*work-dir* (str "tls-keys-" (rand-int 1000))]
        ;;   (when (:debug options) (debug!))
        ;;   (condp get (keyword op)
        ;;     #{:build-ca :ca}  (build-ca* merged-opts)
        ;;     #{:gen-cert} (gen-cert* merged-opts)
        ;;     #{:inspect} (if-let [f (first cmd-args)]
        ;;                   (inspect f (:opts merged-opts))
        ;;                   (throw (ex-info "No file specified" {}))
        ;;                   )
        ;;     (usage summary)))
        (catch clojure.lang.ExceptionInfo e (usage summary))
        (catch  Exception e (println e))))))





