(ns mulify.svg
  (:require [dali.io :as io]
            [clojure.string :as str]
            [dali.prefab :as prefab]
            [dali.layout.stack]
            [dali.syntax :as d]
            [dali.layout.align]
            [garden.core :as g]))

(def circle-radius 50)

(defn text-stack [texts]
  (vec (concat [:dali/stack {:direction :down :gap 6}]
               (map #(vector :text {:font-family "Verdana" :font-size 14} %) texts))))

(defn circle-text
  ([id text cls]
   (circle-text id text cls nil))
  ([id text cls radius]
   (let [radius (or radius circle-radius)]
    [:dali/align {:axis :center}
     [:circle {:id id :class cls :filter "url(#ds)"} :_ radius]
     (text-stack (str/split-lines text))])))

(def doc
  [:dali/page
   [:defs
    (prefab/drop-shadow-effect :ds {:opacity 0.3 :offset [5 5] :radius 6})
    (d/css (g/css [:corp-fun {:fill "darkorange"}]))
    ]
   [:dali/stack {:position [30 400]}
    (circle-text :set-variable "Set Variable" :corp-fun )]])

