(ns mulify.generic
  (:require [mulify.core :refer [defprocess >snake]]
            [clojure.string :as str]
            [clojure.data.xml :as xml]))

(defn connector [{:keys [connector-type key-fn] :as attrs :or {key-fn identity}} & body]
  (let [[cns cn] (str/split (name connector-type)  #":")]
    (xml/element (keyword (str "mulify." cns) cn)
                 (key-fn (dissoc attrs :connector-type :key-fn))
                 body)))
