(ns mulify.ee
  (:require [mulify.doc :as doc]
            [mulify.core :refer (defprocess)]
            [silvur.util :refer [uuid]]
            [clojure.data.xml :as dx]))

(defprocess transform {:display-name "transorm"} :key-fn identity)
(defprocess message)
(defprocess object-store-caching-strategy)
(defprocess cache)
(defprocess set-payload {} :update-fn dx/cdata)
(defprocess set-variable)
(defprocess variables)
(defprocess message)

(defn transform* [& {:keys [display-name resource dw]  :as params} ]
  (transform {:display-name display-name}
   (message {}
    (set-payload (or dw (select-keys params [:resource] ))))))
