(ns mulify.admin.jdbc
  (:require [next.jdbc :as jdbc]
            [next.jdbc.result-set :as rs]
            [clojure.data.xml :as xml]))

(def db {:dbtype "mysql"
         :dbname "y1"
         :user "y1"
         :host "eksprod.tools.mulesoft.com"
         :password "Debian311Winnt400"
         :port 30786})

(defonce ^:dynamic *ds* (atom nil))
(defn set-default-datasource! [& {:keys [dbtype dbname user host password port] :as db-spec
                                  :or {dbtype "mysql" port 3306}}]
  (reset! *ds* (jdbc/get-datasource db-spec)))

(defn get-database-meta-data []
  (with-open [con (jdbc/get-connection @*ds*)]
    (-> (.getMetaData con)
        (.getTables nil nil nil (into-array ["TABLE"]))
        (rs/datafiable-result-set )
        (->> (map #(select-keys % [:TABLE_NAME]))))))

(defn get-table-meta-data [schema table]
  (with-open [con (jdbc/get-connection @*ds*)]
    (-> (.getMetaData con)
        (.getColumns nil (name schema) (name table) nil)
        (rs/datafiable-result-set)
        (->> (map #(select-keys % [:COLUMN_NAME :TYPE_NAME :COLUMN_SIZE :DATA_TYPE :IS_NULLABLE]))))))

(defn get-keys-meta-data [schema table]
  (with-open [con (jdbc/get-connection @*ds*)]
    (prn con)
    (-> (.getMetaData con)
        ;;(.getPrimaryKeys nil schema table)
        ;;(rs/datafiable-result-set)
        ;;(->> (map #(select-keys % [:COLUMN_NAME :TYPE_NAME :COLUMN_SIZE])))
        )))



(defn gen-csdl [schema table]
  (let [properties (->> (get-table-meta-data schema table)
                        (map #(xml/element :Property (conj {:Name (:COLUMN_NAME %)}
                                                           (condp = (:TYPE_NAME %)
                                                             "INT" {:Type (str "Edm.Int" (* (:DATA_TYPE %) 8))}
                                                             "DATE" {:Type (str "Edm.DateTime")} 
                                                             "VARCHAR" {:Type "Edm.String"
                                                                        :MaxLength (:COLUMN_SIZE %)
                                                                        :Unicode "true"})
                                                           (when (= (:IS_NULLABLE %) "YES")
                                                             {:Nullable "true"})))))]
    (xml/emit-str 
     (apply xml/element :EntityType {:Name table}
            properties))
    ))
