(ns mulify.db
  (:refer-clojure :exclude [update])
  (:require [clojure.data.xml :as dx]
            [silvur.util :refer [uuid]]
            [clojure.string :as str]
            [mulify.core :refer (defprocess camelize)]))

(defprocess config)

(defprocess sql)

(defprocess input-parameters)

(defprocess my-sql-connection {:host "localhost" :port 3306})

(defprocess pooling-profile {:max-pool-size "10" :min-pool-size "1"})

(defprocess select {:config-ref "catabase_config"})

(defprocess update)

(defprocess insert {:auto-generate-keys true :config-ref "database_config"})

(defprocess query-single {:config-ref "database_config"})

(defprocess listener {:config-ref "database_config"})


(defn select* [{:keys [config-ref sql-content input-parameters-content]
                :or {sql-content "#[payload]"
                     input-parameters-content "#[attributes.queryParameters]"}}]
  (select
   {:config-ref config-ref}
   (sql sql-content)
   (input-parameters input-parameters-content)))

(defn insert* [{:keys [config-ref sql-content input-parameters-content]
                :or {sql-content "#[payload]"
                     input-parameters-content "#[attributes.queryParameters]"}}]
  (insert
   {:config-ref config-ref}
   (sql sql-content)
   (input-parameters input-parameters-content)))


(defn mysql-config* [{:keys [name config-prefix host port user password database]
                      :or {name "Database_Config"}}]
  (config
   {:name name}
   (my-sql-connection
    (if config-prefix
      {:host (str "${" config-prefix ".host}"),
       :port (str "${" config-prefix ".port}")
       :user (str "${" config-prefix ".user}")
       :password (str "${" config-prefix ".password}")
       :database (str "${" config-prefix ".database}")}
      {:host host
       :port port
       :user user
       :password password
       :database database}))))
