(ns mulify.dataweave
  (:require [clojure.data.xml :as dx]
            [jsonista.core :as j]
            [jsonista.tagged :as jt]
            [clojure.string :as str]))

(def mapper
  (j/object-mapper {:encode-key-fn true
                    :decode-key-fn true
                    :modules [(jt/module {:handlers {clojure.lang.Symbol {:tag "!sym"
                                                                          :encode jt/encode-str
                                                                          :decode symbol}}})]}))

(defn fx
  ([body]
   (str "#[" (if (map? body)
               (str/replace (j/write-value-as-string body mapper) #"\[\"!sym\",\"(.*?)\"\]" "$1")
               (symbol body)) "]"))
  ([output body]
   (str "#[" "output " (name output) " --- " (if (map? body)
                                               (str/replace (j/write-value-as-string body mapper) #"\[\"!sym\",\"(.*?)\"\]" "$1")
                                               (symbol body)) "]")))

(defn wrap [^String body & [output]]
  (if (.matches body "^#")
    body
    (str "%dw 2.0\n"
         "output " (or output "application/json\n")
         "---\n"
         body)))


