(ns mulify.http
  (:require [clojure.data.xml :as dx]
            [clojure.string :as str]
            [mulify.dataweave :as dw]
            [mulify.tls :as tls]
            [silvur.util :refer [uuid map->json]]
            [mulify.core :refer (defprocess camelize)]))



(defprocess listener-connection
  {:port "8081" :host "localhost" :protocol "HTTP"})

(defprocess listener-config {:name "listner-config"})

(defn https-listener-config* [& {:keys [name host port key-type key-path key-password]
                                 :or {name "listener-config"
                                      port "8082"}}]
  (->> (tls/context (tls/key-store {:type key-type
                                    :path key-path
                                    :keyPassword key-password
                                    :password key-password}))
       (listener-connection {:host host :port port :protocol "HTTPS"})
       (listener-config {:name name})))

(defn http-listener-config* [& {:keys [name host port] :or {name "listener-config" port "8081"}}]
  (->> (listener-connection {:host host :port port})
       (listener-config {:name name})))


(defprocess request-connection {:host "localhost" :port "80" :protocol "HTTP"})

(defprocess request-config {:name "request-config"})


(defn http-request-config* [& {:keys [name port host]
                               :or {name "http-request-config" host "localhost" port "80"}}]
  (request-config {:name name}
                  (request-connection {:protocol "HTTP" :host host :port port})))

(defn https-request-config* [& {:keys [name port host]
                                :or {name "https-request-config" host "localhost" port "443"}}]
  (request-config {:name name}
                  (request-connection {:protocol "HTTPS" :host host :port port})))

(defprocess response {:status-code "#[vars.httpStatus default 200]"})
(defprocess error-response {:status-code "#[vars.httpStatus default 500]"})
(defprocess body)
(defprocess listener {:path "/api/*" :config-ref "http-listner-config"})

(defprocess request {:path "/",
                     :config-ref "config-ref"
                     :method "GET"})

(defprocess query-params)

(defprocess headers)

