(ns mulify.http
  (:require [clojure.data.xml :as dx]
            [clojure.string :as str]
            [mulify.dataweave :as dw]
            [silvur.util :refer [uuid map->json]]
            [mulify.core :refer (defprocess camelize)]))


;; (defn listener-connection [{:keys [host port]}]
;;   (dx/element ::listener-connection {:port port :host host}))

(defprocess listener-connection {:port "8081" :host "localhost"})

;; (defn request-connection [{:keys [host port protocol]}]
;;   (dx/element ::request-connection
;;                           {:protocol protocol
;;                            :port (or port (if (= (str/upper-case protocol) "HTTPS")
;;                                             "443"
;;                                             "80"))
;;                            :host host}))



;; (defn listener-config [& [{:keys [name port host]
;;                          :or {name "listener-config" port "8081" host "0.0.0.0"}}]]
;;   (dx/element ::listener-config
;;               {:name (or name (str (gensym "ListnerConfig_")))}
;;               (dx/element ::listener-connection {:port port :host host})))

(defprocess listener-config {:name "http-listner-config"})

(defn listener-config* [{:keys [name host port]
                         :or {name "listener-config" host "localhost" port "8081"}}]
  (listener-config {:name name}
                   (listener-connection {:host host :port port})))


(defprocess request-connection {:host "localhost" :port "80" :protocol "HTTP"})

(defprocess request-config {:host "localhost" :port "80" :protocol "HTTP" :name "http-request-config"})

(defn request-config* [& [{:keys [name port host protocol]
                           :or {protocol "HTTPS" name "request-config" host "0.0.0.0"}}]]
  (request-config {:name name}
                  (request-connection {:protocol protocol :host host :port port}))
  ;; (dx/element ::request-config
  ;;             {:name (or name (str (gensym "RequestConfig_")))}
  ;;             (dx/element ::request-connection
  ;;                         {:protocol protocol
  ;;                          :port (or port (if (= (str/upper-case protocol) "HTTPS")
  ;;                                           "443"
  ;;                                           "80"))
  ;;                          :host host}))
  )



;; (defn listener [& [{:keys [path config-ref
;;                            response error-response
;;                            response-headers error-response-headers
;;                            body]
;;                     :or {path "/api/*"
;;                          config-ref "listener-config"
;;                          response "#[vars.httpStatus default 200]"
;;                          response-headers "#[vars.outboundHeaders default {}]"
;;                          error-response "#[vars.httpStatus default 500]"
;;                          error-response-headers "#[vars.outboundHeaders default {}]"
;;                          body "#[payload]"}}]]
;;   (dx/element ::listener
;;               {:path path, :config-ref config-ref}
;;               ;; (dx/element ::response
;;               ;;             {:statusCode response}
;;               ;;             (dx/element ::headers
;;               ;;                         {}
;;               ;;                         response-headers))
;;               ;; (dx/element ::error-response
;;               ;;             {:statusCode error-response}
;;               ;;             (dx/element ::body {} body)
;;               ;;             (dx/element ::headers {} error-response-headers))
;;               ))

;; (defn response [{:keys [status-code]} & body]
;;   (apply dx/element
;;          ::response
;;          {:statusCode (or status-code "#[vars.httpStatus default 200]")}
;;          body))

;; (defn error-response [{:keys [status-code]} & body]
;;   (apply dx/element
;;          ::response
;;          {:statusCode (or status-code "#[vars.httpStatus default 500]")}
;;          body))

;; (defn body [& [content]]
;;   (dx/element ::body (or content "#[payload]")))

(defprocess response {:status-code "#[vars.httpStatus default 200]"})
(defprocess error-response {:status-code "#[vars.httpStatus default 500]"})
(defprocess body {})
(defprocess listener {:path "/api/*" :config-ref "http-listner-config"})
(defn listener* [& params-or-body]
  (listener (first params-or-body)
            (response (second params-or-body))
            (error-response (first (drop 2 params-or-body)))))


;; (defn request [{:keys [path config-ref method] :or {method "GET" path "/"}} & others]
;;   (apply dx/element ::request
;;          {:path path,
;;           :config-ref config-ref,
;;           :doc:id (str (uuid)),
;;           :doc:name "Request",
;;           :method method}
;;          others))

(defprocess request {:path "/",
                     :config-ref "config-ref"
                     :method "GET"})

;; (defn query-params [dw-params]
;;   (dx/element ::query-params {} (dx/cdata dw-params)))

(defprocess query-params {})

;; (defn headers [body]
;;   (dx/element ::headers {} body))

(defprocess headers {})

