(ns mulify.db
  (:refer-clojure :exclude [update])
  (:require [clojure.data.xml :as dx]
            [silvur.util :refer [uuid]]
            [clojure.string :as str]
            [mulify.core :refer (defprocess camelize)]))

(defprocess config)

(defprocess sql)

(defprocess input-parameters)

(defprocess my-sql-connection {:host "localhost" :port 3306})

(defprocess pooling-profile {:max-pool-size "10" :min-pool-size "1"})

(defprocess select {:config-ref "Database_Config"})

(defprocess update)

(defprocess insert {:auto-generate-keys true :config-ref "Database_Config"})

(defprocess query-single {:config-ref "Database_Config"})

(defprocess listener {:config-ref "Database_Config"})
