(ns godotclj.api.gdscript
  (:require [godotclj.proto :as proto] [godotclj.bindings.godot])
  (:import godotclj.bindings.godot.IndexedPoolStringArray
           godotclj.bindings.godot.Variant
           godotclj.bindings.godot.IndexedArray
           godotclj.bindings.godot.Color
           godotclj.bindings.godot.IndexedPoolVector2Array
           godotclj.bindings.godot.IndexedRect2
           godotclj.bindings.godot.Vector2
           godotclj.bindings.godot.NodePath
           godotclj.bindings.godot.PoolByteArray
           godotclj.bindings.godot.AABB
           godotclj.bindings.godot.Transform
           godotclj.bindings.godot.Dictionary
           godotclj.bindings.godot.PoolIntArray
           godotclj.bindings.godot.RID
           godotclj.bindings.godot.PoolColorArray
           godotclj.bindings.godot.PoolRealArray
           godotclj.bindings.godot.Vector3
           godotclj.bindings.godot.Plane
           godotclj.bindings.godot.Transform2D
           godotclj.bindings.godot.PoolVector3Array
           godotclj.bindings.godot.Basis))
(definterface
 MGodotObject
 (^{:tag void} addUserSignal [signal])
 (^{:tag void} addUserSignal [signal arguments])
 (^{:tag godotclj.bindings.godot.Variant} call [method])
 (^{:tag godotclj.bindings.godot.Variant} call [method v1])
 (^{:tag godotclj.bindings.godot.Variant} call [method v1 v2])
 (^{:tag godotclj.bindings.godot.Variant} call [method v1 v2 v3])
 (^{:tag godotclj.bindings.godot.Variant} call [method v1 v2 v3 v4])
 (^{:tag godotclj.bindings.godot.Variant}
  call
  [method v1 v2 v3 v4 v5])
 (^{:tag void} callDeferred [method])
 (^{:tag void} callDeferred [method v1])
 (^{:tag void} callDeferred [method v1 v2])
 (^{:tag void} callDeferred [method v1 v2 v3])
 (^{:tag void} callDeferred [method v1 v2 v3 v4])
 (^{:tag void} callDeferred [method v1 v2 v3 v4 v5])
 (^{:tag godotclj.bindings.godot.Variant} callv [method arg_array])
 (^{:tag boolean} canTranslateMessages [])
 (^{:tag int} connect [signal target method])
 (^{:tag int} connect [signal target method binds])
 (^{:tag int} connect [signal target method binds flags])
 (^{:tag void} disconnect [signal target method])
 (^{:tag void} emitSignal [signal])
 (^{:tag void} emitSignal [signal v1])
 (^{:tag void} emitSignal [signal v1 v2])
 (^{:tag void} emitSignal [signal v1 v2 v3])
 (^{:tag void} emitSignal [signal v1 v2 v3 v4])
 (^{:tag void} emitSignal [signal v1 v2 v3 v4 v5])
 (^{:tag void} free [])
 (^{:tag godotclj.bindings.godot.Variant} get [property])
 (^{:tag String} getClass [])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  getIncomingConnections
  [])
 (^{:tag godotclj.bindings.godot.Variant} getIndexed [property])
 (^{:tag int} getInstanceId [])
 (^{:tag godotclj.bindings.godot.Variant} getMeta [name])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  getMetaList
  [])
 (^{:tag godotclj.bindings.godot.IndexedArray} getMethodList [])
 (^{:tag godotclj.bindings.godot.IndexedArray} getPropertyList [])
 (^{:tag godotclj.api.gdscript.IGodotReference} getScript [])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  getSignalConnectionList
  [signal])
 (^{:tag godotclj.bindings.godot.IndexedArray} getSignalList [])
 (^{:tag boolean} hasMeta [name])
 (^{:tag boolean} hasMethod [method])
 (^{:tag boolean} hasSignal [signal])
 (^{:tag boolean} hasUserSignal [signal])
 (^{:tag boolean} isBlockingSignals [])
 (^{:tag boolean} isClass [class])
 (^{:tag boolean} isConnected [signal target method])
 (^{:tag boolean} isQueuedForDeletion [])
 (^{:tag void} notification [what])
 (^{:tag void} notification [what reversed])
 (^{:tag void} propertyListChangedNotify [])
 (^{:tag void} removeMeta [name])
 (^{:tag void} set [property value])
 (^{:tag void} setBlockSignals [enable])
 (^{:tag void} setDeferred [property value])
 (^{:tag void} setIndexed [property value])
 (^{:tag void} setMessageTranslation [enable])
 (^{:tag void} setMeta [name value])
 (^{:tag void} setScript [script])
 (^{:tag String} toString [])
 (^{:tag String} tr [message]))
(definterface
 MGodotEditorNavigationMeshGenerator
 (^{:tag void} bake [nav_mesh root_node])
 (^{:tag void} clear [nav_mesh]))
(definterface
 MGodotReference
 (^{:tag boolean} initRef [])
 (^{:tag boolean} reference [])
 (^{:tag boolean} unreference []))
(definterface
 MGodotResource
 (^{:tag godotclj.api.gdscript.IGodotResource} duplicate [])
 (^{:tag godotclj.api.gdscript.IGodotResource}
  duplicate
  [subresources])
 (^{:tag void} emitChanged [])
 (^{:tag godotclj.api.gdscript.IGodotNode} getLocalScene [])
 (^{:tag String} getName [])
 (^{:tag String} getPath [])
 (^{:tag godotclj.bindings.godot.RID} getRid [])
 (^{:tag boolean} isLocalToScene [])
 (^{:tag void} setLocalToScene [enable])
 (^{:tag void} setName [name])
 (^{:tag void} setPath [path])
 (^{:tag void} setupLocalToScene [])
 (^{:tag void} takeOverPath [path]))
(definterface
 MGodotVisualShaderNode
 (^{:tag godotclj.bindings.godot.IndexedArray}
  getDefaultInputValues
  [])
 (^{:tag godotclj.bindings.godot.Variant}
  getInputPortDefaultValue
  [port])
 (^{:tag int} getOutputPortForPreview [])
 (^{:tag void} setDefaultInputValues [values])
 (^{:tag void} setInputPortDefaultValue [port value])
 (^{:tag void} setOutputPortForPreview [port]))
(definterface MGodotVisualShaderNodeVectorScalarMix)
(definterface
 MGodotNode
 (^{:tag void} addChild [node])
 (^{:tag void} addChild [node legible_unique_name])
 (^{:tag void} addChildBelowNode [node child_node])
 (^{:tag void}
  addChildBelowNode
  [node child_node legible_unique_name])
 (^{:tag void} addToGroup [group])
 (^{:tag void} addToGroup [group persistent])
 (^{:tag boolean} canProcess [])
 (^{:tag godotclj.api.gdscript.IGodotNode} duplicate [])
 (^{:tag godotclj.api.gdscript.IGodotNode} duplicate [flags])
 (^{:tag godotclj.api.gdscript.IGodotNode} findNode [mask])
 (^{:tag godotclj.api.gdscript.IGodotNode} findNode [mask recursive])
 (^{:tag godotclj.api.gdscript.IGodotNode}
  findNode
  [mask recursive owned])
 (^{:tag godotclj.api.gdscript.IGodotNode} findParent [mask])
 (^{:tag godotclj.api.gdscript.IGodotNode} getChild [idx])
 (^{:tag int} getChildCount [])
 (^{:tag godotclj.bindings.godot.IndexedArray} getChildren [])
 (^{:tag godotclj.api.gdscript.IGodotMultiplayerAPI}
  getCustomMultiplayer
  [])
 (^{:tag String} getFilename [])
 (^{:tag godotclj.bindings.godot.IndexedArray} getGroups [])
 (^{:tag int} getIndex [])
 (^{:tag godotclj.api.gdscript.IGodotMultiplayerAPI}
  getMultiplayer
  [])
 (^{:tag String} getName [])
 (^{:tag int} getNetworkMaster [])
 (^{:tag godotclj.api.gdscript.IGodotNode} getNode [path])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  getNodeAndResource
  [path])
 (^{:tag godotclj.api.gdscript.IGodotNode} getNodeOrNull [path])
 (^{:tag godotclj.api.gdscript.IGodotNode} getOwner [])
 (^{:tag godotclj.api.gdscript.IGodotNode} getParent [])
 (^{:tag godotclj.bindings.godot.NodePath} getPath [])
 (^{:tag godotclj.bindings.godot.NodePath} getPathTo [node])
 (^{:tag int} getPauseMode [])
 (^{:tag float} getPhysicsProcessDeltaTime [])
 (^{:tag int} getPositionInParent [])
 (^{:tag float} getProcessDeltaTime [])
 (^{:tag int} getProcessPriority [])
 (^{:tag boolean} getSceneInstanceLoadPlaceholder [])
 (^{:tag godotclj.api.gdscript.IGodotSceneTree} getTree [])
 (^{:tag godotclj.api.gdscript.IGodotViewport} getViewport [])
 (^{:tag boolean} hasNode [path])
 (^{:tag boolean} hasNodeAndResource [path])
 (^{:tag boolean} isAParentOf [node])
 (^{:tag boolean} isDisplayedFolded [])
 (^{:tag boolean} isGreaterThan [node])
 (^{:tag boolean} isInGroup [group])
 (^{:tag boolean} isInsideTree [])
 (^{:tag boolean} isNetworkMaster [])
 (^{:tag boolean} isPhysicsProcessing [])
 (^{:tag boolean} isPhysicsProcessingInternal [])
 (^{:tag boolean} isProcessing [])
 (^{:tag boolean} isProcessingInput [])
 (^{:tag boolean} isProcessingInternal [])
 (^{:tag boolean} isProcessingUnhandledInput [])
 (^{:tag boolean} isProcessingUnhandledKeyInput [])
 (^{:tag void} moveChild [child_node to_position])
 (^{:tag void} printStrayNodes [])
 (^{:tag void} printTree [])
 (^{:tag void} printTreePretty [])
 (^{:tag void} propagateCall [method])
 (^{:tag void} propagateCall [method args])
 (^{:tag void} propagateCall [method args parent_first])
 (^{:tag void} propagateNotification [what])
 (^{:tag void} queueFree [])
 (^{:tag void} raise [])
 (^{:tag void} removeAndSkip [])
 (^{:tag void} removeChild [node])
 (^{:tag void} removeFromGroup [group])
 (^{:tag void} replaceBy [node])
 (^{:tag void} replaceBy [node keep_data])
 (^{:tag void} requestReady [])
 (^{:tag godotclj.bindings.godot.Variant} rpc [method])
 (^{:tag godotclj.bindings.godot.Variant} rpc [method v1])
 (^{:tag godotclj.bindings.godot.Variant} rpc [method v1 v2])
 (^{:tag godotclj.bindings.godot.Variant} rpc [method v1 v2 v3])
 (^{:tag godotclj.bindings.godot.Variant} rpc [method v1 v2 v3 v4])
 (^{:tag godotclj.bindings.godot.Variant} rpc [method v1 v2 v3 v4 v5])
 (^{:tag void} rpcConfig [method mode])
 (^{:tag godotclj.bindings.godot.Variant} rpcId [peer_id method])
 (^{:tag godotclj.bindings.godot.Variant} rpcId [peer_id method v1])
 (^{:tag godotclj.bindings.godot.Variant}
  rpcId
  [peer_id method v1 v2])
 (^{:tag godotclj.bindings.godot.Variant}
  rpcId
  [peer_id method v1 v2 v3])
 (^{:tag godotclj.bindings.godot.Variant}
  rpcId
  [peer_id method v1 v2 v3 v4])
 (^{:tag godotclj.bindings.godot.Variant}
  rpcId
  [peer_id method v1 v2 v3 v4 v5])
 (^{:tag godotclj.bindings.godot.Variant} rpcUnreliable [method])
 (^{:tag godotclj.bindings.godot.Variant} rpcUnreliable [method v1])
 (^{:tag godotclj.bindings.godot.Variant}
  rpcUnreliable
  [method v1 v2])
 (^{:tag godotclj.bindings.godot.Variant}
  rpcUnreliable
  [method v1 v2 v3])
 (^{:tag godotclj.bindings.godot.Variant}
  rpcUnreliable
  [method v1 v2 v3 v4])
 (^{:tag godotclj.bindings.godot.Variant}
  rpcUnreliable
  [method v1 v2 v3 v4 v5])
 (^{:tag godotclj.bindings.godot.Variant}
  rpcUnreliableId
  [peer_id method])
 (^{:tag godotclj.bindings.godot.Variant}
  rpcUnreliableId
  [peer_id method v1])
 (^{:tag godotclj.bindings.godot.Variant}
  rpcUnreliableId
  [peer_id method v1 v2])
 (^{:tag godotclj.bindings.godot.Variant}
  rpcUnreliableId
  [peer_id method v1 v2 v3])
 (^{:tag godotclj.bindings.godot.Variant}
  rpcUnreliableId
  [peer_id method v1 v2 v3 v4])
 (^{:tag godotclj.bindings.godot.Variant}
  rpcUnreliableId
  [peer_id method v1 v2 v3 v4 v5])
 (^{:tag void} rset [property value])
 (^{:tag void} rsetConfig [property mode])
 (^{:tag void} rsetId [peer_id property value])
 (^{:tag void} rsetUnreliable [property value])
 (^{:tag void} rsetUnreliableId [peer_id property value])
 (^{:tag void} setCustomMultiplayer [api])
 (^{:tag void} setDisplayFolded [fold])
 (^{:tag void} setFilename [filename])
 (^{:tag void} setName [name])
 (^{:tag void} setNetworkMaster [id])
 (^{:tag void} setNetworkMaster [id recursive])
 (^{:tag void} setOwner [owner])
 (^{:tag void} setPauseMode [mode])
 (^{:tag void} setPhysicsProcess [enable])
 (^{:tag void} setPhysicsProcessInternal [enable])
 (^{:tag void} setProcess [enable])
 (^{:tag void} setProcessInput [enable])
 (^{:tag void} setProcessInternal [enable])
 (^{:tag void} setProcessPriority [priority])
 (^{:tag void} setProcessUnhandledInput [enable])
 (^{:tag void} setProcessUnhandledKeyInput [enable])
 (^{:tag void} setSceneInstanceLoadPlaceholder [load_placeholder])
 (^{:tag void} updateConfigurationWarning []))
(definterface
 MGodotCanvasItem
 (^{:tag void}
  drawArc
  [center radius start_angle end_angle point_count color])
 (^{:tag void}
  drawArc
  [center radius start_angle end_angle point_count color width])
 (^{:tag void}
  drawArc
  [center
   radius
   start_angle
   end_angle
   point_count
   color
   width
   antialiased])
 (^{:tag float} drawChar [font position char next])
 (^{:tag float} drawChar [font position char next modulate])
 (^{:tag void} drawCircle [position radius color])
 (^{:tag void} drawColoredPolygon [points color])
 (^{:tag void} drawColoredPolygon [points color uvs])
 (^{:tag void} drawColoredPolygon [points color uvs texture])
 (^{:tag void}
  drawColoredPolygon
  [points color uvs texture normal_map])
 (^{:tag void}
  drawColoredPolygon
  [points color uvs texture normal_map antialiased])
 (^{:tag void} drawLine [from to color])
 (^{:tag void} drawLine [from to color width])
 (^{:tag void} drawLine [from to color width antialiased])
 (^{:tag void} drawMesh [mesh texture])
 (^{:tag void} drawMesh [mesh texture normal_map])
 (^{:tag void} drawMesh [mesh texture normal_map transform])
 (^{:tag void} drawMesh [mesh texture normal_map transform modulate])
 (^{:tag void} drawMultiline [points color])
 (^{:tag void} drawMultiline [points color width])
 (^{:tag void} drawMultiline [points color width antialiased])
 (^{:tag void} drawMultilineColors [points colors])
 (^{:tag void} drawMultilineColors [points colors width])
 (^{:tag void} drawMultilineColors [points colors width antialiased])
 (^{:tag void} drawMultimesh [multimesh texture])
 (^{:tag void} drawMultimesh [multimesh texture normal_map])
 (^{:tag void} drawPolygon [points colors])
 (^{:tag void} drawPolygon [points colors uvs])
 (^{:tag void} drawPolygon [points colors uvs texture])
 (^{:tag void} drawPolygon [points colors uvs texture normal_map])
 (^{:tag void}
  drawPolygon
  [points colors uvs texture normal_map antialiased])
 (^{:tag void} drawPolyline [points color])
 (^{:tag void} drawPolyline [points color width])
 (^{:tag void} drawPolyline [points color width antialiased])
 (^{:tag void} drawPolylineColors [points colors])
 (^{:tag void} drawPolylineColors [points colors width])
 (^{:tag void} drawPolylineColors [points colors width antialiased])
 (^{:tag void} drawPrimitive [points colors uvs])
 (^{:tag void} drawPrimitive [points colors uvs texture])
 (^{:tag void} drawPrimitive [points colors uvs texture width])
 (^{:tag void}
  drawPrimitive
  [points colors uvs texture width normal_map])
 (^{:tag void} drawRect [rect color])
 (^{:tag void} drawRect [rect color filled])
 (^{:tag void} drawRect [rect color filled width])
 (^{:tag void} drawRect [rect color filled width antialiased])
 (^{:tag void} drawSetTransform [position rotation scale])
 (^{:tag void} drawSetTransformMatrix [xform])
 (^{:tag void} drawString [font position text])
 (^{:tag void} drawString [font position text modulate])
 (^{:tag void} drawString [font position text modulate clip_w])
 (^{:tag void} drawStyleBox [style_box rect])
 (^{:tag void} drawTexture [texture position])
 (^{:tag void} drawTexture [texture position modulate])
 (^{:tag void} drawTexture [texture position modulate normal_map])
 (^{:tag void} drawTextureRect [texture rect tile])
 (^{:tag void} drawTextureRect [texture rect tile modulate])
 (^{:tag void} drawTextureRect [texture rect tile modulate transpose])
 (^{:tag void}
  drawTextureRect
  [texture rect tile modulate transpose normal_map])
 (^{:tag void} drawTextureRectRegion [texture rect src_rect])
 (^{:tag void} drawTextureRectRegion [texture rect src_rect modulate])
 (^{:tag void}
  drawTextureRectRegion
  [texture rect src_rect modulate transpose])
 (^{:tag void}
  drawTextureRectRegion
  [texture rect src_rect modulate transpose normal_map])
 (^{:tag void}
  drawTextureRectRegion
  [texture rect src_rect modulate transpose normal_map clip_uv])
 (^{:tag void} forceUpdateTransform [])
 (^{:tag godotclj.bindings.godot.RID} getCanvas [])
 (^{:tag godotclj.bindings.godot.RID} getCanvasItem [])
 (^{:tag godotclj.bindings.godot.Transform2D} getCanvasTransform [])
 (^{:tag godotclj.bindings.godot.Vector2} getGlobalMousePosition [])
 (^{:tag godotclj.bindings.godot.Transform2D} getGlobalTransform [])
 (^{:tag godotclj.bindings.godot.Transform2D}
  getGlobalTransformWithCanvas
  [])
 (^{:tag int} getLightMask [])
 (^{:tag godotclj.bindings.godot.Vector2} getLocalMousePosition [])
 (^{:tag godotclj.api.gdscript.IGodotMaterial} getMaterial [])
 (^{:tag godotclj.bindings.godot.Color} getModulate [])
 (^{:tag godotclj.bindings.godot.Color} getSelfModulate [])
 (^{:tag godotclj.bindings.godot.Transform2D} getTransform [])
 (^{:tag boolean} getUseParentMaterial [])
 (^{:tag godotclj.bindings.godot.IndexedRect2} getViewportRect [])
 (^{:tag godotclj.bindings.godot.Transform2D} getViewportTransform [])
 (^{:tag godotclj.api.gdscript.IGodotWorld2D} getWorld2d [])
 (^{:tag void} hide [])
 (^{:tag boolean} isDrawBehindParentEnabled [])
 (^{:tag boolean} isLocalTransformNotificationEnabled [])
 (^{:tag boolean} isSetAsToplevel [])
 (^{:tag boolean} isTransformNotificationEnabled [])
 (^{:tag boolean} isVisible [])
 (^{:tag boolean} isVisibleInTree [])
 (^{:tag godotclj.bindings.godot.Vector2}
  makeCanvasPositionLocal
  [screen_point])
 (^{:tag godotclj.api.gdscript.IGodotInputEvent}
  makeInputLocal
  [event])
 (^{:tag void} setAsToplevel [enable])
 (^{:tag void} setDrawBehindParent [enable])
 (^{:tag void} setLightMask [light_mask])
 (^{:tag void} setMaterial [material])
 (^{:tag void} setModulate [modulate])
 (^{:tag void} setNotifyLocalTransform [enable])
 (^{:tag void} setNotifyTransform [enable])
 (^{:tag void} setSelfModulate [self_modulate])
 (^{:tag void} setUseParentMaterial [enable])
 (^{:tag void} setVisible [visible])
 (^{:tag void} show [])
 (^{:tag void} update []))
(definterface
 MGodotControl
 (^{:tag void} acceptEvent [])
 (^{:tag void} addColorOverride [name color])
 (^{:tag void} addConstantOverride [name constant])
 (^{:tag void} addFontOverride [name font])
 (^{:tag void} addIconOverride [name texture])
 (^{:tag void} addShaderOverride [name shader])
 (^{:tag void} addStyleboxOverride [name stylebox])
 (^{:tag boolean} canDropData [position data])
 (^{:tag void} dropData [position data])
 (^{:tag godotclj.api.gdscript.IGodotControl} findNextValidFocus [])
 (^{:tag godotclj.api.gdscript.IGodotControl} findPrevValidFocus [])
 (^{:tag void} forceDrag [data preview])
 (^{:tag float} getAnchor [margin])
 (^{:tag godotclj.bindings.godot.Vector2} getBegin [])
 (^{:tag godotclj.bindings.godot.Color} getColor [name])
 (^{:tag godotclj.bindings.godot.Color} getColor [name node_type])
 (^{:tag godotclj.bindings.godot.Vector2} getCombinedMinimumSize [])
 (^{:tag int} getConstant [name])
 (^{:tag int} getConstant [name node_type])
 (^{:tag int} getCursorShape [])
 (^{:tag int} getCursorShape [position])
 (^{:tag godotclj.bindings.godot.Vector2} getCustomMinimumSize [])
 (^{:tag int} getDefaultCursorShape [])
 (^{:tag godotclj.bindings.godot.Variant} getDragData [position])
 (^{:tag godotclj.bindings.godot.Vector2} getEnd [])
 (^{:tag int} getFocusMode [])
 (^{:tag godotclj.bindings.godot.NodePath} getFocusNeighbour [margin])
 (^{:tag godotclj.bindings.godot.NodePath} getFocusNext [])
 (^{:tag godotclj.api.gdscript.IGodotControl} getFocusOwner [])
 (^{:tag godotclj.bindings.godot.NodePath} getFocusPrevious [])
 (^{:tag godotclj.api.gdscript.IGodotFont} getFont [name])
 (^{:tag godotclj.api.gdscript.IGodotFont} getFont [name node_type])
 (^{:tag godotclj.bindings.godot.Vector2} getGlobalPosition [])
 (^{:tag godotclj.bindings.godot.IndexedRect2} getGlobalRect [])
 (^{:tag int} getHGrowDirection [])
 (^{:tag int} getHSizeFlags [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getIcon [name])
 (^{:tag godotclj.api.gdscript.IGodotTexture}
  getIcon
  [name node_type])
 (^{:tag float} getMargin [margin])
 (^{:tag godotclj.bindings.godot.Vector2} getMinimumSize [])
 (^{:tag int} getMouseFilter [])
 (^{:tag godotclj.bindings.godot.Vector2} getParentAreaSize [])
 (^{:tag godotclj.api.gdscript.IGodotControl} getParentControl [])
 (^{:tag boolean} getPassOnModalCloseClick [])
 (^{:tag godotclj.bindings.godot.Vector2} getPivotOffset [])
 (^{:tag godotclj.bindings.godot.Vector2} getPosition [])
 (^{:tag godotclj.bindings.godot.IndexedRect2} getRect [])
 (^{:tag float} getRotation [])
 (^{:tag float} getRotationDegrees [])
 (^{:tag godotclj.bindings.godot.Vector2} getScale [])
 (^{:tag godotclj.bindings.godot.Vector2} getSize [])
 (^{:tag float} getStretchRatio [])
 (^{:tag godotclj.api.gdscript.IGodotStyleBox} getStylebox [name])
 (^{:tag godotclj.api.gdscript.IGodotStyleBox}
  getStylebox
  [name node_type])
 (^{:tag godotclj.api.gdscript.IGodotTheme} getTheme [])
 (^{:tag String} getTooltip [])
 (^{:tag String} getTooltip [at_position])
 (^{:tag int} getVGrowDirection [])
 (^{:tag int} getVSizeFlags [])
 (^{:tag void} grabClickFocus [])
 (^{:tag void} grabFocus [])
 (^{:tag boolean} hasColor [name])
 (^{:tag boolean} hasColor [name node_type])
 (^{:tag boolean} hasColorOverride [name])
 (^{:tag boolean} hasConstant [name])
 (^{:tag boolean} hasConstant [name node_type])
 (^{:tag boolean} hasConstantOverride [name])
 (^{:tag boolean} hasFocus [])
 (^{:tag boolean} hasFont [name])
 (^{:tag boolean} hasFont [name node_type])
 (^{:tag boolean} hasFontOverride [name])
 (^{:tag boolean} hasIcon [name])
 (^{:tag boolean} hasIcon [name node_type])
 (^{:tag boolean} hasIconOverride [name])
 (^{:tag boolean} hasPoint [point])
 (^{:tag boolean} hasShaderOverride [name])
 (^{:tag boolean} hasStylebox [name])
 (^{:tag boolean} hasStylebox [name node_type])
 (^{:tag boolean} hasStyleboxOverride [name])
 (^{:tag boolean} isClippingContents [])
 (^{:tag void} minimumSizeChanged [])
 (^{:tag void} releaseFocus [])
 (^{:tag void} setAnchor [margin anchor])
 (^{:tag void} setAnchor [margin anchor keep_margin])
 (^{:tag void}
  setAnchor
  [margin anchor keep_margin push_opposite_anchor])
 (^{:tag void} setAnchorAndMargin [margin anchor offset])
 (^{:tag void}
  setAnchorAndMargin
  [margin anchor offset push_opposite_anchor])
 (^{:tag void} setAnchorsAndMarginsPreset [preset])
 (^{:tag void} setAnchorsAndMarginsPreset [preset resize_mode])
 (^{:tag void} setAnchorsAndMarginsPreset [preset resize_mode margin])
 (^{:tag void} setAnchorsPreset [preset])
 (^{:tag void} setAnchorsPreset [preset keep_margins])
 (^{:tag void} setBegin [position])
 (^{:tag void} setClipContents [enable])
 (^{:tag void} setCustomMinimumSize [size])
 (^{:tag void} setDefaultCursorShape [shape])
 (^{:tag void} setDragForwarding [target])
 (^{:tag void} setDragPreview [control])
 (^{:tag void} setEnd [position])
 (^{:tag void} setFocusMode [mode])
 (^{:tag void} setFocusNeighbour [margin neighbour])
 (^{:tag void} setFocusNext [next])
 (^{:tag void} setFocusPrevious [previous])
 (^{:tag void} setGlobalPosition [position])
 (^{:tag void} setGlobalPosition [position keep_margins])
 (^{:tag void} setHGrowDirection [direction])
 (^{:tag void} setHSizeFlags [flags])
 (^{:tag void} setMargin [margin offset])
 (^{:tag void} setMarginsPreset [preset])
 (^{:tag void} setMarginsPreset [preset resize_mode])
 (^{:tag void} setMarginsPreset [preset resize_mode margin])
 (^{:tag void} setMouseFilter [filter])
 (^{:tag void} setPassOnModalCloseClick [enabled])
 (^{:tag void} setPivotOffset [pivot_offset])
 (^{:tag void} setPosition [position])
 (^{:tag void} setPosition [position keep_margins])
 (^{:tag void} setRotation [radians])
 (^{:tag void} setRotationDegrees [degrees])
 (^{:tag void} setScale [scale])
 (^{:tag void} setSize [size])
 (^{:tag void} setSize [size keep_margins])
 (^{:tag void} setStretchRatio [ratio])
 (^{:tag void} setTheme [theme])
 (^{:tag void} setTooltip [tooltip])
 (^{:tag void} setVGrowDirection [direction])
 (^{:tag void} setVSizeFlags [flags])
 (^{:tag void} showModal [])
 (^{:tag void} showModal [exclusive])
 (^{:tag void} warpMouse [to_position]))
(definterface
 MGodotPopup
 (^{:tag boolean} isExclusive [])
 (^{:tag void} popup [])
 (^{:tag void} popup [bounds])
 (^{:tag void} popupCentered [])
 (^{:tag void} popupCentered [size])
 (^{:tag void} popupCenteredClamped [])
 (^{:tag void} popupCenteredClamped [size])
 (^{:tag void} popupCenteredClamped [size fallback_ratio])
 (^{:tag void} popupCenteredMinsize [])
 (^{:tag void} popupCenteredMinsize [minsize])
 (^{:tag void} popupCenteredRatio [])
 (^{:tag void} popupCenteredRatio [ratio])
 (^{:tag void} setAsMinsize [])
 (^{:tag void} setExclusive [enable]))
(definterface
 MGodotWindowDialog
 (^{:tag godotclj.api.gdscript.IGodotTextureButton} getCloseButton [])
 (^{:tag boolean} getResizable [])
 (^{:tag String} getTitle [])
 (^{:tag void} setResizable [resizable])
 (^{:tag void} setTitle [title]))
(definterface
 MGodotAcceptDialog
 (^{:tag godotclj.api.gdscript.IGodotButton} addButton [text])
 (^{:tag godotclj.api.gdscript.IGodotButton} addButton [text right])
 (^{:tag godotclj.api.gdscript.IGodotButton}
  addButton
  [text right action])
 (^{:tag godotclj.api.gdscript.IGodotButton} addCancel [name])
 (^{:tag boolean} getHideOnOk [])
 (^{:tag godotclj.api.gdscript.IGodotLabel} getLabel [])
 (^{:tag godotclj.api.gdscript.IGodotButton} getOk [])
 (^{:tag String} getText [])
 (^{:tag boolean} hasAutowrap [])
 (^{:tag void} registerTextEnter [line_edit])
 (^{:tag void} setAutowrap [autowrap])
 (^{:tag void} setHideOnOk [enabled])
 (^{:tag void} setText [text]))
(definterface
 MGodotConfirmationDialog
 (^{:tag godotclj.api.gdscript.IGodotButton} getCancel []))
(definterface
 MGodotTween
 (^{:tag boolean}
  followMethod
  [object method initial_val target target_method duration])
 (^{:tag boolean}
  followMethod
  [object method initial_val target target_method duration trans_type])
 (^{:tag boolean}
  followMethod
  [object
   method
   initial_val
   target
   target_method
   duration
   trans_type
   ease_type])
 (^{:tag boolean}
  followMethod
  [object
   method
   initial_val
   target
   target_method
   duration
   trans_type
   ease_type
   delay])
 (^{:tag boolean}
  followProperty
  [object property initial_val target target_property duration])
 (^{:tag boolean}
  followProperty
  [object
   property
   initial_val
   target
   target_property
   duration
   trans_type])
 (^{:tag boolean}
  followProperty
  [object
   property
   initial_val
   target
   target_property
   duration
   trans_type
   ease_type])
 (^{:tag boolean}
  followProperty
  [object
   property
   initial_val
   target
   target_property
   duration
   trans_type
   ease_type
   delay])
 (^{:tag float} getRuntime [])
 (^{:tag float} getSpeedScale [])
 (^{:tag int} getTweenProcessMode [])
 (^{:tag boolean} interpolateCallback [object duration callback])
 (^{:tag boolean} interpolateCallback [object duration callback arg1])
 (^{:tag boolean}
  interpolateCallback
  [object duration callback arg1 arg2])
 (^{:tag boolean}
  interpolateCallback
  [object duration callback arg1 arg2 arg3])
 (^{:tag boolean}
  interpolateCallback
  [object duration callback arg1 arg2 arg3 arg4])
 (^{:tag boolean}
  interpolateCallback
  [object duration callback arg1 arg2 arg3 arg4 arg5])
 (^{:tag boolean}
  interpolateDeferredCallback
  [object duration callback])
 (^{:tag boolean}
  interpolateDeferredCallback
  [object duration callback arg1])
 (^{:tag boolean}
  interpolateDeferredCallback
  [object duration callback arg1 arg2])
 (^{:tag boolean}
  interpolateDeferredCallback
  [object duration callback arg1 arg2 arg3])
 (^{:tag boolean}
  interpolateDeferredCallback
  [object duration callback arg1 arg2 arg3 arg4])
 (^{:tag boolean}
  interpolateDeferredCallback
  [object duration callback arg1 arg2 arg3 arg4 arg5])
 (^{:tag boolean}
  interpolateMethod
  [object method initial_val final_val duration])
 (^{:tag boolean}
  interpolateMethod
  [object method initial_val final_val duration trans_type])
 (^{:tag boolean}
  interpolateMethod
  [object method initial_val final_val duration trans_type ease_type])
 (^{:tag boolean}
  interpolateMethod
  [object
   method
   initial_val
   final_val
   duration
   trans_type
   ease_type
   delay])
 (^{:tag boolean}
  interpolateProperty
  [object property initial_val final_val duration])
 (^{:tag boolean}
  interpolateProperty
  [object property initial_val final_val duration trans_type])
 (^{:tag boolean}
  interpolateProperty
  [object
   property
   initial_val
   final_val
   duration
   trans_type
   ease_type])
 (^{:tag boolean}
  interpolateProperty
  [object
   property
   initial_val
   final_val
   duration
   trans_type
   ease_type
   delay])
 (^{:tag boolean} isActive [])
 (^{:tag boolean} isRepeat [])
 (^{:tag boolean} remove [object])
 (^{:tag boolean} remove [object key])
 (^{:tag boolean} removeAll [])
 (^{:tag boolean} reset [object])
 (^{:tag boolean} reset [object key])
 (^{:tag boolean} resetAll [])
 (^{:tag boolean} resume [object])
 (^{:tag boolean} resume [object key])
 (^{:tag boolean} resumeAll [])
 (^{:tag boolean} seek [time])
 (^{:tag void} setActive [active])
 (^{:tag void} setRepeat [repeat])
 (^{:tag void} setSpeedScale [speed])
 (^{:tag void} setTweenProcessMode [mode])
 (^{:tag boolean} start [])
 (^{:tag boolean} stop [object])
 (^{:tag boolean} stop [object key])
 (^{:tag boolean} stopAll [])
 (^{:tag boolean}
  targetingMethod
  [object method initial initial_method final_val duration])
 (^{:tag boolean}
  targetingMethod
  [object method initial initial_method final_val duration trans_type])
 (^{:tag boolean}
  targetingMethod
  [object
   method
   initial
   initial_method
   final_val
   duration
   trans_type
   ease_type])
 (^{:tag boolean}
  targetingMethod
  [object
   method
   initial
   initial_method
   final_val
   duration
   trans_type
   ease_type
   delay])
 (^{:tag boolean}
  targetingProperty
  [object property initial initial_val final_val duration])
 (^{:tag boolean}
  targetingProperty
  [object property initial initial_val final_val duration trans_type])
 (^{:tag boolean}
  targetingProperty
  [object
   property
   initial
   initial_val
   final_val
   duration
   trans_type
   ease_type])
 (^{:tag boolean}
  targetingProperty
  [object
   property
   initial
   initial_val
   final_val
   duration
   trans_type
   ease_type
   delay])
 (^{:tag float} tell []))
(definterface
 MGodotXMLParser
 (^{:tag int} getAttributeCount [])
 (^{:tag String} getAttributeName [idx])
 (^{:tag String} getAttributeValue [idx])
 (^{:tag int} getCurrentLine [])
 (^{:tag String} getNamedAttributeValue [name])
 (^{:tag String} getNamedAttributeValueSafe [name])
 (^{:tag String} getNodeData [])
 (^{:tag String} getNodeName [])
 (^{:tag int} getNodeOffset [])
 (^{:tag int} getNodeType [])
 (^{:tag boolean} hasAttribute [name])
 (^{:tag boolean} isEmpty [])
 (^{:tag int} open [file])
 (^{:tag int} openBuffer [buffer])
 (^{:tag int} read [])
 (^{:tag int} seek [position])
 (^{:tag void} skipSection []))
(definterface
 MGodotSpatial
 (^{:tag void} forceUpdateTransform [])
 (^{:tag godotclj.api.gdscript.IGodotSpatialGizmo} getGizmo [])
 (^{:tag godotclj.bindings.godot.Transform} getGlobalTransform [])
 (^{:tag godotclj.api.gdscript.IGodotSpatial} getParentSpatial [])
 (^{:tag godotclj.bindings.godot.Vector3} getRotation [])
 (^{:tag godotclj.bindings.godot.Vector3} getRotationDegrees [])
 (^{:tag godotclj.bindings.godot.Vector3} getScale [])
 (^{:tag godotclj.bindings.godot.Transform} getTransform [])
 (^{:tag godotclj.bindings.godot.Vector3} getTranslation [])
 (^{:tag godotclj.api.gdscript.IGodotWorld} getWorld [])
 (^{:tag void} globalRotate [axis angle])
 (^{:tag void} globalScale [scale])
 (^{:tag void} globalTranslate [offset])
 (^{:tag void} hide [])
 (^{:tag boolean} isLocalTransformNotificationEnabled [])
 (^{:tag boolean} isScaleDisabled [])
 (^{:tag boolean} isSetAsToplevel [])
 (^{:tag boolean} isTransformNotificationEnabled [])
 (^{:tag boolean} isVisible [])
 (^{:tag boolean} isVisibleInTree [])
 (^{:tag void} lookAt [target up])
 (^{:tag void} lookAtFromPosition [position target up])
 (^{:tag void} orthonormalize [])
 (^{:tag void} rotate [axis angle])
 (^{:tag void} rotateObjectLocal [axis angle])
 (^{:tag void} rotateX [angle])
 (^{:tag void} rotateY [angle])
 (^{:tag void} rotateZ [angle])
 (^{:tag void} scaleObjectLocal [scale])
 (^{:tag void} setAsToplevel [enable])
 (^{:tag void} setDisableScale [disable])
 (^{:tag void} setGizmo [gizmo])
 (^{:tag void} setGlobalTransform [global])
 (^{:tag void} setIdentity [])
 (^{:tag void} setIgnoreTransformNotification [enabled])
 (^{:tag void} setNotifyLocalTransform [enable])
 (^{:tag void} setNotifyTransform [enable])
 (^{:tag void} setRotation [euler])
 (^{:tag void} setRotationDegrees [euler_degrees])
 (^{:tag void} setScale [scale])
 (^{:tag void} setTransform [local])
 (^{:tag void} setTranslation [translation])
 (^{:tag void} setVisible [visible])
 (^{:tag void} show [])
 (^{:tag godotclj.bindings.godot.Vector3} toGlobal [local_point])
 (^{:tag godotclj.bindings.godot.Vector3} toLocal [global_point])
 (^{:tag void} translate [offset])
 (^{:tag void} translateObjectLocal [offset])
 (^{:tag void} updateGizmo []))
(definterface
 MGodotSkeleton
 (^{:tag void} addBone [name])
 (^{:tag void} bindChildNodeToBone [bone_idx node])
 (^{:tag void} clearBones [])
 (^{:tag void} clearBonesGlobalPoseOverride [])
 (^{:tag int} findBone [name])
 (^{:tag int} getBoneCount [])
 (^{:tag godotclj.bindings.godot.Transform}
  getBoneCustomPose
  [bone_idx])
 (^{:tag godotclj.bindings.godot.Transform}
  getBoneGlobalPose
  [bone_idx])
 (^{:tag godotclj.bindings.godot.Transform}
  getBoneGlobalPoseNoOverride
  [bone_idx])
 (^{:tag String} getBoneName [bone_idx])
 (^{:tag int} getBoneParent [bone_idx])
 (^{:tag godotclj.bindings.godot.Transform} getBonePose [bone_idx])
 (^{:tag godotclj.bindings.godot.Transform} getBoneRest [bone_idx])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  getBoundChildNodesToBone
  [bone_idx])
 (^{:tag boolean} isBoneRestDisabled [bone_idx])
 (^{:tag void} localizeRests [])
 (^{:tag void} physicalBonesAddCollisionException [exception])
 (^{:tag void} physicalBonesRemoveCollisionException [exception])
 (^{:tag void} physicalBonesStartSimulation [])
 (^{:tag void} physicalBonesStartSimulation [bones])
 (^{:tag void} physicalBonesStopSimulation [])
 (^{:tag godotclj.api.gdscript.IGodotSkinReference}
  registerSkin
  [skin])
 (^{:tag void} setBoneCustomPose [bone_idx custom_pose])
 (^{:tag void} setBoneDisableRest [bone_idx disable])
 (^{:tag void} setBoneGlobalPoseOverride [bone_idx pose amount])
 (^{:tag void}
  setBoneGlobalPoseOverride
  [bone_idx pose amount persistent])
 (^{:tag void} setBoneParent [bone_idx parent_idx])
 (^{:tag void} setBonePose [bone_idx pose])
 (^{:tag void} setBoneRest [bone_idx rest])
 (^{:tag void} unbindChildNodeFromBone [bone_idx node])
 (^{:tag void} unparentBoneAndRest [bone_idx]))
(definterface
 MGodotInputEvent
 (^{:tag boolean} accumulate [with_event])
 (^{:tag String} asText [])
 (^{:tag float} getActionStrength [action])
 (^{:tag int} getDevice [])
 (^{:tag boolean} isAction [action])
 (^{:tag boolean} isActionPressed [action])
 (^{:tag boolean} isActionPressed [action allow_echo])
 (^{:tag boolean} isActionReleased [action])
 (^{:tag boolean} isActionType [])
 (^{:tag boolean} isEcho [])
 (^{:tag boolean} isPressed [])
 (^{:tag void} setDevice [device])
 (^{:tag boolean} shortcutMatch [event])
 (^{:tag godotclj.api.gdscript.IGodotInputEvent} xformedBy [xform])
 (^{:tag godotclj.api.gdscript.IGodotInputEvent}
  xformedBy
  [xform local_ofs]))
(definterface
 MGodotInputEventJoypadButton
 (^{:tag int} getButtonIndex [])
 (^{:tag float} getPressure [])
 (^{:tag void} setButtonIndex [button_index])
 (^{:tag void} setPressed [pressed])
 (^{:tag void} setPressure [pressure]))
(definterface
 MGodotPopupMenu
 (^{:tag void} addCheckItem [label])
 (^{:tag void} addCheckItem [label id])
 (^{:tag void} addCheckItem [label id accel])
 (^{:tag void} addCheckShortcut [shortcut])
 (^{:tag void} addCheckShortcut [shortcut id])
 (^{:tag void} addCheckShortcut [shortcut id global])
 (^{:tag void} addIconCheckItem [texture label])
 (^{:tag void} addIconCheckItem [texture label id])
 (^{:tag void} addIconCheckItem [texture label id accel])
 (^{:tag void} addIconCheckShortcut [texture shortcut])
 (^{:tag void} addIconCheckShortcut [texture shortcut id])
 (^{:tag void} addIconCheckShortcut [texture shortcut id global])
 (^{:tag void} addIconItem [texture label])
 (^{:tag void} addIconItem [texture label id])
 (^{:tag void} addIconItem [texture label id accel])
 (^{:tag void} addIconRadioCheckItem [texture label])
 (^{:tag void} addIconRadioCheckItem [texture label id])
 (^{:tag void} addIconRadioCheckItem [texture label id accel])
 (^{:tag void} addIconRadioCheckShortcut [texture shortcut])
 (^{:tag void} addIconRadioCheckShortcut [texture shortcut id])
 (^{:tag void} addIconRadioCheckShortcut [texture shortcut id global])
 (^{:tag void} addIconShortcut [texture shortcut])
 (^{:tag void} addIconShortcut [texture shortcut id])
 (^{:tag void} addIconShortcut [texture shortcut id global])
 (^{:tag void} addItem [label])
 (^{:tag void} addItem [label id])
 (^{:tag void} addItem [label id accel])
 (^{:tag void} addMultistateItem [label max_states])
 (^{:tag void} addMultistateItem [label max_states default_state])
 (^{:tag void} addMultistateItem [label max_states default_state id])
 (^{:tag void}
  addMultistateItem
  [label max_states default_state id accel])
 (^{:tag void} addRadioCheckItem [label])
 (^{:tag void} addRadioCheckItem [label id])
 (^{:tag void} addRadioCheckItem [label id accel])
 (^{:tag void} addRadioCheckShortcut [shortcut])
 (^{:tag void} addRadioCheckShortcut [shortcut id])
 (^{:tag void} addRadioCheckShortcut [shortcut id global])
 (^{:tag void} addSeparator [])
 (^{:tag void} addSeparator [label])
 (^{:tag void} addSeparator [label id])
 (^{:tag void} addShortcut [shortcut])
 (^{:tag void} addShortcut [shortcut id])
 (^{:tag void} addShortcut [shortcut id global])
 (^{:tag void} addSubmenuItem [label submenu])
 (^{:tag void} addSubmenuItem [label submenu id])
 (^{:tag void} clear [])
 (^{:tag boolean} getAllowSearch [])
 (^{:tag int} getCurrentIndex [])
 (^{:tag int} getItemAccelerator [idx])
 (^{:tag int} getItemCount [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getItemIcon [idx])
 (^{:tag int} getItemId [idx])
 (^{:tag int} getItemIndex [id])
 (^{:tag godotclj.bindings.godot.Variant} getItemMetadata [idx])
 (^{:tag godotclj.api.gdscript.IGodotShortCut} getItemShortcut [idx])
 (^{:tag String} getItemSubmenu [idx])
 (^{:tag String} getItemText [idx])
 (^{:tag String} getItemTooltip [idx])
 (^{:tag float} getSubmenuPopupDelay [])
 (^{:tag boolean} isHideOnCheckableItemSelection [])
 (^{:tag boolean} isHideOnItemSelection [])
 (^{:tag boolean} isHideOnStateItemSelection [])
 (^{:tag boolean} isHideOnWindowLoseFocus [])
 (^{:tag boolean} isItemCheckable [idx])
 (^{:tag boolean} isItemChecked [idx])
 (^{:tag boolean} isItemDisabled [idx])
 (^{:tag boolean} isItemRadioCheckable [idx])
 (^{:tag boolean} isItemSeparator [idx])
 (^{:tag boolean} isItemShortcutDisabled [idx])
 (^{:tag void} removeItem [idx])
 (^{:tag void} setAllowSearch [allow])
 (^{:tag void} setHideOnCheckableItemSelection [enable])
 (^{:tag void} setHideOnItemSelection [enable])
 (^{:tag void} setHideOnStateItemSelection [enable])
 (^{:tag void} setHideOnWindowLoseFocus [enable])
 (^{:tag void} setItemAccelerator [idx accel])
 (^{:tag void} setItemAsCheckable [idx enable])
 (^{:tag void} setItemAsRadioCheckable [idx enable])
 (^{:tag void} setItemAsSeparator [idx enable])
 (^{:tag void} setItemChecked [idx checked])
 (^{:tag void} setItemDisabled [idx disabled])
 (^{:tag void} setItemIcon [idx icon])
 (^{:tag void} setItemId [idx id])
 (^{:tag void} setItemMetadata [idx metadata])
 (^{:tag void} setItemMultistate [idx state])
 (^{:tag void} setItemShortcut [idx shortcut])
 (^{:tag void} setItemShortcut [idx shortcut global])
 (^{:tag void} setItemShortcutDisabled [idx disabled])
 (^{:tag void} setItemSubmenu [idx submenu])
 (^{:tag void} setItemText [idx text])
 (^{:tag void} setItemTooltip [idx tooltip])
 (^{:tag void} setSubmenuPopupDelay [seconds])
 (^{:tag void} toggleItemChecked [idx])
 (^{:tag void} toggleItemMultistate [idx]))
(definterface
 MGodotConfigFile
 (^{:tag void} clear [])
 (^{:tag void} eraseSection [section])
 (^{:tag void} eraseSectionKey [section key])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  getSectionKeys
  [section])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  getSections
  [])
 (^{:tag godotclj.bindings.godot.Variant} getValue [section key])
 (^{:tag godotclj.bindings.godot.Variant}
  getValue
  [section key default])
 (^{:tag boolean} hasSection [section])
 (^{:tag boolean} hasSectionKey [section key])
 (^{:tag int} load [path])
 (^{:tag int} loadEncrypted [path key])
 (^{:tag int} loadEncryptedPass [path password])
 (^{:tag int} parse [data])
 (^{:tag int} save [path])
 (^{:tag int} saveEncrypted [path key])
 (^{:tag int} saveEncryptedPass [path password])
 (^{:tag void} setValue [section key value]))
(definterface MGodotVisualShaderNodeTransformDecompose)
(definterface
 MGodotContainer
 (^{:tag void} fitChildInRect [child rect])
 (^{:tag void} queueSort []))
(definterface
 MGodotBoxContainer
 (^{:tag void} addSpacer [begin])
 (^{:tag int} getAlignment [])
 (^{:tag void} setAlignment [alignment]))
(definterface MGodotHBoxContainer)
(definterface
 MGodotNode2D
 (^{:tag void} applyScale [ratio])
 (^{:tag float} getAngleTo [point])
 (^{:tag godotclj.bindings.godot.Vector2} getGlobalPosition [])
 (^{:tag float} getGlobalRotation [])
 (^{:tag float} getGlobalRotationDegrees [])
 (^{:tag godotclj.bindings.godot.Vector2} getGlobalScale [])
 (^{:tag godotclj.bindings.godot.Vector2} getPosition [])
 (^{:tag godotclj.bindings.godot.Transform2D}
  getRelativeTransformToParent
  [parent])
 (^{:tag float} getRotation [])
 (^{:tag float} getRotationDegrees [])
 (^{:tag godotclj.bindings.godot.Vector2} getScale [])
 (^{:tag int} getZIndex [])
 (^{:tag void} globalTranslate [offset])
 (^{:tag boolean} isZRelative [])
 (^{:tag void} lookAt [point])
 (^{:tag void} moveLocalX [delta])
 (^{:tag void} moveLocalX [delta scaled])
 (^{:tag void} moveLocalY [delta])
 (^{:tag void} moveLocalY [delta scaled])
 (^{:tag void} rotate [radians])
 (^{:tag void} setGlobalPosition [position])
 (^{:tag void} setGlobalRotation [radians])
 (^{:tag void} setGlobalRotationDegrees [degrees])
 (^{:tag void} setGlobalScale [scale])
 (^{:tag void} setGlobalTransform [xform])
 (^{:tag void} setPosition [position])
 (^{:tag void} setRotation [radians])
 (^{:tag void} setRotationDegrees [degrees])
 (^{:tag void} setScale [scale])
 (^{:tag void} setTransform [xform])
 (^{:tag void} setZAsRelative [enable])
 (^{:tag void} setZIndex [z_index])
 (^{:tag godotclj.bindings.godot.Vector2} toGlobal [local_point])
 (^{:tag godotclj.bindings.godot.Vector2} toLocal [global_point])
 (^{:tag void} translate [offset]))
(definterface
 MGodotMultiMeshInstance2D
 (^{:tag godotclj.api.gdscript.IGodotMultiMesh} getMultimesh [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getNormalMap [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getTexture [])
 (^{:tag void} setMultimesh [multimesh])
 (^{:tag void} setNormalMap [normal_map])
 (^{:tag void} setTexture [texture]))
(definterface
 MGodotUDPServer
 (^{:tag int} getMaxPendingConnections [])
 (^{:tag boolean} isConnectionAvailable [])
 (^{:tag boolean} isListening [])
 (^{:tag int} listen [port])
 (^{:tag int} listen [port bind_address])
 (^{:tag int} poll [])
 (^{:tag void} setMaxPendingConnections [max_pending_connections])
 (^{:tag void} stop [])
 (^{:tag godotclj.api.gdscript.IGodotPacketPeerUDP} takeConnection []))
(definterface
 MGodotVisibilityNotifier
 (^{:tag godotclj.bindings.godot.AABB} getAabb [])
 (^{:tag boolean} isOnScreen [])
 (^{:tag void} setAabb [rect]))
(definterface
 MGodotCurve3D
 (^{:tag void} addPoint [position])
 (^{:tag void} addPoint [position in])
 (^{:tag void} addPoint [position in out])
 (^{:tag void} addPoint [position in out at_position])
 (^{:tag void} clearPoints [])
 (^{:tag float} getBakeInterval [])
 (^{:tag float} getBakedLength [])
 (^{:tag godotclj.bindings.godot.PoolVector3Array} getBakedPoints [])
 (^{:tag godotclj.bindings.godot.PoolRealArray} getBakedTilts [])
 (^{:tag godotclj.bindings.godot.PoolVector3Array}
  getBakedUpVectors
  [])
 (^{:tag float} getClosestOffset [to_point])
 (^{:tag godotclj.bindings.godot.Vector3} getClosestPoint [to_point])
 (^{:tag int} getPointCount [])
 (^{:tag godotclj.bindings.godot.Vector3} getPointIn [idx])
 (^{:tag godotclj.bindings.godot.Vector3} getPointOut [idx])
 (^{:tag godotclj.bindings.godot.Vector3} getPointPosition [idx])
 (^{:tag float} getPointTilt [idx])
 (^{:tag godotclj.bindings.godot.Vector3} interpolate [idx t])
 (^{:tag godotclj.bindings.godot.Vector3} interpolateBaked [offset])
 (^{:tag godotclj.bindings.godot.Vector3}
  interpolateBaked
  [offset cubic])
 (^{:tag godotclj.bindings.godot.Vector3}
  interpolateBakedUpVector
  [offset])
 (^{:tag godotclj.bindings.godot.Vector3}
  interpolateBakedUpVector
  [offset apply_tilt])
 (^{:tag godotclj.bindings.godot.Vector3} interpolatef [fofs])
 (^{:tag boolean} isUpVectorEnabled [])
 (^{:tag void} removePoint [idx])
 (^{:tag void} setBakeInterval [distance])
 (^{:tag void} setPointIn [idx position])
 (^{:tag void} setPointOut [idx position])
 (^{:tag void} setPointPosition [idx position])
 (^{:tag void} setPointTilt [idx tilt])
 (^{:tag void} setUpVectorEnabled [enable])
 (^{:tag godotclj.bindings.godot.PoolVector3Array} tessellate [])
 (^{:tag godotclj.bindings.godot.PoolVector3Array}
  tessellate
  [max_stages])
 (^{:tag godotclj.bindings.godot.PoolVector3Array}
  tessellate
  [max_stages tolerance_degrees]))
(definterface
 MGodotCPUParticles2D
 (^{:tag void} convertFromParticles [particles])
 (^{:tag int} getAmount [])
 (^{:tag godotclj.bindings.godot.Color} getColor [])
 (^{:tag godotclj.api.gdscript.IGodotGradient} getColorRamp [])
 (^{:tag godotclj.bindings.godot.Vector2} getDirection [])
 (^{:tag int} getDrawOrder [])
 (^{:tag godotclj.bindings.godot.PoolColorArray} getEmissionColors [])
 (^{:tag godotclj.bindings.godot.IndexedPoolVector2Array}
  getEmissionNormals
  [])
 (^{:tag godotclj.bindings.godot.IndexedPoolVector2Array}
  getEmissionPoints
  [])
 (^{:tag godotclj.bindings.godot.Vector2} getEmissionRectExtents [])
 (^{:tag int} getEmissionShape [])
 (^{:tag float} getEmissionSphereRadius [])
 (^{:tag float} getExplosivenessRatio [])
 (^{:tag int} getFixedFps [])
 (^{:tag boolean} getFractionalDelta [])
 (^{:tag godotclj.bindings.godot.Vector2} getGravity [])
 (^{:tag float} getLifetime [])
 (^{:tag float} getLifetimeRandomness [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getNormalmap [])
 (^{:tag boolean} getOneShot [])
 (^{:tag float} getParam [param])
 (^{:tag godotclj.api.gdscript.IGodotCurve} getParamCurve [param])
 (^{:tag float} getParamRandomness [param])
 (^{:tag boolean} getParticleFlag [flag])
 (^{:tag float} getPreProcessTime [])
 (^{:tag float} getRandomnessRatio [])
 (^{:tag float} getSpeedScale [])
 (^{:tag float} getSpread [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getTexture [])
 (^{:tag boolean} getUseLocalCoordinates [])
 (^{:tag boolean} isEmitting [])
 (^{:tag void} restart [])
 (^{:tag void} setAmount [amount])
 (^{:tag void} setColor [color])
 (^{:tag void} setColorRamp [ramp])
 (^{:tag void} setDirection [direction])
 (^{:tag void} setDrawOrder [order])
 (^{:tag void} setEmissionColors [array])
 (^{:tag void} setEmissionNormals [array])
 (^{:tag void} setEmissionPoints [array])
 (^{:tag void} setEmissionRectExtents [extents])
 (^{:tag void} setEmissionShape [shape])
 (^{:tag void} setEmissionSphereRadius [radius])
 (^{:tag void} setEmitting [emitting])
 (^{:tag void} setExplosivenessRatio [ratio])
 (^{:tag void} setFixedFps [fps])
 (^{:tag void} setFractionalDelta [enable])
 (^{:tag void} setGravity [accel_vec])
 (^{:tag void} setLifetime [secs])
 (^{:tag void} setLifetimeRandomness [random])
 (^{:tag void} setNormalmap [normalmap])
 (^{:tag void} setOneShot [enable])
 (^{:tag void} setParam [param value])
 (^{:tag void} setParamCurve [param curve])
 (^{:tag void} setParamRandomness [param randomness])
 (^{:tag void} setParticleFlag [flag enable])
 (^{:tag void} setPreProcessTime [secs])
 (^{:tag void} setRandomnessRatio [ratio])
 (^{:tag void} setSpeedScale [scale])
 (^{:tag void} setSpread [degrees])
 (^{:tag void} setTexture [texture])
 (^{:tag void} setUseLocalCoordinates [enable]))
(definterface
 MGodotVisualInstance
 (^{:tag godotclj.bindings.godot.AABB} getAabb [])
 (^{:tag godotclj.bindings.godot.RID} getBase [])
 (^{:tag godotclj.bindings.godot.RID} getInstance [])
 (^{:tag int} getLayerMask [])
 (^{:tag boolean} getLayerMaskBit [layer])
 (^{:tag godotclj.bindings.godot.AABB} getTransformedAabb [])
 (^{:tag void} setBase [base])
 (^{:tag void} setLayerMask [mask])
 (^{:tag void} setLayerMaskBit [layer enabled]))
(definterface MGodotRootMotionView)
(definterface
 MGodotVisualScriptNode
 (^{:tag godotclj.bindings.godot.Variant}
  getDefaultInputValue
  [port_idx])
 (^{:tag godotclj.api.gdscript.IGodotVisualScript} getVisualScript [])
 (^{:tag void} portsChangedNotify [])
 (^{:tag void} setDefaultInputValue [port_idx value]))
(definterface
 MGodotVisualScriptVariableGet
 (^{:tag String} getVariable [])
 (^{:tag void} setVariable [name]))
(definterface
 MGodotMesh
 (^{:tag godotclj.api.gdscript.IGodotShape} createConvexShape [])
 (^{:tag godotclj.api.gdscript.IGodotMesh} createOutline [margin])
 (^{:tag godotclj.api.gdscript.IGodotShape} createTrimeshShape [])
 (^{:tag godotclj.api.gdscript.IGodotTriangleMesh}
  generateTriangleMesh
  [])
 (^{:tag godotclj.bindings.godot.AABB} getAabb [])
 (^{:tag godotclj.bindings.godot.PoolVector3Array} getFaces [])
 (^{:tag godotclj.bindings.godot.Vector2} getLightmapSizeHint [])
 (^{:tag int} getSurfaceCount [])
 (^{:tag void} setLightmapSizeHint [size])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  surfaceGetArrays
  [surf_idx])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  surfaceGetBlendShapeArrays
  [surf_idx])
 (^{:tag godotclj.api.gdscript.IGodotMaterial}
  surfaceGetMaterial
  [surf_idx])
 (^{:tag void} surfaceSetMaterial [surf_idx material]))
(definterface
 MGodotPrimitiveMesh
 (^{:tag godotclj.bindings.godot.AABB} getCustomAabb [])
 (^{:tag boolean} getFlipFaces [])
 (^{:tag godotclj.api.gdscript.IGodotMaterial} getMaterial [])
 (^{:tag godotclj.bindings.godot.IndexedArray} getMeshArrays [])
 (^{:tag void} setCustomAabb [aabb])
 (^{:tag void} setFlipFaces [flip_faces])
 (^{:tag void} setMaterial [material]))
(definterface
 MGodotCapsuleMesh
 (^{:tag float} getMidHeight [])
 (^{:tag int} getRadialSegments [])
 (^{:tag float} getRadius [])
 (^{:tag int} getRings [])
 (^{:tag void} setMidHeight [mid_height])
 (^{:tag void} setRadialSegments [segments])
 (^{:tag void} setRadius [radius])
 (^{:tag void} setRings [rings]))
(definterface
 MGodotARVRPositionalTracker
 (^{:tag int} getHand [])
 (^{:tag int} getJoyId [])
 (^{:tag godotclj.api.gdscript.IGodotMesh} getMesh [])
 (^{:tag String} getName [])
 (^{:tag godotclj.bindings.godot.Basis} getOrientation [])
 (^{:tag godotclj.bindings.godot.Vector3} getPosition [])
 (^{:tag float} getRumble [])
 (^{:tag int} getTrackerId [])
 (^{:tag boolean} getTracksOrientation [])
 (^{:tag boolean} getTracksPosition [])
 (^{:tag godotclj.bindings.godot.Transform}
  getTransform
  [adjust_by_reference_frame])
 (^{:tag int} getType [])
 (^{:tag void} setRumble [rumble]))
(definterface
 MGodotShape
 (^{:tag godotclj.api.gdscript.IGodotArrayMesh} getDebugMesh [])
 (^{:tag float} getMargin [])
 (^{:tag void} setMargin [margin]))
(definterface
 MGodotConvexPolygonShape
 (^{:tag godotclj.bindings.godot.PoolVector3Array} getPoints [])
 (^{:tag void} setPoints [points]))
(definterface
 MGodotInputEventWithModifiers
 (^{:tag boolean} getAlt [])
 (^{:tag boolean} getCommand [])
 (^{:tag boolean} getControl [])
 (^{:tag boolean} getMetakey [])
 (^{:tag boolean} getShift [])
 (^{:tag void} setAlt [enable])
 (^{:tag void} setCommand [enable])
 (^{:tag void} setControl [enable])
 (^{:tag void} setMetakey [enable])
 (^{:tag void} setShift [enable]))
(definterface
 MGodotInputEventGesture
 (^{:tag godotclj.bindings.godot.Vector2} getPosition [])
 (^{:tag void} setPosition [position]))
(definterface
 MGodotVisualScriptConstant
 (^{:tag int} getConstantType [])
 (^{:tag godotclj.bindings.godot.Variant} getConstantValue [])
 (^{:tag void} setConstantType [type])
 (^{:tag void} setConstantValue [value]))
(definterface
 MGodot_Semaphore
 (^{:tag int} post [])
 (^{:tag int} wait []))
(definterface
 MGodotLight
 (^{:tag int} getBakeMode [])
 (^{:tag godotclj.bindings.godot.Color} getColor [])
 (^{:tag int} getCullMask [])
 (^{:tag float} getParam [param])
 (^{:tag godotclj.bindings.godot.Color} getShadowColor [])
 (^{:tag boolean} getShadowReverseCullFace [])
 (^{:tag boolean} hasShadow [])
 (^{:tag boolean} isEditorOnly [])
 (^{:tag boolean} isNegative [])
 (^{:tag void} setBakeMode [bake_mode])
 (^{:tag void} setColor [color])
 (^{:tag void} setCullMask [cull_mask])
 (^{:tag void} setEditorOnly [editor_only])
 (^{:tag void} setNegative [enabled])
 (^{:tag void} setParam [param value])
 (^{:tag void} setShadow [enabled])
 (^{:tag void} setShadowColor [shadow_color])
 (^{:tag void} setShadowReverseCullFace [enable]))
(definterface
 MGodotOmniLight
 (^{:tag int} getShadowDetail [])
 (^{:tag int} getShadowMode [])
 (^{:tag void} setShadowDetail [detail])
 (^{:tag void} setShadowMode [mode]))
(definterface
 MGodotAnimation
 (^{:tag int} addTrack [type])
 (^{:tag int} addTrack [type at_position])
 (^{:tag String} animationTrackGetKeyAnimation [track_idx key_idx])
 (^{:tag int} animationTrackInsertKey [track_idx time animation])
 (^{:tag void}
  animationTrackSetKeyAnimation
  [track_idx key_idx animation])
 (^{:tag float} audioTrackGetKeyEndOffset [track_idx key_idx])
 (^{:tag float} audioTrackGetKeyStartOffset [track_idx key_idx])
 (^{:tag godotclj.api.gdscript.IGodotResource}
  audioTrackGetKeyStream
  [track_idx key_idx])
 (^{:tag int} audioTrackInsertKey [track_idx time stream])
 (^{:tag int}
  audioTrackInsertKey
  [track_idx time stream start_offset])
 (^{:tag int}
  audioTrackInsertKey
  [track_idx time stream start_offset end_offset])
 (^{:tag void} audioTrackSetKeyEndOffset [track_idx key_idx offset])
 (^{:tag void} audioTrackSetKeyStartOffset [track_idx key_idx offset])
 (^{:tag void} audioTrackSetKeyStream [track_idx key_idx stream])
 (^{:tag godotclj.bindings.godot.Vector2}
  bezierTrackGetKeyInHandle
  [track_idx key_idx])
 (^{:tag godotclj.bindings.godot.Vector2}
  bezierTrackGetKeyOutHandle
  [track_idx key_idx])
 (^{:tag float} bezierTrackGetKeyValue [track_idx key_idx])
 (^{:tag int} bezierTrackInsertKey [track_idx time value])
 (^{:tag int} bezierTrackInsertKey [track_idx time value in_handle])
 (^{:tag int}
  bezierTrackInsertKey
  [track_idx time value in_handle out_handle])
 (^{:tag float} bezierTrackInterpolate [track_idx time])
 (^{:tag void}
  bezierTrackSetKeyInHandle
  [track_idx key_idx in_handle])
 (^{:tag void}
  bezierTrackSetKeyOutHandle
  [track_idx key_idx out_handle])
 (^{:tag void} bezierTrackSetKeyValue [track_idx key_idx value])
 (^{:tag void} clear [])
 (^{:tag void} copyTrack [track_idx to_animation])
 (^{:tag int} findTrack [path])
 (^{:tag float} getLength [])
 (^{:tag float} getStep [])
 (^{:tag int} getTrackCount [])
 (^{:tag boolean} hasLoop [])
 (^{:tag godotclj.bindings.godot.PoolIntArray}
  methodTrackGetKeyIndices
  [track_idx time_sec delta])
 (^{:tag String} methodTrackGetName [track_idx key_idx])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  methodTrackGetParams
  [track_idx key_idx])
 (^{:tag void} removeTrack [track_idx])
 (^{:tag void} setLength [time_sec])
 (^{:tag void} setLoop [enabled])
 (^{:tag void} setStep [size_sec])
 (^{:tag int} trackFindKey [track_idx time])
 (^{:tag int} trackFindKey [track_idx time exact])
 (^{:tag boolean} trackGetInterpolationLoopWrap [track_idx])
 (^{:tag int} trackGetInterpolationType [track_idx])
 (^{:tag int} trackGetKeyCount [track_idx])
 (^{:tag float} trackGetKeyTime [track_idx key_idx])
 (^{:tag float} trackGetKeyTransition [track_idx key_idx])
 (^{:tag godotclj.bindings.godot.Variant}
  trackGetKeyValue
  [track_idx key_idx])
 (^{:tag godotclj.bindings.godot.NodePath} trackGetPath [track_idx])
 (^{:tag int} trackGetType [track_idx])
 (^{:tag void} trackInsertKey [track_idx time key])
 (^{:tag void} trackInsertKey [track_idx time key transition])
 (^{:tag boolean} trackIsEnabled [track_idx])
 (^{:tag boolean} trackIsImported [track_idx])
 (^{:tag void} trackMoveDown [track_idx])
 (^{:tag void} trackMoveTo [track_idx to_idx])
 (^{:tag void} trackMoveUp [track_idx])
 (^{:tag void} trackRemoveKey [track_idx key_idx])
 (^{:tag void} trackRemoveKeyAtPosition [track_idx position])
 (^{:tag void} trackSetEnabled [track_idx enabled])
 (^{:tag void} trackSetImported [track_idx imported])
 (^{:tag void}
  trackSetInterpolationLoopWrap
  [track_idx interpolation])
 (^{:tag void} trackSetInterpolationType [track_idx interpolation])
 (^{:tag void} trackSetKeyTime [track_idx key_idx time])
 (^{:tag void} trackSetKeyTransition [track_idx key_idx transition])
 (^{:tag void} trackSetKeyValue [track_idx key value])
 (^{:tag void} trackSetPath [track_idx path])
 (^{:tag void} trackSwap [track_idx with_idx])
 (^{:tag int}
  transformTrackInsertKey
  [track_idx time location rotation scale])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  transformTrackInterpolate
  [track_idx time_sec])
 (^{:tag godotclj.bindings.godot.PoolIntArray}
  valueTrackGetKeyIndices
  [track_idx time_sec delta])
 (^{:tag int} valueTrackGetUpdateMode [track_idx])
 (^{:tag godotclj.bindings.godot.Variant}
  valueTrackInterpolate
  [track_idx time_sec])
 (^{:tag void} valueTrackSetUpdateMode [track_idx mode]))
(definterface
 MGodotHTTPClient
 (^{:tag void} close [])
 (^{:tag int} connectToHost [host])
 (^{:tag int} connectToHost [host port])
 (^{:tag int} connectToHost [host port use_ssl])
 (^{:tag int} connectToHost [host port use_ssl verify_host])
 (^{:tag godotclj.api.gdscript.IGodotStreamPeer} getConnection [])
 (^{:tag int} getReadChunkSize [])
 (^{:tag int} getResponseBodyLength [])
 (^{:tag int} getResponseCode [])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  getResponseHeaders
  [])
 (^{:tag godotclj.bindings.godot.Dictionary}
  getResponseHeadersAsDictionary
  [])
 (^{:tag int} getStatus [])
 (^{:tag boolean} hasResponse [])
 (^{:tag boolean} isBlockingModeEnabled [])
 (^{:tag boolean} isResponseChunked [])
 (^{:tag int} poll [])
 (^{:tag String} queryStringFromDict [fields])
 (^{:tag godotclj.bindings.godot.PoolByteArray}
  readResponseBodyChunk
  [])
 (^{:tag int} request [method url headers])
 (^{:tag int} request [method url headers body])
 (^{:tag int} requestRaw [method url headers body])
 (^{:tag void} setBlockingMode [enabled])
 (^{:tag void} setConnection [connection])
 (^{:tag void} setReadChunkSize [bytes]))
(definterface
 MGodotAnimationNode
 (^{:tag void} addInput [name])
 (^{:tag void} blendAnimation [animation time delta seeked blend])
 (^{:tag float} blendInput [input_index time seek blend])
 (^{:tag float} blendInput [input_index time seek blend filter])
 (^{:tag float}
  blendInput
  [input_index time seek blend filter optimize])
 (^{:tag float} blendNode [name node time seek blend])
 (^{:tag float} blendNode [name node time seek blend filter])
 (^{:tag float} blendNode [name node time seek blend filter optimize])
 (^{:tag String} getCaption [])
 (^{:tag godotclj.api.gdscript.IGodotObject} getChildByName [name])
 (^{:tag godotclj.bindings.godot.Dictionary} getChildNodes [])
 (^{:tag int} getInputCount [])
 (^{:tag String} getInputName [input])
 (^{:tag godotclj.bindings.godot.Variant} getParameter [name])
 (^{:tag godotclj.bindings.godot.Variant}
  getParameterDefaultValue
  [name])
 (^{:tag godotclj.bindings.godot.IndexedArray} getParameterList [])
 (^{:tag String} hasFilter [])
 (^{:tag boolean} isFilterEnabled [])
 (^{:tag boolean} isPathFiltered [path])
 (^{:tag void} process [time seek])
 (^{:tag void} removeInput [index])
 (^{:tag void} setFilterEnabled [enable])
 (^{:tag void} setFilterPath [path enable])
 (^{:tag void} setParameter [name value]))
(definterface MGodotAnimationRootNode)
(definterface
 MGodotAnimationNodeBlendTree
 (^{:tag void} addNode [name node])
 (^{:tag void} addNode [name node position])
 (^{:tag void} connectNode [input_node input_index output_node])
 (^{:tag void} disconnectNode [input_node input_index])
 (^{:tag godotclj.bindings.godot.Vector2} getGraphOffset [])
 (^{:tag godotclj.api.gdscript.IGodotAnimationNode} getNode [name])
 (^{:tag godotclj.bindings.godot.Vector2} getNodePosition [name])
 (^{:tag boolean} hasNode [name])
 (^{:tag void} removeNode [name])
 (^{:tag void} renameNode [name new_name])
 (^{:tag void} setGraphOffset [offset])
 (^{:tag void} setNodePosition [name position]))
(definterface
 MGodot_File
 (^{:tag void} close [])
 (^{:tag boolean} eofReached [])
 (^{:tag boolean} fileExists [path])
 (^{:tag void} flush [])
 (^{:tag int} get16 [])
 (^{:tag int} get32 [])
 (^{:tag int} get64 [])
 (^{:tag int} get8 [])
 (^{:tag String} getAsText [])
 (^{:tag godotclj.bindings.godot.PoolByteArray} getBuffer [len])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  getCsvLine
  [])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  getCsvLine
  [delim])
 (^{:tag float} getDouble [])
 (^{:tag boolean} getEndianSwap [])
 (^{:tag int} getError [])
 (^{:tag float} getFloat [])
 (^{:tag int} getLen [])
 (^{:tag String} getLine [])
 (^{:tag String} getMd5 [path])
 (^{:tag int} getModifiedTime [file])
 (^{:tag String} getPascalString [])
 (^{:tag String} getPath [])
 (^{:tag String} getPathAbsolute [])
 (^{:tag int} getPosition [])
 (^{:tag float} getReal [])
 (^{:tag String} getSha256 [path])
 (^{:tag godotclj.bindings.godot.Variant} getVar [])
 (^{:tag godotclj.bindings.godot.Variant} getVar [allow_objects])
 (^{:tag boolean} isOpen [])
 (^{:tag int} open [path flags])
 (^{:tag int} openCompressed [path mode_flags])
 (^{:tag int} openCompressed [path mode_flags compression_mode])
 (^{:tag int} openEncrypted [path mode_flags key])
 (^{:tag int} openEncryptedWithPass [path mode_flags pass])
 (^{:tag void} seek [position])
 (^{:tag void} seekEnd [])
 (^{:tag void} seekEnd [position])
 (^{:tag void} setEndianSwap [enable])
 (^{:tag void} store16 [value])
 (^{:tag void} store32 [value])
 (^{:tag void} store64 [value])
 (^{:tag void} store8 [value])
 (^{:tag void} storeBuffer [buffer])
 (^{:tag void} storeCsvLine [values])
 (^{:tag void} storeCsvLine [values delim])
 (^{:tag void} storeDouble [value])
 (^{:tag void} storeFloat [value])
 (^{:tag void} storeLine [line])
 (^{:tag void} storePascalString [string])
 (^{:tag void} storeReal [value])
 (^{:tag void} storeString [string])
 (^{:tag void} storeVar [value])
 (^{:tag void} storeVar [value full_objects]))
(definterface
 MGodotVisualScriptResourcePath
 (^{:tag String} getResourcePath [])
 (^{:tag void} setResourcePath [path]))
(definterface
 MGodotEditorFeatureProfile
 (^{:tag String} getFeatureName [feature])
 (^{:tag boolean} isClassDisabled [class_name])
 (^{:tag boolean} isClassEditorDisabled [class_name])
 (^{:tag boolean} isClassPropertyDisabled [class_name property])
 (^{:tag boolean} isFeatureDisabled [feature])
 (^{:tag int} loadFromFile [path])
 (^{:tag int} saveToFile [path])
 (^{:tag void} setDisableClass [class_name disable])
 (^{:tag void} setDisableClassEditor [class_name disable])
 (^{:tag void} setDisableClassProperty [class_name property disable])
 (^{:tag void} setDisableFeature [feature disable]))
(definterface
 MGodotVisualScriptLocalVarSet
 (^{:tag String} getVarName [])
 (^{:tag int} getVarType [])
 (^{:tag void} setVarName [name])
 (^{:tag void} setVarType [type]))
(definterface
 MGodot_JSON
 (^{:tag godotclj.api.gdscript.IGodotJSONParseResult} parse [json])
 (^{:tag String} print [value])
 (^{:tag String} print [value indent])
 (^{:tag String} print [value indent sort_keys]))
(definterface
 MGodotHTTPRequest
 (^{:tag void} cancelRequest [])
 (^{:tag int} getBodySize [])
 (^{:tag int} getBodySizeLimit [])
 (^{:tag int} getDownloadChunkSize [])
 (^{:tag String} getDownloadFile [])
 (^{:tag int} getDownloadedBytes [])
 (^{:tag int} getHttpClientStatus [])
 (^{:tag int} getMaxRedirects [])
 (^{:tag int} getTimeout [])
 (^{:tag boolean} isUsingThreads [])
 (^{:tag int} request [url])
 (^{:tag int} request [url custom_headers])
 (^{:tag int} request [url custom_headers ssl_validate_domain])
 (^{:tag int} request [url custom_headers ssl_validate_domain method])
 (^{:tag int}
  request
  [url custom_headers ssl_validate_domain method request_data])
 (^{:tag void} setBodySizeLimit [bytes])
 (^{:tag void} setDownloadChunkSize [arg0])
 (^{:tag void} setDownloadFile [path])
 (^{:tag void} setMaxRedirects [amount])
 (^{:tag void} setTimeout [timeout])
 (^{:tag void} setUseThreads [enable]))
(definterface
 MGodotNavigationPolygonInstance
 (^{:tag godotclj.api.gdscript.IGodotNavigationPolygon}
  getNavigationPolygon
  [])
 (^{:tag boolean} isEnabled [])
 (^{:tag void} setEnabled [enabled])
 (^{:tag void} setNavigationPolygon [navpoly]))
(definterface
 MGodot_Marshalls
 (^{:tag godotclj.bindings.godot.PoolByteArray}
  base64ToRaw
  [base64_str])
 (^{:tag String} base64ToUtf8 [base64_str])
 (^{:tag godotclj.bindings.godot.Variant}
  base64ToVariant
  [base64_str])
 (^{:tag godotclj.bindings.godot.Variant}
  base64ToVariant
  [base64_str allow_objects])
 (^{:tag String} rawToBase64 [array])
 (^{:tag String} utf8ToBase64 [utf8_str])
 (^{:tag String} variantToBase64 [variant])
 (^{:tag String} variantToBase64 [variant full_objects]))
(definterface MGodotVideoStream)
(definterface
 MGodotVideoStreamGDNative
 (^{:tag String} getFile [])
 (^{:tag void} setFile [file]))
(definterface
 MGodotTexture
 (^{:tag void} draw [canvas_item position])
 (^{:tag void} draw [canvas_item position modulate])
 (^{:tag void} draw [canvas_item position modulate transpose])
 (^{:tag void}
  draw
  [canvas_item position modulate transpose normal_map])
 (^{:tag void} drawRect [canvas_item rect tile])
 (^{:tag void} drawRect [canvas_item rect tile modulate])
 (^{:tag void} drawRect [canvas_item rect tile modulate transpose])
 (^{:tag void}
  drawRect
  [canvas_item rect tile modulate transpose normal_map])
 (^{:tag void} drawRectRegion [canvas_item rect src_rect])
 (^{:tag void} drawRectRegion [canvas_item rect src_rect modulate])
 (^{:tag void}
  drawRectRegion
  [canvas_item rect src_rect modulate transpose])
 (^{:tag void}
  drawRectRegion
  [canvas_item rect src_rect modulate transpose normal_map])
 (^{:tag void}
  drawRectRegion
  [canvas_item rect src_rect modulate transpose normal_map clip_uv])
 (^{:tag godotclj.api.gdscript.IGodotImage} getData [])
 (^{:tag int} getFlags [])
 (^{:tag int} getHeight [])
 (^{:tag godotclj.bindings.godot.Vector2} getSize [])
 (^{:tag int} getWidth [])
 (^{:tag boolean} hasAlpha [])
 (^{:tag void} setFlags [flags]))
(definterface
 MGodotNoiseTexture
 (^{:tag float} getBumpStrength [])
 (^{:tag godotclj.api.gdscript.IGodotOpenSimplexNoise} getNoise [])
 (^{:tag boolean} getSeamless [])
 (^{:tag boolean} isNormalmap [])
 (^{:tag void} setAsNormalmap [as_normalmap])
 (^{:tag void} setBumpStrength [bump_strength])
 (^{:tag void} setHeight [height])
 (^{:tag void} setNoise [noise])
 (^{:tag void} setSeamless [seamless])
 (^{:tag void} setWidth [width]))
(definterface
 MGodotCollisionObject
 (^{:tag int} createShapeOwner [owner])
 (^{:tag boolean} getCaptureInputOnDrag [])
 (^{:tag godotclj.bindings.godot.RID} getRid [])
 (^{:tag godotclj.bindings.godot.IndexedArray} getShapeOwners [])
 (^{:tag boolean} isRayPickable [])
 (^{:tag boolean} isShapeOwnerDisabled [owner_id])
 (^{:tag void} removeShapeOwner [owner_id])
 (^{:tag void} setCaptureInputOnDrag [enable])
 (^{:tag void} setRayPickable [ray_pickable])
 (^{:tag int} shapeFindOwner [shape_index])
 (^{:tag void} shapeOwnerAddShape [owner_id shape])
 (^{:tag void} shapeOwnerClearShapes [owner_id])
 (^{:tag godotclj.api.gdscript.IGodotObject}
  shapeOwnerGetOwner
  [owner_id])
 (^{:tag godotclj.api.gdscript.IGodotShape}
  shapeOwnerGetShape
  [owner_id shape_id])
 (^{:tag int} shapeOwnerGetShapeCount [owner_id])
 (^{:tag int} shapeOwnerGetShapeIndex [owner_id shape_id])
 (^{:tag godotclj.bindings.godot.Transform}
  shapeOwnerGetTransform
  [owner_id])
 (^{:tag void} shapeOwnerRemoveShape [owner_id shape_id])
 (^{:tag void} shapeOwnerSetDisabled [owner_id disabled])
 (^{:tag void} shapeOwnerSetTransform [owner_id transform]))
(definterface
 MGodotArea
 (^{:tag float} getAngularDamp [])
 (^{:tag String} getAudioBus [])
 (^{:tag int} getCollisionLayer [])
 (^{:tag boolean} getCollisionLayerBit [bit])
 (^{:tag int} getCollisionMask [])
 (^{:tag boolean} getCollisionMaskBit [bit])
 (^{:tag float} getGravity [])
 (^{:tag float} getGravityDistanceScale [])
 (^{:tag godotclj.bindings.godot.Vector3} getGravityVector [])
 (^{:tag float} getLinearDamp [])
 (^{:tag godotclj.bindings.godot.IndexedArray} getOverlappingAreas [])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  getOverlappingBodies
  [])
 (^{:tag float} getPriority [])
 (^{:tag float} getReverbAmount [])
 (^{:tag String} getReverbBus [])
 (^{:tag float} getReverbUniformity [])
 (^{:tag int} getSpaceOverrideMode [])
 (^{:tag boolean} isGravityAPoint [])
 (^{:tag boolean} isMonitorable [])
 (^{:tag boolean} isMonitoring [])
 (^{:tag boolean} isOverridingAudioBus [])
 (^{:tag boolean} isUsingReverbBus [])
 (^{:tag boolean} overlapsArea [area])
 (^{:tag boolean} overlapsBody [body])
 (^{:tag void} setAngularDamp [angular_damp])
 (^{:tag void} setAudioBus [name])
 (^{:tag void} setAudioBusOverride [enable])
 (^{:tag void} setCollisionLayer [collision_layer])
 (^{:tag void} setCollisionLayerBit [bit value])
 (^{:tag void} setCollisionMask [collision_mask])
 (^{:tag void} setCollisionMaskBit [bit value])
 (^{:tag void} setGravity [gravity])
 (^{:tag void} setGravityDistanceScale [distance_scale])
 (^{:tag void} setGravityIsPoint [enable])
 (^{:tag void} setGravityVector [vector])
 (^{:tag void} setLinearDamp [linear_damp])
 (^{:tag void} setMonitorable [enable])
 (^{:tag void} setMonitoring [enable])
 (^{:tag void} setPriority [priority])
 (^{:tag void} setReverbAmount [amount])
 (^{:tag void} setReverbBus [name])
 (^{:tag void} setReverbUniformity [amount])
 (^{:tag void} setSpaceOverrideMode [enable])
 (^{:tag void} setUseReverbBus [enable]))
(definterface
 MGodotRange
 (^{:tag float} getAsRatio [])
 (^{:tag float} getMax [])
 (^{:tag float} getMin [])
 (^{:tag float} getPage [])
 (^{:tag float} getStep [])
 (^{:tag float} getValue [])
 (^{:tag boolean} isGreaterAllowed [])
 (^{:tag boolean} isLesserAllowed [])
 (^{:tag boolean} isRatioExp [])
 (^{:tag boolean} isUsingRoundedValues [])
 (^{:tag void} setAllowGreater [allow])
 (^{:tag void} setAllowLesser [allow])
 (^{:tag void} setAsRatio [value])
 (^{:tag void} setExpRatio [enabled])
 (^{:tag void} setMax [maximum])
 (^{:tag void} setMin [minimum])
 (^{:tag void} setPage [pagesize])
 (^{:tag void} setStep [step])
 (^{:tag void} setUseRoundedValues [enabled])
 (^{:tag void} setValue [value])
 (^{:tag void} share [with])
 (^{:tag void} unshare []))
(definterface
 MGodotScrollBar
 (^{:tag float} getCustomStep [])
 (^{:tag void} setCustomStep [step]))
(definterface MGodotVScrollBar)
(definterface
 MGodotSky
 (^{:tag int} getRadianceSize [])
 (^{:tag void} setRadianceSize [size]))
(definterface
 MGodotPanoramaSky
 (^{:tag godotclj.api.gdscript.IGodotTexture} getPanorama [])
 (^{:tag void} setPanorama [texture]))
(definterface
 MGodotFuncRef
 (^{:tag godotclj.bindings.godot.Variant} callFunc [])
 (^{:tag godotclj.bindings.godot.Variant} callFunc [v1])
 (^{:tag godotclj.bindings.godot.Variant} callFunc [v1 v2])
 (^{:tag godotclj.bindings.godot.Variant} callFunc [v1 v2 v3])
 (^{:tag godotclj.bindings.godot.Variant} callFunc [v1 v2 v3 v4])
 (^{:tag godotclj.bindings.godot.Variant} callFunc [v1 v2 v3 v4 v5])
 (^{:tag godotclj.bindings.godot.Variant} callFuncv [arg_array])
 (^{:tag String} getFunction [])
 (^{:tag boolean} isValid [])
 (^{:tag void} setFunction [name])
 (^{:tag void} setInstance [instance]))
(definterface
 MGodotBaseButton
 (^{:tag int} getActionMode [])
 (^{:tag godotclj.api.gdscript.IGodotButtonGroup} getButtonGroup [])
 (^{:tag int} getButtonMask [])
 (^{:tag int} getDrawMode [])
 (^{:tag int} getEnabledFocusMode [])
 (^{:tag godotclj.api.gdscript.IGodotShortCut} getShortcut [])
 (^{:tag boolean} isDisabled [])
 (^{:tag boolean} isHovered [])
 (^{:tag boolean} isKeepPressedOutside [])
 (^{:tag boolean} isPressed [])
 (^{:tag boolean} isShortcutInTooltipEnabled [])
 (^{:tag boolean} isToggleMode [])
 (^{:tag void} setActionMode [mode])
 (^{:tag void} setButtonGroup [button_group])
 (^{:tag void} setButtonMask [mask])
 (^{:tag void} setDisabled [disabled])
 (^{:tag void} setEnabledFocusMode [mode])
 (^{:tag void} setKeepPressedOutside [enabled])
 (^{:tag void} setPressed [pressed])
 (^{:tag void} setShortcut [shortcut])
 (^{:tag void} setShortcutInTooltip [enabled])
 (^{:tag void} setToggleMode [enabled]))
(definterface
 MGodotButton
 (^{:tag godotclj.api.gdscript.IGodotTexture} getButtonIcon [])
 (^{:tag boolean} getClipText [])
 (^{:tag String} getText [])
 (^{:tag int} getTextAlign [])
 (^{:tag boolean} isExpandIcon [])
 (^{:tag boolean} isFlat [])
 (^{:tag void} setButtonIcon [texture])
 (^{:tag void} setClipText [enabled])
 (^{:tag void} setExpandIcon [arg0])
 (^{:tag void} setFlat [enabled])
 (^{:tag void} setText [text])
 (^{:tag void} setTextAlign [align]))
(definterface
 MGodotOptionButton
 (^{:tag void} addIconItem [texture label])
 (^{:tag void} addIconItem [texture label id])
 (^{:tag void} addItem [label])
 (^{:tag void} addItem [label id])
 (^{:tag void} addSeparator [])
 (^{:tag void} clear [])
 (^{:tag int} getItemCount [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getItemIcon [idx])
 (^{:tag int} getItemId [idx])
 (^{:tag int} getItemIndex [id])
 (^{:tag godotclj.bindings.godot.Variant} getItemMetadata [idx])
 (^{:tag String} getItemText [idx])
 (^{:tag godotclj.api.gdscript.IGodotPopupMenu} getPopup [])
 (^{:tag int} getSelected [])
 (^{:tag int} getSelectedId [])
 (^{:tag godotclj.bindings.godot.Variant} getSelectedMetadata [])
 (^{:tag boolean} isItemDisabled [idx])
 (^{:tag void} removeItem [idx])
 (^{:tag void} select [idx])
 (^{:tag void} setItemDisabled [idx disabled])
 (^{:tag void} setItemIcon [idx texture])
 (^{:tag void} setItemId [idx id])
 (^{:tag void} setItemMetadata [idx metadata])
 (^{:tag void} setItemText [idx text]))
(definterface MGodotToolButton)
(definterface
 MGodotPhysicsBody
 (^{:tag void} addCollisionExceptionWith [body])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  getCollisionExceptions
  [])
 (^{:tag int} getCollisionLayer [])
 (^{:tag boolean} getCollisionLayerBit [bit])
 (^{:tag int} getCollisionMask [])
 (^{:tag boolean} getCollisionMaskBit [bit])
 (^{:tag void} removeCollisionExceptionWith [body])
 (^{:tag void} setCollisionLayer [layer])
 (^{:tag void} setCollisionLayerBit [bit value])
 (^{:tag void} setCollisionMask [mask])
 (^{:tag void} setCollisionMaskBit [bit value]))
(definterface
 MGodotPhysicalBone
 (^{:tag void} applyCentralImpulse [impulse])
 (^{:tag void} applyImpulse [position impulse])
 (^{:tag godotclj.bindings.godot.Transform} getBodyOffset [])
 (^{:tag int} getBoneId [])
 (^{:tag float} getBounce [])
 (^{:tag float} getFriction [])
 (^{:tag float} getGravityScale [])
 (^{:tag godotclj.bindings.godot.Transform} getJointOffset [])
 (^{:tag int} getJointType [])
 (^{:tag float} getMass [])
 (^{:tag boolean} getSimulatePhysics [])
 (^{:tag float} getWeight [])
 (^{:tag boolean} isSimulatingPhysics [])
 (^{:tag boolean} isStaticBody [])
 (^{:tag void} setBodyOffset [offset])
 (^{:tag void} setBounce [bounce])
 (^{:tag void} setFriction [friction])
 (^{:tag void} setGravityScale [gravity_scale])
 (^{:tag void} setJointOffset [offset])
 (^{:tag void} setJointType [joint_type])
 (^{:tag void} setMass [mass])
 (^{:tag void} setWeight [weight]))
(definterface
 MGodotAnimationNodeStateMachineTransition
 (^{:tag String} getAdvanceCondition [])
 (^{:tag int} getPriority [])
 (^{:tag int} getSwitchMode [])
 (^{:tag float} getXfadeTime [])
 (^{:tag boolean} hasAutoAdvance [])
 (^{:tag boolean} isDisabled [])
 (^{:tag void} setAdvanceCondition [name])
 (^{:tag void} setAutoAdvance [auto_advance])
 (^{:tag void} setDisabled [disabled])
 (^{:tag void} setPriority [priority])
 (^{:tag void} setSwitchMode [mode])
 (^{:tag void} setXfadeTime [secs]))
(definterface
 MGodotLine2D
 (^{:tag void} addPoint [position])
 (^{:tag void} addPoint [position at_position])
 (^{:tag void} clearPoints [])
 (^{:tag boolean} getAntialiased [])
 (^{:tag int} getBeginCapMode [])
 (^{:tag godotclj.api.gdscript.IGodotCurve} getCurve [])
 (^{:tag godotclj.bindings.godot.Color} getDefaultColor [])
 (^{:tag int} getEndCapMode [])
 (^{:tag godotclj.api.gdscript.IGodotGradient} getGradient [])
 (^{:tag int} getJointMode [])
 (^{:tag int} getPointCount [])
 (^{:tag godotclj.bindings.godot.Vector2} getPointPosition [i])
 (^{:tag godotclj.bindings.godot.IndexedPoolVector2Array}
  getPoints
  [])
 (^{:tag int} getRoundPrecision [])
 (^{:tag float} getSharpLimit [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getTexture [])
 (^{:tag int} getTextureMode [])
 (^{:tag float} getWidth [])
 (^{:tag void} removePoint [i])
 (^{:tag void} setAntialiased [antialiased])
 (^{:tag void} setBeginCapMode [mode])
 (^{:tag void} setCurve [curve])
 (^{:tag void} setDefaultColor [color])
 (^{:tag void} setEndCapMode [mode])
 (^{:tag void} setGradient [color])
 (^{:tag void} setJointMode [mode])
 (^{:tag void} setPointPosition [i position])
 (^{:tag void} setPoints [points])
 (^{:tag void} setRoundPrecision [precision])
 (^{:tag void} setSharpLimit [limit])
 (^{:tag void} setTexture [texture])
 (^{:tag void} setTextureMode [mode])
 (^{:tag void} setWidth [width]))
(definterface
 MGodot_ResourceSaver
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  getRecognizedExtensions
  [type])
 (^{:tag int} save [path resource])
 (^{:tag int} save [path resource flags]))
(definterface
 MGodotInputEventMIDI
 (^{:tag int} getChannel [])
 (^{:tag int} getControllerNumber [])
 (^{:tag int} getControllerValue [])
 (^{:tag int} getInstrument [])
 (^{:tag int} getMessage [])
 (^{:tag int} getPitch [])
 (^{:tag int} getPressure [])
 (^{:tag int} getVelocity [])
 (^{:tag void} setChannel [channel])
 (^{:tag void} setControllerNumber [controller_number])
 (^{:tag void} setControllerValue [controller_value])
 (^{:tag void} setInstrument [instrument])
 (^{:tag void} setMessage [message])
 (^{:tag void} setPitch [pitch])
 (^{:tag void} setPressure [pressure])
 (^{:tag void} setVelocity [velocity]))
(definterface
 MGodotARVRInterface
 (^{:tag boolean} getAnchorDetectionIsEnabled [])
 (^{:tag int} getCameraFeedId [])
 (^{:tag int} getCapabilities [])
 (^{:tag String} getName [])
 (^{:tag godotclj.bindings.godot.Vector2} getRenderTargetsize [])
 (^{:tag int} getTrackingStatus [])
 (^{:tag boolean} initialize [])
 (^{:tag boolean} isInitialized [])
 (^{:tag boolean} isPrimary [])
 (^{:tag boolean} isStereo [])
 (^{:tag void} setAnchorDetectionIsEnabled [enable])
 (^{:tag void} setIsInitialized [initialized])
 (^{:tag void} setIsPrimary [enable])
 (^{:tag void} uninitialize []))
(definterface
 MGodotMobileVRInterface
 (^{:tag float} getDisplayToLens [])
 (^{:tag float} getDisplayWidth [])
 (^{:tag float} getEyeHeight [])
 (^{:tag float} getIod [])
 (^{:tag float} getK1 [])
 (^{:tag float} getK2 [])
 (^{:tag float} getOversample [])
 (^{:tag void} setDisplayToLens [display_to_lens])
 (^{:tag void} setDisplayWidth [display_width])
 (^{:tag void} setEyeHeight [eye_height])
 (^{:tag void} setIod [iod])
 (^{:tag void} setK1 [k])
 (^{:tag void} setK2 [k])
 (^{:tag void} setOversample [oversample]))
(definterface
 MGodotRayShape
 (^{:tag float} getLength [])
 (^{:tag boolean} getSlipsOnSlope [])
 (^{:tag void} setLength [length])
 (^{:tag void} setSlipsOnSlope [active]))
(definterface MGodotAudioEffect)
(definterface
 MGodotAudioEffectDelay
 (^{:tag float} getDry [])
 (^{:tag float} getFeedbackDelayMs [])
 (^{:tag float} getFeedbackLevelDb [])
 (^{:tag float} getFeedbackLowpass [])
 (^{:tag float} getTap1DelayMs [])
 (^{:tag float} getTap1LevelDb [])
 (^{:tag float} getTap1Pan [])
 (^{:tag float} getTap2DelayMs [])
 (^{:tag float} getTap2LevelDb [])
 (^{:tag float} getTap2Pan [])
 (^{:tag boolean} isFeedbackActive [])
 (^{:tag boolean} isTap1Active [])
 (^{:tag boolean} isTap2Active [])
 (^{:tag void} setDry [amount])
 (^{:tag void} setFeedbackActive [amount])
 (^{:tag void} setFeedbackDelayMs [amount])
 (^{:tag void} setFeedbackLevelDb [amount])
 (^{:tag void} setFeedbackLowpass [amount])
 (^{:tag void} setTap1Active [amount])
 (^{:tag void} setTap1DelayMs [amount])
 (^{:tag void} setTap1LevelDb [amount])
 (^{:tag void} setTap1Pan [amount])
 (^{:tag void} setTap2Active [amount])
 (^{:tag void} setTap2DelayMs [amount])
 (^{:tag void} setTap2LevelDb [amount])
 (^{:tag void} setTap2Pan [amount]))
(definterface
 MGodotAnimationNodeAdd3
 (^{:tag boolean} isUsingSync [])
 (^{:tag void} setUseSync [enable]))
(definterface
 MGodotAudioEffectFilter
 (^{:tag float} getCutoff [])
 (^{:tag int} getDb [])
 (^{:tag float} getGain [])
 (^{:tag float} getResonance [])
 (^{:tag void} setCutoff [freq])
 (^{:tag void} setDb [amount])
 (^{:tag void} setGain [amount])
 (^{:tag void} setResonance [amount]))
(definterface MGodotAudioEffectHighShelfFilter)
(definterface
 MGodotAudioEffectCapture
 (^{:tag boolean} canGetBuffer [frames])
 (^{:tag void} clearBuffer [])
 (^{:tag godotclj.bindings.godot.IndexedPoolVector2Array}
  getBuffer
  [frames])
 (^{:tag float} getBufferLength [])
 (^{:tag int} getBufferLengthFrames [])
 (^{:tag int} getDiscardedFrames [])
 (^{:tag int} getFramesAvailable [])
 (^{:tag int} getPushedFrames [])
 (^{:tag void} setBufferLength [buffer_length_seconds]))
(definterface MGodotPanel)
(definterface MGodotVisualScriptCondition)
(definterface
 MGodotPolygon2D
 (^{:tag void} addBone [path weights])
 (^{:tag void} clearBones [])
 (^{:tag void} eraseBone [index])
 (^{:tag boolean} getAntialiased [])
 (^{:tag int} getBoneCount [])
 (^{:tag godotclj.bindings.godot.NodePath} getBonePath [index])
 (^{:tag godotclj.bindings.godot.PoolRealArray}
  getBoneWeights
  [index])
 (^{:tag godotclj.bindings.godot.Color} getColor [])
 (^{:tag int} getInternalVertexCount [])
 (^{:tag boolean} getInvert [])
 (^{:tag float} getInvertBorder [])
 (^{:tag godotclj.bindings.godot.Vector2} getOffset [])
 (^{:tag godotclj.bindings.godot.IndexedPoolVector2Array}
  getPolygon
  [])
 (^{:tag godotclj.bindings.godot.IndexedArray} getPolygons [])
 (^{:tag godotclj.bindings.godot.NodePath} getSkeleton [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getTexture [])
 (^{:tag godotclj.bindings.godot.Vector2} getTextureOffset [])
 (^{:tag float} getTextureRotation [])
 (^{:tag float} getTextureRotationDegrees [])
 (^{:tag godotclj.bindings.godot.Vector2} getTextureScale [])
 (^{:tag godotclj.bindings.godot.IndexedPoolVector2Array} getUv [])
 (^{:tag godotclj.bindings.godot.PoolColorArray} getVertexColors [])
 (^{:tag void} setAntialiased [antialiased])
 (^{:tag void} setBonePath [index path])
 (^{:tag void} setBoneWeights [index weights])
 (^{:tag void} setColor [color])
 (^{:tag void} setInternalVertexCount [internal_vertex_count])
 (^{:tag void} setInvert [invert])
 (^{:tag void} setInvertBorder [invert_border])
 (^{:tag void} setOffset [offset])
 (^{:tag void} setPolygon [polygon])
 (^{:tag void} setPolygons [polygons])
 (^{:tag void} setSkeleton [skeleton])
 (^{:tag void} setTexture [texture])
 (^{:tag void} setTextureOffset [texture_offset])
 (^{:tag void} setTextureRotation [texture_rotation])
 (^{:tag void} setTextureRotationDegrees [texture_rotation])
 (^{:tag void} setTextureScale [texture_scale])
 (^{:tag void} setUv [uv])
 (^{:tag void} setVertexColors [vertex_colors]))
(definterface
 MGodotSkinReference
 (^{:tag godotclj.bindings.godot.RID} getSkeleton [])
 (^{:tag godotclj.api.gdscript.IGodotSkin} getSkin []))
(definterface
 MGodotPacketPeer
 (^{:tag int} getAvailablePacketCount [])
 (^{:tag int} getEncodeBufferMaxSize [])
 (^{:tag godotclj.bindings.godot.PoolByteArray} getPacket [])
 (^{:tag int} getPacketError [])
 (^{:tag godotclj.bindings.godot.Variant} getVar [])
 (^{:tag godotclj.bindings.godot.Variant} getVar [allow_objects])
 (^{:tag boolean} isObjectDecodingAllowed [])
 (^{:tag int} putPacket [buffer])
 (^{:tag int} putVar [var])
 (^{:tag int} putVar [var full_objects])
 (^{:tag void} setAllowObjectDecoding [enable])
 (^{:tag void} setEncodeBufferMaxSize [max_size]))
(definterface
 MGodotNetworkedMultiplayerPeer
 (^{:tag int} getConnectionStatus [])
 (^{:tag int} getPacketPeer [])
 (^{:tag int} getTransferMode [])
 (^{:tag int} getUniqueId [])
 (^{:tag boolean} isRefusingNewConnections [])
 (^{:tag void} poll [])
 (^{:tag void} setRefuseNewConnections [enable])
 (^{:tag void} setTargetPeer [id])
 (^{:tag void} setTransferMode [mode]))
(definterface
 MGodotWebRTCMultiplayer
 (^{:tag int} addPeer [peer peer_id])
 (^{:tag int} addPeer [peer peer_id unreliable_lifetime])
 (^{:tag void} close [])
 (^{:tag godotclj.bindings.godot.Dictionary} getPeer [peer_id])
 (^{:tag godotclj.bindings.godot.Dictionary} getPeers [])
 (^{:tag boolean} hasPeer [peer_id])
 (^{:tag int} initialize [peer_id])
 (^{:tag int} initialize [peer_id server_compatibility])
 (^{:tag void} removePeer [peer_id]))
(definterface
 MGodotVisualShaderNodeIs
 (^{:tag int} getFunction [])
 (^{:tag void} setFunction [func]))
(definterface
 MGodotVisualScriptGlobalConstant
 (^{:tag int} getGlobalConstant [])
 (^{:tag void} setGlobalConstant [index]))
(definterface
 MGodotPhysics2DShapeQueryParameters
 (^{:tag int} getCollisionLayer [])
 (^{:tag godotclj.bindings.godot.IndexedArray} getExclude [])
 (^{:tag float} getMargin [])
 (^{:tag godotclj.bindings.godot.Vector2} getMotion [])
 (^{:tag godotclj.bindings.godot.RID} getShapeRid [])
 (^{:tag godotclj.bindings.godot.Transform2D} getTransform [])
 (^{:tag boolean} isCollideWithAreasEnabled [])
 (^{:tag boolean} isCollideWithBodiesEnabled [])
 (^{:tag void} setCollideWithAreas [enable])
 (^{:tag void} setCollideWithBodies [enable])
 (^{:tag void} setCollisionLayer [collision_layer])
 (^{:tag void} setExclude [exclude])
 (^{:tag void} setMargin [margin])
 (^{:tag void} setMotion [motion])
 (^{:tag void} setShape [shape])
 (^{:tag void} setShapeRid [shape])
 (^{:tag void} setTransform [transform]))
(definterface
 MGodotDTLSServer
 (^{:tag int} setup [key certificate])
 (^{:tag int} setup [key certificate chain])
 (^{:tag godotclj.api.gdscript.IGodotPacketPeerDTLS}
  takeConnection
  [udp_peer]))
(definterface
 MGodotCylinderShape
 (^{:tag float} getHeight [])
 (^{:tag float} getRadius [])
 (^{:tag void} setHeight [height])
 (^{:tag void} setRadius [radius]))
(definterface
 MGodotVisualScriptConstructor
 (^{:tag godotclj.bindings.godot.Dictionary} getConstructor [])
 (^{:tag int} getConstructorType [])
 (^{:tag void} setConstructor [constructor])
 (^{:tag void} setConstructorType [type]))
(definterface
 MGodotVisualScriptClassConstant
 (^{:tag String} getBaseType [])
 (^{:tag String} getClassConstant [])
 (^{:tag void} setBaseType [name])
 (^{:tag void} setClassConstant [name]))
(definterface
 MGodotPath2D
 (^{:tag godotclj.api.gdscript.IGodotCurve2D} getCurve [])
 (^{:tag void} setCurve [curve]))
(definterface
 MGodotCollisionPolygon
 (^{:tag float} getDepth [])
 (^{:tag float} getMargin [])
 (^{:tag godotclj.bindings.godot.IndexedPoolVector2Array}
  getPolygon
  [])
 (^{:tag boolean} isDisabled [])
 (^{:tag void} setDepth [depth])
 (^{:tag void} setDisabled [disabled])
 (^{:tag void} setMargin [margin])
 (^{:tag void} setPolygon [polygon]))
(definterface
 MGodotGridMap
 (^{:tag void} clear [])
 (^{:tag void} clearBakedMeshes [])
 (^{:tag godotclj.bindings.godot.RID} getBakeMeshInstance [idx])
 (^{:tag godotclj.bindings.godot.IndexedArray} getBakeMeshes [])
 (^{:tag int} getCellItem [x y z])
 (^{:tag int} getCellItemOrientation [x y z])
 (^{:tag float} getCellScale [])
 (^{:tag godotclj.bindings.godot.Vector3} getCellSize [])
 (^{:tag boolean} getCenterX [])
 (^{:tag boolean} getCenterY [])
 (^{:tag boolean} getCenterZ [])
 (^{:tag int} getCollisionLayer [])
 (^{:tag boolean} getCollisionLayerBit [bit])
 (^{:tag int} getCollisionMask [])
 (^{:tag boolean} getCollisionMaskBit [bit])
 (^{:tag godotclj.api.gdscript.IGodotMeshLibrary} getMeshLibrary [])
 (^{:tag godotclj.bindings.godot.IndexedArray} getMeshes [])
 (^{:tag int} getOctantSize [])
 (^{:tag boolean} getUseInBakedLight [])
 (^{:tag godotclj.bindings.godot.IndexedArray} getUsedCells [])
 (^{:tag void} makeBakedMeshes [])
 (^{:tag void} makeBakedMeshes [gen_lightmap_uv])
 (^{:tag void}
  makeBakedMeshes
  [gen_lightmap_uv lightmap_uv_texel_size])
 (^{:tag godotclj.bindings.godot.Vector3} mapToWorld [x y z])
 (^{:tag void} resourceChanged [resource])
 (^{:tag void} setCellItem [x y z item])
 (^{:tag void} setCellItem [x y z item orientation])
 (^{:tag void} setCellScale [scale])
 (^{:tag void} setCellSize [size])
 (^{:tag void} setCenterX [enable])
 (^{:tag void} setCenterY [enable])
 (^{:tag void} setCenterZ [enable])
 (^{:tag void} setClip [enabled])
 (^{:tag void} setClip [enabled clipabove])
 (^{:tag void} setClip [enabled clipabove floor])
 (^{:tag void} setClip [enabled clipabove floor axis])
 (^{:tag void} setCollisionLayer [layer])
 (^{:tag void} setCollisionLayerBit [bit value])
 (^{:tag void} setCollisionMask [mask])
 (^{:tag void} setCollisionMaskBit [bit value])
 (^{:tag void} setMeshLibrary [mesh_library])
 (^{:tag void} setOctantSize [size])
 (^{:tag void} setUseInBakedLight [use_in_baked_light])
 (^{:tag godotclj.bindings.godot.Vector3} worldToMap [pos]))
(definterface
 MGodotX509Certificate
 (^{:tag int} load [path])
 (^{:tag int} save [path]))
(definterface
 MGodotPhysics2DServer
 (^{:tag void} areaAddShape [area shape])
 (^{:tag void} areaAddShape [area shape transform])
 (^{:tag void} areaAddShape [area shape transform disabled])
 (^{:tag void} areaAttachCanvasInstanceId [area id])
 (^{:tag void} areaAttachObjectInstanceId [area id])
 (^{:tag void} areaClearShapes [area])
 (^{:tag godotclj.bindings.godot.RID} areaCreate [])
 (^{:tag int} areaGetCanvasInstanceId [area])
 (^{:tag int} areaGetObjectInstanceId [area])
 (^{:tag godotclj.bindings.godot.Variant} areaGetParam [area param])
 (^{:tag godotclj.bindings.godot.RID} areaGetShape [area shape_idx])
 (^{:tag int} areaGetShapeCount [area])
 (^{:tag godotclj.bindings.godot.Transform2D}
  areaGetShapeTransform
  [area shape_idx])
 (^{:tag godotclj.bindings.godot.RID} areaGetSpace [area])
 (^{:tag int} areaGetSpaceOverrideMode [area])
 (^{:tag godotclj.bindings.godot.Transform2D} areaGetTransform [area])
 (^{:tag void} areaRemoveShape [area shape_idx])
 (^{:tag void} areaSetAreaMonitorCallback [area receiver method])
 (^{:tag void} areaSetCollisionLayer [area layer])
 (^{:tag void} areaSetCollisionMask [area mask])
 (^{:tag void} areaSetMonitorCallback [area receiver method])
 (^{:tag void} areaSetMonitorable [area monitorable])
 (^{:tag void} areaSetParam [area param value])
 (^{:tag void} areaSetShape [area shape_idx shape])
 (^{:tag void} areaSetShapeDisabled [area shape_idx disabled])
 (^{:tag void} areaSetShapeTransform [area shape_idx transform])
 (^{:tag void} areaSetSpace [area space])
 (^{:tag void} areaSetSpaceOverrideMode [area mode])
 (^{:tag void} areaSetTransform [area transform])
 (^{:tag void} bodyAddCentralForce [body force])
 (^{:tag void} bodyAddCollisionException [body excepted_body])
 (^{:tag void} bodyAddForce [body offset force])
 (^{:tag void} bodyAddShape [body shape])
 (^{:tag void} bodyAddShape [body shape transform])
 (^{:tag void} bodyAddShape [body shape transform disabled])
 (^{:tag void} bodyAddTorque [body torque])
 (^{:tag void} bodyApplyCentralImpulse [body impulse])
 (^{:tag void} bodyApplyImpulse [body position impulse])
 (^{:tag void} bodyApplyTorqueImpulse [body impulse])
 (^{:tag void} bodyAttachCanvasInstanceId [body id])
 (^{:tag void} bodyAttachObjectInstanceId [body id])
 (^{:tag void} bodyClearShapes [body])
 (^{:tag godotclj.bindings.godot.RID} bodyCreate [])
 (^{:tag int} bodyGetCanvasInstanceId [body])
 (^{:tag int} bodyGetCollisionLayer [body])
 (^{:tag int} bodyGetCollisionMask [body])
 (^{:tag int} bodyGetContinuousCollisionDetectionMode [body])
 (^{:tag godotclj.api.gdscript.IGodotPhysics2DDirectBodyState}
  bodyGetDirectState
  [body])
 (^{:tag int} bodyGetMaxContactsReported [body])
 (^{:tag int} bodyGetMode [body])
 (^{:tag int} bodyGetObjectInstanceId [body])
 (^{:tag float} bodyGetParam [body param])
 (^{:tag godotclj.bindings.godot.RID} bodyGetShape [body shape_idx])
 (^{:tag int} bodyGetShapeCount [body])
 (^{:tag godotclj.bindings.godot.Variant}
  bodyGetShapeMetadata
  [body shape_idx])
 (^{:tag godotclj.bindings.godot.Transform2D}
  bodyGetShapeTransform
  [body shape_idx])
 (^{:tag godotclj.bindings.godot.RID} bodyGetSpace [body])
 (^{:tag godotclj.bindings.godot.Variant} bodyGetState [body state])
 (^{:tag boolean} bodyIsOmittingForceIntegration [body])
 (^{:tag void} bodyRemoveCollisionException [body excepted_body])
 (^{:tag void} bodyRemoveShape [body shape_idx])
 (^{:tag void} bodySetAxisVelocity [body axis_velocity])
 (^{:tag void} bodySetCollisionLayer [body layer])
 (^{:tag void} bodySetCollisionMask [body mask])
 (^{:tag void} bodySetContinuousCollisionDetectionMode [body mode])
 (^{:tag void} bodySetForceIntegrationCallback [body receiver method])
 (^{:tag void}
  bodySetForceIntegrationCallback
  [body receiver method userdata])
 (^{:tag void} bodySetMaxContactsReported [body amount])
 (^{:tag void} bodySetMode [body mode])
 (^{:tag void} bodySetOmitForceIntegration [body enable])
 (^{:tag void} bodySetParam [body param value])
 (^{:tag void} bodySetShape [body shape_idx shape])
 (^{:tag void}
  bodySetShapeAsOneWayCollision
  [body shape_idx enable margin])
 (^{:tag void} bodySetShapeDisabled [body shape_idx disabled])
 (^{:tag void} bodySetShapeMetadata [body shape_idx metadata])
 (^{:tag void} bodySetShapeTransform [body shape_idx transform])
 (^{:tag void} bodySetSpace [body space])
 (^{:tag void} bodySetState [body state value])
 (^{:tag boolean} bodyTestMotion [body from motion infinite_inertia])
 (^{:tag boolean}
  bodyTestMotion
  [body from motion infinite_inertia margin])
 (^{:tag boolean}
  bodyTestMotion
  [body from motion infinite_inertia margin result])
 (^{:tag godotclj.bindings.godot.RID} capsuleShapeCreate [])
 (^{:tag godotclj.bindings.godot.RID} circleShapeCreate [])
 (^{:tag godotclj.bindings.godot.RID} concavePolygonShapeCreate [])
 (^{:tag godotclj.bindings.godot.RID} convexPolygonShapeCreate [])
 (^{:tag godotclj.bindings.godot.RID}
  dampedSpringJointCreate
  [anchor_a anchor_b body_a])
 (^{:tag godotclj.bindings.godot.RID}
  dampedSpringJointCreate
  [anchor_a anchor_b body_a body_b])
 (^{:tag float} dampedStringJointGetParam [joint param])
 (^{:tag void} dampedStringJointSetParam [joint param value])
 (^{:tag void} freeRid [rid])
 (^{:tag int} getProcessInfo [process_info])
 (^{:tag godotclj.bindings.godot.RID}
  grooveJointCreate
  [groove1_a groove2_a anchor_b])
 (^{:tag godotclj.bindings.godot.RID}
  grooveJointCreate
  [groove1_a groove2_a anchor_b body_a])
 (^{:tag godotclj.bindings.godot.RID}
  grooveJointCreate
  [groove1_a groove2_a anchor_b body_a body_b])
 (^{:tag float} jointGetParam [joint param])
 (^{:tag int} jointGetType [joint])
 (^{:tag void} jointSetParam [joint param value])
 (^{:tag godotclj.bindings.godot.RID} lineShapeCreate [])
 (^{:tag godotclj.bindings.godot.RID} pinJointCreate [anchor body_a])
 (^{:tag godotclj.bindings.godot.RID}
  pinJointCreate
  [anchor body_a body_b])
 (^{:tag godotclj.bindings.godot.RID} rayShapeCreate [])
 (^{:tag godotclj.bindings.godot.RID} rectangleShapeCreate [])
 (^{:tag godotclj.bindings.godot.RID} segmentShapeCreate [])
 (^{:tag void} setActive [active])
 (^{:tag godotclj.bindings.godot.Variant} shapeGetData [shape])
 (^{:tag int} shapeGetType [shape])
 (^{:tag void} shapeSetData [shape data])
 (^{:tag godotclj.bindings.godot.RID} spaceCreate [])
 (^{:tag godotclj.api.gdscript.IGodotPhysics2DDirectSpaceState}
  spaceGetDirectState
  [space])
 (^{:tag float} spaceGetParam [space param])
 (^{:tag boolean} spaceIsActive [space])
 (^{:tag void} spaceSetActive [space active])
 (^{:tag void} spaceSetParam [space param value]))
(definterface MGodotPhysics2DServerSW)
(definterface
 MGodotPacketPeerStream
 (^{:tag int} getInputBufferMaxSize [])
 (^{:tag int} getOutputBufferMaxSize [])
 (^{:tag godotclj.api.gdscript.IGodotStreamPeer} getStreamPeer [])
 (^{:tag void} setInputBufferMaxSize [max_size_bytes])
 (^{:tag void} setOutputBufferMaxSize [max_size_bytes])
 (^{:tag void} setStreamPeer [peer]))
(definterface
 MGodot_ResourceLoader
 (^{:tag boolean} exists [path])
 (^{:tag boolean} exists [path type_hint])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  getDependencies
  [path])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  getRecognizedExtensionsForType
  [type])
 (^{:tag boolean} has [path])
 (^{:tag boolean} hasCached [path])
 (^{:tag godotclj.api.gdscript.IGodotResource} load [path])
 (^{:tag godotclj.api.gdscript.IGodotResource} load [path type_hint])
 (^{:tag godotclj.api.gdscript.IGodotResource}
  load
  [path type_hint no_cache])
 (^{:tag godotclj.api.gdscript.IGodotResourceInteractiveLoader}
  loadInteractive
  [path])
 (^{:tag godotclj.api.gdscript.IGodotResourceInteractiveLoader}
  loadInteractive
  [path type_hint])
 (^{:tag void} setAbortOnMissingResources [abort]))
(definterface
 MGodotBone2D
 (^{:tag void} applyRest [])
 (^{:tag float} getDefaultLength [])
 (^{:tag int} getIndexInSkeleton [])
 (^{:tag godotclj.bindings.godot.Transform2D} getRest [])
 (^{:tag godotclj.bindings.godot.Transform2D} getSkeletonRest [])
 (^{:tag void} setDefaultLength [default_length])
 (^{:tag void} setRest [rest]))
(definterface
 MGodotRigidBody
 (^{:tag void} addCentralForce [force])
 (^{:tag void} addForce [force position])
 (^{:tag void} addTorque [torque])
 (^{:tag void} applyCentralImpulse [impulse])
 (^{:tag void} applyImpulse [position impulse])
 (^{:tag void} applyTorqueImpulse [impulse])
 (^{:tag float} getAngularDamp [])
 (^{:tag godotclj.bindings.godot.Vector3} getAngularVelocity [])
 (^{:tag boolean} getAxisLock [axis])
 (^{:tag float} getBounce [])
 (^{:tag godotclj.bindings.godot.IndexedArray} getCollidingBodies [])
 (^{:tag float} getFriction [])
 (^{:tag float} getGravityScale [])
 (^{:tag godotclj.bindings.godot.Basis} getInverseInertiaTensor [])
 (^{:tag float} getLinearDamp [])
 (^{:tag godotclj.bindings.godot.Vector3} getLinearVelocity [])
 (^{:tag float} getMass [])
 (^{:tag int} getMaxContactsReported [])
 (^{:tag int} getMode [])
 (^{:tag godotclj.api.gdscript.IGodotPhysicsMaterial}
  getPhysicsMaterialOverride
  [])
 (^{:tag float} getWeight [])
 (^{:tag boolean} isAbleToSleep [])
 (^{:tag boolean} isContactMonitorEnabled [])
 (^{:tag boolean} isSleeping [])
 (^{:tag boolean} isUsingContinuousCollisionDetection [])
 (^{:tag boolean} isUsingCustomIntegrator [])
 (^{:tag void} setAngularDamp [angular_damp])
 (^{:tag void} setAngularVelocity [angular_velocity])
 (^{:tag void} setAxisLock [axis lock])
 (^{:tag void} setAxisVelocity [axis_velocity])
 (^{:tag void} setBounce [bounce])
 (^{:tag void} setCanSleep [able_to_sleep])
 (^{:tag void} setContactMonitor [enabled])
 (^{:tag void} setFriction [friction])
 (^{:tag void} setGravityScale [gravity_scale])
 (^{:tag void} setLinearDamp [linear_damp])
 (^{:tag void} setLinearVelocity [linear_velocity])
 (^{:tag void} setMass [mass])
 (^{:tag void} setMaxContactsReported [amount])
 (^{:tag void} setMode [mode])
 (^{:tag void} setPhysicsMaterialOverride [physics_material_override])
 (^{:tag void} setSleeping [sleeping])
 (^{:tag void} setUseContinuousCollisionDetection [enable])
 (^{:tag void} setUseCustomIntegrator [enable])
 (^{:tag void} setWeight [weight]))
(definterface
 MGodotPlaneMesh
 (^{:tag godotclj.bindings.godot.Vector2} getSize [])
 (^{:tag int} getSubdivideDepth [])
 (^{:tag int} getSubdivideWidth [])
 (^{:tag void} setSize [size])
 (^{:tag void} setSubdivideDepth [subdivide])
 (^{:tag void} setSubdivideWidth [subdivide]))
(definterface MGodotMultiplayerPeerGDNative)
(definterface
 MGodotCollisionObject2D
 (^{:tag int} createShapeOwner [owner])
 (^{:tag godotclj.bindings.godot.RID} getRid [])
 (^{:tag float} getShapeOwnerOneWayCollisionMargin [owner_id])
 (^{:tag godotclj.bindings.godot.IndexedArray} getShapeOwners [])
 (^{:tag boolean} isPickable [])
 (^{:tag boolean} isShapeOwnerDisabled [owner_id])
 (^{:tag boolean} isShapeOwnerOneWayCollisionEnabled [owner_id])
 (^{:tag void} removeShapeOwner [owner_id])
 (^{:tag void} setPickable [enabled])
 (^{:tag int} shapeFindOwner [shape_index])
 (^{:tag void} shapeOwnerAddShape [owner_id shape])
 (^{:tag void} shapeOwnerClearShapes [owner_id])
 (^{:tag godotclj.api.gdscript.IGodotObject}
  shapeOwnerGetOwner
  [owner_id])
 (^{:tag godotclj.api.gdscript.IGodotShape2D}
  shapeOwnerGetShape
  [owner_id shape_id])
 (^{:tag int} shapeOwnerGetShapeCount [owner_id])
 (^{:tag int} shapeOwnerGetShapeIndex [owner_id shape_id])
 (^{:tag godotclj.bindings.godot.Transform2D}
  shapeOwnerGetTransform
  [owner_id])
 (^{:tag void} shapeOwnerRemoveShape [owner_id shape_id])
 (^{:tag void} shapeOwnerSetDisabled [owner_id disabled])
 (^{:tag void} shapeOwnerSetOneWayCollision [owner_id enable])
 (^{:tag void} shapeOwnerSetOneWayCollisionMargin [owner_id margin])
 (^{:tag void} shapeOwnerSetTransform [owner_id transform]))
(definterface
 MGodotSurfaceTool
 (^{:tag void} addBones [bones])
 (^{:tag void} addColor [color])
 (^{:tag void} addIndex [index])
 (^{:tag void} addNormal [normal])
 (^{:tag void} addSmoothGroup [smooth])
 (^{:tag void} addTangent [tangent])
 (^{:tag void} addTriangleFan [vertices])
 (^{:tag void} addTriangleFan [vertices uvs])
 (^{:tag void} addTriangleFan [vertices uvs colors])
 (^{:tag void} addTriangleFan [vertices uvs colors uv2s])
 (^{:tag void} addTriangleFan [vertices uvs colors uv2s normals])
 (^{:tag void}
  addTriangleFan
  [vertices uvs colors uv2s normals tangents])
 (^{:tag void} addUv [uv])
 (^{:tag void} addUv2 [uv2])
 (^{:tag void} addVertex [vertex])
 (^{:tag void} addWeights [weights])
 (^{:tag void} appendFrom [existing surface transform])
 (^{:tag void} begin [primitive])
 (^{:tag void} clear [])
 (^{:tag godotclj.api.gdscript.IGodotArrayMesh} commit [])
 (^{:tag godotclj.api.gdscript.IGodotArrayMesh} commit [existing])
 (^{:tag godotclj.api.gdscript.IGodotArrayMesh}
  commit
  [existing flags])
 (^{:tag godotclj.bindings.godot.IndexedArray} commitToArrays [])
 (^{:tag void} createFrom [existing surface])
 (^{:tag void} createFromBlendShape [existing surface blend_shape])
 (^{:tag void} deindex [])
 (^{:tag void} generateNormals [])
 (^{:tag void} generateNormals [flip])
 (^{:tag void} generateTangents [])
 (^{:tag void} index [])
 (^{:tag void} setMaterial [material]))
(definterface
 MGodotIP
 (^{:tag void} clearCache [])
 (^{:tag void} clearCache [hostname])
 (^{:tag void} eraseResolveItem [id])
 (^{:tag godotclj.bindings.godot.IndexedArray} getLocalAddresses [])
 (^{:tag godotclj.bindings.godot.IndexedArray} getLocalInterfaces [])
 (^{:tag String} getResolveItemAddress [id])
 (^{:tag int} getResolveItemStatus [id])
 (^{:tag String} resolveHostname [host])
 (^{:tag String} resolveHostname [host ip_type])
 (^{:tag int} resolveHostnameQueueItem [host])
 (^{:tag int} resolveHostnameQueueItem [host ip_type]))
(definterface MGodotIP_Unix)
(definterface
 MGodotCamera
 (^{:tag void} clearCurrent [])
 (^{:tag void} clearCurrent [enable_next])
 (^{:tag godotclj.bindings.godot.RID} getCameraRid [])
 (^{:tag godotclj.bindings.godot.Transform} getCameraTransform [])
 (^{:tag int} getCullMask [])
 (^{:tag boolean} getCullMaskBit [layer])
 (^{:tag int} getDopplerTracking [])
 (^{:tag godotclj.api.gdscript.IGodotEnvironment} getEnvironment [])
 (^{:tag float} getFov [])
 (^{:tag godotclj.bindings.godot.IndexedArray} getFrustum [])
 (^{:tag godotclj.bindings.godot.Vector2} getFrustumOffset [])
 (^{:tag float} getHOffset [])
 (^{:tag int} getKeepAspectMode [])
 (^{:tag int} getProjection [])
 (^{:tag float} getSize [])
 (^{:tag float} getVOffset [])
 (^{:tag float} getZfar [])
 (^{:tag float} getZnear [])
 (^{:tag boolean} isCurrent [])
 (^{:tag boolean} isPositionBehind [world_point])
 (^{:tag void} makeCurrent [])
 (^{:tag godotclj.bindings.godot.Vector3}
  projectLocalRayNormal
  [screen_point])
 (^{:tag godotclj.bindings.godot.Vector3}
  projectPosition
  [screen_point z_depth])
 (^{:tag godotclj.bindings.godot.Vector3}
  projectRayNormal
  [screen_point])
 (^{:tag godotclj.bindings.godot.Vector3}
  projectRayOrigin
  [screen_point])
 (^{:tag void} setCullMask [mask])
 (^{:tag void} setCullMaskBit [layer enable])
 (^{:tag void} setCurrent [arg0])
 (^{:tag void} setDopplerTracking [mode])
 (^{:tag void} setEnvironment [env])
 (^{:tag void} setFov [arg0])
 (^{:tag void} setFrustum [size offset z_near z_far])
 (^{:tag void} setFrustumOffset [arg0])
 (^{:tag void} setHOffset [ofs])
 (^{:tag void} setKeepAspectMode [mode])
 (^{:tag void} setOrthogonal [size z_near z_far])
 (^{:tag void} setPerspective [fov z_near z_far])
 (^{:tag void} setProjection [arg0])
 (^{:tag void} setSize [arg0])
 (^{:tag void} setVOffset [ofs])
 (^{:tag void} setZfar [arg0])
 (^{:tag void} setZnear [arg0])
 (^{:tag godotclj.bindings.godot.Vector2}
  unprojectPosition
  [world_point]))
(definterface
 MGodotClippedCamera
 (^{:tag void} addException [node])
 (^{:tag void} addExceptionRid [rid])
 (^{:tag void} clearExceptions [])
 (^{:tag float} getClipOffset [])
 (^{:tag int} getCollisionMask [])
 (^{:tag boolean} getCollisionMaskBit [bit])
 (^{:tag float} getMargin [])
 (^{:tag int} getProcessMode [])
 (^{:tag boolean} isClipToAreasEnabled [])
 (^{:tag boolean} isClipToBodiesEnabled [])
 (^{:tag void} removeException [node])
 (^{:tag void} removeExceptionRid [rid])
 (^{:tag void} setClipToAreas [enable])
 (^{:tag void} setClipToBodies [enable])
 (^{:tag void} setCollisionMask [mask])
 (^{:tag void} setCollisionMaskBit [bit value])
 (^{:tag void} setMargin [margin])
 (^{:tag void} setProcessMode [process_mode]))
(definterface
 MGodotAudioEffectLimiter
 (^{:tag float} getCeilingDb [])
 (^{:tag float} getSoftClipDb [])
 (^{:tag float} getSoftClipRatio [])
 (^{:tag float} getThresholdDb [])
 (^{:tag void} setCeilingDb [ceiling])
 (^{:tag void} setSoftClipDb [soft_clip])
 (^{:tag void} setSoftClipRatio [soft_clip])
 (^{:tag void} setThresholdDb [threshold]))
(definterface
 MGodotCurveTexture
 (^{:tag godotclj.api.gdscript.IGodotCurve} getCurve [])
 (^{:tag void} setCurve [curve])
 (^{:tag void} setWidth [width]))
(definterface
 MGodotEditorInterface
 (^{:tag void} editNode [node])
 (^{:tag void} editResource [resource])
 (^{:tag godotclj.api.gdscript.IGodotControl} getBaseControl [])
 (^{:tag String} getCurrentPath [])
 (^{:tag godotclj.api.gdscript.IGodotNode} getEditedSceneRoot [])
 (^{:tag float} getEditorScale [])
 (^{:tag godotclj.api.gdscript.IGodotEditorSettings}
  getEditorSettings
  [])
 (^{:tag godotclj.api.gdscript.IGodotControl} getEditorViewport [])
 (^{:tag godotclj.api.gdscript.IGodotFileSystemDock}
  getFileSystemDock
  [])
 (^{:tag godotclj.api.gdscript.IGodotEditorInspector} getInspector [])
 (^{:tag godotclj.bindings.godot.IndexedArray} getOpenScenes [])
 (^{:tag String} getPlayingScene [])
 (^{:tag godotclj.api.gdscript.IGodotEditorFileSystem}
  getResourceFilesystem
  [])
 (^{:tag godotclj.api.gdscript.IGodotEditorResourcePreview}
  getResourcePreviewer
  [])
 (^{:tag godotclj.api.gdscript.IGodotScriptEditor} getScriptEditor [])
 (^{:tag String} getSelectedPath [])
 (^{:tag godotclj.api.gdscript.IGodotEditorSelection} getSelection [])
 (^{:tag void} inspectObject [object])
 (^{:tag void} inspectObject [object for_property])
 (^{:tag void} inspectObject [object for_property inspector_only])
 (^{:tag boolean} isDistractionFreeModeEnabled [])
 (^{:tag boolean} isPlayingScene [])
 (^{:tag boolean} isPluginEnabled [plugin])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  makeMeshPreviews
  [meshes preview_size])
 (^{:tag void} openSceneFromPath [scene_filepath])
 (^{:tag void} playCurrentScene [])
 (^{:tag void} playCustomScene [scene_filepath])
 (^{:tag void} playMainScene [])
 (^{:tag void} reloadSceneFromPath [scene_filepath])
 (^{:tag int} saveScene [])
 (^{:tag void} saveSceneAs [path])
 (^{:tag void} saveSceneAs [path with_preview])
 (^{:tag void} selectFile [file])
 (^{:tag void} setDistractionFreeMode [enter])
 (^{:tag void} setMainScreenEditor [name])
 (^{:tag void} setPluginEnabled [plugin enabled])
 (^{:tag void} stopPlayingScene []))
(definterface
 MGodotVisualShaderNodeUniform
 (^{:tag String} getUniformName [])
 (^{:tag void} setUniformName [name]))
(definterface
 MGodotVisualShaderNodeTextureUniform
 (^{:tag int} getColorDefault [])
 (^{:tag int} getTextureType [])
 (^{:tag void} setColorDefault [type])
 (^{:tag void} setTextureType [type]))
(definterface MGodotVisualShaderNodeScalarUniform)
(definterface
 MGodot_Directory
 (^{:tag int} changeDir [todir])
 (^{:tag int} copy [from to])
 (^{:tag boolean} currentIsDir [])
 (^{:tag boolean} dirExists [path])
 (^{:tag boolean} fileExists [path])
 (^{:tag String} getCurrentDir [])
 (^{:tag int} getCurrentDrive [])
 (^{:tag String} getDrive [idx])
 (^{:tag int} getDriveCount [])
 (^{:tag String} getNext [])
 (^{:tag int} getSpaceLeft [])
 (^{:tag int} listDirBegin [])
 (^{:tag int} listDirBegin [skip_navigational])
 (^{:tag int} listDirBegin [skip_navigational skip_hidden])
 (^{:tag void} listDirEnd [])
 (^{:tag int} makeDir [path])
 (^{:tag int} makeDirRecursive [path])
 (^{:tag int} open [path])
 (^{:tag int} remove [path])
 (^{:tag int} rename [from to]))
(definterface
 MGodotAnimationNodeAnimation
 (^{:tag String} getAnimation [])
 (^{:tag void} setAnimation [name]))
(definterface MGodotVisualScriptFunction)
(definterface
 MGodotMaterial
 (^{:tag godotclj.api.gdscript.IGodotMaterial} getNextPass [])
 (^{:tag int} getRenderPriority [])
 (^{:tag void} setNextPass [next_pass])
 (^{:tag void} setRenderPriority [priority]))
(definterface
 MGodotParticlesMaterial
 (^{:tag godotclj.bindings.godot.Color} getColor [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getColorRamp [])
 (^{:tag godotclj.bindings.godot.Vector3} getDirection [])
 (^{:tag godotclj.bindings.godot.Vector3} getEmissionBoxExtents [])
 (^{:tag godotclj.api.gdscript.IGodotTexture}
  getEmissionColorTexture
  [])
 (^{:tag godotclj.api.gdscript.IGodotTexture}
  getEmissionNormalTexture
  [])
 (^{:tag int} getEmissionPointCount [])
 (^{:tag godotclj.api.gdscript.IGodotTexture}
  getEmissionPointTexture
  [])
 (^{:tag int} getEmissionShape [])
 (^{:tag float} getEmissionSphereRadius [])
 (^{:tag boolean} getFlag [flag])
 (^{:tag float} getFlatness [])
 (^{:tag godotclj.bindings.godot.Vector3} getGravity [])
 (^{:tag float} getLifetimeRandomness [])
 (^{:tag float} getParam [param])
 (^{:tag float} getParamRandomness [param])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getParamTexture [param])
 (^{:tag float} getSpread [])
 (^{:tag godotclj.api.gdscript.IGodotGradientTexture}
  getTrailColorModifier
  [])
 (^{:tag int} getTrailDivisor [])
 (^{:tag godotclj.api.gdscript.IGodotCurveTexture}
  getTrailSizeModifier
  [])
 (^{:tag void} setColor [color])
 (^{:tag void} setColorRamp [ramp])
 (^{:tag void} setDirection [degrees])
 (^{:tag void} setEmissionBoxExtents [extents])
 (^{:tag void} setEmissionColorTexture [texture])
 (^{:tag void} setEmissionNormalTexture [texture])
 (^{:tag void} setEmissionPointCount [point_count])
 (^{:tag void} setEmissionPointTexture [texture])
 (^{:tag void} setEmissionShape [shape])
 (^{:tag void} setEmissionSphereRadius [radius])
 (^{:tag void} setFlag [flag enable])
 (^{:tag void} setFlatness [amount])
 (^{:tag void} setGravity [accel_vec])
 (^{:tag void} setLifetimeRandomness [randomness])
 (^{:tag void} setParam [param value])
 (^{:tag void} setParamRandomness [param randomness])
 (^{:tag void} setParamTexture [param texture])
 (^{:tag void} setSpread [degrees])
 (^{:tag void} setTrailColorModifier [texture])
 (^{:tag void} setTrailDivisor [divisor])
 (^{:tag void} setTrailSizeModifier [texture]))
(definterface MGodotRichTextEffect)
(definterface MGodotVisualScriptSelf)
(definterface
 MGodotVehicleBody
 (^{:tag float} getBrake [])
 (^{:tag float} getEngineForce [])
 (^{:tag float} getSteering [])
 (^{:tag void} setBrake [brake])
 (^{:tag void} setEngineForce [engine_force])
 (^{:tag void} setSteering [steering]))
(definterface
 MGodotVisualShaderNodeScalarOp
 (^{:tag int} getOperator [])
 (^{:tag void} setOperator [op]))
(definterface
 MGodotViewport
 (^{:tag godotclj.api.gdscript.IGodotWorld} findWorld [])
 (^{:tag godotclj.api.gdscript.IGodotWorld2D} findWorld2d [])
 (^{:tag godotclj.api.gdscript.IGodotCamera} getCamera [])
 (^{:tag godotclj.bindings.godot.Transform2D} getCanvasTransform [])
 (^{:tag int} getClearMode [])
 (^{:tag int} getDebugDraw [])
 (^{:tag godotclj.bindings.godot.Transform2D} getFinalTransform [])
 (^{:tag godotclj.bindings.godot.Transform2D}
  getGlobalCanvasTransform
  [])
 (^{:tag boolean} getHdr [])
 (^{:tag boolean} getKeep3dLinear [])
 (^{:tag godotclj.api.gdscript.IGodotControl} getModalStackTop [])
 (^{:tag godotclj.bindings.godot.Vector2} getMousePosition [])
 (^{:tag int} getMsaa [])
 (^{:tag boolean} getPhysicsObjectPicking [])
 (^{:tag int} getRenderInfo [info])
 (^{:tag int} getShadowAtlasQuadrantSubdiv [quadrant])
 (^{:tag int} getShadowAtlasSize [])
 (^{:tag godotclj.bindings.godot.Vector2} getSize [])
 (^{:tag godotclj.bindings.godot.Vector2} getSizeOverride [])
 (^{:tag godotclj.api.gdscript.IGodotViewportTexture} getTexture [])
 (^{:tag int} getUpdateMode [])
 (^{:tag int} getUsage [])
 (^{:tag boolean} getUseDebanding [])
 (^{:tag boolean} getUseFxaa [])
 (^{:tag boolean} getVflip [])
 (^{:tag godotclj.bindings.godot.RID} getViewportRid [])
 (^{:tag godotclj.bindings.godot.IndexedRect2} getVisibleRect [])
 (^{:tag godotclj.api.gdscript.IGodotWorld} getWorld [])
 (^{:tag godotclj.api.gdscript.IGodotWorld2D} getWorld2d [])
 (^{:tag godotclj.bindings.godot.Variant} guiGetDragData [])
 (^{:tag boolean} guiHasModalStack [])
 (^{:tag boolean} guiIsDragging [])
 (^{:tag boolean} hasTransparentBackground [])
 (^{:tag void} input [local_event])
 (^{:tag boolean} is3dDisabled [])
 (^{:tag boolean} isAudioListener [])
 (^{:tag boolean} isAudioListener2d [])
 (^{:tag boolean} isHandlingInputLocally [])
 (^{:tag boolean} isInputDisabled [])
 (^{:tag boolean} isInputHandled [])
 (^{:tag boolean} isSizeOverrideEnabled [])
 (^{:tag boolean} isSizeOverrideStretchEnabled [])
 (^{:tag boolean} isSnapControlsToPixelsEnabled [])
 (^{:tag boolean} isUsingOwnWorld [])
 (^{:tag boolean} isUsingRenderDirectToScreen [])
 (^{:tag void} setAsAudioListener [enable])
 (^{:tag void} setAsAudioListener2d [enable])
 (^{:tag void} setAttachToScreenRect [rect])
 (^{:tag void} setCanvasTransform [xform])
 (^{:tag void} setClearMode [mode])
 (^{:tag void} setDebugDraw [debug_draw])
 (^{:tag void} setDisable3d [disable])
 (^{:tag void} setDisableInput [disable])
 (^{:tag void} setGlobalCanvasTransform [xform])
 (^{:tag void} setHandleInputLocally [enable])
 (^{:tag void} setHdr [enable])
 (^{:tag void} setInputAsHandled [])
 (^{:tag void} setKeep3dLinear [keep_3d_linear])
 (^{:tag void} setMsaa [msaa])
 (^{:tag void} setPhysicsObjectPicking [enable])
 (^{:tag void} setShadowAtlasQuadrantSubdiv [quadrant subdiv])
 (^{:tag void} setShadowAtlasSize [size])
 (^{:tag void} setSize [size])
 (^{:tag void} setSizeOverride [enable])
 (^{:tag void} setSizeOverride [enable size])
 (^{:tag void} setSizeOverride [enable size margin])
 (^{:tag void} setSizeOverrideStretch [enabled])
 (^{:tag void} setSnapControlsToPixels [enabled])
 (^{:tag void} setTransparentBackground [enable])
 (^{:tag void} setUpdateMode [mode])
 (^{:tag void} setUsage [usage])
 (^{:tag void} setUseArvr [use])
 (^{:tag void} setUseDebanding [enable])
 (^{:tag void} setUseFxaa [enable])
 (^{:tag void} setUseOwnWorld [enable])
 (^{:tag void} setUseRenderDirectToScreen [enable])
 (^{:tag void} setVflip [enable])
 (^{:tag void} setWorld [world])
 (^{:tag void} setWorld2d [world_2d])
 (^{:tag void} unhandledInput [local_event])
 (^{:tag void} updateWorlds [])
 (^{:tag boolean} useArvr [])
 (^{:tag void} warpMouse [to_position]))
(definterface
 MGodotAudioEffectAmplify
 (^{:tag float} getVolumeDb [])
 (^{:tag void} setVolumeDb [volume]))
(definterface
 MGodotImage
 (^{:tag void} blendRect [src src_rect dst])
 (^{:tag void} blendRectMask [src mask src_rect dst])
 (^{:tag void} blitRect [src src_rect dst])
 (^{:tag void} blitRectMask [src mask src_rect dst])
 (^{:tag void} bumpmapToNormalmap [])
 (^{:tag void} bumpmapToNormalmap [bump_scale])
 (^{:tag void} clearMipmaps [])
 (^{:tag int} compress [mode source lossy_quality])
 (^{:tag void} convert [format])
 (^{:tag void} copyFrom [src])
 (^{:tag void} create [width height use_mipmaps format])
 (^{:tag void} createFromData [width height use_mipmaps format data])
 (^{:tag void} crop [width height])
 (^{:tag int} decompress [])
 (^{:tag int} detectAlpha [])
 (^{:tag void} expandX2Hq2x [])
 (^{:tag void} fill [color])
 (^{:tag void} fixAlphaEdges [])
 (^{:tag void} flipX [])
 (^{:tag void} flipY [])
 (^{:tag int} generateMipmaps [])
 (^{:tag int} generateMipmaps [renormalize])
 (^{:tag godotclj.bindings.godot.PoolByteArray} getData [])
 (^{:tag int} getFormat [])
 (^{:tag int} getHeight [])
 (^{:tag int} getMipmapOffset [mipmap])
 (^{:tag godotclj.bindings.godot.Color} getPixel [x y])
 (^{:tag godotclj.bindings.godot.Color} getPixelv [src])
 (^{:tag godotclj.api.gdscript.IGodotImage} getRect [rect])
 (^{:tag godotclj.bindings.godot.Vector2} getSize [])
 (^{:tag godotclj.bindings.godot.IndexedRect2} getUsedRect [])
 (^{:tag int} getWidth [])
 (^{:tag boolean} hasMipmaps [])
 (^{:tag boolean} isCompressed [])
 (^{:tag boolean} isEmpty [])
 (^{:tag boolean} isInvisible [])
 (^{:tag int} load [path])
 (^{:tag int} loadBmpFromBuffer [buffer])
 (^{:tag int} loadJpgFromBuffer [buffer])
 (^{:tag int} loadPngFromBuffer [buffer])
 (^{:tag int} loadTgaFromBuffer [buffer])
 (^{:tag int} loadWebpFromBuffer [buffer])
 (^{:tag void} lock [])
 (^{:tag void} normalmapToXy [])
 (^{:tag void} premultiplyAlpha [])
 (^{:tag void} resize [width height])
 (^{:tag void} resize [width height interpolation])
 (^{:tag void} resizeToPo2 [])
 (^{:tag void} resizeToPo2 [square])
 (^{:tag void} resizeToPo2 [square interpolation])
 (^{:tag godotclj.api.gdscript.IGodotImage} rgbeToSrgb [])
 (^{:tag int} saveExr [path])
 (^{:tag int} saveExr [path grayscale])
 (^{:tag int} savePng [path])
 (^{:tag godotclj.bindings.godot.PoolByteArray} savePngToBuffer [])
 (^{:tag void} setPixel [x y color])
 (^{:tag void} setPixelv [dst color])
 (^{:tag void} shrinkX2 [])
 (^{:tag void} srgbToLinear [])
 (^{:tag void} unlock []))
(definterface
 MGodotLineEdit
 (^{:tag void} appendAtCursor [text])
 (^{:tag void} clear [])
 (^{:tag boolean} cursorGetBlinkEnabled [])
 (^{:tag float} cursorGetBlinkSpeed [])
 (^{:tag void} cursorSetBlinkEnabled [enabled])
 (^{:tag void} cursorSetBlinkSpeed [blink_speed])
 (^{:tag void} deleteCharAtCursor [])
 (^{:tag void} deleteText [from_column to_column])
 (^{:tag void} deselect [])
 (^{:tag int} getAlign [])
 (^{:tag int} getCursorPosition [])
 (^{:tag boolean} getExpandToTextLength [])
 (^{:tag int} getMaxLength [])
 (^{:tag godotclj.api.gdscript.IGodotPopupMenu} getMenu [])
 (^{:tag String} getPlaceholder [])
 (^{:tag float} getPlaceholderAlpha [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getRightIcon [])
 (^{:tag int} getScrollOffset [])
 (^{:tag String} getSecretCharacter [])
 (^{:tag String} getText [])
 (^{:tag boolean} isClearButtonEnabled [])
 (^{:tag boolean} isContextMenuEnabled [])
 (^{:tag boolean} isEditable [])
 (^{:tag boolean} isSecret [])
 (^{:tag boolean} isSelectingEnabled [])
 (^{:tag boolean} isShortcutKeysEnabled [])
 (^{:tag boolean} isVirtualKeyboardEnabled [])
 (^{:tag void} menuOption [option])
 (^{:tag void} select [])
 (^{:tag void} select [from])
 (^{:tag void} select [from to])
 (^{:tag void} selectAll [])
 (^{:tag void} setAlign [align])
 (^{:tag void} setClearButtonEnabled [enable])
 (^{:tag void} setContextMenuEnabled [enable])
 (^{:tag void} setCursorPosition [position])
 (^{:tag void} setEditable [enabled])
 (^{:tag void} setExpandToTextLength [enabled])
 (^{:tag void} setMaxLength [chars])
 (^{:tag void} setPlaceholder [text])
 (^{:tag void} setPlaceholderAlpha [alpha])
 (^{:tag void} setRightIcon [icon])
 (^{:tag void} setSecret [enabled])
 (^{:tag void} setSecretCharacter [character])
 (^{:tag void} setSelectingEnabled [enable])
 (^{:tag void} setShortcutKeysEnabled [enable])
 (^{:tag void} setText [text])
 (^{:tag void} setVirtualKeyboardEnabled [enable]))
(definterface
 MGodotShaderMaterial
 (^{:tag godotclj.api.gdscript.IGodotShader} getShader [])
 (^{:tag godotclj.bindings.godot.Variant} getShaderParam [param])
 (^{:tag boolean} propertyCanRevert [name])
 (^{:tag godotclj.bindings.godot.Variant} propertyGetRevert [name])
 (^{:tag void} setShader [shader])
 (^{:tag void} setShaderParam [param value]))
(definterface MGodotVisualShaderNodeOuterProduct)
(definterface
 MGodotSlider
 (^{:tag int} getTicks [])
 (^{:tag boolean} getTicksOnBorders [])
 (^{:tag boolean} isEditable [])
 (^{:tag boolean} isScrollable [])
 (^{:tag void} setEditable [editable])
 (^{:tag void} setScrollable [scrollable])
 (^{:tag void} setTicks [count])
 (^{:tag void} setTicksOnBorders [ticks_on_border]))
(definterface MGodotHSlider)
(definterface
 MGodotAnimationNodeBlendSpace1D
 (^{:tag void} addBlendPoint [node pos])
 (^{:tag void} addBlendPoint [node pos at_index])
 (^{:tag int} getBlendPointCount [])
 (^{:tag godotclj.api.gdscript.IGodotAnimationRootNode}
  getBlendPointNode
  [point])
 (^{:tag float} getBlendPointPosition [point])
 (^{:tag float} getMaxSpace [])
 (^{:tag float} getMinSpace [])
 (^{:tag float} getSnap [])
 (^{:tag String} getValueLabel [])
 (^{:tag void} removeBlendPoint [point])
 (^{:tag void} setBlendPointNode [point node])
 (^{:tag void} setBlendPointPosition [point pos])
 (^{:tag void} setMaxSpace [max_space])
 (^{:tag void} setMinSpace [min_space])
 (^{:tag void} setSnap [snap])
 (^{:tag void} setValueLabel [text]))
(definterface
 MGodotVisualScriptBasicTypeConstant
 (^{:tag int} getBasicType [])
 (^{:tag String} getBasicTypeConstant [])
 (^{:tag void} setBasicType [name])
 (^{:tag void} setBasicTypeConstant [name]))
(definterface MGodotVisualShaderNodeFresnel)
(definterface
 MGodotProgressBar
 (^{:tag boolean} isPercentVisible [])
 (^{:tag void} setPercentVisible [visible]))
(definterface MGodotAudioStream (^{:tag float} getLength []))
(definterface
 MGodotAudioStreamGenerator
 (^{:tag float} getBufferLength [])
 (^{:tag float} getMixRate [])
 (^{:tag void} setBufferLength [seconds])
 (^{:tag void} setMixRate [hz]))
(definterface
 MGodotBakedLightmap
 (^{:tag int} bake [])
 (^{:tag int} bake [from_node])
 (^{:tag int} bake [from_node data_save_path])
 (^{:tag int} getBakeQuality [])
 (^{:tag float} getBias [])
 (^{:tag int} getBounces [])
 (^{:tag float} getCaptureCellSize [])
 (^{:tag boolean} getCaptureEnabled [])
 (^{:tag float} getCapturePropagation [])
 (^{:tag int} getCaptureQuality [])
 (^{:tag float} getDefaultTexelsPerUnit [])
 (^{:tag godotclj.bindings.godot.Color} getEnvironmentCustomColor [])
 (^{:tag float} getEnvironmentCustomEnergy [])
 (^{:tag godotclj.api.gdscript.IGodotSky} getEnvironmentCustomSky [])
 (^{:tag godotclj.bindings.godot.Vector3}
  getEnvironmentCustomSkyRotationDegrees
  [])
 (^{:tag godotclj.bindings.godot.Color} getEnvironmentMinLight [])
 (^{:tag int} getEnvironmentMode [])
 (^{:tag godotclj.bindings.godot.Vector3} getExtents [])
 (^{:tag String} getImagePath [])
 (^{:tag godotclj.api.gdscript.IGodotBakedLightmapData}
  getLightData
  [])
 (^{:tag int} getMaxAtlasSize [])
 (^{:tag boolean} isGenerateAtlasEnabled [])
 (^{:tag boolean} isUsingColor [])
 (^{:tag boolean} isUsingDenoiser [])
 (^{:tag boolean} isUsingHdr [])
 (^{:tag void} setBakeQuality [quality])
 (^{:tag void} setBias [bias])
 (^{:tag void} setBounces [bounces])
 (^{:tag void} setCaptureCellSize [capture_cell_size])
 (^{:tag void} setCaptureEnabled [enabled])
 (^{:tag void} setCapturePropagation [propagation])
 (^{:tag void} setCaptureQuality [capture_quality])
 (^{:tag void} setDefaultTexelsPerUnit [texels])
 (^{:tag void} setEnvironmentCustomColor [color])
 (^{:tag void} setEnvironmentCustomEnergy [energy])
 (^{:tag void} setEnvironmentCustomSky [sky])
 (^{:tag void} setEnvironmentCustomSkyRotationDegrees [rotation])
 (^{:tag void} setEnvironmentMinLight [min_light])
 (^{:tag void} setEnvironmentMode [mode])
 (^{:tag void} setExtents [extents])
 (^{:tag void} setGenerateAtlas [enabled])
 (^{:tag void} setImagePath [image_path])
 (^{:tag void} setLightData [data])
 (^{:tag void} setMaxAtlasSize [max_atlas_size])
 (^{:tag void} setUseColor [use_denoiser])
 (^{:tag void} setUseDenoiser [use_denoiser])
 (^{:tag void} setUseHdr [use_denoiser]))
(definterface MGodotVisualScriptSceneTree)
(definterface
 MGodotARVROrigin
 (^{:tag float} getWorldScale [])
 (^{:tag void} setWorldScale [world_scale]))
(definterface
 MGodotAudioEffectEQ
 (^{:tag int} getBandCount [])
 (^{:tag float} getBandGainDb [band_idx])
 (^{:tag void} setBandGainDb [band_idx volume_db]))
(definterface MGodotAudioEffectEQ21)
(definterface
 MGodotSplitContainer
 (^{:tag void} clampSplitOffset [])
 (^{:tag int} getDraggerVisibility [])
 (^{:tag int} getSplitOffset [])
 (^{:tag boolean} isCollapsed [])
 (^{:tag void} setCollapsed [collapsed])
 (^{:tag void} setDraggerVisibility [mode])
 (^{:tag void} setSplitOffset [offset]))
(definterface MGodotHSplitContainer)
(definterface
 MGodotVisualShaderNodeTransformFunc
 (^{:tag int} getFunction [])
 (^{:tag void} setFunction [func]))
(definterface MGodotVisualShaderNodeScalarInterp)
(definterface MGodotEditorResourceConversionPlugin)
(definterface
 MGodotAnimationNodeOneShot
 (^{:tag float} getAutorestartDelay [])
 (^{:tag float} getAutorestartRandomDelay [])
 (^{:tag float} getFadeinTime [])
 (^{:tag float} getFadeoutTime [])
 (^{:tag int} getMixMode [])
 (^{:tag boolean} hasAutorestart [])
 (^{:tag boolean} isUsingSync [])
 (^{:tag void} setAutorestart [enable])
 (^{:tag void} setAutorestartDelay [enable])
 (^{:tag void} setAutorestartRandomDelay [enable])
 (^{:tag void} setFadeinTime [time])
 (^{:tag void} setFadeoutTime [time])
 (^{:tag void} setMixMode [mode])
 (^{:tag void} setUseSync [enable]))
(definterface
 MGodotTranslation
 (^{:tag void} addMessage [src_message xlated_message])
 (^{:tag void} eraseMessage [src_message])
 (^{:tag String} getLocale [])
 (^{:tag String} getMessage [src_message])
 (^{:tag int} getMessageCount [])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  getMessageList
  [])
 (^{:tag void} setLocale [locale]))
(definterface MGodotPHashTranslation (^{:tag void} generate [from]))
(definterface MGodotHScrollBar)
(definterface MGodotVisualShaderNodeOutput)
(definterface
 MGodotWebXRInterface
 (^{:tag godotclj.bindings.godot.PoolVector3Array}
  getBoundsGeometry
  [])
 (^{:tag godotclj.api.gdscript.IGodotARVRPositionalTracker}
  getController
  [controller_id])
 (^{:tag String} getOptionalFeatures [])
 (^{:tag String} getReferenceSpaceType [])
 (^{:tag String} getRequestedReferenceSpaceTypes [])
 (^{:tag String} getRequiredFeatures [])
 (^{:tag String} getSessionMode [])
 (^{:tag String} getVisibilityState [])
 (^{:tag void} isSessionSupported [session_mode])
 (^{:tag void} setOptionalFeatures [optional_features])
 (^{:tag void}
  setRequestedReferenceSpaceTypes
  [requested_reference_space_types])
 (^{:tag void} setRequiredFeatures [required_features])
 (^{:tag void} setSessionMode [session_mode]))
(definterface
 MGodotSphereShape
 (^{:tag float} getRadius [])
 (^{:tag void} setRadius [radius]))
(definterface MGodotPopupDialog)
(definterface
 MGodotUPNPDevice
 (^{:tag int} addPortMapping [port])
 (^{:tag int} addPortMapping [port port_internal])
 (^{:tag int} addPortMapping [port port_internal desc])
 (^{:tag int} addPortMapping [port port_internal desc proto])
 (^{:tag int} addPortMapping [port port_internal desc proto duration])
 (^{:tag int} deletePortMapping [port])
 (^{:tag int} deletePortMapping [port proto])
 (^{:tag String} getDescriptionUrl [])
 (^{:tag String} getIgdControlUrl [])
 (^{:tag String} getIgdOurAddr [])
 (^{:tag String} getIgdServiceType [])
 (^{:tag int} getIgdStatus [])
 (^{:tag String} getServiceType [])
 (^{:tag boolean} isValidGateway [])
 (^{:tag String} queryExternalAddress [])
 (^{:tag void} setDescriptionUrl [url])
 (^{:tag void} setIgdControlUrl [url])
 (^{:tag void} setIgdOurAddr [addr])
 (^{:tag void} setIgdServiceType [type])
 (^{:tag void} setIgdStatus [status])
 (^{:tag void} setServiceType [type]))
(definterface MGodotVisualShaderNodeDeterminant)
(definterface
 MGodotStreamTexture
 (^{:tag String} getLoadPath [])
 (^{:tag int} load [path]))
(definterface
 MGodotDynamicFontData
 (^{:tag String} getFontPath [])
 (^{:tag int} getHinting [])
 (^{:tag boolean} isAntialiased [])
 (^{:tag void} setAntialiased [antialiased])
 (^{:tag void} setFontPath [path])
 (^{:tag void} setHinting [mode]))
(definterface
 MGodotVisualShaderNodeVectorFunc
 (^{:tag int} getFunction [])
 (^{:tag void} setFunction [func]))
(definterface
 MGodotBoneAttachment
 (^{:tag String} getBoneName [])
 (^{:tag void} setBoneName [bone_name]))
(definterface
 MGodotTree
 (^{:tag boolean} areColumnTitlesVisible [])
 (^{:tag void} clear [])
 (^{:tag godotclj.api.gdscript.IGodotTreeItem} createItem [])
 (^{:tag godotclj.api.gdscript.IGodotTreeItem} createItem [parent])
 (^{:tag godotclj.api.gdscript.IGodotTreeItem}
  createItem
  [parent idx])
 (^{:tag boolean} editSelected [])
 (^{:tag void} ensureCursorIsVisible [])
 (^{:tag boolean} getAllowReselect [])
 (^{:tag boolean} getAllowRmbSelect [])
 (^{:tag int} getColumnAtPosition [position])
 (^{:tag String} getColumnTitle [column])
 (^{:tag int} getColumnWidth [column])
 (^{:tag int} getColumns [])
 (^{:tag godotclj.bindings.godot.IndexedRect2} getCustomPopupRect [])
 (^{:tag int} getDropModeFlags [])
 (^{:tag int} getDropSectionAtPosition [position])
 (^{:tag godotclj.api.gdscript.IGodotTreeItem} getEdited [])
 (^{:tag int} getEditedColumn [])
 (^{:tag godotclj.bindings.godot.IndexedRect2} getItemAreaRect [item])
 (^{:tag godotclj.bindings.godot.IndexedRect2}
  getItemAreaRect
  [item column])
 (^{:tag godotclj.api.gdscript.IGodotTreeItem}
  getItemAtPosition
  [position])
 (^{:tag godotclj.api.gdscript.IGodotTreeItem} getNextSelected [from])
 (^{:tag int} getPressedButton [])
 (^{:tag godotclj.api.gdscript.IGodotTreeItem} getRoot [])
 (^{:tag godotclj.bindings.godot.Vector2} getScroll [])
 (^{:tag int} getSelectMode [])
 (^{:tag godotclj.api.gdscript.IGodotTreeItem} getSelected [])
 (^{:tag int} getSelectedColumn [])
 (^{:tag boolean} isFoldingHidden [])
 (^{:tag boolean} isRootHidden [])
 (^{:tag void} scrollToItem [item])
 (^{:tag void} setAllowReselect [allow])
 (^{:tag void} setAllowRmbSelect [allow])
 (^{:tag void} setColumnExpand [column expand])
 (^{:tag void} setColumnMinWidth [column min_width])
 (^{:tag void} setColumnTitle [column title])
 (^{:tag void} setColumnTitlesVisible [visible])
 (^{:tag void} setColumns [amount])
 (^{:tag void} setDropModeFlags [flags])
 (^{:tag void} setHideFolding [hide])
 (^{:tag void} setHideRoot [enable])
 (^{:tag void} setSelectMode [mode]))
(definterface
 MGodotPhysicsBody2D
 (^{:tag void} addCollisionExceptionWith [body])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  getCollisionExceptions
  [])
 (^{:tag int} getCollisionLayer [])
 (^{:tag boolean} getCollisionLayerBit [bit])
 (^{:tag int} getCollisionMask [])
 (^{:tag boolean} getCollisionMaskBit [bit])
 (^{:tag void} removeCollisionExceptionWith [body])
 (^{:tag void} setCollisionLayer [layer])
 (^{:tag void} setCollisionLayerBit [bit value])
 (^{:tag void} setCollisionMask [mask])
 (^{:tag void} setCollisionMaskBit [bit value]))
(definterface
 MGodotInputEventScreenDrag
 (^{:tag int} getIndex [])
 (^{:tag godotclj.bindings.godot.Vector2} getPosition [])
 (^{:tag godotclj.bindings.godot.Vector2} getRelative [])
 (^{:tag godotclj.bindings.godot.Vector2} getSpeed [])
 (^{:tag void} setIndex [index])
 (^{:tag void} setPosition [position])
 (^{:tag void} setRelative [relative])
 (^{:tag void} setSpeed [speed]))
(definterface
 MGodotButtonGroup
 (^{:tag godotclj.bindings.godot.IndexedArray} getButtons [])
 (^{:tag godotclj.api.gdscript.IGodotBaseButton} getPressedButton []))
(definterface
 MGodotAudioEffectRecord
 (^{:tag int} getFormat [])
 (^{:tag godotclj.api.gdscript.IGodotAudioStreamSample}
  getRecording
  [])
 (^{:tag boolean} isRecordingActive [])
 (^{:tag void} setFormat [format])
 (^{:tag void} setRecordingActive [record]))
(definterface
 MGodotCrypto
 (^{:tag godotclj.bindings.godot.PoolByteArray}
  generateRandomBytes
  [size])
 (^{:tag godotclj.api.gdscript.IGodotCryptoKey} generateRsa [size])
 (^{:tag godotclj.api.gdscript.IGodotX509Certificate}
  generateSelfSignedCertificate
  [key])
 (^{:tag godotclj.api.gdscript.IGodotX509Certificate}
  generateSelfSignedCertificate
  [key issuer_name])
 (^{:tag godotclj.api.gdscript.IGodotX509Certificate}
  generateSelfSignedCertificate
  [key issuer_name not_before])
 (^{:tag godotclj.api.gdscript.IGodotX509Certificate}
  generateSelfSignedCertificate
  [key issuer_name not_before not_after]))
(definterface
 MGodotGeometryInstance
 (^{:tag int} getCastShadowsSetting [])
 (^{:tag float} getExtraCullMargin [])
 (^{:tag boolean} getFlag [flag])
 (^{:tag boolean} getGenerateLightmap [])
 (^{:tag int} getLightmapScale [])
 (^{:tag float} getLodMaxDistance [])
 (^{:tag float} getLodMaxHysteresis [])
 (^{:tag float} getLodMinDistance [])
 (^{:tag float} getLodMinHysteresis [])
 (^{:tag godotclj.api.gdscript.IGodotMaterial} getMaterialOverride [])
 (^{:tag void} setCastShadowsSetting [shadow_casting_setting])
 (^{:tag void} setCustomAabb [aabb])
 (^{:tag void} setExtraCullMargin [margin])
 (^{:tag void} setFlag [flag value])
 (^{:tag void} setGenerateLightmap [enabled])
 (^{:tag void} setLightmapScale [scale])
 (^{:tag void} setLodMaxDistance [mode])
 (^{:tag void} setLodMaxHysteresis [mode])
 (^{:tag void} setLodMinDistance [mode])
 (^{:tag void} setLodMinHysteresis [mode])
 (^{:tag void} setMaterialOverride [material]))
(definterface
 MGodotCSGShape
 (^{:tag int} getCollisionLayer [])
 (^{:tag boolean} getCollisionLayerBit [bit])
 (^{:tag int} getCollisionMask [])
 (^{:tag boolean} getCollisionMaskBit [bit])
 (^{:tag godotclj.bindings.godot.IndexedArray} getMeshes [])
 (^{:tag int} getOperation [])
 (^{:tag float} getSnap [])
 (^{:tag boolean} isCalculatingTangents [])
 (^{:tag boolean} isRootShape [])
 (^{:tag boolean} isUsingCollision [])
 (^{:tag void} setCalculateTangents [enabled])
 (^{:tag void} setCollisionLayer [layer])
 (^{:tag void} setCollisionLayerBit [bit value])
 (^{:tag void} setCollisionMask [mask])
 (^{:tag void} setCollisionMaskBit [bit value])
 (^{:tag void} setOperation [operation])
 (^{:tag void} setSnap [snap])
 (^{:tag void} setUseCollision [operation]))
(definterface
 MGodotCSGPrimitive
 (^{:tag boolean} isInvertingFaces [])
 (^{:tag void} setInvertFaces [invert_faces]))
(definterface
 MGodotCSGCylinder
 (^{:tag float} getHeight [])
 (^{:tag godotclj.api.gdscript.IGodotMaterial} getMaterial [])
 (^{:tag float} getRadius [])
 (^{:tag int} getSides [])
 (^{:tag boolean} getSmoothFaces [])
 (^{:tag boolean} isCone [])
 (^{:tag void} setCone [cone])
 (^{:tag void} setHeight [height])
 (^{:tag void} setMaterial [material])
 (^{:tag void} setRadius [radius])
 (^{:tag void} setSides [sides])
 (^{:tag void} setSmoothFaces [smooth_faces]))
(definterface
 MGodotExternalTexture
 (^{:tag int} getExternalTextureId [])
 (^{:tag void} setSize [size]))
(definterface
 MGodotVisualScriptLists
 (^{:tag void} addInputDataPort [type name index])
 (^{:tag void} addOutputDataPort [type name index])
 (^{:tag void} removeInputDataPort [index])
 (^{:tag void} removeOutputDataPort [index])
 (^{:tag void} setInputDataPortName [index name])
 (^{:tag void} setInputDataPortType [index type])
 (^{:tag void} setOutputDataPortName [index name])
 (^{:tag void} setOutputDataPortType [index type]))
(definterface
 MGodotJSONParseResult
 (^{:tag int} getError [])
 (^{:tag int} getErrorLine [])
 (^{:tag String} getErrorString [])
 (^{:tag godotclj.bindings.godot.Variant} getResult [])
 (^{:tag void} setError [error])
 (^{:tag void} setErrorLine [error_line])
 (^{:tag void} setErrorString [error_string])
 (^{:tag void} setResult [result]))
(definterface
 MGodotPhysicsServer
 (^{:tag void} areaAddShape [area shape])
 (^{:tag void} areaAddShape [area shape transform])
 (^{:tag void} areaAddShape [area shape transform disabled])
 (^{:tag void} areaAttachObjectInstanceId [area id])
 (^{:tag void} areaClearShapes [area])
 (^{:tag godotclj.bindings.godot.RID} areaCreate [])
 (^{:tag int} areaGetObjectInstanceId [area])
 (^{:tag godotclj.bindings.godot.Variant} areaGetParam [area param])
 (^{:tag godotclj.bindings.godot.RID} areaGetShape [area shape_idx])
 (^{:tag int} areaGetShapeCount [area])
 (^{:tag godotclj.bindings.godot.Transform}
  areaGetShapeTransform
  [area shape_idx])
 (^{:tag godotclj.bindings.godot.RID} areaGetSpace [area])
 (^{:tag int} areaGetSpaceOverrideMode [area])
 (^{:tag godotclj.bindings.godot.Transform} areaGetTransform [area])
 (^{:tag boolean} areaIsRayPickable [area])
 (^{:tag void} areaRemoveShape [area shape_idx])
 (^{:tag void} areaSetAreaMonitorCallback [area receiver method])
 (^{:tag void} areaSetCollisionLayer [area layer])
 (^{:tag void} areaSetCollisionMask [area mask])
 (^{:tag void} areaSetMonitorCallback [area receiver method])
 (^{:tag void} areaSetMonitorable [area monitorable])
 (^{:tag void} areaSetParam [area param value])
 (^{:tag void} areaSetRayPickable [area enable])
 (^{:tag void} areaSetShape [area shape_idx shape])
 (^{:tag void} areaSetShapeDisabled [area shape_idx disabled])
 (^{:tag void} areaSetShapeTransform [area shape_idx transform])
 (^{:tag void} areaSetSpace [area space])
 (^{:tag void} areaSetSpaceOverrideMode [area mode])
 (^{:tag void} areaSetTransform [area transform])
 (^{:tag void} bodyAddCentralForce [body force])
 (^{:tag void} bodyAddCollisionException [body excepted_body])
 (^{:tag void} bodyAddForce [body force position])
 (^{:tag void} bodyAddShape [body shape])
 (^{:tag void} bodyAddShape [body shape transform])
 (^{:tag void} bodyAddShape [body shape transform disabled])
 (^{:tag void} bodyAddTorque [body torque])
 (^{:tag void} bodyApplyCentralImpulse [body impulse])
 (^{:tag void} bodyApplyImpulse [body position impulse])
 (^{:tag void} bodyApplyTorqueImpulse [body impulse])
 (^{:tag void} bodyAttachObjectInstanceId [body id])
 (^{:tag void} bodyClearShapes [body])
 (^{:tag godotclj.bindings.godot.RID} bodyCreate [])
 (^{:tag godotclj.bindings.godot.RID} bodyCreate [mode])
 (^{:tag godotclj.bindings.godot.RID} bodyCreate [mode init_sleeping])
 (^{:tag int} bodyGetCollisionLayer [body])
 (^{:tag int} bodyGetCollisionMask [body])
 (^{:tag godotclj.api.gdscript.IGodotPhysicsDirectBodyState}
  bodyGetDirectState
  [body])
 (^{:tag float} bodyGetKinematicSafeMargin [body])
 (^{:tag int} bodyGetMaxContactsReported [body])
 (^{:tag int} bodyGetMode [body])
 (^{:tag int} bodyGetObjectInstanceId [body])
 (^{:tag float} bodyGetParam [body param])
 (^{:tag godotclj.bindings.godot.RID} bodyGetShape [body shape_idx])
 (^{:tag int} bodyGetShapeCount [body])
 (^{:tag godotclj.bindings.godot.Transform}
  bodyGetShapeTransform
  [body shape_idx])
 (^{:tag godotclj.bindings.godot.RID} bodyGetSpace [body])
 (^{:tag godotclj.bindings.godot.Variant} bodyGetState [body state])
 (^{:tag boolean} bodyIsAxisLocked [body axis])
 (^{:tag boolean} bodyIsContinuousCollisionDetectionEnabled [body])
 (^{:tag boolean} bodyIsOmittingForceIntegration [body])
 (^{:tag boolean} bodyIsRayPickable [body])
 (^{:tag void} bodyRemoveCollisionException [body excepted_body])
 (^{:tag void} bodyRemoveShape [body shape_idx])
 (^{:tag void} bodySetAxisLock [body axis lock])
 (^{:tag void} bodySetAxisVelocity [body axis_velocity])
 (^{:tag void} bodySetCollisionLayer [body layer])
 (^{:tag void} bodySetCollisionMask [body mask])
 (^{:tag void}
  bodySetEnableContinuousCollisionDetection
  [body enable])
 (^{:tag void} bodySetForceIntegrationCallback [body receiver method])
 (^{:tag void}
  bodySetForceIntegrationCallback
  [body receiver method userdata])
 (^{:tag void} bodySetKinematicSafeMargin [body margin])
 (^{:tag void} bodySetMaxContactsReported [body amount])
 (^{:tag void} bodySetMode [body mode])
 (^{:tag void} bodySetOmitForceIntegration [body enable])
 (^{:tag void} bodySetParam [body param value])
 (^{:tag void} bodySetRayPickable [body enable])
 (^{:tag void} bodySetShape [body shape_idx shape])
 (^{:tag void} bodySetShapeDisabled [body shape_idx disabled])
 (^{:tag void} bodySetShapeTransform [body shape_idx transform])
 (^{:tag void} bodySetSpace [body space])
 (^{:tag void} bodySetState [body state value])
 (^{:tag float} coneTwistJointGetParam [joint param])
 (^{:tag void} coneTwistJointSetParam [joint param value])
 (^{:tag void} freeRid [rid])
 (^{:tag boolean} generic6dofJointGetFlag [joint axis flag])
 (^{:tag float} generic6dofJointGetParam [joint axis param])
 (^{:tag void} generic6dofJointSetFlag [joint axis flag enable])
 (^{:tag void} generic6dofJointSetParam [joint axis param value])
 (^{:tag int} getProcessInfo [process_info])
 (^{:tag boolean} hingeJointGetFlag [joint flag])
 (^{:tag float} hingeJointGetParam [joint param])
 (^{:tag void} hingeJointSetFlag [joint flag enabled])
 (^{:tag void} hingeJointSetParam [joint param value])
 (^{:tag godotclj.bindings.godot.RID}
  jointCreateConeTwist
  [body_A local_ref_A body_B local_ref_B])
 (^{:tag godotclj.bindings.godot.RID}
  jointCreateGeneric6dof
  [body_A local_ref_A body_B local_ref_B])
 (^{:tag godotclj.bindings.godot.RID}
  jointCreateHinge
  [body_A hinge_A body_B hinge_B])
 (^{:tag godotclj.bindings.godot.RID}
  jointCreatePin
  [body_A local_A body_B local_B])
 (^{:tag godotclj.bindings.godot.RID}
  jointCreateSlider
  [body_A local_ref_A body_B local_ref_B])
 (^{:tag int} jointGetSolverPriority [joint])
 (^{:tag int} jointGetType [joint])
 (^{:tag void} jointSetSolverPriority [joint priority])
 (^{:tag godotclj.bindings.godot.Vector3} pinJointGetLocalA [joint])
 (^{:tag godotclj.bindings.godot.Vector3} pinJointGetLocalB [joint])
 (^{:tag float} pinJointGetParam [joint param])
 (^{:tag void} pinJointSetLocalA [joint local_A])
 (^{:tag void} pinJointSetLocalB [joint local_B])
 (^{:tag void} pinJointSetParam [joint param value])
 (^{:tag void} setActive [active])
 (^{:tag godotclj.bindings.godot.RID} shapeCreate [type])
 (^{:tag godotclj.bindings.godot.Variant} shapeGetData [shape])
 (^{:tag int} shapeGetType [shape])
 (^{:tag void} shapeSetData [shape data])
 (^{:tag float} sliderJointGetParam [joint param])
 (^{:tag void} sliderJointSetParam [joint param value])
 (^{:tag godotclj.bindings.godot.RID} spaceCreate [])
 (^{:tag godotclj.api.gdscript.IGodotPhysicsDirectSpaceState}
  spaceGetDirectState
  [space])
 (^{:tag float} spaceGetParam [space param])
 (^{:tag boolean} spaceIsActive [space])
 (^{:tag void} spaceSetActive [space active])
 (^{:tag void} spaceSetParam [space param value]))
(definterface
 MGodotTextEdit
 (^{:tag void} addColorRegion [begin_key end_key color])
 (^{:tag void} addColorRegion [begin_key end_key color line_only])
 (^{:tag void} addKeywordColor [keyword color])
 (^{:tag boolean} canFold [line])
 (^{:tag void} centerViewportToCursor [])
 (^{:tag void} clearColors [])
 (^{:tag void} clearUndoHistory [])
 (^{:tag void} copy [])
 (^{:tag boolean} cursorGetBlinkEnabled [])
 (^{:tag float} cursorGetBlinkSpeed [])
 (^{:tag int} cursorGetColumn [])
 (^{:tag int} cursorGetLine [])
 (^{:tag boolean} cursorIsBlockMode [])
 (^{:tag void} cursorSetBlinkEnabled [enable])
 (^{:tag void} cursorSetBlinkSpeed [blink_speed])
 (^{:tag void} cursorSetBlockMode [enable])
 (^{:tag void} cursorSetColumn [column])
 (^{:tag void} cursorSetColumn [column adjust_viewport])
 (^{:tag void} cursorSetLine [line])
 (^{:tag void} cursorSetLine [line adjust_viewport])
 (^{:tag void} cursorSetLine [line adjust_viewport can_be_hidden])
 (^{:tag void}
  cursorSetLine
  [line adjust_viewport can_be_hidden wrap_index])
 (^{:tag void} cut [])
 (^{:tag void} deselect [])
 (^{:tag void} drawMinimap [draw])
 (^{:tag void} foldAllLines [])
 (^{:tag void} foldLine [line])
 (^{:tag godotclj.bindings.godot.IndexedArray} getBreakpoints [])
 (^{:tag int} getHScroll [])
 (^{:tag godotclj.bindings.godot.Color} getKeywordColor [keyword])
 (^{:tag String} getLine [line])
 (^{:tag int} getLineCount [])
 (^{:tag godotclj.api.gdscript.IGodotPopupMenu} getMenu [])
 (^{:tag int} getMinimapWidth [])
 (^{:tag int} getSelectionFromColumn [])
 (^{:tag int} getSelectionFromLine [])
 (^{:tag String} getSelectionText [])
 (^{:tag int} getSelectionToColumn [])
 (^{:tag int} getSelectionToLine [])
 (^{:tag String} getText [])
 (^{:tag float} getVScroll [])
 (^{:tag float} getVScrollSpeed [])
 (^{:tag String} getWordUnderCursor [])
 (^{:tag boolean} hasKeywordColor [keyword])
 (^{:tag void} insertTextAtCursor [text])
 (^{:tag boolean} isBreakpointGutterEnabled [])
 (^{:tag boolean} isContextMenuEnabled [])
 (^{:tag boolean} isDrawingFoldGutter [])
 (^{:tag boolean} isDrawingMinimap [])
 (^{:tag boolean} isDrawingSpaces [])
 (^{:tag boolean} isDrawingTabs [])
 (^{:tag boolean} isFolded [line])
 (^{:tag boolean} isHidingEnabled [])
 (^{:tag boolean} isHighlightAllOccurrencesEnabled [])
 (^{:tag boolean} isHighlightCurrentLineEnabled [])
 (^{:tag boolean} isLineHidden [line])
 (^{:tag boolean} isLineSetAsBookmark [line])
 (^{:tag boolean} isLineSetAsBreakpoint [line])
 (^{:tag boolean} isLineSetAsSafe [line])
 (^{:tag boolean} isOverridingSelectedFontColor [])
 (^{:tag boolean} isReadonly [])
 (^{:tag boolean} isRightClickMovingCaret [])
 (^{:tag boolean} isSelectingEnabled [])
 (^{:tag boolean} isSelectionActive [])
 (^{:tag boolean} isShortcutKeysEnabled [])
 (^{:tag boolean} isShowLineNumbersEnabled [])
 (^{:tag boolean} isSmoothScrollEnabled [])
 (^{:tag boolean} isSyntaxColoringEnabled [])
 (^{:tag boolean} isVirtualKeyboardEnabled [])
 (^{:tag boolean} isWrapEnabled [])
 (^{:tag void} menuOption [option])
 (^{:tag void} paste [])
 (^{:tag void} redo [])
 (^{:tag void} removeBreakpoints [])
 (^{:tag godotclj.bindings.godot.PoolIntArray}
  search
  [key flags from_line from_column])
 (^{:tag void} select [from_line from_column to_line to_column])
 (^{:tag void} selectAll [])
 (^{:tag void} setBreakpointGutterEnabled [enable])
 (^{:tag void} setContextMenuEnabled [enable])
 (^{:tag void} setDrawFoldGutter [arg0])
 (^{:tag void} setDrawSpaces [arg0])
 (^{:tag void} setDrawTabs [arg0])
 (^{:tag void} setHScroll [value])
 (^{:tag void} setHidingEnabled [enable])
 (^{:tag void} setHighlightAllOccurrences [enable])
 (^{:tag void} setHighlightCurrentLine [enabled])
 (^{:tag void} setLine [line new_text])
 (^{:tag void} setLineAsBookmark [line bookmark])
 (^{:tag void} setLineAsBreakpoint [line breakpoint])
 (^{:tag void} setLineAsHidden [line enable])
 (^{:tag void} setLineAsSafe [line safe])
 (^{:tag void} setMinimapWidth [width])
 (^{:tag void} setOverrideSelectedFontColor [override])
 (^{:tag void} setReadonly [enable])
 (^{:tag void} setRightClickMovesCaret [enable])
 (^{:tag void} setSelectingEnabled [enable])
 (^{:tag void} setShortcutKeysEnabled [enable])
 (^{:tag void} setShowLineNumbers [enable])
 (^{:tag void} setSmoothScrollEnable [enable])
 (^{:tag void} setSyntaxColoring [enable])
 (^{:tag void} setText [text])
 (^{:tag void} setVScroll [value])
 (^{:tag void} setVScrollSpeed [speed])
 (^{:tag void} setVirtualKeyboardEnabled [enable])
 (^{:tag void} setWrapEnabled [enable])
 (^{:tag void} toggleFoldLine [line])
 (^{:tag void} undo [])
 (^{:tag void} unfoldLine [line])
 (^{:tag void} unhideAllLines []))
(definterface MGodotVisualShaderNodeVectorDistance)
(definterface
 MGodotScript
 (^{:tag boolean} canInstance [])
 (^{:tag godotclj.api.gdscript.IGodotScript} getBaseScript [])
 (^{:tag String} getInstanceBaseType [])
 (^{:tag godotclj.bindings.godot.Variant}
  getPropertyDefaultValue
  [property])
 (^{:tag godotclj.bindings.godot.Dictionary} getScriptConstantMap [])
 (^{:tag godotclj.bindings.godot.IndexedArray} getScriptMethodList [])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  getScriptPropertyList
  [])
 (^{:tag godotclj.bindings.godot.IndexedArray} getScriptSignalList [])
 (^{:tag String} getSourceCode [])
 (^{:tag boolean} hasScriptSignal [signal_name])
 (^{:tag boolean} hasSourceCode [])
 (^{:tag boolean} instanceHas [base_object])
 (^{:tag boolean} isTool [])
 (^{:tag int} reload [])
 (^{:tag int} reload [keep_state])
 (^{:tag void} setSourceCode [source]))
(definterface
 MGodotNativeScript
 (^{:tag String} getClassDocumentation [])
 (^{:tag String} getClassName [])
 (^{:tag godotclj.api.gdscript.IGodotGDNativeLibrary} getLibrary [])
 (^{:tag String} getMethodDocumentation [method])
 (^{:tag String} getPropertyDocumentation [path])
 (^{:tag String} getScriptClassIconPath [])
 (^{:tag String} getScriptClassName [])
 (^{:tag String} getSignalDocumentation [signal_name])
 (^{:tag godotclj.bindings.godot.Variant} new [])
 (^{:tag godotclj.bindings.godot.Variant} new [v1])
 (^{:tag godotclj.bindings.godot.Variant} new [v1 v2])
 (^{:tag godotclj.bindings.godot.Variant} new [v1 v2 v3])
 (^{:tag godotclj.bindings.godot.Variant} new [v1 v2 v3 v4])
 (^{:tag godotclj.bindings.godot.Variant} new [v1 v2 v3 v4 v5])
 (^{:tag void} setClassName [class_name])
 (^{:tag void} setLibrary [library])
 (^{:tag void} setScriptClassIconPath [icon_path])
 (^{:tag void} setScriptClassName [class_name]))
(definterface
 MGodotGDScriptFunctionState
 (^{:tag boolean} isValid [])
 (^{:tag boolean} isValid [extended_check])
 (^{:tag godotclj.bindings.godot.Variant} resume [])
 (^{:tag godotclj.bindings.godot.Variant} resume [arg]))
(definterface
 MGodotVisualScriptComment
 (^{:tag String} getDescription [])
 (^{:tag godotclj.bindings.godot.Vector2} getSize [])
 (^{:tag String} getTitle [])
 (^{:tag void} setDescription [description])
 (^{:tag void} setSize [size])
 (^{:tag void} setTitle [title]))
(definterface
 MGodotJoint
 (^{:tag boolean} getExcludeNodesFromCollision [])
 (^{:tag godotclj.bindings.godot.NodePath} getNodeA [])
 (^{:tag godotclj.bindings.godot.NodePath} getNodeB [])
 (^{:tag int} getSolverPriority [])
 (^{:tag void} setExcludeNodesFromCollision [enable])
 (^{:tag void} setNodeA [node])
 (^{:tag void} setNodeB [node])
 (^{:tag void} setSolverPriority [priority]))
(definterface
 MGodotHingeJoint
 (^{:tag boolean} getFlag [flag])
 (^{:tag float} getParam [param])
 (^{:tag void} setFlag [flag enabled])
 (^{:tag void} setParam [param value]))
(definterface
 MGodotConcavePolygonShape
 (^{:tag godotclj.bindings.godot.PoolVector3Array} getFaces [])
 (^{:tag void} setFaces [faces]))
(definterface
 MGodotTextureLayered
 (^{:tag void} create [width height depth format])
 (^{:tag void} create [width height depth format flags])
 (^{:tag int} getDepth [])
 (^{:tag int} getFlags [])
 (^{:tag int} getFormat [])
 (^{:tag int} getHeight [])
 (^{:tag godotclj.api.gdscript.IGodotImage} getLayerData [layer])
 (^{:tag int} getWidth [])
 (^{:tag void} setDataPartial [image x_offset y_offset layer])
 (^{:tag void} setDataPartial [image x_offset y_offset layer mipmap])
 (^{:tag void} setFlags [flags])
 (^{:tag void} setLayerData [image layer]))
(definterface MGodotTexture3D)
(definterface
 MGodotSpatialMaterial
 (^{:tag godotclj.bindings.godot.Color} getAlbedo [])
 (^{:tag float} getAlphaScissorThreshold [])
 (^{:tag float} getAnisotropy [])
 (^{:tag float} getAoLightAffect [])
 (^{:tag int} getAoTextureChannel [])
 (^{:tag int} getBillboardMode [])
 (^{:tag int} getBlendMode [])
 (^{:tag float} getClearcoat [])
 (^{:tag float} getClearcoatGloss [])
 (^{:tag int} getCullMode [])
 (^{:tag boolean} getDepthDeepParallaxFlipBinormal [])
 (^{:tag boolean} getDepthDeepParallaxFlipTangent [])
 (^{:tag int} getDepthDeepParallaxMaxLayers [])
 (^{:tag int} getDepthDeepParallaxMinLayers [])
 (^{:tag int} getDepthDrawMode [])
 (^{:tag float} getDepthScale [])
 (^{:tag int} getDetailBlendMode [])
 (^{:tag int} getDetailUv [])
 (^{:tag int} getDiffuseMode [])
 (^{:tag int} getDistanceFade [])
 (^{:tag float} getDistanceFadeMaxDistance [])
 (^{:tag float} getDistanceFadeMinDistance [])
 (^{:tag godotclj.bindings.godot.Color} getEmission [])
 (^{:tag float} getEmissionEnergy [])
 (^{:tag int} getEmissionOperator [])
 (^{:tag boolean} getFeature [feature])
 (^{:tag boolean} getFlag [flag])
 (^{:tag float} getGrow [])
 (^{:tag float} getLineWidth [])
 (^{:tag float} getMetallic [])
 (^{:tag int} getMetallicTextureChannel [])
 (^{:tag float} getNormalScale [])
 (^{:tag int} getParticlesAnimHFrames [])
 (^{:tag boolean} getParticlesAnimLoop [])
 (^{:tag int} getParticlesAnimVFrames [])
 (^{:tag float} getPointSize [])
 (^{:tag float} getProximityFadeDistance [])
 (^{:tag float} getRefraction [])
 (^{:tag int} getRefractionTextureChannel [])
 (^{:tag float} getRim [])
 (^{:tag float} getRimTint [])
 (^{:tag float} getRoughness [])
 (^{:tag int} getRoughnessTextureChannel [])
 (^{:tag float} getSpecular [])
 (^{:tag int} getSpecularMode [])
 (^{:tag float} getSubsurfaceScatteringStrength [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getTexture [param])
 (^{:tag godotclj.bindings.godot.Color} getTransmission [])
 (^{:tag godotclj.bindings.godot.Vector3} getUv1Offset [])
 (^{:tag godotclj.bindings.godot.Vector3} getUv1Scale [])
 (^{:tag float} getUv1TriplanarBlendSharpness [])
 (^{:tag godotclj.bindings.godot.Vector3} getUv2Offset [])
 (^{:tag godotclj.bindings.godot.Vector3} getUv2Scale [])
 (^{:tag float} getUv2TriplanarBlendSharpness [])
 (^{:tag boolean} isDepthDeepParallaxEnabled [])
 (^{:tag boolean} isGrowEnabled [])
 (^{:tag boolean} isProximityFadeEnabled [])
 (^{:tag void} setAlbedo [albedo])
 (^{:tag void} setAlphaScissorThreshold [threshold])
 (^{:tag void} setAnisotropy [anisotropy])
 (^{:tag void} setAoLightAffect [amount])
 (^{:tag void} setAoTextureChannel [channel])
 (^{:tag void} setBillboardMode [mode])
 (^{:tag void} setBlendMode [blend_mode])
 (^{:tag void} setClearcoat [clearcoat])
 (^{:tag void} setClearcoatGloss [clearcoat_gloss])
 (^{:tag void} setCullMode [cull_mode])
 (^{:tag void} setDepthDeepParallax [enable])
 (^{:tag void} setDepthDeepParallaxFlipBinormal [flip])
 (^{:tag void} setDepthDeepParallaxFlipTangent [flip])
 (^{:tag void} setDepthDeepParallaxMaxLayers [layer])
 (^{:tag void} setDepthDeepParallaxMinLayers [layer])
 (^{:tag void} setDepthDrawMode [depth_draw_mode])
 (^{:tag void} setDepthScale [depth_scale])
 (^{:tag void} setDetailBlendMode [detail_blend_mode])
 (^{:tag void} setDetailUv [detail_uv])
 (^{:tag void} setDiffuseMode [diffuse_mode])
 (^{:tag void} setDistanceFade [mode])
 (^{:tag void} setDistanceFadeMaxDistance [distance])
 (^{:tag void} setDistanceFadeMinDistance [distance])
 (^{:tag void} setEmission [emission])
 (^{:tag void} setEmissionEnergy [emission_energy])
 (^{:tag void} setEmissionOperator [operator])
 (^{:tag void} setFeature [feature enable])
 (^{:tag void} setFlag [flag enable])
 (^{:tag void} setGrow [amount])
 (^{:tag void} setGrowEnabled [enable])
 (^{:tag void} setLineWidth [line_width])
 (^{:tag void} setMetallic [metallic])
 (^{:tag void} setMetallicTextureChannel [channel])
 (^{:tag void} setNormalScale [normal_scale])
 (^{:tag void} setParticlesAnimHFrames [frames])
 (^{:tag void} setParticlesAnimLoop [loop])
 (^{:tag void} setParticlesAnimVFrames [frames])
 (^{:tag void} setPointSize [point_size])
 (^{:tag void} setProximityFade [enabled])
 (^{:tag void} setProximityFadeDistance [distance])
 (^{:tag void} setRefraction [refraction])
 (^{:tag void} setRefractionTextureChannel [channel])
 (^{:tag void} setRim [rim])
 (^{:tag void} setRimTint [rim_tint])
 (^{:tag void} setRoughness [roughness])
 (^{:tag void} setRoughnessTextureChannel [channel])
 (^{:tag void} setSpecular [specular])
 (^{:tag void} setSpecularMode [specular_mode])
 (^{:tag void} setSubsurfaceScatteringStrength [strength])
 (^{:tag void} setTexture [param texture])
 (^{:tag void} setTransmission [transmission])
 (^{:tag void} setUv1Offset [offset])
 (^{:tag void} setUv1Scale [scale])
 (^{:tag void} setUv1TriplanarBlendSharpness [sharpness])
 (^{:tag void} setUv2Offset [offset])
 (^{:tag void} setUv2Scale [scale])
 (^{:tag void} setUv2TriplanarBlendSharpness [sharpness]))
(definterface
 MGodotViewportTexture
 (^{:tag godotclj.bindings.godot.NodePath} getViewportPathInScene [])
 (^{:tag void} setViewportPathInScene [path]))
(definterface
 MGodotAnimationPlayer
 (^{:tag int} addAnimation [name animation])
 (^{:tag void} advance [delta])
 (^{:tag String} animationGetNext [anim_from])
 (^{:tag void} animationSetNext [anim_from anim_to])
 (^{:tag void} clearCaches [])
 (^{:tag void} clearQueue [])
 (^{:tag String} findAnimation [animation])
 (^{:tag godotclj.api.gdscript.IGodotAnimation} getAnimation [name])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  getAnimationList
  [])
 (^{:tag int} getAnimationProcessMode [])
 (^{:tag String} getAssignedAnimation [])
 (^{:tag String} getAutoplay [])
 (^{:tag float} getBlendTime [anim_from anim_to])
 (^{:tag String} getCurrentAnimation [])
 (^{:tag float} getCurrentAnimationLength [])
 (^{:tag float} getCurrentAnimationPosition [])
 (^{:tag float} getDefaultBlendTime [])
 (^{:tag int} getMethodCallMode [])
 (^{:tag float} getPlayingSpeed [])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray} getQueue [])
 (^{:tag godotclj.bindings.godot.NodePath} getRoot [])
 (^{:tag float} getSpeedScale [])
 (^{:tag boolean} hasAnimation [name])
 (^{:tag boolean} isActive [])
 (^{:tag boolean} isPlaying [])
 (^{:tag void} play [])
 (^{:tag void} play [name])
 (^{:tag void} play [name custom_blend])
 (^{:tag void} play [name custom_blend custom_speed])
 (^{:tag void} play [name custom_blend custom_speed from_end])
 (^{:tag void} playBackwards [])
 (^{:tag void} playBackwards [name])
 (^{:tag void} playBackwards [name custom_blend])
 (^{:tag void} queue [name])
 (^{:tag void} removeAnimation [name])
 (^{:tag void} renameAnimation [name newname])
 (^{:tag void} seek [seconds])
 (^{:tag void} seek [seconds update])
 (^{:tag void} setActive [active])
 (^{:tag void} setAnimationProcessMode [mode])
 (^{:tag void} setAssignedAnimation [anim])
 (^{:tag void} setAutoplay [name])
 (^{:tag void} setBlendTime [anim_from anim_to sec])
 (^{:tag void} setCurrentAnimation [anim])
 (^{:tag void} setDefaultBlendTime [sec])
 (^{:tag void} setMethodCallMode [mode])
 (^{:tag void} setRoot [path])
 (^{:tag void} setSpeedScale [speed])
 (^{:tag void} stop [])
 (^{:tag void} stop [reset]))
(definterface
 MGodotEditorResourcePreview
 (^{:tag void} addPreviewGenerator [generator])
 (^{:tag void} checkForInvalidation [path])
 (^{:tag void}
  queueEditedResourcePreview
  [resource receiver receiver_func userdata])
 (^{:tag void}
  queueResourcePreview
  [path receiver receiver_func userdata])
 (^{:tag void} removePreviewGenerator [generator]))
(definterface
 MGodotVisualShaderNodeBooleanConstant
 (^{:tag boolean} getConstant [])
 (^{:tag void} setConstant [value]))
(definterface
 MGodotResourceInteractiveLoader
 (^{:tag godotclj.api.gdscript.IGodotResource} getResource [])
 (^{:tag int} getStage [])
 (^{:tag int} getStageCount [])
 (^{:tag int} poll [])
 (^{:tag int} wait []))
(definterface
 MGodotVisualScriptFunctionCall
 (^{:tag godotclj.bindings.godot.NodePath} getBasePath [])
 (^{:tag String} getBaseScript [])
 (^{:tag String} getBaseType [])
 (^{:tag int} getBasicType [])
 (^{:tag int} getCallMode [])
 (^{:tag String} getFunction [])
 (^{:tag int} getRpcCallMode [])
 (^{:tag String} getSingleton [])
 (^{:tag int} getUseDefaultArgs [])
 (^{:tag boolean} getValidate [])
 (^{:tag void} setBasePath [base_path])
 (^{:tag void} setBaseScript [base_script])
 (^{:tag void} setBaseType [base_type])
 (^{:tag void} setBasicType [basic_type])
 (^{:tag void} setCallMode [mode])
 (^{:tag void} setFunction [function])
 (^{:tag void} setRpcCallMode [mode])
 (^{:tag void} setSingleton [singleton])
 (^{:tag void} setUseDefaultArgs [amount])
 (^{:tag void} setValidate [enable]))
(definterface
 MGodotGIProbe
 (^{:tag void} bake [])
 (^{:tag void} bake [from_node])
 (^{:tag void} bake [from_node create_visual_debug])
 (^{:tag void} debugBake [])
 (^{:tag float} getBias [])
 (^{:tag int} getDynamicRange [])
 (^{:tag float} getEnergy [])
 (^{:tag godotclj.bindings.godot.Vector3} getExtents [])
 (^{:tag float} getNormalBias [])
 (^{:tag godotclj.api.gdscript.IGodotGIProbeData} getProbeData [])
 (^{:tag float} getPropagation [])
 (^{:tag int} getSubdiv [])
 (^{:tag boolean} isCompressed [])
 (^{:tag boolean} isInterior [])
 (^{:tag void} setBias [max])
 (^{:tag void} setCompress [enable])
 (^{:tag void} setDynamicRange [max])
 (^{:tag void} setEnergy [max])
 (^{:tag void} setExtents [extents])
 (^{:tag void} setInterior [enable])
 (^{:tag void} setNormalBias [max])
 (^{:tag void} setProbeData [data])
 (^{:tag void} setPropagation [max])
 (^{:tag void} setSubdiv [subdiv]))
(definterface
 MGodotStreamPeer
 (^{:tag int} get16 [])
 (^{:tag int} get32 [])
 (^{:tag int} get64 [])
 (^{:tag int} get8 [])
 (^{:tag int} getAvailableBytes [])
 (^{:tag godotclj.bindings.godot.IndexedArray} getData [bytes])
 (^{:tag float} getDouble [])
 (^{:tag float} getFloat [])
 (^{:tag godotclj.bindings.godot.IndexedArray} getPartialData [bytes])
 (^{:tag String} getString [])
 (^{:tag String} getString [bytes])
 (^{:tag int} getU16 [])
 (^{:tag int} getU32 [])
 (^{:tag int} getU64 [])
 (^{:tag int} getU8 [])
 (^{:tag String} getUtf8String [])
 (^{:tag String} getUtf8String [bytes])
 (^{:tag godotclj.bindings.godot.Variant} getVar [])
 (^{:tag godotclj.bindings.godot.Variant} getVar [allow_objects])
 (^{:tag boolean} isBigEndianEnabled [])
 (^{:tag void} put16 [value])
 (^{:tag void} put32 [value])
 (^{:tag void} put64 [value])
 (^{:tag void} put8 [value])
 (^{:tag int} putData [data])
 (^{:tag void} putDouble [value])
 (^{:tag void} putFloat [value])
 (^{:tag godotclj.bindings.godot.IndexedArray} putPartialData [data])
 (^{:tag void} putString [value])
 (^{:tag void} putU16 [value])
 (^{:tag void} putU32 [value])
 (^{:tag void} putU64 [value])
 (^{:tag void} putU8 [value])
 (^{:tag void} putUtf8String [value])
 (^{:tag void} putVar [value])
 (^{:tag void} putVar [value full_objects])
 (^{:tag void} setBigEndian [enable]))
(definterface MGodotStreamPeerGDNative)
(definterface MGodotVisualScriptComposeArray)
(definterface
 MGodotAnimationNodeBlendSpace2D
 (^{:tag void} addBlendPoint [node pos])
 (^{:tag void} addBlendPoint [node pos at_index])
 (^{:tag void} addTriangle [x y z])
 (^{:tag void} addTriangle [x y z at_index])
 (^{:tag boolean} getAutoTriangles [])
 (^{:tag int} getBlendMode [])
 (^{:tag int} getBlendPointCount [])
 (^{:tag godotclj.api.gdscript.IGodotAnimationRootNode}
  getBlendPointNode
  [point])
 (^{:tag godotclj.bindings.godot.Vector2}
  getBlendPointPosition
  [point])
 (^{:tag godotclj.bindings.godot.Vector2} getMaxSpace [])
 (^{:tag godotclj.bindings.godot.Vector2} getMinSpace [])
 (^{:tag godotclj.bindings.godot.Vector2} getSnap [])
 (^{:tag int} getTriangleCount [])
 (^{:tag int} getTrianglePoint [triangle point])
 (^{:tag String} getXLabel [])
 (^{:tag String} getYLabel [])
 (^{:tag void} removeBlendPoint [point])
 (^{:tag void} removeTriangle [triangle])
 (^{:tag void} setAutoTriangles [enable])
 (^{:tag void} setBlendMode [mode])
 (^{:tag void} setBlendPointNode [point node])
 (^{:tag void} setBlendPointPosition [point pos])
 (^{:tag void} setMaxSpace [max_space])
 (^{:tag void} setMinSpace [min_space])
 (^{:tag void} setSnap [snap])
 (^{:tag void} setXLabel [text])
 (^{:tag void} setYLabel [text]))
(definterface
 MGodotArea2D
 (^{:tag float} getAngularDamp [])
 (^{:tag String} getAudioBusName [])
 (^{:tag int} getCollisionLayer [])
 (^{:tag boolean} getCollisionLayerBit [bit])
 (^{:tag int} getCollisionMask [])
 (^{:tag boolean} getCollisionMaskBit [bit])
 (^{:tag float} getGravity [])
 (^{:tag float} getGravityDistanceScale [])
 (^{:tag godotclj.bindings.godot.Vector2} getGravityVector [])
 (^{:tag float} getLinearDamp [])
 (^{:tag godotclj.bindings.godot.IndexedArray} getOverlappingAreas [])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  getOverlappingBodies
  [])
 (^{:tag float} getPriority [])
 (^{:tag int} getSpaceOverrideMode [])
 (^{:tag boolean} isGravityAPoint [])
 (^{:tag boolean} isMonitorable [])
 (^{:tag boolean} isMonitoring [])
 (^{:tag boolean} isOverridingAudioBus [])
 (^{:tag boolean} overlapsArea [area])
 (^{:tag boolean} overlapsBody [body])
 (^{:tag void} setAngularDamp [angular_damp])
 (^{:tag void} setAudioBusName [name])
 (^{:tag void} setAudioBusOverride [enable])
 (^{:tag void} setCollisionLayer [collision_layer])
 (^{:tag void} setCollisionLayerBit [bit value])
 (^{:tag void} setCollisionMask [collision_mask])
 (^{:tag void} setCollisionMaskBit [bit value])
 (^{:tag void} setGravity [gravity])
 (^{:tag void} setGravityDistanceScale [distance_scale])
 (^{:tag void} setGravityIsPoint [enable])
 (^{:tag void} setGravityVector [vector])
 (^{:tag void} setLinearDamp [linear_damp])
 (^{:tag void} setMonitorable [enable])
 (^{:tag void} setMonitoring [enable])
 (^{:tag void} setPriority [priority])
 (^{:tag void} setSpaceOverrideMode [space_override_mode]))
(definterface
 MGodotVisualScriptOperator
 (^{:tag int} getOperator [])
 (^{:tag int} getTyped [])
 (^{:tag void} setOperator [op])
 (^{:tag void} setTyped [type]))
(definterface
 MGodotKinematicBody
 (^{:tag boolean} getAxisLock [axis])
 (^{:tag godotclj.bindings.godot.Vector3} getFloorNormal [])
 (^{:tag godotclj.bindings.godot.Vector3} getFloorVelocity [])
 (^{:tag float} getSafeMargin [])
 (^{:tag godotclj.api.gdscript.IGodotKinematicCollision}
  getSlideCollision
  [slide_idx])
 (^{:tag int} getSlideCount [])
 (^{:tag boolean} isOnCeiling [])
 (^{:tag boolean} isOnFloor [])
 (^{:tag boolean} isOnWall [])
 (^{:tag godotclj.api.gdscript.IGodotKinematicCollision}
  moveAndCollide
  [rel_vec])
 (^{:tag godotclj.api.gdscript.IGodotKinematicCollision}
  moveAndCollide
  [rel_vec infinite_inertia])
 (^{:tag godotclj.api.gdscript.IGodotKinematicCollision}
  moveAndCollide
  [rel_vec infinite_inertia exclude_raycast_shapes])
 (^{:tag godotclj.api.gdscript.IGodotKinematicCollision}
  moveAndCollide
  [rel_vec infinite_inertia exclude_raycast_shapes test_only])
 (^{:tag godotclj.bindings.godot.Vector3}
  moveAndSlide
  [linear_velocity])
 (^{:tag godotclj.bindings.godot.Vector3}
  moveAndSlide
  [linear_velocity up_direction])
 (^{:tag godotclj.bindings.godot.Vector3}
  moveAndSlide
  [linear_velocity up_direction stop_on_slope])
 (^{:tag godotclj.bindings.godot.Vector3}
  moveAndSlide
  [linear_velocity up_direction stop_on_slope max_slides])
 (^{:tag godotclj.bindings.godot.Vector3}
  moveAndSlide
  [linear_velocity
   up_direction
   stop_on_slope
   max_slides
   floor_max_angle])
 (^{:tag godotclj.bindings.godot.Vector3}
  moveAndSlide
  [linear_velocity
   up_direction
   stop_on_slope
   max_slides
   floor_max_angle
   infinite_inertia])
 (^{:tag godotclj.bindings.godot.Vector3}
  moveAndSlideWithSnap
  [linear_velocity snap])
 (^{:tag godotclj.bindings.godot.Vector3}
  moveAndSlideWithSnap
  [linear_velocity snap up_direction])
 (^{:tag godotclj.bindings.godot.Vector3}
  moveAndSlideWithSnap
  [linear_velocity snap up_direction stop_on_slope])
 (^{:tag godotclj.bindings.godot.Vector3}
  moveAndSlideWithSnap
  [linear_velocity snap up_direction stop_on_slope max_slides])
 (^{:tag godotclj.bindings.godot.Vector3}
  moveAndSlideWithSnap
  [linear_velocity
   snap
   up_direction
   stop_on_slope
   max_slides
   floor_max_angle])
 (^{:tag godotclj.bindings.godot.Vector3}
  moveAndSlideWithSnap
  [linear_velocity
   snap
   up_direction
   stop_on_slope
   max_slides
   floor_max_angle
   infinite_inertia])
 (^{:tag void} setAxisLock [axis lock])
 (^{:tag void} setSafeMargin [pixels])
 (^{:tag boolean} testMove [from rel_vec])
 (^{:tag boolean} testMove [from rel_vec infinite_inertia]))
(definterface
 MGodotVisualShaderNodeGroupBase
 (^{:tag void} addInputPort [id type name])
 (^{:tag void} addOutputPort [id type name])
 (^{:tag void} clearInputPorts [])
 (^{:tag void} clearOutputPorts [])
 (^{:tag int} getFreeInputPortId [])
 (^{:tag int} getFreeOutputPortId [])
 (^{:tag int} getInputPortCount [])
 (^{:tag String} getInputs [])
 (^{:tag int} getOutputPortCount [])
 (^{:tag String} getOutputs [])
 (^{:tag godotclj.bindings.godot.Vector2} getSize [])
 (^{:tag boolean} hasInputPort [id])
 (^{:tag boolean} hasOutputPort [id])
 (^{:tag boolean} isValidPortName [name])
 (^{:tag void} removeInputPort [id])
 (^{:tag void} removeOutputPort [id])
 (^{:tag void} setInputPortName [id name])
 (^{:tag void} setInputPortType [id type])
 (^{:tag void} setInputs [inputs])
 (^{:tag void} setOutputPortName [id name])
 (^{:tag void} setOutputPortType [id type])
 (^{:tag void} setOutputs [outputs])
 (^{:tag void} setSize [size]))
(definterface
 MGodotVisualShaderNodeExpression
 (^{:tag String} getExpression [])
 (^{:tag void} setExpression [expression]))
(definterface MGodotVisualShaderNodeGlobalExpression)
(definterface
 MGodotPhysicsDirectBodyState
 (^{:tag void} addCentralForce [force])
 (^{:tag void} addForce [force position])
 (^{:tag void} addTorque [torque])
 (^{:tag void} applyCentralImpulse [j])
 (^{:tag void} applyImpulse [position j])
 (^{:tag void} applyTorqueImpulse [j])
 (^{:tag godotclj.bindings.godot.Vector3} getAngularVelocity [])
 (^{:tag godotclj.bindings.godot.Vector3} getCenterOfMass [])
 (^{:tag godotclj.bindings.godot.RID}
  getContactCollider
  [contact_idx])
 (^{:tag int} getContactColliderId [contact_idx])
 (^{:tag godotclj.api.gdscript.IGodotObject}
  getContactColliderObject
  [contact_idx])
 (^{:tag godotclj.bindings.godot.Vector3}
  getContactColliderPosition
  [contact_idx])
 (^{:tag int} getContactColliderShape [contact_idx])
 (^{:tag godotclj.bindings.godot.Vector3}
  getContactColliderVelocityAtPosition
  [contact_idx])
 (^{:tag int} getContactCount [])
 (^{:tag float} getContactImpulse [contact_idx])
 (^{:tag godotclj.bindings.godot.Vector3}
  getContactLocalNormal
  [contact_idx])
 (^{:tag godotclj.bindings.godot.Vector3}
  getContactLocalPosition
  [contact_idx])
 (^{:tag int} getContactLocalShape [contact_idx])
 (^{:tag godotclj.bindings.godot.Vector3} getInverseInertia [])
 (^{:tag float} getInverseMass [])
 (^{:tag godotclj.bindings.godot.Vector3} getLinearVelocity [])
 (^{:tag godotclj.bindings.godot.Basis} getPrincipalInertiaAxes [])
 (^{:tag godotclj.api.gdscript.IGodotPhysicsDirectSpaceState}
  getSpaceState
  [])
 (^{:tag float} getStep [])
 (^{:tag float} getTotalAngularDamp [])
 (^{:tag godotclj.bindings.godot.Vector3} getTotalGravity [])
 (^{:tag float} getTotalLinearDamp [])
 (^{:tag godotclj.bindings.godot.Transform} getTransform [])
 (^{:tag void} integrateForces [])
 (^{:tag boolean} isSleeping [])
 (^{:tag void} setAngularVelocity [velocity])
 (^{:tag void} setLinearVelocity [velocity])
 (^{:tag void} setSleepState [enabled])
 (^{:tag void} setTransform [transform]))
(definterface
 MGodotRichTextLabel
 (^{:tag void} addImage [image])
 (^{:tag void} addImage [image width])
 (^{:tag void} addImage [image width height])
 (^{:tag void} addText [text])
 (^{:tag int} appendBbcode [bbcode])
 (^{:tag void} clear [])
 (^{:tag String} getBbcode [])
 (^{:tag int} getContentHeight [])
 (^{:tag godotclj.bindings.godot.IndexedArray} getEffects [])
 (^{:tag int} getLineCount [])
 (^{:tag float} getPercentVisible [])
 (^{:tag int} getTabSize [])
 (^{:tag String} getText [])
 (^{:tag int} getTotalCharacterCount [])
 (^{:tag godotclj.api.gdscript.IGodotVScrollBar} getVScroll [])
 (^{:tag int} getVisibleCharacters [])
 (^{:tag int} getVisibleLineCount [])
 (^{:tag void} installEffect [effect])
 (^{:tag boolean} isFitContentHeightEnabled [])
 (^{:tag boolean} isMetaUnderlined [])
 (^{:tag boolean} isOverridingSelectedFontColor [])
 (^{:tag boolean} isScrollActive [])
 (^{:tag boolean} isScrollFollowing [])
 (^{:tag boolean} isSelectionEnabled [])
 (^{:tag boolean} isUsingBbcode [])
 (^{:tag void} newline [])
 (^{:tag int} parseBbcode [bbcode])
 (^{:tag godotclj.bindings.godot.Dictionary}
  parseExpressionsForValues
  [expressions])
 (^{:tag void} pop [])
 (^{:tag void} pushAlign [align])
 (^{:tag void} pushBold [])
 (^{:tag void} pushBoldItalics [])
 (^{:tag void} pushCell [])
 (^{:tag void} pushColor [color])
 (^{:tag void} pushFont [font])
 (^{:tag void} pushIndent [level])
 (^{:tag void} pushItalics [])
 (^{:tag void} pushList [type])
 (^{:tag void} pushMeta [data])
 (^{:tag void} pushMono [])
 (^{:tag void} pushNormal [])
 (^{:tag void} pushStrikethrough [])
 (^{:tag void} pushTable [columns])
 (^{:tag void} pushUnderline [])
 (^{:tag boolean} removeLine [line])
 (^{:tag void} scrollToLine [line])
 (^{:tag void} setBbcode [text])
 (^{:tag void} setEffects [effects])
 (^{:tag void} setFitContentHeight [enabled])
 (^{:tag void} setMetaUnderline [enable])
 (^{:tag void} setOverrideSelectedFontColor [override])
 (^{:tag void} setPercentVisible [percent_visible])
 (^{:tag void} setScrollActive [active])
 (^{:tag void} setScrollFollow [follow])
 (^{:tag void} setSelectionEnabled [enabled])
 (^{:tag void} setTabSize [spaces])
 (^{:tag void} setTableColumnExpand [column expand ratio])
 (^{:tag void} setText [text])
 (^{:tag void} setUseBbcode [enable])
 (^{:tag void} setVisibleCharacters [amount]))
(definterface
 MGodotRigidBody2D
 (^{:tag void} addCentralForce [force])
 (^{:tag void} addForce [offset force])
 (^{:tag void} addTorque [torque])
 (^{:tag void} applyCentralImpulse [impulse])
 (^{:tag void} applyImpulse [offset impulse])
 (^{:tag void} applyTorqueImpulse [torque])
 (^{:tag float} getAngularDamp [])
 (^{:tag float} getAngularVelocity [])
 (^{:tag godotclj.bindings.godot.Vector2} getAppliedForce [])
 (^{:tag float} getAppliedTorque [])
 (^{:tag float} getBounce [])
 (^{:tag godotclj.bindings.godot.IndexedArray} getCollidingBodies [])
 (^{:tag int} getContinuousCollisionDetectionMode [])
 (^{:tag float} getFriction [])
 (^{:tag float} getGravityScale [])
 (^{:tag float} getInertia [])
 (^{:tag float} getLinearDamp [])
 (^{:tag godotclj.bindings.godot.Vector2} getLinearVelocity [])
 (^{:tag float} getMass [])
 (^{:tag int} getMaxContactsReported [])
 (^{:tag int} getMode [])
 (^{:tag godotclj.api.gdscript.IGodotPhysicsMaterial}
  getPhysicsMaterialOverride
  [])
 (^{:tag float} getWeight [])
 (^{:tag boolean} isAbleToSleep [])
 (^{:tag boolean} isContactMonitorEnabled [])
 (^{:tag boolean} isSleeping [])
 (^{:tag boolean} isUsingCustomIntegrator [])
 (^{:tag void} setAngularDamp [angular_damp])
 (^{:tag void} setAngularVelocity [angular_velocity])
 (^{:tag void} setAppliedForce [force])
 (^{:tag void} setAppliedTorque [torque])
 (^{:tag void} setAxisVelocity [axis_velocity])
 (^{:tag void} setBounce [bounce])
 (^{:tag void} setCanSleep [able_to_sleep])
 (^{:tag void} setContactMonitor [enabled])
 (^{:tag void} setContinuousCollisionDetectionMode [mode])
 (^{:tag void} setFriction [friction])
 (^{:tag void} setGravityScale [gravity_scale])
 (^{:tag void} setInertia [inertia])
 (^{:tag void} setLinearDamp [linear_damp])
 (^{:tag void} setLinearVelocity [linear_velocity])
 (^{:tag void} setMass [mass])
 (^{:tag void} setMaxContactsReported [amount])
 (^{:tag void} setMode [mode])
 (^{:tag void} setPhysicsMaterialOverride [physics_material_override])
 (^{:tag void} setSleeping [sleeping])
 (^{:tag void} setUseCustomIntegrator [enable])
 (^{:tag void} setWeight [weight])
 (^{:tag boolean} testMotion [motion])
 (^{:tag boolean} testMotion [motion infinite_inertia])
 (^{:tag boolean} testMotion [motion infinite_inertia margin])
 (^{:tag boolean} testMotion [motion infinite_inertia margin result]))
(definterface
 MGodotJSONRPC
 (^{:tag godotclj.bindings.godot.Dictionary}
  makeNotification
  [method params])
 (^{:tag godotclj.bindings.godot.Dictionary}
  makeRequest
  [method params id])
 (^{:tag godotclj.bindings.godot.Dictionary} makeResponse [result id])
 (^{:tag godotclj.bindings.godot.Dictionary}
  makeResponseError
  [code message])
 (^{:tag godotclj.bindings.godot.Dictionary}
  makeResponseError
  [code message id])
 (^{:tag godotclj.bindings.godot.Variant} processAction [action])
 (^{:tag godotclj.bindings.godot.Variant}
  processAction
  [action recurse])
 (^{:tag String} processString [action])
 (^{:tag void} setScope [scope target]))
(definterface
 MGodotOpenSimplexNoise
 (^{:tag godotclj.api.gdscript.IGodotImage} getImage [width height])
 (^{:tag float} getLacunarity [])
 (^{:tag float} getNoise1d [x])
 (^{:tag float} getNoise2d [x y])
 (^{:tag float} getNoise2dv [pos])
 (^{:tag float} getNoise3d [x y z])
 (^{:tag float} getNoise3dv [pos])
 (^{:tag float} getNoise4d [x y z w])
 (^{:tag int} getOctaves [])
 (^{:tag float} getPeriod [])
 (^{:tag float} getPersistence [])
 (^{:tag godotclj.api.gdscript.IGodotImage} getSeamlessImage [size])
 (^{:tag int} getSeed [])
 (^{:tag void} setLacunarity [lacunarity])
 (^{:tag void} setOctaves [octave_count])
 (^{:tag void} setPeriod [period])
 (^{:tag void} setPersistence [persistence])
 (^{:tag void} setSeed [seed]))
(definterface MGodotVisualShaderNodeCustom)
(definterface MGodotAnimationNodeOutput)
(definterface
 MGodotGraphNode
 (^{:tag void} clearAllSlots [])
 (^{:tag void} clearSlot [idx])
 (^{:tag godotclj.bindings.godot.Color} getConnectionInputColor [idx])
 (^{:tag int} getConnectionInputCount [])
 (^{:tag godotclj.bindings.godot.Vector2}
  getConnectionInputPosition
  [idx])
 (^{:tag int} getConnectionInputType [idx])
 (^{:tag godotclj.bindings.godot.Color}
  getConnectionOutputColor
  [idx])
 (^{:tag int} getConnectionOutputCount [])
 (^{:tag godotclj.bindings.godot.Vector2}
  getConnectionOutputPosition
  [idx])
 (^{:tag int} getConnectionOutputType [idx])
 (^{:tag godotclj.bindings.godot.Vector2} getOffset [])
 (^{:tag int} getOverlay [])
 (^{:tag godotclj.bindings.godot.Color} getSlotColorLeft [idx])
 (^{:tag godotclj.bindings.godot.Color} getSlotColorRight [idx])
 (^{:tag int} getSlotTypeLeft [idx])
 (^{:tag int} getSlotTypeRight [idx])
 (^{:tag String} getTitle [])
 (^{:tag boolean} isCloseButtonVisible [])
 (^{:tag boolean} isComment [])
 (^{:tag boolean} isResizable [])
 (^{:tag boolean} isSelected [])
 (^{:tag boolean} isSlotEnabledLeft [idx])
 (^{:tag boolean} isSlotEnabledRight [idx])
 (^{:tag void} setComment [comment])
 (^{:tag void} setOffset [offset])
 (^{:tag void} setOverlay [overlay])
 (^{:tag void} setResizable [resizable])
 (^{:tag void} setSelected [selected])
 (^{:tag void} setShowCloseButton [show])
 (^{:tag void}
  setSlot
  [idx
   enable_left
   type_left
   color_left
   enable_right
   type_right
   color_right])
 (^{:tag void}
  setSlot
  [idx
   enable_left
   type_left
   color_left
   enable_right
   type_right
   color_right
   custom_left])
 (^{:tag void}
  setSlot
  [idx
   enable_left
   type_left
   color_left
   enable_right
   type_right
   color_right
   custom_left
   custom_right])
 (^{:tag void} setTitle [title]))
(definterface MGodotVBoxContainer)
(definterface
 MGodotFileSystemDock
 (^{:tag boolean} canDropDataFw [arg0 arg1 arg2])
 (^{:tag void} dropDataFw [arg0 arg1 arg2])
 (^{:tag godotclj.bindings.godot.Variant} getDragDataFw [arg0 arg1])
 (^{:tag void} navigateToPath [arg0]))
(definterface
 MGodotCanvasLayer
 (^{:tag godotclj.bindings.godot.RID} getCanvas [])
 (^{:tag godotclj.api.gdscript.IGodotNode} getCustomViewport [])
 (^{:tag float} getFollowViewportScale [])
 (^{:tag int} getLayer [])
 (^{:tag godotclj.bindings.godot.Vector2} getOffset [])
 (^{:tag float} getRotation [])
 (^{:tag float} getRotationDegrees [])
 (^{:tag godotclj.bindings.godot.Vector2} getScale [])
 (^{:tag godotclj.bindings.godot.Transform2D} getTransform [])
 (^{:tag boolean} isFollowingViewport [])
 (^{:tag void} setCustomViewport [viewport])
 (^{:tag void} setFollowViewport [enable])
 (^{:tag void} setFollowViewportScale [scale])
 (^{:tag void} setLayer [layer])
 (^{:tag void} setOffset [offset])
 (^{:tag void} setRotation [radians])
 (^{:tag void} setRotationDegrees [degrees])
 (^{:tag void} setScale [scale])
 (^{:tag void} setTransform [transform]))
(definterface
 MGodotParallaxBackground
 (^{:tag godotclj.bindings.godot.Vector2} getLimitBegin [])
 (^{:tag godotclj.bindings.godot.Vector2} getLimitEnd [])
 (^{:tag godotclj.bindings.godot.Vector2} getScrollBaseOffset [])
 (^{:tag godotclj.bindings.godot.Vector2} getScrollBaseScale [])
 (^{:tag godotclj.bindings.godot.Vector2} getScrollOffset [])
 (^{:tag boolean} isIgnoreCameraZoom [])
 (^{:tag void} setIgnoreCameraZoom [ignore])
 (^{:tag void} setLimitBegin [ofs])
 (^{:tag void} setLimitEnd [ofs])
 (^{:tag void} setScrollBaseOffset [ofs])
 (^{:tag void} setScrollBaseScale [scale])
 (^{:tag void} setScrollOffset [ofs]))
(definterface MGodotVisualShaderNodeTransformCompose)
(definterface
 MGodotInputEventMouse
 (^{:tag int} getButtonMask [])
 (^{:tag godotclj.bindings.godot.Vector2} getGlobalPosition [])
 (^{:tag godotclj.bindings.godot.Vector2} getPosition [])
 (^{:tag void} setButtonMask [button_mask])
 (^{:tag void} setGlobalPosition [global_position])
 (^{:tag void} setPosition [position]))
(definterface
 MGodotInputEventMouseButton
 (^{:tag int} getButtonIndex [])
 (^{:tag float} getFactor [])
 (^{:tag boolean} isDoubleclick [])
 (^{:tag void} setButtonIndex [button_index])
 (^{:tag void} setDoubleclick [doubleclick])
 (^{:tag void} setFactor [factor])
 (^{:tag void} setPressed [pressed]))
(definterface
 MGodotRemoteTransform2D
 (^{:tag void} forceUpdateCache [])
 (^{:tag godotclj.bindings.godot.NodePath} getRemoteNode [])
 (^{:tag boolean} getUpdatePosition [])
 (^{:tag boolean} getUpdateRotation [])
 (^{:tag boolean} getUpdateScale [])
 (^{:tag boolean} getUseGlobalCoordinates [])
 (^{:tag void} setRemoteNode [path])
 (^{:tag void} setUpdatePosition [update_remote_position])
 (^{:tag void} setUpdateRotation [update_remote_rotation])
 (^{:tag void} setUpdateScale [update_remote_scale])
 (^{:tag void} setUseGlobalCoordinates [use_global_coordinates]))
(definterface
 MGodotRegExMatch
 (^{:tag int} getEnd [])
 (^{:tag int} getEnd [name])
 (^{:tag int} getGroupCount [])
 (^{:tag godotclj.bindings.godot.Dictionary} getNames [])
 (^{:tag int} getStart [])
 (^{:tag int} getStart [name])
 (^{:tag String} getString [])
 (^{:tag String} getString [name])
 (^{:tag godotclj.bindings.godot.IndexedArray} getStrings [])
 (^{:tag String} getSubject []))
(definterface
 MGodotTouchScreenButton
 (^{:tag String} getAction [])
 (^{:tag godotclj.api.gdscript.IGodotBitMap} getBitmask [])
 (^{:tag godotclj.api.gdscript.IGodotShape2D} getShape [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getTexture [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getTexturePressed [])
 (^{:tag int} getVisibilityMode [])
 (^{:tag boolean} isPassbyPressEnabled [])
 (^{:tag boolean} isPressed [])
 (^{:tag boolean} isShapeCentered [])
 (^{:tag boolean} isShapeVisible [])
 (^{:tag void} setAction [action])
 (^{:tag void} setBitmask [bitmask])
 (^{:tag void} setPassbyPress [enabled])
 (^{:tag void} setShape [shape])
 (^{:tag void} setShapeCentered [bool])
 (^{:tag void} setShapeVisible [bool])
 (^{:tag void} setTexture [texture])
 (^{:tag void} setTexturePressed [texture_pressed])
 (^{:tag void} setVisibilityMode [mode]))
(definterface
 MGodotHashingContext
 (^{:tag godotclj.bindings.godot.PoolByteArray} finish [])
 (^{:tag int} start [type])
 (^{:tag int} update [chunk]))
(definterface MGodotSpotLight)
(definterface
 MGodotVisualShaderNodeScalarDerivativeFunc
 (^{:tag int} getFunction [])
 (^{:tag void} setFunction [func]))
(definterface
 MGodotKinematicBody2D
 (^{:tag godotclj.bindings.godot.Vector2} getFloorNormal [])
 (^{:tag godotclj.bindings.godot.Vector2} getFloorVelocity [])
 (^{:tag float} getSafeMargin [])
 (^{:tag godotclj.api.gdscript.IGodotKinematicCollision2D}
  getSlideCollision
  [slide_idx])
 (^{:tag int} getSlideCount [])
 (^{:tag boolean} isOnCeiling [])
 (^{:tag boolean} isOnFloor [])
 (^{:tag boolean} isOnWall [])
 (^{:tag boolean} isSyncToPhysicsEnabled [])
 (^{:tag godotclj.api.gdscript.IGodotKinematicCollision2D}
  moveAndCollide
  [rel_vec])
 (^{:tag godotclj.api.gdscript.IGodotKinematicCollision2D}
  moveAndCollide
  [rel_vec infinite_inertia])
 (^{:tag godotclj.api.gdscript.IGodotKinematicCollision2D}
  moveAndCollide
  [rel_vec infinite_inertia exclude_raycast_shapes])
 (^{:tag godotclj.api.gdscript.IGodotKinematicCollision2D}
  moveAndCollide
  [rel_vec infinite_inertia exclude_raycast_shapes test_only])
 (^{:tag godotclj.bindings.godot.Vector2}
  moveAndSlide
  [linear_velocity])
 (^{:tag godotclj.bindings.godot.Vector2}
  moveAndSlide
  [linear_velocity up_direction])
 (^{:tag godotclj.bindings.godot.Vector2}
  moveAndSlide
  [linear_velocity up_direction stop_on_slope])
 (^{:tag godotclj.bindings.godot.Vector2}
  moveAndSlide
  [linear_velocity up_direction stop_on_slope max_slides])
 (^{:tag godotclj.bindings.godot.Vector2}
  moveAndSlide
  [linear_velocity
   up_direction
   stop_on_slope
   max_slides
   floor_max_angle])
 (^{:tag godotclj.bindings.godot.Vector2}
  moveAndSlide
  [linear_velocity
   up_direction
   stop_on_slope
   max_slides
   floor_max_angle
   infinite_inertia])
 (^{:tag godotclj.bindings.godot.Vector2}
  moveAndSlideWithSnap
  [linear_velocity snap])
 (^{:tag godotclj.bindings.godot.Vector2}
  moveAndSlideWithSnap
  [linear_velocity snap up_direction])
 (^{:tag godotclj.bindings.godot.Vector2}
  moveAndSlideWithSnap
  [linear_velocity snap up_direction stop_on_slope])
 (^{:tag godotclj.bindings.godot.Vector2}
  moveAndSlideWithSnap
  [linear_velocity snap up_direction stop_on_slope max_slides])
 (^{:tag godotclj.bindings.godot.Vector2}
  moveAndSlideWithSnap
  [linear_velocity
   snap
   up_direction
   stop_on_slope
   max_slides
   floor_max_angle])
 (^{:tag godotclj.bindings.godot.Vector2}
  moveAndSlideWithSnap
  [linear_velocity
   snap
   up_direction
   stop_on_slope
   max_slides
   floor_max_angle
   infinite_inertia])
 (^{:tag void} setSafeMargin [pixels])
 (^{:tag void} setSyncToPhysics [enable])
 (^{:tag boolean} testMove [from rel_vec])
 (^{:tag boolean} testMove [from rel_vec infinite_inertia]))
(definterface
 MGodotVisualShaderNodeVectorDerivativeFunc
 (^{:tag int} getFunction [])
 (^{:tag void} setFunction [func]))
(definterface
 MGodotVisualScriptSceneNode
 (^{:tag godotclj.bindings.godot.NodePath} getNodePath [])
 (^{:tag void} setNodePath [path]))
(definterface
 MGodotJavaClassWrapper
 (^{:tag godotclj.api.gdscript.IGodotJavaClass} wrap [name]))
(definterface
 MGodotTileSet
 (^{:tag void} autotileClearBitmaskMap [id])
 (^{:tag int} autotileGetBitmask [id coord])
 (^{:tag int} autotileGetBitmaskMode [id])
 (^{:tag godotclj.bindings.godot.Vector2}
  autotileGetIconCoordinate
  [id])
 (^{:tag godotclj.api.gdscript.IGodotOccluderPolygon2D}
  autotileGetLightOccluder
  [id coord])
 (^{:tag godotclj.api.gdscript.IGodotNavigationPolygon}
  autotileGetNavigationPolygon
  [id coord])
 (^{:tag godotclj.bindings.godot.Vector2} autotileGetSize [id])
 (^{:tag int} autotileGetSpacing [id])
 (^{:tag int} autotileGetSubtilePriority [id coord])
 (^{:tag int} autotileGetZIndex [id coord])
 (^{:tag void} autotileSetBitmask [id bitmask flag])
 (^{:tag void} autotileSetBitmaskMode [id mode])
 (^{:tag void} autotileSetIconCoordinate [id coord])
 (^{:tag void} autotileSetLightOccluder [id light_occluder coord])
 (^{:tag void}
  autotileSetNavigationPolygon
  [id navigation_polygon coord])
 (^{:tag void} autotileSetSize [id size])
 (^{:tag void} autotileSetSpacing [id spacing])
 (^{:tag void} autotileSetSubtilePriority [id coord priority])
 (^{:tag void} autotileSetZIndex [id coord z_index])
 (^{:tag void} clear [])
 (^{:tag void} createTile [id])
 (^{:tag int} findTileByName [name])
 (^{:tag int} getLastUnusedTileId [])
 (^{:tag godotclj.bindings.godot.IndexedArray} getTilesIds [])
 (^{:tag void} removeTile [id])
 (^{:tag void} tileAddShape [id shape shape_transform])
 (^{:tag void} tileAddShape [id shape shape_transform one_way])
 (^{:tag void}
  tileAddShape
  [id shape shape_transform one_way autotile_coord])
 (^{:tag godotclj.api.gdscript.IGodotOccluderPolygon2D}
  tileGetLightOccluder
  [id])
 (^{:tag godotclj.api.gdscript.IGodotShaderMaterial}
  tileGetMaterial
  [id])
 (^{:tag godotclj.bindings.godot.Color} tileGetModulate [id])
 (^{:tag String} tileGetName [id])
 (^{:tag godotclj.api.gdscript.IGodotNavigationPolygon}
  tileGetNavigationPolygon
  [id])
 (^{:tag godotclj.bindings.godot.Vector2}
  tileGetNavigationPolygonOffset
  [id])
 (^{:tag godotclj.api.gdscript.IGodotTexture} tileGetNormalMap [id])
 (^{:tag godotclj.bindings.godot.Vector2} tileGetOccluderOffset [id])
 (^{:tag godotclj.bindings.godot.IndexedRect2} tileGetRegion [id])
 (^{:tag godotclj.api.gdscript.IGodotShape2D}
  tileGetShape
  [id shape_id])
 (^{:tag int} tileGetShapeCount [id])
 (^{:tag godotclj.bindings.godot.Vector2}
  tileGetShapeOffset
  [id shape_id])
 (^{:tag boolean} tileGetShapeOneWay [id shape_id])
 (^{:tag float} tileGetShapeOneWayMargin [id shape_id])
 (^{:tag godotclj.bindings.godot.Transform2D}
  tileGetShapeTransform
  [id shape_id])
 (^{:tag godotclj.bindings.godot.IndexedArray} tileGetShapes [id])
 (^{:tag godotclj.api.gdscript.IGodotTexture} tileGetTexture [id])
 (^{:tag godotclj.bindings.godot.Vector2} tileGetTextureOffset [id])
 (^{:tag int} tileGetTileMode [id])
 (^{:tag int} tileGetZIndex [id])
 (^{:tag void} tileSetLightOccluder [id light_occluder])
 (^{:tag void} tileSetMaterial [id material])
 (^{:tag void} tileSetModulate [id color])
 (^{:tag void} tileSetName [id name])
 (^{:tag void} tileSetNavigationPolygon [id navigation_polygon])
 (^{:tag void}
  tileSetNavigationPolygonOffset
  [id navigation_polygon_offset])
 (^{:tag void} tileSetNormalMap [id normal_map])
 (^{:tag void} tileSetOccluderOffset [id occluder_offset])
 (^{:tag void} tileSetRegion [id region])
 (^{:tag void} tileSetShape [id shape_id shape])
 (^{:tag void} tileSetShapeOffset [id shape_id shape_offset])
 (^{:tag void} tileSetShapeOneWay [id shape_id one_way])
 (^{:tag void} tileSetShapeOneWayMargin [id shape_id one_way])
 (^{:tag void} tileSetShapeTransform [id shape_id shape_transform])
 (^{:tag void} tileSetShapes [id shapes])
 (^{:tag void} tileSetTexture [id texture])
 (^{:tag void} tileSetTextureOffset [id texture_offset])
 (^{:tag void} tileSetTileMode [id tilemode])
 (^{:tag void} tileSetZIndex [id z_index]))
(definterface
 MGodotLargeTexture
 (^{:tag int} addPiece [ofs texture])
 (^{:tag void} clear [])
 (^{:tag int} getPieceCount [])
 (^{:tag godotclj.bindings.godot.Vector2} getPieceOffset [idx])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getPieceTexture [idx])
 (^{:tag void} setPieceOffset [idx ofs])
 (^{:tag void} setPieceTexture [idx texture])
 (^{:tag void} setSize [size]))
(definterface
 MGodotVisualScriptPropertyGet
 (^{:tag godotclj.bindings.godot.NodePath} getBasePath [])
 (^{:tag String} getBaseScript [])
 (^{:tag String} getBaseType [])
 (^{:tag int} getBasicType [])
 (^{:tag int} getCallMode [])
 (^{:tag String} getIndex [])
 (^{:tag String} getProperty [])
 (^{:tag void} setBasePath [base_path])
 (^{:tag void} setBaseScript [base_script])
 (^{:tag void} setBaseType [base_type])
 (^{:tag void} setBasicType [basic_type])
 (^{:tag void} setCallMode [mode])
 (^{:tag void} setIndex [index])
 (^{:tag void} setProperty [property]))
(definterface
 MGodotShape2D
 (^{:tag boolean} collide [local_xform with_shape shape_xform])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  collideAndGetContacts
  [local_xform with_shape shape_xform])
 (^{:tag boolean}
  collideWithMotion
  [local_xform local_motion with_shape shape_xform shape_motion])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  collideWithMotionAndGetContacts
  [local_xform local_motion with_shape shape_xform shape_motion])
 (^{:tag void} draw [canvas_item color])
 (^{:tag float} getCustomSolverBias [])
 (^{:tag void} setCustomSolverBias [bias]))
(definterface
 MGodotConvexPolygonShape2D
 (^{:tag godotclj.bindings.godot.IndexedPoolVector2Array}
  getPoints
  [])
 (^{:tag void} setPointCloud [point_cloud])
 (^{:tag void} setPoints [points]))
(definterface
 MGodotTheme
 (^{:tag void} clear [])
 (^{:tag void} clearColor [name node_type])
 (^{:tag void} clearConstant [name node_type])
 (^{:tag void} clearFont [name node_type])
 (^{:tag void} clearIcon [name node_type])
 (^{:tag void} clearStylebox [name node_type])
 (^{:tag void} copyDefaultTheme [])
 (^{:tag void} copyTheme [other])
 (^{:tag godotclj.bindings.godot.Color} getColor [name node_type])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  getColorList
  [node_type])
 (^{:tag int} getConstant [name node_type])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  getConstantList
  [node_type])
 (^{:tag godotclj.api.gdscript.IGodotFont} getDefaultFont [])
 (^{:tag godotclj.api.gdscript.IGodotFont} getFont [name node_type])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  getFontList
  [node_type])
 (^{:tag godotclj.api.gdscript.IGodotTexture}
  getIcon
  [name node_type])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  getIconList
  [node_type])
 (^{:tag godotclj.api.gdscript.IGodotStyleBox}
  getStylebox
  [name node_type])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  getStyleboxList
  [node_type])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  getStyleboxTypes
  [])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  getTypeList
  [node_type])
 (^{:tag boolean} hasColor [name node_type])
 (^{:tag boolean} hasConstant [name node_type])
 (^{:tag boolean} hasFont [name node_type])
 (^{:tag boolean} hasIcon [name node_type])
 (^{:tag boolean} hasStylebox [name node_type])
 (^{:tag void} setColor [name node_type color])
 (^{:tag void} setConstant [name node_type constant])
 (^{:tag void} setDefaultFont [font])
 (^{:tag void} setFont [name node_type font])
 (^{:tag void} setIcon [name node_type texture])
 (^{:tag void} setStylebox [name node_type texture]))
(definterface MGodotAnimationNodeTimeSeek)
(definterface MGodotAnimationNodeTimeScale)
(definterface
 MGodotAudioServer
 (^{:tag void} addBus [])
 (^{:tag void} addBus [at_position])
 (^{:tag void} addBusEffect [bus_idx effect])
 (^{:tag void} addBusEffect [bus_idx effect at_position])
 (^{:tag String} captureGetDevice [])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  captureGetDeviceList
  [])
 (^{:tag void} captureSetDevice [name])
 (^{:tag godotclj.api.gdscript.IGodotAudioBusLayout}
  generateBusLayout
  [])
 (^{:tag int} getBusChannels [bus_idx])
 (^{:tag int} getBusCount [])
 (^{:tag godotclj.api.gdscript.IGodotAudioEffect}
  getBusEffect
  [bus_idx effect_idx])
 (^{:tag int} getBusEffectCount [bus_idx])
 (^{:tag godotclj.api.gdscript.IGodotAudioEffectInstance}
  getBusEffectInstance
  [bus_idx effect_idx])
 (^{:tag godotclj.api.gdscript.IGodotAudioEffectInstance}
  getBusEffectInstance
  [bus_idx effect_idx channel])
 (^{:tag int} getBusIndex [bus_name])
 (^{:tag String} getBusName [bus_idx])
 (^{:tag float} getBusPeakVolumeLeftDb [bus_idx channel])
 (^{:tag float} getBusPeakVolumeRightDb [bus_idx channel])
 (^{:tag String} getBusSend [bus_idx])
 (^{:tag float} getBusVolumeDb [bus_idx])
 (^{:tag String} getDevice [])
 (^{:tag godotclj.bindings.godot.IndexedArray} getDeviceList [])
 (^{:tag float} getGlobalRateScale [])
 (^{:tag float} getMixRate [])
 (^{:tag float} getOutputLatency [])
 (^{:tag int} getSpeakerMode [])
 (^{:tag float} getTimeSinceLastMix [])
 (^{:tag float} getTimeToNextMix [])
 (^{:tag boolean} isBusBypassingEffects [bus_idx])
 (^{:tag boolean} isBusEffectEnabled [bus_idx effect_idx])
 (^{:tag boolean} isBusMute [bus_idx])
 (^{:tag boolean} isBusSolo [bus_idx])
 (^{:tag void} lock [])
 (^{:tag void} moveBus [index to_index])
 (^{:tag void} removeBus [index])
 (^{:tag void} removeBusEffect [bus_idx effect_idx])
 (^{:tag void} setBusBypassEffects [bus_idx enable])
 (^{:tag void} setBusCount [amount])
 (^{:tag void} setBusEffectEnabled [bus_idx effect_idx enabled])
 (^{:tag void} setBusLayout [bus_layout])
 (^{:tag void} setBusMute [bus_idx enable])
 (^{:tag void} setBusName [bus_idx name])
 (^{:tag void} setBusSend [bus_idx send])
 (^{:tag void} setBusSolo [bus_idx enable])
 (^{:tag void} setBusVolumeDb [bus_idx volume_db])
 (^{:tag void} setDevice [device])
 (^{:tag void} setGlobalRateScale [scale])
 (^{:tag void} swapBusEffects [bus_idx effect_idx by_effect_idx])
 (^{:tag void} unlock []))
(definterface
 MGodotVisualServer
 (^{:tag void} blackBarsSetImages [left top right bottom])
 (^{:tag void} blackBarsSetMargins [left top right bottom])
 (^{:tag godotclj.bindings.godot.RID} cameraCreate [])
 (^{:tag void} cameraSetCullMask [camera layers])
 (^{:tag void} cameraSetEnvironment [camera env])
 (^{:tag void} cameraSetFrustum [camera size offset z_near z_far])
 (^{:tag void} cameraSetOrthogonal [camera size z_near z_far])
 (^{:tag void}
  cameraSetPerspective
  [camera fovy_degrees z_near z_far])
 (^{:tag void} cameraSetTransform [camera transform])
 (^{:tag void} cameraSetUseVerticalAspect [camera enable])
 (^{:tag godotclj.bindings.godot.RID} canvasCreate [])
 (^{:tag void} canvasItemAddCircle [item pos radius color])
 (^{:tag void} canvasItemAddClipIgnore [item ignore])
 (^{:tag void} canvasItemAddLine [item from to color])
 (^{:tag void} canvasItemAddLine [item from to color width])
 (^{:tag void}
  canvasItemAddLine
  [item from to color width antialiased])
 (^{:tag void} canvasItemAddMesh [item mesh])
 (^{:tag void} canvasItemAddMesh [item mesh transform])
 (^{:tag void} canvasItemAddMesh [item mesh transform modulate])
 (^{:tag void}
  canvasItemAddMesh
  [item mesh transform modulate texture])
 (^{:tag void}
  canvasItemAddMesh
  [item mesh transform modulate texture normal_map])
 (^{:tag void} canvasItemAddMultimesh [item mesh texture])
 (^{:tag void} canvasItemAddMultimesh [item mesh texture normal_map])
 (^{:tag void}
  canvasItemAddNinePatch
  [item rect source texture topleft bottomright])
 (^{:tag void}
  canvasItemAddNinePatch
  [item rect source texture topleft bottomright x_axis_mode])
 (^{:tag void}
  canvasItemAddNinePatch
  [item
   rect
   source
   texture
   topleft
   bottomright
   x_axis_mode
   y_axis_mode])
 (^{:tag void}
  canvasItemAddNinePatch
  [item
   rect
   source
   texture
   topleft
   bottomright
   x_axis_mode
   y_axis_mode
   draw_center])
 (^{:tag void}
  canvasItemAddNinePatch
  [item
   rect
   source
   texture
   topleft
   bottomright
   x_axis_mode
   y_axis_mode
   draw_center
   modulate])
 (^{:tag void}
  canvasItemAddNinePatch
  [item
   rect
   source
   texture
   topleft
   bottomright
   x_axis_mode
   y_axis_mode
   draw_center
   modulate
   normal_map])
 (^{:tag void}
  canvasItemAddParticles
  [item particles texture normal_map])
 (^{:tag void} canvasItemAddPolygon [item points colors])
 (^{:tag void} canvasItemAddPolygon [item points colors uvs])
 (^{:tag void} canvasItemAddPolygon [item points colors uvs texture])
 (^{:tag void}
  canvasItemAddPolygon
  [item points colors uvs texture normal_map])
 (^{:tag void}
  canvasItemAddPolygon
  [item points colors uvs texture normal_map antialiased])
 (^{:tag void} canvasItemAddPolyline [item points colors])
 (^{:tag void} canvasItemAddPolyline [item points colors width])
 (^{:tag void}
  canvasItemAddPolyline
  [item points colors width antialiased])
 (^{:tag void}
  canvasItemAddPrimitive
  [item points colors uvs texture])
 (^{:tag void}
  canvasItemAddPrimitive
  [item points colors uvs texture width])
 (^{:tag void}
  canvasItemAddPrimitive
  [item points colors uvs texture width normal_map])
 (^{:tag void} canvasItemAddRect [item rect color])
 (^{:tag void} canvasItemAddSetTransform [item transform])
 (^{:tag void} canvasItemAddTextureRect [item rect texture])
 (^{:tag void} canvasItemAddTextureRect [item rect texture tile])
 (^{:tag void}
  canvasItemAddTextureRect
  [item rect texture tile modulate])
 (^{:tag void}
  canvasItemAddTextureRect
  [item rect texture tile modulate transpose])
 (^{:tag void}
  canvasItemAddTextureRect
  [item rect texture tile modulate transpose normal_map])
 (^{:tag void}
  canvasItemAddTextureRectRegion
  [item rect texture src_rect])
 (^{:tag void}
  canvasItemAddTextureRectRegion
  [item rect texture src_rect modulate])
 (^{:tag void}
  canvasItemAddTextureRectRegion
  [item rect texture src_rect modulate transpose])
 (^{:tag void}
  canvasItemAddTextureRectRegion
  [item rect texture src_rect modulate transpose normal_map])
 (^{:tag void}
  canvasItemAddTextureRectRegion
  [item rect texture src_rect modulate transpose normal_map clip_uv])
 (^{:tag void}
  canvasItemAddTriangleArray
  [item indices points colors])
 (^{:tag void}
  canvasItemAddTriangleArray
  [item indices points colors uvs])
 (^{:tag void}
  canvasItemAddTriangleArray
  [item indices points colors uvs bones])
 (^{:tag void}
  canvasItemAddTriangleArray
  [item indices points colors uvs bones weights])
 (^{:tag void}
  canvasItemAddTriangleArray
  [item indices points colors uvs bones weights texture])
 (^{:tag void}
  canvasItemAddTriangleArray
  [item indices points colors uvs bones weights texture count])
 (^{:tag void}
  canvasItemAddTriangleArray
  [item
   indices
   points
   colors
   uvs
   bones
   weights
   texture
   count
   normal_map])
 (^{:tag void}
  canvasItemAddTriangleArray
  [item
   indices
   points
   colors
   uvs
   bones
   weights
   texture
   count
   normal_map
   antialiased])
 (^{:tag void}
  canvasItemAddTriangleArray
  [item
   indices
   points
   colors
   uvs
   bones
   weights
   texture
   count
   normal_map
   antialiased
   antialiasing_use_indices])
 (^{:tag void} canvasItemClear [item])
 (^{:tag godotclj.bindings.godot.RID} canvasItemCreate [])
 (^{:tag void} canvasItemSetClip [item clip])
 (^{:tag void} canvasItemSetCopyToBackbuffer [item enabled rect])
 (^{:tag void} canvasItemSetCustomRect [item use_custom_rect])
 (^{:tag void} canvasItemSetCustomRect [item use_custom_rect rect])
 (^{:tag void} canvasItemSetDistanceFieldMode [item enabled])
 (^{:tag void} canvasItemSetDrawBehindParent [item enabled])
 (^{:tag void} canvasItemSetDrawIndex [item index])
 (^{:tag void} canvasItemSetLightMask [item mask])
 (^{:tag void} canvasItemSetMaterial [item material])
 (^{:tag void} canvasItemSetModulate [item color])
 (^{:tag void} canvasItemSetParent [item parent])
 (^{:tag void} canvasItemSetSelfModulate [item color])
 (^{:tag void} canvasItemSetSortChildrenByY [item enabled])
 (^{:tag void} canvasItemSetTransform [item transform])
 (^{:tag void} canvasItemSetUseParentMaterial [item enabled])
 (^{:tag void} canvasItemSetVisible [item visible])
 (^{:tag void} canvasItemSetZAsRelativeToParent [item enabled])
 (^{:tag void} canvasItemSetZIndex [item z_index])
 (^{:tag void} canvasLightAttachToCanvas [light canvas])
 (^{:tag godotclj.bindings.godot.RID} canvasLightCreate [])
 (^{:tag void} canvasLightOccluderAttachToCanvas [occluder canvas])
 (^{:tag godotclj.bindings.godot.RID} canvasLightOccluderCreate [])
 (^{:tag void} canvasLightOccluderSetEnabled [occluder enabled])
 (^{:tag void} canvasLightOccluderSetLightMask [occluder mask])
 (^{:tag void} canvasLightOccluderSetPolygon [occluder polygon])
 (^{:tag void} canvasLightOccluderSetTransform [occluder transform])
 (^{:tag void} canvasLightSetColor [light color])
 (^{:tag void} canvasLightSetEnabled [light enabled])
 (^{:tag void} canvasLightSetEnergy [light energy])
 (^{:tag void} canvasLightSetHeight [light height])
 (^{:tag void} canvasLightSetItemCullMask [light mask])
 (^{:tag void} canvasLightSetItemShadowCullMask [light mask])
 (^{:tag void} canvasLightSetLayerRange [light min_layer max_layer])
 (^{:tag void} canvasLightSetMode [light mode])
 (^{:tag void} canvasLightSetScale [light scale])
 (^{:tag void} canvasLightSetShadowBufferSize [light size])
 (^{:tag void} canvasLightSetShadowColor [light color])
 (^{:tag void} canvasLightSetShadowEnabled [light enabled])
 (^{:tag void} canvasLightSetShadowFilter [light filter])
 (^{:tag void} canvasLightSetShadowGradientLength [light length])
 (^{:tag void} canvasLightSetShadowSmooth [light smooth])
 (^{:tag void} canvasLightSetTexture [light texture])
 (^{:tag void} canvasLightSetTextureOffset [light offset])
 (^{:tag void} canvasLightSetTransform [light transform])
 (^{:tag void} canvasLightSetZRange [light min_z max_z])
 (^{:tag godotclj.bindings.godot.RID} canvasOccluderPolygonCreate [])
 (^{:tag void}
  canvasOccluderPolygonSetCullMode
  [occluder_polygon mode])
 (^{:tag void}
  canvasOccluderPolygonSetShape
  [occluder_polygon shape closed])
 (^{:tag void}
  canvasOccluderPolygonSetShapeAsLines
  [occluder_polygon shape])
 (^{:tag void} canvasSetItemMirroring [canvas item mirroring])
 (^{:tag void} canvasSetModulate [canvas color])
 (^{:tag godotclj.bindings.godot.RID} directionalLightCreate [])
 (^{:tag void} draw [])
 (^{:tag void} draw [swap_buffers])
 (^{:tag void} draw [swap_buffers frame_step])
 (^{:tag godotclj.bindings.godot.RID} environmentCreate [])
 (^{:tag void}
  environmentSetAdjustment
  [env enable brightness contrast saturation ramp])
 (^{:tag void} environmentSetAmbientLight [env color])
 (^{:tag void} environmentSetAmbientLight [env color energy])
 (^{:tag void}
  environmentSetAmbientLight
  [env color energy sky_contibution])
 (^{:tag void} environmentSetBackground [env bg])
 (^{:tag void} environmentSetBgColor [env color])
 (^{:tag void} environmentSetBgEnergy [env energy])
 (^{:tag void} environmentSetCanvasMaxLayer [env max_layer])
 (^{:tag void}
  environmentSetDofBlurFar
  [env enable distance transition far_amount quality])
 (^{:tag void}
  environmentSetDofBlurNear
  [env enable distance transition far_amount quality])
 (^{:tag void}
  environmentSetFog
  [env enable color sun_color sun_amount])
 (^{:tag void}
  environmentSetFogDepth
  [env
   enable
   depth_begin
   depth_end
   depth_curve
   transmit
   transmit_curve])
 (^{:tag void}
  environmentSetFogHeight
  [env enable min_height max_height height_curve])
 (^{:tag void}
  environmentSetGlow
  [env
   enable
   level_flags
   intensity
   strength
   bloom_threshold
   blend_mode
   hdr_bleed_threshold
   hdr_bleed_scale
   hdr_luminance_cap
   bicubic_upscale])
 (^{:tag void} environmentSetSky [env sky])
 (^{:tag void} environmentSetSkyCustomFov [env scale])
 (^{:tag void} environmentSetSkyOrientation [env orientation])
 (^{:tag void}
  environmentSetSsao
  [env
   enable
   radius
   intensity
   radius2
   intensity2
   bias
   light_affect
   ao_channel_affect
   color
   quality
   blur
   bilateral_sharpness])
 (^{:tag void}
  environmentSetSsr
  [env enable max_steps fade_in fade_out depth_tolerance roughness])
 (^{:tag void}
  environmentSetTonemap
  [env
   tone_mapper
   exposure
   white
   auto_exposure
   min_luminance
   max_luminance
   auto_exp_speed
   auto_exp_grey])
 (^{:tag void} finish [])
 (^{:tag void} forceDraw [])
 (^{:tag void} forceDraw [swap_buffers])
 (^{:tag void} forceDraw [swap_buffers frame_step])
 (^{:tag void} forceSync [])
 (^{:tag void} freeRid [rid])
 (^{:tag int} getRenderInfo [info])
 (^{:tag godotclj.bindings.godot.RID} getTestCube [])
 (^{:tag godotclj.bindings.godot.RID} getTestTexture [])
 (^{:tag String} getVideoAdapterName [])
 (^{:tag String} getVideoAdapterVendor [])
 (^{:tag godotclj.bindings.godot.RID} getWhiteTexture [])
 (^{:tag godotclj.bindings.godot.RID} giProbeCreate [])
 (^{:tag float} giProbeGetBias [probe])
 (^{:tag godotclj.bindings.godot.AABB} giProbeGetBounds [probe])
 (^{:tag float} giProbeGetCellSize [probe])
 (^{:tag godotclj.bindings.godot.PoolIntArray}
  giProbeGetDynamicData
  [probe])
 (^{:tag int} giProbeGetDynamicRange [probe])
 (^{:tag float} giProbeGetEnergy [probe])
 (^{:tag float} giProbeGetNormalBias [probe])
 (^{:tag float} giProbeGetPropagation [probe])
 (^{:tag godotclj.bindings.godot.Transform}
  giProbeGetToCellXform
  [probe])
 (^{:tag boolean} giProbeIsCompressed [probe])
 (^{:tag boolean} giProbeIsInterior [probe])
 (^{:tag void} giProbeSetBias [probe bias])
 (^{:tag void} giProbeSetBounds [probe bounds])
 (^{:tag void} giProbeSetCellSize [probe range])
 (^{:tag void} giProbeSetCompress [probe enable])
 (^{:tag void} giProbeSetDynamicData [probe data])
 (^{:tag void} giProbeSetDynamicRange [probe range])
 (^{:tag void} giProbeSetEnergy [probe energy])
 (^{:tag void} giProbeSetInterior [probe enable])
 (^{:tag void} giProbeSetNormalBias [probe bias])
 (^{:tag void} giProbeSetPropagation [probe propagation])
 (^{:tag void} giProbeSetToCellXform [probe xform])
 (^{:tag boolean} hasChanged [])
 (^{:tag boolean} hasFeature [feature])
 (^{:tag boolean} hasOsFeature [feature])
 (^{:tag void} immediateBegin [immediate primitive])
 (^{:tag void} immediateBegin [immediate primitive texture])
 (^{:tag void} immediateClear [immediate])
 (^{:tag void} immediateColor [immediate color])
 (^{:tag godotclj.bindings.godot.RID} immediateCreate [])
 (^{:tag void} immediateEnd [immediate])
 (^{:tag godotclj.bindings.godot.RID}
  immediateGetMaterial
  [immediate])
 (^{:tag void} immediateNormal [immediate normal])
 (^{:tag void} immediateSetMaterial [immediate material])
 (^{:tag void} immediateTangent [immediate tangent])
 (^{:tag void} immediateUv [immediate tex_uv])
 (^{:tag void} immediateUv2 [immediate tex_uv])
 (^{:tag void} immediateVertex [immediate vertex])
 (^{:tag void} immediateVertex2d [immediate vertex])
 (^{:tag void} init [])
 (^{:tag void} instanceAttachObjectInstanceId [instance id])
 (^{:tag void} instanceAttachSkeleton [instance skeleton])
 (^{:tag godotclj.bindings.godot.RID} instanceCreate [])
 (^{:tag godotclj.bindings.godot.RID} instanceCreate2 [base scenario])
 (^{:tag void}
  instanceGeometrySetAsInstanceLod
  [instance as_lod_of_instance])
 (^{:tag void}
  instanceGeometrySetCastShadowsSetting
  [instance shadow_casting_setting])
 (^{:tag void}
  instanceGeometrySetDrawRange
  [instance min max min_margin max_margin])
 (^{:tag void} instanceGeometrySetFlag [instance flag enabled])
 (^{:tag void}
  instanceGeometrySetMaterialOverride
  [instance material])
 (^{:tag void} instanceSetBase [instance base])
 (^{:tag void} instanceSetBlendShapeWeight [instance shape weight])
 (^{:tag void} instanceSetCustomAabb [instance aabb])
 (^{:tag void} instanceSetExterior [instance enabled])
 (^{:tag void} instanceSetExtraVisibilityMargin [instance margin])
 (^{:tag void} instanceSetLayerMask [instance mask])
 (^{:tag void} instanceSetScenario [instance scenario])
 (^{:tag void} instanceSetSurfaceMaterial [instance surface material])
 (^{:tag void} instanceSetTransform [instance transform])
 (^{:tag void}
  instanceSetUseLightmap
  [instance lightmap_instance lightmap])
 (^{:tag void}
  instanceSetUseLightmap
  [instance lightmap_instance lightmap lightmap_slice])
 (^{:tag void}
  instanceSetUseLightmap
  [instance
   lightmap_instance
   lightmap
   lightmap_slice
   lightmap_uv_rect])
 (^{:tag void} instanceSetVisible [instance visible])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  instancesCullAabb
  [aabb])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  instancesCullAabb
  [aabb scenario])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  instancesCullConvex
  [convex])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  instancesCullConvex
  [convex scenario])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  instancesCullRay
  [from to])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  instancesCullRay
  [from to scenario])
 (^{:tag boolean} isRenderLoopEnabled [])
 (^{:tag void} lightDirectionalSetBlendSplits [light enable])
 (^{:tag void}
  lightDirectionalSetShadowDepthRangeMode
  [light range_mode])
 (^{:tag void} lightDirectionalSetShadowMode [light mode])
 (^{:tag void} lightOmniSetShadowDetail [light detail])
 (^{:tag void} lightOmniSetShadowMode [light mode])
 (^{:tag void} lightSetBakeMode [light bake_mode])
 (^{:tag void} lightSetColor [light color])
 (^{:tag void} lightSetCullMask [light mask])
 (^{:tag void} lightSetNegative [light enable])
 (^{:tag void} lightSetParam [light param value])
 (^{:tag void} lightSetProjector [light texture])
 (^{:tag void} lightSetReverseCullFaceMode [light enabled])
 (^{:tag void} lightSetShadow [light enabled])
 (^{:tag void} lightSetShadowColor [light color])
 (^{:tag void} lightSetUseGi [light enabled])
 (^{:tag godotclj.bindings.godot.RID} lightmapCaptureCreate [])
 (^{:tag godotclj.bindings.godot.AABB}
  lightmapCaptureGetBounds
  [capture])
 (^{:tag float} lightmapCaptureGetEnergy [capture])
 (^{:tag godotclj.bindings.godot.PoolByteArray}
  lightmapCaptureGetOctree
  [capture])
 (^{:tag int} lightmapCaptureGetOctreeCellSubdiv [capture])
 (^{:tag godotclj.bindings.godot.Transform}
  lightmapCaptureGetOctreeCellTransform
  [capture])
 (^{:tag boolean} lightmapCaptureIsInterior [capture])
 (^{:tag void} lightmapCaptureSetBounds [capture bounds])
 (^{:tag void} lightmapCaptureSetEnergy [capture energy])
 (^{:tag void} lightmapCaptureSetInterior [capture interior])
 (^{:tag void} lightmapCaptureSetOctree [capture octree])
 (^{:tag void} lightmapCaptureSetOctreeCellSubdiv [capture subdiv])
 (^{:tag void} lightmapCaptureSetOctreeCellTransform [capture xform])
 (^{:tag godotclj.bindings.godot.RID}
  makeSphereMesh
  [latitudes longitudes radius])
 (^{:tag godotclj.bindings.godot.RID} materialCreate [])
 (^{:tag godotclj.bindings.godot.Variant}
  materialGetParam
  [material parameter])
 (^{:tag godotclj.bindings.godot.Variant}
  materialGetParamDefault
  [material parameter])
 (^{:tag godotclj.bindings.godot.RID}
  materialGetShader
  [shader_material])
 (^{:tag void} materialSetLineWidth [material width])
 (^{:tag void} materialSetNextPass [material next_material])
 (^{:tag void} materialSetParam [material parameter value])
 (^{:tag void} materialSetRenderPriority [material priority])
 (^{:tag void} materialSetShader [shader_material shader])
 (^{:tag void} meshAddSurfaceFromArrays [mesh primitive arrays])
 (^{:tag void}
  meshAddSurfaceFromArrays
  [mesh primitive arrays blend_shapes])
 (^{:tag void}
  meshAddSurfaceFromArrays
  [mesh primitive arrays blend_shapes compress_format])
 (^{:tag void} meshClear [mesh])
 (^{:tag godotclj.bindings.godot.RID} meshCreate [])
 (^{:tag int} meshGetBlendShapeCount [mesh])
 (^{:tag int} meshGetBlendShapeMode [mesh])
 (^{:tag godotclj.bindings.godot.AABB} meshGetCustomAabb [mesh])
 (^{:tag int} meshGetSurfaceCount [mesh])
 (^{:tag void} meshRemoveSurface [mesh index])
 (^{:tag void} meshSetBlendShapeCount [mesh amount])
 (^{:tag void} meshSetBlendShapeMode [mesh mode])
 (^{:tag void} meshSetCustomAabb [mesh aabb])
 (^{:tag godotclj.bindings.godot.AABB}
  meshSurfaceGetAabb
  [mesh surface])
 (^{:tag godotclj.bindings.godot.PoolByteArray}
  meshSurfaceGetArray
  [mesh surface])
 (^{:tag int} meshSurfaceGetArrayIndexLen [mesh surface])
 (^{:tag int} meshSurfaceGetArrayLen [mesh surface])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  meshSurfaceGetArrays
  [mesh surface])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  meshSurfaceGetBlendShapeArrays
  [mesh surface])
 (^{:tag int} meshSurfaceGetFormat [mesh surface])
 (^{:tag int}
  meshSurfaceGetFormatOffset
  [format vertex_len index_len array_index])
 (^{:tag int}
  meshSurfaceGetFormatStride
  [format vertex_len index_len])
 (^{:tag godotclj.bindings.godot.PoolByteArray}
  meshSurfaceGetIndexArray
  [mesh surface])
 (^{:tag godotclj.bindings.godot.RID}
  meshSurfaceGetMaterial
  [mesh surface])
 (^{:tag int} meshSurfaceGetPrimitiveType [mesh surface])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  meshSurfaceGetSkeletonAabb
  [mesh surface])
 (^{:tag void} meshSurfaceSetMaterial [mesh surface material])
 (^{:tag void} meshSurfaceUpdateRegion [mesh surface offset data])
 (^{:tag void}
  multimeshAllocate
  [multimesh instances transform_format color_format])
 (^{:tag void}
  multimeshAllocate
  [multimesh
   instances
   transform_format
   color_format
   custom_data_format])
 (^{:tag godotclj.bindings.godot.RID} multimeshCreate [])
 (^{:tag godotclj.bindings.godot.AABB} multimeshGetAabb [multimesh])
 (^{:tag int} multimeshGetInstanceCount [multimesh])
 (^{:tag godotclj.bindings.godot.RID} multimeshGetMesh [multimesh])
 (^{:tag int} multimeshGetVisibleInstances [multimesh])
 (^{:tag godotclj.bindings.godot.Color}
  multimeshInstanceGetColor
  [multimesh index])
 (^{:tag godotclj.bindings.godot.Color}
  multimeshInstanceGetCustomData
  [multimesh index])
 (^{:tag godotclj.bindings.godot.Transform}
  multimeshInstanceGetTransform
  [multimesh index])
 (^{:tag godotclj.bindings.godot.Transform2D}
  multimeshInstanceGetTransform2d
  [multimesh index])
 (^{:tag void} multimeshInstanceSetColor [multimesh index color])
 (^{:tag void}
  multimeshInstanceSetCustomData
  [multimesh index custom_data])
 (^{:tag void}
  multimeshInstanceSetTransform
  [multimesh index transform])
 (^{:tag void}
  multimeshInstanceSetTransform2d
  [multimesh index transform])
 (^{:tag void} multimeshSetAsBulkArray [multimesh array])
 (^{:tag void} multimeshSetMesh [multimesh mesh])
 (^{:tag void} multimeshSetVisibleInstances [multimesh visible])
 (^{:tag godotclj.bindings.godot.RID} omniLightCreate [])
 (^{:tag godotclj.bindings.godot.RID} particlesCreate [])
 (^{:tag godotclj.bindings.godot.AABB}
  particlesGetCurrentAabb
  [particles])
 (^{:tag boolean} particlesGetEmitting [particles])
 (^{:tag boolean} particlesIsInactive [particles])
 (^{:tag void} particlesRequestProcess [particles])
 (^{:tag void} particlesRestart [particles])
 (^{:tag void} particlesSetAmount [particles amount])
 (^{:tag void} particlesSetCustomAabb [particles aabb])
 (^{:tag void} particlesSetDrawOrder [particles order])
 (^{:tag void} particlesSetDrawPassMesh [particles pass mesh])
 (^{:tag void} particlesSetDrawPasses [particles count])
 (^{:tag void} particlesSetEmissionTransform [particles transform])
 (^{:tag void} particlesSetEmitting [particles emitting])
 (^{:tag void} particlesSetExplosivenessRatio [particles ratio])
 (^{:tag void} particlesSetFixedFps [particles fps])
 (^{:tag void} particlesSetFractionalDelta [particles enable])
 (^{:tag void} particlesSetLifetime [particles lifetime])
 (^{:tag void} particlesSetOneShot [particles one_shot])
 (^{:tag void} particlesSetPreProcessTime [particles time])
 (^{:tag void} particlesSetProcessMaterial [particles material])
 (^{:tag void} particlesSetRandomnessRatio [particles ratio])
 (^{:tag void} particlesSetSpeedScale [particles scale])
 (^{:tag void} particlesSetUseLocalCoordinates [particles enable])
 (^{:tag godotclj.bindings.godot.RID} reflectionProbeCreate [])
 (^{:tag void} reflectionProbeSetAsInterior [probe enable])
 (^{:tag void} reflectionProbeSetCullMask [probe layers])
 (^{:tag void} reflectionProbeSetEnableBoxProjection [probe enable])
 (^{:tag void} reflectionProbeSetEnableShadows [probe enable])
 (^{:tag void} reflectionProbeSetExtents [probe extents])
 (^{:tag void} reflectionProbeSetIntensity [probe intensity])
 (^{:tag void} reflectionProbeSetInteriorAmbient [probe color])
 (^{:tag void} reflectionProbeSetInteriorAmbientEnergy [probe energy])
 (^{:tag void}
  reflectionProbeSetInteriorAmbientProbeContribution
  [probe contrib])
 (^{:tag void} reflectionProbeSetMaxDistance [probe distance])
 (^{:tag void} reflectionProbeSetOriginOffset [probe offset])
 (^{:tag void} reflectionProbeSetUpdateMode [probe mode])
 (^{:tag void} requestFrameDrawnCallback [where method userdata])
 (^{:tag godotclj.bindings.godot.RID} scenarioCreate [])
 (^{:tag void} scenarioSetDebug [scenario debug_mode])
 (^{:tag void} scenarioSetEnvironment [scenario environment])
 (^{:tag void} scenarioSetFallbackEnvironment [scenario environment])
 (^{:tag void} scenarioSetReflectionAtlasSize [scenario size subdiv])
 (^{:tag void} setBootImage [image color scale])
 (^{:tag void} setBootImage [image color scale use_filter])
 (^{:tag void} setDebugGenerateWireframes [generate])
 (^{:tag void} setDefaultClearColor [color])
 (^{:tag void} setRenderLoopEnabled [enabled])
 (^{:tag void} setShaderTimeScale [scale])
 (^{:tag godotclj.bindings.godot.RID} shaderCreate [])
 (^{:tag String} shaderGetCode [shader])
 (^{:tag godotclj.bindings.godot.RID}
  shaderGetDefaultTextureParam
  [shader name])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  shaderGetParamList
  [shader])
 (^{:tag void} shaderSetCode [shader code])
 (^{:tag void} shaderSetDefaultTextureParam [shader name texture])
 (^{:tag void} skeletonAllocate [skeleton bones])
 (^{:tag void} skeletonAllocate [skeleton bones is_2d_skeleton])
 (^{:tag godotclj.bindings.godot.Transform}
  skeletonBoneGetTransform
  [skeleton bone])
 (^{:tag godotclj.bindings.godot.Transform2D}
  skeletonBoneGetTransform2d
  [skeleton bone])
 (^{:tag void} skeletonBoneSetTransform [skeleton bone transform])
 (^{:tag void} skeletonBoneSetTransform2d [skeleton bone transform])
 (^{:tag godotclj.bindings.godot.RID} skeletonCreate [])
 (^{:tag int} skeletonGetBoneCount [skeleton])
 (^{:tag godotclj.bindings.godot.RID} skyCreate [])
 (^{:tag void} skySetTexture [sky cube_map radiance_size])
 (^{:tag godotclj.bindings.godot.RID} spotLightCreate [])
 (^{:tag void} sync [])
 (^{:tag void}
  textureAllocate
  [texture width height depth_3d format type])
 (^{:tag void}
  textureAllocate
  [texture width height depth_3d format type flags])
 (^{:tag void} textureBind [texture number])
 (^{:tag godotclj.bindings.godot.RID} textureCreate [])
 (^{:tag godotclj.bindings.godot.RID} textureCreateFromImage [image])
 (^{:tag godotclj.bindings.godot.RID}
  textureCreateFromImage
  [image flags])
 (^{:tag godotclj.bindings.godot.IndexedArray} textureDebugUsage [])
 (^{:tag godotclj.api.gdscript.IGodotImage} textureGetData [texture])
 (^{:tag godotclj.api.gdscript.IGodotImage}
  textureGetData
  [texture cube_side])
 (^{:tag int} textureGetDepth [texture])
 (^{:tag int} textureGetFlags [texture])
 (^{:tag int} textureGetFormat [texture])
 (^{:tag int} textureGetHeight [texture])
 (^{:tag String} textureGetPath [texture])
 (^{:tag int} textureGetTexid [texture])
 (^{:tag int} textureGetType [texture])
 (^{:tag int} textureGetWidth [texture])
 (^{:tag void} textureSetData [texture image])
 (^{:tag void} textureSetData [texture image layer])
 (^{:tag void}
  textureSetDataPartial
  [texture image src_x src_y src_w src_h dst_x dst_y dst_mip])
 (^{:tag void}
  textureSetDataPartial
  [texture image src_x src_y src_w src_h dst_x dst_y dst_mip layer])
 (^{:tag void} textureSetFlags [texture flags])
 (^{:tag void} textureSetPath [texture path])
 (^{:tag void} textureSetShrinkAllX2OnSetData [shrink])
 (^{:tag void} textureSetSizeOverride [texture width height depth])
 (^{:tag void} texturesKeepOriginal [enable])
 (^{:tag void} viewportAttachCamera [viewport camera])
 (^{:tag void} viewportAttachCanvas [viewport canvas])
 (^{:tag void} viewportAttachToScreen [viewport])
 (^{:tag void} viewportAttachToScreen [viewport rect])
 (^{:tag void} viewportAttachToScreen [viewport rect screen])
 (^{:tag godotclj.bindings.godot.RID} viewportCreate [])
 (^{:tag void} viewportDetach [viewport])
 (^{:tag int} viewportGetRenderInfo [viewport info])
 (^{:tag godotclj.bindings.godot.RID} viewportGetTexture [viewport])
 (^{:tag void} viewportRemoveCanvas [viewport canvas])
 (^{:tag void} viewportSetActive [viewport active])
 (^{:tag void}
  viewportSetCanvasStacking
  [viewport canvas layer sublayer])
 (^{:tag void} viewportSetCanvasTransform [viewport canvas offset])
 (^{:tag void} viewportSetClearMode [viewport clear_mode])
 (^{:tag void} viewportSetDebugDraw [viewport draw])
 (^{:tag void} viewportSetDisable3d [viewport disabled])
 (^{:tag void} viewportSetDisableEnvironment [viewport disabled])
 (^{:tag void} viewportSetGlobalCanvasTransform [viewport transform])
 (^{:tag void} viewportSetHdr [viewport enabled])
 (^{:tag void} viewportSetHideCanvas [viewport hidden])
 (^{:tag void} viewportSetHideScenario [viewport hidden])
 (^{:tag void} viewportSetMsaa [viewport msaa])
 (^{:tag void} viewportSetParentViewport [viewport parent_viewport])
 (^{:tag void} viewportSetRenderDirectToScreen [viewport enabled])
 (^{:tag void} viewportSetScenario [viewport scenario])
 (^{:tag void}
  viewportSetShadowAtlasQuadrantSubdivision
  [viewport quadrant subdivision])
 (^{:tag void} viewportSetShadowAtlasSize [viewport size])
 (^{:tag void} viewportSetSize [viewport width height])
 (^{:tag void} viewportSetTransparentBackground [viewport enabled])
 (^{:tag void} viewportSetUpdateMode [viewport update_mode])
 (^{:tag void} viewportSetUsage [viewport usage])
 (^{:tag void} viewportSetUseArvr [viewport use_arvr])
 (^{:tag void} viewportSetUseDebanding [viewport debanding])
 (^{:tag void} viewportSetUseFxaa [viewport fxaa])
 (^{:tag void} viewportSetVflip [viewport enabled]))
(definterface
 MGodotScriptCreateDialog
 (^{:tag void} config [inherits path])
 (^{:tag void} config [inherits path built_in_enabled])
 (^{:tag void} config [inherits path built_in_enabled load_enabled]))
(definterface
 MGodotCharFXTransform
 (^{:tag int} getAbsoluteIndex [])
 (^{:tag int} getCharacter [])
 (^{:tag godotclj.bindings.godot.Color} getColor [])
 (^{:tag float} getElapsedTime [])
 (^{:tag godotclj.bindings.godot.Dictionary} getEnvironment [])
 (^{:tag godotclj.bindings.godot.Vector2} getOffset [])
 (^{:tag int} getRelativeIndex [])
 (^{:tag boolean} isVisible [])
 (^{:tag void} setAbsoluteIndex [index])
 (^{:tag void} setCharacter [character])
 (^{:tag void} setColor [color])
 (^{:tag void} setElapsedTime [time])
 (^{:tag void} setEnvironment [environment])
 (^{:tag void} setOffset [offset])
 (^{:tag void} setRelativeIndex [index])
 (^{:tag void} setVisibility [visibility]))
(definterface MGodotVisualShaderNodeSwitch)
(definterface
 MGodotLabel
 (^{:tag int} getAlign [])
 (^{:tag int} getLineCount [])
 (^{:tag int} getLineHeight [])
 (^{:tag int} getLinesSkipped [])
 (^{:tag int} getMaxLinesVisible [])
 (^{:tag float} getPercentVisible [])
 (^{:tag String} getText [])
 (^{:tag int} getTotalCharacterCount [])
 (^{:tag int} getValign [])
 (^{:tag int} getVisibleCharacters [])
 (^{:tag int} getVisibleLineCount [])
 (^{:tag boolean} hasAutowrap [])
 (^{:tag boolean} isClippingText [])
 (^{:tag boolean} isUppercase [])
 (^{:tag void} setAlign [align])
 (^{:tag void} setAutowrap [enable])
 (^{:tag void} setClipText [enable])
 (^{:tag void} setLinesSkipped [lines_skipped])
 (^{:tag void} setMaxLinesVisible [lines_visible])
 (^{:tag void} setPercentVisible [percent_visible])
 (^{:tag void} setText [text])
 (^{:tag void} setUppercase [enable])
 (^{:tag void} setValign [valign])
 (^{:tag void} setVisibleCharacters [amount]))
(definterface
 MGodotVideoStreamWebm
 (^{:tag String} getFile [])
 (^{:tag void} setFile [file]))
(definterface
 MGodotVisualScriptYieldSignal
 (^{:tag godotclj.bindings.godot.NodePath} getBasePath [])
 (^{:tag String} getBaseType [])
 (^{:tag int} getCallMode [])
 (^{:tag String} getSignal [])
 (^{:tag void} setBasePath [base_path])
 (^{:tag void} setBaseType [base_type])
 (^{:tag void} setCallMode [mode])
 (^{:tag void} setSignal [signal]))
(definterface
 MGodotCurve2D
 (^{:tag void} addPoint [position])
 (^{:tag void} addPoint [position in])
 (^{:tag void} addPoint [position in out])
 (^{:tag void} addPoint [position in out at_position])
 (^{:tag void} clearPoints [])
 (^{:tag float} getBakeInterval [])
 (^{:tag float} getBakedLength [])
 (^{:tag godotclj.bindings.godot.IndexedPoolVector2Array}
  getBakedPoints
  [])
 (^{:tag float} getClosestOffset [to_point])
 (^{:tag godotclj.bindings.godot.Vector2} getClosestPoint [to_point])
 (^{:tag int} getPointCount [])
 (^{:tag godotclj.bindings.godot.Vector2} getPointIn [idx])
 (^{:tag godotclj.bindings.godot.Vector2} getPointOut [idx])
 (^{:tag godotclj.bindings.godot.Vector2} getPointPosition [idx])
 (^{:tag godotclj.bindings.godot.Vector2} interpolate [idx t])
 (^{:tag godotclj.bindings.godot.Vector2} interpolateBaked [offset])
 (^{:tag godotclj.bindings.godot.Vector2}
  interpolateBaked
  [offset cubic])
 (^{:tag godotclj.bindings.godot.Vector2} interpolatef [fofs])
 (^{:tag void} removePoint [idx])
 (^{:tag void} setBakeInterval [distance])
 (^{:tag void} setPointIn [idx position])
 (^{:tag void} setPointOut [idx position])
 (^{:tag void} setPointPosition [idx position])
 (^{:tag godotclj.bindings.godot.IndexedPoolVector2Array}
  tessellate
  [])
 (^{:tag godotclj.bindings.godot.IndexedPoolVector2Array}
  tessellate
  [max_stages])
 (^{:tag godotclj.bindings.godot.IndexedPoolVector2Array}
  tessellate
  [max_stages tolerance_degrees]))
(definterface
 MGodot_OS
 (^{:tag void} alert [text])
 (^{:tag void} alert [text title])
 (^{:tag boolean} canDraw [])
 (^{:tag boolean} canUseThreads [])
 (^{:tag void} centerWindow [])
 (^{:tag void} closeMidiInputs [])
 (^{:tag void} delayMsec [msec])
 (^{:tag void} delayUsec [usec])
 (^{:tag void} dumpMemoryToFile [file])
 (^{:tag void} dumpResourcesToFile [file])
 (^{:tag int} execute [path arguments])
 (^{:tag int} execute [path arguments blocking])
 (^{:tag int} execute [path arguments blocking output])
 (^{:tag int} execute [path arguments blocking output read_stderr])
 (^{:tag int} findScancodeFromString [string])
 (^{:tag int} getAudioDriverCount [])
 (^{:tag String} getAudioDriverName [driver])
 (^{:tag boolean} getBorderlessWindow [])
 (^{:tag String} getClipboard [])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  getCmdlineArgs
  [])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  getConnectedMidiInputs
  [])
 (^{:tag int} getCurrentScreen [])
 (^{:tag String} getCurrentTabletDriver [])
 (^{:tag int} getCurrentVideoDriver [])
 (^{:tag godotclj.bindings.godot.Dictionary} getDate [])
 (^{:tag godotclj.bindings.godot.Dictionary} getDate [utc])
 (^{:tag godotclj.bindings.godot.Dictionary} getDatetime [])
 (^{:tag godotclj.bindings.godot.Dictionary} getDatetime [utc])
 (^{:tag godotclj.bindings.godot.Dictionary}
  getDatetimeFromUnixTime
  [unix_time_val])
 (^{:tag int} getDynamicMemoryUsage [])
 (^{:tag String} getEnvironment [variable])
 (^{:tag String} getExecutablePath [])
 (^{:tag int} getExitCode [])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  getGrantedPermissions
  [])
 (^{:tag godotclj.bindings.godot.Vector2} getImeSelection [])
 (^{:tag String} getImeText [])
 (^{:tag String} getLatinKeyboardVariant [])
 (^{:tag String} getLocale [])
 (^{:tag int} getLowProcessorUsageModeSleepUsec [])
 (^{:tag godotclj.bindings.godot.Vector2} getMaxWindowSize [])
 (^{:tag godotclj.bindings.godot.Vector2} getMinWindowSize [])
 (^{:tag String} getModelName [])
 (^{:tag String} getName [])
 (^{:tag int} getNativeHandle [handle_type])
 (^{:tag int} getPowerPercentLeft [])
 (^{:tag int} getPowerSecondsLeft [])
 (^{:tag int} getPowerState [])
 (^{:tag int} getProcessId [])
 (^{:tag int} getProcessorCount [])
 (^{:tag godotclj.bindings.godot.Vector2} getRealWindowSize [])
 (^{:tag String} getScancodeString [code])
 (^{:tag int} getScreenCount [])
 (^{:tag int} getScreenDpi [])
 (^{:tag int} getScreenDpi [screen])
 (^{:tag float} getScreenMaxScale [])
 (^{:tag int} getScreenOrientation [])
 (^{:tag godotclj.bindings.godot.Vector2} getScreenPosition [])
 (^{:tag godotclj.bindings.godot.Vector2} getScreenPosition [screen])
 (^{:tag float} getScreenScale [])
 (^{:tag float} getScreenScale [screen])
 (^{:tag godotclj.bindings.godot.Vector2} getScreenSize [])
 (^{:tag godotclj.bindings.godot.Vector2} getScreenSize [screen])
 (^{:tag int} getSplashTickMsec [])
 (^{:tag int} getStaticMemoryPeakUsage [])
 (^{:tag int} getStaticMemoryUsage [])
 (^{:tag String} getSystemDir [dir])
 (^{:tag String} getSystemDir [dir shared_storage])
 (^{:tag int} getSystemTimeMsecs [])
 (^{:tag int} getSystemTimeSecs [])
 (^{:tag int} getTabletDriverCount [])
 (^{:tag String} getTabletDriverName [idx])
 (^{:tag int} getThreadCallerId [])
 (^{:tag int} getTicksMsec [])
 (^{:tag int} getTicksUsec [])
 (^{:tag godotclj.bindings.godot.Dictionary} getTime [])
 (^{:tag godotclj.bindings.godot.Dictionary} getTime [utc])
 (^{:tag godotclj.bindings.godot.Dictionary} getTimeZoneInfo [])
 (^{:tag String} getUniqueId [])
 (^{:tag int} getUnixTime [])
 (^{:tag int} getUnixTimeFromDatetime [datetime])
 (^{:tag String} getUserDataDir [])
 (^{:tag int} getVideoDriverCount [])
 (^{:tag String} getVideoDriverName [driver])
 (^{:tag int} getVirtualKeyboardHeight [])
 (^{:tag boolean} getWindowPerPixelTransparencyEnabled [])
 (^{:tag godotclj.bindings.godot.Vector2} getWindowPosition [])
 (^{:tag godotclj.bindings.godot.IndexedRect2} getWindowSafeArea [])
 (^{:tag godotclj.bindings.godot.Vector2} getWindowSize [])
 (^{:tag void} globalMenuAddItem [menu label id meta])
 (^{:tag void} globalMenuAddSeparator [menu])
 (^{:tag void} globalMenuClear [menu])
 (^{:tag void} globalMenuRemoveItem [menu idx])
 (^{:tag boolean} hasEnvironment [variable])
 (^{:tag boolean} hasFeature [tag_name])
 (^{:tag boolean} hasTouchscreenUiHint [])
 (^{:tag boolean} hasVirtualKeyboard [])
 (^{:tag void} hideVirtualKeyboard [])
 (^{:tag boolean} isDebugBuild [])
 (^{:tag boolean} isInLowProcessorUsageMode [])
 (^{:tag boolean} isKeepScreenOn [])
 (^{:tag boolean} isOkLeftAndCancelRight [])
 (^{:tag boolean} isScancodeUnicode [code])
 (^{:tag boolean} isStdoutVerbose [])
 (^{:tag boolean} isUserfsPersistent [])
 (^{:tag boolean} isVsyncEnabled [])
 (^{:tag boolean} isVsyncViaCompositorEnabled [])
 (^{:tag boolean} isWindowAlwaysOnTop [])
 (^{:tag boolean} isWindowFocused [])
 (^{:tag boolean} isWindowFullscreen [])
 (^{:tag boolean} isWindowMaximized [])
 (^{:tag boolean} isWindowMinimized [])
 (^{:tag boolean} isWindowResizable [])
 (^{:tag int} keyboardGetCurrentLayout [])
 (^{:tag int} keyboardGetLayoutCount [])
 (^{:tag String} keyboardGetLayoutLanguage [index])
 (^{:tag String} keyboardGetLayoutName [index])
 (^{:tag void} keyboardSetCurrentLayout [index])
 (^{:tag int} kill [pid])
 (^{:tag void} moveWindowToForeground [])
 (^{:tag boolean} nativeVideoIsPlaying [])
 (^{:tag void} nativeVideoPause [])
 (^{:tag int}
  nativeVideoPlay
  [path volume audio_track subtitle_track])
 (^{:tag void} nativeVideoStop [])
 (^{:tag void} nativeVideoUnpause [])
 (^{:tag void} openMidiInputs [])
 (^{:tag void} printAllResources [])
 (^{:tag void} printAllResources [tofile])
 (^{:tag void} printAllTexturesBySize [])
 (^{:tag void} printResourcesByType [types])
 (^{:tag void} printResourcesInUse [])
 (^{:tag void} printResourcesInUse [short])
 (^{:tag void} requestAttention [])
 (^{:tag boolean} requestPermission [name])
 (^{:tag boolean} requestPermissions [])
 (^{:tag void} setBorderlessWindow [borderless])
 (^{:tag void} setClipboard [clipboard])
 (^{:tag void} setCurrentScreen [screen])
 (^{:tag void} setCurrentTabletDriver [name])
 (^{:tag boolean} setEnvironment [variable value])
 (^{:tag void} setExitCode [code])
 (^{:tag void} setIcon [icon])
 (^{:tag void} setImeActive [active])
 (^{:tag void} setImePosition [position])
 (^{:tag void} setKeepScreenOn [enabled])
 (^{:tag void} setLowProcessorUsageMode [enable])
 (^{:tag void} setLowProcessorUsageModeSleepUsec [usec])
 (^{:tag void} setMaxWindowSize [size])
 (^{:tag void} setMinWindowSize [size])
 (^{:tag void} setNativeIcon [filename])
 (^{:tag void} setScreenOrientation [orientation])
 (^{:tag int} setThreadName [name])
 (^{:tag void} setUseFileAccessSaveAndSwap [enabled])
 (^{:tag void} setUseVsync [enable])
 (^{:tag void} setVsyncViaCompositor [enable])
 (^{:tag void} setWindowAlwaysOnTop [enabled])
 (^{:tag void} setWindowFullscreen [enabled])
 (^{:tag void} setWindowMaximized [enabled])
 (^{:tag void} setWindowMinimized [enabled])
 (^{:tag void} setWindowMousePassthrough [region])
 (^{:tag void} setWindowPerPixelTransparencyEnabled [enabled])
 (^{:tag void} setWindowPosition [position])
 (^{:tag void} setWindowResizable [enabled])
 (^{:tag void} setWindowSize [size])
 (^{:tag void} setWindowTitle [title])
 (^{:tag int} shellOpen [uri])
 (^{:tag void} showVirtualKeyboard [])
 (^{:tag void} showVirtualKeyboard [existing_text])
 (^{:tag void} showVirtualKeyboard [existing_text multiline]))
(definterface MGodotAudioEffectLowPassFilter)
(definterface
 MGodotSegmentShape2D
 (^{:tag godotclj.bindings.godot.Vector2} getA [])
 (^{:tag godotclj.bindings.godot.Vector2} getB [])
 (^{:tag void} setA [a])
 (^{:tag void} setB [b]))
(definterface MGodotVSlider)
(definterface
 MGodotVisualScriptTypeCast
 (^{:tag String} getBaseScript [])
 (^{:tag String} getBaseType [])
 (^{:tag void} setBaseScript [path])
 (^{:tag void} setBaseType [type]))
(definterface
 MGodotEnvironment
 (^{:tag float} getAdjustmentBrightness [])
 (^{:tag godotclj.api.gdscript.IGodotTexture}
  getAdjustmentColorCorrection
  [])
 (^{:tag float} getAdjustmentContrast [])
 (^{:tag float} getAdjustmentSaturation [])
 (^{:tag godotclj.bindings.godot.Color} getAmbientLightColor [])
 (^{:tag float} getAmbientLightEnergy [])
 (^{:tag float} getAmbientLightSkyContribution [])
 (^{:tag int} getBackground [])
 (^{:tag godotclj.bindings.godot.Color} getBgColor [])
 (^{:tag float} getBgEnergy [])
 (^{:tag int} getCameraFeedId [])
 (^{:tag int} getCanvasMaxLayer [])
 (^{:tag float} getDofBlurFarAmount [])
 (^{:tag float} getDofBlurFarDistance [])
 (^{:tag int} getDofBlurFarQuality [])
 (^{:tag float} getDofBlurFarTransition [])
 (^{:tag float} getDofBlurNearAmount [])
 (^{:tag float} getDofBlurNearDistance [])
 (^{:tag int} getDofBlurNearQuality [])
 (^{:tag float} getDofBlurNearTransition [])
 (^{:tag godotclj.bindings.godot.Color} getFogColor [])
 (^{:tag float} getFogDepthBegin [])
 (^{:tag float} getFogDepthCurve [])
 (^{:tag float} getFogDepthEnd [])
 (^{:tag float} getFogHeightCurve [])
 (^{:tag float} getFogHeightMax [])
 (^{:tag float} getFogHeightMin [])
 (^{:tag float} getFogSunAmount [])
 (^{:tag godotclj.bindings.godot.Color} getFogSunColor [])
 (^{:tag float} getFogTransmitCurve [])
 (^{:tag int} getGlowBlendMode [])
 (^{:tag float} getGlowBloom [])
 (^{:tag float} getGlowHdrBleedScale [])
 (^{:tag float} getGlowHdrBleedThreshold [])
 (^{:tag float} getGlowHdrLuminanceCap [])
 (^{:tag float} getGlowIntensity [])
 (^{:tag float} getGlowStrength [])
 (^{:tag godotclj.api.gdscript.IGodotSky} getSky [])
 (^{:tag float} getSkyCustomFov [])
 (^{:tag godotclj.bindings.godot.Basis} getSkyOrientation [])
 (^{:tag godotclj.bindings.godot.Vector3} getSkyRotation [])
 (^{:tag godotclj.bindings.godot.Vector3} getSkyRotationDegrees [])
 (^{:tag float} getSsaoAoChannelAffect [])
 (^{:tag float} getSsaoBias [])
 (^{:tag int} getSsaoBlur [])
 (^{:tag godotclj.bindings.godot.Color} getSsaoColor [])
 (^{:tag float} getSsaoDirectLightAffect [])
 (^{:tag float} getSsaoEdgeSharpness [])
 (^{:tag float} getSsaoIntensity [])
 (^{:tag float} getSsaoIntensity2 [])
 (^{:tag int} getSsaoQuality [])
 (^{:tag float} getSsaoRadius [])
 (^{:tag float} getSsaoRadius2 [])
 (^{:tag float} getSsrDepthTolerance [])
 (^{:tag float} getSsrFadeIn [])
 (^{:tag float} getSsrFadeOut [])
 (^{:tag int} getSsrMaxSteps [])
 (^{:tag boolean} getTonemapAutoExposure [])
 (^{:tag float} getTonemapAutoExposureGrey [])
 (^{:tag float} getTonemapAutoExposureMax [])
 (^{:tag float} getTonemapAutoExposureMin [])
 (^{:tag float} getTonemapAutoExposureSpeed [])
 (^{:tag float} getTonemapExposure [])
 (^{:tag float} getTonemapWhite [])
 (^{:tag int} getTonemapper [])
 (^{:tag boolean} isAdjustmentEnabled [])
 (^{:tag boolean} isDofBlurFarEnabled [])
 (^{:tag boolean} isDofBlurNearEnabled [])
 (^{:tag boolean} isFogDepthEnabled [])
 (^{:tag boolean} isFogEnabled [])
 (^{:tag boolean} isFogHeightEnabled [])
 (^{:tag boolean} isFogTransmitEnabled [])
 (^{:tag boolean} isGlowBicubicUpscaleEnabled [])
 (^{:tag boolean} isGlowEnabled [])
 (^{:tag boolean} isGlowLevelEnabled [idx])
 (^{:tag boolean} isSsaoEnabled [])
 (^{:tag boolean} isSsrEnabled [])
 (^{:tag boolean} isSsrRough [])
 (^{:tag void} setAdjustmentBrightness [brightness])
 (^{:tag void} setAdjustmentColorCorrection [color_correction])
 (^{:tag void} setAdjustmentContrast [contrast])
 (^{:tag void} setAdjustmentEnable [enabled])
 (^{:tag void} setAdjustmentSaturation [saturation])
 (^{:tag void} setAmbientLightColor [color])
 (^{:tag void} setAmbientLightEnergy [energy])
 (^{:tag void} setAmbientLightSkyContribution [energy])
 (^{:tag void} setBackground [mode])
 (^{:tag void} setBgColor [color])
 (^{:tag void} setBgEnergy [energy])
 (^{:tag void} setCameraFeedId [camera_feed_id])
 (^{:tag void} setCanvasMaxLayer [layer])
 (^{:tag void} setDofBlurFarAmount [intensity])
 (^{:tag void} setDofBlurFarDistance [intensity])
 (^{:tag void} setDofBlurFarEnabled [enabled])
 (^{:tag void} setDofBlurFarQuality [intensity])
 (^{:tag void} setDofBlurFarTransition [intensity])
 (^{:tag void} setDofBlurNearAmount [intensity])
 (^{:tag void} setDofBlurNearDistance [intensity])
 (^{:tag void} setDofBlurNearEnabled [enabled])
 (^{:tag void} setDofBlurNearQuality [level])
 (^{:tag void} setDofBlurNearTransition [intensity])
 (^{:tag void} setFogColor [color])
 (^{:tag void} setFogDepthBegin [distance])
 (^{:tag void} setFogDepthCurve [curve])
 (^{:tag void} setFogDepthEnabled [enabled])
 (^{:tag void} setFogDepthEnd [distance])
 (^{:tag void} setFogEnabled [enabled])
 (^{:tag void} setFogHeightCurve [curve])
 (^{:tag void} setFogHeightEnabled [enabled])
 (^{:tag void} setFogHeightMax [height])
 (^{:tag void} setFogHeightMin [height])
 (^{:tag void} setFogSunAmount [amount])
 (^{:tag void} setFogSunColor [color])
 (^{:tag void} setFogTransmitCurve [curve])
 (^{:tag void} setFogTransmitEnabled [enabled])
 (^{:tag void} setGlowBicubicUpscale [enabled])
 (^{:tag void} setGlowBlendMode [mode])
 (^{:tag void} setGlowBloom [amount])
 (^{:tag void} setGlowEnabled [enabled])
 (^{:tag void} setGlowHdrBleedScale [scale])
 (^{:tag void} setGlowHdrBleedThreshold [threshold])
 (^{:tag void} setGlowHdrLuminanceCap [amount])
 (^{:tag void} setGlowIntensity [intensity])
 (^{:tag void} setGlowLevel [idx enabled])
 (^{:tag void} setGlowStrength [strength])
 (^{:tag void} setSky [sky])
 (^{:tag void} setSkyCustomFov [scale])
 (^{:tag void} setSkyOrientation [orientation])
 (^{:tag void} setSkyRotation [euler_radians])
 (^{:tag void} setSkyRotationDegrees [euler_degrees])
 (^{:tag void} setSsaoAoChannelAffect [amount])
 (^{:tag void} setSsaoBias [bias])
 (^{:tag void} setSsaoBlur [mode])
 (^{:tag void} setSsaoColor [color])
 (^{:tag void} setSsaoDirectLightAffect [amount])
 (^{:tag void} setSsaoEdgeSharpness [edge_sharpness])
 (^{:tag void} setSsaoEnabled [enabled])
 (^{:tag void} setSsaoIntensity [intensity])
 (^{:tag void} setSsaoIntensity2 [intensity])
 (^{:tag void} setSsaoQuality [quality])
 (^{:tag void} setSsaoRadius [radius])
 (^{:tag void} setSsaoRadius2 [radius])
 (^{:tag void} setSsrDepthTolerance [depth_tolerance])
 (^{:tag void} setSsrEnabled [enabled])
 (^{:tag void} setSsrFadeIn [fade_in])
 (^{:tag void} setSsrFadeOut [fade_out])
 (^{:tag void} setSsrMaxSteps [max_steps])
 (^{:tag void} setSsrRough [rough])
 (^{:tag void} setTonemapAutoExposure [auto_exposure])
 (^{:tag void} setTonemapAutoExposureGrey [exposure_grey])
 (^{:tag void} setTonemapAutoExposureMax [exposure_max])
 (^{:tag void} setTonemapAutoExposureMin [exposure_min])
 (^{:tag void} setTonemapAutoExposureSpeed [exposure_speed])
 (^{:tag void} setTonemapExposure [exposure])
 (^{:tag void} setTonemapWhite [white])
 (^{:tag void} setTonemapper [mode]))
(definterface
 MGodotListener
 (^{:tag void} clearCurrent [])
 (^{:tag godotclj.bindings.godot.Transform} getListenerTransform [])
 (^{:tag boolean} isCurrent [])
 (^{:tag void} makeCurrent []))
(definterface
 MGodotEditorVCSInterface
 (^{:tag void} commit [msg])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  getFileDiff
  [file_path])
 (^{:tag godotclj.bindings.godot.Dictionary} getModifiedFilesData [])
 (^{:tag String} getProjectName [])
 (^{:tag String} getVcsName [])
 (^{:tag boolean} initialize [project_root_path])
 (^{:tag boolean} isAddonReady [])
 (^{:tag boolean} isVcsInitialized [])
 (^{:tag boolean} shutDown [])
 (^{:tag void} stageFile [file_path])
 (^{:tag void} unstageFile [file_path]))
(definterface MGodotVisualShaderNodeVectorLen)
(definterface MGodotAudioEffectEQ10)
(definterface
 MGodotInstancePlaceholder
 (^{:tag godotclj.api.gdscript.IGodotNode} createInstance [])
 (^{:tag godotclj.api.gdscript.IGodotNode} createInstance [replace])
 (^{:tag godotclj.api.gdscript.IGodotNode}
  createInstance
  [replace custom_scene])
 (^{:tag String} getInstancePath [])
 (^{:tag godotclj.bindings.godot.Dictionary} getStoredValues [])
 (^{:tag godotclj.bindings.godot.Dictionary}
  getStoredValues
  [with_order])
 (^{:tag void} replaceByInstance [])
 (^{:tag void} replaceByInstance [custom_scene]))
(definterface
 MGodotNavigationPolygon
 (^{:tag void} addOutline [outline])
 (^{:tag void} addOutlineAtIndex [outline index])
 (^{:tag void} addPolygon [polygon])
 (^{:tag void} clearOutlines [])
 (^{:tag void} clearPolygons [])
 (^{:tag godotclj.bindings.godot.IndexedPoolVector2Array}
  getOutline
  [idx])
 (^{:tag int} getOutlineCount [])
 (^{:tag godotclj.bindings.godot.PoolIntArray} getPolygon [idx])
 (^{:tag int} getPolygonCount [])
 (^{:tag godotclj.bindings.godot.IndexedPoolVector2Array}
  getVertices
  [])
 (^{:tag void} makePolygonsFromOutlines [])
 (^{:tag void} removeOutline [idx])
 (^{:tag void} setOutline [idx outline])
 (^{:tag void} setVertices [vertices]))
(definterface
 MGodotStreamPeerBuffer
 (^{:tag void} clear [])
 (^{:tag godotclj.api.gdscript.IGodotStreamPeerBuffer} duplicate [])
 (^{:tag godotclj.bindings.godot.PoolByteArray} getDataArray [])
 (^{:tag int} getPosition [])
 (^{:tag int} getSize [])
 (^{:tag void} resize [size])
 (^{:tag void} seek [position])
 (^{:tag void} setDataArray [data]))
(definterface
 MGodotVisualScriptFunctionState
 (^{:tag void} connectToSignal [obj signals args])
 (^{:tag boolean} isValid [])
 (^{:tag godotclj.bindings.godot.Variant} resume [])
 (^{:tag godotclj.bindings.godot.Variant} resume [args]))
(definterface MGodotVisualShaderNodeTextureUniformTriplanar)
(definterface
 MGodotEditorScript
 (^{:tag void} addRootNode [node])
 (^{:tag godotclj.api.gdscript.IGodotEditorInterface}
  getEditorInterface
  [])
 (^{:tag godotclj.api.gdscript.IGodotNode} getScene []))
(definterface
 MGodotPhysics2DDirectSpaceState
 (^{:tag godotclj.bindings.godot.IndexedArray} castMotion [shape])
 (^{:tag godotclj.bindings.godot.IndexedArray} collideShape [shape])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  collideShape
  [shape max_results])
 (^{:tag godotclj.bindings.godot.Dictionary} getRestInfo [shape])
 (^{:tag godotclj.bindings.godot.IndexedArray} intersectPoint [point])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  intersectPoint
  [point max_results])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  intersectPoint
  [point max_results exclude])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  intersectPoint
  [point max_results exclude collision_layer])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  intersectPoint
  [point max_results exclude collision_layer collide_with_bodies])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  intersectPoint
  [point
   max_results
   exclude
   collision_layer
   collide_with_bodies
   collide_with_areas])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  intersectPointOnCanvas
  [point canvas_instance_id])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  intersectPointOnCanvas
  [point canvas_instance_id max_results])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  intersectPointOnCanvas
  [point canvas_instance_id max_results exclude])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  intersectPointOnCanvas
  [point canvas_instance_id max_results exclude collision_layer])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  intersectPointOnCanvas
  [point
   canvas_instance_id
   max_results
   exclude
   collision_layer
   collide_with_bodies])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  intersectPointOnCanvas
  [point
   canvas_instance_id
   max_results
   exclude
   collision_layer
   collide_with_bodies
   collide_with_areas])
 (^{:tag godotclj.bindings.godot.Dictionary} intersectRay [from to])
 (^{:tag godotclj.bindings.godot.Dictionary}
  intersectRay
  [from to exclude])
 (^{:tag godotclj.bindings.godot.Dictionary}
  intersectRay
  [from to exclude collision_layer])
 (^{:tag godotclj.bindings.godot.Dictionary}
  intersectRay
  [from to exclude collision_layer collide_with_bodies])
 (^{:tag godotclj.bindings.godot.Dictionary}
  intersectRay
  [from
   to
   exclude
   collision_layer
   collide_with_bodies
   collide_with_areas])
 (^{:tag godotclj.bindings.godot.IndexedArray} intersectShape [shape])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  intersectShape
  [shape max_results]))
(definterface MGodotCheckBox)
(definterface
 MGodotAudioEffectPitchShift
 (^{:tag int} getFftSize [])
 (^{:tag int} getOversampling [])
 (^{:tag float} getPitchScale [])
 (^{:tag void} setFftSize [size])
 (^{:tag void} setOversampling [amount])
 (^{:tag void} setPitchScale [rate]))
(definterface
 MGodotWebRTCPeerConnection
 (^{:tag int} addIceCandidate [media index name])
 (^{:tag void} close [])
 (^{:tag godotclj.api.gdscript.IGodotWebRTCDataChannel}
  createDataChannel
  [label])
 (^{:tag godotclj.api.gdscript.IGodotWebRTCDataChannel}
  createDataChannel
  [label options])
 (^{:tag int} createOffer [])
 (^{:tag int} getConnectionState [])
 (^{:tag int} initialize [])
 (^{:tag int} initialize [configuration])
 (^{:tag int} poll [])
 (^{:tag int} setLocalDescription [type sdp])
 (^{:tag int} setRemoteDescription [type sdp]))
(definterface MGodotVisualShaderNodeFaceForward)
(definterface
 MGodotConeTwistJoint
 (^{:tag float} getParam [param])
 (^{:tag void} setParam [param value]))
(definterface
 MGodotVisibilityEnabler
 (^{:tag boolean} isEnablerEnabled [enabler])
 (^{:tag void} setEnabler [enabler enabled]))
(definterface
 MGodotRegEx
 (^{:tag void} clear [])
 (^{:tag int} compile [pattern])
 (^{:tag int} getGroupCount [])
 (^{:tag godotclj.bindings.godot.IndexedArray} getNames [])
 (^{:tag String} getPattern [])
 (^{:tag boolean} isValid [])
 (^{:tag godotclj.api.gdscript.IGodotRegExMatch} search [subject])
 (^{:tag godotclj.api.gdscript.IGodotRegExMatch}
  search
  [subject offset])
 (^{:tag godotclj.api.gdscript.IGodotRegExMatch}
  search
  [subject offset end])
 (^{:tag godotclj.bindings.godot.IndexedArray} searchAll [subject])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  searchAll
  [subject offset])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  searchAll
  [subject offset end])
 (^{:tag String} sub [subject replacement])
 (^{:tag String} sub [subject replacement all])
 (^{:tag String} sub [subject replacement all offset])
 (^{:tag String} sub [subject replacement all offset end]))
(definterface MGodotPackedDataContainerRef (^{:tag int} size []))
(definterface
 MGodotMeshInstance
 (^{:tag void} createConvexCollision [])
 (^{:tag void} createDebugTangents [])
 (^{:tag void} createTrimeshCollision [])
 (^{:tag godotclj.api.gdscript.IGodotMaterial}
  getActiveMaterial
  [surface])
 (^{:tag godotclj.api.gdscript.IGodotMesh} getMesh [])
 (^{:tag godotclj.bindings.godot.NodePath} getSkeletonPath [])
 (^{:tag godotclj.api.gdscript.IGodotSkin} getSkin [])
 (^{:tag godotclj.api.gdscript.IGodotMaterial}
  getSurfaceMaterial
  [surface])
 (^{:tag int} getSurfaceMaterialCount [])
 (^{:tag boolean} isSoftwareSkinningTransformNormalsEnabled [])
 (^{:tag void} setMesh [mesh])
 (^{:tag void} setSkeletonPath [skeleton_path])
 (^{:tag void} setSkin [skin])
 (^{:tag void} setSoftwareSkinningTransformNormals [enabled])
 (^{:tag void} setSurfaceMaterial [surface material]))
(definterface MGodotVisualShaderNodeVectorSmoothStep)
(definterface
 MGodotFont
 (^{:tag void} draw [canvas_item position string])
 (^{:tag void} draw [canvas_item position string modulate])
 (^{:tag void} draw [canvas_item position string modulate clip_w])
 (^{:tag void}
  draw
  [canvas_item position string modulate clip_w outline_modulate])
 (^{:tag float} drawChar [canvas_item position char])
 (^{:tag float} drawChar [canvas_item position char next])
 (^{:tag float} drawChar [canvas_item position char next modulate])
 (^{:tag float}
  drawChar
  [canvas_item position char next modulate outline])
 (^{:tag float} getAscent [])
 (^{:tag godotclj.bindings.godot.Vector2} getCharSize [char])
 (^{:tag godotclj.bindings.godot.Vector2} getCharSize [char next])
 (^{:tag float} getDescent [])
 (^{:tag float} getHeight [])
 (^{:tag godotclj.bindings.godot.Vector2} getStringSize [string])
 (^{:tag godotclj.bindings.godot.Vector2}
  getWordwrapStringSize
  [string width])
 (^{:tag boolean} hasOutline [])
 (^{:tag boolean} isDistanceFieldHint [])
 (^{:tag void} updateChanges []))
(definterface
 MGodotLight2D
 (^{:tag godotclj.bindings.godot.Color} getColor [])
 (^{:tag float} getEnergy [])
 (^{:tag float} getHeight [])
 (^{:tag int} getItemCullMask [])
 (^{:tag int} getItemShadowCullMask [])
 (^{:tag int} getLayerRangeMax [])
 (^{:tag int} getLayerRangeMin [])
 (^{:tag int} getMode [])
 (^{:tag int} getShadowBufferSize [])
 (^{:tag godotclj.bindings.godot.Color} getShadowColor [])
 (^{:tag int} getShadowFilter [])
 (^{:tag float} getShadowGradientLength [])
 (^{:tag float} getShadowSmooth [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getTexture [])
 (^{:tag godotclj.bindings.godot.Vector2} getTextureOffset [])
 (^{:tag float} getTextureScale [])
 (^{:tag int} getZRangeMax [])
 (^{:tag int} getZRangeMin [])
 (^{:tag boolean} isEditorOnly [])
 (^{:tag boolean} isEnabled [])
 (^{:tag boolean} isShadowEnabled [])
 (^{:tag void} setColor [color])
 (^{:tag void} setEditorOnly [editor_only])
 (^{:tag void} setEnabled [enabled])
 (^{:tag void} setEnergy [energy])
 (^{:tag void} setHeight [height])
 (^{:tag void} setItemCullMask [item_cull_mask])
 (^{:tag void} setItemShadowCullMask [item_shadow_cull_mask])
 (^{:tag void} setLayerRangeMax [layer])
 (^{:tag void} setLayerRangeMin [layer])
 (^{:tag void} setMode [mode])
 (^{:tag void} setShadowBufferSize [size])
 (^{:tag void} setShadowColor [shadow_color])
 (^{:tag void} setShadowEnabled [enabled])
 (^{:tag void} setShadowFilter [filter])
 (^{:tag void} setShadowGradientLength [multiplier])
 (^{:tag void} setShadowSmooth [smooth])
 (^{:tag void} setTexture [texture])
 (^{:tag void} setTextureOffset [texture_offset])
 (^{:tag void} setTextureScale [texture_scale])
 (^{:tag void} setZRangeMax [z])
 (^{:tag void} setZRangeMin [z]))
(definterface
 MGodotVisibilityNotifier2D
 (^{:tag godotclj.bindings.godot.IndexedRect2} getRect [])
 (^{:tag boolean} isOnScreen [])
 (^{:tag void} setRect [rect]))
(definterface
 MGodotVisibilityEnabler2D
 (^{:tag boolean} isEnablerEnabled [enabler])
 (^{:tag void} setEnabler [enabler enabled]))
(definterface
 MGodotARVRServer
 (^{:tag void} centerOnHmd [rotation_mode keep_height])
 (^{:tag godotclj.api.gdscript.IGodotARVRInterface}
  findInterface
  [name])
 (^{:tag godotclj.bindings.godot.Transform} getHmdTransform [])
 (^{:tag godotclj.api.gdscript.IGodotARVRInterface}
  getInterface
  [idx])
 (^{:tag int} getInterfaceCount [])
 (^{:tag godotclj.bindings.godot.IndexedArray} getInterfaces [])
 (^{:tag int} getLastCommitUsec [])
 (^{:tag int} getLastFrameUsec [])
 (^{:tag int} getLastProcessUsec [])
 (^{:tag godotclj.api.gdscript.IGodotARVRInterface}
  getPrimaryInterface
  [])
 (^{:tag godotclj.bindings.godot.Transform} getReferenceFrame [])
 (^{:tag godotclj.api.gdscript.IGodotARVRPositionalTracker}
  getTracker
  [idx])
 (^{:tag int} getTrackerCount [])
 (^{:tag float} getWorldScale [])
 (^{:tag void} setPrimaryInterface [interface])
 (^{:tag void} setWorldScale [arg0]))
(definterface
 MGodotStaticBody
 (^{:tag float} getBounce [])
 (^{:tag godotclj.bindings.godot.Vector3}
  getConstantAngularVelocity
  [])
 (^{:tag godotclj.bindings.godot.Vector3}
  getConstantLinearVelocity
  [])
 (^{:tag float} getFriction [])
 (^{:tag godotclj.api.gdscript.IGodotPhysicsMaterial}
  getPhysicsMaterialOverride
  [])
 (^{:tag void} setBounce [bounce])
 (^{:tag void} setConstantAngularVelocity [vel])
 (^{:tag void} setConstantLinearVelocity [vel])
 (^{:tag void} setFriction [friction])
 (^{:tag void} setPhysicsMaterialOverride [physics_material_override]))
(definterface
 MGodotPhysicsMaterial
 (^{:tag float} getBounce [])
 (^{:tag float} getFriction [])
 (^{:tag boolean} isAbsorbent [])
 (^{:tag boolean} isRough [])
 (^{:tag void} setAbsorbent [absorbent])
 (^{:tag void} setBounce [bounce])
 (^{:tag void} setFriction [friction])
 (^{:tag void} setRough [rough]))
(definterface
 MGodotEditorResourcePreviewGenerator
 (^{:tag boolean} canGenerateSmallPreview [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} generate [from size])
 (^{:tag godotclj.api.gdscript.IGodotTexture}
  generateFromPath
  [path size])
 (^{:tag boolean} generateSmallPreviewAutomatically [])
 (^{:tag boolean} handles [type]))
(definterface MGodotSeparator)
(definterface MGodotVSeparator)
(definterface
 MGodotInputEventJoypadMotion
 (^{:tag int} getAxis [])
 (^{:tag float} getAxisValue [])
 (^{:tag void} setAxis [axis])
 (^{:tag void} setAxisValue [axis_value]))
(definterface
 MGodotWebSocketMultiplayerPeer
 (^{:tag godotclj.api.gdscript.IGodotWebSocketPeer} getPeer [peer_id])
 (^{:tag int}
  setBuffers
  [input_buffer_size_kb
   input_max_packets
   output_buffer_size_kb
   output_max_packets]))
(definterface
 MGodotWebSocketServer
 (^{:tag void} disconnectPeer [id])
 (^{:tag void} disconnectPeer [id code])
 (^{:tag void} disconnectPeer [id code reason])
 (^{:tag String} getBindIp [])
 (^{:tag godotclj.api.gdscript.IGodotX509Certificate} getCaChain [])
 (^{:tag String} getPeerAddress [id])
 (^{:tag int} getPeerPort [id])
 (^{:tag godotclj.api.gdscript.IGodotCryptoKey} getPrivateKey [])
 (^{:tag godotclj.api.gdscript.IGodotX509Certificate}
  getSslCertificate
  [])
 (^{:tag boolean} hasPeer [id])
 (^{:tag boolean} isListening [])
 (^{:tag int} listen [port])
 (^{:tag int} listen [port protocols])
 (^{:tag int} listen [port protocols gd_mp_api])
 (^{:tag void} setBindIp [arg0])
 (^{:tag void} setCaChain [arg0])
 (^{:tag void} setPrivateKey [arg0])
 (^{:tag void} setSslCertificate [arg0])
 (^{:tag void} stop []))
(definterface
 MGodotCameraServer
 (^{:tag void} addFeed [feed])
 (^{:tag godotclj.bindings.godot.IndexedArray} feeds [])
 (^{:tag godotclj.api.gdscript.IGodotCameraFeed} getFeed [index])
 (^{:tag int} getFeedCount [])
 (^{:tag void} removeFeed [feed]))
(definterface
 MGodotMainLoop
 (^{:tag void} finish [])
 (^{:tag boolean} idle [delta])
 (^{:tag void} init [])
 (^{:tag void} inputEvent [event])
 (^{:tag void} inputText [text])
 (^{:tag boolean} iteration [delta]))
(definterface
 MGodotAnimationNodeStateMachinePlayback
 (^{:tag float} getCurrentLength [])
 (^{:tag String} getCurrentNode [])
 (^{:tag float} getCurrentPlayPosition [])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  getTravelPath
  [])
 (^{:tag boolean} isPlaying [])
 (^{:tag void} start [node])
 (^{:tag void} stop [])
 (^{:tag void} travel [to_node]))
(definterface
 MGodotPlaneShape
 (^{:tag godotclj.bindings.godot.Plane} getPlane [])
 (^{:tag void} setPlane [plane]))
(definterface MGodotVisualShaderNodeDotProduct)
(definterface
 MGodotOccluderPolygon2D
 (^{:tag int} getCullMode [])
 (^{:tag godotclj.bindings.godot.IndexedPoolVector2Array}
  getPolygon
  [])
 (^{:tag boolean} isClosed [])
 (^{:tag void} setClosed [closed])
 (^{:tag void} setCullMode [cull_mode])
 (^{:tag void} setPolygon [polygon]))
(definterface
 MGodotEditorSelection
 (^{:tag void} addNode [node])
 (^{:tag void} clear [])
 (^{:tag godotclj.bindings.godot.IndexedArray} getSelectedNodes [])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  getTransformableSelectedNodes
  [])
 (^{:tag void} removeNode [node]))
(definterface
 MGodotRayCast2D
 (^{:tag void} addException [node])
 (^{:tag void} addExceptionRid [rid])
 (^{:tag void} clearExceptions [])
 (^{:tag void} forceRaycastUpdate [])
 (^{:tag godotclj.bindings.godot.Vector2} getCastTo [])
 (^{:tag godotclj.api.gdscript.IGodotObject} getCollider [])
 (^{:tag int} getColliderShape [])
 (^{:tag int} getCollisionMask [])
 (^{:tag boolean} getCollisionMaskBit [bit])
 (^{:tag godotclj.bindings.godot.Vector2} getCollisionNormal [])
 (^{:tag godotclj.bindings.godot.Vector2} getCollisionPoint [])
 (^{:tag boolean} getExcludeParentBody [])
 (^{:tag boolean} isCollideWithAreasEnabled [])
 (^{:tag boolean} isCollideWithBodiesEnabled [])
 (^{:tag boolean} isColliding [])
 (^{:tag boolean} isEnabled [])
 (^{:tag void} removeException [node])
 (^{:tag void} removeExceptionRid [rid])
 (^{:tag void} setCastTo [local_point])
 (^{:tag void} setCollideWithAreas [enable])
 (^{:tag void} setCollideWithBodies [enable])
 (^{:tag void} setCollisionMask [mask])
 (^{:tag void} setCollisionMaskBit [bit value])
 (^{:tag void} setEnabled [enabled])
 (^{:tag void} setExcludeParentBody [mask]))
(definterface
 MGodotScrollContainer
 (^{:tag int} getDeadzone [])
 (^{:tag int} getHScroll [])
 (^{:tag godotclj.api.gdscript.IGodotHScrollBar} getHScrollbar [])
 (^{:tag int} getVScroll [])
 (^{:tag godotclj.api.gdscript.IGodotVScrollBar} getVScrollbar [])
 (^{:tag boolean} isFollowingFocus [])
 (^{:tag boolean} isHScrollEnabled [])
 (^{:tag boolean} isVScrollEnabled [])
 (^{:tag void} setDeadzone [deadzone])
 (^{:tag void} setEnableHScroll [enable])
 (^{:tag void} setEnableVScroll [enable])
 (^{:tag void} setFollowFocus [enabled])
 (^{:tag void} setHScroll [value])
 (^{:tag void} setVScroll [value]))
(definterface
 MGodotAudioStreamRandomPitch
 (^{:tag godotclj.api.gdscript.IGodotAudioStream} getAudioStream [])
 (^{:tag float} getRandomPitch [])
 (^{:tag void} setAudioStream [stream])
 (^{:tag void} setRandomPitch [scale]))
(definterface MGodotVisualShaderNodeVectorScalarSmoothStep)
(definterface
 MGodotAnimationNodeBlend3
 (^{:tag boolean} isUsingSync [])
 (^{:tag void} setUseSync [enable]))
(definterface MGodotVisualShaderNodeVectorScalarStep)
(definterface
 MGodot_VisualScriptEditor
 (^{:tag void} addCustomNode [name category script])
 (^{:tag void} removeCustomNode [name category]))
(definterface
 MGodotCamera2D
 (^{:tag void} align [])
 (^{:tag void} clearCurrent [])
 (^{:tag void} forceUpdateScroll [])
 (^{:tag int} getAnchorMode [])
 (^{:tag godotclj.bindings.godot.Vector2} getCameraPosition [])
 (^{:tag godotclj.bindings.godot.Vector2} getCameraScreenCenter [])
 (^{:tag godotclj.api.gdscript.IGodotNode} getCustomViewport [])
 (^{:tag float} getDragMargin [margin])
 (^{:tag float} getFollowSmoothing [])
 (^{:tag float} getHOffset [])
 (^{:tag int} getLimit [margin])
 (^{:tag godotclj.bindings.godot.Vector2} getOffset [])
 (^{:tag int} getProcessMode [])
 (^{:tag float} getVOffset [])
 (^{:tag godotclj.bindings.godot.Vector2} getZoom [])
 (^{:tag boolean} isCurrent [])
 (^{:tag boolean} isFollowSmoothingEnabled [])
 (^{:tag boolean} isHDragEnabled [])
 (^{:tag boolean} isLimitDrawingEnabled [])
 (^{:tag boolean} isLimitSmoothingEnabled [])
 (^{:tag boolean} isMarginDrawingEnabled [])
 (^{:tag boolean} isRotating [])
 (^{:tag boolean} isScreenDrawingEnabled [])
 (^{:tag boolean} isVDragEnabled [])
 (^{:tag void} makeCurrent [])
 (^{:tag void} resetSmoothing [])
 (^{:tag void} setAnchorMode [anchor_mode])
 (^{:tag void} setCustomViewport [viewport])
 (^{:tag void} setDragMargin [margin drag_margin])
 (^{:tag void} setEnableFollowSmoothing [follow_smoothing])
 (^{:tag void} setFollowSmoothing [follow_smoothing])
 (^{:tag void} setHDragEnabled [enabled])
 (^{:tag void} setHOffset [ofs])
 (^{:tag void} setLimit [margin limit])
 (^{:tag void} setLimitDrawingEnabled [limit_drawing_enabled])
 (^{:tag void} setLimitSmoothingEnabled [limit_smoothing_enabled])
 (^{:tag void} setMarginDrawingEnabled [margin_drawing_enabled])
 (^{:tag void} setOffset [offset])
 (^{:tag void} setProcessMode [mode])
 (^{:tag void} setRotating [rotating])
 (^{:tag void} setScreenDrawingEnabled [screen_drawing_enabled])
 (^{:tag void} setVDragEnabled [enabled])
 (^{:tag void} setVOffset [ofs])
 (^{:tag void} setZoom [zoom]))
(definterface MGodotVisualShaderNodeIf)
(definterface
 MGodotArrayMesh
 (^{:tag void} addBlendShape [name])
 (^{:tag void} addSurfaceFromArrays [primitive arrays])
 (^{:tag void} addSurfaceFromArrays [primitive arrays blend_shapes])
 (^{:tag void}
  addSurfaceFromArrays
  [primitive arrays blend_shapes compress_flags])
 (^{:tag void} clearBlendShapes [])
 (^{:tag int} getBlendShapeCount [])
 (^{:tag int} getBlendShapeMode [])
 (^{:tag String} getBlendShapeName [index])
 (^{:tag godotclj.bindings.godot.AABB} getCustomAabb [])
 (^{:tag int} lightmapUnwrap [transform texel_size])
 (^{:tag void} regenNormalmaps [])
 (^{:tag void} setBlendShapeMode [mode])
 (^{:tag void} setCustomAabb [aabb])
 (^{:tag int} surfaceFindByName [name])
 (^{:tag int} surfaceGetArrayIndexLen [surf_idx])
 (^{:tag int} surfaceGetArrayLen [surf_idx])
 (^{:tag int} surfaceGetFormat [surf_idx])
 (^{:tag String} surfaceGetName [surf_idx])
 (^{:tag int} surfaceGetPrimitiveType [surf_idx])
 (^{:tag void} surfaceRemove [surf_idx])
 (^{:tag void} surfaceSetName [surf_idx name])
 (^{:tag void} surfaceUpdateRegion [surf_idx offset data]))
(definterface
 MGodotInput
 (^{:tag void} actionPress [action])
 (^{:tag void} actionPress [action strength])
 (^{:tag void} actionRelease [action])
 (^{:tag void} addJoyMapping [mapping])
 (^{:tag void} addJoyMapping [mapping update_existing])
 (^{:tag godotclj.bindings.godot.Vector3} getAccelerometer [])
 (^{:tag float} getActionStrength [action])
 (^{:tag godotclj.bindings.godot.IndexedArray} getConnectedJoypads [])
 (^{:tag int} getCurrentCursorShape [])
 (^{:tag godotclj.bindings.godot.Vector3} getGravity [])
 (^{:tag godotclj.bindings.godot.Vector3} getGyroscope [])
 (^{:tag float} getJoyAxis [device axis])
 (^{:tag int} getJoyAxisIndexFromString [axis])
 (^{:tag String} getJoyAxisString [axis_index])
 (^{:tag int} getJoyButtonIndexFromString [button])
 (^{:tag String} getJoyButtonString [button_index])
 (^{:tag String} getJoyGuid [device])
 (^{:tag String} getJoyName [device])
 (^{:tag float} getJoyVibrationDuration [device])
 (^{:tag godotclj.bindings.godot.Vector2}
  getJoyVibrationStrength
  [device])
 (^{:tag godotclj.bindings.godot.Vector2} getLastMouseSpeed [])
 (^{:tag godotclj.bindings.godot.Vector3} getMagnetometer [])
 (^{:tag int} getMouseButtonMask [])
 (^{:tag int} getMouseMode [])
 (^{:tag boolean} isActionJustPressed [action])
 (^{:tag boolean} isActionJustReleased [action])
 (^{:tag boolean} isActionPressed [action])
 (^{:tag boolean} isJoyButtonPressed [device button])
 (^{:tag boolean} isJoyKnown [device])
 (^{:tag boolean} isKeyPressed [scancode])
 (^{:tag boolean} isMouseButtonPressed [button])
 (^{:tag void} joyConnectionChanged [device connected name guid])
 (^{:tag void} parseInputEvent [event])
 (^{:tag void} removeJoyMapping [guid])
 (^{:tag void} setCustomMouseCursor [image])
 (^{:tag void} setCustomMouseCursor [image shape])
 (^{:tag void} setCustomMouseCursor [image shape hotspot])
 (^{:tag void} setDefaultCursorShape [])
 (^{:tag void} setDefaultCursorShape [shape])
 (^{:tag void} setMouseMode [mode])
 (^{:tag void} setUseAccumulatedInput [enable])
 (^{:tag void}
  startJoyVibration
  [device weak_magnitude strong_magnitude])
 (^{:tag void}
  startJoyVibration
  [device weak_magnitude strong_magnitude duration])
 (^{:tag void} stopJoyVibration [device])
 (^{:tag void} vibrateHandheld [])
 (^{:tag void} vibrateHandheld [duration_ms])
 (^{:tag void} warpMousePosition [to]))
(definterface MGodotMarginContainer)
(definterface MGodotVisualScriptIndexSet)
(definterface MGodotTextFile)
(definterface
 MGodotAudioEffectPhaser
 (^{:tag float} getDepth [])
 (^{:tag float} getFeedback [])
 (^{:tag float} getRangeMaxHz [])
 (^{:tag float} getRangeMinHz [])
 (^{:tag float} getRateHz [])
 (^{:tag void} setDepth [depth])
 (^{:tag void} setFeedback [fbk])
 (^{:tag void} setRangeMaxHz [hz])
 (^{:tag void} setRangeMinHz [hz])
 (^{:tag void} setRateHz [hz]))
(definterface
 MGodotYSort
 (^{:tag boolean} isSortEnabled [])
 (^{:tag void} setSortEnabled [enabled]))
(definterface
 MGodotVisualScriptDeconstruct
 (^{:tag int} getDeconstructType [])
 (^{:tag void} setDeconstructType [type]))
(definterface
 MGodotSphereMesh
 (^{:tag float} getHeight [])
 (^{:tag boolean} getIsHemisphere [])
 (^{:tag int} getRadialSegments [])
 (^{:tag float} getRadius [])
 (^{:tag int} getRings [])
 (^{:tag void} setHeight [height])
 (^{:tag void} setIsHemisphere [is_hemisphere])
 (^{:tag void} setRadialSegments [radial_segments])
 (^{:tag void} setRadius [radius])
 (^{:tag void} setRings [rings]))
(definterface
 MGodotStyleBox
 (^{:tag void} draw [canvas_item rect])
 (^{:tag godotclj.bindings.godot.Vector2} getCenterSize [])
 (^{:tag godotclj.api.gdscript.IGodotCanvasItem}
  getCurrentItemDrawn
  [])
 (^{:tag float} getDefaultMargin [margin])
 (^{:tag float} getMargin [margin])
 (^{:tag godotclj.bindings.godot.Vector2} getMinimumSize [])
 (^{:tag godotclj.bindings.godot.Vector2} getOffset [])
 (^{:tag void} setDefaultMargin [margin offset])
 (^{:tag boolean} testMask [point rect]))
(definterface
 MGodotStyleBoxLine
 (^{:tag godotclj.bindings.godot.Color} getColor [])
 (^{:tag float} getGrowBegin [])
 (^{:tag float} getGrowEnd [])
 (^{:tag int} getThickness [])
 (^{:tag boolean} isVertical [])
 (^{:tag void} setColor [color])
 (^{:tag void} setGrowBegin [offset])
 (^{:tag void} setGrowEnd [offset])
 (^{:tag void} setThickness [thickness])
 (^{:tag void} setVertical [vertical]))
(definterface
 MGodotSkeleton2D
 (^{:tag godotclj.api.gdscript.IGodotBone2D} getBone [idx])
 (^{:tag int} getBoneCount [])
 (^{:tag godotclj.bindings.godot.RID} getSkeleton []))
(definterface
 MGodotCollisionPolygon2D
 (^{:tag int} getBuildMode [])
 (^{:tag float} getOneWayCollisionMargin [])
 (^{:tag godotclj.bindings.godot.IndexedPoolVector2Array}
  getPolygon
  [])
 (^{:tag boolean} isDisabled [])
 (^{:tag boolean} isOneWayCollisionEnabled [])
 (^{:tag void} setBuildMode [build_mode])
 (^{:tag void} setDisabled [disabled])
 (^{:tag void} setOneWayCollision [enabled])
 (^{:tag void} setOneWayCollisionMargin [margin])
 (^{:tag void} setPolygon [polygon]))
(definterface
 MGodotVisualScriptSelect
 (^{:tag int} getTyped [])
 (^{:tag void} setTyped [type]))
(definterface
 MGodotAnimationNodeTransition
 (^{:tag float} getCrossFadeTime [])
 (^{:tag int} getEnabledInputs [])
 (^{:tag String} getInputCaption [input])
 (^{:tag boolean} isInputSetAsAutoAdvance [input])
 (^{:tag void} setCrossFadeTime [time])
 (^{:tag void} setEnabledInputs [amount])
 (^{:tag void} setInputAsAutoAdvance [input enable])
 (^{:tag void} setInputCaption [input caption]))
(definterface MGodotAnimationTrackEditPlugin)
(definterface
 MGodotEditorSpatialGizmoPlugin
 (^{:tag void} addMaterial [name material])
 (^{:tag boolean} canBeHidden [])
 (^{:tag void} commitHandle [gizmo index restore cancel])
 (^{:tag godotclj.api.gdscript.IGodotEditorSpatialGizmo}
  createGizmo
  [spatial])
 (^{:tag void} createHandleMaterial [name])
 (^{:tag void} createHandleMaterial [name billboard])
 (^{:tag void} createIconMaterial [name texture])
 (^{:tag void} createIconMaterial [name texture on_top])
 (^{:tag void} createIconMaterial [name texture on_top color])
 (^{:tag void} createMaterial [name color])
 (^{:tag void} createMaterial [name color billboard])
 (^{:tag void} createMaterial [name color billboard on_top])
 (^{:tag void}
  createMaterial
  [name color billboard on_top use_vertex_color])
 (^{:tag String} getHandleName [gizmo index])
 (^{:tag godotclj.bindings.godot.Variant}
  getHandleValue
  [gizmo index])
 (^{:tag godotclj.api.gdscript.IGodotSpatialMaterial}
  getMaterial
  [name])
 (^{:tag godotclj.api.gdscript.IGodotSpatialMaterial}
  getMaterial
  [name gizmo])
 (^{:tag String} getName [])
 (^{:tag int} getPriority [])
 (^{:tag boolean} hasGizmo [spatial])
 (^{:tag boolean} isHandleHighlighted [gizmo index])
 (^{:tag boolean} isSelectableWhenHidden [])
 (^{:tag void} redraw [gizmo])
 (^{:tag void} setHandle [gizmo index camera point]))
(definterface MGodotInputDefault)
(definterface
 MGodotSpriteFrames
 (^{:tag void} addAnimation [anim])
 (^{:tag void} addFrame [anim frame])
 (^{:tag void} addFrame [anim frame at_position])
 (^{:tag void} clear [anim])
 (^{:tag void} clearAll [])
 (^{:tag boolean} getAnimationLoop [anim])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  getAnimationNames
  [])
 (^{:tag float} getAnimationSpeed [anim])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getFrame [anim idx])
 (^{:tag int} getFrameCount [anim])
 (^{:tag boolean} hasAnimation [anim])
 (^{:tag void} removeAnimation [anim])
 (^{:tag void} removeFrame [anim idx])
 (^{:tag void} renameAnimation [anim newname])
 (^{:tag void} setAnimationLoop [anim loop])
 (^{:tag void} setAnimationSpeed [anim speed])
 (^{:tag void} setFrame [anim idx txt]))
(definterface
 MGodotBoxShape
 (^{:tag godotclj.bindings.godot.Vector3} getExtents [])
 (^{:tag void} setExtents [extents]))
(definterface
 MGodotVisualScriptBuiltinFunc
 (^{:tag int} getFunc [])
 (^{:tag void} setFunc [which]))
(definterface
 MGodotInputEventPanGesture
 (^{:tag godotclj.bindings.godot.Vector2} getDelta [])
 (^{:tag void} setDelta [delta]))
(definterface
 MGodotGraphEdit
 (^{:tag void} addValidConnectionType [from_type to_type])
 (^{:tag void} addValidLeftDisconnectType [type])
 (^{:tag void} addValidRightDisconnectType [type])
 (^{:tag void} clearConnections [])
 (^{:tag int} connectNode [from from_port to to_port])
 (^{:tag void} disconnectNode [from from_port to to_port])
 (^{:tag godotclj.bindings.godot.IndexedArray} getConnectionList [])
 (^{:tag float} getMinimapOpacity [])
 (^{:tag godotclj.bindings.godot.Vector2} getMinimapSize [])
 (^{:tag godotclj.bindings.godot.Vector2} getScrollOfs [])
 (^{:tag int} getSnap [])
 (^{:tag float} getZoom [])
 (^{:tag godotclj.api.gdscript.IGodotHBoxContainer} getZoomHbox [])
 (^{:tag boolean} isMinimapEnabled [])
 (^{:tag boolean} isNodeConnected [from from_port to to_port])
 (^{:tag boolean} isRightDisconnectsEnabled [])
 (^{:tag boolean} isUsingSnap [])
 (^{:tag boolean} isValidConnectionType [from_type to_type])
 (^{:tag void} removeValidConnectionType [from_type to_type])
 (^{:tag void} removeValidLeftDisconnectType [type])
 (^{:tag void} removeValidRightDisconnectType [type])
 (^{:tag void}
  setConnectionActivity
  [from from_port to to_port amount])
 (^{:tag void} setMinimapEnabled [enable])
 (^{:tag void} setMinimapOpacity [p_opacity])
 (^{:tag void} setMinimapSize [p_size])
 (^{:tag void} setRightDisconnects [enable])
 (^{:tag void} setScrollOfs [ofs])
 (^{:tag void} setSelected [node])
 (^{:tag void} setSnap [pixels])
 (^{:tag void} setUseSnap [enable])
 (^{:tag void} setZoom [p_zoom]))
(definterface MGodotVisualShaderNodeVectorDecompose)
(definterface
 MGodotAtlasTexture
 (^{:tag godotclj.api.gdscript.IGodotTexture} getAtlas [])
 (^{:tag godotclj.bindings.godot.IndexedRect2} getMargin [])
 (^{:tag godotclj.bindings.godot.IndexedRect2} getRegion [])
 (^{:tag boolean} hasFilterClip [])
 (^{:tag void} setAtlas [atlas])
 (^{:tag void} setFilterClip [enable])
 (^{:tag void} setMargin [margin])
 (^{:tag void} setRegion [region]))
(definterface
 MGodotImageTexture
 (^{:tag void} create [width height format])
 (^{:tag void} create [width height format flags])
 (^{:tag void} createFromImage [image])
 (^{:tag void} createFromImage [image flags])
 (^{:tag int} getFormat [])
 (^{:tag float} getLossyStorageQuality [])
 (^{:tag int} getStorage [])
 (^{:tag int} load [path])
 (^{:tag void} setData [image])
 (^{:tag void} setLossyStorageQuality [quality])
 (^{:tag void} setSizeOverride [size])
 (^{:tag void} setStorage [mode]))
(definterface
 MGodotHeightMapShape
 (^{:tag godotclj.bindings.godot.PoolRealArray} getMapData [])
 (^{:tag int} getMapDepth [])
 (^{:tag int} getMapWidth [])
 (^{:tag void} setMapData [data])
 (^{:tag void} setMapDepth [height])
 (^{:tag void} setMapWidth [width]))
(definterface MGodotHSeparator)
(definterface
 MGodotCircleShape2D
 (^{:tag float} getRadius [])
 (^{:tag void} setRadius [radius]))
(definterface
 MGodotVisualScript
 (^{:tag void} addCustomSignal [name])
 (^{:tag void} addFunction [name])
 (^{:tag void} addNode [func id node])
 (^{:tag void} addNode [func id node position])
 (^{:tag void} addVariable [name])
 (^{:tag void} addVariable [name default_value])
 (^{:tag void} addVariable [name default_value export])
 (^{:tag void} customSignalAddArgument [name type argname])
 (^{:tag void} customSignalAddArgument [name type argname index])
 (^{:tag int} customSignalGetArgumentCount [name])
 (^{:tag String} customSignalGetArgumentName [name argidx])
 (^{:tag int} customSignalGetArgumentType [name argidx])
 (^{:tag void} customSignalRemoveArgument [name argidx])
 (^{:tag void} customSignalSetArgumentName [name argidx argname])
 (^{:tag void} customSignalSetArgumentType [name argidx type])
 (^{:tag void} customSignalSwapArgument [name argidx withidx])
 (^{:tag void} dataConnect [func from_node from_port to_node to_port])
 (^{:tag void}
  dataDisconnect
  [func from_node from_port to_node to_port])
 (^{:tag int} getFunctionNodeId [name])
 (^{:tag godotclj.bindings.godot.Vector2} getFunctionScroll [name])
 (^{:tag godotclj.api.gdscript.IGodotVisualScriptNode}
  getNode
  [func id])
 (^{:tag godotclj.bindings.godot.Vector2} getNodePosition [func id])
 (^{:tag godotclj.bindings.godot.Variant}
  getVariableDefaultValue
  [name])
 (^{:tag boolean} getVariableExport [name])
 (^{:tag godotclj.bindings.godot.Dictionary} getVariableInfo [name])
 (^{:tag boolean} hasCustomSignal [name])
 (^{:tag boolean}
  hasDataConnection
  [func from_node from_port to_node to_port])
 (^{:tag boolean} hasFunction [name])
 (^{:tag boolean} hasNode [func id])
 (^{:tag boolean}
  hasSequenceConnection
  [func from_node from_output to_node])
 (^{:tag boolean} hasVariable [name])
 (^{:tag void} removeCustomSignal [name])
 (^{:tag void} removeFunction [name])
 (^{:tag void} removeNode [func id])
 (^{:tag void} removeVariable [name])
 (^{:tag void} renameCustomSignal [name new_name])
 (^{:tag void} renameFunction [name new_name])
 (^{:tag void} renameVariable [name new_name])
 (^{:tag void} sequenceConnect [func from_node from_output to_node])
 (^{:tag void}
  sequenceDisconnect
  [func from_node from_output to_node])
 (^{:tag void} setFunctionScroll [name ofs])
 (^{:tag void} setInstanceBaseType [type])
 (^{:tag void} setNodePosition [func id position])
 (^{:tag void} setVariableDefaultValue [name value])
 (^{:tag void} setVariableExport [name enable])
 (^{:tag void} setVariableInfo [name value]))
(definterface
 MGodotNavigation2D
 (^{:tag godotclj.bindings.godot.Vector2} getClosestPoint [to_point])
 (^{:tag godotclj.api.gdscript.IGodotObject}
  getClosestPointOwner
  [to_point])
 (^{:tag godotclj.bindings.godot.IndexedPoolVector2Array}
  getSimplePath
  [start end])
 (^{:tag godotclj.bindings.godot.IndexedPoolVector2Array}
  getSimplePath
  [start end optimize])
 (^{:tag int} navpolyAdd [mesh xform])
 (^{:tag int} navpolyAdd [mesh xform owner])
 (^{:tag void} navpolyRemove [id])
 (^{:tag void} navpolySetTransform [id xform]))
(definterface MGodotVisualShaderNodeVectorRefract)
(definterface
 MGodotSliderJoint
 (^{:tag float} getParam [param])
 (^{:tag void} setParam [param value]))
(definterface
 MGodotProjectSettings
 (^{:tag void} addPropertyInfo [hint])
 (^{:tag void} clear [name])
 (^{:tag int} getOrder [name])
 (^{:tag godotclj.bindings.godot.Variant} getSetting [name])
 (^{:tag String} globalizePath [path])
 (^{:tag boolean} hasSetting [name])
 (^{:tag boolean} loadResourcePack [pack])
 (^{:tag boolean} loadResourcePack [pack replace_files])
 (^{:tag boolean} loadResourcePack [pack replace_files offset])
 (^{:tag String} localizePath [path])
 (^{:tag boolean} propertyCanRevert [name])
 (^{:tag godotclj.bindings.godot.Variant} propertyGetRevert [name])
 (^{:tag int} save [])
 (^{:tag int} saveCustom [file])
 (^{:tag void} setInitialValue [name value])
 (^{:tag void} setOrder [name position])
 (^{:tag void} setSetting [name value]))
(definterface
 MGodotStreamPeerTCP
 (^{:tag int} connectToHost [host port])
 (^{:tag void} disconnectFromHost [])
 (^{:tag String} getConnectedHost [])
 (^{:tag int} getConnectedPort [])
 (^{:tag int} getStatus [])
 (^{:tag boolean} isConnectedToHost [])
 (^{:tag void} setNoDelay [enabled]))
(definterface MGodotAudioEffectBandPassFilter)
(definterface
 MGodotSpringArm
 (^{:tag void} addExcludedObject [RID])
 (^{:tag void} clearExcludedObjects [])
 (^{:tag int} getCollisionMask [])
 (^{:tag float} getHitLength [])
 (^{:tag float} getLength [])
 (^{:tag float} getMargin [])
 (^{:tag godotclj.api.gdscript.IGodotShape} getShape [])
 (^{:tag boolean} removeExcludedObject [RID])
 (^{:tag void} setCollisionMask [mask])
 (^{:tag void} setLength [length])
 (^{:tag void} setMargin [margin])
 (^{:tag void} setShape [shape]))
(definterface
 MGodotEditorProperty
 (^{:tag void} addFocusable [control])
 (^{:tag void} emitChanged [property value])
 (^{:tag void} emitChanged [property value field])
 (^{:tag void} emitChanged [property value field changing])
 (^{:tag godotclj.api.gdscript.IGodotObject} getEditedObject [])
 (^{:tag String} getEditedProperty [])
 (^{:tag String} getLabel [])
 (^{:tag String} getTooltipText [])
 (^{:tag boolean} isCheckable [])
 (^{:tag boolean} isChecked [])
 (^{:tag boolean} isDrawRed [])
 (^{:tag boolean} isKeying [])
 (^{:tag boolean} isReadOnly [])
 (^{:tag void} setBottomEditor [editor])
 (^{:tag void} setCheckable [checkable])
 (^{:tag void} setChecked [checked])
 (^{:tag void} setDrawRed [draw_red])
 (^{:tag void} setKeying [keying])
 (^{:tag void} setLabel [text])
 (^{:tag void} setReadOnly [read_only])
 (^{:tag void} updateProperty []))
(definterface
 MGodotVisualShaderNodeTransformVecMult
 (^{:tag int} getOperator [])
 (^{:tag void} setOperator [op]))
(definterface
 MGodotJoint2D
 (^{:tag float} getBias [])
 (^{:tag boolean} getExcludeNodesFromCollision [])
 (^{:tag godotclj.bindings.godot.NodePath} getNodeA [])
 (^{:tag godotclj.bindings.godot.NodePath} getNodeB [])
 (^{:tag void} setBias [bias])
 (^{:tag void} setExcludeNodesFromCollision [enable])
 (^{:tag void} setNodeA [node])
 (^{:tag void} setNodeB [node]))
(definterface
 MGodotVisualShaderNodeVec3Constant
 (^{:tag godotclj.bindings.godot.Vector3} getConstant [])
 (^{:tag void} setConstant [value]))
(definterface
 MGodotCSGBox
 (^{:tag float} getDepth [])
 (^{:tag float} getHeight [])
 (^{:tag godotclj.api.gdscript.IGodotMaterial} getMaterial [])
 (^{:tag float} getWidth [])
 (^{:tag void} setDepth [depth])
 (^{:tag void} setHeight [height])
 (^{:tag void} setMaterial [material])
 (^{:tag void} setWidth [width]))
(definterface
 MGodotProximityGroup
 (^{:tag void} broadcast [method parameters])
 (^{:tag int} getDispatchMode [])
 (^{:tag godotclj.bindings.godot.Vector3} getGridRadius [])
 (^{:tag String} getGroupName [])
 (^{:tag void} setDispatchMode [mode])
 (^{:tag void} setGridRadius [radius])
 (^{:tag void} setGroupName [name]))
(definterface
 MGodotEditorFileDialog
 (^{:tag void} addFilter [filter])
 (^{:tag void} clearFilters [])
 (^{:tag int} getAccess [])
 (^{:tag String} getCurrentDir [])
 (^{:tag String} getCurrentFile [])
 (^{:tag String} getCurrentPath [])
 (^{:tag int} getDisplayMode [])
 (^{:tag int} getMode [])
 (^{:tag godotclj.api.gdscript.IGodotVBoxContainer} getVbox [])
 (^{:tag void} invalidate [])
 (^{:tag boolean} isOverwriteWarningDisabled [])
 (^{:tag boolean} isShowingHiddenFiles [])
 (^{:tag void} setAccess [access])
 (^{:tag void} setCurrentDir [dir])
 (^{:tag void} setCurrentFile [file])
 (^{:tag void} setCurrentPath [path])
 (^{:tag void} setDisableOverwriteWarning [disable])
 (^{:tag void} setDisplayMode [mode])
 (^{:tag void} setMode [mode])
 (^{:tag void} setShowHiddenFiles [show]))
(definterface
 MGodot_ClassDB
 (^{:tag boolean} canInstance [class])
 (^{:tag boolean} classExists [class])
 (^{:tag String} classGetCategory [class])
 (^{:tag int} classGetIntegerConstant [class name])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  classGetIntegerConstantList
  [class])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  classGetIntegerConstantList
  [class no_inheritance])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  classGetMethodList
  [class])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  classGetMethodList
  [class no_inheritance])
 (^{:tag godotclj.bindings.godot.Variant}
  classGetProperty
  [object property])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  classGetPropertyList
  [class])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  classGetPropertyList
  [class no_inheritance])
 (^{:tag godotclj.bindings.godot.Dictionary}
  classGetSignal
  [class signal])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  classGetSignalList
  [class])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  classGetSignalList
  [class no_inheritance])
 (^{:tag boolean} classHasIntegerConstant [class name])
 (^{:tag boolean} classHasMethod [class method])
 (^{:tag boolean} classHasMethod [class method no_inheritance])
 (^{:tag boolean} classHasSignal [class signal])
 (^{:tag int} classSetProperty [object property value])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  getClassList
  [])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  getInheritersFromClass
  [class])
 (^{:tag String} getParentClass [class])
 (^{:tag godotclj.bindings.godot.Variant} instance [class])
 (^{:tag boolean} isClassEnabled [class])
 (^{:tag boolean} isParentClass [class inherits]))
(definterface
 MGodotTabs
 (^{:tag void} addTab [])
 (^{:tag void} addTab [title])
 (^{:tag void} addTab [title icon])
 (^{:tag void} ensureTabVisible [idx])
 (^{:tag int} getCurrentTab [])
 (^{:tag boolean} getDragToRearrangeEnabled [])
 (^{:tag boolean} getOffsetButtonsVisible [])
 (^{:tag int} getPreviousTab [])
 (^{:tag boolean} getScrollingEnabled [])
 (^{:tag boolean} getSelectWithRmb [])
 (^{:tag int} getTabAlign [])
 (^{:tag int} getTabCloseDisplayPolicy [])
 (^{:tag int} getTabCount [])
 (^{:tag boolean} getTabDisabled [tab_idx])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getTabIcon [tab_idx])
 (^{:tag int} getTabOffset [])
 (^{:tag godotclj.bindings.godot.IndexedRect2} getTabRect [tab_idx])
 (^{:tag String} getTabTitle [tab_idx])
 (^{:tag int} getTabsRearrangeGroup [])
 (^{:tag void} moveTab [from to])
 (^{:tag void} removeTab [tab_idx])
 (^{:tag void} setCurrentTab [tab_idx])
 (^{:tag void} setDragToRearrangeEnabled [enabled])
 (^{:tag void} setScrollingEnabled [enabled])
 (^{:tag void} setSelectWithRmb [enabled])
 (^{:tag void} setTabAlign [align])
 (^{:tag void} setTabCloseDisplayPolicy [policy])
 (^{:tag void} setTabDisabled [tab_idx disabled])
 (^{:tag void} setTabIcon [tab_idx icon])
 (^{:tag void} setTabTitle [tab_idx title])
 (^{:tag void} setTabsRearrangeGroup [group_id]))
(definterface
 MGodotVisualScriptEngineSingleton
 (^{:tag String} getSingleton [])
 (^{:tag void} setSingleton [name]))
(definterface MGodotSpatialGizmo)
(definterface
 MGodotEditorSpatialGizmo
 (^{:tag void} addCollisionSegments [segments])
 (^{:tag void} addCollisionTriangles [triangles])
 (^{:tag void} addHandles [handles material])
 (^{:tag void} addHandles [handles material billboard])
 (^{:tag void} addHandles [handles material billboard secondary])
 (^{:tag void} addLines [lines material])
 (^{:tag void} addLines [lines material billboard])
 (^{:tag void} addLines [lines material billboard modulate])
 (^{:tag void} addMesh [mesh])
 (^{:tag void} addMesh [mesh billboard])
 (^{:tag void} addMesh [mesh billboard skeleton])
 (^{:tag void} addMesh [mesh billboard skeleton material])
 (^{:tag void} addUnscaledBillboard [material])
 (^{:tag void} addUnscaledBillboard [material default_scale])
 (^{:tag void} addUnscaledBillboard [material default_scale modulate])
 (^{:tag void} clear [])
 (^{:tag void} commitHandle [index restore cancel])
 (^{:tag String} getHandleName [index])
 (^{:tag godotclj.bindings.godot.Variant} getHandleValue [index])
 (^{:tag godotclj.api.gdscript.IGodotEditorSpatialGizmoPlugin}
  getPlugin
  [])
 (^{:tag godotclj.api.gdscript.IGodotSpatial} getSpatialNode [])
 (^{:tag boolean} isHandleHighlighted [index])
 (^{:tag void} redraw [])
 (^{:tag void} setHandle [index camera point])
 (^{:tag void} setHidden [hidden])
 (^{:tag void} setSpatialNode [node]))
(definterface
 MGodotMultiMeshInstance
 (^{:tag godotclj.api.gdscript.IGodotMultiMesh} getMultimesh [])
 (^{:tag void} setMultimesh [multimesh]))
(definterface MGodotAudioEffectInstance)
(definterface
 MGodotAudioEffectSpectrumAnalyzerInstance
 (^{:tag godotclj.bindings.godot.Vector2}
  getMagnitudeForFrequencyRange
  [from_hz to_hz])
 (^{:tag godotclj.bindings.godot.Vector2}
  getMagnitudeForFrequencyRange
  [from_hz to_hz mode]))
(definterface
 MGodotGradientTexture
 (^{:tag godotclj.api.gdscript.IGodotGradient} getGradient [])
 (^{:tag void} setGradient [gradient])
 (^{:tag void} setWidth [width]))
(definterface
 MGodotVisualScriptInputAction
 (^{:tag int} getActionMode [])
 (^{:tag String} getActionName [])
 (^{:tag void} setActionMode [mode])
 (^{:tag void} setActionName [name]))
(definterface
 MGodotReferenceRect
 (^{:tag godotclj.bindings.godot.Color} getBorderColor [])
 (^{:tag float} getBorderWidth [])
 (^{:tag boolean} getEditorOnly [])
 (^{:tag void} setBorderColor [color])
 (^{:tag void} setBorderWidth [width])
 (^{:tag void} setEditorOnly [enabled]))
(definterface
 MGodotEditorSceneImporter
 (^{:tag godotclj.api.gdscript.IGodotAnimation}
  importAnimationFromOtherImporter
  [path flags bake_fps])
 (^{:tag godotclj.api.gdscript.IGodotNode}
  importSceneFromOtherImporter
  [path flags bake_fps]))
(definterface MGodotEditorSceneImporterFBX)
(definterface
 MGodotCollisionShape
 (^{:tag godotclj.api.gdscript.IGodotShape} getShape [])
 (^{:tag boolean} isDisabled [])
 (^{:tag void} makeConvexFromBrothers [])
 (^{:tag void} resourceChanged [resource])
 (^{:tag void} setDisabled [enable])
 (^{:tag void} setShape [shape]))
(definterface
 MGodotCollisionShape2D
 (^{:tag float} getOneWayCollisionMargin [])
 (^{:tag godotclj.api.gdscript.IGodotShape2D} getShape [])
 (^{:tag boolean} isDisabled [])
 (^{:tag boolean} isOneWayCollisionEnabled [])
 (^{:tag void} setDisabled [disabled])
 (^{:tag void} setOneWayCollision [enabled])
 (^{:tag void} setOneWayCollisionMargin [margin])
 (^{:tag void} setShape [shape]))
(definterface
 MGodotCSGSphere
 (^{:tag godotclj.api.gdscript.IGodotMaterial} getMaterial [])
 (^{:tag int} getRadialSegments [])
 (^{:tag float} getRadius [])
 (^{:tag int} getRings [])
 (^{:tag boolean} getSmoothFaces [])
 (^{:tag void} setMaterial [material])
 (^{:tag void} setRadialSegments [radial_segments])
 (^{:tag void} setRadius [radius])
 (^{:tag void} setRings [rings])
 (^{:tag void} setSmoothFaces [smooth_faces]))
(definterface
 MGodotWorld2D
 (^{:tag godotclj.bindings.godot.RID} getCanvas [])
 (^{:tag godotclj.api.gdscript.IGodotPhysics2DDirectSpaceState}
  getDirectSpaceState
  [])
 (^{:tag godotclj.bindings.godot.RID} getSpace []))
(definterface
 MGodotSpatialVelocityTracker
 (^{:tag godotclj.bindings.godot.Vector3} getTrackedLinearVelocity [])
 (^{:tag boolean} isTrackingPhysicsStep [])
 (^{:tag void} reset [position])
 (^{:tag void} setTrackPhysicsStep [enable])
 (^{:tag void} updatePosition [position]))
(definterface MGodotAudioEffectHighPassFilter)
(definterface MGodotVisualScriptCustomNode)
(definterface
 MGodotWebRTCDataChannel
 (^{:tag void} close [])
 (^{:tag int} getId [])
 (^{:tag String} getLabel [])
 (^{:tag int} getMaxPacketLifeTime [])
 (^{:tag int} getMaxRetransmits [])
 (^{:tag String} getProtocol [])
 (^{:tag int} getReadyState [])
 (^{:tag int} getWriteMode [])
 (^{:tag boolean} isNegotiated [])
 (^{:tag boolean} isOrdered [])
 (^{:tag int} poll [])
 (^{:tag void} setWriteMode [write_mode])
 (^{:tag boolean} wasStringPacket []))
(definterface MGodotWebRTCDataChannelGDNative)
(definterface
 MGodotInputEventAction
 (^{:tag String} getAction [])
 (^{:tag float} getStrength [])
 (^{:tag void} setAction [action])
 (^{:tag void} setPressed [pressed])
 (^{:tag void} setStrength [strength]))
(definterface
 MGodotAudioStreamPlayer3D
 (^{:tag int} getAreaMask [])
 (^{:tag float} getAttenuationFilterCutoffHz [])
 (^{:tag float} getAttenuationFilterDb [])
 (^{:tag int} getAttenuationModel [])
 (^{:tag String} getBus [])
 (^{:tag int} getDopplerTracking [])
 (^{:tag float} getEmissionAngle [])
 (^{:tag float} getEmissionAngleFilterAttenuationDb [])
 (^{:tag float} getMaxDb [])
 (^{:tag float} getMaxDistance [])
 (^{:tag int} getOutOfRangeMode [])
 (^{:tag float} getPitchScale [])
 (^{:tag float} getPlaybackPosition [])
 (^{:tag godotclj.api.gdscript.IGodotAudioStream} getStream [])
 (^{:tag boolean} getStreamPaused [])
 (^{:tag godotclj.api.gdscript.IGodotAudioStreamPlayback}
  getStreamPlayback
  [])
 (^{:tag float} getUnitDb [])
 (^{:tag float} getUnitSize [])
 (^{:tag boolean} isAutoplayEnabled [])
 (^{:tag boolean} isEmissionAngleEnabled [])
 (^{:tag boolean} isPlaying [])
 (^{:tag void} play [])
 (^{:tag void} play [from_position])
 (^{:tag void} seek [to_position])
 (^{:tag void} setAreaMask [mask])
 (^{:tag void} setAttenuationFilterCutoffHz [degrees])
 (^{:tag void} setAttenuationFilterDb [db])
 (^{:tag void} setAttenuationModel [model])
 (^{:tag void} setAutoplay [enable])
 (^{:tag void} setBus [bus])
 (^{:tag void} setDopplerTracking [mode])
 (^{:tag void} setEmissionAngle [degrees])
 (^{:tag void} setEmissionAngleEnabled [enabled])
 (^{:tag void} setEmissionAngleFilterAttenuationDb [db])
 (^{:tag void} setMaxDb [max_db])
 (^{:tag void} setMaxDistance [metres])
 (^{:tag void} setOutOfRangeMode [mode])
 (^{:tag void} setPitchScale [pitch_scale])
 (^{:tag void} setStream [stream])
 (^{:tag void} setStreamPaused [pause])
 (^{:tag void} setUnitDb [unit_db])
 (^{:tag void} setUnitSize [unit_size])
 (^{:tag void} stop []))
(definterface
 MGodotVisualScriptSequence
 (^{:tag int} getSteps [])
 (^{:tag void} setSteps [steps]))
(definterface
 MGodotMultiMesh
 (^{:tag godotclj.bindings.godot.AABB} getAabb [])
 (^{:tag int} getColorFormat [])
 (^{:tag int} getCustomDataFormat [])
 (^{:tag godotclj.bindings.godot.Color} getInstanceColor [instance])
 (^{:tag int} getInstanceCount [])
 (^{:tag godotclj.bindings.godot.Color}
  getInstanceCustomData
  [instance])
 (^{:tag godotclj.bindings.godot.Transform}
  getInstanceTransform
  [instance])
 (^{:tag godotclj.bindings.godot.Transform2D}
  getInstanceTransform2d
  [instance])
 (^{:tag godotclj.api.gdscript.IGodotMesh} getMesh [])
 (^{:tag int} getTransformFormat [])
 (^{:tag int} getVisibleInstanceCount [])
 (^{:tag void} setAsBulkArray [array])
 (^{:tag void} setColorFormat [format])
 (^{:tag void} setCustomDataFormat [format])
 (^{:tag void} setInstanceColor [instance color])
 (^{:tag void} setInstanceCount [count])
 (^{:tag void} setInstanceCustomData [instance custom_data])
 (^{:tag void} setInstanceTransform [instance transform])
 (^{:tag void} setInstanceTransform2d [instance transform])
 (^{:tag void} setMesh [mesh])
 (^{:tag void} setTransformFormat [format])
 (^{:tag void} setVisibleInstanceCount [count]))
(definterface
 MGodotTCP_Server
 (^{:tag boolean} isConnectionAvailable [])
 (^{:tag boolean} isListening [])
 (^{:tag int} listen [port])
 (^{:tag int} listen [port bind_address])
 (^{:tag void} stop [])
 (^{:tag godotclj.api.gdscript.IGodotStreamPeerTCP} takeConnection []))
(definterface
 MGodotGDNativeLibrary
 (^{:tag godotclj.api.gdscript.IGodotConfigFile} getConfigFile [])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  getCurrentDependencies
  [])
 (^{:tag String} getCurrentLibraryPath [])
 (^{:tag String} getSymbolPrefix [])
 (^{:tag boolean} isReloadable [])
 (^{:tag boolean} isSingleton [])
 (^{:tag void} setConfigFile [config_file])
 (^{:tag void} setLoadOnce [load_once])
 (^{:tag void} setReloadable [reloadable])
 (^{:tag void} setSingleton [singleton])
 (^{:tag void} setSymbolPrefix [symbol_prefix])
 (^{:tag boolean} shouldLoadOnce []))
(definterface
 MGodotNavigationMesh
 (^{:tag void} addPolygon [polygon])
 (^{:tag void} clearPolygons [])
 (^{:tag void} createFromMesh [mesh])
 (^{:tag float} getAgentHeight [])
 (^{:tag float} getAgentMaxClimb [])
 (^{:tag float} getAgentMaxSlope [])
 (^{:tag float} getAgentRadius [])
 (^{:tag float} getCellHeight [])
 (^{:tag float} getCellSize [])
 (^{:tag int} getCollisionMask [])
 (^{:tag boolean} getCollisionMaskBit [bit])
 (^{:tag float} getDetailSampleDistance [])
 (^{:tag float} getDetailSampleMaxError [])
 (^{:tag float} getEdgeMaxError [])
 (^{:tag float} getEdgeMaxLength [])
 (^{:tag boolean} getFilterLedgeSpans [])
 (^{:tag boolean} getFilterLowHangingObstacles [])
 (^{:tag boolean} getFilterWalkableLowHeightSpans [])
 (^{:tag int} getParsedGeometryType [])
 (^{:tag godotclj.bindings.godot.PoolIntArray} getPolygon [idx])
 (^{:tag int} getPolygonCount [])
 (^{:tag float} getRegionMergeSize [])
 (^{:tag float} getRegionMinSize [])
 (^{:tag int} getSamplePartitionType [])
 (^{:tag int} getSourceGeometryMode [])
 (^{:tag String} getSourceGroupName [])
 (^{:tag godotclj.bindings.godot.PoolVector3Array} getVertices [])
 (^{:tag float} getVertsPerPoly [])
 (^{:tag void} setAgentHeight [agent_height])
 (^{:tag void} setAgentMaxClimb [agent_max_climb])
 (^{:tag void} setAgentMaxSlope [agent_max_slope])
 (^{:tag void} setAgentRadius [agent_radius])
 (^{:tag void} setCellHeight [cell_height])
 (^{:tag void} setCellSize [cell_size])
 (^{:tag void} setCollisionMask [mask])
 (^{:tag void} setCollisionMaskBit [bit value])
 (^{:tag void} setDetailSampleDistance [detail_sample_dist])
 (^{:tag void} setDetailSampleMaxError [detail_sample_max_error])
 (^{:tag void} setEdgeMaxError [edge_max_error])
 (^{:tag void} setEdgeMaxLength [edge_max_length])
 (^{:tag void} setFilterLedgeSpans [filter_ledge_spans])
 (^{:tag void}
  setFilterLowHangingObstacles
  [filter_low_hanging_obstacles])
 (^{:tag void}
  setFilterWalkableLowHeightSpans
  [filter_walkable_low_height_spans])
 (^{:tag void} setParsedGeometryType [geometry_type])
 (^{:tag void} setRegionMergeSize [region_merge_size])
 (^{:tag void} setRegionMinSize [region_min_size])
 (^{:tag void} setSamplePartitionType [sample_partition_type])
 (^{:tag void} setSourceGeometryMode [mask])
 (^{:tag void} setSourceGroupName [mask])
 (^{:tag void} setVertices [vertices])
 (^{:tag void} setVertsPerPoly [verts_per_poly]))
(definterface
 MGodotAudioEffectReverb
 (^{:tag float} getDamping [])
 (^{:tag float} getDry [])
 (^{:tag float} getHpf [])
 (^{:tag float} getPredelayFeedback [])
 (^{:tag float} getPredelayMsec [])
 (^{:tag float} getRoomSize [])
 (^{:tag float} getSpread [])
 (^{:tag float} getWet [])
 (^{:tag void} setDamping [amount])
 (^{:tag void} setDry [amount])
 (^{:tag void} setHpf [amount])
 (^{:tag void} setPredelayFeedback [feedback])
 (^{:tag void} setPredelayMsec [msec])
 (^{:tag void} setRoomSize [size])
 (^{:tag void} setSpread [amount])
 (^{:tag void} setWet [amount]))
(definterface
 MGodotCSGTorus
 (^{:tag float} getInnerRadius [])
 (^{:tag godotclj.api.gdscript.IGodotMaterial} getMaterial [])
 (^{:tag float} getOuterRadius [])
 (^{:tag int} getRingSides [])
 (^{:tag int} getSides [])
 (^{:tag boolean} getSmoothFaces [])
 (^{:tag void} setInnerRadius [radius])
 (^{:tag void} setMaterial [material])
 (^{:tag void} setOuterRadius [radius])
 (^{:tag void} setRingSides [sides])
 (^{:tag void} setSides [sides])
 (^{:tag void} setSmoothFaces [smooth_faces]))
(definterface
 MGodotNinePatchRect
 (^{:tag int} getHAxisStretchMode [])
 (^{:tag int} getPatchMargin [margin])
 (^{:tag godotclj.bindings.godot.IndexedRect2} getRegionRect [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getTexture [])
 (^{:tag int} getVAxisStretchMode [])
 (^{:tag boolean} isDrawCenterEnabled [])
 (^{:tag void} setDrawCenter [draw_center])
 (^{:tag void} setHAxisStretchMode [mode])
 (^{:tag void} setPatchMargin [margin value])
 (^{:tag void} setRegionRect [rect])
 (^{:tag void} setTexture [texture])
 (^{:tag void} setVAxisStretchMode [mode]))
(definterface MGodotJNISingleton)
(definterface
 MGodotCSGPolygon
 (^{:tag float} getDepth [])
 (^{:tag godotclj.api.gdscript.IGodotMaterial} getMaterial [])
 (^{:tag int} getMode [])
 (^{:tag float} getPathInterval [])
 (^{:tag godotclj.bindings.godot.NodePath} getPathNode [])
 (^{:tag int} getPathRotation [])
 (^{:tag godotclj.bindings.godot.IndexedPoolVector2Array}
  getPolygon
  [])
 (^{:tag boolean} getSmoothFaces [])
 (^{:tag float} getSpinDegrees [])
 (^{:tag int} getSpinSides [])
 (^{:tag boolean} isPathContinuousU [])
 (^{:tag boolean} isPathJoined [])
 (^{:tag boolean} isPathLocal [])
 (^{:tag void} setDepth [depth])
 (^{:tag void} setMaterial [material])
 (^{:tag void} setMode [mode])
 (^{:tag void} setPathContinuousU [enable])
 (^{:tag void} setPathInterval [distance])
 (^{:tag void} setPathJoined [enable])
 (^{:tag void} setPathLocal [enable])
 (^{:tag void} setPathNode [path])
 (^{:tag void} setPathRotation [mode])
 (^{:tag void} setPolygon [polygon])
 (^{:tag void} setSmoothFaces [smooth_faces])
 (^{:tag void} setSpinDegrees [degrees])
 (^{:tag void} setSpinSides [spin_sides]))
(definterface
 MGodotVisualScriptLocalVar
 (^{:tag String} getVarName [])
 (^{:tag int} getVarType [])
 (^{:tag void} setVarName [name])
 (^{:tag void} setVarType [type]))
(definterface
 MGodotAStar
 (^{:tag void} addPoint [id position])
 (^{:tag void} addPoint [id position weight_scale])
 (^{:tag boolean} arePointsConnected [id to_id])
 (^{:tag boolean} arePointsConnected [id to_id bidirectional])
 (^{:tag void} clear [])
 (^{:tag void} connectPoints [id to_id])
 (^{:tag void} connectPoints [id to_id bidirectional])
 (^{:tag void} disconnectPoints [id to_id])
 (^{:tag void} disconnectPoints [id to_id bidirectional])
 (^{:tag int} getAvailablePointId [])
 (^{:tag int} getClosestPoint [to_position])
 (^{:tag int} getClosestPoint [to_position include_disabled])
 (^{:tag godotclj.bindings.godot.Vector3}
  getClosestPositionInSegment
  [to_position])
 (^{:tag godotclj.bindings.godot.PoolIntArray}
  getIdPath
  [from_id to_id])
 (^{:tag int} getPointCapacity [])
 (^{:tag godotclj.bindings.godot.PoolIntArray}
  getPointConnections
  [id])
 (^{:tag int} getPointCount [])
 (^{:tag godotclj.bindings.godot.PoolVector3Array}
  getPointPath
  [from_id to_id])
 (^{:tag godotclj.bindings.godot.Vector3} getPointPosition [id])
 (^{:tag float} getPointWeightScale [id])
 (^{:tag godotclj.bindings.godot.IndexedArray} getPoints [])
 (^{:tag boolean} hasPoint [id])
 (^{:tag boolean} isPointDisabled [id])
 (^{:tag void} removePoint [id])
 (^{:tag void} reserveSpace [num_nodes])
 (^{:tag void} setPointDisabled [id])
 (^{:tag void} setPointDisabled [id disabled])
 (^{:tag void} setPointPosition [id position])
 (^{:tag void} setPointWeightScale [id weight_scale]))
(definterface
 MGodotResourceFormatLoader
 (^{:tag void} getDependencies [path add_types])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  getRecognizedExtensions
  [])
 (^{:tag String} getResourceType [path])
 (^{:tag boolean} handlesType [typename])
 (^{:tag godotclj.bindings.godot.Variant} load [path original_path])
 (^{:tag int} renameDependencies [path renames]))
(definterface
 MGodotGDScript
 (^{:tag godotclj.bindings.godot.PoolByteArray} getAsByteCode [])
 (^{:tag godotclj.bindings.godot.Variant} new [])
 (^{:tag godotclj.bindings.godot.Variant} new [v1])
 (^{:tag godotclj.bindings.godot.Variant} new [v1 v2])
 (^{:tag godotclj.bindings.godot.Variant} new [v1 v2 v3])
 (^{:tag godotclj.bindings.godot.Variant} new [v1 v2 v3 v4])
 (^{:tag godotclj.bindings.godot.Variant} new [v1 v2 v3 v4 v5]))
(definterface
 MGodotJavaScript
 (^{:tag godotclj.bindings.godot.Variant} eval [code])
 (^{:tag godotclj.bindings.godot.Variant}
  eval
  [code use_global_execution_context]))
(definterface
 MGodotVideoStreamTheora
 (^{:tag String} getFile [])
 (^{:tag void} setFile [file]))
(definterface
 MGodotMeshDataTool
 (^{:tag void} clear [])
 (^{:tag int} commitToSurface [mesh])
 (^{:tag int} createFromSurface [mesh surface])
 (^{:tag int} getEdgeCount [])
 (^{:tag godotclj.bindings.godot.PoolIntArray} getEdgeFaces [idx])
 (^{:tag godotclj.bindings.godot.Variant} getEdgeMeta [idx])
 (^{:tag int} getEdgeVertex [idx vertex])
 (^{:tag int} getFaceCount [])
 (^{:tag int} getFaceEdge [idx edge])
 (^{:tag godotclj.bindings.godot.Variant} getFaceMeta [idx])
 (^{:tag godotclj.bindings.godot.Vector3} getFaceNormal [idx])
 (^{:tag int} getFaceVertex [idx vertex])
 (^{:tag int} getFormat [])
 (^{:tag godotclj.api.gdscript.IGodotMaterial} getMaterial [])
 (^{:tag godotclj.bindings.godot.Vector3} getVertex [idx])
 (^{:tag godotclj.bindings.godot.PoolIntArray} getVertexBones [idx])
 (^{:tag godotclj.bindings.godot.Color} getVertexColor [idx])
 (^{:tag int} getVertexCount [])
 (^{:tag godotclj.bindings.godot.PoolIntArray} getVertexEdges [idx])
 (^{:tag godotclj.bindings.godot.PoolIntArray} getVertexFaces [idx])
 (^{:tag godotclj.bindings.godot.Variant} getVertexMeta [idx])
 (^{:tag godotclj.bindings.godot.Vector3} getVertexNormal [idx])
 (^{:tag godotclj.bindings.godot.Plane} getVertexTangent [idx])
 (^{:tag godotclj.bindings.godot.Vector2} getVertexUv [idx])
 (^{:tag godotclj.bindings.godot.Vector2} getVertexUv2 [idx])
 (^{:tag godotclj.bindings.godot.PoolRealArray}
  getVertexWeights
  [idx])
 (^{:tag void} setEdgeMeta [idx meta])
 (^{:tag void} setFaceMeta [idx meta])
 (^{:tag void} setMaterial [material])
 (^{:tag void} setVertex [idx vertex])
 (^{:tag void} setVertexBones [idx bones])
 (^{:tag void} setVertexColor [idx color])
 (^{:tag void} setVertexMeta [idx meta])
 (^{:tag void} setVertexNormal [idx normal])
 (^{:tag void} setVertexTangent [idx tangent])
 (^{:tag void} setVertexUv [idx uv])
 (^{:tag void} setVertexUv2 [idx uv2])
 (^{:tag void} setVertexWeights [idx weights]))
(definterface
 MGodotAudioStreamMP3
 (^{:tag godotclj.bindings.godot.PoolByteArray} getData [])
 (^{:tag float} getLoopOffset [])
 (^{:tag boolean} hasLoop [])
 (^{:tag void} setData [data])
 (^{:tag void} setLoop [enable])
 (^{:tag void} setLoopOffset [seconds]))
(definterface
 MGodotCubeMap
 (^{:tag int} getFlags [])
 (^{:tag int} getHeight [])
 (^{:tag float} getLossyStorageQuality [])
 (^{:tag godotclj.api.gdscript.IGodotImage} getSide [side])
 (^{:tag int} getStorage [])
 (^{:tag int} getWidth [])
 (^{:tag void} setFlags [flags])
 (^{:tag void} setLossyStorageQuality [quality])
 (^{:tag void} setSide [side image])
 (^{:tag void} setStorage [mode]))
(definterface
 MGodotTileMap
 (^{:tag void} clear [])
 (^{:tag void} fixInvalidTiles [])
 (^{:tag int} getCell [x y])
 (^{:tag godotclj.bindings.godot.Vector2} getCellAutotileCoord [x y])
 (^{:tag godotclj.bindings.godot.Vector2} getCellSize [])
 (^{:tag int} getCellv [position])
 (^{:tag boolean} getClipUv [])
 (^{:tag float} getCollisionBounce [])
 (^{:tag float} getCollisionFriction [])
 (^{:tag int} getCollisionLayer [])
 (^{:tag boolean} getCollisionLayerBit [bit])
 (^{:tag int} getCollisionMask [])
 (^{:tag boolean} getCollisionMaskBit [bit])
 (^{:tag boolean} getCollisionUseKinematic [])
 (^{:tag boolean} getCollisionUseParent [])
 (^{:tag godotclj.bindings.godot.Transform2D} getCustomTransform [])
 (^{:tag int} getHalfOffset [])
 (^{:tag int} getMode [])
 (^{:tag int} getOccluderLightMask [])
 (^{:tag int} getQuadrantSize [])
 (^{:tag int} getTileOrigin [])
 (^{:tag godotclj.api.gdscript.IGodotTileSet} getTileset [])
 (^{:tag godotclj.bindings.godot.IndexedArray} getUsedCells [])
 (^{:tag godotclj.bindings.godot.IndexedArray} getUsedCellsById [id])
 (^{:tag godotclj.bindings.godot.IndexedRect2} getUsedRect [])
 (^{:tag boolean} isCellTransposed [x y])
 (^{:tag boolean} isCellXFlipped [x y])
 (^{:tag boolean} isCellYFlipped [x y])
 (^{:tag boolean} isCenteredTexturesEnabled [])
 (^{:tag boolean} isCompatibilityModeEnabled [])
 (^{:tag boolean} isShowCollisionEnabled [])
 (^{:tag boolean} isYSortModeEnabled [])
 (^{:tag godotclj.bindings.godot.Vector2} mapToWorld [map_position])
 (^{:tag godotclj.bindings.godot.Vector2}
  mapToWorld
  [map_position ignore_half_ofs])
 (^{:tag void} setCell [x y tile])
 (^{:tag void} setCell [x y tile flip_x])
 (^{:tag void} setCell [x y tile flip_x flip_y])
 (^{:tag void} setCell [x y tile flip_x flip_y transpose])
 (^{:tag void}
  setCell
  [x y tile flip_x flip_y transpose autotile_coord])
 (^{:tag void} setCellSize [size])
 (^{:tag void} setCellv [position tile])
 (^{:tag void} setCellv [position tile flip_x])
 (^{:tag void} setCellv [position tile flip_x flip_y])
 (^{:tag void} setCellv [position tile flip_x flip_y transpose])
 (^{:tag void} setCenteredTextures [enable])
 (^{:tag void} setClipUv [enable])
 (^{:tag void} setCollisionBounce [value])
 (^{:tag void} setCollisionFriction [value])
 (^{:tag void} setCollisionLayer [layer])
 (^{:tag void} setCollisionLayerBit [bit value])
 (^{:tag void} setCollisionMask [mask])
 (^{:tag void} setCollisionMaskBit [bit value])
 (^{:tag void} setCollisionUseKinematic [use_kinematic])
 (^{:tag void} setCollisionUseParent [use_parent])
 (^{:tag void} setCompatibilityMode [enable])
 (^{:tag void} setCustomTransform [custom_transform])
 (^{:tag void} setHalfOffset [half_offset])
 (^{:tag void} setMode [mode])
 (^{:tag void} setOccluderLightMask [mask])
 (^{:tag void} setQuadrantSize [size])
 (^{:tag void} setShowCollision [enable])
 (^{:tag void} setTileOrigin [origin])
 (^{:tag void} setTileset [tileset])
 (^{:tag void} setYSortMode [enable])
 (^{:tag void} updateBitmaskArea [position])
 (^{:tag void} updateBitmaskRegion [])
 (^{:tag void} updateBitmaskRegion [start])
 (^{:tag void} updateBitmaskRegion [start end])
 (^{:tag void} updateDirtyQuadrants [])
 (^{:tag godotclj.bindings.godot.Vector2} worldToMap [world_position]))
(definterface
 MGodotInputEventScreenTouch
 (^{:tag int} getIndex [])
 (^{:tag godotclj.bindings.godot.Vector2} getPosition [])
 (^{:tag void} setIndex [index])
 (^{:tag void} setPosition [position])
 (^{:tag void} setPressed [pressed]))
(definterface MGodotTextureArray)
(definterface
 MGodotVisualScriptPropertySet
 (^{:tag int} getAssignOp [])
 (^{:tag godotclj.bindings.godot.NodePath} getBasePath [])
 (^{:tag String} getBaseScript [])
 (^{:tag String} getBaseType [])
 (^{:tag int} getBasicType [])
 (^{:tag int} getCallMode [])
 (^{:tag String} getIndex [])
 (^{:tag String} getProperty [])
 (^{:tag void} setAssignOp [assign_op])
 (^{:tag void} setBasePath [base_path])
 (^{:tag void} setBaseScript [base_script])
 (^{:tag void} setBaseType [base_type])
 (^{:tag void} setBasicType [basic_type])
 (^{:tag void} setCallMode [mode])
 (^{:tag void} setIndex [index])
 (^{:tag void} setProperty [property]))
(definterface
 MGodotBakedLightmapData
 (^{:tag void}
  addUser
  [path lightmap lightmap_slice lightmap_uv_rect instance])
 (^{:tag void} clearData [])
 (^{:tag void} clearUsers [])
 (^{:tag godotclj.bindings.godot.AABB} getBounds [])
 (^{:tag godotclj.bindings.godot.Transform} getCellSpaceTransform [])
 (^{:tag int} getCellSubdiv [])
 (^{:tag float} getEnergy [])
 (^{:tag godotclj.bindings.godot.PoolByteArray} getOctree [])
 (^{:tag int} getUserCount [])
 (^{:tag godotclj.api.gdscript.IGodotResource}
  getUserLightmap
  [user_idx])
 (^{:tag godotclj.bindings.godot.NodePath} getUserPath [user_idx])
 (^{:tag boolean} isInterior [])
 (^{:tag void} setBounds [bounds])
 (^{:tag void} setCellSpaceTransform [xform])
 (^{:tag void} setCellSubdiv [cell_subdiv])
 (^{:tag void} setEnergy [energy])
 (^{:tag void} setInterior [interior])
 (^{:tag void} setOctree [octree]))
(definterface MGodotEditorInspector (^{:tag void} refresh []))
(definterface MGodotVisualShaderNodeTransformUniform)
(definterface
 MGodotRectangleShape2D
 (^{:tag godotclj.bindings.godot.Vector2} getExtents [])
 (^{:tag void} setExtents [extents]))
(definterface
 MGodotInputEventMagnifyGesture
 (^{:tag float} getFactor [])
 (^{:tag void} setFactor [factor]))
(definterface
 MGodotShader
 (^{:tag String} getCode [])
 (^{:tag String} getCustomDefines [])
 (^{:tag godotclj.api.gdscript.IGodotTexture}
  getDefaultTextureParam
  [param])
 (^{:tag int} getMode [])
 (^{:tag boolean} hasParam [name])
 (^{:tag void} setCode [code])
 (^{:tag void} setCustomDefines [custom_defines])
 (^{:tag void} setDefaultTextureParam [param texture]))
(definterface
 MGodotVisualShader
 (^{:tag void} addNode [type node position id])
 (^{:tag boolean}
  canConnectNodes
  [type from_node from_port to_node to_port])
 (^{:tag int} connectNodes [type from_node from_port to_node to_port])
 (^{:tag void}
  connectNodesForced
  [type from_node from_port to_node to_port])
 (^{:tag void}
  disconnectNodes
  [type from_node from_port to_node to_port])
 (^{:tag godotclj.bindings.godot.Vector2} getGraphOffset [])
 (^{:tag godotclj.api.gdscript.IGodotVisualShaderNode}
  getNode
  [type id])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  getNodeConnections
  [type])
 (^{:tag godotclj.bindings.godot.PoolIntArray} getNodeList [type])
 (^{:tag godotclj.bindings.godot.Vector2} getNodePosition [type id])
 (^{:tag int} getValidNodeId [type])
 (^{:tag boolean}
  isNodeConnection
  [type from_node from_port to_node to_port])
 (^{:tag void} removeNode [type id])
 (^{:tag void} setGraphOffset [offset])
 (^{:tag void} setMode [mode])
 (^{:tag void} setNodePosition [type id position]))
(definterface
 MGodotColorRect
 (^{:tag godotclj.bindings.godot.Color} getFrameColor [])
 (^{:tag void} setFrameColor [color]))
(definterface MGodotBulletPhysicsDirectBodyState)
(definterface MGodotAudioStreamMicrophone)
(definterface MGodotResourceImporter)
(definterface
 MGodotTextureRect
 (^{:tag int} getStretchMode [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getTexture [])
 (^{:tag boolean} hasExpand [])
 (^{:tag boolean} isFlippedH [])
 (^{:tag boolean} isFlippedV [])
 (^{:tag void} setExpand [enable])
 (^{:tag void} setFlipH [enable])
 (^{:tag void} setFlipV [enable])
 (^{:tag void} setStretchMode [stretch_mode])
 (^{:tag void} setTexture [texture]))
(definterface
 MGodotMultiplayerAPI
 (^{:tag void} clear [])
 (^{:tag godotclj.bindings.godot.PoolIntArray}
  getNetworkConnectedPeers
  [])
 (^{:tag godotclj.api.gdscript.IGodotNetworkedMultiplayerPeer}
  getNetworkPeer
  [])
 (^{:tag int} getNetworkUniqueId [])
 (^{:tag godotclj.api.gdscript.IGodotNode} getRootNode [])
 (^{:tag int} getRpcSenderId [])
 (^{:tag boolean} hasNetworkPeer [])
 (^{:tag boolean} isNetworkServer [])
 (^{:tag boolean} isObjectDecodingAllowed [])
 (^{:tag boolean} isRefusingNewNetworkConnections [])
 (^{:tag void} poll [])
 (^{:tag int} sendBytes [bytes])
 (^{:tag int} sendBytes [bytes id])
 (^{:tag int} sendBytes [bytes id mode])
 (^{:tag void} setAllowObjectDecoding [enable])
 (^{:tag void} setNetworkPeer [peer])
 (^{:tag void} setRefuseNewNetworkConnections [refuse])
 (^{:tag void} setRootNode [node]))
(definterface
 MGodotEditorExportPlugin
 (^{:tag void} addFile [path file remap])
 (^{:tag void} addIosBundleFile [path])
 (^{:tag void} addIosCppCode [code])
 (^{:tag void} addIosEmbeddedFramework [path])
 (^{:tag void} addIosFramework [path])
 (^{:tag void} addIosLinkerFlags [flags])
 (^{:tag void} addIosPlistContent [plist_content])
 (^{:tag void} addIosProjectStaticLib [path])
 (^{:tag void} addSharedObject [path tags])
 (^{:tag void} skip []))
(definterface
 MGodotPhysicsShapeQueryResult
 (^{:tag int} getResultCount [])
 (^{:tag godotclj.api.gdscript.IGodotObject} getResultObject [idx])
 (^{:tag int} getResultObjectId [idx])
 (^{:tag int} getResultObjectShape [idx])
 (^{:tag godotclj.bindings.godot.RID} getResultRid [idx]))
(definterface MGodotWebRTCPeerConnectionGDNative)
(definterface
 MGodotKinematicCollision2D
 (^{:tag godotclj.api.gdscript.IGodotObject} getCollider [])
 (^{:tag int} getColliderId [])
 (^{:tag godotclj.bindings.godot.Variant} getColliderMetadata [])
 (^{:tag godotclj.bindings.godot.RID} getColliderRid [])
 (^{:tag godotclj.api.gdscript.IGodotObject} getColliderShape [])
 (^{:tag int} getColliderShapeIndex [])
 (^{:tag godotclj.bindings.godot.Vector2} getColliderVelocity [])
 (^{:tag godotclj.api.gdscript.IGodotObject} getLocalShape [])
 (^{:tag godotclj.bindings.godot.Vector2} getNormal [])
 (^{:tag godotclj.bindings.godot.Vector2} getPosition [])
 (^{:tag godotclj.bindings.godot.Vector2} getRemainder [])
 (^{:tag godotclj.bindings.godot.Vector2} getTravel []))
(definterface
 MGodotStreamPeerSSL
 (^{:tag int} acceptStream [stream private_key certificate])
 (^{:tag int} acceptStream [stream private_key certificate chain])
 (^{:tag int} connectToStream [stream])
 (^{:tag int} connectToStream [stream validate_certs])
 (^{:tag int} connectToStream [stream validate_certs for_hostname])
 (^{:tag int}
  connectToStream
  [stream validate_certs for_hostname valid_certificate])
 (^{:tag void} disconnectFromStream [])
 (^{:tag int} getStatus [])
 (^{:tag boolean} isBlockingHandshakeEnabled [])
 (^{:tag void} poll [])
 (^{:tag void} setBlockingHandshakeEnabled [enabled]))
(definterface
 MGodotSpriteBase3D
 (^{:tag godotclj.api.gdscript.IGodotTriangleMesh}
  generateTriangleMesh
  [])
 (^{:tag int} getAlphaCutMode [])
 (^{:tag int} getAxis [])
 (^{:tag int} getBillboardMode [])
 (^{:tag boolean} getDrawFlag [flag])
 (^{:tag godotclj.bindings.godot.IndexedRect2} getItemRect [])
 (^{:tag godotclj.bindings.godot.Color} getModulate [])
 (^{:tag godotclj.bindings.godot.Vector2} getOffset [])
 (^{:tag float} getOpacity [])
 (^{:tag float} getPixelSize [])
 (^{:tag boolean} isCentered [])
 (^{:tag boolean} isFlippedH [])
 (^{:tag boolean} isFlippedV [])
 (^{:tag void} setAlphaCutMode [mode])
 (^{:tag void} setAxis [axis])
 (^{:tag void} setBillboardMode [mode])
 (^{:tag void} setCentered [centered])
 (^{:tag void} setDrawFlag [flag enabled])
 (^{:tag void} setFlipH [flip_h])
 (^{:tag void} setFlipV [flip_v])
 (^{:tag void} setModulate [modulate])
 (^{:tag void} setOffset [offset])
 (^{:tag void} setOpacity [opacity])
 (^{:tag void} setPixelSize [pixel_size]))
(definterface
 MGodotAnimatedSprite3D
 (^{:tag String} getAnimation [])
 (^{:tag int} getFrame [])
 (^{:tag godotclj.api.gdscript.IGodotSpriteFrames} getSpriteFrames [])
 (^{:tag boolean} isPlaying [])
 (^{:tag void} play [])
 (^{:tag void} play [anim])
 (^{:tag void} setAnimation [animation])
 (^{:tag void} setFrame [frame])
 (^{:tag void} setSpriteFrames [sprite_frames])
 (^{:tag void} stop []))
(definterface
 MGodot_Geometry
 (^{:tag godotclj.bindings.godot.IndexedArray}
  buildBoxPlanes
  [extents])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  buildCapsulePlanes
  [radius height sides lats])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  buildCapsulePlanes
  [radius height sides lats axis])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  buildCylinderPlanes
  [radius height sides])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  buildCylinderPlanes
  [radius height sides axis])
 (^{:tag godotclj.bindings.godot.PoolVector3Array}
  clipPolygon
  [points plane])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  clipPolygons2d
  [polygon_a polygon_b])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  clipPolylineWithPolygon2d
  [polyline polygon])
 (^{:tag godotclj.bindings.godot.IndexedPoolVector2Array}
  convexHull2d
  [points])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  excludePolygons2d
  [polygon_a polygon_b])
 (^{:tag godotclj.bindings.godot.Vector3}
  getClosestPointToSegment
  [point s1 s2])
 (^{:tag godotclj.bindings.godot.Vector2}
  getClosestPointToSegment2d
  [point s1 s2])
 (^{:tag godotclj.bindings.godot.Vector3}
  getClosestPointToSegmentUncapped
  [point s1 s2])
 (^{:tag godotclj.bindings.godot.Vector2}
  getClosestPointToSegmentUncapped2d
  [point s1 s2])
 (^{:tag godotclj.bindings.godot.PoolVector3Array}
  getClosestPointsBetweenSegments
  [p1 p2 q1 q2])
 (^{:tag godotclj.bindings.godot.IndexedPoolVector2Array}
  getClosestPointsBetweenSegments2d
  [p1 q1 p2 q2])
 (^{:tag int} getUv84NormalBit [normal])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  intersectPolygons2d
  [polygon_a polygon_b])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  intersectPolylineWithPolygon2d
  [polyline polygon])
 (^{:tag boolean}
  isPointInCircle
  [point circle_position circle_radius])
 (^{:tag boolean} isPointInPolygon [point polygon])
 (^{:tag boolean} isPolygonClockwise [polygon])
 (^{:tag godotclj.bindings.godot.Variant}
  lineIntersectsLine2d
  [from_a dir_a from_b dir_b])
 (^{:tag godotclj.bindings.godot.Dictionary} makeAtlas [sizes])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  mergePolygons2d
  [polygon_a polygon_b])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  offsetPolygon2d
  [polygon delta])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  offsetPolygon2d
  [polygon delta join_type])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  offsetPolyline2d
  [polyline delta])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  offsetPolyline2d
  [polyline delta join_type])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  offsetPolyline2d
  [polyline delta join_type end_type])
 (^{:tag boolean} pointIsInsideTriangle [point a b c])
 (^{:tag godotclj.bindings.godot.Variant}
  rayIntersectsTriangle
  [from dir a b c])
 (^{:tag float}
  segmentIntersectsCircle
  [segment_from segment_to circle_position circle_radius])
 (^{:tag godotclj.bindings.godot.PoolVector3Array}
  segmentIntersectsConvex
  [from to planes])
 (^{:tag godotclj.bindings.godot.PoolVector3Array}
  segmentIntersectsCylinder
  [from to height radius])
 (^{:tag godotclj.bindings.godot.Variant}
  segmentIntersectsSegment2d
  [from_a to_a from_b to_b])
 (^{:tag godotclj.bindings.godot.PoolVector3Array}
  segmentIntersectsSphere
  [from to sphere_position sphere_radius])
 (^{:tag godotclj.bindings.godot.Variant}
  segmentIntersectsTriangle
  [from to a b c])
 (^{:tag godotclj.bindings.godot.PoolIntArray}
  triangulateDelaunay2d
  [points])
 (^{:tag godotclj.bindings.godot.PoolIntArray}
  triangulatePolygon
  [polygon]))
(definterface
 MGodotVisualShaderNodeVectorOp
 (^{:tag int} getOperator [])
 (^{:tag void} setOperator [op]))
(definterface
 MGodotLinkButton
 (^{:tag String} getText [])
 (^{:tag int} getUnderlineMode [])
 (^{:tag void} setText [text])
 (^{:tag void} setUnderlineMode [underline_mode]))
(definterface
 MGodotSpinBox
 (^{:tag void} apply [])
 (^{:tag int} getAlign [])
 (^{:tag godotclj.api.gdscript.IGodotLineEdit} getLineEdit [])
 (^{:tag String} getPrefix [])
 (^{:tag String} getSuffix [])
 (^{:tag boolean} isEditable [])
 (^{:tag void} setAlign [align])
 (^{:tag void} setEditable [editable])
 (^{:tag void} setPrefix [prefix])
 (^{:tag void} setSuffix [suffix]))
(definterface
 MGodotVisualShaderNodeCubeMap
 (^{:tag godotclj.api.gdscript.IGodotCubeMap} getCubeMap [])
 (^{:tag int} getSource [])
 (^{:tag int} getTextureType [])
 (^{:tag void} setCubeMap [value])
 (^{:tag void} setSource [value])
 (^{:tag void} setTextureType [value]))
(definterface
 MGodotAStar2D
 (^{:tag void} addPoint [id position])
 (^{:tag void} addPoint [id position weight_scale])
 (^{:tag boolean} arePointsConnected [id to_id])
 (^{:tag void} clear [])
 (^{:tag void} connectPoints [id to_id])
 (^{:tag void} connectPoints [id to_id bidirectional])
 (^{:tag void} disconnectPoints [id to_id])
 (^{:tag int} getAvailablePointId [])
 (^{:tag int} getClosestPoint [to_position])
 (^{:tag int} getClosestPoint [to_position include_disabled])
 (^{:tag godotclj.bindings.godot.Vector2}
  getClosestPositionInSegment
  [to_position])
 (^{:tag godotclj.bindings.godot.PoolIntArray}
  getIdPath
  [from_id to_id])
 (^{:tag int} getPointCapacity [])
 (^{:tag godotclj.bindings.godot.PoolIntArray}
  getPointConnections
  [id])
 (^{:tag int} getPointCount [])
 (^{:tag godotclj.bindings.godot.IndexedPoolVector2Array}
  getPointPath
  [from_id to_id])
 (^{:tag godotclj.bindings.godot.Vector2} getPointPosition [id])
 (^{:tag float} getPointWeightScale [id])
 (^{:tag godotclj.bindings.godot.IndexedArray} getPoints [])
 (^{:tag boolean} hasPoint [id])
 (^{:tag boolean} isPointDisabled [id])
 (^{:tag void} removePoint [id])
 (^{:tag void} reserveSpace [num_nodes])
 (^{:tag void} setPointDisabled [id])
 (^{:tag void} setPointDisabled [id disabled])
 (^{:tag void} setPointPosition [id position])
 (^{:tag void} setPointWeightScale [id weight_scale]))
(definterface
 MGodot_Thread
 (^{:tag String} getId [])
 (^{:tag boolean} isActive [])
 (^{:tag int} start [instance method])
 (^{:tag int} start [instance method userdata])
 (^{:tag int} start [instance method userdata priority])
 (^{:tag godotclj.bindings.godot.Variant} waitToFinish []))
(definterface
 MGodotEditorSettings
 (^{:tag void} addPropertyInfo [info])
 (^{:tag void} erase [property])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  getFavorites
  [])
 (^{:tag godotclj.bindings.godot.Variant}
  getProjectMetadata
  [section key])
 (^{:tag godotclj.bindings.godot.Variant}
  getProjectMetadata
  [section key default])
 (^{:tag String} getProjectSettingsDir [])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  getRecentDirs
  [])
 (^{:tag godotclj.bindings.godot.Variant} getSetting [name])
 (^{:tag String} getSettingsDir [])
 (^{:tag boolean} hasSetting [name])
 (^{:tag boolean} propertyCanRevert [name])
 (^{:tag godotclj.bindings.godot.Variant} propertyGetRevert [name])
 (^{:tag void} setFavorites [dirs])
 (^{:tag void} setInitialValue [name value update_current])
 (^{:tag void} setProjectMetadata [section key data])
 (^{:tag void} setRecentDirs [dirs])
 (^{:tag void} setSetting [name value]))
(definterface
 MGodotAudioEffectStereoEnhance
 (^{:tag float} getPanPullout [])
 (^{:tag float} getSurround [])
 (^{:tag float} getTimePullout [])
 (^{:tag void} setPanPullout [amount])
 (^{:tag void} setSurround [amount])
 (^{:tag void} setTimePullout [amount]))
(definterface
 MGodotTimer
 (^{:tag float} getTimeLeft [])
 (^{:tag int} getTimerProcessMode [])
 (^{:tag float} getWaitTime [])
 (^{:tag boolean} hasAutostart [])
 (^{:tag boolean} isOneShot [])
 (^{:tag boolean} isPaused [])
 (^{:tag boolean} isStopped [])
 (^{:tag void} setAutostart [enable])
 (^{:tag void} setOneShot [enable])
 (^{:tag void} setPaused [paused])
 (^{:tag void} setTimerProcessMode [mode])
 (^{:tag void} setWaitTime [time_sec])
 (^{:tag void} start [])
 (^{:tag void} start [time_sec])
 (^{:tag void} stop []))
(definterface MGodotVisualScriptSwitch)
(definterface
 MGodotEditorPlugin
 (^{:tag void} addAutoloadSingleton [name path])
 (^{:tag godotclj.api.gdscript.IGodotToolButton}
  addControlToBottomPanel
  [control title])
 (^{:tag void} addControlToContainer [container control])
 (^{:tag void} addControlToDock [slot control])
 (^{:tag void} addCustomType [type base script icon])
 (^{:tag void} addExportPlugin [plugin])
 (^{:tag void} addImportPlugin [importer])
 (^{:tag void} addInspectorPlugin [plugin])
 (^{:tag void} addSceneImportPlugin [scene_importer])
 (^{:tag void} addSpatialGizmoPlugin [plugin])
 (^{:tag void} addToolMenuItem [name handler callback])
 (^{:tag void} addToolMenuItem [name handler callback ud])
 (^{:tag void} addToolSubmenuItem [name submenu])
 (^{:tag void} applyChanges [])
 (^{:tag boolean} build [])
 (^{:tag void} clear [])
 (^{:tag void} disablePlugin [])
 (^{:tag void} edit [object])
 (^{:tag void} enablePlugin [])
 (^{:tag void} forwardCanvasDrawOverViewport [overlay])
 (^{:tag void} forwardCanvasForceDrawOverViewport [overlay])
 (^{:tag boolean} forwardCanvasGuiInput [event])
 (^{:tag void} forwardSpatialDrawOverViewport [overlay])
 (^{:tag void} forwardSpatialForceDrawOverViewport [overlay])
 (^{:tag boolean} forwardSpatialGuiInput [camera event])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  getBreakpoints
  [])
 (^{:tag godotclj.api.gdscript.IGodotEditorInterface}
  getEditorInterface
  [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getPluginIcon [])
 (^{:tag String} getPluginName [])
 (^{:tag godotclj.api.gdscript.IGodotScriptCreateDialog}
  getScriptCreateDialog
  [])
 (^{:tag godotclj.bindings.godot.Dictionary} getState [])
 (^{:tag godotclj.api.gdscript.IGodotUndoRedo} getUndoRedo [])
 (^{:tag void} getWindowLayout [layout])
 (^{:tag boolean} handles [object])
 (^{:tag boolean} hasMainScreen [])
 (^{:tag void} hideBottomPanel [])
 (^{:tag void} makeBottomPanelItemVisible [item])
 (^{:tag void} makeVisible [visible])
 (^{:tag void} queueSaveLayout [])
 (^{:tag void} removeAutoloadSingleton [name])
 (^{:tag void} removeControlFromBottomPanel [control])
 (^{:tag void} removeControlFromContainer [container control])
 (^{:tag void} removeControlFromDocks [control])
 (^{:tag void} removeCustomType [type])
 (^{:tag void} removeExportPlugin [plugin])
 (^{:tag void} removeImportPlugin [importer])
 (^{:tag void} removeInspectorPlugin [plugin])
 (^{:tag void} removeSceneImportPlugin [scene_importer])
 (^{:tag void} removeSpatialGizmoPlugin [plugin])
 (^{:tag void} removeToolMenuItem [name])
 (^{:tag void} saveExternalData [])
 (^{:tag void} setForceDrawOverForwardingEnabled [])
 (^{:tag void} setInputEventForwardingAlwaysEnabled [])
 (^{:tag void} setState [state])
 (^{:tag void} setWindowLayout [layout])
 (^{:tag int} updateOverlays []))
(definterface
 MGodotInputEventKey
 (^{:tag int} getScancode [])
 (^{:tag int} getScancodeWithModifiers [])
 (^{:tag int} getUnicode [])
 (^{:tag void} setEcho [echo])
 (^{:tag void} setPressed [pressed])
 (^{:tag void} setScancode [scancode])
 (^{:tag void} setUnicode [unicode]))
(definterface
 MGodotStyleBoxFlat
 (^{:tag int} getAaSize [])
 (^{:tag godotclj.bindings.godot.Color} getBgColor [])
 (^{:tag boolean} getBorderBlend [])
 (^{:tag godotclj.bindings.godot.Color} getBorderColor [])
 (^{:tag int} getBorderWidth [margin])
 (^{:tag int} getBorderWidthMin [])
 (^{:tag int} getCornerDetail [])
 (^{:tag int} getCornerRadius [corner])
 (^{:tag float} getExpandMargin [margin])
 (^{:tag godotclj.bindings.godot.Color} getShadowColor [])
 (^{:tag godotclj.bindings.godot.Vector2} getShadowOffset [])
 (^{:tag int} getShadowSize [])
 (^{:tag boolean} isAntiAliased [])
 (^{:tag boolean} isDrawCenterEnabled [])
 (^{:tag void} setAaSize [size])
 (^{:tag void} setAntiAliased [anti_aliased])
 (^{:tag void} setBgColor [color])
 (^{:tag void} setBorderBlend [blend])
 (^{:tag void} setBorderColor [color])
 (^{:tag void} setBorderWidth [margin width])
 (^{:tag void} setBorderWidthAll [width])
 (^{:tag void} setCornerDetail [detail])
 (^{:tag void} setCornerRadius [corner radius])
 (^{:tag void} setCornerRadiusAll [radius])
 (^{:tag void}
  setCornerRadiusIndividual
  [radius_top_left
   radius_top_right
   radius_bottom_right
   radius_bottom_left])
 (^{:tag void} setDrawCenter [draw_center])
 (^{:tag void} setExpandMargin [margin size])
 (^{:tag void} setExpandMarginAll [size])
 (^{:tag void}
  setExpandMarginIndividual
  [size_left size_top size_right size_bottom])
 (^{:tag void} setShadowColor [color])
 (^{:tag void} setShadowOffset [offset])
 (^{:tag void} setShadowSize [size]))
(definterface MGodotAudioEffectLowShelfFilter)
(definterface
 MGodotStaticBody2D
 (^{:tag float} getBounce [])
 (^{:tag float} getConstantAngularVelocity [])
 (^{:tag godotclj.bindings.godot.Vector2}
  getConstantLinearVelocity
  [])
 (^{:tag float} getFriction [])
 (^{:tag godotclj.api.gdscript.IGodotPhysicsMaterial}
  getPhysicsMaterialOverride
  [])
 (^{:tag void} setBounce [bounce])
 (^{:tag void} setConstantAngularVelocity [vel])
 (^{:tag void} setConstantLinearVelocity [vel])
 (^{:tag void} setFriction [friction])
 (^{:tag void} setPhysicsMaterialOverride [physics_material_override]))
(definterface MGodotAudioBusLayout)
(definterface MGodotAudioStreamPlayback)
(definterface MGodotAudioStreamPlaybackResampled)
(definterface
 MGodotItemList
 (^{:tag void} addIconItem [icon])
 (^{:tag void} addIconItem [icon selectable])
 (^{:tag void} addItem [text])
 (^{:tag void} addItem [text icon])
 (^{:tag void} addItem [text icon selectable])
 (^{:tag void} clear [])
 (^{:tag void} ensureCurrentIsVisible [])
 (^{:tag boolean} getAllowReselect [])
 (^{:tag boolean} getAllowRmbSelect [])
 (^{:tag int} getFixedColumnWidth [])
 (^{:tag godotclj.bindings.godot.Vector2} getFixedIconSize [])
 (^{:tag int} getIconMode [])
 (^{:tag float} getIconScale [])
 (^{:tag int} getItemAtPosition [position])
 (^{:tag int} getItemAtPosition [position exact])
 (^{:tag int} getItemCount [])
 (^{:tag godotclj.bindings.godot.Color} getItemCustomBgColor [idx])
 (^{:tag godotclj.bindings.godot.Color} getItemCustomFgColor [idx])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getItemIcon [idx])
 (^{:tag godotclj.bindings.godot.Color} getItemIconModulate [idx])
 (^{:tag godotclj.bindings.godot.IndexedRect2}
  getItemIconRegion
  [idx])
 (^{:tag godotclj.bindings.godot.Variant} getItemMetadata [idx])
 (^{:tag String} getItemText [idx])
 (^{:tag String} getItemTooltip [idx])
 (^{:tag int} getMaxColumns [])
 (^{:tag int} getMaxTextLines [])
 (^{:tag int} getSelectMode [])
 (^{:tag godotclj.bindings.godot.PoolIntArray} getSelectedItems [])
 (^{:tag godotclj.api.gdscript.IGodotVScrollBar} getVScroll [])
 (^{:tag boolean} hasAutoHeight [])
 (^{:tag boolean} isAnythingSelected [])
 (^{:tag boolean} isItemDisabled [idx])
 (^{:tag boolean} isItemIconTransposed [idx])
 (^{:tag boolean} isItemSelectable [idx])
 (^{:tag boolean} isItemTooltipEnabled [idx])
 (^{:tag boolean} isSameColumnWidth [])
 (^{:tag boolean} isSelected [idx])
 (^{:tag void} moveItem [from_idx to_idx])
 (^{:tag void} removeItem [idx])
 (^{:tag void} select [idx])
 (^{:tag void} select [idx single])
 (^{:tag void} setAllowReselect [allow])
 (^{:tag void} setAllowRmbSelect [allow])
 (^{:tag void} setAutoHeight [enable])
 (^{:tag void} setFixedColumnWidth [width])
 (^{:tag void} setFixedIconSize [size])
 (^{:tag void} setIconMode [mode])
 (^{:tag void} setIconScale [scale])
 (^{:tag void} setItemCustomBgColor [idx custom_bg_color])
 (^{:tag void} setItemCustomFgColor [idx custom_fg_color])
 (^{:tag void} setItemDisabled [idx disabled])
 (^{:tag void} setItemIcon [idx icon])
 (^{:tag void} setItemIconModulate [idx modulate])
 (^{:tag void} setItemIconRegion [idx rect])
 (^{:tag void} setItemIconTransposed [idx transposed])
 (^{:tag void} setItemMetadata [idx metadata])
 (^{:tag void} setItemSelectable [idx selectable])
 (^{:tag void} setItemText [idx text])
 (^{:tag void} setItemTooltip [idx tooltip])
 (^{:tag void} setItemTooltipEnabled [idx enable])
 (^{:tag void} setMaxColumns [amount])
 (^{:tag void} setMaxTextLines [lines])
 (^{:tag void} setSameColumnWidth [enable])
 (^{:tag void} setSelectMode [mode])
 (^{:tag void} sortItemsByText [])
 (^{:tag void} unselect [idx])
 (^{:tag void} unselectAll []))
(definterface
 MGodotVisualShaderNodeTexture
 (^{:tag int} getSource [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getTexture [])
 (^{:tag int} getTextureType [])
 (^{:tag void} setSource [value])
 (^{:tag void} setTexture [value])
 (^{:tag void} setTextureType [value]))
(definterface MGodotVisualScriptSubCall)
(definterface MGodotPerformance (^{:tag float} getMonitor [monitor]))
(definterface MGodotVisualScriptExpression)
(definterface
 MGodotTreeItem
 (^{:tag void} addButton [column button])
 (^{:tag void} addButton [column button button_idx])
 (^{:tag void} addButton [column button button_idx disabled])
 (^{:tag void} addButton [column button button_idx disabled tooltip])
 (^{:tag godotclj.bindings.godot.Variant} callRecursive [method])
 (^{:tag godotclj.bindings.godot.Variant} callRecursive [method v1])
 (^{:tag godotclj.bindings.godot.Variant}
  callRecursive
  [method v1 v2])
 (^{:tag godotclj.bindings.godot.Variant}
  callRecursive
  [method v1 v2 v3])
 (^{:tag godotclj.bindings.godot.Variant}
  callRecursive
  [method v1 v2 v3 v4])
 (^{:tag godotclj.bindings.godot.Variant}
  callRecursive
  [method v1 v2 v3 v4 v5])
 (^{:tag void} clearCustomBgColor [column])
 (^{:tag void} clearCustomColor [column])
 (^{:tag void} deselect [column])
 (^{:tag void} eraseButton [column button_idx])
 (^{:tag godotclj.api.gdscript.IGodotTexture}
  getButton
  [column button_idx])
 (^{:tag int} getButtonCount [column])
 (^{:tag String} getButtonTooltip [column button_idx])
 (^{:tag int} getCellMode [column])
 (^{:tag godotclj.api.gdscript.IGodotTreeItem} getChildren [])
 (^{:tag godotclj.bindings.godot.Color} getCustomBgColor [column])
 (^{:tag godotclj.bindings.godot.Color} getCustomColor [column])
 (^{:tag int} getCustomMinimumHeight [])
 (^{:tag boolean} getExpandRight [column])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getIcon [column])
 (^{:tag int} getIconMaxWidth [column])
 (^{:tag godotclj.bindings.godot.Color} getIconModulate [column])
 (^{:tag godotclj.bindings.godot.IndexedRect2} getIconRegion [column])
 (^{:tag godotclj.bindings.godot.Variant} getMetadata [column])
 (^{:tag godotclj.api.gdscript.IGodotTreeItem} getNext [])
 (^{:tag godotclj.api.gdscript.IGodotTreeItem} getNextVisible [])
 (^{:tag godotclj.api.gdscript.IGodotTreeItem} getNextVisible [wrap])
 (^{:tag godotclj.api.gdscript.IGodotTreeItem} getParent [])
 (^{:tag godotclj.api.gdscript.IGodotTreeItem} getPrev [])
 (^{:tag godotclj.api.gdscript.IGodotTreeItem} getPrevVisible [])
 (^{:tag godotclj.api.gdscript.IGodotTreeItem} getPrevVisible [wrap])
 (^{:tag float} getRange [column])
 (^{:tag godotclj.bindings.godot.Dictionary} getRangeConfig [column])
 (^{:tag String} getSuffix [column])
 (^{:tag String} getText [column])
 (^{:tag int} getTextAlign [column])
 (^{:tag String} getTooltip [column])
 (^{:tag boolean} isButtonDisabled [column button_idx])
 (^{:tag boolean} isChecked [column])
 (^{:tag boolean} isCollapsed [])
 (^{:tag boolean} isCustomSetAsButton [column])
 (^{:tag boolean} isEditable [column])
 (^{:tag boolean} isFoldingDisabled [])
 (^{:tag boolean} isSelectable [column])
 (^{:tag boolean} isSelected [column])
 (^{:tag void} moveToBottom [])
 (^{:tag void} moveToTop [])
 (^{:tag void} removeChild [child])
 (^{:tag void} select [column])
 (^{:tag void} setButton [column button_idx button])
 (^{:tag void} setButtonDisabled [column button_idx disabled])
 (^{:tag void} setCellMode [column mode])
 (^{:tag void} setChecked [column checked])
 (^{:tag void} setCollapsed [enable])
 (^{:tag void} setCustomAsButton [column enable])
 (^{:tag void} setCustomBgColor [column color])
 (^{:tag void} setCustomBgColor [column color just_outline])
 (^{:tag void} setCustomColor [column color])
 (^{:tag void} setCustomDraw [column object callback])
 (^{:tag void} setCustomMinimumHeight [height])
 (^{:tag void} setDisableFolding [disable])
 (^{:tag void} setEditable [column enabled])
 (^{:tag void} setExpandRight [column enable])
 (^{:tag void} setIcon [column texture])
 (^{:tag void} setIconMaxWidth [column width])
 (^{:tag void} setIconModulate [column modulate])
 (^{:tag void} setIconRegion [column region])
 (^{:tag void} setMetadata [column meta])
 (^{:tag void} setRange [column value])
 (^{:tag void} setRangeConfig [column min max step])
 (^{:tag void} setRangeConfig [column min max step expr])
 (^{:tag void} setSelectable [column selectable])
 (^{:tag void} setSuffix [column text])
 (^{:tag void} setText [column text])
 (^{:tag void} setTextAlign [column text_align])
 (^{:tag void} setTooltip [column tooltip]))
(definterface MGodotPanelContainer)
(definterface
 MGodotVisualShaderNodeTransformMult
 (^{:tag int} getOperator [])
 (^{:tag void} setOperator [op]))
(definterface
 MGodotTabContainer
 (^{:tag boolean} areTabsVisible [])
 (^{:tag int} getCurrentTab [])
 (^{:tag godotclj.api.gdscript.IGodotControl} getCurrentTabControl [])
 (^{:tag boolean} getDragToRearrangeEnabled [])
 (^{:tag godotclj.api.gdscript.IGodotPopup} getPopup [])
 (^{:tag int} getPreviousTab [])
 (^{:tag int} getTabAlign [])
 (^{:tag godotclj.api.gdscript.IGodotControl} getTabControl [tab_idx])
 (^{:tag int} getTabCount [])
 (^{:tag boolean} getTabDisabled [tab_idx])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getTabIcon [tab_idx])
 (^{:tag String} getTabTitle [tab_idx])
 (^{:tag int} getTabsRearrangeGroup [])
 (^{:tag boolean} getUseHiddenTabsForMinSize [])
 (^{:tag boolean} isAllTabsInFront [])
 (^{:tag void} setAllTabsInFront [is_front])
 (^{:tag void} setCurrentTab [tab_idx])
 (^{:tag void} setDragToRearrangeEnabled [enabled])
 (^{:tag void} setPopup [popup])
 (^{:tag void} setTabAlign [align])
 (^{:tag void} setTabDisabled [tab_idx disabled])
 (^{:tag void} setTabIcon [tab_idx icon])
 (^{:tag void} setTabTitle [tab_idx title])
 (^{:tag void} setTabsRearrangeGroup [group_id])
 (^{:tag void} setTabsVisible [visible])
 (^{:tag void} setUseHiddenTabsForMinSize [enabled]))
(definterface MGodotPosition3D)
(definterface
 MGodotExpression
 (^{:tag godotclj.bindings.godot.Variant} execute [])
 (^{:tag godotclj.bindings.godot.Variant} execute [inputs])
 (^{:tag godotclj.bindings.godot.Variant}
  execute
  [inputs base_instance])
 (^{:tag godotclj.bindings.godot.Variant}
  execute
  [inputs base_instance show_error])
 (^{:tag String} getErrorText [])
 (^{:tag boolean} hasExecuteFailed [])
 (^{:tag int} parse [expression])
 (^{:tag int} parse [expression input_names]))
(definterface MGodotVisualShaderNodeScalarSwitch)
(definterface
 MGodotCylinderMesh
 (^{:tag float} getBottomRadius [])
 (^{:tag float} getHeight [])
 (^{:tag int} getRadialSegments [])
 (^{:tag int} getRings [])
 (^{:tag float} getTopRadius [])
 (^{:tag void} setBottomRadius [radius])
 (^{:tag void} setHeight [height])
 (^{:tag void} setRadialSegments [segments])
 (^{:tag void} setRings [rings])
 (^{:tag void} setTopRadius [radius]))
(definterface
 MGodotAnimatedTexture
 (^{:tag int} getCurrentFrame [])
 (^{:tag float} getFps [])
 (^{:tag float} getFrameDelay [frame])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getFrameTexture [frame])
 (^{:tag int} getFrames [])
 (^{:tag boolean} getOneshot [])
 (^{:tag boolean} getPause [])
 (^{:tag void} setCurrentFrame [frame])
 (^{:tag void} setFps [fps])
 (^{:tag void} setFrameDelay [frame delay])
 (^{:tag void} setFrameTexture [frame texture])
 (^{:tag void} setFrames [frames])
 (^{:tag void} setOneshot [oneshot])
 (^{:tag void} setPause [pause]))
(definterface
 MGodotAudioStreamPlayer
 (^{:tag String} getBus [])
 (^{:tag int} getMixTarget [])
 (^{:tag float} getPitchScale [])
 (^{:tag float} getPlaybackPosition [])
 (^{:tag godotclj.api.gdscript.IGodotAudioStream} getStream [])
 (^{:tag boolean} getStreamPaused [])
 (^{:tag godotclj.api.gdscript.IGodotAudioStreamPlayback}
  getStreamPlayback
  [])
 (^{:tag float} getVolumeDb [])
 (^{:tag boolean} isAutoplayEnabled [])
 (^{:tag boolean} isPlaying [])
 (^{:tag void} play [])
 (^{:tag void} play [from_position])
 (^{:tag void} seek [to_position])
 (^{:tag void} setAutoplay [enable])
 (^{:tag void} setBus [bus])
 (^{:tag void} setMixTarget [mix_target])
 (^{:tag void} setPitchScale [pitch_scale])
 (^{:tag void} setStream [stream])
 (^{:tag void} setStreamPaused [pause])
 (^{:tag void} setVolumeDb [volume_db])
 (^{:tag void} stop []))
(definterface
 MGodotVisualShaderNodeCompare
 (^{:tag int} getComparisonType [])
 (^{:tag int} getCondition [])
 (^{:tag int} getFunction [])
 (^{:tag void} setComparisonType [type])
 (^{:tag void} setCondition [condition])
 (^{:tag void} setFunction [func]))
(definterface MGodotVSplitContainer)
(definterface
 MGodotEditorScenePostImport
 (^{:tag String} getSourceFile [])
 (^{:tag String} getSourceFolder [])
 (^{:tag godotclj.api.gdscript.IGodotObject} postImport [scene]))
(definterface
 MGodotAudioEffectPanner
 (^{:tag float} getPan [])
 (^{:tag void} setPan [cpanume]))
(definterface MGodotCSGCombiner)
(definterface
 MGodotVisualScriptMathConstant
 (^{:tag int} getMathConstant [])
 (^{:tag void} setMathConstant [which]))
(definterface
 MGodotLineShape2D
 (^{:tag float} getD [])
 (^{:tag godotclj.bindings.godot.Vector2} getNormal [])
 (^{:tag void} setD [d])
 (^{:tag void} setNormal [normal]))
(definterface
 MGodotDampedSpringJoint2D
 (^{:tag float} getDamping [])
 (^{:tag float} getLength [])
 (^{:tag float} getRestLength [])
 (^{:tag float} getStiffness [])
 (^{:tag void} setDamping [damping])
 (^{:tag void} setLength [length])
 (^{:tag void} setRestLength [rest_length])
 (^{:tag void} setStiffness [stiffness]))
(definterface
 MGodotTextureButton
 (^{:tag godotclj.api.gdscript.IGodotBitMap} getClickMask [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getDisabledTexture [])
 (^{:tag boolean} getExpand [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getFocusedTexture [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getHoverTexture [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getNormalTexture [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getPressedTexture [])
 (^{:tag int} getStretchMode [])
 (^{:tag void} setClickMask [mask])
 (^{:tag void} setDisabledTexture [texture])
 (^{:tag void} setExpand [p_expand])
 (^{:tag void} setFocusedTexture [texture])
 (^{:tag void} setHoverTexture [texture])
 (^{:tag void} setNormalTexture [texture])
 (^{:tag void} setPressedTexture [texture])
 (^{:tag void} setStretchMode [p_mode]))
(definterface
 MGodotPinJoint
 (^{:tag float} getParam [param])
 (^{:tag void} setParam [param value]))
(definterface
 MGodotVideoPlayer
 (^{:tag int} getAudioTrack [])
 (^{:tag int} getBufferingMsec [])
 (^{:tag String} getBus [])
 (^{:tag godotclj.api.gdscript.IGodotVideoStream} getStream [])
 (^{:tag String} getStreamName [])
 (^{:tag float} getStreamPosition [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getVideoTexture [])
 (^{:tag float} getVolume [])
 (^{:tag float} getVolumeDb [])
 (^{:tag boolean} hasAutoplay [])
 (^{:tag boolean} hasExpand [])
 (^{:tag boolean} isPaused [])
 (^{:tag boolean} isPlaying [])
 (^{:tag void} play [])
 (^{:tag void} setAudioTrack [track])
 (^{:tag void} setAutoplay [enabled])
 (^{:tag void} setBufferingMsec [msec])
 (^{:tag void} setBus [bus])
 (^{:tag void} setExpand [enable])
 (^{:tag void} setPaused [paused])
 (^{:tag void} setStream [stream])
 (^{:tag void} setStreamPosition [position])
 (^{:tag void} setVolume [volume])
 (^{:tag void} setVolumeDb [db])
 (^{:tag void} stop []))
(definterface
 MGodotResourceFormatSaver
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  getRecognizedExtensions
  [resource])
 (^{:tag boolean} recognize [resource])
 (^{:tag int} save [path resource flags]))
(definterface
 MGodotEditorFileSystemDirectory
 (^{:tag int} findDirIndex [name])
 (^{:tag int} findFileIndex [name])
 (^{:tag String} getFile [idx])
 (^{:tag int} getFileCount [])
 (^{:tag boolean} getFileImportIsValid [idx])
 (^{:tag String} getFilePath [idx])
 (^{:tag String} getFileScriptClassExtends [idx])
 (^{:tag String} getFileScriptClassName [idx])
 (^{:tag String} getFileType [idx])
 (^{:tag String} getName [])
 (^{:tag godotclj.api.gdscript.IGodotEditorFileSystemDirectory}
  getParent
  [])
 (^{:tag String} getPath [])
 (^{:tag godotclj.api.gdscript.IGodotEditorFileSystemDirectory}
  getSubdir
  [idx])
 (^{:tag int} getSubdirCount []))
(definterface
 MGodotParallaxLayer
 (^{:tag godotclj.bindings.godot.Vector2} getMirroring [])
 (^{:tag godotclj.bindings.godot.Vector2} getMotionOffset [])
 (^{:tag godotclj.bindings.godot.Vector2} getMotionScale [])
 (^{:tag void} setMirroring [mirror])
 (^{:tag void} setMotionOffset [offset])
 (^{:tag void} setMotionScale [scale]))
(definterface
 MGodotVisualShaderNodeScalarFunc
 (^{:tag int} getFunction [])
 (^{:tag void} setFunction [func]))
(definterface
 MGodotAudioEffectCompressor
 (^{:tag float} getAttackUs [])
 (^{:tag float} getGain [])
 (^{:tag float} getMix [])
 (^{:tag float} getRatio [])
 (^{:tag float} getReleaseMs [])
 (^{:tag String} getSidechain [])
 (^{:tag float} getThreshold [])
 (^{:tag void} setAttackUs [attack_us])
 (^{:tag void} setGain [gain])
 (^{:tag void} setMix [mix])
 (^{:tag void} setRatio [ratio])
 (^{:tag void} setReleaseMs [release_ms])
 (^{:tag void} setSidechain [sidechain])
 (^{:tag void} setThreshold [threshold]))
(definterface
 MGodotARVRController
 (^{:tag int} getControllerId [])
 (^{:tag String} getControllerName [])
 (^{:tag int} getHand [])
 (^{:tag boolean} getIsActive [])
 (^{:tag float} getJoystickAxis [axis])
 (^{:tag int} getJoystickId [])
 (^{:tag godotclj.api.gdscript.IGodotMesh} getMesh [])
 (^{:tag float} getRumble [])
 (^{:tag int} isButtonPressed [button])
 (^{:tag void} setControllerId [controller_id])
 (^{:tag void} setRumble [rumble]))
(definterface
 MGodotMenuButton
 (^{:tag godotclj.api.gdscript.IGodotPopupMenu} getPopup [])
 (^{:tag boolean} isSwitchOnHover [])
 (^{:tag void} setDisableShortcuts [disabled])
 (^{:tag void} setSwitchOnHover [enable]))
(definterface
 MGodotProceduralSky
 (^{:tag godotclj.bindings.godot.Color} getGroundBottomColor [])
 (^{:tag float} getGroundCurve [])
 (^{:tag float} getGroundEnergy [])
 (^{:tag godotclj.bindings.godot.Color} getGroundHorizonColor [])
 (^{:tag float} getSkyCurve [])
 (^{:tag float} getSkyEnergy [])
 (^{:tag godotclj.bindings.godot.Color} getSkyHorizonColor [])
 (^{:tag godotclj.bindings.godot.Color} getSkyTopColor [])
 (^{:tag float} getSunAngleMax [])
 (^{:tag float} getSunAngleMin [])
 (^{:tag godotclj.bindings.godot.Color} getSunColor [])
 (^{:tag float} getSunCurve [])
 (^{:tag float} getSunEnergy [])
 (^{:tag float} getSunLatitude [])
 (^{:tag float} getSunLongitude [])
 (^{:tag int} getTextureSize [])
 (^{:tag void} setGroundBottomColor [color])
 (^{:tag void} setGroundCurve [curve])
 (^{:tag void} setGroundEnergy [energy])
 (^{:tag void} setGroundHorizonColor [color])
 (^{:tag void} setSkyCurve [curve])
 (^{:tag void} setSkyEnergy [energy])
 (^{:tag void} setSkyHorizonColor [color])
 (^{:tag void} setSkyTopColor [color])
 (^{:tag void} setSunAngleMax [degrees])
 (^{:tag void} setSunAngleMin [degrees])
 (^{:tag void} setSunColor [color])
 (^{:tag void} setSunCurve [curve])
 (^{:tag void} setSunEnergy [energy])
 (^{:tag void} setSunLatitude [degrees])
 (^{:tag void} setSunLongitude [degrees])
 (^{:tag void} setTextureSize [size]))
(definterface
 MGodotAudioEffectSpectrumAnalyzer
 (^{:tag float} getBufferLength [])
 (^{:tag int} getFftSize [])
 (^{:tag float} getTapBackPos [])
 (^{:tag void} setBufferLength [seconds])
 (^{:tag void} setFftSize [size])
 (^{:tag void} setTapBackPos [seconds]))
(definterface
 MGodotInterpolatedCamera
 (^{:tag float} getSpeed [])
 (^{:tag godotclj.bindings.godot.NodePath} getTargetPath [])
 (^{:tag boolean} isInterpolationEnabled [])
 (^{:tag void} setInterpolationEnabled [target_path])
 (^{:tag void} setSpeed [speed])
 (^{:tag void} setTarget [target])
 (^{:tag void} setTargetPath [target_path]))
(definterface
 MGodotCameraFeed
 (^{:tag int} getId [])
 (^{:tag String} getName [])
 (^{:tag int} getPosition [])
 (^{:tag godotclj.bindings.godot.Transform2D} getTransform [])
 (^{:tag boolean} isActive [])
 (^{:tag void} setActive [active])
 (^{:tag void} setTransform [transform]))
(definterface
 MGodotParticles2D
 (^{:tag godotclj.bindings.godot.IndexedRect2} captureRect [])
 (^{:tag int} getAmount [])
 (^{:tag int} getDrawOrder [])
 (^{:tag float} getExplosivenessRatio [])
 (^{:tag int} getFixedFps [])
 (^{:tag boolean} getFractionalDelta [])
 (^{:tag float} getLifetime [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getNormalMap [])
 (^{:tag boolean} getOneShot [])
 (^{:tag float} getPreProcessTime [])
 (^{:tag godotclj.api.gdscript.IGodotMaterial} getProcessMaterial [])
 (^{:tag float} getRandomnessRatio [])
 (^{:tag float} getSpeedScale [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getTexture [])
 (^{:tag boolean} getUseLocalCoordinates [])
 (^{:tag godotclj.bindings.godot.IndexedRect2} getVisibilityRect [])
 (^{:tag boolean} isEmitting [])
 (^{:tag void} restart [])
 (^{:tag void} setAmount [amount])
 (^{:tag void} setDrawOrder [order])
 (^{:tag void} setEmitting [emitting])
 (^{:tag void} setExplosivenessRatio [ratio])
 (^{:tag void} setFixedFps [fps])
 (^{:tag void} setFractionalDelta [enable])
 (^{:tag void} setLifetime [secs])
 (^{:tag void} setNormalMap [texture])
 (^{:tag void} setOneShot [secs])
 (^{:tag void} setPreProcessTime [secs])
 (^{:tag void} setProcessMaterial [material])
 (^{:tag void} setRandomnessRatio [ratio])
 (^{:tag void} setSpeedScale [scale])
 (^{:tag void} setTexture [texture])
 (^{:tag void} setUseLocalCoordinates [enable])
 (^{:tag void} setVisibilityRect [visibility_rect]))
(definterface
 MGodotUPNP
 (^{:tag void} addDevice [device])
 (^{:tag int} addPortMapping [port])
 (^{:tag int} addPortMapping [port port_internal])
 (^{:tag int} addPortMapping [port port_internal desc])
 (^{:tag int} addPortMapping [port port_internal desc proto])
 (^{:tag int} addPortMapping [port port_internal desc proto duration])
 (^{:tag void} clearDevices [])
 (^{:tag int} deletePortMapping [port])
 (^{:tag int} deletePortMapping [port proto])
 (^{:tag int} discover [])
 (^{:tag int} discover [timeout])
 (^{:tag int} discover [timeout ttl])
 (^{:tag int} discover [timeout ttl device_filter])
 (^{:tag godotclj.api.gdscript.IGodotUPNPDevice} getDevice [index])
 (^{:tag int} getDeviceCount [])
 (^{:tag int} getDiscoverLocalPort [])
 (^{:tag String} getDiscoverMulticastIf [])
 (^{:tag godotclj.api.gdscript.IGodotUPNPDevice} getGateway [])
 (^{:tag boolean} isDiscoverIpv6 [])
 (^{:tag String} queryExternalAddress [])
 (^{:tag void} removeDevice [index])
 (^{:tag void} setDevice [index device])
 (^{:tag void} setDiscoverIpv6 [ipv6])
 (^{:tag void} setDiscoverLocalPort [port])
 (^{:tag void} setDiscoverMulticastIf [m_if]))
(definterface
 MGodotPhysics2DTestMotionResult
 (^{:tag godotclj.api.gdscript.IGodotObject} getCollider [])
 (^{:tag int} getColliderId [])
 (^{:tag godotclj.bindings.godot.RID} getColliderRid [])
 (^{:tag int} getColliderShape [])
 (^{:tag godotclj.bindings.godot.Vector2} getColliderVelocity [])
 (^{:tag godotclj.bindings.godot.Vector2} getCollisionNormal [])
 (^{:tag godotclj.bindings.godot.Vector2} getCollisionPoint [])
 (^{:tag godotclj.bindings.godot.Vector2} getMotion [])
 (^{:tag godotclj.bindings.godot.Vector2} getMotionRemainder []))
(definterface
 MGodotSkeletonIK
 (^{:tag float} getInterpolation [])
 (^{:tag godotclj.bindings.godot.Vector3} getMagnetPosition [])
 (^{:tag int} getMaxIterations [])
 (^{:tag float} getMinDistance [])
 (^{:tag godotclj.api.gdscript.IGodotSkeleton} getParentSkeleton [])
 (^{:tag String} getRootBone [])
 (^{:tag godotclj.bindings.godot.NodePath} getTargetNode [])
 (^{:tag godotclj.bindings.godot.Transform} getTargetTransform [])
 (^{:tag String} getTipBone [])
 (^{:tag boolean} isOverrideTipBasis [])
 (^{:tag boolean} isRunning [])
 (^{:tag boolean} isUsingMagnet [])
 (^{:tag void} setInterpolation [interpolation])
 (^{:tag void} setMagnetPosition [local_position])
 (^{:tag void} setMaxIterations [iterations])
 (^{:tag void} setMinDistance [min_distance])
 (^{:tag void} setOverrideTipBasis [override])
 (^{:tag void} setRootBone [root_bone])
 (^{:tag void} setTargetNode [node])
 (^{:tag void} setTargetTransform [target])
 (^{:tag void} setTipBone [tip_bone])
 (^{:tag void} setUseMagnet [use])
 (^{:tag void} start [])
 (^{:tag void} start [one_time])
 (^{:tag void} stop []))
(definterface
 MGodotNavigation
 (^{:tag godotclj.bindings.godot.Vector3} getClosestPoint [to_point])
 (^{:tag godotclj.bindings.godot.Vector3}
  getClosestPointNormal
  [to_point])
 (^{:tag godotclj.api.gdscript.IGodotObject}
  getClosestPointOwner
  [to_point])
 (^{:tag godotclj.bindings.godot.Vector3}
  getClosestPointToSegment
  [start end])
 (^{:tag godotclj.bindings.godot.Vector3}
  getClosestPointToSegment
  [start end use_collision])
 (^{:tag godotclj.bindings.godot.PoolVector3Array}
  getSimplePath
  [start end])
 (^{:tag godotclj.bindings.godot.PoolVector3Array}
  getSimplePath
  [start end optimize])
 (^{:tag godotclj.bindings.godot.Vector3} getUpVector [])
 (^{:tag int} navmeshAdd [mesh xform])
 (^{:tag int} navmeshAdd [mesh xform owner])
 (^{:tag void} navmeshRemove [id])
 (^{:tag void} navmeshSetTransform [id xform])
 (^{:tag void} setUpVector [up]))
(definterface
 MGodotPhysics2DShapeQueryResult
 (^{:tag int} getResultCount [])
 (^{:tag godotclj.api.gdscript.IGodotObject} getResultObject [idx])
 (^{:tag int} getResultObjectId [idx])
 (^{:tag int} getResultObjectShape [idx])
 (^{:tag godotclj.bindings.godot.RID} getResultRid [idx]))
(definterface
 MGodotPacketPeerUDP
 (^{:tag void} close [])
 (^{:tag int} connectToHost [host port])
 (^{:tag String} getPacketIp [])
 (^{:tag int} getPacketPort [])
 (^{:tag boolean} isConnectedToHost [])
 (^{:tag boolean} isListening [])
 (^{:tag int} joinMulticastGroup [multicast_address interface_name])
 (^{:tag int} leaveMulticastGroup [multicast_address interface_name])
 (^{:tag int} listen [port])
 (^{:tag int} listen [port bind_address])
 (^{:tag int} listen [port bind_address recv_buf_size])
 (^{:tag void} setBroadcastEnabled [enabled])
 (^{:tag int} setDestAddress [host port])
 (^{:tag int} wait []))
(definterface MGodotVisualShaderNodeVectorClamp)
(definterface
 MGodotAnimationNodeBlend2
 (^{:tag boolean} isUsingSync [])
 (^{:tag void} setUseSync [enable]))
(definterface MGodotVisualShaderNodeBooleanUniform)
(definterface
 MGodotCSGMesh
 (^{:tag godotclj.api.gdscript.IGodotMaterial} getMaterial [])
 (^{:tag godotclj.api.gdscript.IGodotMesh} getMesh [])
 (^{:tag void} setMaterial [material])
 (^{:tag void} setMesh [mesh]))
(definterface MGodotPopupPanel)
(definterface
 MGodotVisualShaderNodeColorConstant
 (^{:tag godotclj.bindings.godot.Color} getConstant [])
 (^{:tag void} setConstant [value]))
(definterface
 MGodotImmediateGeometry
 (^{:tag void} addSphere [lats lons radius])
 (^{:tag void} addSphere [lats lons radius add_uv])
 (^{:tag void} addVertex [position])
 (^{:tag void} begin [primitive])
 (^{:tag void} begin [primitive texture])
 (^{:tag void} clear [])
 (^{:tag void} end [])
 (^{:tag void} setColor [color])
 (^{:tag void} setNormal [normal])
 (^{:tag void} setTangent [tangent])
 (^{:tag void} setUv [uv])
 (^{:tag void} setUv2 [uv]))
(definterface
 MGodot_Engine
 (^{:tag godotclj.bindings.godot.Dictionary} getAuthorInfo [])
 (^{:tag godotclj.bindings.godot.IndexedArray} getCopyrightInfo [])
 (^{:tag godotclj.bindings.godot.Dictionary} getDonorInfo [])
 (^{:tag int} getFramesDrawn [])
 (^{:tag float} getFramesPerSecond [])
 (^{:tag int} getIdleFrames [])
 (^{:tag int} getIterationsPerSecond [])
 (^{:tag godotclj.bindings.godot.Dictionary} getLicenseInfo [])
 (^{:tag String} getLicenseText [])
 (^{:tag godotclj.api.gdscript.IGodotMainLoop} getMainLoop [])
 (^{:tag int} getPhysicsFrames [])
 (^{:tag float} getPhysicsInterpolationFraction [])
 (^{:tag float} getPhysicsJitterFix [])
 (^{:tag godotclj.api.gdscript.IGodotObject} getSingleton [name])
 (^{:tag int} getTargetFps [])
 (^{:tag float} getTimeScale [])
 (^{:tag godotclj.bindings.godot.Dictionary} getVersionInfo [])
 (^{:tag boolean} hasSingleton [name])
 (^{:tag boolean} isEditorHint [])
 (^{:tag boolean} isInPhysicsFrame [])
 (^{:tag void} setEditorHint [enabled])
 (^{:tag void} setIterationsPerSecond [iterations_per_second])
 (^{:tag void} setPhysicsJitterFix [physics_jitter_fix])
 (^{:tag void} setTargetFps [target_fps])
 (^{:tag void} setTimeScale [time_scale]))
(definterface
 MGodotFileDialog
 (^{:tag void} addFilter [filter])
 (^{:tag void} clearFilters [])
 (^{:tag void} deselectItems [])
 (^{:tag int} getAccess [])
 (^{:tag String} getCurrentDir [])
 (^{:tag String} getCurrentFile [])
 (^{:tag String} getCurrentPath [])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  getFilters
  [])
 (^{:tag godotclj.api.gdscript.IGodotLineEdit} getLineEdit [])
 (^{:tag int} getMode [])
 (^{:tag godotclj.api.gdscript.IGodotVBoxContainer} getVbox [])
 (^{:tag void} invalidate [])
 (^{:tag boolean} isModeOverridingTitle [])
 (^{:tag boolean} isShowingHiddenFiles [])
 (^{:tag void} setAccess [access])
 (^{:tag void} setCurrentDir [dir])
 (^{:tag void} setCurrentFile [file])
 (^{:tag void} setCurrentPath [path])
 (^{:tag void} setFilters [filters])
 (^{:tag void} setMode [mode])
 (^{:tag void} setModeOverridesTitle [override])
 (^{:tag void} setShowHiddenFiles [show]))
(definterface MGodotVisualShaderNodeCubeMapUniform)
(definterface
 MGodotAudioEffectChorus
 (^{:tag float} getDry [])
 (^{:tag int} getVoiceCount [])
 (^{:tag float} getVoiceCutoffHz [voice_idx])
 (^{:tag float} getVoiceDelayMs [voice_idx])
 (^{:tag float} getVoiceDepthMs [voice_idx])
 (^{:tag float} getVoiceLevelDb [voice_idx])
 (^{:tag float} getVoicePan [voice_idx])
 (^{:tag float} getVoiceRateHz [voice_idx])
 (^{:tag float} getWet [])
 (^{:tag void} setDry [amount])
 (^{:tag void} setVoiceCount [voices])
 (^{:tag void} setVoiceCutoffHz [voice_idx cutoff_hz])
 (^{:tag void} setVoiceDelayMs [voice_idx delay_ms])
 (^{:tag void} setVoiceDepthMs [voice_idx depth_ms])
 (^{:tag void} setVoiceLevelDb [voice_idx level_db])
 (^{:tag void} setVoicePan [voice_idx pan])
 (^{:tag void} setVoiceRateHz [voice_idx rate_hz])
 (^{:tag void} setWet [amount]))
(definterface
 MGodotPhysicsShapeQueryParameters
 (^{:tag int} getCollisionMask [])
 (^{:tag godotclj.bindings.godot.IndexedArray} getExclude [])
 (^{:tag float} getMargin [])
 (^{:tag godotclj.bindings.godot.RID} getShapeRid [])
 (^{:tag godotclj.bindings.godot.Transform} getTransform [])
 (^{:tag boolean} isCollideWithAreasEnabled [])
 (^{:tag boolean} isCollideWithBodiesEnabled [])
 (^{:tag void} setCollideWithAreas [enable])
 (^{:tag void} setCollideWithBodies [enable])
 (^{:tag void} setCollisionMask [collision_mask])
 (^{:tag void} setExclude [exclude])
 (^{:tag void} setMargin [margin])
 (^{:tag void} setShape [shape])
 (^{:tag void} setShapeRid [shape])
 (^{:tag void} setTransform [transform]))
(definterface
 MGodotVisualScriptVariableSet
 (^{:tag String} getVariable [])
 (^{:tag void} setVariable [name]))
(definterface
 MGodotWorldEnvironment
 (^{:tag godotclj.api.gdscript.IGodotEnvironment} getEnvironment [])
 (^{:tag void} setEnvironment [env]))
(definterface
 MGodotScriptEditor
 (^{:tag boolean} canDropDataFw [point data from])
 (^{:tag void} dropDataFw [point data from])
 (^{:tag godotclj.api.gdscript.IGodotScript} getCurrentScript [])
 (^{:tag godotclj.bindings.godot.Variant} getDragDataFw [point from])
 (^{:tag godotclj.bindings.godot.IndexedArray} getOpenScripts [])
 (^{:tag void} gotoLine [line_number])
 (^{:tag void} openScriptCreateDialog [base_name base_path]))
(definterface
 MGodotEditorInspectorPlugin
 (^{:tag void} addCustomControl [control])
 (^{:tag void} addPropertyEditor [property editor])
 (^{:tag void}
  addPropertyEditorForMultipleProperties
  [label properties editor])
 (^{:tag boolean} canHandle [object])
 (^{:tag void} parseBegin [object])
 (^{:tag void} parseCategory [object category])
 (^{:tag void} parseEnd [])
 (^{:tag boolean}
  parseProperty
  [object type path hint hint_text usage]))
(definterface MGodotJavaClass)
(definterface
 MGodotVisualShaderNodeInput
 (^{:tag String} getInputName [])
 (^{:tag String} getInputRealName [])
 (^{:tag void} setInputName [name]))
(definterface MGodotAudioEffectEQ6)
(definterface
 MGodotCPUParticles
 (^{:tag void} convertFromParticles [particles])
 (^{:tag int} getAmount [])
 (^{:tag godotclj.bindings.godot.Color} getColor [])
 (^{:tag godotclj.api.gdscript.IGodotGradient} getColorRamp [])
 (^{:tag godotclj.bindings.godot.Vector3} getDirection [])
 (^{:tag int} getDrawOrder [])
 (^{:tag godotclj.bindings.godot.Vector3} getEmissionBoxExtents [])
 (^{:tag godotclj.bindings.godot.PoolColorArray} getEmissionColors [])
 (^{:tag godotclj.bindings.godot.PoolVector3Array}
  getEmissionNormals
  [])
 (^{:tag godotclj.bindings.godot.PoolVector3Array}
  getEmissionPoints
  [])
 (^{:tag int} getEmissionShape [])
 (^{:tag float} getEmissionSphereRadius [])
 (^{:tag float} getExplosivenessRatio [])
 (^{:tag int} getFixedFps [])
 (^{:tag float} getFlatness [])
 (^{:tag boolean} getFractionalDelta [])
 (^{:tag godotclj.bindings.godot.Vector3} getGravity [])
 (^{:tag float} getLifetime [])
 (^{:tag float} getLifetimeRandomness [])
 (^{:tag godotclj.api.gdscript.IGodotMesh} getMesh [])
 (^{:tag boolean} getOneShot [])
 (^{:tag float} getParam [param])
 (^{:tag godotclj.api.gdscript.IGodotCurve} getParamCurve [param])
 (^{:tag float} getParamRandomness [param])
 (^{:tag boolean} getParticleFlag [flag])
 (^{:tag float} getPreProcessTime [])
 (^{:tag float} getRandomnessRatio [])
 (^{:tag float} getSpeedScale [])
 (^{:tag float} getSpread [])
 (^{:tag boolean} getUseLocalCoordinates [])
 (^{:tag boolean} isEmitting [])
 (^{:tag void} restart [])
 (^{:tag void} setAmount [amount])
 (^{:tag void} setColor [color])
 (^{:tag void} setColorRamp [ramp])
 (^{:tag void} setDirection [direction])
 (^{:tag void} setDrawOrder [order])
 (^{:tag void} setEmissionBoxExtents [extents])
 (^{:tag void} setEmissionColors [array])
 (^{:tag void} setEmissionNormals [array])
 (^{:tag void} setEmissionPoints [array])
 (^{:tag void} setEmissionShape [shape])
 (^{:tag void} setEmissionSphereRadius [radius])
 (^{:tag void} setEmitting [emitting])
 (^{:tag void} setExplosivenessRatio [ratio])
 (^{:tag void} setFixedFps [fps])
 (^{:tag void} setFlatness [amount])
 (^{:tag void} setFractionalDelta [enable])
 (^{:tag void} setGravity [accel_vec])
 (^{:tag void} setLifetime [secs])
 (^{:tag void} setLifetimeRandomness [random])
 (^{:tag void} setMesh [mesh])
 (^{:tag void} setOneShot [enable])
 (^{:tag void} setParam [param value])
 (^{:tag void} setParamCurve [param curve])
 (^{:tag void} setParamRandomness [param randomness])
 (^{:tag void} setParticleFlag [flag enable])
 (^{:tag void} setPreProcessTime [secs])
 (^{:tag void} setRandomnessRatio [ratio])
 (^{:tag void} setSpeedScale [scale])
 (^{:tag void} setSpread [degrees])
 (^{:tag void} setUseLocalCoordinates [enable]))
(definterface
 MGodotCurve
 (^{:tag int} addPoint [position])
 (^{:tag int} addPoint [position left_tangent])
 (^{:tag int} addPoint [position left_tangent right_tangent])
 (^{:tag int}
  addPoint
  [position left_tangent right_tangent left_mode])
 (^{:tag int}
  addPoint
  [position left_tangent right_tangent left_mode right_mode])
 (^{:tag void} bake [])
 (^{:tag void} cleanDupes [])
 (^{:tag void} clearPoints [])
 (^{:tag int} getBakeResolution [])
 (^{:tag float} getMaxValue [])
 (^{:tag float} getMinValue [])
 (^{:tag int} getPointCount [])
 (^{:tag int} getPointLeftMode [index])
 (^{:tag float} getPointLeftTangent [index])
 (^{:tag godotclj.bindings.godot.Vector2} getPointPosition [index])
 (^{:tag int} getPointRightMode [index])
 (^{:tag float} getPointRightTangent [index])
 (^{:tag float} interpolate [offset])
 (^{:tag float} interpolateBaked [offset])
 (^{:tag void} removePoint [index])
 (^{:tag void} setBakeResolution [resolution])
 (^{:tag void} setMaxValue [max])
 (^{:tag void} setMinValue [min])
 (^{:tag void} setPointLeftMode [index mode])
 (^{:tag void} setPointLeftTangent [index tangent])
 (^{:tag int} setPointOffset [index offset])
 (^{:tag void} setPointRightMode [index mode])
 (^{:tag void} setPointRightTangent [index tangent])
 (^{:tag void} setPointValue [index y]))
(definterface
 MGodotTextureProgress
 (^{:tag float} getFillDegrees [])
 (^{:tag int} getFillMode [])
 (^{:tag boolean} getNinePatchStretch [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getOverTexture [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getProgressTexture [])
 (^{:tag godotclj.bindings.godot.Vector2} getRadialCenterOffset [])
 (^{:tag float} getRadialInitialAngle [])
 (^{:tag int} getStretchMargin [margin])
 (^{:tag godotclj.bindings.godot.Color} getTintOver [])
 (^{:tag godotclj.bindings.godot.Color} getTintProgress [])
 (^{:tag godotclj.bindings.godot.Color} getTintUnder [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getUnderTexture [])
 (^{:tag void} setFillDegrees [mode])
 (^{:tag void} setFillMode [mode])
 (^{:tag void} setNinePatchStretch [stretch])
 (^{:tag void} setOverTexture [tex])
 (^{:tag void} setProgressTexture [tex])
 (^{:tag void} setRadialCenterOffset [mode])
 (^{:tag void} setRadialInitialAngle [mode])
 (^{:tag void} setStretchMargin [margin value])
 (^{:tag void} setTintOver [tint])
 (^{:tag void} setTintProgress [tint])
 (^{:tag void} setTintUnder [tint])
 (^{:tag void} setUnderTexture [tex]))
(definterface
 MGodotPathFollow
 (^{:tag boolean} getCubicInterpolation [])
 (^{:tag float} getHOffset [])
 (^{:tag float} getOffset [])
 (^{:tag int} getRotationMode [])
 (^{:tag float} getUnitOffset [])
 (^{:tag float} getVOffset [])
 (^{:tag boolean} hasLoop [])
 (^{:tag void} setCubicInterpolation [enable])
 (^{:tag void} setHOffset [h_offset])
 (^{:tag void} setLoop [loop])
 (^{:tag void} setOffset [offset])
 (^{:tag void} setRotationMode [rotation_mode])
 (^{:tag void} setUnitOffset [unit_offset])
 (^{:tag void} setVOffset [v_offset]))
(definterface
 MGodotCanvasModulate
 (^{:tag godotclj.bindings.godot.Color} getColor [])
 (^{:tag void} setColor [color]))
(definterface
 MGodotAnimationNodeStateMachine
 (^{:tag void} addNode [name node])
 (^{:tag void} addNode [name node position])
 (^{:tag void} addTransition [from to transition])
 (^{:tag String} getEndNode [])
 (^{:tag godotclj.bindings.godot.Vector2} getGraphOffset [])
 (^{:tag godotclj.api.gdscript.IGodotAnimationNode} getNode [name])
 (^{:tag String} getNodeName [node])
 (^{:tag godotclj.bindings.godot.Vector2} getNodePosition [name])
 (^{:tag String} getStartNode [])
 (^{:tag godotclj.api.gdscript.IGodotAnimationNodeStateMachineTransition}
  getTransition
  [idx])
 (^{:tag int} getTransitionCount [])
 (^{:tag String} getTransitionFrom [idx])
 (^{:tag String} getTransitionTo [idx])
 (^{:tag boolean} hasNode [name])
 (^{:tag boolean} hasTransition [from to])
 (^{:tag void} removeNode [name])
 (^{:tag void} removeTransition [from to])
 (^{:tag void} removeTransitionByIndex [idx])
 (^{:tag void} renameNode [name new_name])
 (^{:tag void} replaceNode [name node])
 (^{:tag void} setEndNode [name])
 (^{:tag void} setGraphOffset [offset])
 (^{:tag void} setNodePosition [name position])
 (^{:tag void} setStartNode [name]))
(definterface MGodotPointMesh)
(definterface
 MGodotBitMap
 (^{:tag void} create [size])
 (^{:tag void} createFromImageAlpha [image])
 (^{:tag void} createFromImageAlpha [image threshold])
 (^{:tag boolean} getBit [position])
 (^{:tag godotclj.bindings.godot.Vector2} getSize [])
 (^{:tag int} getTrueBitCount [])
 (^{:tag void} growMask [pixels rect])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  opaqueToPolygons
  [rect])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  opaqueToPolygons
  [rect epsilon])
 (^{:tag void} setBit [position bit])
 (^{:tag void} setBitRect [rect bit]))
(definterface
 MGodotCubeMesh
 (^{:tag godotclj.bindings.godot.Vector3} getSize [])
 (^{:tag int} getSubdivideDepth [])
 (^{:tag int} getSubdivideHeight [])
 (^{:tag int} getSubdivideWidth [])
 (^{:tag void} setSize [size])
 (^{:tag void} setSubdivideDepth [divisions])
 (^{:tag void} setSubdivideHeight [divisions])
 (^{:tag void} setSubdivideWidth [subdivide]))
(definterface
 MGodotPath
 (^{:tag godotclj.api.gdscript.IGodotCurve3D} getCurve [])
 (^{:tag void} setCurve [curve]))
(definterface
 MGodotAnimatedSprite
 (^{:tag String} getAnimation [])
 (^{:tag int} getFrame [])
 (^{:tag godotclj.bindings.godot.Vector2} getOffset [])
 (^{:tag float} getSpeedScale [])
 (^{:tag godotclj.api.gdscript.IGodotSpriteFrames} getSpriteFrames [])
 (^{:tag boolean} isCentered [])
 (^{:tag boolean} isFlippedH [])
 (^{:tag boolean} isFlippedV [])
 (^{:tag boolean} isPlaying [])
 (^{:tag void} play [])
 (^{:tag void} play [anim])
 (^{:tag void} play [anim backwards])
 (^{:tag void} setAnimation [animation])
 (^{:tag void} setCentered [centered])
 (^{:tag void} setFlipH [flip_h])
 (^{:tag void} setFlipV [flip_v])
 (^{:tag void} setFrame [frame])
 (^{:tag void} setOffset [offset])
 (^{:tag void} setSpeedScale [speed_scale])
 (^{:tag void} setSpriteFrames [sprite_frames])
 (^{:tag void} stop []))
(definterface
 MGodotAudioEffectDistortion
 (^{:tag float} getDrive [])
 (^{:tag float} getKeepHfHz [])
 (^{:tag int} getMode [])
 (^{:tag float} getPostGain [])
 (^{:tag float} getPreGain [])
 (^{:tag void} setDrive [drive])
 (^{:tag void} setKeepHfHz [keep_hf_hz])
 (^{:tag void} setMode [mode])
 (^{:tag void} setPostGain [post_gain])
 (^{:tag void} setPreGain [pre_gain]))
(definterface
 MGodotNetworkedMultiplayerENet
 (^{:tag void} closeConnection [])
 (^{:tag void} closeConnection [wait_usec])
 (^{:tag int} createClient [address port])
 (^{:tag int} createClient [address port in_bandwidth])
 (^{:tag int} createClient [address port in_bandwidth out_bandwidth])
 (^{:tag int}
  createClient
  [address port in_bandwidth out_bandwidth client_port])
 (^{:tag int} createServer [port])
 (^{:tag int} createServer [port max_clients])
 (^{:tag int} createServer [port max_clients in_bandwidth])
 (^{:tag int}
  createServer
  [port max_clients in_bandwidth out_bandwidth])
 (^{:tag void} disconnectPeer [id])
 (^{:tag void} disconnectPeer [id now])
 (^{:tag int} getChannelCount [])
 (^{:tag int} getCompressionMode [])
 (^{:tag int} getLastPacketChannel [])
 (^{:tag int} getPacketChannel [])
 (^{:tag String} getPeerAddress [id])
 (^{:tag int} getPeerPort [id])
 (^{:tag int} getTransferChannel [])
 (^{:tag boolean} isAlwaysOrdered [])
 (^{:tag boolean} isDtlsEnabled [])
 (^{:tag boolean} isDtlsVerifyEnabled [])
 (^{:tag boolean} isServerRelayEnabled [])
 (^{:tag void} setAlwaysOrdered [ordered])
 (^{:tag void} setBindIp [ip])
 (^{:tag void} setChannelCount [channels])
 (^{:tag void} setCompressionMode [mode])
 (^{:tag void} setDtlsCertificate [certificate])
 (^{:tag void} setDtlsEnabled [enabled])
 (^{:tag void} setDtlsKey [key])
 (^{:tag void} setDtlsVerifyEnabled [enabled])
 (^{:tag void}
  setPeerTimeout
  [id timeout_limit timeout_min timeout_max])
 (^{:tag void} setServerRelayEnabled [enabled])
 (^{:tag void} setTransferChannel [channel]))
(definterface
 MGodotPhysics2DDirectBodyState
 (^{:tag void} addCentralForce [force])
 (^{:tag void} addForce [offset force])
 (^{:tag void} addTorque [torque])
 (^{:tag void} applyCentralImpulse [impulse])
 (^{:tag void} applyImpulse [offset impulse])
 (^{:tag void} applyTorqueImpulse [impulse])
 (^{:tag float} getAngularVelocity [])
 (^{:tag godotclj.bindings.godot.RID}
  getContactCollider
  [contact_idx])
 (^{:tag int} getContactColliderId [contact_idx])
 (^{:tag godotclj.api.gdscript.IGodotObject}
  getContactColliderObject
  [contact_idx])
 (^{:tag godotclj.bindings.godot.Vector2}
  getContactColliderPosition
  [contact_idx])
 (^{:tag int} getContactColliderShape [contact_idx])
 (^{:tag godotclj.bindings.godot.Variant}
  getContactColliderShapeMetadata
  [contact_idx])
 (^{:tag godotclj.bindings.godot.Vector2}
  getContactColliderVelocityAtPosition
  [contact_idx])
 (^{:tag int} getContactCount [])
 (^{:tag godotclj.bindings.godot.Vector2}
  getContactLocalNormal
  [contact_idx])
 (^{:tag godotclj.bindings.godot.Vector2}
  getContactLocalPosition
  [contact_idx])
 (^{:tag int} getContactLocalShape [contact_idx])
 (^{:tag float} getInverseInertia [])
 (^{:tag float} getInverseMass [])
 (^{:tag godotclj.bindings.godot.Vector2} getLinearVelocity [])
 (^{:tag godotclj.api.gdscript.IGodotPhysics2DDirectSpaceState}
  getSpaceState
  [])
 (^{:tag float} getStep [])
 (^{:tag float} getTotalAngularDamp [])
 (^{:tag godotclj.bindings.godot.Vector2} getTotalGravity [])
 (^{:tag float} getTotalLinearDamp [])
 (^{:tag godotclj.bindings.godot.Transform2D} getTransform [])
 (^{:tag void} integrateForces [])
 (^{:tag boolean} isSleeping [])
 (^{:tag void} setAngularVelocity [velocity])
 (^{:tag void} setLinearVelocity [velocity])
 (^{:tag void} setSleepState [enabled])
 (^{:tag void} setTransform [transform]))
(definterface
 MGodotDynamicFont
 (^{:tag void} addFallback [data])
 (^{:tag String} getAvailableChars [])
 (^{:tag godotclj.api.gdscript.IGodotDynamicFontData}
  getFallback
  [idx])
 (^{:tag int} getFallbackCount [])
 (^{:tag godotclj.api.gdscript.IGodotDynamicFontData} getFontData [])
 (^{:tag godotclj.bindings.godot.Color} getOutlineColor [])
 (^{:tag int} getOutlineSize [])
 (^{:tag int} getSize [])
 (^{:tag int} getSpacing [type])
 (^{:tag boolean} getUseFilter [])
 (^{:tag boolean} getUseMipmaps [])
 (^{:tag void} removeFallback [idx])
 (^{:tag void} setFallback [idx data])
 (^{:tag void} setFontData [data])
 (^{:tag void} setOutlineColor [color])
 (^{:tag void} setOutlineSize [size])
 (^{:tag void} setSize [data])
 (^{:tag void} setSpacing [type value])
 (^{:tag void} setUseFilter [enable])
 (^{:tag void} setUseMipmaps [enable]))
(definterface
 MGodotResourcePreloader
 (^{:tag void} addResource [name resource])
 (^{:tag godotclj.api.gdscript.IGodotResource} getResource [name])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  getResourceList
  [])
 (^{:tag boolean} hasResource [name])
 (^{:tag void} removeResource [name])
 (^{:tag void} renameResource [name newname]))
(definterface
 MGodotSprite3D
 (^{:tag int} getFrame [])
 (^{:tag godotclj.bindings.godot.Vector2} getFrameCoords [])
 (^{:tag int} getHframes [])
 (^{:tag godotclj.bindings.godot.IndexedRect2} getRegionRect [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getTexture [])
 (^{:tag int} getVframes [])
 (^{:tag boolean} isRegion [])
 (^{:tag void} setFrame [frame])
 (^{:tag void} setFrameCoords [coords])
 (^{:tag void} setHframes [hframes])
 (^{:tag void} setRegion [enabled])
 (^{:tag void} setRegionRect [rect])
 (^{:tag void} setTexture [texture])
 (^{:tag void} setVframes [vframes]))
(definterface
 MGodotDirectionalLight
 (^{:tag int} getShadowDepthRange [])
 (^{:tag int} getShadowMode [])
 (^{:tag boolean} isBlendSplitsEnabled [])
 (^{:tag void} setBlendSplits [enabled])
 (^{:tag void} setShadowDepthRange [mode])
 (^{:tag void} setShadowMode [mode]))
(definterface MGodotPacketPeerGDNative)
(definterface
 MGodotVisualShaderNodeColorOp
 (^{:tag int} getOperator [])
 (^{:tag void} setOperator [op]))
(definterface
 MGodotAudioStreamGeneratorPlayback
 (^{:tag boolean} canPushBuffer [amount])
 (^{:tag void} clearBuffer [])
 (^{:tag int} getFramesAvailable [])
 (^{:tag int} getSkips [])
 (^{:tag boolean} pushBuffer [frames])
 (^{:tag boolean} pushFrame [frame]))
(definterface
 MGodotCryptoKey
 (^{:tag int} load [path])
 (^{:tag int} save [path]))
(definterface
 MGodotARVRAnchor
 (^{:tag int} getAnchorId [])
 (^{:tag String} getAnchorName [])
 (^{:tag boolean} getIsActive [])
 (^{:tag godotclj.api.gdscript.IGodotMesh} getMesh [])
 (^{:tag godotclj.bindings.godot.Plane} getPlane [])
 (^{:tag godotclj.bindings.godot.Vector3} getSize [])
 (^{:tag void} setAnchorId [anchor_id]))
(definterface
 MGodotBitmapFont
 (^{:tag void} addChar [character texture rect])
 (^{:tag void} addChar [character texture rect align])
 (^{:tag void} addChar [character texture rect align advance])
 (^{:tag void} addKerningPair [char_a char_b kerning])
 (^{:tag void} addTexture [texture])
 (^{:tag void} clear [])
 (^{:tag int} createFromFnt [path])
 (^{:tag godotclj.api.gdscript.IGodotBitmapFont} getFallback [])
 (^{:tag int} getKerningPair [char_a char_b])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getTexture [idx])
 (^{:tag int} getTextureCount [])
 (^{:tag void} setAscent [px])
 (^{:tag void} setDistanceFieldHint [enable])
 (^{:tag void} setFallback [fallback])
 (^{:tag void} setHeight [px]))
(definterface
 MGodotViewportContainer
 (^{:tag int} getStretchShrink [])
 (^{:tag boolean} isStretchEnabled [])
 (^{:tag void} setStretch [enable])
 (^{:tag void} setStretchShrink [amount]))
(definterface
 MGodotAspectRatioContainer
 (^{:tag int} getAlignmentHorizontal [])
 (^{:tag int} getAlignmentVertical [])
 (^{:tag float} getRatio [])
 (^{:tag int} getStretchMode [])
 (^{:tag void} setAlignmentHorizontal [alignment_horizontal])
 (^{:tag void} setAlignmentVertical [alignment_vertical])
 (^{:tag void} setRatio [ratio])
 (^{:tag void} setStretchMode [stretch_mode]))
(definterface
 MGodotGIProbeData
 (^{:tag float} getBias [])
 (^{:tag godotclj.bindings.godot.AABB} getBounds [])
 (^{:tag float} getCellSize [])
 (^{:tag godotclj.bindings.godot.PoolIntArray} getDynamicData [])
 (^{:tag int} getDynamicRange [])
 (^{:tag float} getEnergy [])
 (^{:tag float} getNormalBias [])
 (^{:tag float} getPropagation [])
 (^{:tag godotclj.bindings.godot.Transform} getToCellXform [])
 (^{:tag boolean} isCompressed [])
 (^{:tag boolean} isInterior [])
 (^{:tag void} setBias [bias])
 (^{:tag void} setBounds [bounds])
 (^{:tag void} setCellSize [cell_size])
 (^{:tag void} setCompress [compress])
 (^{:tag void} setDynamicData [dynamic_data])
 (^{:tag void} setDynamicRange [dynamic_range])
 (^{:tag void} setEnergy [energy])
 (^{:tag void} setInterior [interior])
 (^{:tag void} setNormalBias [bias])
 (^{:tag void} setPropagation [propagation])
 (^{:tag void} setToCellXform [to_cell_xform]))
(definterface
 MGodotAnimationNodeAdd2
 (^{:tag boolean} isUsingSync [])
 (^{:tag void} setUseSync [enable]))
(definterface
 MGodotNavigationMeshInstance
 (^{:tag godotclj.api.gdscript.IGodotNavigationMesh}
  getNavigationMesh
  [])
 (^{:tag boolean} isEnabled [])
 (^{:tag void} setEnabled [enabled])
 (^{:tag void} setNavigationMesh [navmesh]))
(definterface MGodotAudioEffectBandLimitFilter)
(definterface
 MGodotInputEventMouseMotion
 (^{:tag float} getPressure [])
 (^{:tag godotclj.bindings.godot.Vector2} getRelative [])
 (^{:tag godotclj.bindings.godot.Vector2} getSpeed [])
 (^{:tag godotclj.bindings.godot.Vector2} getTilt [])
 (^{:tag void} setPressure [pressure])
 (^{:tag void} setRelative [relative])
 (^{:tag void} setSpeed [speed])
 (^{:tag void} setTilt [tilt]))
(definterface
 MGodotConcavePolygonShape2D
 (^{:tag godotclj.bindings.godot.IndexedPoolVector2Array}
  getSegments
  [])
 (^{:tag void} setSegments [segments]))
(definterface MGodotVisualShaderNodeVectorCompose)
(definterface
 MGodotTranslationServer
 (^{:tag void} addTranslation [translation])
 (^{:tag void} clear [])
 (^{:tag godotclj.bindings.godot.IndexedArray} getLoadedLocales [])
 (^{:tag String} getLocale [])
 (^{:tag String} getLocaleName [locale])
 (^{:tag void} removeTranslation [translation])
 (^{:tag void} setLocale [locale])
 (^{:tag String} translate [message]))
(definterface
 MGodotProxyTexture
 (^{:tag godotclj.api.gdscript.IGodotTexture} getBase [])
 (^{:tag void} setBase [base]))
(definterface
 MGodotBackBufferCopy
 (^{:tag int} getCopyMode [])
 (^{:tag godotclj.bindings.godot.IndexedRect2} getRect [])
 (^{:tag void} setCopyMode [copy_mode])
 (^{:tag void} setRect [rect]))
(definterface
 MGodotEditorSpinSlider
 (^{:tag String} getLabel [])
 (^{:tag boolean} isFlat [])
 (^{:tag boolean} isReadOnly [])
 (^{:tag void} setFlat [flat])
 (^{:tag void} setLabel [label])
 (^{:tag void} setReadOnly [read_only]))
(definterface
 MGodotAudioStreamPlayer2D
 (^{:tag int} getAreaMask [])
 (^{:tag float} getAttenuation [])
 (^{:tag String} getBus [])
 (^{:tag float} getMaxDistance [])
 (^{:tag float} getPitchScale [])
 (^{:tag float} getPlaybackPosition [])
 (^{:tag godotclj.api.gdscript.IGodotAudioStream} getStream [])
 (^{:tag boolean} getStreamPaused [])
 (^{:tag godotclj.api.gdscript.IGodotAudioStreamPlayback}
  getStreamPlayback
  [])
 (^{:tag float} getVolumeDb [])
 (^{:tag boolean} isAutoplayEnabled [])
 (^{:tag boolean} isPlaying [])
 (^{:tag void} play [])
 (^{:tag void} play [from_position])
 (^{:tag void} seek [to_position])
 (^{:tag void} setAreaMask [mask])
 (^{:tag void} setAttenuation [curve])
 (^{:tag void} setAutoplay [enable])
 (^{:tag void} setBus [bus])
 (^{:tag void} setMaxDistance [pixels])
 (^{:tag void} setPitchScale [pitch_scale])
 (^{:tag void} setStream [stream])
 (^{:tag void} setStreamPaused [pause])
 (^{:tag void} setVolumeDb [volume_db])
 (^{:tag void} stop []))
(definterface MGodotARVRInterfaceGDNative)
(definterface
 MGodotAnimationTree
 (^{:tag void} advance [delta])
 (^{:tag godotclj.bindings.godot.NodePath} getAnimationPlayer [])
 (^{:tag int} getProcessMode [])
 (^{:tag godotclj.bindings.godot.NodePath} getRootMotionTrack [])
 (^{:tag godotclj.bindings.godot.Transform} getRootMotionTransform [])
 (^{:tag godotclj.api.gdscript.IGodotAnimationNode} getTreeRoot [])
 (^{:tag boolean} isActive [])
 (^{:tag void} renameParameter [old_name new_name])
 (^{:tag void} setActive [active])
 (^{:tag void} setAnimationPlayer [root])
 (^{:tag void} setProcessMode [mode])
 (^{:tag void} setRootMotionTrack [path])
 (^{:tag void} setTreeRoot [root]))
(definterface
 MGodotColorPicker
 (^{:tag void} addPreset [color])
 (^{:tag boolean} arePresetsEnabled [])
 (^{:tag boolean} arePresetsVisible [])
 (^{:tag void} erasePreset [color])
 (^{:tag godotclj.bindings.godot.Color} getPickColor [])
 (^{:tag godotclj.bindings.godot.PoolColorArray} getPresets [])
 (^{:tag boolean} isDeferredMode [])
 (^{:tag boolean} isEditingAlpha [])
 (^{:tag boolean} isHsvMode [])
 (^{:tag boolean} isRawMode [])
 (^{:tag void} setDeferredMode [mode])
 (^{:tag void} setEditAlpha [show])
 (^{:tag void} setHsvMode [mode])
 (^{:tag void} setPickColor [color])
 (^{:tag void} setPresetsEnabled [enabled])
 (^{:tag void} setPresetsVisible [visible])
 (^{:tag void} setRawMode [mode]))
(definterface MGodotVisualShaderNodeColorUniform)
(definterface
 MGodotStyleBoxTexture
 (^{:tag float} getExpandMarginSize [margin])
 (^{:tag int} getHAxisStretchMode [])
 (^{:tag float} getMarginSize [margin])
 (^{:tag godotclj.bindings.godot.Color} getModulate [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getNormalMap [])
 (^{:tag godotclj.bindings.godot.IndexedRect2} getRegionRect [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getTexture [])
 (^{:tag int} getVAxisStretchMode [])
 (^{:tag boolean} isDrawCenterEnabled [])
 (^{:tag void} setDrawCenter [enable])
 (^{:tag void} setExpandMarginAll [size])
 (^{:tag void}
  setExpandMarginIndividual
  [size_left size_top size_right size_bottom])
 (^{:tag void} setExpandMarginSize [margin size])
 (^{:tag void} setHAxisStretchMode [mode])
 (^{:tag void} setMarginSize [margin size])
 (^{:tag void} setModulate [color])
 (^{:tag void} setNormalMap [normal_map])
 (^{:tag void} setRegionRect [region])
 (^{:tag void} setTexture [texture])
 (^{:tag void} setVAxisStretchMode [mode]))
(definterface MGodotVisualScriptIterator)
(definterface
 MGodotAudioStreamOGGVorbis
 (^{:tag godotclj.bindings.godot.PoolByteArray} getData [])
 (^{:tag float} getLoopOffset [])
 (^{:tag boolean} hasLoop [])
 (^{:tag void} setData [data])
 (^{:tag void} setLoop [enable])
 (^{:tag void} setLoopOffset [seconds]))
(definterface MGodotVisualShaderNodeScalarClamp)
(definterface
 MGodotUndoRedo
 (^{:tag void} addDoMethod [object method])
 (^{:tag void} addDoMethod [object method v1])
 (^{:tag void} addDoMethod [object method v1 v2])
 (^{:tag void} addDoMethod [object method v1 v2 v3])
 (^{:tag void} addDoMethod [object method v1 v2 v3 v4])
 (^{:tag void} addDoMethod [object method v1 v2 v3 v4 v5])
 (^{:tag void} addDoProperty [object property value])
 (^{:tag void} addDoReference [object])
 (^{:tag void} addUndoMethod [object method])
 (^{:tag void} addUndoMethod [object method v1])
 (^{:tag void} addUndoMethod [object method v1 v2])
 (^{:tag void} addUndoMethod [object method v1 v2 v3])
 (^{:tag void} addUndoMethod [object method v1 v2 v3 v4])
 (^{:tag void} addUndoMethod [object method v1 v2 v3 v4 v5])
 (^{:tag void} addUndoProperty [object property value])
 (^{:tag void} addUndoReference [object])
 (^{:tag void} clearHistory [])
 (^{:tag void} clearHistory [increase_version])
 (^{:tag void} commitAction [])
 (^{:tag void} createAction [name])
 (^{:tag void} createAction [name merge_mode])
 (^{:tag String} getCurrentActionName [])
 (^{:tag int} getVersion [])
 (^{:tag boolean} hasRedo [])
 (^{:tag boolean} hasUndo [])
 (^{:tag boolean} isCommitingAction [])
 (^{:tag boolean} redo [])
 (^{:tag boolean} undo []))
(definterface
 MGodotPluginScript
 (^{:tag godotclj.bindings.godot.Variant} new [])
 (^{:tag godotclj.bindings.godot.Variant} new [v1])
 (^{:tag godotclj.bindings.godot.Variant} new [v1 v2])
 (^{:tag godotclj.bindings.godot.Variant} new [v1 v2 v3])
 (^{:tag godotclj.bindings.godot.Variant} new [v1 v2 v3 v4])
 (^{:tag godotclj.bindings.godot.Variant} new [v1 v2 v3 v4 v5]))
(definterface
 MGodotSoftBody
 (^{:tag void} addCollisionExceptionWith [body])
 (^{:tag float} getAreaangularStiffness [])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  getCollisionExceptions
  [])
 (^{:tag int} getCollisionLayer [])
 (^{:tag boolean} getCollisionLayerBit [bit])
 (^{:tag int} getCollisionMask [])
 (^{:tag boolean} getCollisionMaskBit [bit])
 (^{:tag float} getDampingCoefficient [])
 (^{:tag float} getDragCoefficient [])
 (^{:tag float} getLinearStiffness [])
 (^{:tag godotclj.bindings.godot.NodePath}
  getParentCollisionIgnore
  [])
 (^{:tag float} getPoseMatchingCoefficient [])
 (^{:tag float} getPressureCoefficient [])
 (^{:tag int} getSimulationPrecision [])
 (^{:tag float} getTotalMass [])
 (^{:tag float} getVolumeStiffness [])
 (^{:tag boolean} isRayPickable [])
 (^{:tag void} removeCollisionExceptionWith [body])
 (^{:tag void} setAreaangularStiffness [areaAngular_stiffness])
 (^{:tag void} setCollisionLayer [collision_layer])
 (^{:tag void} setCollisionLayerBit [bit value])
 (^{:tag void} setCollisionMask [collision_mask])
 (^{:tag void} setCollisionMaskBit [bit value])
 (^{:tag void} setDampingCoefficient [damping_coefficient])
 (^{:tag void} setDragCoefficient [drag_coefficient])
 (^{:tag void} setLinearStiffness [linear_stiffness])
 (^{:tag void} setParentCollisionIgnore [parent_collision_ignore])
 (^{:tag void} setPoseMatchingCoefficient [pose_matching_coefficient])
 (^{:tag void} setPressureCoefficient [pressure_coefficient])
 (^{:tag void} setRayPickable [ray_pickable])
 (^{:tag void} setSimulationPrecision [simulation_precision])
 (^{:tag void} setTotalMass [mass])
 (^{:tag void} setVolumeStiffness [volume_stiffness]))
(definterface
 MGodotRayCast
 (^{:tag void} addException [node])
 (^{:tag void} addExceptionRid [rid])
 (^{:tag void} clearExceptions [])
 (^{:tag void} forceRaycastUpdate [])
 (^{:tag godotclj.bindings.godot.Vector3} getCastTo [])
 (^{:tag godotclj.api.gdscript.IGodotObject} getCollider [])
 (^{:tag int} getColliderShape [])
 (^{:tag int} getCollisionMask [])
 (^{:tag boolean} getCollisionMaskBit [bit])
 (^{:tag godotclj.bindings.godot.Vector3} getCollisionNormal [])
 (^{:tag godotclj.bindings.godot.Vector3} getCollisionPoint [])
 (^{:tag boolean} getExcludeParentBody [])
 (^{:tag boolean} isCollideWithAreasEnabled [])
 (^{:tag boolean} isCollideWithBodiesEnabled [])
 (^{:tag boolean} isColliding [])
 (^{:tag boolean} isEnabled [])
 (^{:tag void} removeException [node])
 (^{:tag void} removeExceptionRid [rid])
 (^{:tag void} setCastTo [local_point])
 (^{:tag void} setCollideWithAreas [enable])
 (^{:tag void} setCollideWithBodies [enable])
 (^{:tag void} setCollisionMask [mask])
 (^{:tag void} setCollisionMaskBit [bit value])
 (^{:tag void} setEnabled [enabled])
 (^{:tag void} setExcludeParentBody [mask]))
(definterface MGodotVisualScriptIndexGet)
(definterface
 MGodotVisualScriptYield
 (^{:tag float} getWaitTime [])
 (^{:tag int} getYieldMode [])
 (^{:tag void} setWaitTime [sec])
 (^{:tag void} setYieldMode [mode]))
(definterface
 MGodotKinematicCollision
 (^{:tag godotclj.api.gdscript.IGodotObject} getCollider [])
 (^{:tag int} getColliderId [])
 (^{:tag godotclj.bindings.godot.Variant} getColliderMetadata [])
 (^{:tag godotclj.bindings.godot.RID} getColliderRid [])
 (^{:tag godotclj.api.gdscript.IGodotObject} getColliderShape [])
 (^{:tag int} getColliderShapeIndex [])
 (^{:tag godotclj.bindings.godot.Vector3} getColliderVelocity [])
 (^{:tag godotclj.api.gdscript.IGodotObject} getLocalShape [])
 (^{:tag godotclj.bindings.godot.Vector3} getNormal [])
 (^{:tag godotclj.bindings.godot.Vector3} getPosition [])
 (^{:tag godotclj.bindings.godot.Vector3} getRemainder [])
 (^{:tag godotclj.bindings.godot.Vector3} getTravel []))
(definterface
 MGodotSceneTree
 (^{:tag godotclj.bindings.godot.Variant} callGroup [group method])
 (^{:tag godotclj.bindings.godot.Variant} callGroup [group method v1])
 (^{:tag godotclj.bindings.godot.Variant}
  callGroup
  [group method v1 v2])
 (^{:tag godotclj.bindings.godot.Variant}
  callGroup
  [group method v1 v2 v3])
 (^{:tag godotclj.bindings.godot.Variant}
  callGroup
  [group method v1 v2 v3 v4])
 (^{:tag godotclj.bindings.godot.Variant}
  callGroup
  [group method v1 v2 v3 v4 v5])
 (^{:tag godotclj.bindings.godot.Variant}
  callGroupFlags
  [flags group method])
 (^{:tag godotclj.bindings.godot.Variant}
  callGroupFlags
  [flags group method v1])
 (^{:tag godotclj.bindings.godot.Variant}
  callGroupFlags
  [flags group method v1 v2])
 (^{:tag godotclj.bindings.godot.Variant}
  callGroupFlags
  [flags group method v1 v2 v3])
 (^{:tag godotclj.bindings.godot.Variant}
  callGroupFlags
  [flags group method v1 v2 v3 v4])
 (^{:tag godotclj.bindings.godot.Variant}
  callGroupFlags
  [flags group method v1 v2 v3 v4 v5])
 (^{:tag int} changeScene [path])
 (^{:tag int} changeSceneTo [packed_scene])
 (^{:tag godotclj.api.gdscript.IGodotSceneTreeTimer}
  createTimer
  [time_sec])
 (^{:tag godotclj.api.gdscript.IGodotSceneTreeTimer}
  createTimer
  [time_sec pause_mode_process])
 (^{:tag godotclj.api.gdscript.IGodotNode} getCurrentScene [])
 (^{:tag godotclj.api.gdscript.IGodotNode} getEditedSceneRoot [])
 (^{:tag int} getFrame [])
 (^{:tag godotclj.api.gdscript.IGodotMultiplayerAPI}
  getMultiplayer
  [])
 (^{:tag godotclj.bindings.godot.PoolIntArray}
  getNetworkConnectedPeers
  [])
 (^{:tag godotclj.api.gdscript.IGodotNetworkedMultiplayerPeer}
  getNetworkPeer
  [])
 (^{:tag int} getNetworkUniqueId [])
 (^{:tag int} getNodeCount [])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  getNodesInGroup
  [group])
 (^{:tag godotclj.api.gdscript.IGodotViewport} getRoot [])
 (^{:tag int} getRpcSenderId [])
 (^{:tag boolean} hasGroup [name])
 (^{:tag boolean} hasNetworkPeer [])
 (^{:tag boolean} isDebuggingCollisionsHint [])
 (^{:tag boolean} isDebuggingNavigationHint [])
 (^{:tag boolean} isInputHandled [])
 (^{:tag boolean} isMultiplayerPollEnabled [])
 (^{:tag boolean} isNetworkServer [])
 (^{:tag boolean} isPaused [])
 (^{:tag boolean} isRefusingNewNetworkConnections [])
 (^{:tag boolean} isUsingFontOversampling [])
 (^{:tag void} notifyGroup [group notification])
 (^{:tag void} notifyGroupFlags [call_flags group notification])
 (^{:tag void} queueDelete [obj])
 (^{:tag void} quit [])
 (^{:tag void} quit [exit_code])
 (^{:tag int} reloadCurrentScene [])
 (^{:tag void} setAutoAcceptQuit [enabled])
 (^{:tag void} setCurrentScene [child_node])
 (^{:tag void} setDebugCollisionsHint [enable])
 (^{:tag void} setDebugNavigationHint [enable])
 (^{:tag void} setEditedSceneRoot [scene])
 (^{:tag void} setGroup [group property value])
 (^{:tag void} setGroupFlags [call_flags group property value])
 (^{:tag void} setInputAsHandled [])
 (^{:tag void} setMultiplayer [multiplayer])
 (^{:tag void} setMultiplayerPollEnabled [enabled])
 (^{:tag void} setNetworkPeer [peer])
 (^{:tag void} setPause [enable])
 (^{:tag void} setQuitOnGoBack [enabled])
 (^{:tag void} setRefuseNewNetworkConnections [refuse])
 (^{:tag void} setScreenStretch [mode aspect minsize])
 (^{:tag void} setScreenStretch [mode aspect minsize shrink])
 (^{:tag void} setUseFontOversampling [enable]))
(definterface MGodotGlobalConstants)
(definterface
 MGodotGridContainer
 (^{:tag int} getColumns [])
 (^{:tag void} setColumns [columns]))
(definterface
 MGodotInputMap
 (^{:tag void} actionAddEvent [action event])
 (^{:tag void} actionEraseEvent [action event])
 (^{:tag void} actionEraseEvents [action])
 (^{:tag float} actionGetDeadzone [action])
 (^{:tag boolean} actionHasEvent [action event])
 (^{:tag void} actionSetDeadzone [action deadzone])
 (^{:tag void} addAction [action])
 (^{:tag void} addAction [action deadzone])
 (^{:tag void} eraseAction [action])
 (^{:tag boolean} eventIsAction [event action])
 (^{:tag godotclj.bindings.godot.IndexedArray} getActionList [action])
 (^{:tag godotclj.bindings.godot.IndexedArray} getActions [])
 (^{:tag boolean} hasAction [action])
 (^{:tag void} loadFromGlobals []))
(definterface
 MGodotPCKPacker
 (^{:tag int} addFile [pck_path source_path])
 (^{:tag int} flush [])
 (^{:tag int} flush [verbose])
 (^{:tag int} pckStart [pck_name])
 (^{:tag int} pckStart [pck_name alignment]))
(definterface
 MGodotShortCut
 (^{:tag String} getAsText [])
 (^{:tag godotclj.api.gdscript.IGodotInputEvent} getShortcut [])
 (^{:tag boolean} isShortcut [event])
 (^{:tag boolean} isValid [])
 (^{:tag void} setShortcut [event]))
(definterface MGodotStyleBoxEmpty)
(definterface
 MGodotVisualShaderNodeScalarConstant
 (^{:tag float} getConstant [])
 (^{:tag void} setConstant [value]))
(definterface MGodotCheckButton)
(definterface
 MGodotWeakRef
 (^{:tag godotclj.bindings.godot.Variant} getRef []))
(definterface
 MGodotVisualShaderNodeColorFunc
 (^{:tag int} getFunction [])
 (^{:tag void} setFunction [func]))
(definterface
 MGodotMeshTexture
 (^{:tag godotclj.api.gdscript.IGodotTexture} getBaseTexture [])
 (^{:tag godotclj.bindings.godot.Vector2} getImageSize [])
 (^{:tag godotclj.api.gdscript.IGodotMesh} getMesh [])
 (^{:tag void} setBaseTexture [texture])
 (^{:tag void} setImageSize [size])
 (^{:tag void} setMesh [mesh]))
(definterface MGodotVisualShaderNodeVectorInterp)
(definterface
 MGodotPackedScene
 (^{:tag boolean} canInstance [])
 (^{:tag godotclj.api.gdscript.IGodotSceneState} getState [])
 (^{:tag godotclj.api.gdscript.IGodotNode} instance [])
 (^{:tag godotclj.api.gdscript.IGodotNode} instance [edit_state])
 (^{:tag int} pack [path]))
(definterface
 MGodotLightOccluder2D
 (^{:tag int} getOccluderLightMask [])
 (^{:tag godotclj.api.gdscript.IGodotOccluderPolygon2D}
  getOccluderPolygon
  [])
 (^{:tag void} setOccluderLightMask [mask])
 (^{:tag void} setOccluderPolygon [polygon]))
(definterface
 MGodotPrismMesh
 (^{:tag float} getLeftToRight [])
 (^{:tag godotclj.bindings.godot.Vector3} getSize [])
 (^{:tag int} getSubdivideDepth [])
 (^{:tag int} getSubdivideHeight [])
 (^{:tag int} getSubdivideWidth [])
 (^{:tag void} setLeftToRight [left_to_right])
 (^{:tag void} setSize [size])
 (^{:tag void} setSubdivideDepth [segments])
 (^{:tag void} setSubdivideHeight [segments])
 (^{:tag void} setSubdivideWidth [segments]))
(definterface MGodotVisualShaderNodeVec3Uniform)
(definterface MGodotPhysics2DDirectBodyStateSW)
(definterface
 MGodotReflectionProbe
 (^{:tag boolean} areShadowsEnabled [])
 (^{:tag int} getCullMask [])
 (^{:tag godotclj.bindings.godot.Vector3} getExtents [])
 (^{:tag float} getIntensity [])
 (^{:tag godotclj.bindings.godot.Color} getInteriorAmbient [])
 (^{:tag float} getInteriorAmbientEnergy [])
 (^{:tag float} getInteriorAmbientProbeContribution [])
 (^{:tag float} getMaxDistance [])
 (^{:tag godotclj.bindings.godot.Vector3} getOriginOffset [])
 (^{:tag int} getUpdateMode [])
 (^{:tag boolean} isBoxProjectionEnabled [])
 (^{:tag boolean} isSetAsInterior [])
 (^{:tag void} setAsInterior [enable])
 (^{:tag void} setCullMask [layers])
 (^{:tag void} setEnableBoxProjection [enable])
 (^{:tag void} setEnableShadows [enable])
 (^{:tag void} setExtents [extents])
 (^{:tag void} setIntensity [intensity])
 (^{:tag void} setInteriorAmbient [ambient])
 (^{:tag void} setInteriorAmbientEnergy [ambient_energy])
 (^{:tag void}
  setInteriorAmbientProbeContribution
  [ambient_probe_contribution])
 (^{:tag void} setMaxDistance [max_distance])
 (^{:tag void} setOriginOffset [origin_offset])
 (^{:tag void} setUpdateMode [mode]))
(definterface
 MGodotVisualScriptEmitSignal
 (^{:tag String} getSignal [])
 (^{:tag void} setSignal [name]))
(definterface
 MGodotVehicleWheel
 (^{:tag float} getBrake [])
 (^{:tag float} getDampingCompression [])
 (^{:tag float} getDampingRelaxation [])
 (^{:tag float} getEngineForce [])
 (^{:tag float} getFrictionSlip [])
 (^{:tag float} getRadius [])
 (^{:tag float} getRollInfluence [])
 (^{:tag float} getRpm [])
 (^{:tag float} getSkidinfo [])
 (^{:tag float} getSteering [])
 (^{:tag float} getSuspensionMaxForce [])
 (^{:tag float} getSuspensionRestLength [])
 (^{:tag float} getSuspensionStiffness [])
 (^{:tag float} getSuspensionTravel [])
 (^{:tag boolean} isInContact [])
 (^{:tag boolean} isUsedAsSteering [])
 (^{:tag boolean} isUsedAsTraction [])
 (^{:tag void} setBrake [brake])
 (^{:tag void} setDampingCompression [length])
 (^{:tag void} setDampingRelaxation [length])
 (^{:tag void} setEngineForce [engine_force])
 (^{:tag void} setFrictionSlip [length])
 (^{:tag void} setRadius [length])
 (^{:tag void} setRollInfluence [roll_influence])
 (^{:tag void} setSteering [steering])
 (^{:tag void} setSuspensionMaxForce [length])
 (^{:tag void} setSuspensionRestLength [length])
 (^{:tag void} setSuspensionStiffness [length])
 (^{:tag void} setSuspensionTravel [length])
 (^{:tag void} setUseAsSteering [enable])
 (^{:tag void} setUseAsTraction [enable]))
(definterface
 MGodotRandomNumberGenerator
 (^{:tag int} getSeed [])
 (^{:tag int} getState [])
 (^{:tag float} randf [])
 (^{:tag float} randfRange [from to])
 (^{:tag float} randfn [])
 (^{:tag float} randfn [mean])
 (^{:tag float} randfn [mean deviation])
 (^{:tag int} randi [])
 (^{:tag int} randiRange [from to])
 (^{:tag void} randomize [])
 (^{:tag void} setSeed [seed])
 (^{:tag void} setState [state]))
(definterface
 MGodotEditorImportPlugin
 (^{:tag godotclj.bindings.godot.IndexedArray}
  getImportOptions
  [preset])
 (^{:tag int} getImportOrder [])
 (^{:tag String} getImporterName [])
 (^{:tag boolean} getOptionVisibility [option options])
 (^{:tag int} getPresetCount [])
 (^{:tag String} getPresetName [preset])
 (^{:tag float} getPriority [])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  getRecognizedExtensions
  [])
 (^{:tag String} getResourceType [])
 (^{:tag String} getSaveExtension [])
 (^{:tag String} getVisibleName [])
 (^{:tag int}
  import
  [source_file save_path options platform_variants gen_files]))
(definterface
 MGodotWebSocketPeer
 (^{:tag void} close [])
 (^{:tag void} close [code])
 (^{:tag void} close [code reason])
 (^{:tag String} getConnectedHost [])
 (^{:tag int} getConnectedPort [])
 (^{:tag int} getCurrentOutboundBufferedAmount [])
 (^{:tag int} getWriteMode [])
 (^{:tag boolean} isConnectedToHost [])
 (^{:tag void} setNoDelay [enabled])
 (^{:tag void} setWriteMode [mode])
 (^{:tag boolean} wasStringPacket []))
(definterface
 MGodotGradient
 (^{:tag void} addPoint [offset color])
 (^{:tag godotclj.bindings.godot.Color} getColor [point])
 (^{:tag godotclj.bindings.godot.PoolColorArray} getColors [])
 (^{:tag float} getOffset [point])
 (^{:tag godotclj.bindings.godot.PoolRealArray} getOffsets [])
 (^{:tag int} getPointCount [])
 (^{:tag godotclj.bindings.godot.Color} interpolate [offset])
 (^{:tag void} removePoint [point])
 (^{:tag void} setColor [point color])
 (^{:tag void} setColors [colors])
 (^{:tag void} setOffset [point offset])
 (^{:tag void} setOffsets [offsets]))
(definterface MGodotAudioEffectNotchFilter)
(definterface MGodotVisualScriptWhile)
(definterface
 MGodotSkin
 (^{:tag void} addBind [bone pose])
 (^{:tag void} clearBinds [])
 (^{:tag int} getBindBone [bind_index])
 (^{:tag int} getBindCount [])
 (^{:tag String} getBindName [bind_index])
 (^{:tag godotclj.bindings.godot.Transform} getBindPose [bind_index])
 (^{:tag void} setBindBone [bind_index bone])
 (^{:tag void} setBindCount [bind_count])
 (^{:tag void} setBindName [bind_index name])
 (^{:tag void} setBindPose [bind_index pose]))
(definterface
 MGodotWorld
 (^{:tag godotclj.api.gdscript.IGodotPhysicsDirectSpaceState}
  getDirectSpaceState
  [])
 (^{:tag godotclj.api.gdscript.IGodotEnvironment} getEnvironment [])
 (^{:tag godotclj.api.gdscript.IGodotEnvironment}
  getFallbackEnvironment
  [])
 (^{:tag godotclj.bindings.godot.RID} getScenario [])
 (^{:tag godotclj.bindings.godot.RID} getSpace [])
 (^{:tag void} setEnvironment [env])
 (^{:tag void} setFallbackEnvironment [env]))
(definterface
 MGodotSprite
 (^{:tag int} getFrame [])
 (^{:tag godotclj.bindings.godot.Vector2} getFrameCoords [])
 (^{:tag int} getHframes [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getNormalMap [])
 (^{:tag godotclj.bindings.godot.Vector2} getOffset [])
 (^{:tag godotclj.bindings.godot.IndexedRect2} getRect [])
 (^{:tag godotclj.bindings.godot.IndexedRect2} getRegionRect [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getTexture [])
 (^{:tag int} getVframes [])
 (^{:tag boolean} isCentered [])
 (^{:tag boolean} isFlippedH [])
 (^{:tag boolean} isFlippedV [])
 (^{:tag boolean} isPixelOpaque [pos])
 (^{:tag boolean} isRegion [])
 (^{:tag boolean} isRegionFilterClipEnabled [])
 (^{:tag void} setCentered [centered])
 (^{:tag void} setFlipH [flip_h])
 (^{:tag void} setFlipV [flip_v])
 (^{:tag void} setFrame [frame])
 (^{:tag void} setFrameCoords [coords])
 (^{:tag void} setHframes [hframes])
 (^{:tag void} setNormalMap [normal_map])
 (^{:tag void} setOffset [offset])
 (^{:tag void} setRegion [enabled])
 (^{:tag void} setRegionFilterClip [enabled])
 (^{:tag void} setRegionRect [rect])
 (^{:tag void} setTexture [texture])
 (^{:tag void} setVframes [vframes]))
(definterface
 MGodotPhysicsDirectSpaceState
 (^{:tag godotclj.bindings.godot.IndexedArray}
  castMotion
  [shape motion])
 (^{:tag godotclj.bindings.godot.IndexedArray} collideShape [shape])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  collideShape
  [shape max_results])
 (^{:tag godotclj.bindings.godot.Dictionary} getRestInfo [shape])
 (^{:tag godotclj.bindings.godot.Dictionary} intersectRay [from to])
 (^{:tag godotclj.bindings.godot.Dictionary}
  intersectRay
  [from to exclude])
 (^{:tag godotclj.bindings.godot.Dictionary}
  intersectRay
  [from to exclude collision_mask])
 (^{:tag godotclj.bindings.godot.Dictionary}
  intersectRay
  [from to exclude collision_mask collide_with_bodies])
 (^{:tag godotclj.bindings.godot.Dictionary}
  intersectRay
  [from
   to
   exclude
   collision_mask
   collide_with_bodies
   collide_with_areas])
 (^{:tag godotclj.bindings.godot.IndexedArray} intersectShape [shape])
 (^{:tag godotclj.bindings.godot.IndexedArray}
  intersectShape
  [shape max_results]))
(definterface
 MGodotWebSocketClient
 (^{:tag int} connectToUrl [url])
 (^{:tag int} connectToUrl [url protocols])
 (^{:tag int} connectToUrl [url protocols gd_mp_api])
 (^{:tag int} connectToUrl [url protocols gd_mp_api custom_headers])
 (^{:tag void} disconnectFromHost [])
 (^{:tag void} disconnectFromHost [code])
 (^{:tag void} disconnectFromHost [code reason])
 (^{:tag String} getConnectedHost [])
 (^{:tag int} getConnectedPort [])
 (^{:tag godotclj.api.gdscript.IGodotX509Certificate}
  getTrustedSslCertificate
  [])
 (^{:tag boolean} isVerifySslEnabled [])
 (^{:tag void} setTrustedSslCertificate [arg0])
 (^{:tag void} setVerifySslEnabled [enabled]))
(definterface
 MGodotEncodedObjectAsID
 (^{:tag int} getObjectId [])
 (^{:tag void} setObjectId [id]))
(definterface
 MGodotMeshLibrary
 (^{:tag void} clear [])
 (^{:tag void} createItem [id])
 (^{:tag int} findItemByName [name])
 (^{:tag godotclj.bindings.godot.PoolIntArray} getItemList [])
 (^{:tag godotclj.api.gdscript.IGodotMesh} getItemMesh [id])
 (^{:tag String} getItemName [id])
 (^{:tag godotclj.api.gdscript.IGodotNavigationMesh}
  getItemNavmesh
  [id])
 (^{:tag godotclj.bindings.godot.Transform}
  getItemNavmeshTransform
  [id])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getItemPreview [id])
 (^{:tag godotclj.bindings.godot.IndexedArray} getItemShapes [id])
 (^{:tag int} getLastUnusedItemId [])
 (^{:tag void} removeItem [id])
 (^{:tag void} setItemMesh [id mesh])
 (^{:tag void} setItemName [id name])
 (^{:tag void} setItemNavmesh [id navmesh])
 (^{:tag void} setItemNavmeshTransform [id navmesh])
 (^{:tag void} setItemPreview [id texture])
 (^{:tag void} setItemShapes [id shapes]))
(definterface
 MGodotPathFollow2D
 (^{:tag boolean} getCubicInterpolation [])
 (^{:tag float} getHOffset [])
 (^{:tag float} getLookahead [])
 (^{:tag float} getOffset [])
 (^{:tag float} getUnitOffset [])
 (^{:tag float} getVOffset [])
 (^{:tag boolean} hasLoop [])
 (^{:tag boolean} isRotating [])
 (^{:tag void} setCubicInterpolation [enable])
 (^{:tag void} setHOffset [h_offset])
 (^{:tag void} setLookahead [lookahead])
 (^{:tag void} setLoop [loop])
 (^{:tag void} setOffset [offset])
 (^{:tag void} setRotate [enable])
 (^{:tag void} setUnitOffset [unit_offset])
 (^{:tag void} setVOffset [v_offset]))
(definterface
 MGodotGrooveJoint2D
 (^{:tag float} getInitialOffset [])
 (^{:tag float} getLength [])
 (^{:tag void} setInitialOffset [offset])
 (^{:tag void} setLength [length]))
(definterface
 MGodotVisualShaderNodeUniformRef
 (^{:tag String} getUniformName [])
 (^{:tag void} setUniformName [name]))
(definterface
 MGodotGeneric6DOFJoint
 (^{:tag boolean} getFlagX [flag])
 (^{:tag boolean} getFlagY [flag])
 (^{:tag boolean} getFlagZ [flag])
 (^{:tag float} getParamX [param])
 (^{:tag float} getParamY [param])
 (^{:tag float} getParamZ [param])
 (^{:tag void} setFlagX [flag value])
 (^{:tag void} setFlagY [flag value])
 (^{:tag void} setFlagZ [flag value])
 (^{:tag void} setParamX [param value])
 (^{:tag void} setParamY [param value])
 (^{:tag void} setParamZ [param value]))
(definterface
 MGodotRemoteTransform
 (^{:tag void} forceUpdateCache [])
 (^{:tag godotclj.bindings.godot.NodePath} getRemoteNode [])
 (^{:tag boolean} getUpdatePosition [])
 (^{:tag boolean} getUpdateRotation [])
 (^{:tag boolean} getUpdateScale [])
 (^{:tag boolean} getUseGlobalCoordinates [])
 (^{:tag void} setRemoteNode [path])
 (^{:tag void} setUpdatePosition [update_remote_position])
 (^{:tag void} setUpdateRotation [update_remote_rotation])
 (^{:tag void} setUpdateScale [update_remote_scale])
 (^{:tag void} setUseGlobalCoordinates [use_global_coordinates]))
(definterface
 MGodotCapsuleShape2D
 (^{:tag float} getHeight [])
 (^{:tag float} getRadius [])
 (^{:tag void} setHeight [height])
 (^{:tag void} setRadius [radius]))
(definterface
 MGodot_Mutex
 (^{:tag void} lock [])
 (^{:tag int} tryLock [])
 (^{:tag void} unlock []))
(definterface
 MGodotEditorFileSystem
 (^{:tag String} getFileType [path])
 (^{:tag godotclj.api.gdscript.IGodotEditorFileSystemDirectory}
  getFilesystem
  [])
 (^{:tag godotclj.api.gdscript.IGodotEditorFileSystemDirectory}
  getFilesystemPath
  [path])
 (^{:tag float} getScanningProgress [])
 (^{:tag boolean} isScanning [])
 (^{:tag void} scan [])
 (^{:tag void} scanSources [])
 (^{:tag void} updateFile [path])
 (^{:tag void} updateScriptClasses []))
(definterface
 MGodotQuadMesh
 (^{:tag godotclj.bindings.godot.Vector2} getSize [])
 (^{:tag void} setSize [size]))
(definterface
 MGodotVisualShaderNodeTransformConstant
 (^{:tag godotclj.bindings.godot.Transform} getConstant [])
 (^{:tag void} setConstant [value]))
(definterface
 MGodotAnimationTreePlayer
 (^{:tag void} addNode [type id])
 (^{:tag void} advance [delta])
 (^{:tag godotclj.api.gdscript.IGodotAnimation}
  animationNodeGetAnimation
  [id])
 (^{:tag String} animationNodeGetMasterAnimation [id])
 (^{:tag float} animationNodeGetPosition [id])
 (^{:tag void} animationNodeSetAnimation [id animation])
 (^{:tag void} animationNodeSetFilterPath [id path enable])
 (^{:tag void} animationNodeSetMasterAnimation [id source])
 (^{:tag boolean} areNodesConnected [id dst_id dst_input_idx])
 (^{:tag float} blend2NodeGetAmount [id])
 (^{:tag void} blend2NodeSetAmount [id blend])
 (^{:tag void} blend2NodeSetFilterPath [id path enable])
 (^{:tag float} blend3NodeGetAmount [id])
 (^{:tag void} blend3NodeSetAmount [id blend])
 (^{:tag godotclj.bindings.godot.Vector2} blend4NodeGetAmount [id])
 (^{:tag void} blend4NodeSetAmount [id blend])
 (^{:tag int} connectNodes [id dst_id dst_input_idx])
 (^{:tag void} disconnectNodes [id dst_input_idx])
 (^{:tag int} getAnimationProcessMode [])
 (^{:tag godotclj.bindings.godot.NodePath} getBasePath [])
 (^{:tag godotclj.bindings.godot.NodePath} getMasterPlayer [])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  getNodeList
  [])
 (^{:tag boolean} isActive [])
 (^{:tag float} mixNodeGetAmount [id])
 (^{:tag void} mixNodeSetAmount [id ratio])
 (^{:tag boolean} nodeExists [node])
 (^{:tag int} nodeGetInputCount [id])
 (^{:tag String} nodeGetInputSource [id idx])
 (^{:tag godotclj.bindings.godot.Vector2} nodeGetPosition [id])
 (^{:tag int} nodeGetType [id])
 (^{:tag int} nodeRename [node new_name])
 (^{:tag void} nodeSetPosition [id screen_position])
 (^{:tag float} oneshotNodeGetAutorestartDelay [id])
 (^{:tag float} oneshotNodeGetAutorestartRandomDelay [id])
 (^{:tag float} oneshotNodeGetFadeinTime [id])
 (^{:tag float} oneshotNodeGetFadeoutTime [id])
 (^{:tag boolean} oneshotNodeHasAutorestart [id])
 (^{:tag boolean} oneshotNodeIsActive [id])
 (^{:tag void} oneshotNodeSetAutorestart [id enable])
 (^{:tag void} oneshotNodeSetAutorestartDelay [id delay_sec])
 (^{:tag void} oneshotNodeSetAutorestartRandomDelay [id rand_sec])
 (^{:tag void} oneshotNodeSetFadeinTime [id time_sec])
 (^{:tag void} oneshotNodeSetFadeoutTime [id time_sec])
 (^{:tag void} oneshotNodeSetFilterPath [id path enable])
 (^{:tag void} oneshotNodeStart [id])
 (^{:tag void} oneshotNodeStop [id])
 (^{:tag void} recomputeCaches [])
 (^{:tag void} removeNode [id])
 (^{:tag void} reset [])
 (^{:tag void} setActive [enabled])
 (^{:tag void} setAnimationProcessMode [mode])
 (^{:tag void} setBasePath [path])
 (^{:tag void} setMasterPlayer [nodepath])
 (^{:tag float} timescaleNodeGetScale [id])
 (^{:tag void} timescaleNodeSetScale [id scale])
 (^{:tag void} timeseekNodeSeek [id seconds])
 (^{:tag void} transitionNodeDeleteInput [id input_idx])
 (^{:tag int} transitionNodeGetCurrent [id])
 (^{:tag int} transitionNodeGetInputCount [id])
 (^{:tag float} transitionNodeGetXfadeTime [id])
 (^{:tag boolean} transitionNodeHasInputAutoAdvance [id input_idx])
 (^{:tag void} transitionNodeSetCurrent [id input_idx])
 (^{:tag void}
  transitionNodeSetInputAutoAdvance
  [id input_idx enable])
 (^{:tag void} transitionNodeSetInputCount [id count])
 (^{:tag void} transitionNodeSetXfadeTime [id time_sec]))
(definterface
 MGodotParticles
 (^{:tag godotclj.bindings.godot.AABB} captureAabb [])
 (^{:tag int} getAmount [])
 (^{:tag int} getDrawOrder [])
 (^{:tag godotclj.api.gdscript.IGodotMesh} getDrawPassMesh [pass])
 (^{:tag int} getDrawPasses [])
 (^{:tag float} getExplosivenessRatio [])
 (^{:tag int} getFixedFps [])
 (^{:tag boolean} getFractionalDelta [])
 (^{:tag float} getLifetime [])
 (^{:tag boolean} getOneShot [])
 (^{:tag float} getPreProcessTime [])
 (^{:tag godotclj.api.gdscript.IGodotMaterial} getProcessMaterial [])
 (^{:tag float} getRandomnessRatio [])
 (^{:tag float} getSpeedScale [])
 (^{:tag boolean} getUseLocalCoordinates [])
 (^{:tag godotclj.bindings.godot.AABB} getVisibilityAabb [])
 (^{:tag boolean} isEmitting [])
 (^{:tag void} restart [])
 (^{:tag void} setAmount [amount])
 (^{:tag void} setDrawOrder [order])
 (^{:tag void} setDrawPassMesh [pass mesh])
 (^{:tag void} setDrawPasses [passes])
 (^{:tag void} setEmitting [emitting])
 (^{:tag void} setExplosivenessRatio [ratio])
 (^{:tag void} setFixedFps [fps])
 (^{:tag void} setFractionalDelta [enable])
 (^{:tag void} setLifetime [secs])
 (^{:tag void} setOneShot [enable])
 (^{:tag void} setPreProcessTime [secs])
 (^{:tag void} setProcessMaterial [material])
 (^{:tag void} setRandomnessRatio [ratio])
 (^{:tag void} setSpeedScale [scale])
 (^{:tag void} setUseLocalCoordinates [enable])
 (^{:tag void} setVisibilityAabb [aabb]))
(definterface
 MGodotMeshInstance2D
 (^{:tag godotclj.api.gdscript.IGodotMesh} getMesh [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getNormalMap [])
 (^{:tag godotclj.api.gdscript.IGodotTexture} getTexture [])
 (^{:tag void} setMesh [mesh])
 (^{:tag void} setNormalMap [normal_map])
 (^{:tag void} setTexture [texture]))
(definterface
 MGodotVisualScriptReturn
 (^{:tag int} getReturnType [])
 (^{:tag boolean} isReturnValueEnabled [])
 (^{:tag void} setEnableReturnValue [enable])
 (^{:tag void} setReturnType [type]))
(definterface
 MGodotPacketPeerDTLS
 (^{:tag int} connectToPeer [packet_peer])
 (^{:tag int} connectToPeer [packet_peer validate_certs])
 (^{:tag int} connectToPeer [packet_peer validate_certs for_hostname])
 (^{:tag int}
  connectToPeer
  [packet_peer validate_certs for_hostname valid_certificate])
 (^{:tag void} disconnectFromPeer [])
 (^{:tag int} getStatus [])
 (^{:tag void} poll []))
(definterface MGodotBulletPhysicsServer)
(definterface
 MGodotVisualScriptPreload
 (^{:tag godotclj.api.gdscript.IGodotResource} getPreload [])
 (^{:tag void} setPreload [resource]))
(definterface
 MGodotPinJoint2D
 (^{:tag float} getSoftness [])
 (^{:tag void} setSoftness [softness]))
(definterface
 MGodotCapsuleShape
 (^{:tag float} getHeight [])
 (^{:tag float} getRadius [])
 (^{:tag void} setHeight [height])
 (^{:tag void} setRadius [radius]))
(definterface MGodotTriangleMesh)
(definterface
 MGodotAudioStreamSample
 (^{:tag godotclj.bindings.godot.PoolByteArray} getData [])
 (^{:tag int} getFormat [])
 (^{:tag int} getLoopBegin [])
 (^{:tag int} getLoopEnd [])
 (^{:tag int} getLoopMode [])
 (^{:tag int} getMixRate [])
 (^{:tag boolean} isStereo [])
 (^{:tag int} saveToWav [path])
 (^{:tag void} setData [data])
 (^{:tag void} setFormat [format])
 (^{:tag void} setLoopBegin [loop_begin])
 (^{:tag void} setLoopEnd [loop_end])
 (^{:tag void} setLoopMode [loop_mode])
 (^{:tag void} setMixRate [mix_rate])
 (^{:tag void} setStereo [stereo]))
(definterface
 MGodotPackedDataContainer
 (^{:tag int} pack [value])
 (^{:tag int} size []))
(definterface
 MGodotSceneTreeTimer
 (^{:tag float} getTimeLeft [])
 (^{:tag void} setTimeLeft [time]))
(definterface
 MGodotCameraTexture
 (^{:tag boolean} getCameraActive [])
 (^{:tag int} getCameraFeedId [])
 (^{:tag int} getWhichFeed [])
 (^{:tag void} setCameraActive [active])
 (^{:tag void} setCameraFeedId [feed_id])
 (^{:tag void} setWhichFeed [which_feed]))
(definterface MGodotVisualShaderNodeScalarSmoothStep)
(definterface
 MGodotSceneState
 (^{:tag godotclj.bindings.godot.IndexedArray}
  getConnectionBinds
  [idx])
 (^{:tag int} getConnectionCount [])
 (^{:tag int} getConnectionFlags [idx])
 (^{:tag String} getConnectionMethod [idx])
 (^{:tag String} getConnectionSignal [idx])
 (^{:tag godotclj.bindings.godot.NodePath} getConnectionSource [idx])
 (^{:tag godotclj.bindings.godot.NodePath} getConnectionTarget [idx])
 (^{:tag int} getNodeCount [])
 (^{:tag godotclj.bindings.godot.IndexedPoolStringArray}
  getNodeGroups
  [idx])
 (^{:tag int} getNodeIndex [idx])
 (^{:tag godotclj.api.gdscript.IGodotPackedScene}
  getNodeInstance
  [idx])
 (^{:tag String} getNodeInstancePlaceholder [idx])
 (^{:tag String} getNodeName [idx])
 (^{:tag godotclj.bindings.godot.NodePath} getNodeOwnerPath [idx])
 (^{:tag godotclj.bindings.godot.NodePath} getNodePath [idx])
 (^{:tag godotclj.bindings.godot.NodePath}
  getNodePath
  [idx for_parent])
 (^{:tag int} getNodePropertyCount [idx])
 (^{:tag String} getNodePropertyName [idx prop_idx])
 (^{:tag godotclj.bindings.godot.Variant}
  getNodePropertyValue
  [idx prop_idx])
 (^{:tag String} getNodeType [idx])
 (^{:tag boolean} isNodeInstancePlaceholder [idx]))
(definterface
 MGodotPolygonPathFinder
 (^{:tag godotclj.bindings.godot.IndexedPoolVector2Array}
  findPath
  [from to])
 (^{:tag godotclj.bindings.godot.IndexedRect2} getBounds [])
 (^{:tag godotclj.bindings.godot.Vector2} getClosestPoint [point])
 (^{:tag godotclj.bindings.godot.IndexedPoolVector2Array}
  getIntersections
  [from to])
 (^{:tag float} getPointPenalty [idx])
 (^{:tag boolean} isPointInside [point])
 (^{:tag void} setPointPenalty [idx penalty])
 (^{:tag void} setup [points connections]))
(definterface
 MGodotRayShape2D
 (^{:tag float} getLength [])
 (^{:tag boolean} getSlipsOnSlope [])
 (^{:tag void} setLength [length])
 (^{:tag void} setSlipsOnSlope [active]))
(definterface
 MGodotGDNative
 (^{:tag godotclj.bindings.godot.Variant}
  callNative
  [calling_type procedure_name arguments])
 (^{:tag godotclj.api.gdscript.IGodotGDNativeLibrary} getLibrary [])
 (^{:tag boolean} initialize [])
 (^{:tag void} setLibrary [library])
 (^{:tag boolean} terminate []))
(definterface MGodotARVRCamera)
(definterface
 MGodotCenterContainer
 (^{:tag boolean} isUsingTopLeft [])
 (^{:tag void} setUseTopLeft [enable]))
(definterface MGodotPosition2D)
(definterface
 MGodotColorPickerButton
 (^{:tag godotclj.bindings.godot.Color} getPickColor [])
 (^{:tag godotclj.api.gdscript.IGodotColorPicker} getPicker [])
 (^{:tag godotclj.api.gdscript.IGodotPopupPanel} getPopup [])
 (^{:tag boolean} isEditingAlpha [])
 (^{:tag void} setEditAlpha [show])
 (^{:tag void} setPickColor [color]))
(definterface
 MGodotCanvasItemMaterial
 (^{:tag int} getBlendMode [])
 (^{:tag int} getLightMode [])
 (^{:tag int} getParticlesAnimHFrames [])
 (^{:tag boolean} getParticlesAnimLoop [])
 (^{:tag int} getParticlesAnimVFrames [])
 (^{:tag boolean} getParticlesAnimation [])
 (^{:tag void} setBlendMode [blend_mode])
 (^{:tag void} setLightMode [light_mode])
 (^{:tag void} setParticlesAnimHFrames [frames])
 (^{:tag void} setParticlesAnimLoop [loop])
 (^{:tag void} setParticlesAnimVFrames [frames])
 (^{:tag void} setParticlesAnimation [particles_anim]))
(gen-interface
 :name
 godotclj.api.gdscript.IGodotObject
 :extends
 [godotclj.api.gdscript.MGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotEditorNavigationMeshGenerator
 :extends
 [godotclj.api.gdscript.MGodotEditorNavigationMeshGenerator
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotReference
 :extends
 [godotclj.api.gdscript.MGodotReference
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotResource
 :extends
 [godotclj.api.gdscript.MGodotResource
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNode
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNode
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeVectorScalarMix
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeVectorScalarMix
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotNode
 :extends
 [godotclj.api.gdscript.MGodotNode godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCanvasItem
 :extends
 [godotclj.api.gdscript.MGodotCanvasItem
  godotclj.api.gdscript.IGodotNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotControl
 :extends
 [godotclj.api.gdscript.MGodotControl
  godotclj.api.gdscript.IGodotCanvasItem])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPopup
 :extends
 [godotclj.api.gdscript.MGodotPopup
  godotclj.api.gdscript.IGodotControl])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotWindowDialog
 :extends
 [godotclj.api.gdscript.MGodotWindowDialog
  godotclj.api.gdscript.IGodotPopup])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAcceptDialog
 :extends
 [godotclj.api.gdscript.MGodotAcceptDialog
  godotclj.api.gdscript.IGodotWindowDialog])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotConfirmationDialog
 :extends
 [godotclj.api.gdscript.MGodotConfirmationDialog
  godotclj.api.gdscript.IGodotAcceptDialog])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotTween
 :extends
 [godotclj.api.gdscript.MGodotTween godotclj.api.gdscript.IGodotNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotXMLParser
 :extends
 [godotclj.api.gdscript.MGodotXMLParser
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotSpatial
 :extends
 [godotclj.api.gdscript.MGodotSpatial
  godotclj.api.gdscript.IGodotNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotSkeleton
 :extends
 [godotclj.api.gdscript.MGodotSkeleton
  godotclj.api.gdscript.IGodotSpatial])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotInputEvent
 :extends
 [godotclj.api.gdscript.MGodotInputEvent
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotInputEventJoypadButton
 :extends
 [godotclj.api.gdscript.MGodotInputEventJoypadButton
  godotclj.api.gdscript.IGodotInputEvent])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPopupMenu
 :extends
 [godotclj.api.gdscript.MGodotPopupMenu
  godotclj.api.gdscript.IGodotPopup])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotConfigFile
 :extends
 [godotclj.api.gdscript.MGodotConfigFile
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeTransformDecompose
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeTransformDecompose
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotContainer
 :extends
 [godotclj.api.gdscript.MGodotContainer
  godotclj.api.gdscript.IGodotControl])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotBoxContainer
 :extends
 [godotclj.api.gdscript.MGodotBoxContainer
  godotclj.api.gdscript.IGodotContainer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotHBoxContainer
 :extends
 [godotclj.api.gdscript.MGodotHBoxContainer
  godotclj.api.gdscript.IGodotBoxContainer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotNode2D
 :extends
 [godotclj.api.gdscript.MGodotNode2D
  godotclj.api.gdscript.IGodotCanvasItem])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotMultiMeshInstance2D
 :extends
 [godotclj.api.gdscript.MGodotMultiMeshInstance2D
  godotclj.api.gdscript.IGodotNode2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotUDPServer
 :extends
 [godotclj.api.gdscript.MGodotUDPServer
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisibilityNotifier
 :extends
 [godotclj.api.gdscript.MGodotVisibilityNotifier
  godotclj.api.gdscript.IGodotSpatial])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCurve3D
 :extends
 [godotclj.api.gdscript.MGodotCurve3D
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCPUParticles2D
 :extends
 [godotclj.api.gdscript.MGodotCPUParticles2D
  godotclj.api.gdscript.IGodotNode2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualInstance
 :extends
 [godotclj.api.gdscript.MGodotVisualInstance
  godotclj.api.gdscript.IGodotSpatial])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotRootMotionView
 :extends
 [godotclj.api.gdscript.MGodotRootMotionView
  godotclj.api.gdscript.IGodotVisualInstance])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptNode
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptNode
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptVariableGet
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptVariableGet
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotMesh
 :extends
 [godotclj.api.gdscript.MGodotMesh
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPrimitiveMesh
 :extends
 [godotclj.api.gdscript.MGodotPrimitiveMesh
  godotclj.api.gdscript.IGodotMesh])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCapsuleMesh
 :extends
 [godotclj.api.gdscript.MGodotCapsuleMesh
  godotclj.api.gdscript.IGodotPrimitiveMesh])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotARVRPositionalTracker
 :extends
 [godotclj.api.gdscript.MGodotARVRPositionalTracker
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotShape
 :extends
 [godotclj.api.gdscript.MGodotShape
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotConvexPolygonShape
 :extends
 [godotclj.api.gdscript.MGodotConvexPolygonShape
  godotclj.api.gdscript.IGodotShape])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotInputEventWithModifiers
 :extends
 [godotclj.api.gdscript.MGodotInputEventWithModifiers
  godotclj.api.gdscript.IGodotInputEvent])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotInputEventGesture
 :extends
 [godotclj.api.gdscript.MGodotInputEventGesture
  godotclj.api.gdscript.IGodotInputEventWithModifiers])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptConstant
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptConstant
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodot_Semaphore
 :extends
 [godotclj.api.gdscript.MGodot_Semaphore
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotLight
 :extends
 [godotclj.api.gdscript.MGodotLight
  godotclj.api.gdscript.IGodotVisualInstance])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotOmniLight
 :extends
 [godotclj.api.gdscript.MGodotOmniLight
  godotclj.api.gdscript.IGodotLight])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAnimation
 :extends
 [godotclj.api.gdscript.MGodotAnimation
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotHTTPClient
 :extends
 [godotclj.api.gdscript.MGodotHTTPClient
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAnimationNode
 :extends
 [godotclj.api.gdscript.MGodotAnimationNode
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAnimationRootNode
 :extends
 [godotclj.api.gdscript.MGodotAnimationRootNode
  godotclj.api.gdscript.IGodotAnimationNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAnimationNodeBlendTree
 :extends
 [godotclj.api.gdscript.MGodotAnimationNodeBlendTree
  godotclj.api.gdscript.IGodotAnimationRootNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodot_File
 :extends
 [godotclj.api.gdscript.MGodot_File
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptResourcePath
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptResourcePath
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotEditorFeatureProfile
 :extends
 [godotclj.api.gdscript.MGodotEditorFeatureProfile
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptLocalVarSet
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptLocalVarSet
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodot_JSON
 :extends
 [godotclj.api.gdscript.MGodot_JSON
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotHTTPRequest
 :extends
 [godotclj.api.gdscript.MGodotHTTPRequest
  godotclj.api.gdscript.IGodotNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotNavigationPolygonInstance
 :extends
 [godotclj.api.gdscript.MGodotNavigationPolygonInstance
  godotclj.api.gdscript.IGodotNode2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodot_Marshalls
 :extends
 [godotclj.api.gdscript.MGodot_Marshalls
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVideoStream
 :extends
 [godotclj.api.gdscript.MGodotVideoStream
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVideoStreamGDNative
 :extends
 [godotclj.api.gdscript.MGodotVideoStreamGDNative
  godotclj.api.gdscript.IGodotVideoStream])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotTexture
 :extends
 [godotclj.api.gdscript.MGodotTexture
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotNoiseTexture
 :extends
 [godotclj.api.gdscript.MGodotNoiseTexture
  godotclj.api.gdscript.IGodotTexture])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCollisionObject
 :extends
 [godotclj.api.gdscript.MGodotCollisionObject
  godotclj.api.gdscript.IGodotSpatial])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotArea
 :extends
 [godotclj.api.gdscript.MGodotArea
  godotclj.api.gdscript.IGodotCollisionObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotRange
 :extends
 [godotclj.api.gdscript.MGodotRange
  godotclj.api.gdscript.IGodotControl])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotScrollBar
 :extends
 [godotclj.api.gdscript.MGodotScrollBar
  godotclj.api.gdscript.IGodotRange])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVScrollBar
 :extends
 [godotclj.api.gdscript.MGodotVScrollBar
  godotclj.api.gdscript.IGodotScrollBar])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotSky
 :extends
 [godotclj.api.gdscript.MGodotSky
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPanoramaSky
 :extends
 [godotclj.api.gdscript.MGodotPanoramaSky
  godotclj.api.gdscript.IGodotSky])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotFuncRef
 :extends
 [godotclj.api.gdscript.MGodotFuncRef
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotBaseButton
 :extends
 [godotclj.api.gdscript.MGodotBaseButton
  godotclj.api.gdscript.IGodotControl])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotButton
 :extends
 [godotclj.api.gdscript.MGodotButton
  godotclj.api.gdscript.IGodotBaseButton])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotOptionButton
 :extends
 [godotclj.api.gdscript.MGodotOptionButton
  godotclj.api.gdscript.IGodotButton])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotToolButton
 :extends
 [godotclj.api.gdscript.MGodotToolButton
  godotclj.api.gdscript.IGodotButton])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPhysicsBody
 :extends
 [godotclj.api.gdscript.MGodotPhysicsBody
  godotclj.api.gdscript.IGodotCollisionObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPhysicalBone
 :extends
 [godotclj.api.gdscript.MGodotPhysicalBone
  godotclj.api.gdscript.IGodotPhysicsBody])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAnimationNodeStateMachineTransition
 :extends
 [godotclj.api.gdscript.MGodotAnimationNodeStateMachineTransition
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotLine2D
 :extends
 [godotclj.api.gdscript.MGodotLine2D
  godotclj.api.gdscript.IGodotNode2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodot_ResourceSaver
 :extends
 [godotclj.api.gdscript.MGodot_ResourceSaver
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotInputEventMIDI
 :extends
 [godotclj.api.gdscript.MGodotInputEventMIDI
  godotclj.api.gdscript.IGodotInputEvent])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotARVRInterface
 :extends
 [godotclj.api.gdscript.MGodotARVRInterface
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotMobileVRInterface
 :extends
 [godotclj.api.gdscript.MGodotMobileVRInterface
  godotclj.api.gdscript.IGodotARVRInterface])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotRayShape
 :extends
 [godotclj.api.gdscript.MGodotRayShape
  godotclj.api.gdscript.IGodotShape])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioEffect
 :extends
 [godotclj.api.gdscript.MGodotAudioEffect
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioEffectDelay
 :extends
 [godotclj.api.gdscript.MGodotAudioEffectDelay
  godotclj.api.gdscript.IGodotAudioEffect])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAnimationNodeAdd3
 :extends
 [godotclj.api.gdscript.MGodotAnimationNodeAdd3
  godotclj.api.gdscript.IGodotAnimationNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioEffectFilter
 :extends
 [godotclj.api.gdscript.MGodotAudioEffectFilter
  godotclj.api.gdscript.IGodotAudioEffect])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioEffectHighShelfFilter
 :extends
 [godotclj.api.gdscript.MGodotAudioEffectHighShelfFilter
  godotclj.api.gdscript.IGodotAudioEffectFilter])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioEffectCapture
 :extends
 [godotclj.api.gdscript.MGodotAudioEffectCapture
  godotclj.api.gdscript.IGodotAudioEffect])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPanel
 :extends
 [godotclj.api.gdscript.MGodotPanel
  godotclj.api.gdscript.IGodotControl])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptCondition
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptCondition
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPolygon2D
 :extends
 [godotclj.api.gdscript.MGodotPolygon2D
  godotclj.api.gdscript.IGodotNode2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotSkinReference
 :extends
 [godotclj.api.gdscript.MGodotSkinReference
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPacketPeer
 :extends
 [godotclj.api.gdscript.MGodotPacketPeer
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotNetworkedMultiplayerPeer
 :extends
 [godotclj.api.gdscript.MGodotNetworkedMultiplayerPeer
  godotclj.api.gdscript.IGodotPacketPeer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotWebRTCMultiplayer
 :extends
 [godotclj.api.gdscript.MGodotWebRTCMultiplayer
  godotclj.api.gdscript.IGodotNetworkedMultiplayerPeer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeIs
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeIs
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptGlobalConstant
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptGlobalConstant
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPhysics2DShapeQueryParameters
 :extends
 [godotclj.api.gdscript.MGodotPhysics2DShapeQueryParameters
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotDTLSServer
 :extends
 [godotclj.api.gdscript.MGodotDTLSServer
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCylinderShape
 :extends
 [godotclj.api.gdscript.MGodotCylinderShape
  godotclj.api.gdscript.IGodotShape])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptConstructor
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptConstructor
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptClassConstant
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptClassConstant
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPath2D
 :extends
 [godotclj.api.gdscript.MGodotPath2D
  godotclj.api.gdscript.IGodotNode2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCollisionPolygon
 :extends
 [godotclj.api.gdscript.MGodotCollisionPolygon
  godotclj.api.gdscript.IGodotSpatial])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotGridMap
 :extends
 [godotclj.api.gdscript.MGodotGridMap
  godotclj.api.gdscript.IGodotSpatial])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotX509Certificate
 :extends
 [godotclj.api.gdscript.MGodotX509Certificate
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPhysics2DServer
 :extends
 [godotclj.api.gdscript.MGodotPhysics2DServer
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPhysics2DServerSW
 :extends
 [godotclj.api.gdscript.MGodotPhysics2DServerSW
  godotclj.api.gdscript.IGodotPhysics2DServer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPacketPeerStream
 :extends
 [godotclj.api.gdscript.MGodotPacketPeerStream
  godotclj.api.gdscript.IGodotPacketPeer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodot_ResourceLoader
 :extends
 [godotclj.api.gdscript.MGodot_ResourceLoader
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotBone2D
 :extends
 [godotclj.api.gdscript.MGodotBone2D
  godotclj.api.gdscript.IGodotNode2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotRigidBody
 :extends
 [godotclj.api.gdscript.MGodotRigidBody
  godotclj.api.gdscript.IGodotPhysicsBody])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPlaneMesh
 :extends
 [godotclj.api.gdscript.MGodotPlaneMesh
  godotclj.api.gdscript.IGodotPrimitiveMesh])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotMultiplayerPeerGDNative
 :extends
 [godotclj.api.gdscript.MGodotMultiplayerPeerGDNative
  godotclj.api.gdscript.IGodotNetworkedMultiplayerPeer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCollisionObject2D
 :extends
 [godotclj.api.gdscript.MGodotCollisionObject2D
  godotclj.api.gdscript.IGodotNode2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotSurfaceTool
 :extends
 [godotclj.api.gdscript.MGodotSurfaceTool
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotIP
 :extends
 [godotclj.api.gdscript.MGodotIP godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotIP_Unix
 :extends
 [godotclj.api.gdscript.MGodotIP_Unix godotclj.api.gdscript.IGodotIP])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCamera
 :extends
 [godotclj.api.gdscript.MGodotCamera
  godotclj.api.gdscript.IGodotSpatial])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotClippedCamera
 :extends
 [godotclj.api.gdscript.MGodotClippedCamera
  godotclj.api.gdscript.IGodotCamera])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioEffectLimiter
 :extends
 [godotclj.api.gdscript.MGodotAudioEffectLimiter
  godotclj.api.gdscript.IGodotAudioEffect])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCurveTexture
 :extends
 [godotclj.api.gdscript.MGodotCurveTexture
  godotclj.api.gdscript.IGodotTexture])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotEditorInterface
 :extends
 [godotclj.api.gdscript.MGodotEditorInterface
  godotclj.api.gdscript.IGodotNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeUniform
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeUniform
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeTextureUniform
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeTextureUniform
  godotclj.api.gdscript.IGodotVisualShaderNodeUniform])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeScalarUniform
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeScalarUniform
  godotclj.api.gdscript.IGodotVisualShaderNodeUniform])
(gen-interface
 :name
 godotclj.api.gdscript.IGodot_Directory
 :extends
 [godotclj.api.gdscript.MGodot_Directory
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAnimationNodeAnimation
 :extends
 [godotclj.api.gdscript.MGodotAnimationNodeAnimation
  godotclj.api.gdscript.IGodotAnimationRootNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptFunction
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptFunction
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotMaterial
 :extends
 [godotclj.api.gdscript.MGodotMaterial
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotParticlesMaterial
 :extends
 [godotclj.api.gdscript.MGodotParticlesMaterial
  godotclj.api.gdscript.IGodotMaterial])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotRichTextEffect
 :extends
 [godotclj.api.gdscript.MGodotRichTextEffect
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptSelf
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptSelf
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVehicleBody
 :extends
 [godotclj.api.gdscript.MGodotVehicleBody
  godotclj.api.gdscript.IGodotRigidBody])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeScalarOp
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeScalarOp
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotViewport
 :extends
 [godotclj.api.gdscript.MGodotViewport
  godotclj.api.gdscript.IGodotNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioEffectAmplify
 :extends
 [godotclj.api.gdscript.MGodotAudioEffectAmplify
  godotclj.api.gdscript.IGodotAudioEffect])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotImage
 :extends
 [godotclj.api.gdscript.MGodotImage
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotLineEdit
 :extends
 [godotclj.api.gdscript.MGodotLineEdit
  godotclj.api.gdscript.IGodotControl])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotShaderMaterial
 :extends
 [godotclj.api.gdscript.MGodotShaderMaterial
  godotclj.api.gdscript.IGodotMaterial])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeOuterProduct
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeOuterProduct
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotSlider
 :extends
 [godotclj.api.gdscript.MGodotSlider
  godotclj.api.gdscript.IGodotRange])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotHSlider
 :extends
 [godotclj.api.gdscript.MGodotHSlider
  godotclj.api.gdscript.IGodotSlider])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAnimationNodeBlendSpace1D
 :extends
 [godotclj.api.gdscript.MGodotAnimationNodeBlendSpace1D
  godotclj.api.gdscript.IGodotAnimationRootNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptBasicTypeConstant
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptBasicTypeConstant
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeFresnel
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeFresnel
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotProgressBar
 :extends
 [godotclj.api.gdscript.MGodotProgressBar
  godotclj.api.gdscript.IGodotRange])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioStream
 :extends
 [godotclj.api.gdscript.MGodotAudioStream
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioStreamGenerator
 :extends
 [godotclj.api.gdscript.MGodotAudioStreamGenerator
  godotclj.api.gdscript.IGodotAudioStream])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotBakedLightmap
 :extends
 [godotclj.api.gdscript.MGodotBakedLightmap
  godotclj.api.gdscript.IGodotVisualInstance])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptSceneTree
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptSceneTree
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotARVROrigin
 :extends
 [godotclj.api.gdscript.MGodotARVROrigin
  godotclj.api.gdscript.IGodotSpatial])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioEffectEQ
 :extends
 [godotclj.api.gdscript.MGodotAudioEffectEQ
  godotclj.api.gdscript.IGodotAudioEffect])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioEffectEQ21
 :extends
 [godotclj.api.gdscript.MGodotAudioEffectEQ21
  godotclj.api.gdscript.IGodotAudioEffectEQ])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotSplitContainer
 :extends
 [godotclj.api.gdscript.MGodotSplitContainer
  godotclj.api.gdscript.IGodotContainer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotHSplitContainer
 :extends
 [godotclj.api.gdscript.MGodotHSplitContainer
  godotclj.api.gdscript.IGodotSplitContainer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeTransformFunc
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeTransformFunc
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeScalarInterp
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeScalarInterp
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotEditorResourceConversionPlugin
 :extends
 [godotclj.api.gdscript.MGodotEditorResourceConversionPlugin
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAnimationNodeOneShot
 :extends
 [godotclj.api.gdscript.MGodotAnimationNodeOneShot
  godotclj.api.gdscript.IGodotAnimationNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotTranslation
 :extends
 [godotclj.api.gdscript.MGodotTranslation
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPHashTranslation
 :extends
 [godotclj.api.gdscript.MGodotPHashTranslation
  godotclj.api.gdscript.IGodotTranslation])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotHScrollBar
 :extends
 [godotclj.api.gdscript.MGodotHScrollBar
  godotclj.api.gdscript.IGodotScrollBar])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeOutput
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeOutput
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotWebXRInterface
 :extends
 [godotclj.api.gdscript.MGodotWebXRInterface
  godotclj.api.gdscript.IGodotARVRInterface])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotSphereShape
 :extends
 [godotclj.api.gdscript.MGodotSphereShape
  godotclj.api.gdscript.IGodotShape])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPopupDialog
 :extends
 [godotclj.api.gdscript.MGodotPopupDialog
  godotclj.api.gdscript.IGodotPopup])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotUPNPDevice
 :extends
 [godotclj.api.gdscript.MGodotUPNPDevice
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeDeterminant
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeDeterminant
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotStreamTexture
 :extends
 [godotclj.api.gdscript.MGodotStreamTexture
  godotclj.api.gdscript.IGodotTexture])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotDynamicFontData
 :extends
 [godotclj.api.gdscript.MGodotDynamicFontData
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeVectorFunc
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeVectorFunc
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotBoneAttachment
 :extends
 [godotclj.api.gdscript.MGodotBoneAttachment
  godotclj.api.gdscript.IGodotSpatial])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotTree
 :extends
 [godotclj.api.gdscript.MGodotTree
  godotclj.api.gdscript.IGodotControl])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPhysicsBody2D
 :extends
 [godotclj.api.gdscript.MGodotPhysicsBody2D
  godotclj.api.gdscript.IGodotCollisionObject2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotInputEventScreenDrag
 :extends
 [godotclj.api.gdscript.MGodotInputEventScreenDrag
  godotclj.api.gdscript.IGodotInputEvent])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotButtonGroup
 :extends
 [godotclj.api.gdscript.MGodotButtonGroup
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioEffectRecord
 :extends
 [godotclj.api.gdscript.MGodotAudioEffectRecord
  godotclj.api.gdscript.IGodotAudioEffect])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCrypto
 :extends
 [godotclj.api.gdscript.MGodotCrypto
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotGeometryInstance
 :extends
 [godotclj.api.gdscript.MGodotGeometryInstance
  godotclj.api.gdscript.IGodotVisualInstance])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCSGShape
 :extends
 [godotclj.api.gdscript.MGodotCSGShape
  godotclj.api.gdscript.IGodotGeometryInstance])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCSGPrimitive
 :extends
 [godotclj.api.gdscript.MGodotCSGPrimitive
  godotclj.api.gdscript.IGodotCSGShape])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCSGCylinder
 :extends
 [godotclj.api.gdscript.MGodotCSGCylinder
  godotclj.api.gdscript.IGodotCSGPrimitive])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotExternalTexture
 :extends
 [godotclj.api.gdscript.MGodotExternalTexture
  godotclj.api.gdscript.IGodotTexture])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptLists
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptLists
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotJSONParseResult
 :extends
 [godotclj.api.gdscript.MGodotJSONParseResult
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPhysicsServer
 :extends
 [godotclj.api.gdscript.MGodotPhysicsServer
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotTextEdit
 :extends
 [godotclj.api.gdscript.MGodotTextEdit
  godotclj.api.gdscript.IGodotControl])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeVectorDistance
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeVectorDistance
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotScript
 :extends
 [godotclj.api.gdscript.MGodotScript
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotNativeScript
 :extends
 [godotclj.api.gdscript.MGodotNativeScript
  godotclj.api.gdscript.IGodotScript])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotGDScriptFunctionState
 :extends
 [godotclj.api.gdscript.MGodotGDScriptFunctionState
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptComment
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptComment
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotJoint
 :extends
 [godotclj.api.gdscript.MGodotJoint
  godotclj.api.gdscript.IGodotSpatial])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotHingeJoint
 :extends
 [godotclj.api.gdscript.MGodotHingeJoint
  godotclj.api.gdscript.IGodotJoint])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotConcavePolygonShape
 :extends
 [godotclj.api.gdscript.MGodotConcavePolygonShape
  godotclj.api.gdscript.IGodotShape])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotTextureLayered
 :extends
 [godotclj.api.gdscript.MGodotTextureLayered
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotTexture3D
 :extends
 [godotclj.api.gdscript.MGodotTexture3D
  godotclj.api.gdscript.IGodotTextureLayered])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotSpatialMaterial
 :extends
 [godotclj.api.gdscript.MGodotSpatialMaterial
  godotclj.api.gdscript.IGodotMaterial])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotViewportTexture
 :extends
 [godotclj.api.gdscript.MGodotViewportTexture
  godotclj.api.gdscript.IGodotTexture])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAnimationPlayer
 :extends
 [godotclj.api.gdscript.MGodotAnimationPlayer
  godotclj.api.gdscript.IGodotNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotEditorResourcePreview
 :extends
 [godotclj.api.gdscript.MGodotEditorResourcePreview
  godotclj.api.gdscript.IGodotNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeBooleanConstant
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeBooleanConstant
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotResourceInteractiveLoader
 :extends
 [godotclj.api.gdscript.MGodotResourceInteractiveLoader
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptFunctionCall
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptFunctionCall
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotGIProbe
 :extends
 [godotclj.api.gdscript.MGodotGIProbe
  godotclj.api.gdscript.IGodotVisualInstance])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotStreamPeer
 :extends
 [godotclj.api.gdscript.MGodotStreamPeer
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotStreamPeerGDNative
 :extends
 [godotclj.api.gdscript.MGodotStreamPeerGDNative
  godotclj.api.gdscript.IGodotStreamPeer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptComposeArray
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptComposeArray
  godotclj.api.gdscript.IGodotVisualScriptLists])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAnimationNodeBlendSpace2D
 :extends
 [godotclj.api.gdscript.MGodotAnimationNodeBlendSpace2D
  godotclj.api.gdscript.IGodotAnimationRootNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotArea2D
 :extends
 [godotclj.api.gdscript.MGodotArea2D
  godotclj.api.gdscript.IGodotCollisionObject2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptOperator
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptOperator
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotKinematicBody
 :extends
 [godotclj.api.gdscript.MGodotKinematicBody
  godotclj.api.gdscript.IGodotPhysicsBody])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeGroupBase
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeGroupBase
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeExpression
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeExpression
  godotclj.api.gdscript.IGodotVisualShaderNodeGroupBase])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeGlobalExpression
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeGlobalExpression
  godotclj.api.gdscript.IGodotVisualShaderNodeExpression])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPhysicsDirectBodyState
 :extends
 [godotclj.api.gdscript.MGodotPhysicsDirectBodyState
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotRichTextLabel
 :extends
 [godotclj.api.gdscript.MGodotRichTextLabel
  godotclj.api.gdscript.IGodotControl])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotRigidBody2D
 :extends
 [godotclj.api.gdscript.MGodotRigidBody2D
  godotclj.api.gdscript.IGodotPhysicsBody2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotJSONRPC
 :extends
 [godotclj.api.gdscript.MGodotJSONRPC
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotOpenSimplexNoise
 :extends
 [godotclj.api.gdscript.MGodotOpenSimplexNoise
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeCustom
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeCustom
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAnimationNodeOutput
 :extends
 [godotclj.api.gdscript.MGodotAnimationNodeOutput
  godotclj.api.gdscript.IGodotAnimationNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotGraphNode
 :extends
 [godotclj.api.gdscript.MGodotGraphNode
  godotclj.api.gdscript.IGodotContainer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVBoxContainer
 :extends
 [godotclj.api.gdscript.MGodotVBoxContainer
  godotclj.api.gdscript.IGodotBoxContainer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotFileSystemDock
 :extends
 [godotclj.api.gdscript.MGodotFileSystemDock
  godotclj.api.gdscript.IGodotVBoxContainer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCanvasLayer
 :extends
 [godotclj.api.gdscript.MGodotCanvasLayer
  godotclj.api.gdscript.IGodotNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotParallaxBackground
 :extends
 [godotclj.api.gdscript.MGodotParallaxBackground
  godotclj.api.gdscript.IGodotCanvasLayer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeTransformCompose
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeTransformCompose
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotInputEventMouse
 :extends
 [godotclj.api.gdscript.MGodotInputEventMouse
  godotclj.api.gdscript.IGodotInputEventWithModifiers])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotInputEventMouseButton
 :extends
 [godotclj.api.gdscript.MGodotInputEventMouseButton
  godotclj.api.gdscript.IGodotInputEventMouse])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotRemoteTransform2D
 :extends
 [godotclj.api.gdscript.MGodotRemoteTransform2D
  godotclj.api.gdscript.IGodotNode2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotRegExMatch
 :extends
 [godotclj.api.gdscript.MGodotRegExMatch
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotTouchScreenButton
 :extends
 [godotclj.api.gdscript.MGodotTouchScreenButton
  godotclj.api.gdscript.IGodotNode2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotHashingContext
 :extends
 [godotclj.api.gdscript.MGodotHashingContext
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotSpotLight
 :extends
 [godotclj.api.gdscript.MGodotSpotLight
  godotclj.api.gdscript.IGodotLight])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeScalarDerivativeFunc
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeScalarDerivativeFunc
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotKinematicBody2D
 :extends
 [godotclj.api.gdscript.MGodotKinematicBody2D
  godotclj.api.gdscript.IGodotPhysicsBody2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeVectorDerivativeFunc
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeVectorDerivativeFunc
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptSceneNode
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptSceneNode
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotJavaClassWrapper
 :extends
 [godotclj.api.gdscript.MGodotJavaClassWrapper
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotTileSet
 :extends
 [godotclj.api.gdscript.MGodotTileSet
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotLargeTexture
 :extends
 [godotclj.api.gdscript.MGodotLargeTexture
  godotclj.api.gdscript.IGodotTexture])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptPropertyGet
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptPropertyGet
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotShape2D
 :extends
 [godotclj.api.gdscript.MGodotShape2D
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotConvexPolygonShape2D
 :extends
 [godotclj.api.gdscript.MGodotConvexPolygonShape2D
  godotclj.api.gdscript.IGodotShape2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotTheme
 :extends
 [godotclj.api.gdscript.MGodotTheme
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAnimationNodeTimeSeek
 :extends
 [godotclj.api.gdscript.MGodotAnimationNodeTimeSeek
  godotclj.api.gdscript.IGodotAnimationNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAnimationNodeTimeScale
 :extends
 [godotclj.api.gdscript.MGodotAnimationNodeTimeScale
  godotclj.api.gdscript.IGodotAnimationNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioServer
 :extends
 [godotclj.api.gdscript.MGodotAudioServer
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualServer
 :extends
 [godotclj.api.gdscript.MGodotVisualServer
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotScriptCreateDialog
 :extends
 [godotclj.api.gdscript.MGodotScriptCreateDialog
  godotclj.api.gdscript.IGodotConfirmationDialog])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCharFXTransform
 :extends
 [godotclj.api.gdscript.MGodotCharFXTransform
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeSwitch
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeSwitch
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotLabel
 :extends
 [godotclj.api.gdscript.MGodotLabel
  godotclj.api.gdscript.IGodotControl])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVideoStreamWebm
 :extends
 [godotclj.api.gdscript.MGodotVideoStreamWebm
  godotclj.api.gdscript.IGodotVideoStream])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptYieldSignal
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptYieldSignal
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCurve2D
 :extends
 [godotclj.api.gdscript.MGodotCurve2D
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodot_OS
 :extends
 [godotclj.api.gdscript.MGodot_OS godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioEffectLowPassFilter
 :extends
 [godotclj.api.gdscript.MGodotAudioEffectLowPassFilter
  godotclj.api.gdscript.IGodotAudioEffectFilter])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotSegmentShape2D
 :extends
 [godotclj.api.gdscript.MGodotSegmentShape2D
  godotclj.api.gdscript.IGodotShape2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVSlider
 :extends
 [godotclj.api.gdscript.MGodotVSlider
  godotclj.api.gdscript.IGodotSlider])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptTypeCast
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptTypeCast
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotEnvironment
 :extends
 [godotclj.api.gdscript.MGodotEnvironment
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotListener
 :extends
 [godotclj.api.gdscript.MGodotListener
  godotclj.api.gdscript.IGodotSpatial])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotEditorVCSInterface
 :extends
 [godotclj.api.gdscript.MGodotEditorVCSInterface
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeVectorLen
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeVectorLen
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioEffectEQ10
 :extends
 [godotclj.api.gdscript.MGodotAudioEffectEQ10
  godotclj.api.gdscript.IGodotAudioEffectEQ])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotInstancePlaceholder
 :extends
 [godotclj.api.gdscript.MGodotInstancePlaceholder
  godotclj.api.gdscript.IGodotNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotNavigationPolygon
 :extends
 [godotclj.api.gdscript.MGodotNavigationPolygon
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotStreamPeerBuffer
 :extends
 [godotclj.api.gdscript.MGodotStreamPeerBuffer
  godotclj.api.gdscript.IGodotStreamPeer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptFunctionState
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptFunctionState
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeTextureUniformTriplanar
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeTextureUniformTriplanar
  godotclj.api.gdscript.IGodotVisualShaderNodeTextureUniform])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotEditorScript
 :extends
 [godotclj.api.gdscript.MGodotEditorScript
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPhysics2DDirectSpaceState
 :extends
 [godotclj.api.gdscript.MGodotPhysics2DDirectSpaceState
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCheckBox
 :extends
 [godotclj.api.gdscript.MGodotCheckBox
  godotclj.api.gdscript.IGodotButton])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioEffectPitchShift
 :extends
 [godotclj.api.gdscript.MGodotAudioEffectPitchShift
  godotclj.api.gdscript.IGodotAudioEffect])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotWebRTCPeerConnection
 :extends
 [godotclj.api.gdscript.MGodotWebRTCPeerConnection
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeFaceForward
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeFaceForward
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotConeTwistJoint
 :extends
 [godotclj.api.gdscript.MGodotConeTwistJoint
  godotclj.api.gdscript.IGodotJoint])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisibilityEnabler
 :extends
 [godotclj.api.gdscript.MGodotVisibilityEnabler
  godotclj.api.gdscript.IGodotVisibilityNotifier])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotRegEx
 :extends
 [godotclj.api.gdscript.MGodotRegEx
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPackedDataContainerRef
 :extends
 [godotclj.api.gdscript.MGodotPackedDataContainerRef
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotMeshInstance
 :extends
 [godotclj.api.gdscript.MGodotMeshInstance
  godotclj.api.gdscript.IGodotGeometryInstance])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeVectorSmoothStep
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeVectorSmoothStep
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotFont
 :extends
 [godotclj.api.gdscript.MGodotFont
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotLight2D
 :extends
 [godotclj.api.gdscript.MGodotLight2D
  godotclj.api.gdscript.IGodotNode2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisibilityNotifier2D
 :extends
 [godotclj.api.gdscript.MGodotVisibilityNotifier2D
  godotclj.api.gdscript.IGodotNode2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisibilityEnabler2D
 :extends
 [godotclj.api.gdscript.MGodotVisibilityEnabler2D
  godotclj.api.gdscript.IGodotVisibilityNotifier2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotARVRServer
 :extends
 [godotclj.api.gdscript.MGodotARVRServer
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotStaticBody
 :extends
 [godotclj.api.gdscript.MGodotStaticBody
  godotclj.api.gdscript.IGodotPhysicsBody])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPhysicsMaterial
 :extends
 [godotclj.api.gdscript.MGodotPhysicsMaterial
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotEditorResourcePreviewGenerator
 :extends
 [godotclj.api.gdscript.MGodotEditorResourcePreviewGenerator
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotSeparator
 :extends
 [godotclj.api.gdscript.MGodotSeparator
  godotclj.api.gdscript.IGodotControl])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVSeparator
 :extends
 [godotclj.api.gdscript.MGodotVSeparator
  godotclj.api.gdscript.IGodotSeparator])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotInputEventJoypadMotion
 :extends
 [godotclj.api.gdscript.MGodotInputEventJoypadMotion
  godotclj.api.gdscript.IGodotInputEvent])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotWebSocketMultiplayerPeer
 :extends
 [godotclj.api.gdscript.MGodotWebSocketMultiplayerPeer
  godotclj.api.gdscript.IGodotNetworkedMultiplayerPeer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotWebSocketServer
 :extends
 [godotclj.api.gdscript.MGodotWebSocketServer
  godotclj.api.gdscript.IGodotWebSocketMultiplayerPeer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCameraServer
 :extends
 [godotclj.api.gdscript.MGodotCameraServer
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotMainLoop
 :extends
 [godotclj.api.gdscript.MGodotMainLoop
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAnimationNodeStateMachinePlayback
 :extends
 [godotclj.api.gdscript.MGodotAnimationNodeStateMachinePlayback
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPlaneShape
 :extends
 [godotclj.api.gdscript.MGodotPlaneShape
  godotclj.api.gdscript.IGodotShape])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeDotProduct
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeDotProduct
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotOccluderPolygon2D
 :extends
 [godotclj.api.gdscript.MGodotOccluderPolygon2D
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotEditorSelection
 :extends
 [godotclj.api.gdscript.MGodotEditorSelection
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotRayCast2D
 :extends
 [godotclj.api.gdscript.MGodotRayCast2D
  godotclj.api.gdscript.IGodotNode2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotScrollContainer
 :extends
 [godotclj.api.gdscript.MGodotScrollContainer
  godotclj.api.gdscript.IGodotContainer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioStreamRandomPitch
 :extends
 [godotclj.api.gdscript.MGodotAudioStreamRandomPitch
  godotclj.api.gdscript.IGodotAudioStream])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeVectorScalarSmoothStep
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeVectorScalarSmoothStep
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAnimationNodeBlend3
 :extends
 [godotclj.api.gdscript.MGodotAnimationNodeBlend3
  godotclj.api.gdscript.IGodotAnimationNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeVectorScalarStep
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeVectorScalarStep
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodot_VisualScriptEditor
 :extends
 [godotclj.api.gdscript.MGodot_VisualScriptEditor
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCamera2D
 :extends
 [godotclj.api.gdscript.MGodotCamera2D
  godotclj.api.gdscript.IGodotNode2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeIf
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeIf
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotArrayMesh
 :extends
 [godotclj.api.gdscript.MGodotArrayMesh
  godotclj.api.gdscript.IGodotMesh])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotInput
 :extends
 [godotclj.api.gdscript.MGodotInput
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotMarginContainer
 :extends
 [godotclj.api.gdscript.MGodotMarginContainer
  godotclj.api.gdscript.IGodotContainer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptIndexSet
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptIndexSet
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotTextFile
 :extends
 [godotclj.api.gdscript.MGodotTextFile
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioEffectPhaser
 :extends
 [godotclj.api.gdscript.MGodotAudioEffectPhaser
  godotclj.api.gdscript.IGodotAudioEffect])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotYSort
 :extends
 [godotclj.api.gdscript.MGodotYSort
  godotclj.api.gdscript.IGodotNode2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptDeconstruct
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptDeconstruct
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotSphereMesh
 :extends
 [godotclj.api.gdscript.MGodotSphereMesh
  godotclj.api.gdscript.IGodotPrimitiveMesh])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotStyleBox
 :extends
 [godotclj.api.gdscript.MGodotStyleBox
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotStyleBoxLine
 :extends
 [godotclj.api.gdscript.MGodotStyleBoxLine
  godotclj.api.gdscript.IGodotStyleBox])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotSkeleton2D
 :extends
 [godotclj.api.gdscript.MGodotSkeleton2D
  godotclj.api.gdscript.IGodotNode2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCollisionPolygon2D
 :extends
 [godotclj.api.gdscript.MGodotCollisionPolygon2D
  godotclj.api.gdscript.IGodotNode2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptSelect
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptSelect
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAnimationNodeTransition
 :extends
 [godotclj.api.gdscript.MGodotAnimationNodeTransition
  godotclj.api.gdscript.IGodotAnimationNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAnimationTrackEditPlugin
 :extends
 [godotclj.api.gdscript.MGodotAnimationTrackEditPlugin
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotEditorSpatialGizmoPlugin
 :extends
 [godotclj.api.gdscript.MGodotEditorSpatialGizmoPlugin
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotInputDefault
 :extends
 [godotclj.api.gdscript.MGodotInputDefault
  godotclj.api.gdscript.IGodotInput])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotSpriteFrames
 :extends
 [godotclj.api.gdscript.MGodotSpriteFrames
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotBoxShape
 :extends
 [godotclj.api.gdscript.MGodotBoxShape
  godotclj.api.gdscript.IGodotShape])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptBuiltinFunc
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptBuiltinFunc
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotInputEventPanGesture
 :extends
 [godotclj.api.gdscript.MGodotInputEventPanGesture
  godotclj.api.gdscript.IGodotInputEventGesture])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotGraphEdit
 :extends
 [godotclj.api.gdscript.MGodotGraphEdit
  godotclj.api.gdscript.IGodotControl])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeVectorDecompose
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeVectorDecompose
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAtlasTexture
 :extends
 [godotclj.api.gdscript.MGodotAtlasTexture
  godotclj.api.gdscript.IGodotTexture])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotImageTexture
 :extends
 [godotclj.api.gdscript.MGodotImageTexture
  godotclj.api.gdscript.IGodotTexture])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotHeightMapShape
 :extends
 [godotclj.api.gdscript.MGodotHeightMapShape
  godotclj.api.gdscript.IGodotShape])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotHSeparator
 :extends
 [godotclj.api.gdscript.MGodotHSeparator
  godotclj.api.gdscript.IGodotSeparator])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCircleShape2D
 :extends
 [godotclj.api.gdscript.MGodotCircleShape2D
  godotclj.api.gdscript.IGodotShape2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScript
 :extends
 [godotclj.api.gdscript.MGodotVisualScript
  godotclj.api.gdscript.IGodotScript])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotNavigation2D
 :extends
 [godotclj.api.gdscript.MGodotNavigation2D
  godotclj.api.gdscript.IGodotNode2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeVectorRefract
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeVectorRefract
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotSliderJoint
 :extends
 [godotclj.api.gdscript.MGodotSliderJoint
  godotclj.api.gdscript.IGodotJoint])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotProjectSettings
 :extends
 [godotclj.api.gdscript.MGodotProjectSettings
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotStreamPeerTCP
 :extends
 [godotclj.api.gdscript.MGodotStreamPeerTCP
  godotclj.api.gdscript.IGodotStreamPeer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioEffectBandPassFilter
 :extends
 [godotclj.api.gdscript.MGodotAudioEffectBandPassFilter
  godotclj.api.gdscript.IGodotAudioEffectFilter])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotSpringArm
 :extends
 [godotclj.api.gdscript.MGodotSpringArm
  godotclj.api.gdscript.IGodotSpatial])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotEditorProperty
 :extends
 [godotclj.api.gdscript.MGodotEditorProperty
  godotclj.api.gdscript.IGodotContainer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeTransformVecMult
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeTransformVecMult
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotJoint2D
 :extends
 [godotclj.api.gdscript.MGodotJoint2D
  godotclj.api.gdscript.IGodotNode2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeVec3Constant
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeVec3Constant
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCSGBox
 :extends
 [godotclj.api.gdscript.MGodotCSGBox
  godotclj.api.gdscript.IGodotCSGPrimitive])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotProximityGroup
 :extends
 [godotclj.api.gdscript.MGodotProximityGroup
  godotclj.api.gdscript.IGodotSpatial])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotEditorFileDialog
 :extends
 [godotclj.api.gdscript.MGodotEditorFileDialog
  godotclj.api.gdscript.IGodotConfirmationDialog])
(gen-interface
 :name
 godotclj.api.gdscript.IGodot_ClassDB
 :extends
 [godotclj.api.gdscript.MGodot_ClassDB
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotTabs
 :extends
 [godotclj.api.gdscript.MGodotTabs
  godotclj.api.gdscript.IGodotControl])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptEngineSingleton
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptEngineSingleton
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotSpatialGizmo
 :extends
 [godotclj.api.gdscript.MGodotSpatialGizmo
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotEditorSpatialGizmo
 :extends
 [godotclj.api.gdscript.MGodotEditorSpatialGizmo
  godotclj.api.gdscript.IGodotSpatialGizmo])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotMultiMeshInstance
 :extends
 [godotclj.api.gdscript.MGodotMultiMeshInstance
  godotclj.api.gdscript.IGodotGeometryInstance])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioEffectInstance
 :extends
 [godotclj.api.gdscript.MGodotAudioEffectInstance
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioEffectSpectrumAnalyzerInstance
 :extends
 [godotclj.api.gdscript.MGodotAudioEffectSpectrumAnalyzerInstance
  godotclj.api.gdscript.IGodotAudioEffectInstance])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotGradientTexture
 :extends
 [godotclj.api.gdscript.MGodotGradientTexture
  godotclj.api.gdscript.IGodotTexture])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptInputAction
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptInputAction
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotReferenceRect
 :extends
 [godotclj.api.gdscript.MGodotReferenceRect
  godotclj.api.gdscript.IGodotControl])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotEditorSceneImporter
 :extends
 [godotclj.api.gdscript.MGodotEditorSceneImporter
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotEditorSceneImporterFBX
 :extends
 [godotclj.api.gdscript.MGodotEditorSceneImporterFBX
  godotclj.api.gdscript.IGodotEditorSceneImporter])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCollisionShape
 :extends
 [godotclj.api.gdscript.MGodotCollisionShape
  godotclj.api.gdscript.IGodotSpatial])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCollisionShape2D
 :extends
 [godotclj.api.gdscript.MGodotCollisionShape2D
  godotclj.api.gdscript.IGodotNode2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCSGSphere
 :extends
 [godotclj.api.gdscript.MGodotCSGSphere
  godotclj.api.gdscript.IGodotCSGPrimitive])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotWorld2D
 :extends
 [godotclj.api.gdscript.MGodotWorld2D
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotSpatialVelocityTracker
 :extends
 [godotclj.api.gdscript.MGodotSpatialVelocityTracker
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioEffectHighPassFilter
 :extends
 [godotclj.api.gdscript.MGodotAudioEffectHighPassFilter
  godotclj.api.gdscript.IGodotAudioEffectFilter])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptCustomNode
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptCustomNode
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotWebRTCDataChannel
 :extends
 [godotclj.api.gdscript.MGodotWebRTCDataChannel
  godotclj.api.gdscript.IGodotPacketPeer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotWebRTCDataChannelGDNative
 :extends
 [godotclj.api.gdscript.MGodotWebRTCDataChannelGDNative
  godotclj.api.gdscript.IGodotWebRTCDataChannel])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotInputEventAction
 :extends
 [godotclj.api.gdscript.MGodotInputEventAction
  godotclj.api.gdscript.IGodotInputEvent])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioStreamPlayer3D
 :extends
 [godotclj.api.gdscript.MGodotAudioStreamPlayer3D
  godotclj.api.gdscript.IGodotSpatial])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptSequence
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptSequence
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotMultiMesh
 :extends
 [godotclj.api.gdscript.MGodotMultiMesh
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotTCP_Server
 :extends
 [godotclj.api.gdscript.MGodotTCP_Server
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotGDNativeLibrary
 :extends
 [godotclj.api.gdscript.MGodotGDNativeLibrary
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotNavigationMesh
 :extends
 [godotclj.api.gdscript.MGodotNavigationMesh
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioEffectReverb
 :extends
 [godotclj.api.gdscript.MGodotAudioEffectReverb
  godotclj.api.gdscript.IGodotAudioEffect])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCSGTorus
 :extends
 [godotclj.api.gdscript.MGodotCSGTorus
  godotclj.api.gdscript.IGodotCSGPrimitive])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotNinePatchRect
 :extends
 [godotclj.api.gdscript.MGodotNinePatchRect
  godotclj.api.gdscript.IGodotControl])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotJNISingleton
 :extends
 [godotclj.api.gdscript.MGodotJNISingleton
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCSGPolygon
 :extends
 [godotclj.api.gdscript.MGodotCSGPolygon
  godotclj.api.gdscript.IGodotCSGPrimitive])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptLocalVar
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptLocalVar
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAStar
 :extends
 [godotclj.api.gdscript.MGodotAStar
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotResourceFormatLoader
 :extends
 [godotclj.api.gdscript.MGodotResourceFormatLoader
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotGDScript
 :extends
 [godotclj.api.gdscript.MGodotGDScript
  godotclj.api.gdscript.IGodotScript])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotJavaScript
 :extends
 [godotclj.api.gdscript.MGodotJavaScript
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVideoStreamTheora
 :extends
 [godotclj.api.gdscript.MGodotVideoStreamTheora
  godotclj.api.gdscript.IGodotVideoStream])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotMeshDataTool
 :extends
 [godotclj.api.gdscript.MGodotMeshDataTool
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioStreamMP3
 :extends
 [godotclj.api.gdscript.MGodotAudioStreamMP3
  godotclj.api.gdscript.IGodotAudioStream])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCubeMap
 :extends
 [godotclj.api.gdscript.MGodotCubeMap
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotTileMap
 :extends
 [godotclj.api.gdscript.MGodotTileMap
  godotclj.api.gdscript.IGodotNode2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotInputEventScreenTouch
 :extends
 [godotclj.api.gdscript.MGodotInputEventScreenTouch
  godotclj.api.gdscript.IGodotInputEvent])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotTextureArray
 :extends
 [godotclj.api.gdscript.MGodotTextureArray
  godotclj.api.gdscript.IGodotTextureLayered])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptPropertySet
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptPropertySet
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotBakedLightmapData
 :extends
 [godotclj.api.gdscript.MGodotBakedLightmapData
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotEditorInspector
 :extends
 [godotclj.api.gdscript.MGodotEditorInspector
  godotclj.api.gdscript.IGodotScrollContainer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeTransformUniform
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeTransformUniform
  godotclj.api.gdscript.IGodotVisualShaderNodeUniform])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotRectangleShape2D
 :extends
 [godotclj.api.gdscript.MGodotRectangleShape2D
  godotclj.api.gdscript.IGodotShape2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotInputEventMagnifyGesture
 :extends
 [godotclj.api.gdscript.MGodotInputEventMagnifyGesture
  godotclj.api.gdscript.IGodotInputEventGesture])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotShader
 :extends
 [godotclj.api.gdscript.MGodotShader
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShader
 :extends
 [godotclj.api.gdscript.MGodotVisualShader
  godotclj.api.gdscript.IGodotShader])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotColorRect
 :extends
 [godotclj.api.gdscript.MGodotColorRect
  godotclj.api.gdscript.IGodotControl])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotBulletPhysicsDirectBodyState
 :extends
 [godotclj.api.gdscript.MGodotBulletPhysicsDirectBodyState
  godotclj.api.gdscript.IGodotPhysicsDirectBodyState])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioStreamMicrophone
 :extends
 [godotclj.api.gdscript.MGodotAudioStreamMicrophone
  godotclj.api.gdscript.IGodotAudioStream])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotResourceImporter
 :extends
 [godotclj.api.gdscript.MGodotResourceImporter
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotTextureRect
 :extends
 [godotclj.api.gdscript.MGodotTextureRect
  godotclj.api.gdscript.IGodotControl])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotMultiplayerAPI
 :extends
 [godotclj.api.gdscript.MGodotMultiplayerAPI
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotEditorExportPlugin
 :extends
 [godotclj.api.gdscript.MGodotEditorExportPlugin
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPhysicsShapeQueryResult
 :extends
 [godotclj.api.gdscript.MGodotPhysicsShapeQueryResult
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotWebRTCPeerConnectionGDNative
 :extends
 [godotclj.api.gdscript.MGodotWebRTCPeerConnectionGDNative
  godotclj.api.gdscript.IGodotWebRTCPeerConnection])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotKinematicCollision2D
 :extends
 [godotclj.api.gdscript.MGodotKinematicCollision2D
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotStreamPeerSSL
 :extends
 [godotclj.api.gdscript.MGodotStreamPeerSSL
  godotclj.api.gdscript.IGodotStreamPeer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotSpriteBase3D
 :extends
 [godotclj.api.gdscript.MGodotSpriteBase3D
  godotclj.api.gdscript.IGodotGeometryInstance])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAnimatedSprite3D
 :extends
 [godotclj.api.gdscript.MGodotAnimatedSprite3D
  godotclj.api.gdscript.IGodotSpriteBase3D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodot_Geometry
 :extends
 [godotclj.api.gdscript.MGodot_Geometry
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeVectorOp
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeVectorOp
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotLinkButton
 :extends
 [godotclj.api.gdscript.MGodotLinkButton
  godotclj.api.gdscript.IGodotBaseButton])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotSpinBox
 :extends
 [godotclj.api.gdscript.MGodotSpinBox
  godotclj.api.gdscript.IGodotRange])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeCubeMap
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeCubeMap
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAStar2D
 :extends
 [godotclj.api.gdscript.MGodotAStar2D
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodot_Thread
 :extends
 [godotclj.api.gdscript.MGodot_Thread
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotEditorSettings
 :extends
 [godotclj.api.gdscript.MGodotEditorSettings
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioEffectStereoEnhance
 :extends
 [godotclj.api.gdscript.MGodotAudioEffectStereoEnhance
  godotclj.api.gdscript.IGodotAudioEffect])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotTimer
 :extends
 [godotclj.api.gdscript.MGodotTimer godotclj.api.gdscript.IGodotNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptSwitch
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptSwitch
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotEditorPlugin
 :extends
 [godotclj.api.gdscript.MGodotEditorPlugin
  godotclj.api.gdscript.IGodotNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotInputEventKey
 :extends
 [godotclj.api.gdscript.MGodotInputEventKey
  godotclj.api.gdscript.IGodotInputEventWithModifiers])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotStyleBoxFlat
 :extends
 [godotclj.api.gdscript.MGodotStyleBoxFlat
  godotclj.api.gdscript.IGodotStyleBox])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioEffectLowShelfFilter
 :extends
 [godotclj.api.gdscript.MGodotAudioEffectLowShelfFilter
  godotclj.api.gdscript.IGodotAudioEffectFilter])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotStaticBody2D
 :extends
 [godotclj.api.gdscript.MGodotStaticBody2D
  godotclj.api.gdscript.IGodotPhysicsBody2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioBusLayout
 :extends
 [godotclj.api.gdscript.MGodotAudioBusLayout
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioStreamPlayback
 :extends
 [godotclj.api.gdscript.MGodotAudioStreamPlayback
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioStreamPlaybackResampled
 :extends
 [godotclj.api.gdscript.MGodotAudioStreamPlaybackResampled
  godotclj.api.gdscript.IGodotAudioStreamPlayback])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotItemList
 :extends
 [godotclj.api.gdscript.MGodotItemList
  godotclj.api.gdscript.IGodotControl])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeTexture
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeTexture
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptSubCall
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptSubCall
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPerformance
 :extends
 [godotclj.api.gdscript.MGodotPerformance
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptExpression
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptExpression
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotTreeItem
 :extends
 [godotclj.api.gdscript.MGodotTreeItem
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPanelContainer
 :extends
 [godotclj.api.gdscript.MGodotPanelContainer
  godotclj.api.gdscript.IGodotContainer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeTransformMult
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeTransformMult
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotTabContainer
 :extends
 [godotclj.api.gdscript.MGodotTabContainer
  godotclj.api.gdscript.IGodotContainer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPosition3D
 :extends
 [godotclj.api.gdscript.MGodotPosition3D
  godotclj.api.gdscript.IGodotSpatial])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotExpression
 :extends
 [godotclj.api.gdscript.MGodotExpression
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeScalarSwitch
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeScalarSwitch
  godotclj.api.gdscript.IGodotVisualShaderNodeSwitch])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCylinderMesh
 :extends
 [godotclj.api.gdscript.MGodotCylinderMesh
  godotclj.api.gdscript.IGodotPrimitiveMesh])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAnimatedTexture
 :extends
 [godotclj.api.gdscript.MGodotAnimatedTexture
  godotclj.api.gdscript.IGodotTexture])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioStreamPlayer
 :extends
 [godotclj.api.gdscript.MGodotAudioStreamPlayer
  godotclj.api.gdscript.IGodotNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeCompare
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeCompare
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVSplitContainer
 :extends
 [godotclj.api.gdscript.MGodotVSplitContainer
  godotclj.api.gdscript.IGodotSplitContainer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotEditorScenePostImport
 :extends
 [godotclj.api.gdscript.MGodotEditorScenePostImport
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioEffectPanner
 :extends
 [godotclj.api.gdscript.MGodotAudioEffectPanner
  godotclj.api.gdscript.IGodotAudioEffect])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCSGCombiner
 :extends
 [godotclj.api.gdscript.MGodotCSGCombiner
  godotclj.api.gdscript.IGodotCSGShape])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptMathConstant
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptMathConstant
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotLineShape2D
 :extends
 [godotclj.api.gdscript.MGodotLineShape2D
  godotclj.api.gdscript.IGodotShape2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotDampedSpringJoint2D
 :extends
 [godotclj.api.gdscript.MGodotDampedSpringJoint2D
  godotclj.api.gdscript.IGodotJoint2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotTextureButton
 :extends
 [godotclj.api.gdscript.MGodotTextureButton
  godotclj.api.gdscript.IGodotBaseButton])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPinJoint
 :extends
 [godotclj.api.gdscript.MGodotPinJoint
  godotclj.api.gdscript.IGodotJoint])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVideoPlayer
 :extends
 [godotclj.api.gdscript.MGodotVideoPlayer
  godotclj.api.gdscript.IGodotControl])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotResourceFormatSaver
 :extends
 [godotclj.api.gdscript.MGodotResourceFormatSaver
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotEditorFileSystemDirectory
 :extends
 [godotclj.api.gdscript.MGodotEditorFileSystemDirectory
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotParallaxLayer
 :extends
 [godotclj.api.gdscript.MGodotParallaxLayer
  godotclj.api.gdscript.IGodotNode2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeScalarFunc
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeScalarFunc
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioEffectCompressor
 :extends
 [godotclj.api.gdscript.MGodotAudioEffectCompressor
  godotclj.api.gdscript.IGodotAudioEffect])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotARVRController
 :extends
 [godotclj.api.gdscript.MGodotARVRController
  godotclj.api.gdscript.IGodotSpatial])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotMenuButton
 :extends
 [godotclj.api.gdscript.MGodotMenuButton
  godotclj.api.gdscript.IGodotButton])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotProceduralSky
 :extends
 [godotclj.api.gdscript.MGodotProceduralSky
  godotclj.api.gdscript.IGodotSky])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioEffectSpectrumAnalyzer
 :extends
 [godotclj.api.gdscript.MGodotAudioEffectSpectrumAnalyzer
  godotclj.api.gdscript.IGodotAudioEffect])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotInterpolatedCamera
 :extends
 [godotclj.api.gdscript.MGodotInterpolatedCamera
  godotclj.api.gdscript.IGodotCamera])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCameraFeed
 :extends
 [godotclj.api.gdscript.MGodotCameraFeed
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotParticles2D
 :extends
 [godotclj.api.gdscript.MGodotParticles2D
  godotclj.api.gdscript.IGodotNode2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotUPNP
 :extends
 [godotclj.api.gdscript.MGodotUPNP
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPhysics2DTestMotionResult
 :extends
 [godotclj.api.gdscript.MGodotPhysics2DTestMotionResult
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotSkeletonIK
 :extends
 [godotclj.api.gdscript.MGodotSkeletonIK
  godotclj.api.gdscript.IGodotNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotNavigation
 :extends
 [godotclj.api.gdscript.MGodotNavigation
  godotclj.api.gdscript.IGodotSpatial])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPhysics2DShapeQueryResult
 :extends
 [godotclj.api.gdscript.MGodotPhysics2DShapeQueryResult
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPacketPeerUDP
 :extends
 [godotclj.api.gdscript.MGodotPacketPeerUDP
  godotclj.api.gdscript.IGodotPacketPeer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeVectorClamp
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeVectorClamp
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAnimationNodeBlend2
 :extends
 [godotclj.api.gdscript.MGodotAnimationNodeBlend2
  godotclj.api.gdscript.IGodotAnimationNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeBooleanUniform
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeBooleanUniform
  godotclj.api.gdscript.IGodotVisualShaderNodeUniform])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCSGMesh
 :extends
 [godotclj.api.gdscript.MGodotCSGMesh
  godotclj.api.gdscript.IGodotCSGPrimitive])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPopupPanel
 :extends
 [godotclj.api.gdscript.MGodotPopupPanel
  godotclj.api.gdscript.IGodotPopup])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeColorConstant
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeColorConstant
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotImmediateGeometry
 :extends
 [godotclj.api.gdscript.MGodotImmediateGeometry
  godotclj.api.gdscript.IGodotGeometryInstance])
(gen-interface
 :name
 godotclj.api.gdscript.IGodot_Engine
 :extends
 [godotclj.api.gdscript.MGodot_Engine
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotFileDialog
 :extends
 [godotclj.api.gdscript.MGodotFileDialog
  godotclj.api.gdscript.IGodotConfirmationDialog])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeCubeMapUniform
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeCubeMapUniform
  godotclj.api.gdscript.IGodotVisualShaderNodeTextureUniform])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioEffectChorus
 :extends
 [godotclj.api.gdscript.MGodotAudioEffectChorus
  godotclj.api.gdscript.IGodotAudioEffect])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPhysicsShapeQueryParameters
 :extends
 [godotclj.api.gdscript.MGodotPhysicsShapeQueryParameters
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptVariableSet
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptVariableSet
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotWorldEnvironment
 :extends
 [godotclj.api.gdscript.MGodotWorldEnvironment
  godotclj.api.gdscript.IGodotNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotScriptEditor
 :extends
 [godotclj.api.gdscript.MGodotScriptEditor
  godotclj.api.gdscript.IGodotPanelContainer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotEditorInspectorPlugin
 :extends
 [godotclj.api.gdscript.MGodotEditorInspectorPlugin
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotJavaClass
 :extends
 [godotclj.api.gdscript.MGodotJavaClass
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeInput
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeInput
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioEffectEQ6
 :extends
 [godotclj.api.gdscript.MGodotAudioEffectEQ6
  godotclj.api.gdscript.IGodotAudioEffectEQ])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCPUParticles
 :extends
 [godotclj.api.gdscript.MGodotCPUParticles
  godotclj.api.gdscript.IGodotGeometryInstance])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCurve
 :extends
 [godotclj.api.gdscript.MGodotCurve
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotTextureProgress
 :extends
 [godotclj.api.gdscript.MGodotTextureProgress
  godotclj.api.gdscript.IGodotRange])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPathFollow
 :extends
 [godotclj.api.gdscript.MGodotPathFollow
  godotclj.api.gdscript.IGodotSpatial])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCanvasModulate
 :extends
 [godotclj.api.gdscript.MGodotCanvasModulate
  godotclj.api.gdscript.IGodotNode2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAnimationNodeStateMachine
 :extends
 [godotclj.api.gdscript.MGodotAnimationNodeStateMachine
  godotclj.api.gdscript.IGodotAnimationRootNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPointMesh
 :extends
 [godotclj.api.gdscript.MGodotPointMesh
  godotclj.api.gdscript.IGodotPrimitiveMesh])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotBitMap
 :extends
 [godotclj.api.gdscript.MGodotBitMap
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCubeMesh
 :extends
 [godotclj.api.gdscript.MGodotCubeMesh
  godotclj.api.gdscript.IGodotPrimitiveMesh])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPath
 :extends
 [godotclj.api.gdscript.MGodotPath
  godotclj.api.gdscript.IGodotSpatial])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAnimatedSprite
 :extends
 [godotclj.api.gdscript.MGodotAnimatedSprite
  godotclj.api.gdscript.IGodotNode2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioEffectDistortion
 :extends
 [godotclj.api.gdscript.MGodotAudioEffectDistortion
  godotclj.api.gdscript.IGodotAudioEffect])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotNetworkedMultiplayerENet
 :extends
 [godotclj.api.gdscript.MGodotNetworkedMultiplayerENet
  godotclj.api.gdscript.IGodotNetworkedMultiplayerPeer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPhysics2DDirectBodyState
 :extends
 [godotclj.api.gdscript.MGodotPhysics2DDirectBodyState
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotDynamicFont
 :extends
 [godotclj.api.gdscript.MGodotDynamicFont
  godotclj.api.gdscript.IGodotFont])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotResourcePreloader
 :extends
 [godotclj.api.gdscript.MGodotResourcePreloader
  godotclj.api.gdscript.IGodotNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotSprite3D
 :extends
 [godotclj.api.gdscript.MGodotSprite3D
  godotclj.api.gdscript.IGodotSpriteBase3D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotDirectionalLight
 :extends
 [godotclj.api.gdscript.MGodotDirectionalLight
  godotclj.api.gdscript.IGodotLight])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPacketPeerGDNative
 :extends
 [godotclj.api.gdscript.MGodotPacketPeerGDNative
  godotclj.api.gdscript.IGodotPacketPeer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeColorOp
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeColorOp
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioStreamGeneratorPlayback
 :extends
 [godotclj.api.gdscript.MGodotAudioStreamGeneratorPlayback
  godotclj.api.gdscript.IGodotAudioStreamPlaybackResampled])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCryptoKey
 :extends
 [godotclj.api.gdscript.MGodotCryptoKey
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotARVRAnchor
 :extends
 [godotclj.api.gdscript.MGodotARVRAnchor
  godotclj.api.gdscript.IGodotSpatial])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotBitmapFont
 :extends
 [godotclj.api.gdscript.MGodotBitmapFont
  godotclj.api.gdscript.IGodotFont])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotViewportContainer
 :extends
 [godotclj.api.gdscript.MGodotViewportContainer
  godotclj.api.gdscript.IGodotContainer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAspectRatioContainer
 :extends
 [godotclj.api.gdscript.MGodotAspectRatioContainer
  godotclj.api.gdscript.IGodotContainer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotGIProbeData
 :extends
 [godotclj.api.gdscript.MGodotGIProbeData
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAnimationNodeAdd2
 :extends
 [godotclj.api.gdscript.MGodotAnimationNodeAdd2
  godotclj.api.gdscript.IGodotAnimationNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotNavigationMeshInstance
 :extends
 [godotclj.api.gdscript.MGodotNavigationMeshInstance
  godotclj.api.gdscript.IGodotSpatial])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioEffectBandLimitFilter
 :extends
 [godotclj.api.gdscript.MGodotAudioEffectBandLimitFilter
  godotclj.api.gdscript.IGodotAudioEffectFilter])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotInputEventMouseMotion
 :extends
 [godotclj.api.gdscript.MGodotInputEventMouseMotion
  godotclj.api.gdscript.IGodotInputEventMouse])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotConcavePolygonShape2D
 :extends
 [godotclj.api.gdscript.MGodotConcavePolygonShape2D
  godotclj.api.gdscript.IGodotShape2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeVectorCompose
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeVectorCompose
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotTranslationServer
 :extends
 [godotclj.api.gdscript.MGodotTranslationServer
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotProxyTexture
 :extends
 [godotclj.api.gdscript.MGodotProxyTexture
  godotclj.api.gdscript.IGodotTexture])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotBackBufferCopy
 :extends
 [godotclj.api.gdscript.MGodotBackBufferCopy
  godotclj.api.gdscript.IGodotNode2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotEditorSpinSlider
 :extends
 [godotclj.api.gdscript.MGodotEditorSpinSlider
  godotclj.api.gdscript.IGodotRange])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioStreamPlayer2D
 :extends
 [godotclj.api.gdscript.MGodotAudioStreamPlayer2D
  godotclj.api.gdscript.IGodotNode2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotARVRInterfaceGDNative
 :extends
 [godotclj.api.gdscript.MGodotARVRInterfaceGDNative
  godotclj.api.gdscript.IGodotARVRInterface])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAnimationTree
 :extends
 [godotclj.api.gdscript.MGodotAnimationTree
  godotclj.api.gdscript.IGodotNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotColorPicker
 :extends
 [godotclj.api.gdscript.MGodotColorPicker
  godotclj.api.gdscript.IGodotBoxContainer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeColorUniform
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeColorUniform
  godotclj.api.gdscript.IGodotVisualShaderNodeUniform])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotStyleBoxTexture
 :extends
 [godotclj.api.gdscript.MGodotStyleBoxTexture
  godotclj.api.gdscript.IGodotStyleBox])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptIterator
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptIterator
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioStreamOGGVorbis
 :extends
 [godotclj.api.gdscript.MGodotAudioStreamOGGVorbis
  godotclj.api.gdscript.IGodotAudioStream])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeScalarClamp
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeScalarClamp
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotUndoRedo
 :extends
 [godotclj.api.gdscript.MGodotUndoRedo
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPluginScript
 :extends
 [godotclj.api.gdscript.MGodotPluginScript
  godotclj.api.gdscript.IGodotScript])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotSoftBody
 :extends
 [godotclj.api.gdscript.MGodotSoftBody
  godotclj.api.gdscript.IGodotMeshInstance])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotRayCast
 :extends
 [godotclj.api.gdscript.MGodotRayCast
  godotclj.api.gdscript.IGodotSpatial])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptIndexGet
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptIndexGet
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptYield
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptYield
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotKinematicCollision
 :extends
 [godotclj.api.gdscript.MGodotKinematicCollision
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotSceneTree
 :extends
 [godotclj.api.gdscript.MGodotSceneTree
  godotclj.api.gdscript.IGodotMainLoop])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotGlobalConstants
 :extends
 [godotclj.api.gdscript.MGodotGlobalConstants])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotGridContainer
 :extends
 [godotclj.api.gdscript.MGodotGridContainer
  godotclj.api.gdscript.IGodotContainer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotInputMap
 :extends
 [godotclj.api.gdscript.MGodotInputMap
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPCKPacker
 :extends
 [godotclj.api.gdscript.MGodotPCKPacker
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotShortCut
 :extends
 [godotclj.api.gdscript.MGodotShortCut
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotStyleBoxEmpty
 :extends
 [godotclj.api.gdscript.MGodotStyleBoxEmpty
  godotclj.api.gdscript.IGodotStyleBox])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeScalarConstant
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeScalarConstant
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCheckButton
 :extends
 [godotclj.api.gdscript.MGodotCheckButton
  godotclj.api.gdscript.IGodotButton])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotWeakRef
 :extends
 [godotclj.api.gdscript.MGodotWeakRef
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeColorFunc
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeColorFunc
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotMeshTexture
 :extends
 [godotclj.api.gdscript.MGodotMeshTexture
  godotclj.api.gdscript.IGodotTexture])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeVectorInterp
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeVectorInterp
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPackedScene
 :extends
 [godotclj.api.gdscript.MGodotPackedScene
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotLightOccluder2D
 :extends
 [godotclj.api.gdscript.MGodotLightOccluder2D
  godotclj.api.gdscript.IGodotNode2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPrismMesh
 :extends
 [godotclj.api.gdscript.MGodotPrismMesh
  godotclj.api.gdscript.IGodotPrimitiveMesh])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeVec3Uniform
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeVec3Uniform
  godotclj.api.gdscript.IGodotVisualShaderNodeUniform])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPhysics2DDirectBodyStateSW
 :extends
 [godotclj.api.gdscript.MGodotPhysics2DDirectBodyStateSW
  godotclj.api.gdscript.IGodotPhysics2DDirectBodyState])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotReflectionProbe
 :extends
 [godotclj.api.gdscript.MGodotReflectionProbe
  godotclj.api.gdscript.IGodotVisualInstance])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptEmitSignal
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptEmitSignal
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVehicleWheel
 :extends
 [godotclj.api.gdscript.MGodotVehicleWheel
  godotclj.api.gdscript.IGodotSpatial])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotRandomNumberGenerator
 :extends
 [godotclj.api.gdscript.MGodotRandomNumberGenerator
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotEditorImportPlugin
 :extends
 [godotclj.api.gdscript.MGodotEditorImportPlugin
  godotclj.api.gdscript.IGodotResourceImporter])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotWebSocketPeer
 :extends
 [godotclj.api.gdscript.MGodotWebSocketPeer
  godotclj.api.gdscript.IGodotPacketPeer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotGradient
 :extends
 [godotclj.api.gdscript.MGodotGradient
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioEffectNotchFilter
 :extends
 [godotclj.api.gdscript.MGodotAudioEffectNotchFilter
  godotclj.api.gdscript.IGodotAudioEffectFilter])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptWhile
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptWhile
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotSkin
 :extends
 [godotclj.api.gdscript.MGodotSkin
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotWorld
 :extends
 [godotclj.api.gdscript.MGodotWorld
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotSprite
 :extends
 [godotclj.api.gdscript.MGodotSprite
  godotclj.api.gdscript.IGodotNode2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPhysicsDirectSpaceState
 :extends
 [godotclj.api.gdscript.MGodotPhysicsDirectSpaceState
  godotclj.api.gdscript.IGodotObject])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotWebSocketClient
 :extends
 [godotclj.api.gdscript.MGodotWebSocketClient
  godotclj.api.gdscript.IGodotWebSocketMultiplayerPeer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotEncodedObjectAsID
 :extends
 [godotclj.api.gdscript.MGodotEncodedObjectAsID
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotMeshLibrary
 :extends
 [godotclj.api.gdscript.MGodotMeshLibrary
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPathFollow2D
 :extends
 [godotclj.api.gdscript.MGodotPathFollow2D
  godotclj.api.gdscript.IGodotNode2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotGrooveJoint2D
 :extends
 [godotclj.api.gdscript.MGodotGrooveJoint2D
  godotclj.api.gdscript.IGodotJoint2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeUniformRef
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeUniformRef
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotGeneric6DOFJoint
 :extends
 [godotclj.api.gdscript.MGodotGeneric6DOFJoint
  godotclj.api.gdscript.IGodotJoint])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotRemoteTransform
 :extends
 [godotclj.api.gdscript.MGodotRemoteTransform
  godotclj.api.gdscript.IGodotSpatial])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCapsuleShape2D
 :extends
 [godotclj.api.gdscript.MGodotCapsuleShape2D
  godotclj.api.gdscript.IGodotShape2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodot_Mutex
 :extends
 [godotclj.api.gdscript.MGodot_Mutex
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotEditorFileSystem
 :extends
 [godotclj.api.gdscript.MGodotEditorFileSystem
  godotclj.api.gdscript.IGodotNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotQuadMesh
 :extends
 [godotclj.api.gdscript.MGodotQuadMesh
  godotclj.api.gdscript.IGodotPrimitiveMesh])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeTransformConstant
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeTransformConstant
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAnimationTreePlayer
 :extends
 [godotclj.api.gdscript.MGodotAnimationTreePlayer
  godotclj.api.gdscript.IGodotNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotParticles
 :extends
 [godotclj.api.gdscript.MGodotParticles
  godotclj.api.gdscript.IGodotGeometryInstance])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotMeshInstance2D
 :extends
 [godotclj.api.gdscript.MGodotMeshInstance2D
  godotclj.api.gdscript.IGodotNode2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptReturn
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptReturn
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPacketPeerDTLS
 :extends
 [godotclj.api.gdscript.MGodotPacketPeerDTLS
  godotclj.api.gdscript.IGodotPacketPeer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotBulletPhysicsServer
 :extends
 [godotclj.api.gdscript.MGodotBulletPhysicsServer
  godotclj.api.gdscript.IGodotPhysicsServer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualScriptPreload
 :extends
 [godotclj.api.gdscript.MGodotVisualScriptPreload
  godotclj.api.gdscript.IGodotVisualScriptNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPinJoint2D
 :extends
 [godotclj.api.gdscript.MGodotPinJoint2D
  godotclj.api.gdscript.IGodotJoint2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCapsuleShape
 :extends
 [godotclj.api.gdscript.MGodotCapsuleShape
  godotclj.api.gdscript.IGodotShape])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotTriangleMesh
 :extends
 [godotclj.api.gdscript.MGodotTriangleMesh
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotAudioStreamSample
 :extends
 [godotclj.api.gdscript.MGodotAudioStreamSample
  godotclj.api.gdscript.IGodotAudioStream])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPackedDataContainer
 :extends
 [godotclj.api.gdscript.MGodotPackedDataContainer
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotSceneTreeTimer
 :extends
 [godotclj.api.gdscript.MGodotSceneTreeTimer
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCameraTexture
 :extends
 [godotclj.api.gdscript.MGodotCameraTexture
  godotclj.api.gdscript.IGodotTexture])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotVisualShaderNodeScalarSmoothStep
 :extends
 [godotclj.api.gdscript.MGodotVisualShaderNodeScalarSmoothStep
  godotclj.api.gdscript.IGodotVisualShaderNode])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotSceneState
 :extends
 [godotclj.api.gdscript.MGodotSceneState
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPolygonPathFinder
 :extends
 [godotclj.api.gdscript.MGodotPolygonPathFinder
  godotclj.api.gdscript.IGodotResource])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotRayShape2D
 :extends
 [godotclj.api.gdscript.MGodotRayShape2D
  godotclj.api.gdscript.IGodotShape2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotGDNative
 :extends
 [godotclj.api.gdscript.MGodotGDNative
  godotclj.api.gdscript.IGodotReference])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotARVRCamera
 :extends
 [godotclj.api.gdscript.MGodotARVRCamera
  godotclj.api.gdscript.IGodotCamera])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCenterContainer
 :extends
 [godotclj.api.gdscript.MGodotCenterContainer
  godotclj.api.gdscript.IGodotContainer])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotPosition2D
 :extends
 [godotclj.api.gdscript.MGodotPosition2D
  godotclj.api.gdscript.IGodotNode2D])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotColorPickerButton
 :extends
 [godotclj.api.gdscript.MGodotColorPickerButton
  godotclj.api.gdscript.IGodotButton])
(gen-interface
 :name
 godotclj.api.gdscript.IGodotCanvasItemMaterial
 :extends
 [godotclj.api.gdscript.MGodotCanvasItemMaterial
  godotclj.api.gdscript.IGodotMaterial])
(deftype GodotObject
  [m4122]
  proto/ToVariant
  (->variant [this] (proto/->variant m4122))
  clojure.lang.ILookup
  (valAt [_ k] (get m4122 k))
  godotclj.api.gdscript.IGodotObject
  (addUserSignal
   [_ signal]
   ((clojure.core/get m4122 :add-user-signal) signal))
  (addUserSignal
   [_ signal arguments]
   ((clojure.core/get m4122 :add-user-signal) signal arguments))
  (call [_ method] ((clojure.core/get m4122 :call) method))
  (call [_ method v1] ((clojure.core/get m4122 :call) method v1))
  (call
   [_ method v1 v2]
   ((clojure.core/get m4122 :call) method v1 v2))
  (call
   [_ method v1 v2 v3]
   ((clojure.core/get m4122 :call) method v1 v2 v3))
  (call
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4122 :call) method v1 v2 v3 v4))
  (call
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4122 :call) method v1 v2 v3 v4 v5))
  (callDeferred
   [_ method]
   ((clojure.core/get m4122 :call-deferred) method))
  (callDeferred
   [_ method v1]
   ((clojure.core/get m4122 :call-deferred) method v1))
  (callDeferred
   [_ method v1 v2]
   ((clojure.core/get m4122 :call-deferred) method v1 v2))
  (callDeferred
   [_ method v1 v2 v3]
   ((clojure.core/get m4122 :call-deferred) method v1 v2 v3))
  (callDeferred
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4122 :call-deferred) method v1 v2 v3 v4))
  (callDeferred
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4122 :call-deferred) method v1 v2 v3 v4 v5))
  (callv
   [_ method arg_array]
   ((clojure.core/get m4122 :callv) method arg_array))
  (canTranslateMessages
   [_]
   ((clojure.core/get m4122 :can-translate-messages)))
  (connect
   [_ signal target method]
   ((clojure.core/get m4122 :connect) signal target method))
  (connect
   [_ signal target method binds]
   ((clojure.core/get m4122 :connect) signal target method binds))
  (connect
   [_ signal target method binds flags]
   ((clojure.core/get m4122 :connect)
    signal
    target
    method
    binds
    flags))
  (disconnect
   [_ signal target method]
   ((clojure.core/get m4122 :disconnect) signal target method))
  (emitSignal
   [_ signal]
   ((clojure.core/get m4122 :emit-signal) signal))
  (emitSignal
   [_ signal v1]
   ((clojure.core/get m4122 :emit-signal) signal v1))
  (emitSignal
   [_ signal v1 v2]
   ((clojure.core/get m4122 :emit-signal) signal v1 v2))
  (emitSignal
   [_ signal v1 v2 v3]
   ((clojure.core/get m4122 :emit-signal) signal v1 v2 v3))
  (emitSignal
   [_ signal v1 v2 v3 v4]
   ((clojure.core/get m4122 :emit-signal) signal v1 v2 v3 v4))
  (emitSignal
   [_ signal v1 v2 v3 v4 v5]
   ((clojure.core/get m4122 :emit-signal) signal v1 v2 v3 v4 v5))
  (free [_] ((clojure.core/get m4122 :free)))
  (get [_ property] ((clojure.core/get m4122 :get) property))
  (getClass [_] ((clojure.core/get m4122 :get-class)))
  (getIncomingConnections
   [_]
   ((clojure.core/get m4122 :get-incoming-connections)))
  (getIndexed
   [_ property]
   ((clojure.core/get m4122 :get-indexed) property))
  (getInstanceId [_] ((clojure.core/get m4122 :get-instance-id)))
  (getMeta [_ name] ((clojure.core/get m4122 :get-meta) name))
  (getMetaList [_] ((clojure.core/get m4122 :get-meta-list)))
  (getMethodList [_] ((clojure.core/get m4122 :get-method-list)))
  (getPropertyList [_] ((clojure.core/get m4122 :get-property-list)))
  (getScript [_] ((clojure.core/get m4122 :get-script)))
  (getSignalConnectionList
   [_ signal]
   ((clojure.core/get m4122 :get-signal-connection-list) signal))
  (getSignalList [_] ((clojure.core/get m4122 :get-signal-list)))
  (hasMeta [_ name] ((clojure.core/get m4122 :has-meta) name))
  (hasMethod [_ method] ((clojure.core/get m4122 :has-method) method))
  (hasSignal [_ signal] ((clojure.core/get m4122 :has-signal) signal))
  (hasUserSignal
   [_ signal]
   ((clojure.core/get m4122 :has-user-signal) signal))
  (isBlockingSignals
   [_]
   ((clojure.core/get m4122 :is-blocking-signals)))
  (isClass [_ class] ((clojure.core/get m4122 :is-class) class))
  (isConnected
   [_ signal target method]
   ((clojure.core/get m4122 :is-connected) signal target method))
  (isQueuedForDeletion
   [_]
   ((clojure.core/get m4122 :is-queued-for-deletion)))
  (notification
   [_ what]
   ((clojure.core/get m4122 :notification) what))
  (notification
   [_ what reversed]
   ((clojure.core/get m4122 :notification) what reversed))
  (propertyListChangedNotify
   [_]
   ((clojure.core/get m4122 :property-list-changed-notify)))
  (removeMeta [_ name] ((clojure.core/get m4122 :remove-meta) name))
  (set
   [_ property value]
   ((clojure.core/get m4122 :set) property value))
  (setBlockSignals
   [_ enable]
   ((clojure.core/get m4122 :set-block-signals) enable))
  (setDeferred
   [_ property value]
   ((clojure.core/get m4122 :set-deferred) property value))
  (setIndexed
   [_ property value]
   ((clojure.core/get m4122 :set-indexed) property value))
  (setMessageTranslation
   [_ enable]
   ((clojure.core/get m4122 :set-message-translation) enable))
  (setMeta
   [_ name value]
   ((clojure.core/get m4122 :set-meta) name value))
  (setScript [_ script] ((clojure.core/get m4122 :set-script) script))
  (tr [_ message] ((clojure.core/get m4122 :tr) message)))
(deftype GodotEditorNavigationMeshGenerator
  [m4123]
  proto/ToVariant
  (->variant [this] (proto/->variant m4123))
  clojure.lang.ILookup
  (valAt [_ k] (get m4123 k))
  godotclj.api.gdscript.IGodotEditorNavigationMeshGenerator
  (addUserSignal
   [_ signal]
   ((clojure.core/get m4123 :add-user-signal) signal))
  (addUserSignal
   [_ signal arguments]
   ((clojure.core/get m4123 :add-user-signal) signal arguments))
  (call [_ method] ((clojure.core/get m4123 :call) method))
  (call [_ method v1] ((clojure.core/get m4123 :call) method v1))
  (call
   [_ method v1 v2]
   ((clojure.core/get m4123 :call) method v1 v2))
  (call
   [_ method v1 v2 v3]
   ((clojure.core/get m4123 :call) method v1 v2 v3))
  (call
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4123 :call) method v1 v2 v3 v4))
  (call
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4123 :call) method v1 v2 v3 v4 v5))
  (callDeferred
   [_ method]
   ((clojure.core/get m4123 :call-deferred) method))
  (callDeferred
   [_ method v1]
   ((clojure.core/get m4123 :call-deferred) method v1))
  (callDeferred
   [_ method v1 v2]
   ((clojure.core/get m4123 :call-deferred) method v1 v2))
  (callDeferred
   [_ method v1 v2 v3]
   ((clojure.core/get m4123 :call-deferred) method v1 v2 v3))
  (callDeferred
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4123 :call-deferred) method v1 v2 v3 v4))
  (callDeferred
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4123 :call-deferred) method v1 v2 v3 v4 v5))
  (callv
   [_ method arg_array]
   ((clojure.core/get m4123 :callv) method arg_array))
  (canTranslateMessages
   [_]
   ((clojure.core/get m4123 :can-translate-messages)))
  (connect
   [_ signal target method]
   ((clojure.core/get m4123 :connect) signal target method))
  (connect
   [_ signal target method binds]
   ((clojure.core/get m4123 :connect) signal target method binds))
  (connect
   [_ signal target method binds flags]
   ((clojure.core/get m4123 :connect)
    signal
    target
    method
    binds
    flags))
  (disconnect
   [_ signal target method]
   ((clojure.core/get m4123 :disconnect) signal target method))
  (emitSignal
   [_ signal]
   ((clojure.core/get m4123 :emit-signal) signal))
  (emitSignal
   [_ signal v1]
   ((clojure.core/get m4123 :emit-signal) signal v1))
  (emitSignal
   [_ signal v1 v2]
   ((clojure.core/get m4123 :emit-signal) signal v1 v2))
  (emitSignal
   [_ signal v1 v2 v3]
   ((clojure.core/get m4123 :emit-signal) signal v1 v2 v3))
  (emitSignal
   [_ signal v1 v2 v3 v4]
   ((clojure.core/get m4123 :emit-signal) signal v1 v2 v3 v4))
  (emitSignal
   [_ signal v1 v2 v3 v4 v5]
   ((clojure.core/get m4123 :emit-signal) signal v1 v2 v3 v4 v5))
  (free [_] ((clojure.core/get m4123 :free)))
  (get [_ property] ((clojure.core/get m4123 :get) property))
  (getClass [_] ((clojure.core/get m4123 :get-class)))
  (getIncomingConnections
   [_]
   ((clojure.core/get m4123 :get-incoming-connections)))
  (getIndexed
   [_ property]
   ((clojure.core/get m4123 :get-indexed) property))
  (getInstanceId [_] ((clojure.core/get m4123 :get-instance-id)))
  (getMeta [_ name] ((clojure.core/get m4123 :get-meta) name))
  (getMetaList [_] ((clojure.core/get m4123 :get-meta-list)))
  (getMethodList [_] ((clojure.core/get m4123 :get-method-list)))
  (getPropertyList [_] ((clojure.core/get m4123 :get-property-list)))
  (getScript [_] ((clojure.core/get m4123 :get-script)))
  (getSignalConnectionList
   [_ signal]
   ((clojure.core/get m4123 :get-signal-connection-list) signal))
  (getSignalList [_] ((clojure.core/get m4123 :get-signal-list)))
  (hasMeta [_ name] ((clojure.core/get m4123 :has-meta) name))
  (hasMethod [_ method] ((clojure.core/get m4123 :has-method) method))
  (hasSignal [_ signal] ((clojure.core/get m4123 :has-signal) signal))
  (hasUserSignal
   [_ signal]
   ((clojure.core/get m4123 :has-user-signal) signal))
  (isBlockingSignals
   [_]
   ((clojure.core/get m4123 :is-blocking-signals)))
  (isClass [_ class] ((clojure.core/get m4123 :is-class) class))
  (isConnected
   [_ signal target method]
   ((clojure.core/get m4123 :is-connected) signal target method))
  (isQueuedForDeletion
   [_]
   ((clojure.core/get m4123 :is-queued-for-deletion)))
  (notification
   [_ what]
   ((clojure.core/get m4123 :notification) what))
  (notification
   [_ what reversed]
   ((clojure.core/get m4123 :notification) what reversed))
  (propertyListChangedNotify
   [_]
   ((clojure.core/get m4123 :property-list-changed-notify)))
  (removeMeta [_ name] ((clojure.core/get m4123 :remove-meta) name))
  (set
   [_ property value]
   ((clojure.core/get m4123 :set) property value))
  (setBlockSignals
   [_ enable]
   ((clojure.core/get m4123 :set-block-signals) enable))
  (setDeferred
   [_ property value]
   ((clojure.core/get m4123 :set-deferred) property value))
  (setIndexed
   [_ property value]
   ((clojure.core/get m4123 :set-indexed) property value))
  (setMessageTranslation
   [_ enable]
   ((clojure.core/get m4123 :set-message-translation) enable))
  (setMeta
   [_ name value]
   ((clojure.core/get m4123 :set-meta) name value))
  (setScript [_ script] ((clojure.core/get m4123 :set-script) script))
  (tr [_ message] ((clojure.core/get m4123 :tr) message))
  (bake
   [_ nav_mesh root_node]
   ((clojure.core/get m4123 :bake) nav_mesh root_node))
  (clear [_ nav_mesh] ((clojure.core/get m4123 :clear) nav_mesh)))
(deftype GodotReference
  [m4124]
  proto/ToVariant
  (->variant [this] (proto/->variant m4124))
  clojure.lang.ILookup
  (valAt [_ k] (get m4124 k))
  godotclj.api.gdscript.IGodotReference
  (addUserSignal
   [_ signal]
   ((clojure.core/get m4124 :add-user-signal) signal))
  (addUserSignal
   [_ signal arguments]
   ((clojure.core/get m4124 :add-user-signal) signal arguments))
  (call [_ method] ((clojure.core/get m4124 :call) method))
  (call [_ method v1] ((clojure.core/get m4124 :call) method v1))
  (call
   [_ method v1 v2]
   ((clojure.core/get m4124 :call) method v1 v2))
  (call
   [_ method v1 v2 v3]
   ((clojure.core/get m4124 :call) method v1 v2 v3))
  (call
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4124 :call) method v1 v2 v3 v4))
  (call
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4124 :call) method v1 v2 v3 v4 v5))
  (callDeferred
   [_ method]
   ((clojure.core/get m4124 :call-deferred) method))
  (callDeferred
   [_ method v1]
   ((clojure.core/get m4124 :call-deferred) method v1))
  (callDeferred
   [_ method v1 v2]
   ((clojure.core/get m4124 :call-deferred) method v1 v2))
  (callDeferred
   [_ method v1 v2 v3]
   ((clojure.core/get m4124 :call-deferred) method v1 v2 v3))
  (callDeferred
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4124 :call-deferred) method v1 v2 v3 v4))
  (callDeferred
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4124 :call-deferred) method v1 v2 v3 v4 v5))
  (callv
   [_ method arg_array]
   ((clojure.core/get m4124 :callv) method arg_array))
  (canTranslateMessages
   [_]
   ((clojure.core/get m4124 :can-translate-messages)))
  (connect
   [_ signal target method]
   ((clojure.core/get m4124 :connect) signal target method))
  (connect
   [_ signal target method binds]
   ((clojure.core/get m4124 :connect) signal target method binds))
  (connect
   [_ signal target method binds flags]
   ((clojure.core/get m4124 :connect)
    signal
    target
    method
    binds
    flags))
  (disconnect
   [_ signal target method]
   ((clojure.core/get m4124 :disconnect) signal target method))
  (emitSignal
   [_ signal]
   ((clojure.core/get m4124 :emit-signal) signal))
  (emitSignal
   [_ signal v1]
   ((clojure.core/get m4124 :emit-signal) signal v1))
  (emitSignal
   [_ signal v1 v2]
   ((clojure.core/get m4124 :emit-signal) signal v1 v2))
  (emitSignal
   [_ signal v1 v2 v3]
   ((clojure.core/get m4124 :emit-signal) signal v1 v2 v3))
  (emitSignal
   [_ signal v1 v2 v3 v4]
   ((clojure.core/get m4124 :emit-signal) signal v1 v2 v3 v4))
  (emitSignal
   [_ signal v1 v2 v3 v4 v5]
   ((clojure.core/get m4124 :emit-signal) signal v1 v2 v3 v4 v5))
  (free [_] ((clojure.core/get m4124 :free)))
  (get [_ property] ((clojure.core/get m4124 :get) property))
  (getClass [_] ((clojure.core/get m4124 :get-class)))
  (getIncomingConnections
   [_]
   ((clojure.core/get m4124 :get-incoming-connections)))
  (getIndexed
   [_ property]
   ((clojure.core/get m4124 :get-indexed) property))
  (getInstanceId [_] ((clojure.core/get m4124 :get-instance-id)))
  (getMeta [_ name] ((clojure.core/get m4124 :get-meta) name))
  (getMetaList [_] ((clojure.core/get m4124 :get-meta-list)))
  (getMethodList [_] ((clojure.core/get m4124 :get-method-list)))
  (getPropertyList [_] ((clojure.core/get m4124 :get-property-list)))
  (getScript [_] ((clojure.core/get m4124 :get-script)))
  (getSignalConnectionList
   [_ signal]
   ((clojure.core/get m4124 :get-signal-connection-list) signal))
  (getSignalList [_] ((clojure.core/get m4124 :get-signal-list)))
  (hasMeta [_ name] ((clojure.core/get m4124 :has-meta) name))
  (hasMethod [_ method] ((clojure.core/get m4124 :has-method) method))
  (hasSignal [_ signal] ((clojure.core/get m4124 :has-signal) signal))
  (hasUserSignal
   [_ signal]
   ((clojure.core/get m4124 :has-user-signal) signal))
  (isBlockingSignals
   [_]
   ((clojure.core/get m4124 :is-blocking-signals)))
  (isClass [_ class] ((clojure.core/get m4124 :is-class) class))
  (isConnected
   [_ signal target method]
   ((clojure.core/get m4124 :is-connected) signal target method))
  (isQueuedForDeletion
   [_]
   ((clojure.core/get m4124 :is-queued-for-deletion)))
  (notification
   [_ what]
   ((clojure.core/get m4124 :notification) what))
  (notification
   [_ what reversed]
   ((clojure.core/get m4124 :notification) what reversed))
  (propertyListChangedNotify
   [_]
   ((clojure.core/get m4124 :property-list-changed-notify)))
  (removeMeta [_ name] ((clojure.core/get m4124 :remove-meta) name))
  (set
   [_ property value]
   ((clojure.core/get m4124 :set) property value))
  (setBlockSignals
   [_ enable]
   ((clojure.core/get m4124 :set-block-signals) enable))
  (setDeferred
   [_ property value]
   ((clojure.core/get m4124 :set-deferred) property value))
  (setIndexed
   [_ property value]
   ((clojure.core/get m4124 :set-indexed) property value))
  (setMessageTranslation
   [_ enable]
   ((clojure.core/get m4124 :set-message-translation) enable))
  (setMeta
   [_ name value]
   ((clojure.core/get m4124 :set-meta) name value))
  (setScript [_ script] ((clojure.core/get m4124 :set-script) script))
  (tr [_ message] ((clojure.core/get m4124 :tr) message))
  (initRef [_] ((clojure.core/get m4124 :init-ref)))
  (reference [_] ((clojure.core/get m4124 :reference)))
  (unreference [_] ((clojure.core/get m4124 :unreference))))
(deftype GodotResource
  [m4125]
  proto/ToVariant
  (->variant [this] (proto/->variant m4125))
  clojure.lang.ILookup
  (valAt [_ k] (get m4125 k))
  godotclj.api.gdscript.IGodotResource
  (addUserSignal
   [_ signal]
   ((clojure.core/get m4125 :add-user-signal) signal))
  (addUserSignal
   [_ signal arguments]
   ((clojure.core/get m4125 :add-user-signal) signal arguments))
  (call [_ method] ((clojure.core/get m4125 :call) method))
  (call [_ method v1] ((clojure.core/get m4125 :call) method v1))
  (call
   [_ method v1 v2]
   ((clojure.core/get m4125 :call) method v1 v2))
  (call
   [_ method v1 v2 v3]
   ((clojure.core/get m4125 :call) method v1 v2 v3))
  (call
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4125 :call) method v1 v2 v3 v4))
  (call
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4125 :call) method v1 v2 v3 v4 v5))
  (callDeferred
   [_ method]
   ((clojure.core/get m4125 :call-deferred) method))
  (callDeferred
   [_ method v1]
   ((clojure.core/get m4125 :call-deferred) method v1))
  (callDeferred
   [_ method v1 v2]
   ((clojure.core/get m4125 :call-deferred) method v1 v2))
  (callDeferred
   [_ method v1 v2 v3]
   ((clojure.core/get m4125 :call-deferred) method v1 v2 v3))
  (callDeferred
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4125 :call-deferred) method v1 v2 v3 v4))
  (callDeferred
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4125 :call-deferred) method v1 v2 v3 v4 v5))
  (callv
   [_ method arg_array]
   ((clojure.core/get m4125 :callv) method arg_array))
  (canTranslateMessages
   [_]
   ((clojure.core/get m4125 :can-translate-messages)))
  (connect
   [_ signal target method]
   ((clojure.core/get m4125 :connect) signal target method))
  (connect
   [_ signal target method binds]
   ((clojure.core/get m4125 :connect) signal target method binds))
  (connect
   [_ signal target method binds flags]
   ((clojure.core/get m4125 :connect)
    signal
    target
    method
    binds
    flags))
  (disconnect
   [_ signal target method]
   ((clojure.core/get m4125 :disconnect) signal target method))
  (emitSignal
   [_ signal]
   ((clojure.core/get m4125 :emit-signal) signal))
  (emitSignal
   [_ signal v1]
   ((clojure.core/get m4125 :emit-signal) signal v1))
  (emitSignal
   [_ signal v1 v2]
   ((clojure.core/get m4125 :emit-signal) signal v1 v2))
  (emitSignal
   [_ signal v1 v2 v3]
   ((clojure.core/get m4125 :emit-signal) signal v1 v2 v3))
  (emitSignal
   [_ signal v1 v2 v3 v4]
   ((clojure.core/get m4125 :emit-signal) signal v1 v2 v3 v4))
  (emitSignal
   [_ signal v1 v2 v3 v4 v5]
   ((clojure.core/get m4125 :emit-signal) signal v1 v2 v3 v4 v5))
  (free [_] ((clojure.core/get m4125 :free)))
  (get [_ property] ((clojure.core/get m4125 :get) property))
  (getClass [_] ((clojure.core/get m4125 :get-class)))
  (getIncomingConnections
   [_]
   ((clojure.core/get m4125 :get-incoming-connections)))
  (getIndexed
   [_ property]
   ((clojure.core/get m4125 :get-indexed) property))
  (getInstanceId [_] ((clojure.core/get m4125 :get-instance-id)))
  (getMeta [_ name] ((clojure.core/get m4125 :get-meta) name))
  (getMetaList [_] ((clojure.core/get m4125 :get-meta-list)))
  (getMethodList [_] ((clojure.core/get m4125 :get-method-list)))
  (getPropertyList [_] ((clojure.core/get m4125 :get-property-list)))
  (getScript [_] ((clojure.core/get m4125 :get-script)))
  (getSignalConnectionList
   [_ signal]
   ((clojure.core/get m4125 :get-signal-connection-list) signal))
  (getSignalList [_] ((clojure.core/get m4125 :get-signal-list)))
  (hasMeta [_ name] ((clojure.core/get m4125 :has-meta) name))
  (hasMethod [_ method] ((clojure.core/get m4125 :has-method) method))
  (hasSignal [_ signal] ((clojure.core/get m4125 :has-signal) signal))
  (hasUserSignal
   [_ signal]
   ((clojure.core/get m4125 :has-user-signal) signal))
  (isBlockingSignals
   [_]
   ((clojure.core/get m4125 :is-blocking-signals)))
  (isClass [_ class] ((clojure.core/get m4125 :is-class) class))
  (isConnected
   [_ signal target method]
   ((clojure.core/get m4125 :is-connected) signal target method))
  (isQueuedForDeletion
   [_]
   ((clojure.core/get m4125 :is-queued-for-deletion)))
  (notification
   [_ what]
   ((clojure.core/get m4125 :notification) what))
  (notification
   [_ what reversed]
   ((clojure.core/get m4125 :notification) what reversed))
  (propertyListChangedNotify
   [_]
   ((clojure.core/get m4125 :property-list-changed-notify)))
  (removeMeta [_ name] ((clojure.core/get m4125 :remove-meta) name))
  (set
   [_ property value]
   ((clojure.core/get m4125 :set) property value))
  (setBlockSignals
   [_ enable]
   ((clojure.core/get m4125 :set-block-signals) enable))
  (setDeferred
   [_ property value]
   ((clojure.core/get m4125 :set-deferred) property value))
  (setIndexed
   [_ property value]
   ((clojure.core/get m4125 :set-indexed) property value))
  (setMessageTranslation
   [_ enable]
   ((clojure.core/get m4125 :set-message-translation) enable))
  (setMeta
   [_ name value]
   ((clojure.core/get m4125 :set-meta) name value))
  (setScript [_ script] ((clojure.core/get m4125 :set-script) script))
  (tr [_ message] ((clojure.core/get m4125 :tr) message))
  (initRef [_] ((clojure.core/get m4125 :init-ref)))
  (reference [_] ((clojure.core/get m4125 :reference)))
  (unreference [_] ((clojure.core/get m4125 :unreference)))
  (duplicate [_] ((clojure.core/get m4125 :duplicate)))
  (duplicate
   [_ subresources]
   ((clojure.core/get m4125 :duplicate) subresources))
  (emitChanged [_] ((clojure.core/get m4125 :emit-changed)))
  (getLocalScene [_] ((clojure.core/get m4125 :get-local-scene)))
  (getName [_] ((clojure.core/get m4125 :get-name)))
  (getPath [_] ((clojure.core/get m4125 :get-path)))
  (getRid [_] ((clojure.core/get m4125 :get-rid)))
  (isLocalToScene [_] ((clojure.core/get m4125 :is-local-to-scene)))
  (setLocalToScene
   [_ enable]
   ((clojure.core/get m4125 :set-local-to-scene) enable))
  (setName [_ name] ((clojure.core/get m4125 :set-name) name))
  (setPath [_ path] ((clojure.core/get m4125 :set-path) path))
  (setupLocalToScene
   [_]
   ((clojure.core/get m4125 :setup-local-to-scene)))
  (takeOverPath
   [_ path]
   ((clojure.core/get m4125 :take-over-path) path)))
(deftype GodotVisualShaderNode
  [m4126]
  proto/ToVariant
  (->variant [this] (proto/->variant m4126))
  clojure.lang.ILookup
  (valAt [_ k] (get m4126 k))
  godotclj.api.gdscript.IGodotVisualShaderNode
  (addUserSignal
   [_ signal]
   ((clojure.core/get m4126 :add-user-signal) signal))
  (addUserSignal
   [_ signal arguments]
   ((clojure.core/get m4126 :add-user-signal) signal arguments))
  (call [_ method] ((clojure.core/get m4126 :call) method))
  (call [_ method v1] ((clojure.core/get m4126 :call) method v1))
  (call
   [_ method v1 v2]
   ((clojure.core/get m4126 :call) method v1 v2))
  (call
   [_ method v1 v2 v3]
   ((clojure.core/get m4126 :call) method v1 v2 v3))
  (call
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4126 :call) method v1 v2 v3 v4))
  (call
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4126 :call) method v1 v2 v3 v4 v5))
  (callDeferred
   [_ method]
   ((clojure.core/get m4126 :call-deferred) method))
  (callDeferred
   [_ method v1]
   ((clojure.core/get m4126 :call-deferred) method v1))
  (callDeferred
   [_ method v1 v2]
   ((clojure.core/get m4126 :call-deferred) method v1 v2))
  (callDeferred
   [_ method v1 v2 v3]
   ((clojure.core/get m4126 :call-deferred) method v1 v2 v3))
  (callDeferred
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4126 :call-deferred) method v1 v2 v3 v4))
  (callDeferred
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4126 :call-deferred) method v1 v2 v3 v4 v5))
  (callv
   [_ method arg_array]
   ((clojure.core/get m4126 :callv) method arg_array))
  (canTranslateMessages
   [_]
   ((clojure.core/get m4126 :can-translate-messages)))
  (connect
   [_ signal target method]
   ((clojure.core/get m4126 :connect) signal target method))
  (connect
   [_ signal target method binds]
   ((clojure.core/get m4126 :connect) signal target method binds))
  (connect
   [_ signal target method binds flags]
   ((clojure.core/get m4126 :connect)
    signal
    target
    method
    binds
    flags))
  (disconnect
   [_ signal target method]
   ((clojure.core/get m4126 :disconnect) signal target method))
  (emitSignal
   [_ signal]
   ((clojure.core/get m4126 :emit-signal) signal))
  (emitSignal
   [_ signal v1]
   ((clojure.core/get m4126 :emit-signal) signal v1))
  (emitSignal
   [_ signal v1 v2]
   ((clojure.core/get m4126 :emit-signal) signal v1 v2))
  (emitSignal
   [_ signal v1 v2 v3]
   ((clojure.core/get m4126 :emit-signal) signal v1 v2 v3))
  (emitSignal
   [_ signal v1 v2 v3 v4]
   ((clojure.core/get m4126 :emit-signal) signal v1 v2 v3 v4))
  (emitSignal
   [_ signal v1 v2 v3 v4 v5]
   ((clojure.core/get m4126 :emit-signal) signal v1 v2 v3 v4 v5))
  (free [_] ((clojure.core/get m4126 :free)))
  (get [_ property] ((clojure.core/get m4126 :get) property))
  (getClass [_] ((clojure.core/get m4126 :get-class)))
  (getIncomingConnections
   [_]
   ((clojure.core/get m4126 :get-incoming-connections)))
  (getIndexed
   [_ property]
   ((clojure.core/get m4126 :get-indexed) property))
  (getInstanceId [_] ((clojure.core/get m4126 :get-instance-id)))
  (getMeta [_ name] ((clojure.core/get m4126 :get-meta) name))
  (getMetaList [_] ((clojure.core/get m4126 :get-meta-list)))
  (getMethodList [_] ((clojure.core/get m4126 :get-method-list)))
  (getPropertyList [_] ((clojure.core/get m4126 :get-property-list)))
  (getScript [_] ((clojure.core/get m4126 :get-script)))
  (getSignalConnectionList
   [_ signal]
   ((clojure.core/get m4126 :get-signal-connection-list) signal))
  (getSignalList [_] ((clojure.core/get m4126 :get-signal-list)))
  (hasMeta [_ name] ((clojure.core/get m4126 :has-meta) name))
  (hasMethod [_ method] ((clojure.core/get m4126 :has-method) method))
  (hasSignal [_ signal] ((clojure.core/get m4126 :has-signal) signal))
  (hasUserSignal
   [_ signal]
   ((clojure.core/get m4126 :has-user-signal) signal))
  (isBlockingSignals
   [_]
   ((clojure.core/get m4126 :is-blocking-signals)))
  (isClass [_ class] ((clojure.core/get m4126 :is-class) class))
  (isConnected
   [_ signal target method]
   ((clojure.core/get m4126 :is-connected) signal target method))
  (isQueuedForDeletion
   [_]
   ((clojure.core/get m4126 :is-queued-for-deletion)))
  (notification
   [_ what]
   ((clojure.core/get m4126 :notification) what))
  (notification
   [_ what reversed]
   ((clojure.core/get m4126 :notification) what reversed))
  (propertyListChangedNotify
   [_]
   ((clojure.core/get m4126 :property-list-changed-notify)))
  (removeMeta [_ name] ((clojure.core/get m4126 :remove-meta) name))
  (set
   [_ property value]
   ((clojure.core/get m4126 :set) property value))
  (setBlockSignals
   [_ enable]
   ((clojure.core/get m4126 :set-block-signals) enable))
  (setDeferred
   [_ property value]
   ((clojure.core/get m4126 :set-deferred) property value))
  (setIndexed
   [_ property value]
   ((clojure.core/get m4126 :set-indexed) property value))
  (setMessageTranslation
   [_ enable]
   ((clojure.core/get m4126 :set-message-translation) enable))
  (setMeta
   [_ name value]
   ((clojure.core/get m4126 :set-meta) name value))
  (setScript [_ script] ((clojure.core/get m4126 :set-script) script))
  (tr [_ message] ((clojure.core/get m4126 :tr) message))
  (initRef [_] ((clojure.core/get m4126 :init-ref)))
  (reference [_] ((clojure.core/get m4126 :reference)))
  (unreference [_] ((clojure.core/get m4126 :unreference)))
  (duplicate [_] ((clojure.core/get m4126 :duplicate)))
  (duplicate
   [_ subresources]
   ((clojure.core/get m4126 :duplicate) subresources))
  (emitChanged [_] ((clojure.core/get m4126 :emit-changed)))
  (getLocalScene [_] ((clojure.core/get m4126 :get-local-scene)))
  (getName [_] ((clojure.core/get m4126 :get-name)))
  (getPath [_] ((clojure.core/get m4126 :get-path)))
  (getRid [_] ((clojure.core/get m4126 :get-rid)))
  (isLocalToScene [_] ((clojure.core/get m4126 :is-local-to-scene)))
  (setLocalToScene
   [_ enable]
   ((clojure.core/get m4126 :set-local-to-scene) enable))
  (setName [_ name] ((clojure.core/get m4126 :set-name) name))
  (setPath [_ path] ((clojure.core/get m4126 :set-path) path))
  (setupLocalToScene
   [_]
   ((clojure.core/get m4126 :setup-local-to-scene)))
  (takeOverPath
   [_ path]
   ((clojure.core/get m4126 :take-over-path) path))
  (getDefaultInputValues
   [_]
   ((clojure.core/get m4126 :get-default-input-values)))
  (getInputPortDefaultValue
   [_ port]
   ((clojure.core/get m4126 :get-input-port-default-value) port))
  (getOutputPortForPreview
   [_]
   ((clojure.core/get m4126 :get-output-port-for-preview)))
  (setDefaultInputValues
   [_ values]
   ((clojure.core/get m4126 :set-default-input-values) values))
  (setInputPortDefaultValue
   [_ port value]
   ((clojure.core/get m4126 :set-input-port-default-value) port value))
  (setOutputPortForPreview
   [_ port]
   ((clojure.core/get m4126 :set-output-port-for-preview) port)))
(deftype GodotVisualShaderNodeVectorScalarMix
  [m4127]
  proto/ToVariant
  (->variant [this] (proto/->variant m4127))
  clojure.lang.ILookup
  (valAt [_ k] (get m4127 k))
  godotclj.api.gdscript.IGodotVisualShaderNodeVectorScalarMix
  (addUserSignal
   [_ signal]
   ((clojure.core/get m4127 :add-user-signal) signal))
  (addUserSignal
   [_ signal arguments]
   ((clojure.core/get m4127 :add-user-signal) signal arguments))
  (call [_ method] ((clojure.core/get m4127 :call) method))
  (call [_ method v1] ((clojure.core/get m4127 :call) method v1))
  (call
   [_ method v1 v2]
   ((clojure.core/get m4127 :call) method v1 v2))
  (call
   [_ method v1 v2 v3]
   ((clojure.core/get m4127 :call) method v1 v2 v3))
  (call
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4127 :call) method v1 v2 v3 v4))
  (call
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4127 :call) method v1 v2 v3 v4 v5))
  (callDeferred
   [_ method]
   ((clojure.core/get m4127 :call-deferred) method))
  (callDeferred
   [_ method v1]
   ((clojure.core/get m4127 :call-deferred) method v1))
  (callDeferred
   [_ method v1 v2]
   ((clojure.core/get m4127 :call-deferred) method v1 v2))
  (callDeferred
   [_ method v1 v2 v3]
   ((clojure.core/get m4127 :call-deferred) method v1 v2 v3))
  (callDeferred
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4127 :call-deferred) method v1 v2 v3 v4))
  (callDeferred
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4127 :call-deferred) method v1 v2 v3 v4 v5))
  (callv
   [_ method arg_array]
   ((clojure.core/get m4127 :callv) method arg_array))
  (canTranslateMessages
   [_]
   ((clojure.core/get m4127 :can-translate-messages)))
  (connect
   [_ signal target method]
   ((clojure.core/get m4127 :connect) signal target method))
  (connect
   [_ signal target method binds]
   ((clojure.core/get m4127 :connect) signal target method binds))
  (connect
   [_ signal target method binds flags]
   ((clojure.core/get m4127 :connect)
    signal
    target
    method
    binds
    flags))
  (disconnect
   [_ signal target method]
   ((clojure.core/get m4127 :disconnect) signal target method))
  (emitSignal
   [_ signal]
   ((clojure.core/get m4127 :emit-signal) signal))
  (emitSignal
   [_ signal v1]
   ((clojure.core/get m4127 :emit-signal) signal v1))
  (emitSignal
   [_ signal v1 v2]
   ((clojure.core/get m4127 :emit-signal) signal v1 v2))
  (emitSignal
   [_ signal v1 v2 v3]
   ((clojure.core/get m4127 :emit-signal) signal v1 v2 v3))
  (emitSignal
   [_ signal v1 v2 v3 v4]
   ((clojure.core/get m4127 :emit-signal) signal v1 v2 v3 v4))
  (emitSignal
   [_ signal v1 v2 v3 v4 v5]
   ((clojure.core/get m4127 :emit-signal) signal v1 v2 v3 v4 v5))
  (free [_] ((clojure.core/get m4127 :free)))
  (get [_ property] ((clojure.core/get m4127 :get) property))
  (getClass [_] ((clojure.core/get m4127 :get-class)))
  (getIncomingConnections
   [_]
   ((clojure.core/get m4127 :get-incoming-connections)))
  (getIndexed
   [_ property]
   ((clojure.core/get m4127 :get-indexed) property))
  (getInstanceId [_] ((clojure.core/get m4127 :get-instance-id)))
  (getMeta [_ name] ((clojure.core/get m4127 :get-meta) name))
  (getMetaList [_] ((clojure.core/get m4127 :get-meta-list)))
  (getMethodList [_] ((clojure.core/get m4127 :get-method-list)))
  (getPropertyList [_] ((clojure.core/get m4127 :get-property-list)))
  (getScript [_] ((clojure.core/get m4127 :get-script)))
  (getSignalConnectionList
   [_ signal]
   ((clojure.core/get m4127 :get-signal-connection-list) signal))
  (getSignalList [_] ((clojure.core/get m4127 :get-signal-list)))
  (hasMeta [_ name] ((clojure.core/get m4127 :has-meta) name))
  (hasMethod [_ method] ((clojure.core/get m4127 :has-method) method))
  (hasSignal [_ signal] ((clojure.core/get m4127 :has-signal) signal))
  (hasUserSignal
   [_ signal]
   ((clojure.core/get m4127 :has-user-signal) signal))
  (isBlockingSignals
   [_]
   ((clojure.core/get m4127 :is-blocking-signals)))
  (isClass [_ class] ((clojure.core/get m4127 :is-class) class))
  (isConnected
   [_ signal target method]
   ((clojure.core/get m4127 :is-connected) signal target method))
  (isQueuedForDeletion
   [_]
   ((clojure.core/get m4127 :is-queued-for-deletion)))
  (notification
   [_ what]
   ((clojure.core/get m4127 :notification) what))
  (notification
   [_ what reversed]
   ((clojure.core/get m4127 :notification) what reversed))
  (propertyListChangedNotify
   [_]
   ((clojure.core/get m4127 :property-list-changed-notify)))
  (removeMeta [_ name] ((clojure.core/get m4127 :remove-meta) name))
  (set
   [_ property value]
   ((clojure.core/get m4127 :set) property value))
  (setBlockSignals
   [_ enable]
   ((clojure.core/get m4127 :set-block-signals) enable))
  (setDeferred
   [_ property value]
   ((clojure.core/get m4127 :set-deferred) property value))
  (setIndexed
   [_ property value]
   ((clojure.core/get m4127 :set-indexed) property value))
  (setMessageTranslation
   [_ enable]
   ((clojure.core/get m4127 :set-message-translation) enable))
  (setMeta
   [_ name value]
   ((clojure.core/get m4127 :set-meta) name value))
  (setScript [_ script] ((clojure.core/get m4127 :set-script) script))
  (tr [_ message] ((clojure.core/get m4127 :tr) message))
  (initRef [_] ((clojure.core/get m4127 :init-ref)))
  (reference [_] ((clojure.core/get m4127 :reference)))
  (unreference [_] ((clojure.core/get m4127 :unreference)))
  (duplicate [_] ((clojure.core/get m4127 :duplicate)))
  (duplicate
   [_ subresources]
   ((clojure.core/get m4127 :duplicate) subresources))
  (emitChanged [_] ((clojure.core/get m4127 :emit-changed)))
  (getLocalScene [_] ((clojure.core/get m4127 :get-local-scene)))
  (getName [_] ((clojure.core/get m4127 :get-name)))
  (getPath [_] ((clojure.core/get m4127 :get-path)))
  (getRid [_] ((clojure.core/get m4127 :get-rid)))
  (isLocalToScene [_] ((clojure.core/get m4127 :is-local-to-scene)))
  (setLocalToScene
   [_ enable]
   ((clojure.core/get m4127 :set-local-to-scene) enable))
  (setName [_ name] ((clojure.core/get m4127 :set-name) name))
  (setPath [_ path] ((clojure.core/get m4127 :set-path) path))
  (setupLocalToScene
   [_]
   ((clojure.core/get m4127 :setup-local-to-scene)))
  (takeOverPath
   [_ path]
   ((clojure.core/get m4127 :take-over-path) path))
  (getDefaultInputValues
   [_]
   ((clojure.core/get m4127 :get-default-input-values)))
  (getInputPortDefaultValue
   [_ port]
   ((clojure.core/get m4127 :get-input-port-default-value) port))
  (getOutputPortForPreview
   [_]
   ((clojure.core/get m4127 :get-output-port-for-preview)))
  (setDefaultInputValues
   [_ values]
   ((clojure.core/get m4127 :set-default-input-values) values))
  (setInputPortDefaultValue
   [_ port value]
   ((clojure.core/get m4127 :set-input-port-default-value) port value))
  (setOutputPortForPreview
   [_ port]
   ((clojure.core/get m4127 :set-output-port-for-preview) port)))
(deftype GodotNode
  [m4128]
  proto/ToVariant
  (->variant [this] (proto/->variant m4128))
  clojure.lang.ILookup
  (valAt [_ k] (get m4128 k))
  godotclj.api.gdscript.IGodotNode
  (addUserSignal
   [_ signal]
   ((clojure.core/get m4128 :add-user-signal) signal))
  (addUserSignal
   [_ signal arguments]
   ((clojure.core/get m4128 :add-user-signal) signal arguments))
  (call [_ method] ((clojure.core/get m4128 :call) method))
  (call [_ method v1] ((clojure.core/get m4128 :call) method v1))
  (call
   [_ method v1 v2]
   ((clojure.core/get m4128 :call) method v1 v2))
  (call
   [_ method v1 v2 v3]
   ((clojure.core/get m4128 :call) method v1 v2 v3))
  (call
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4128 :call) method v1 v2 v3 v4))
  (call
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4128 :call) method v1 v2 v3 v4 v5))
  (callDeferred
   [_ method]
   ((clojure.core/get m4128 :call-deferred) method))
  (callDeferred
   [_ method v1]
   ((clojure.core/get m4128 :call-deferred) method v1))
  (callDeferred
   [_ method v1 v2]
   ((clojure.core/get m4128 :call-deferred) method v1 v2))
  (callDeferred
   [_ method v1 v2 v3]
   ((clojure.core/get m4128 :call-deferred) method v1 v2 v3))
  (callDeferred
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4128 :call-deferred) method v1 v2 v3 v4))
  (callDeferred
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4128 :call-deferred) method v1 v2 v3 v4 v5))
  (callv
   [_ method arg_array]
   ((clojure.core/get m4128 :callv) method arg_array))
  (canTranslateMessages
   [_]
   ((clojure.core/get m4128 :can-translate-messages)))
  (connect
   [_ signal target method]
   ((clojure.core/get m4128 :connect) signal target method))
  (connect
   [_ signal target method binds]
   ((clojure.core/get m4128 :connect) signal target method binds))
  (connect
   [_ signal target method binds flags]
   ((clojure.core/get m4128 :connect)
    signal
    target
    method
    binds
    flags))
  (disconnect
   [_ signal target method]
   ((clojure.core/get m4128 :disconnect) signal target method))
  (emitSignal
   [_ signal]
   ((clojure.core/get m4128 :emit-signal) signal))
  (emitSignal
   [_ signal v1]
   ((clojure.core/get m4128 :emit-signal) signal v1))
  (emitSignal
   [_ signal v1 v2]
   ((clojure.core/get m4128 :emit-signal) signal v1 v2))
  (emitSignal
   [_ signal v1 v2 v3]
   ((clojure.core/get m4128 :emit-signal) signal v1 v2 v3))
  (emitSignal
   [_ signal v1 v2 v3 v4]
   ((clojure.core/get m4128 :emit-signal) signal v1 v2 v3 v4))
  (emitSignal
   [_ signal v1 v2 v3 v4 v5]
   ((clojure.core/get m4128 :emit-signal) signal v1 v2 v3 v4 v5))
  (free [_] ((clojure.core/get m4128 :free)))
  (get [_ property] ((clojure.core/get m4128 :get) property))
  (getClass [_] ((clojure.core/get m4128 :get-class)))
  (getIncomingConnections
   [_]
   ((clojure.core/get m4128 :get-incoming-connections)))
  (getIndexed
   [_ property]
   ((clojure.core/get m4128 :get-indexed) property))
  (getInstanceId [_] ((clojure.core/get m4128 :get-instance-id)))
  (getMeta [_ name] ((clojure.core/get m4128 :get-meta) name))
  (getMetaList [_] ((clojure.core/get m4128 :get-meta-list)))
  (getMethodList [_] ((clojure.core/get m4128 :get-method-list)))
  (getPropertyList [_] ((clojure.core/get m4128 :get-property-list)))
  (getScript [_] ((clojure.core/get m4128 :get-script)))
  (getSignalConnectionList
   [_ signal]
   ((clojure.core/get m4128 :get-signal-connection-list) signal))
  (getSignalList [_] ((clojure.core/get m4128 :get-signal-list)))
  (hasMeta [_ name] ((clojure.core/get m4128 :has-meta) name))
  (hasMethod [_ method] ((clojure.core/get m4128 :has-method) method))
  (hasSignal [_ signal] ((clojure.core/get m4128 :has-signal) signal))
  (hasUserSignal
   [_ signal]
   ((clojure.core/get m4128 :has-user-signal) signal))
  (isBlockingSignals
   [_]
   ((clojure.core/get m4128 :is-blocking-signals)))
  (isClass [_ class] ((clojure.core/get m4128 :is-class) class))
  (isConnected
   [_ signal target method]
   ((clojure.core/get m4128 :is-connected) signal target method))
  (isQueuedForDeletion
   [_]
   ((clojure.core/get m4128 :is-queued-for-deletion)))
  (notification
   [_ what]
   ((clojure.core/get m4128 :notification) what))
  (notification
   [_ what reversed]
   ((clojure.core/get m4128 :notification) what reversed))
  (propertyListChangedNotify
   [_]
   ((clojure.core/get m4128 :property-list-changed-notify)))
  (removeMeta [_ name] ((clojure.core/get m4128 :remove-meta) name))
  (set
   [_ property value]
   ((clojure.core/get m4128 :set) property value))
  (setBlockSignals
   [_ enable]
   ((clojure.core/get m4128 :set-block-signals) enable))
  (setDeferred
   [_ property value]
   ((clojure.core/get m4128 :set-deferred) property value))
  (setIndexed
   [_ property value]
   ((clojure.core/get m4128 :set-indexed) property value))
  (setMessageTranslation
   [_ enable]
   ((clojure.core/get m4128 :set-message-translation) enable))
  (setMeta
   [_ name value]
   ((clojure.core/get m4128 :set-meta) name value))
  (setScript [_ script] ((clojure.core/get m4128 :set-script) script))
  (tr [_ message] ((clojure.core/get m4128 :tr) message))
  (addChild [_ node] ((clojure.core/get m4128 :add-child) node))
  (addChild
   [_ node legible_unique_name]
   ((clojure.core/get m4128 :add-child) node legible_unique_name))
  (addChildBelowNode
   [_ node child_node]
   ((clojure.core/get m4128 :add-child-below-node) node child_node))
  (addChildBelowNode
   [_ node child_node legible_unique_name]
   ((clojure.core/get m4128 :add-child-below-node)
    node
    child_node
    legible_unique_name))
  (addToGroup
   [_ group]
   ((clojure.core/get m4128 :add-to-group) group))
  (addToGroup
   [_ group persistent]
   ((clojure.core/get m4128 :add-to-group) group persistent))
  (canProcess [_] ((clojure.core/get m4128 :can-process)))
  (duplicate [_] ((clojure.core/get m4128 :duplicate)))
  (duplicate [_ flags] ((clojure.core/get m4128 :duplicate) flags))
  (findNode [_ mask] ((clojure.core/get m4128 :find-node) mask))
  (findNode
   [_ mask recursive]
   ((clojure.core/get m4128 :find-node) mask recursive))
  (findNode
   [_ mask recursive owned]
   ((clojure.core/get m4128 :find-node) mask recursive owned))
  (findParent [_ mask] ((clojure.core/get m4128 :find-parent) mask))
  (getChild [_ idx] ((clojure.core/get m4128 :get-child) idx))
  (getChildCount [_] ((clojure.core/get m4128 :get-child-count)))
  (getChildren [_] ((clojure.core/get m4128 :get-children)))
  (getCustomMultiplayer
   [_]
   ((clojure.core/get m4128 :get-custom-multiplayer)))
  (getFilename [_] ((clojure.core/get m4128 :get-filename)))
  (getGroups [_] ((clojure.core/get m4128 :get-groups)))
  (getIndex [_] ((clojure.core/get m4128 :get-index)))
  (getMultiplayer [_] ((clojure.core/get m4128 :get-multiplayer)))
  (getName [_] ((clojure.core/get m4128 :get-name)))
  (getNetworkMaster
   [_]
   ((clojure.core/get m4128 :get-network-master)))
  (getNode [_ path] ((clojure.core/get m4128 :get-node) path))
  (getNodeAndResource
   [_ path]
   ((clojure.core/get m4128 :get-node-and-resource) path))
  (getNodeOrNull
   [_ path]
   ((clojure.core/get m4128 :get-node-or-null) path))
  (getOwner [_] ((clojure.core/get m4128 :get-owner)))
  (getParent [_] ((clojure.core/get m4128 :get-parent)))
  (getPath [_] ((clojure.core/get m4128 :get-path)))
  (getPathTo [_ node] ((clojure.core/get m4128 :get-path-to) node))
  (getPauseMode [_] ((clojure.core/get m4128 :get-pause-mode)))
  (getPhysicsProcessDeltaTime
   [_]
   ((clojure.core/get m4128 :get-physics-process-delta-time)))
  (getPositionInParent
   [_]
   ((clojure.core/get m4128 :get-position-in-parent)))
  (getProcessDeltaTime
   [_]
   ((clojure.core/get m4128 :get-process-delta-time)))
  (getProcessPriority
   [_]
   ((clojure.core/get m4128 :get-process-priority)))
  (getSceneInstanceLoadPlaceholder
   [_]
   ((clojure.core/get m4128 :get-scene-instance-load-placeholder)))
  (getTree [_] ((clojure.core/get m4128 :get-tree)))
  (getViewport [_] ((clojure.core/get m4128 :get-viewport)))
  (hasNode [_ path] ((clojure.core/get m4128 :has-node) path))
  (hasNodeAndResource
   [_ path]
   ((clojure.core/get m4128 :has-node-and-resource) path))
  (isAParentOf
   [_ node]
   ((clojure.core/get m4128 :is-a-parent-of) node))
  (isDisplayedFolded
   [_]
   ((clojure.core/get m4128 :is-displayed-folded)))
  (isGreaterThan
   [_ node]
   ((clojure.core/get m4128 :is-greater-than) node))
  (isInGroup [_ group] ((clojure.core/get m4128 :is-in-group) group))
  (isInsideTree [_] ((clojure.core/get m4128 :is-inside-tree)))
  (isNetworkMaster [_] ((clojure.core/get m4128 :is-network-master)))
  (isPhysicsProcessing
   [_]
   ((clojure.core/get m4128 :is-physics-processing)))
  (isPhysicsProcessingInternal
   [_]
   ((clojure.core/get m4128 :is-physics-processing-internal)))
  (isProcessing [_] ((clojure.core/get m4128 :is-processing)))
  (isProcessingInput
   [_]
   ((clojure.core/get m4128 :is-processing-input)))
  (isProcessingInternal
   [_]
   ((clojure.core/get m4128 :is-processing-internal)))
  (isProcessingUnhandledInput
   [_]
   ((clojure.core/get m4128 :is-processing-unhandled-input)))
  (isProcessingUnhandledKeyInput
   [_]
   ((clojure.core/get m4128 :is-processing-unhandled-key-input)))
  (moveChild
   [_ child_node to_position]
   ((clojure.core/get m4128 :move-child) child_node to_position))
  (printStrayNodes [_] ((clojure.core/get m4128 :print-stray-nodes)))
  (printTree [_] ((clojure.core/get m4128 :print-tree)))
  (printTreePretty [_] ((clojure.core/get m4128 :print-tree-pretty)))
  (propagateCall
   [_ method]
   ((clojure.core/get m4128 :propagate-call) method))
  (propagateCall
   [_ method args]
   ((clojure.core/get m4128 :propagate-call) method args))
  (propagateCall
   [_ method args parent_first]
   ((clojure.core/get m4128 :propagate-call) method args parent_first))
  (propagateNotification
   [_ what]
   ((clojure.core/get m4128 :propagate-notification) what))
  (queueFree [_] ((clojure.core/get m4128 :queue-free)))
  (raise [_] ((clojure.core/get m4128 :raise)))
  (removeAndSkip [_] ((clojure.core/get m4128 :remove-and-skip)))
  (removeChild [_ node] ((clojure.core/get m4128 :remove-child) node))
  (removeFromGroup
   [_ group]
   ((clojure.core/get m4128 :remove-from-group) group))
  (replaceBy [_ node] ((clojure.core/get m4128 :replace-by) node))
  (replaceBy
   [_ node keep_data]
   ((clojure.core/get m4128 :replace-by) node keep_data))
  (requestReady [_] ((clojure.core/get m4128 :request-ready)))
  (rpc [_ method] ((clojure.core/get m4128 :rpc) method))
  (rpc [_ method v1] ((clojure.core/get m4128 :rpc) method v1))
  (rpc [_ method v1 v2] ((clojure.core/get m4128 :rpc) method v1 v2))
  (rpc
   [_ method v1 v2 v3]
   ((clojure.core/get m4128 :rpc) method v1 v2 v3))
  (rpc
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4128 :rpc) method v1 v2 v3 v4))
  (rpc
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4128 :rpc) method v1 v2 v3 v4 v5))
  (rpcConfig
   [_ method mode]
   ((clojure.core/get m4128 :rpc-config) method mode))
  (rpcId
   [_ peer_id method]
   ((clojure.core/get m4128 :rpc-id) peer_id method))
  (rpcId
   [_ peer_id method v1]
   ((clojure.core/get m4128 :rpc-id) peer_id method v1))
  (rpcId
   [_ peer_id method v1 v2]
   ((clojure.core/get m4128 :rpc-id) peer_id method v1 v2))
  (rpcId
   [_ peer_id method v1 v2 v3]
   ((clojure.core/get m4128 :rpc-id) peer_id method v1 v2 v3))
  (rpcId
   [_ peer_id method v1 v2 v3 v4]
   ((clojure.core/get m4128 :rpc-id) peer_id method v1 v2 v3 v4))
  (rpcId
   [_ peer_id method v1 v2 v3 v4 v5]
   ((clojure.core/get m4128 :rpc-id) peer_id method v1 v2 v3 v4 v5))
  (rpcUnreliable
   [_ method]
   ((clojure.core/get m4128 :rpc-unreliable) method))
  (rpcUnreliable
   [_ method v1]
   ((clojure.core/get m4128 :rpc-unreliable) method v1))
  (rpcUnreliable
   [_ method v1 v2]
   ((clojure.core/get m4128 :rpc-unreliable) method v1 v2))
  (rpcUnreliable
   [_ method v1 v2 v3]
   ((clojure.core/get m4128 :rpc-unreliable) method v1 v2 v3))
  (rpcUnreliable
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4128 :rpc-unreliable) method v1 v2 v3 v4))
  (rpcUnreliable
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4128 :rpc-unreliable) method v1 v2 v3 v4 v5))
  (rpcUnreliableId
   [_ peer_id method]
   ((clojure.core/get m4128 :rpc-unreliable-id) peer_id method))
  (rpcUnreliableId
   [_ peer_id method v1]
   ((clojure.core/get m4128 :rpc-unreliable-id) peer_id method v1))
  (rpcUnreliableId
   [_ peer_id method v1 v2]
   ((clojure.core/get m4128 :rpc-unreliable-id) peer_id method v1 v2))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3]
   ((clojure.core/get m4128 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3 v4]
   ((clojure.core/get m4128 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3
    v4))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3 v4 v5]
   ((clojure.core/get m4128 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3
    v4
    v5))
  (rset
   [_ property value]
   ((clojure.core/get m4128 :rset) property value))
  (rsetConfig
   [_ property mode]
   ((clojure.core/get m4128 :rset-config) property mode))
  (rsetId
   [_ peer_id property value]
   ((clojure.core/get m4128 :rset-id) peer_id property value))
  (rsetUnreliable
   [_ property value]
   ((clojure.core/get m4128 :rset-unreliable) property value))
  (rsetUnreliableId
   [_ peer_id property value]
   ((clojure.core/get m4128 :rset-unreliable-id)
    peer_id
    property
    value))
  (setCustomMultiplayer
   [_ api]
   ((clojure.core/get m4128 :set-custom-multiplayer) api))
  (setDisplayFolded
   [_ fold]
   ((clojure.core/get m4128 :set-display-folded) fold))
  (setFilename
   [_ filename]
   ((clojure.core/get m4128 :set-filename) filename))
  (setName [_ name] ((clojure.core/get m4128 :set-name) name))
  (setNetworkMaster
   [_ id]
   ((clojure.core/get m4128 :set-network-master) id))
  (setNetworkMaster
   [_ id recursive]
   ((clojure.core/get m4128 :set-network-master) id recursive))
  (setOwner [_ owner] ((clojure.core/get m4128 :set-owner) owner))
  (setPauseMode
   [_ mode]
   ((clojure.core/get m4128 :set-pause-mode) mode))
  (setPhysicsProcess
   [_ enable]
   ((clojure.core/get m4128 :set-physics-process) enable))
  (setPhysicsProcessInternal
   [_ enable]
   ((clojure.core/get m4128 :set-physics-process-internal) enable))
  (setProcess
   [_ enable]
   ((clojure.core/get m4128 :set-process) enable))
  (setProcessInput
   [_ enable]
   ((clojure.core/get m4128 :set-process-input) enable))
  (setProcessInternal
   [_ enable]
   ((clojure.core/get m4128 :set-process-internal) enable))
  (setProcessPriority
   [_ priority]
   ((clojure.core/get m4128 :set-process-priority) priority))
  (setProcessUnhandledInput
   [_ enable]
   ((clojure.core/get m4128 :set-process-unhandled-input) enable))
  (setProcessUnhandledKeyInput
   [_ enable]
   ((clojure.core/get m4128 :set-process-unhandled-key-input) enable))
  (setSceneInstanceLoadPlaceholder
   [_ load_placeholder]
   ((clojure.core/get m4128 :set-scene-instance-load-placeholder)
    load_placeholder))
  (updateConfigurationWarning
   [_]
   ((clojure.core/get m4128 :update-configuration-warning))))
(deftype GodotCanvasItem
  [m4129]
  proto/ToVariant
  (->variant [this] (proto/->variant m4129))
  clojure.lang.ILookup
  (valAt [_ k] (get m4129 k))
  godotclj.api.gdscript.IGodotCanvasItem
  (addUserSignal
   [_ signal]
   ((clojure.core/get m4129 :add-user-signal) signal))
  (addUserSignal
   [_ signal arguments]
   ((clojure.core/get m4129 :add-user-signal) signal arguments))
  (call [_ method] ((clojure.core/get m4129 :call) method))
  (call [_ method v1] ((clojure.core/get m4129 :call) method v1))
  (call
   [_ method v1 v2]
   ((clojure.core/get m4129 :call) method v1 v2))
  (call
   [_ method v1 v2 v3]
   ((clojure.core/get m4129 :call) method v1 v2 v3))
  (call
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4129 :call) method v1 v2 v3 v4))
  (call
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4129 :call) method v1 v2 v3 v4 v5))
  (callDeferred
   [_ method]
   ((clojure.core/get m4129 :call-deferred) method))
  (callDeferred
   [_ method v1]
   ((clojure.core/get m4129 :call-deferred) method v1))
  (callDeferred
   [_ method v1 v2]
   ((clojure.core/get m4129 :call-deferred) method v1 v2))
  (callDeferred
   [_ method v1 v2 v3]
   ((clojure.core/get m4129 :call-deferred) method v1 v2 v3))
  (callDeferred
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4129 :call-deferred) method v1 v2 v3 v4))
  (callDeferred
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4129 :call-deferred) method v1 v2 v3 v4 v5))
  (callv
   [_ method arg_array]
   ((clojure.core/get m4129 :callv) method arg_array))
  (canTranslateMessages
   [_]
   ((clojure.core/get m4129 :can-translate-messages)))
  (connect
   [_ signal target method]
   ((clojure.core/get m4129 :connect) signal target method))
  (connect
   [_ signal target method binds]
   ((clojure.core/get m4129 :connect) signal target method binds))
  (connect
   [_ signal target method binds flags]
   ((clojure.core/get m4129 :connect)
    signal
    target
    method
    binds
    flags))
  (disconnect
   [_ signal target method]
   ((clojure.core/get m4129 :disconnect) signal target method))
  (emitSignal
   [_ signal]
   ((clojure.core/get m4129 :emit-signal) signal))
  (emitSignal
   [_ signal v1]
   ((clojure.core/get m4129 :emit-signal) signal v1))
  (emitSignal
   [_ signal v1 v2]
   ((clojure.core/get m4129 :emit-signal) signal v1 v2))
  (emitSignal
   [_ signal v1 v2 v3]
   ((clojure.core/get m4129 :emit-signal) signal v1 v2 v3))
  (emitSignal
   [_ signal v1 v2 v3 v4]
   ((clojure.core/get m4129 :emit-signal) signal v1 v2 v3 v4))
  (emitSignal
   [_ signal v1 v2 v3 v4 v5]
   ((clojure.core/get m4129 :emit-signal) signal v1 v2 v3 v4 v5))
  (free [_] ((clojure.core/get m4129 :free)))
  (get [_ property] ((clojure.core/get m4129 :get) property))
  (getClass [_] ((clojure.core/get m4129 :get-class)))
  (getIncomingConnections
   [_]
   ((clojure.core/get m4129 :get-incoming-connections)))
  (getIndexed
   [_ property]
   ((clojure.core/get m4129 :get-indexed) property))
  (getInstanceId [_] ((clojure.core/get m4129 :get-instance-id)))
  (getMeta [_ name] ((clojure.core/get m4129 :get-meta) name))
  (getMetaList [_] ((clojure.core/get m4129 :get-meta-list)))
  (getMethodList [_] ((clojure.core/get m4129 :get-method-list)))
  (getPropertyList [_] ((clojure.core/get m4129 :get-property-list)))
  (getScript [_] ((clojure.core/get m4129 :get-script)))
  (getSignalConnectionList
   [_ signal]
   ((clojure.core/get m4129 :get-signal-connection-list) signal))
  (getSignalList [_] ((clojure.core/get m4129 :get-signal-list)))
  (hasMeta [_ name] ((clojure.core/get m4129 :has-meta) name))
  (hasMethod [_ method] ((clojure.core/get m4129 :has-method) method))
  (hasSignal [_ signal] ((clojure.core/get m4129 :has-signal) signal))
  (hasUserSignal
   [_ signal]
   ((clojure.core/get m4129 :has-user-signal) signal))
  (isBlockingSignals
   [_]
   ((clojure.core/get m4129 :is-blocking-signals)))
  (isClass [_ class] ((clojure.core/get m4129 :is-class) class))
  (isConnected
   [_ signal target method]
   ((clojure.core/get m4129 :is-connected) signal target method))
  (isQueuedForDeletion
   [_]
   ((clojure.core/get m4129 :is-queued-for-deletion)))
  (notification
   [_ what]
   ((clojure.core/get m4129 :notification) what))
  (notification
   [_ what reversed]
   ((clojure.core/get m4129 :notification) what reversed))
  (propertyListChangedNotify
   [_]
   ((clojure.core/get m4129 :property-list-changed-notify)))
  (removeMeta [_ name] ((clojure.core/get m4129 :remove-meta) name))
  (set
   [_ property value]
   ((clojure.core/get m4129 :set) property value))
  (setBlockSignals
   [_ enable]
   ((clojure.core/get m4129 :set-block-signals) enable))
  (setDeferred
   [_ property value]
   ((clojure.core/get m4129 :set-deferred) property value))
  (setIndexed
   [_ property value]
   ((clojure.core/get m4129 :set-indexed) property value))
  (setMessageTranslation
   [_ enable]
   ((clojure.core/get m4129 :set-message-translation) enable))
  (setMeta
   [_ name value]
   ((clojure.core/get m4129 :set-meta) name value))
  (setScript [_ script] ((clojure.core/get m4129 :set-script) script))
  (tr [_ message] ((clojure.core/get m4129 :tr) message))
  (addChild [_ node] ((clojure.core/get m4129 :add-child) node))
  (addChild
   [_ node legible_unique_name]
   ((clojure.core/get m4129 :add-child) node legible_unique_name))
  (addChildBelowNode
   [_ node child_node]
   ((clojure.core/get m4129 :add-child-below-node) node child_node))
  (addChildBelowNode
   [_ node child_node legible_unique_name]
   ((clojure.core/get m4129 :add-child-below-node)
    node
    child_node
    legible_unique_name))
  (addToGroup
   [_ group]
   ((clojure.core/get m4129 :add-to-group) group))
  (addToGroup
   [_ group persistent]
   ((clojure.core/get m4129 :add-to-group) group persistent))
  (canProcess [_] ((clojure.core/get m4129 :can-process)))
  (duplicate [_] ((clojure.core/get m4129 :duplicate)))
  (duplicate [_ flags] ((clojure.core/get m4129 :duplicate) flags))
  (findNode [_ mask] ((clojure.core/get m4129 :find-node) mask))
  (findNode
   [_ mask recursive]
   ((clojure.core/get m4129 :find-node) mask recursive))
  (findNode
   [_ mask recursive owned]
   ((clojure.core/get m4129 :find-node) mask recursive owned))
  (findParent [_ mask] ((clojure.core/get m4129 :find-parent) mask))
  (getChild [_ idx] ((clojure.core/get m4129 :get-child) idx))
  (getChildCount [_] ((clojure.core/get m4129 :get-child-count)))
  (getChildren [_] ((clojure.core/get m4129 :get-children)))
  (getCustomMultiplayer
   [_]
   ((clojure.core/get m4129 :get-custom-multiplayer)))
  (getFilename [_] ((clojure.core/get m4129 :get-filename)))
  (getGroups [_] ((clojure.core/get m4129 :get-groups)))
  (getIndex [_] ((clojure.core/get m4129 :get-index)))
  (getMultiplayer [_] ((clojure.core/get m4129 :get-multiplayer)))
  (getName [_] ((clojure.core/get m4129 :get-name)))
  (getNetworkMaster
   [_]
   ((clojure.core/get m4129 :get-network-master)))
  (getNode [_ path] ((clojure.core/get m4129 :get-node) path))
  (getNodeAndResource
   [_ path]
   ((clojure.core/get m4129 :get-node-and-resource) path))
  (getNodeOrNull
   [_ path]
   ((clojure.core/get m4129 :get-node-or-null) path))
  (getOwner [_] ((clojure.core/get m4129 :get-owner)))
  (getParent [_] ((clojure.core/get m4129 :get-parent)))
  (getPath [_] ((clojure.core/get m4129 :get-path)))
  (getPathTo [_ node] ((clojure.core/get m4129 :get-path-to) node))
  (getPauseMode [_] ((clojure.core/get m4129 :get-pause-mode)))
  (getPhysicsProcessDeltaTime
   [_]
   ((clojure.core/get m4129 :get-physics-process-delta-time)))
  (getPositionInParent
   [_]
   ((clojure.core/get m4129 :get-position-in-parent)))
  (getProcessDeltaTime
   [_]
   ((clojure.core/get m4129 :get-process-delta-time)))
  (getProcessPriority
   [_]
   ((clojure.core/get m4129 :get-process-priority)))
  (getSceneInstanceLoadPlaceholder
   [_]
   ((clojure.core/get m4129 :get-scene-instance-load-placeholder)))
  (getTree [_] ((clojure.core/get m4129 :get-tree)))
  (getViewport [_] ((clojure.core/get m4129 :get-viewport)))
  (hasNode [_ path] ((clojure.core/get m4129 :has-node) path))
  (hasNodeAndResource
   [_ path]
   ((clojure.core/get m4129 :has-node-and-resource) path))
  (isAParentOf
   [_ node]
   ((clojure.core/get m4129 :is-a-parent-of) node))
  (isDisplayedFolded
   [_]
   ((clojure.core/get m4129 :is-displayed-folded)))
  (isGreaterThan
   [_ node]
   ((clojure.core/get m4129 :is-greater-than) node))
  (isInGroup [_ group] ((clojure.core/get m4129 :is-in-group) group))
  (isInsideTree [_] ((clojure.core/get m4129 :is-inside-tree)))
  (isNetworkMaster [_] ((clojure.core/get m4129 :is-network-master)))
  (isPhysicsProcessing
   [_]
   ((clojure.core/get m4129 :is-physics-processing)))
  (isPhysicsProcessingInternal
   [_]
   ((clojure.core/get m4129 :is-physics-processing-internal)))
  (isProcessing [_] ((clojure.core/get m4129 :is-processing)))
  (isProcessingInput
   [_]
   ((clojure.core/get m4129 :is-processing-input)))
  (isProcessingInternal
   [_]
   ((clojure.core/get m4129 :is-processing-internal)))
  (isProcessingUnhandledInput
   [_]
   ((clojure.core/get m4129 :is-processing-unhandled-input)))
  (isProcessingUnhandledKeyInput
   [_]
   ((clojure.core/get m4129 :is-processing-unhandled-key-input)))
  (moveChild
   [_ child_node to_position]
   ((clojure.core/get m4129 :move-child) child_node to_position))
  (printStrayNodes [_] ((clojure.core/get m4129 :print-stray-nodes)))
  (printTree [_] ((clojure.core/get m4129 :print-tree)))
  (printTreePretty [_] ((clojure.core/get m4129 :print-tree-pretty)))
  (propagateCall
   [_ method]
   ((clojure.core/get m4129 :propagate-call) method))
  (propagateCall
   [_ method args]
   ((clojure.core/get m4129 :propagate-call) method args))
  (propagateCall
   [_ method args parent_first]
   ((clojure.core/get m4129 :propagate-call) method args parent_first))
  (propagateNotification
   [_ what]
   ((clojure.core/get m4129 :propagate-notification) what))
  (queueFree [_] ((clojure.core/get m4129 :queue-free)))
  (raise [_] ((clojure.core/get m4129 :raise)))
  (removeAndSkip [_] ((clojure.core/get m4129 :remove-and-skip)))
  (removeChild [_ node] ((clojure.core/get m4129 :remove-child) node))
  (removeFromGroup
   [_ group]
   ((clojure.core/get m4129 :remove-from-group) group))
  (replaceBy [_ node] ((clojure.core/get m4129 :replace-by) node))
  (replaceBy
   [_ node keep_data]
   ((clojure.core/get m4129 :replace-by) node keep_data))
  (requestReady [_] ((clojure.core/get m4129 :request-ready)))
  (rpc [_ method] ((clojure.core/get m4129 :rpc) method))
  (rpc [_ method v1] ((clojure.core/get m4129 :rpc) method v1))
  (rpc [_ method v1 v2] ((clojure.core/get m4129 :rpc) method v1 v2))
  (rpc
   [_ method v1 v2 v3]
   ((clojure.core/get m4129 :rpc) method v1 v2 v3))
  (rpc
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4129 :rpc) method v1 v2 v3 v4))
  (rpc
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4129 :rpc) method v1 v2 v3 v4 v5))
  (rpcConfig
   [_ method mode]
   ((clojure.core/get m4129 :rpc-config) method mode))
  (rpcId
   [_ peer_id method]
   ((clojure.core/get m4129 :rpc-id) peer_id method))
  (rpcId
   [_ peer_id method v1]
   ((clojure.core/get m4129 :rpc-id) peer_id method v1))
  (rpcId
   [_ peer_id method v1 v2]
   ((clojure.core/get m4129 :rpc-id) peer_id method v1 v2))
  (rpcId
   [_ peer_id method v1 v2 v3]
   ((clojure.core/get m4129 :rpc-id) peer_id method v1 v2 v3))
  (rpcId
   [_ peer_id method v1 v2 v3 v4]
   ((clojure.core/get m4129 :rpc-id) peer_id method v1 v2 v3 v4))
  (rpcId
   [_ peer_id method v1 v2 v3 v4 v5]
   ((clojure.core/get m4129 :rpc-id) peer_id method v1 v2 v3 v4 v5))
  (rpcUnreliable
   [_ method]
   ((clojure.core/get m4129 :rpc-unreliable) method))
  (rpcUnreliable
   [_ method v1]
   ((clojure.core/get m4129 :rpc-unreliable) method v1))
  (rpcUnreliable
   [_ method v1 v2]
   ((clojure.core/get m4129 :rpc-unreliable) method v1 v2))
  (rpcUnreliable
   [_ method v1 v2 v3]
   ((clojure.core/get m4129 :rpc-unreliable) method v1 v2 v3))
  (rpcUnreliable
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4129 :rpc-unreliable) method v1 v2 v3 v4))
  (rpcUnreliable
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4129 :rpc-unreliable) method v1 v2 v3 v4 v5))
  (rpcUnreliableId
   [_ peer_id method]
   ((clojure.core/get m4129 :rpc-unreliable-id) peer_id method))
  (rpcUnreliableId
   [_ peer_id method v1]
   ((clojure.core/get m4129 :rpc-unreliable-id) peer_id method v1))
  (rpcUnreliableId
   [_ peer_id method v1 v2]
   ((clojure.core/get m4129 :rpc-unreliable-id) peer_id method v1 v2))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3]
   ((clojure.core/get m4129 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3 v4]
   ((clojure.core/get m4129 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3
    v4))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3 v4 v5]
   ((clojure.core/get m4129 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3
    v4
    v5))
  (rset
   [_ property value]
   ((clojure.core/get m4129 :rset) property value))
  (rsetConfig
   [_ property mode]
   ((clojure.core/get m4129 :rset-config) property mode))
  (rsetId
   [_ peer_id property value]
   ((clojure.core/get m4129 :rset-id) peer_id property value))
  (rsetUnreliable
   [_ property value]
   ((clojure.core/get m4129 :rset-unreliable) property value))
  (rsetUnreliableId
   [_ peer_id property value]
   ((clojure.core/get m4129 :rset-unreliable-id)
    peer_id
    property
    value))
  (setCustomMultiplayer
   [_ api]
   ((clojure.core/get m4129 :set-custom-multiplayer) api))
  (setDisplayFolded
   [_ fold]
   ((clojure.core/get m4129 :set-display-folded) fold))
  (setFilename
   [_ filename]
   ((clojure.core/get m4129 :set-filename) filename))
  (setName [_ name] ((clojure.core/get m4129 :set-name) name))
  (setNetworkMaster
   [_ id]
   ((clojure.core/get m4129 :set-network-master) id))
  (setNetworkMaster
   [_ id recursive]
   ((clojure.core/get m4129 :set-network-master) id recursive))
  (setOwner [_ owner] ((clojure.core/get m4129 :set-owner) owner))
  (setPauseMode
   [_ mode]
   ((clojure.core/get m4129 :set-pause-mode) mode))
  (setPhysicsProcess
   [_ enable]
   ((clojure.core/get m4129 :set-physics-process) enable))
  (setPhysicsProcessInternal
   [_ enable]
   ((clojure.core/get m4129 :set-physics-process-internal) enable))
  (setProcess
   [_ enable]
   ((clojure.core/get m4129 :set-process) enable))
  (setProcessInput
   [_ enable]
   ((clojure.core/get m4129 :set-process-input) enable))
  (setProcessInternal
   [_ enable]
   ((clojure.core/get m4129 :set-process-internal) enable))
  (setProcessPriority
   [_ priority]
   ((clojure.core/get m4129 :set-process-priority) priority))
  (setProcessUnhandledInput
   [_ enable]
   ((clojure.core/get m4129 :set-process-unhandled-input) enable))
  (setProcessUnhandledKeyInput
   [_ enable]
   ((clojure.core/get m4129 :set-process-unhandled-key-input) enable))
  (setSceneInstanceLoadPlaceholder
   [_ load_placeholder]
   ((clojure.core/get m4129 :set-scene-instance-load-placeholder)
    load_placeholder))
  (updateConfigurationWarning
   [_]
   ((clojure.core/get m4129 :update-configuration-warning)))
  (drawArc
   [_ center radius start_angle end_angle point_count color]
   ((clojure.core/get m4129 :draw-arc)
    center
    radius
    start_angle
    end_angle
    point_count
    color))
  (drawArc
   [_ center radius start_angle end_angle point_count color width]
   ((clojure.core/get m4129 :draw-arc)
    center
    radius
    start_angle
    end_angle
    point_count
    color
    width))
  (drawArc
   [_
    center
    radius
    start_angle
    end_angle
    point_count
    color
    width
    antialiased]
   ((clojure.core/get m4129 :draw-arc)
    center
    radius
    start_angle
    end_angle
    point_count
    color
    width
    antialiased))
  (drawChar
   [_ font position char next]
   ((clojure.core/get m4129 :draw-char) font position char next))
  (drawChar
   [_ font position char next modulate]
   ((clojure.core/get m4129 :draw-char)
    font
    position
    char
    next
    modulate))
  (drawCircle
   [_ position radius color]
   ((clojure.core/get m4129 :draw-circle) position radius color))
  (drawColoredPolygon
   [_ points color]
   ((clojure.core/get m4129 :draw-colored-polygon) points color))
  (drawColoredPolygon
   [_ points color uvs]
   ((clojure.core/get m4129 :draw-colored-polygon) points color uvs))
  (drawColoredPolygon
   [_ points color uvs texture]
   ((clojure.core/get m4129 :draw-colored-polygon)
    points
    color
    uvs
    texture))
  (drawColoredPolygon
   [_ points color uvs texture normal_map]
   ((clojure.core/get m4129 :draw-colored-polygon)
    points
    color
    uvs
    texture
    normal_map))
  (drawColoredPolygon
   [_ points color uvs texture normal_map antialiased]
   ((clojure.core/get m4129 :draw-colored-polygon)
    points
    color
    uvs
    texture
    normal_map
    antialiased))
  (drawLine
   [_ from to color]
   ((clojure.core/get m4129 :draw-line) from to color))
  (drawLine
   [_ from to color width]
   ((clojure.core/get m4129 :draw-line) from to color width))
  (drawLine
   [_ from to color width antialiased]
   ((clojure.core/get m4129 :draw-line)
    from
    to
    color
    width
    antialiased))
  (drawMesh
   [_ mesh texture]
   ((clojure.core/get m4129 :draw-mesh) mesh texture))
  (drawMesh
   [_ mesh texture normal_map]
   ((clojure.core/get m4129 :draw-mesh) mesh texture normal_map))
  (drawMesh
   [_ mesh texture normal_map transform]
   ((clojure.core/get m4129 :draw-mesh)
    mesh
    texture
    normal_map
    transform))
  (drawMesh
   [_ mesh texture normal_map transform modulate]
   ((clojure.core/get m4129 :draw-mesh)
    mesh
    texture
    normal_map
    transform
    modulate))
  (drawMultiline
   [_ points color]
   ((clojure.core/get m4129 :draw-multiline) points color))
  (drawMultiline
   [_ points color width]
   ((clojure.core/get m4129 :draw-multiline) points color width))
  (drawMultiline
   [_ points color width antialiased]
   ((clojure.core/get m4129 :draw-multiline)
    points
    color
    width
    antialiased))
  (drawMultilineColors
   [_ points colors]
   ((clojure.core/get m4129 :draw-multiline-colors) points colors))
  (drawMultilineColors
   [_ points colors width]
   ((clojure.core/get m4129 :draw-multiline-colors)
    points
    colors
    width))
  (drawMultilineColors
   [_ points colors width antialiased]
   ((clojure.core/get m4129 :draw-multiline-colors)
    points
    colors
    width
    antialiased))
  (drawMultimesh
   [_ multimesh texture]
   ((clojure.core/get m4129 :draw-multimesh) multimesh texture))
  (drawMultimesh
   [_ multimesh texture normal_map]
   ((clojure.core/get m4129 :draw-multimesh)
    multimesh
    texture
    normal_map))
  (drawPolygon
   [_ points colors]
   ((clojure.core/get m4129 :draw-polygon) points colors))
  (drawPolygon
   [_ points colors uvs]
   ((clojure.core/get m4129 :draw-polygon) points colors uvs))
  (drawPolygon
   [_ points colors uvs texture]
   ((clojure.core/get m4129 :draw-polygon) points colors uvs texture))
  (drawPolygon
   [_ points colors uvs texture normal_map]
   ((clojure.core/get m4129 :draw-polygon)
    points
    colors
    uvs
    texture
    normal_map))
  (drawPolygon
   [_ points colors uvs texture normal_map antialiased]
   ((clojure.core/get m4129 :draw-polygon)
    points
    colors
    uvs
    texture
    normal_map
    antialiased))
  (drawPolyline
   [_ points color]
   ((clojure.core/get m4129 :draw-polyline) points color))
  (drawPolyline
   [_ points color width]
   ((clojure.core/get m4129 :draw-polyline) points color width))
  (drawPolyline
   [_ points color width antialiased]
   ((clojure.core/get m4129 :draw-polyline)
    points
    color
    width
    antialiased))
  (drawPolylineColors
   [_ points colors]
   ((clojure.core/get m4129 :draw-polyline-colors) points colors))
  (drawPolylineColors
   [_ points colors width]
   ((clojure.core/get m4129 :draw-polyline-colors)
    points
    colors
    width))
  (drawPolylineColors
   [_ points colors width antialiased]
   ((clojure.core/get m4129 :draw-polyline-colors)
    points
    colors
    width
    antialiased))
  (drawPrimitive
   [_ points colors uvs]
   ((clojure.core/get m4129 :draw-primitive) points colors uvs))
  (drawPrimitive
   [_ points colors uvs texture]
   ((clojure.core/get m4129 :draw-primitive)
    points
    colors
    uvs
    texture))
  (drawPrimitive
   [_ points colors uvs texture width]
   ((clojure.core/get m4129 :draw-primitive)
    points
    colors
    uvs
    texture
    width))
  (drawPrimitive
   [_ points colors uvs texture width normal_map]
   ((clojure.core/get m4129 :draw-primitive)
    points
    colors
    uvs
    texture
    width
    normal_map))
  (drawRect
   [_ rect color]
   ((clojure.core/get m4129 :draw-rect) rect color))
  (drawRect
   [_ rect color filled]
   ((clojure.core/get m4129 :draw-rect) rect color filled))
  (drawRect
   [_ rect color filled width]
   ((clojure.core/get m4129 :draw-rect) rect color filled width))
  (drawRect
   [_ rect color filled width antialiased]
   ((clojure.core/get m4129 :draw-rect)
    rect
    color
    filled
    width
    antialiased))
  (drawSetTransform
   [_ position rotation scale]
   ((clojure.core/get m4129 :draw-set-transform)
    position
    rotation
    scale))
  (drawSetTransformMatrix
   [_ xform]
   ((clojure.core/get m4129 :draw-set-transform-matrix) xform))
  (drawString
   [_ font position text]
   ((clojure.core/get m4129 :draw-string) font position text))
  (drawString
   [_ font position text modulate]
   ((clojure.core/get m4129 :draw-string) font position text modulate))
  (drawString
   [_ font position text modulate clip_w]
   ((clojure.core/get m4129 :draw-string)
    font
    position
    text
    modulate
    clip_w))
  (drawStyleBox
   [_ style_box rect]
   ((clojure.core/get m4129 :draw-style-box) style_box rect))
  (drawTexture
   [_ texture position]
   ((clojure.core/get m4129 :draw-texture) texture position))
  (drawTexture
   [_ texture position modulate]
   ((clojure.core/get m4129 :draw-texture) texture position modulate))
  (drawTexture
   [_ texture position modulate normal_map]
   ((clojure.core/get m4129 :draw-texture)
    texture
    position
    modulate
    normal_map))
  (drawTextureRect
   [_ texture rect tile]
   ((clojure.core/get m4129 :draw-texture-rect) texture rect tile))
  (drawTextureRect
   [_ texture rect tile modulate]
   ((clojure.core/get m4129 :draw-texture-rect)
    texture
    rect
    tile
    modulate))
  (drawTextureRect
   [_ texture rect tile modulate transpose]
   ((clojure.core/get m4129 :draw-texture-rect)
    texture
    rect
    tile
    modulate
    transpose))
  (drawTextureRect
   [_ texture rect tile modulate transpose normal_map]
   ((clojure.core/get m4129 :draw-texture-rect)
    texture
    rect
    tile
    modulate
    transpose
    normal_map))
  (drawTextureRectRegion
   [_ texture rect src_rect]
   ((clojure.core/get m4129 :draw-texture-rect-region)
    texture
    rect
    src_rect))
  (drawTextureRectRegion
   [_ texture rect src_rect modulate]
   ((clojure.core/get m4129 :draw-texture-rect-region)
    texture
    rect
    src_rect
    modulate))
  (drawTextureRectRegion
   [_ texture rect src_rect modulate transpose]
   ((clojure.core/get m4129 :draw-texture-rect-region)
    texture
    rect
    src_rect
    modulate
    transpose))
  (drawTextureRectRegion
   [_ texture rect src_rect modulate transpose normal_map]
   ((clojure.core/get m4129 :draw-texture-rect-region)
    texture
    rect
    src_rect
    modulate
    transpose
    normal_map))
  (drawTextureRectRegion
   [_ texture rect src_rect modulate transpose normal_map clip_uv]
   ((clojure.core/get m4129 :draw-texture-rect-region)
    texture
    rect
    src_rect
    modulate
    transpose
    normal_map
    clip_uv))
  (forceUpdateTransform
   [_]
   ((clojure.core/get m4129 :force-update-transform)))
  (getCanvas [_] ((clojure.core/get m4129 :get-canvas)))
  (getCanvasItem [_] ((clojure.core/get m4129 :get-canvas-item)))
  (getCanvasTransform
   [_]
   ((clojure.core/get m4129 :get-canvas-transform)))
  (getGlobalMousePosition
   [_]
   ((clojure.core/get m4129 :get-global-mouse-position)))
  (getGlobalTransform
   [_]
   ((clojure.core/get m4129 :get-global-transform)))
  (getGlobalTransformWithCanvas
   [_]
   ((clojure.core/get m4129 :get-global-transform-with-canvas)))
  (getLightMask [_] ((clojure.core/get m4129 :get-light-mask)))
  (getLocalMousePosition
   [_]
   ((clojure.core/get m4129 :get-local-mouse-position)))
  (getMaterial [_] ((clojure.core/get m4129 :get-material)))
  (getModulate [_] ((clojure.core/get m4129 :get-modulate)))
  (getSelfModulate [_] ((clojure.core/get m4129 :get-self-modulate)))
  (getTransform [_] ((clojure.core/get m4129 :get-transform)))
  (getUseParentMaterial
   [_]
   ((clojure.core/get m4129 :get-use-parent-material)))
  (getViewportRect [_] ((clojure.core/get m4129 :get-viewport-rect)))
  (getViewportTransform
   [_]
   ((clojure.core/get m4129 :get-viewport-transform)))
  (getWorld2d [_] ((clojure.core/get m4129 :get-world-2d)))
  (hide [_] ((clojure.core/get m4129 :hide)))
  (isDrawBehindParentEnabled
   [_]
   ((clojure.core/get m4129 :is-draw-behind-parent-enabled)))
  (isLocalTransformNotificationEnabled
   [_]
   ((clojure.core/get m4129 :is-local-transform-notification-enabled)))
  (isSetAsToplevel [_] ((clojure.core/get m4129 :is-set-as-toplevel)))
  (isTransformNotificationEnabled
   [_]
   ((clojure.core/get m4129 :is-transform-notification-enabled)))
  (isVisible [_] ((clojure.core/get m4129 :is-visible)))
  (isVisibleInTree [_] ((clojure.core/get m4129 :is-visible-in-tree)))
  (makeCanvasPositionLocal
   [_ screen_point]
   ((clojure.core/get m4129 :make-canvas-position-local) screen_point))
  (makeInputLocal
   [_ event]
   ((clojure.core/get m4129 :make-input-local) event))
  (setAsToplevel
   [_ enable]
   ((clojure.core/get m4129 :set-as-toplevel) enable))
  (setDrawBehindParent
   [_ enable]
   ((clojure.core/get m4129 :set-draw-behind-parent) enable))
  (setLightMask
   [_ light_mask]
   ((clojure.core/get m4129 :set-light-mask) light_mask))
  (setMaterial
   [_ material]
   ((clojure.core/get m4129 :set-material) material))
  (setModulate
   [_ modulate]
   ((clojure.core/get m4129 :set-modulate) modulate))
  (setNotifyLocalTransform
   [_ enable]
   ((clojure.core/get m4129 :set-notify-local-transform) enable))
  (setNotifyTransform
   [_ enable]
   ((clojure.core/get m4129 :set-notify-transform) enable))
  (setSelfModulate
   [_ self_modulate]
   ((clojure.core/get m4129 :set-self-modulate) self_modulate))
  (setUseParentMaterial
   [_ enable]
   ((clojure.core/get m4129 :set-use-parent-material) enable))
  (setVisible
   [_ visible]
   ((clojure.core/get m4129 :set-visible) visible))
  (show [_] ((clojure.core/get m4129 :show)))
  (update [_] ((clojure.core/get m4129 :update))))
(deftype GodotControl
  [m4130]
  proto/ToVariant
  (->variant [this] (proto/->variant m4130))
  clojure.lang.ILookup
  (valAt [_ k] (get m4130 k))
  godotclj.api.gdscript.IGodotControl
  (addUserSignal
   [_ signal]
   ((clojure.core/get m4130 :add-user-signal) signal))
  (addUserSignal
   [_ signal arguments]
   ((clojure.core/get m4130 :add-user-signal) signal arguments))
  (call [_ method] ((clojure.core/get m4130 :call) method))
  (call [_ method v1] ((clojure.core/get m4130 :call) method v1))
  (call
   [_ method v1 v2]
   ((clojure.core/get m4130 :call) method v1 v2))
  (call
   [_ method v1 v2 v3]
   ((clojure.core/get m4130 :call) method v1 v2 v3))
  (call
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4130 :call) method v1 v2 v3 v4))
  (call
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4130 :call) method v1 v2 v3 v4 v5))
  (callDeferred
   [_ method]
   ((clojure.core/get m4130 :call-deferred) method))
  (callDeferred
   [_ method v1]
   ((clojure.core/get m4130 :call-deferred) method v1))
  (callDeferred
   [_ method v1 v2]
   ((clojure.core/get m4130 :call-deferred) method v1 v2))
  (callDeferred
   [_ method v1 v2 v3]
   ((clojure.core/get m4130 :call-deferred) method v1 v2 v3))
  (callDeferred
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4130 :call-deferred) method v1 v2 v3 v4))
  (callDeferred
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4130 :call-deferred) method v1 v2 v3 v4 v5))
  (callv
   [_ method arg_array]
   ((clojure.core/get m4130 :callv) method arg_array))
  (canTranslateMessages
   [_]
   ((clojure.core/get m4130 :can-translate-messages)))
  (connect
   [_ signal target method]
   ((clojure.core/get m4130 :connect) signal target method))
  (connect
   [_ signal target method binds]
   ((clojure.core/get m4130 :connect) signal target method binds))
  (connect
   [_ signal target method binds flags]
   ((clojure.core/get m4130 :connect)
    signal
    target
    method
    binds
    flags))
  (disconnect
   [_ signal target method]
   ((clojure.core/get m4130 :disconnect) signal target method))
  (emitSignal
   [_ signal]
   ((clojure.core/get m4130 :emit-signal) signal))
  (emitSignal
   [_ signal v1]
   ((clojure.core/get m4130 :emit-signal) signal v1))
  (emitSignal
   [_ signal v1 v2]
   ((clojure.core/get m4130 :emit-signal) signal v1 v2))
  (emitSignal
   [_ signal v1 v2 v3]
   ((clojure.core/get m4130 :emit-signal) signal v1 v2 v3))
  (emitSignal
   [_ signal v1 v2 v3 v4]
   ((clojure.core/get m4130 :emit-signal) signal v1 v2 v3 v4))
  (emitSignal
   [_ signal v1 v2 v3 v4 v5]
   ((clojure.core/get m4130 :emit-signal) signal v1 v2 v3 v4 v5))
  (free [_] ((clojure.core/get m4130 :free)))
  (get [_ property] ((clojure.core/get m4130 :get) property))
  (getClass [_] ((clojure.core/get m4130 :get-class)))
  (getIncomingConnections
   [_]
   ((clojure.core/get m4130 :get-incoming-connections)))
  (getIndexed
   [_ property]
   ((clojure.core/get m4130 :get-indexed) property))
  (getInstanceId [_] ((clojure.core/get m4130 :get-instance-id)))
  (getMeta [_ name] ((clojure.core/get m4130 :get-meta) name))
  (getMetaList [_] ((clojure.core/get m4130 :get-meta-list)))
  (getMethodList [_] ((clojure.core/get m4130 :get-method-list)))
  (getPropertyList [_] ((clojure.core/get m4130 :get-property-list)))
  (getScript [_] ((clojure.core/get m4130 :get-script)))
  (getSignalConnectionList
   [_ signal]
   ((clojure.core/get m4130 :get-signal-connection-list) signal))
  (getSignalList [_] ((clojure.core/get m4130 :get-signal-list)))
  (hasMeta [_ name] ((clojure.core/get m4130 :has-meta) name))
  (hasMethod [_ method] ((clojure.core/get m4130 :has-method) method))
  (hasSignal [_ signal] ((clojure.core/get m4130 :has-signal) signal))
  (hasUserSignal
   [_ signal]
   ((clojure.core/get m4130 :has-user-signal) signal))
  (isBlockingSignals
   [_]
   ((clojure.core/get m4130 :is-blocking-signals)))
  (isClass [_ class] ((clojure.core/get m4130 :is-class) class))
  (isConnected
   [_ signal target method]
   ((clojure.core/get m4130 :is-connected) signal target method))
  (isQueuedForDeletion
   [_]
   ((clojure.core/get m4130 :is-queued-for-deletion)))
  (notification
   [_ what]
   ((clojure.core/get m4130 :notification) what))
  (notification
   [_ what reversed]
   ((clojure.core/get m4130 :notification) what reversed))
  (propertyListChangedNotify
   [_]
   ((clojure.core/get m4130 :property-list-changed-notify)))
  (removeMeta [_ name] ((clojure.core/get m4130 :remove-meta) name))
  (set
   [_ property value]
   ((clojure.core/get m4130 :set) property value))
  (setBlockSignals
   [_ enable]
   ((clojure.core/get m4130 :set-block-signals) enable))
  (setDeferred
   [_ property value]
   ((clojure.core/get m4130 :set-deferred) property value))
  (setIndexed
   [_ property value]
   ((clojure.core/get m4130 :set-indexed) property value))
  (setMessageTranslation
   [_ enable]
   ((clojure.core/get m4130 :set-message-translation) enable))
  (setMeta
   [_ name value]
   ((clojure.core/get m4130 :set-meta) name value))
  (setScript [_ script] ((clojure.core/get m4130 :set-script) script))
  (tr [_ message] ((clojure.core/get m4130 :tr) message))
  (addChild [_ node] ((clojure.core/get m4130 :add-child) node))
  (addChild
   [_ node legible_unique_name]
   ((clojure.core/get m4130 :add-child) node legible_unique_name))
  (addChildBelowNode
   [_ node child_node]
   ((clojure.core/get m4130 :add-child-below-node) node child_node))
  (addChildBelowNode
   [_ node child_node legible_unique_name]
   ((clojure.core/get m4130 :add-child-below-node)
    node
    child_node
    legible_unique_name))
  (addToGroup
   [_ group]
   ((clojure.core/get m4130 :add-to-group) group))
  (addToGroup
   [_ group persistent]
   ((clojure.core/get m4130 :add-to-group) group persistent))
  (canProcess [_] ((clojure.core/get m4130 :can-process)))
  (duplicate [_] ((clojure.core/get m4130 :duplicate)))
  (duplicate [_ flags] ((clojure.core/get m4130 :duplicate) flags))
  (findNode [_ mask] ((clojure.core/get m4130 :find-node) mask))
  (findNode
   [_ mask recursive]
   ((clojure.core/get m4130 :find-node) mask recursive))
  (findNode
   [_ mask recursive owned]
   ((clojure.core/get m4130 :find-node) mask recursive owned))
  (findParent [_ mask] ((clojure.core/get m4130 :find-parent) mask))
  (getChild [_ idx] ((clojure.core/get m4130 :get-child) idx))
  (getChildCount [_] ((clojure.core/get m4130 :get-child-count)))
  (getChildren [_] ((clojure.core/get m4130 :get-children)))
  (getCustomMultiplayer
   [_]
   ((clojure.core/get m4130 :get-custom-multiplayer)))
  (getFilename [_] ((clojure.core/get m4130 :get-filename)))
  (getGroups [_] ((clojure.core/get m4130 :get-groups)))
  (getIndex [_] ((clojure.core/get m4130 :get-index)))
  (getMultiplayer [_] ((clojure.core/get m4130 :get-multiplayer)))
  (getName [_] ((clojure.core/get m4130 :get-name)))
  (getNetworkMaster
   [_]
   ((clojure.core/get m4130 :get-network-master)))
  (getNode [_ path] ((clojure.core/get m4130 :get-node) path))
  (getNodeAndResource
   [_ path]
   ((clojure.core/get m4130 :get-node-and-resource) path))
  (getNodeOrNull
   [_ path]
   ((clojure.core/get m4130 :get-node-or-null) path))
  (getOwner [_] ((clojure.core/get m4130 :get-owner)))
  (getParent [_] ((clojure.core/get m4130 :get-parent)))
  (getPath [_] ((clojure.core/get m4130 :get-path)))
  (getPathTo [_ node] ((clojure.core/get m4130 :get-path-to) node))
  (getPauseMode [_] ((clojure.core/get m4130 :get-pause-mode)))
  (getPhysicsProcessDeltaTime
   [_]
   ((clojure.core/get m4130 :get-physics-process-delta-time)))
  (getPositionInParent
   [_]
   ((clojure.core/get m4130 :get-position-in-parent)))
  (getProcessDeltaTime
   [_]
   ((clojure.core/get m4130 :get-process-delta-time)))
  (getProcessPriority
   [_]
   ((clojure.core/get m4130 :get-process-priority)))
  (getSceneInstanceLoadPlaceholder
   [_]
   ((clojure.core/get m4130 :get-scene-instance-load-placeholder)))
  (getTree [_] ((clojure.core/get m4130 :get-tree)))
  (getViewport [_] ((clojure.core/get m4130 :get-viewport)))
  (hasNode [_ path] ((clojure.core/get m4130 :has-node) path))
  (hasNodeAndResource
   [_ path]
   ((clojure.core/get m4130 :has-node-and-resource) path))
  (isAParentOf
   [_ node]
   ((clojure.core/get m4130 :is-a-parent-of) node))
  (isDisplayedFolded
   [_]
   ((clojure.core/get m4130 :is-displayed-folded)))
  (isGreaterThan
   [_ node]
   ((clojure.core/get m4130 :is-greater-than) node))
  (isInGroup [_ group] ((clojure.core/get m4130 :is-in-group) group))
  (isInsideTree [_] ((clojure.core/get m4130 :is-inside-tree)))
  (isNetworkMaster [_] ((clojure.core/get m4130 :is-network-master)))
  (isPhysicsProcessing
   [_]
   ((clojure.core/get m4130 :is-physics-processing)))
  (isPhysicsProcessingInternal
   [_]
   ((clojure.core/get m4130 :is-physics-processing-internal)))
  (isProcessing [_] ((clojure.core/get m4130 :is-processing)))
  (isProcessingInput
   [_]
   ((clojure.core/get m4130 :is-processing-input)))
  (isProcessingInternal
   [_]
   ((clojure.core/get m4130 :is-processing-internal)))
  (isProcessingUnhandledInput
   [_]
   ((clojure.core/get m4130 :is-processing-unhandled-input)))
  (isProcessingUnhandledKeyInput
   [_]
   ((clojure.core/get m4130 :is-processing-unhandled-key-input)))
  (moveChild
   [_ child_node to_position]
   ((clojure.core/get m4130 :move-child) child_node to_position))
  (printStrayNodes [_] ((clojure.core/get m4130 :print-stray-nodes)))
  (printTree [_] ((clojure.core/get m4130 :print-tree)))
  (printTreePretty [_] ((clojure.core/get m4130 :print-tree-pretty)))
  (propagateCall
   [_ method]
   ((clojure.core/get m4130 :propagate-call) method))
  (propagateCall
   [_ method args]
   ((clojure.core/get m4130 :propagate-call) method args))
  (propagateCall
   [_ method args parent_first]
   ((clojure.core/get m4130 :propagate-call) method args parent_first))
  (propagateNotification
   [_ what]
   ((clojure.core/get m4130 :propagate-notification) what))
  (queueFree [_] ((clojure.core/get m4130 :queue-free)))
  (raise [_] ((clojure.core/get m4130 :raise)))
  (removeAndSkip [_] ((clojure.core/get m4130 :remove-and-skip)))
  (removeChild [_ node] ((clojure.core/get m4130 :remove-child) node))
  (removeFromGroup
   [_ group]
   ((clojure.core/get m4130 :remove-from-group) group))
  (replaceBy [_ node] ((clojure.core/get m4130 :replace-by) node))
  (replaceBy
   [_ node keep_data]
   ((clojure.core/get m4130 :replace-by) node keep_data))
  (requestReady [_] ((clojure.core/get m4130 :request-ready)))
  (rpc [_ method] ((clojure.core/get m4130 :rpc) method))
  (rpc [_ method v1] ((clojure.core/get m4130 :rpc) method v1))
  (rpc [_ method v1 v2] ((clojure.core/get m4130 :rpc) method v1 v2))
  (rpc
   [_ method v1 v2 v3]
   ((clojure.core/get m4130 :rpc) method v1 v2 v3))
  (rpc
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4130 :rpc) method v1 v2 v3 v4))
  (rpc
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4130 :rpc) method v1 v2 v3 v4 v5))
  (rpcConfig
   [_ method mode]
   ((clojure.core/get m4130 :rpc-config) method mode))
  (rpcId
   [_ peer_id method]
   ((clojure.core/get m4130 :rpc-id) peer_id method))
  (rpcId
   [_ peer_id method v1]
   ((clojure.core/get m4130 :rpc-id) peer_id method v1))
  (rpcId
   [_ peer_id method v1 v2]
   ((clojure.core/get m4130 :rpc-id) peer_id method v1 v2))
  (rpcId
   [_ peer_id method v1 v2 v3]
   ((clojure.core/get m4130 :rpc-id) peer_id method v1 v2 v3))
  (rpcId
   [_ peer_id method v1 v2 v3 v4]
   ((clojure.core/get m4130 :rpc-id) peer_id method v1 v2 v3 v4))
  (rpcId
   [_ peer_id method v1 v2 v3 v4 v5]
   ((clojure.core/get m4130 :rpc-id) peer_id method v1 v2 v3 v4 v5))
  (rpcUnreliable
   [_ method]
   ((clojure.core/get m4130 :rpc-unreliable) method))
  (rpcUnreliable
   [_ method v1]
   ((clojure.core/get m4130 :rpc-unreliable) method v1))
  (rpcUnreliable
   [_ method v1 v2]
   ((clojure.core/get m4130 :rpc-unreliable) method v1 v2))
  (rpcUnreliable
   [_ method v1 v2 v3]
   ((clojure.core/get m4130 :rpc-unreliable) method v1 v2 v3))
  (rpcUnreliable
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4130 :rpc-unreliable) method v1 v2 v3 v4))
  (rpcUnreliable
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4130 :rpc-unreliable) method v1 v2 v3 v4 v5))
  (rpcUnreliableId
   [_ peer_id method]
   ((clojure.core/get m4130 :rpc-unreliable-id) peer_id method))
  (rpcUnreliableId
   [_ peer_id method v1]
   ((clojure.core/get m4130 :rpc-unreliable-id) peer_id method v1))
  (rpcUnreliableId
   [_ peer_id method v1 v2]
   ((clojure.core/get m4130 :rpc-unreliable-id) peer_id method v1 v2))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3]
   ((clojure.core/get m4130 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3 v4]
   ((clojure.core/get m4130 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3
    v4))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3 v4 v5]
   ((clojure.core/get m4130 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3
    v4
    v5))
  (rset
   [_ property value]
   ((clojure.core/get m4130 :rset) property value))
  (rsetConfig
   [_ property mode]
   ((clojure.core/get m4130 :rset-config) property mode))
  (rsetId
   [_ peer_id property value]
   ((clojure.core/get m4130 :rset-id) peer_id property value))
  (rsetUnreliable
   [_ property value]
   ((clojure.core/get m4130 :rset-unreliable) property value))
  (rsetUnreliableId
   [_ peer_id property value]
   ((clojure.core/get m4130 :rset-unreliable-id)
    peer_id
    property
    value))
  (setCustomMultiplayer
   [_ api]
   ((clojure.core/get m4130 :set-custom-multiplayer) api))
  (setDisplayFolded
   [_ fold]
   ((clojure.core/get m4130 :set-display-folded) fold))
  (setFilename
   [_ filename]
   ((clojure.core/get m4130 :set-filename) filename))
  (setName [_ name] ((clojure.core/get m4130 :set-name) name))
  (setNetworkMaster
   [_ id]
   ((clojure.core/get m4130 :set-network-master) id))
  (setNetworkMaster
   [_ id recursive]
   ((clojure.core/get m4130 :set-network-master) id recursive))
  (setOwner [_ owner] ((clojure.core/get m4130 :set-owner) owner))
  (setPauseMode
   [_ mode]
   ((clojure.core/get m4130 :set-pause-mode) mode))
  (setPhysicsProcess
   [_ enable]
   ((clojure.core/get m4130 :set-physics-process) enable))
  (setPhysicsProcessInternal
   [_ enable]
   ((clojure.core/get m4130 :set-physics-process-internal) enable))
  (setProcess
   [_ enable]
   ((clojure.core/get m4130 :set-process) enable))
  (setProcessInput
   [_ enable]
   ((clojure.core/get m4130 :set-process-input) enable))
  (setProcessInternal
   [_ enable]
   ((clojure.core/get m4130 :set-process-internal) enable))
  (setProcessPriority
   [_ priority]
   ((clojure.core/get m4130 :set-process-priority) priority))
  (setProcessUnhandledInput
   [_ enable]
   ((clojure.core/get m4130 :set-process-unhandled-input) enable))
  (setProcessUnhandledKeyInput
   [_ enable]
   ((clojure.core/get m4130 :set-process-unhandled-key-input) enable))
  (setSceneInstanceLoadPlaceholder
   [_ load_placeholder]
   ((clojure.core/get m4130 :set-scene-instance-load-placeholder)
    load_placeholder))
  (updateConfigurationWarning
   [_]
   ((clojure.core/get m4130 :update-configuration-warning)))
  (drawArc
   [_ center radius start_angle end_angle point_count color]
   ((clojure.core/get m4130 :draw-arc)
    center
    radius
    start_angle
    end_angle
    point_count
    color))
  (drawArc
   [_ center radius start_angle end_angle point_count color width]
   ((clojure.core/get m4130 :draw-arc)
    center
    radius
    start_angle
    end_angle
    point_count
    color
    width))
  (drawArc
   [_
    center
    radius
    start_angle
    end_angle
    point_count
    color
    width
    antialiased]
   ((clojure.core/get m4130 :draw-arc)
    center
    radius
    start_angle
    end_angle
    point_count
    color
    width
    antialiased))
  (drawChar
   [_ font position char next]
   ((clojure.core/get m4130 :draw-char) font position char next))
  (drawChar
   [_ font position char next modulate]
   ((clojure.core/get m4130 :draw-char)
    font
    position
    char
    next
    modulate))
  (drawCircle
   [_ position radius color]
   ((clojure.core/get m4130 :draw-circle) position radius color))
  (drawColoredPolygon
   [_ points color]
   ((clojure.core/get m4130 :draw-colored-polygon) points color))
  (drawColoredPolygon
   [_ points color uvs]
   ((clojure.core/get m4130 :draw-colored-polygon) points color uvs))
  (drawColoredPolygon
   [_ points color uvs texture]
   ((clojure.core/get m4130 :draw-colored-polygon)
    points
    color
    uvs
    texture))
  (drawColoredPolygon
   [_ points color uvs texture normal_map]
   ((clojure.core/get m4130 :draw-colored-polygon)
    points
    color
    uvs
    texture
    normal_map))
  (drawColoredPolygon
   [_ points color uvs texture normal_map antialiased]
   ((clojure.core/get m4130 :draw-colored-polygon)
    points
    color
    uvs
    texture
    normal_map
    antialiased))
  (drawLine
   [_ from to color]
   ((clojure.core/get m4130 :draw-line) from to color))
  (drawLine
   [_ from to color width]
   ((clojure.core/get m4130 :draw-line) from to color width))
  (drawLine
   [_ from to color width antialiased]
   ((clojure.core/get m4130 :draw-line)
    from
    to
    color
    width
    antialiased))
  (drawMesh
   [_ mesh texture]
   ((clojure.core/get m4130 :draw-mesh) mesh texture))
  (drawMesh
   [_ mesh texture normal_map]
   ((clojure.core/get m4130 :draw-mesh) mesh texture normal_map))
  (drawMesh
   [_ mesh texture normal_map transform]
   ((clojure.core/get m4130 :draw-mesh)
    mesh
    texture
    normal_map
    transform))
  (drawMesh
   [_ mesh texture normal_map transform modulate]
   ((clojure.core/get m4130 :draw-mesh)
    mesh
    texture
    normal_map
    transform
    modulate))
  (drawMultiline
   [_ points color]
   ((clojure.core/get m4130 :draw-multiline) points color))
  (drawMultiline
   [_ points color width]
   ((clojure.core/get m4130 :draw-multiline) points color width))
  (drawMultiline
   [_ points color width antialiased]
   ((clojure.core/get m4130 :draw-multiline)
    points
    color
    width
    antialiased))
  (drawMultilineColors
   [_ points colors]
   ((clojure.core/get m4130 :draw-multiline-colors) points colors))
  (drawMultilineColors
   [_ points colors width]
   ((clojure.core/get m4130 :draw-multiline-colors)
    points
    colors
    width))
  (drawMultilineColors
   [_ points colors width antialiased]
   ((clojure.core/get m4130 :draw-multiline-colors)
    points
    colors
    width
    antialiased))
  (drawMultimesh
   [_ multimesh texture]
   ((clojure.core/get m4130 :draw-multimesh) multimesh texture))
  (drawMultimesh
   [_ multimesh texture normal_map]
   ((clojure.core/get m4130 :draw-multimesh)
    multimesh
    texture
    normal_map))
  (drawPolygon
   [_ points colors]
   ((clojure.core/get m4130 :draw-polygon) points colors))
  (drawPolygon
   [_ points colors uvs]
   ((clojure.core/get m4130 :draw-polygon) points colors uvs))
  (drawPolygon
   [_ points colors uvs texture]
   ((clojure.core/get m4130 :draw-polygon) points colors uvs texture))
  (drawPolygon
   [_ points colors uvs texture normal_map]
   ((clojure.core/get m4130 :draw-polygon)
    points
    colors
    uvs
    texture
    normal_map))
  (drawPolygon
   [_ points colors uvs texture normal_map antialiased]
   ((clojure.core/get m4130 :draw-polygon)
    points
    colors
    uvs
    texture
    normal_map
    antialiased))
  (drawPolyline
   [_ points color]
   ((clojure.core/get m4130 :draw-polyline) points color))
  (drawPolyline
   [_ points color width]
   ((clojure.core/get m4130 :draw-polyline) points color width))
  (drawPolyline
   [_ points color width antialiased]
   ((clojure.core/get m4130 :draw-polyline)
    points
    color
    width
    antialiased))
  (drawPolylineColors
   [_ points colors]
   ((clojure.core/get m4130 :draw-polyline-colors) points colors))
  (drawPolylineColors
   [_ points colors width]
   ((clojure.core/get m4130 :draw-polyline-colors)
    points
    colors
    width))
  (drawPolylineColors
   [_ points colors width antialiased]
   ((clojure.core/get m4130 :draw-polyline-colors)
    points
    colors
    width
    antialiased))
  (drawPrimitive
   [_ points colors uvs]
   ((clojure.core/get m4130 :draw-primitive) points colors uvs))
  (drawPrimitive
   [_ points colors uvs texture]
   ((clojure.core/get m4130 :draw-primitive)
    points
    colors
    uvs
    texture))
  (drawPrimitive
   [_ points colors uvs texture width]
   ((clojure.core/get m4130 :draw-primitive)
    points
    colors
    uvs
    texture
    width))
  (drawPrimitive
   [_ points colors uvs texture width normal_map]
   ((clojure.core/get m4130 :draw-primitive)
    points
    colors
    uvs
    texture
    width
    normal_map))
  (drawRect
   [_ rect color]
   ((clojure.core/get m4130 :draw-rect) rect color))
  (drawRect
   [_ rect color filled]
   ((clojure.core/get m4130 :draw-rect) rect color filled))
  (drawRect
   [_ rect color filled width]
   ((clojure.core/get m4130 :draw-rect) rect color filled width))
  (drawRect
   [_ rect color filled width antialiased]
   ((clojure.core/get m4130 :draw-rect)
    rect
    color
    filled
    width
    antialiased))
  (drawSetTransform
   [_ position rotation scale]
   ((clojure.core/get m4130 :draw-set-transform)
    position
    rotation
    scale))
  (drawSetTransformMatrix
   [_ xform]
   ((clojure.core/get m4130 :draw-set-transform-matrix) xform))
  (drawString
   [_ font position text]
   ((clojure.core/get m4130 :draw-string) font position text))
  (drawString
   [_ font position text modulate]
   ((clojure.core/get m4130 :draw-string) font position text modulate))
  (drawString
   [_ font position text modulate clip_w]
   ((clojure.core/get m4130 :draw-string)
    font
    position
    text
    modulate
    clip_w))
  (drawStyleBox
   [_ style_box rect]
   ((clojure.core/get m4130 :draw-style-box) style_box rect))
  (drawTexture
   [_ texture position]
   ((clojure.core/get m4130 :draw-texture) texture position))
  (drawTexture
   [_ texture position modulate]
   ((clojure.core/get m4130 :draw-texture) texture position modulate))
  (drawTexture
   [_ texture position modulate normal_map]
   ((clojure.core/get m4130 :draw-texture)
    texture
    position
    modulate
    normal_map))
  (drawTextureRect
   [_ texture rect tile]
   ((clojure.core/get m4130 :draw-texture-rect) texture rect tile))
  (drawTextureRect
   [_ texture rect tile modulate]
   ((clojure.core/get m4130 :draw-texture-rect)
    texture
    rect
    tile
    modulate))
  (drawTextureRect
   [_ texture rect tile modulate transpose]
   ((clojure.core/get m4130 :draw-texture-rect)
    texture
    rect
    tile
    modulate
    transpose))
  (drawTextureRect
   [_ texture rect tile modulate transpose normal_map]
   ((clojure.core/get m4130 :draw-texture-rect)
    texture
    rect
    tile
    modulate
    transpose
    normal_map))
  (drawTextureRectRegion
   [_ texture rect src_rect]
   ((clojure.core/get m4130 :draw-texture-rect-region)
    texture
    rect
    src_rect))
  (drawTextureRectRegion
   [_ texture rect src_rect modulate]
   ((clojure.core/get m4130 :draw-texture-rect-region)
    texture
    rect
    src_rect
    modulate))
  (drawTextureRectRegion
   [_ texture rect src_rect modulate transpose]
   ((clojure.core/get m4130 :draw-texture-rect-region)
    texture
    rect
    src_rect
    modulate
    transpose))
  (drawTextureRectRegion
   [_ texture rect src_rect modulate transpose normal_map]
   ((clojure.core/get m4130 :draw-texture-rect-region)
    texture
    rect
    src_rect
    modulate
    transpose
    normal_map))
  (drawTextureRectRegion
   [_ texture rect src_rect modulate transpose normal_map clip_uv]
   ((clojure.core/get m4130 :draw-texture-rect-region)
    texture
    rect
    src_rect
    modulate
    transpose
    normal_map
    clip_uv))
  (forceUpdateTransform
   [_]
   ((clojure.core/get m4130 :force-update-transform)))
  (getCanvas [_] ((clojure.core/get m4130 :get-canvas)))
  (getCanvasItem [_] ((clojure.core/get m4130 :get-canvas-item)))
  (getCanvasTransform
   [_]
   ((clojure.core/get m4130 :get-canvas-transform)))
  (getGlobalMousePosition
   [_]
   ((clojure.core/get m4130 :get-global-mouse-position)))
  (getGlobalTransform
   [_]
   ((clojure.core/get m4130 :get-global-transform)))
  (getGlobalTransformWithCanvas
   [_]
   ((clojure.core/get m4130 :get-global-transform-with-canvas)))
  (getLightMask [_] ((clojure.core/get m4130 :get-light-mask)))
  (getLocalMousePosition
   [_]
   ((clojure.core/get m4130 :get-local-mouse-position)))
  (getMaterial [_] ((clojure.core/get m4130 :get-material)))
  (getModulate [_] ((clojure.core/get m4130 :get-modulate)))
  (getSelfModulate [_] ((clojure.core/get m4130 :get-self-modulate)))
  (getTransform [_] ((clojure.core/get m4130 :get-transform)))
  (getUseParentMaterial
   [_]
   ((clojure.core/get m4130 :get-use-parent-material)))
  (getViewportRect [_] ((clojure.core/get m4130 :get-viewport-rect)))
  (getViewportTransform
   [_]
   ((clojure.core/get m4130 :get-viewport-transform)))
  (getWorld2d [_] ((clojure.core/get m4130 :get-world-2d)))
  (hide [_] ((clojure.core/get m4130 :hide)))
  (isDrawBehindParentEnabled
   [_]
   ((clojure.core/get m4130 :is-draw-behind-parent-enabled)))
  (isLocalTransformNotificationEnabled
   [_]
   ((clojure.core/get m4130 :is-local-transform-notification-enabled)))
  (isSetAsToplevel [_] ((clojure.core/get m4130 :is-set-as-toplevel)))
  (isTransformNotificationEnabled
   [_]
   ((clojure.core/get m4130 :is-transform-notification-enabled)))
  (isVisible [_] ((clojure.core/get m4130 :is-visible)))
  (isVisibleInTree [_] ((clojure.core/get m4130 :is-visible-in-tree)))
  (makeCanvasPositionLocal
   [_ screen_point]
   ((clojure.core/get m4130 :make-canvas-position-local) screen_point))
  (makeInputLocal
   [_ event]
   ((clojure.core/get m4130 :make-input-local) event))
  (setAsToplevel
   [_ enable]
   ((clojure.core/get m4130 :set-as-toplevel) enable))
  (setDrawBehindParent
   [_ enable]
   ((clojure.core/get m4130 :set-draw-behind-parent) enable))
  (setLightMask
   [_ light_mask]
   ((clojure.core/get m4130 :set-light-mask) light_mask))
  (setMaterial
   [_ material]
   ((clojure.core/get m4130 :set-material) material))
  (setModulate
   [_ modulate]
   ((clojure.core/get m4130 :set-modulate) modulate))
  (setNotifyLocalTransform
   [_ enable]
   ((clojure.core/get m4130 :set-notify-local-transform) enable))
  (setNotifyTransform
   [_ enable]
   ((clojure.core/get m4130 :set-notify-transform) enable))
  (setSelfModulate
   [_ self_modulate]
   ((clojure.core/get m4130 :set-self-modulate) self_modulate))
  (setUseParentMaterial
   [_ enable]
   ((clojure.core/get m4130 :set-use-parent-material) enable))
  (setVisible
   [_ visible]
   ((clojure.core/get m4130 :set-visible) visible))
  (show [_] ((clojure.core/get m4130 :show)))
  (update [_] ((clojure.core/get m4130 :update)))
  (acceptEvent [_] ((clojure.core/get m4130 :accept-event)))
  (addColorOverride
   [_ name color]
   ((clojure.core/get m4130 :add-color-override) name color))
  (addConstantOverride
   [_ name constant]
   ((clojure.core/get m4130 :add-constant-override) name constant))
  (addFontOverride
   [_ name font]
   ((clojure.core/get m4130 :add-font-override) name font))
  (addIconOverride
   [_ name texture]
   ((clojure.core/get m4130 :add-icon-override) name texture))
  (addShaderOverride
   [_ name shader]
   ((clojure.core/get m4130 :add-shader-override) name shader))
  (addStyleboxOverride
   [_ name stylebox]
   ((clojure.core/get m4130 :add-stylebox-override) name stylebox))
  (canDropData
   [_ position data]
   ((clojure.core/get m4130 :can-drop-data) position data))
  (dropData
   [_ position data]
   ((clojure.core/get m4130 :drop-data) position data))
  (findNextValidFocus
   [_]
   ((clojure.core/get m4130 :find-next-valid-focus)))
  (findPrevValidFocus
   [_]
   ((clojure.core/get m4130 :find-prev-valid-focus)))
  (forceDrag
   [_ data preview]
   ((clojure.core/get m4130 :force-drag) data preview))
  (getAnchor [_ margin] ((clojure.core/get m4130 :get-anchor) margin))
  (getBegin [_] ((clojure.core/get m4130 :get-begin)))
  (getColor [_ name] ((clojure.core/get m4130 :get-color) name))
  (getColor
   [_ name node_type]
   ((clojure.core/get m4130 :get-color) name node_type))
  (getCombinedMinimumSize
   [_]
   ((clojure.core/get m4130 :get-combined-minimum-size)))
  (getConstant [_ name] ((clojure.core/get m4130 :get-constant) name))
  (getConstant
   [_ name node_type]
   ((clojure.core/get m4130 :get-constant) name node_type))
  (getCursorShape [_] ((clojure.core/get m4130 :get-cursor-shape)))
  (getCursorShape
   [_ position]
   ((clojure.core/get m4130 :get-cursor-shape) position))
  (getCustomMinimumSize
   [_]
   ((clojure.core/get m4130 :get-custom-minimum-size)))
  (getDefaultCursorShape
   [_]
   ((clojure.core/get m4130 :get-default-cursor-shape)))
  (getDragData
   [_ position]
   ((clojure.core/get m4130 :get-drag-data) position))
  (getEnd [_] ((clojure.core/get m4130 :get-end)))
  (getFocusMode [_] ((clojure.core/get m4130 :get-focus-mode)))
  (getFocusNeighbour
   [_ margin]
   ((clojure.core/get m4130 :get-focus-neighbour) margin))
  (getFocusNext [_] ((clojure.core/get m4130 :get-focus-next)))
  (getFocusOwner [_] ((clojure.core/get m4130 :get-focus-owner)))
  (getFocusPrevious
   [_]
   ((clojure.core/get m4130 :get-focus-previous)))
  (getFont [_ name] ((clojure.core/get m4130 :get-font) name))
  (getFont
   [_ name node_type]
   ((clojure.core/get m4130 :get-font) name node_type))
  (getGlobalPosition
   [_]
   ((clojure.core/get m4130 :get-global-position)))
  (getGlobalRect [_] ((clojure.core/get m4130 :get-global-rect)))
  (getHGrowDirection
   [_]
   ((clojure.core/get m4130 :get-h-grow-direction)))
  (getHSizeFlags [_] ((clojure.core/get m4130 :get-h-size-flags)))
  (getIcon [_ name] ((clojure.core/get m4130 :get-icon) name))
  (getIcon
   [_ name node_type]
   ((clojure.core/get m4130 :get-icon) name node_type))
  (getMargin [_ margin] ((clojure.core/get m4130 :get-margin) margin))
  (getMinimumSize [_] ((clojure.core/get m4130 :get-minimum-size)))
  (getMouseFilter [_] ((clojure.core/get m4130 :get-mouse-filter)))
  (getParentAreaSize
   [_]
   ((clojure.core/get m4130 :get-parent-area-size)))
  (getParentControl
   [_]
   ((clojure.core/get m4130 :get-parent-control)))
  (getPassOnModalCloseClick
   [_]
   ((clojure.core/get m4130 :get-pass-on-modal-close-click)))
  (getPivotOffset [_] ((clojure.core/get m4130 :get-pivot-offset)))
  (getPosition [_] ((clojure.core/get m4130 :get-position)))
  (getRect [_] ((clojure.core/get m4130 :get-rect)))
  (getRotation [_] ((clojure.core/get m4130 :get-rotation)))
  (getRotationDegrees
   [_]
   ((clojure.core/get m4130 :get-rotation-degrees)))
  (getScale [_] ((clojure.core/get m4130 :get-scale)))
  (getSize [_] ((clojure.core/get m4130 :get-size)))
  (getStretchRatio [_] ((clojure.core/get m4130 :get-stretch-ratio)))
  (getStylebox [_ name] ((clojure.core/get m4130 :get-stylebox) name))
  (getStylebox
   [_ name node_type]
   ((clojure.core/get m4130 :get-stylebox) name node_type))
  (getTheme [_] ((clojure.core/get m4130 :get-theme)))
  (getTooltip [_] ((clojure.core/get m4130 :get-tooltip)))
  (getTooltip
   [_ at_position]
   ((clojure.core/get m4130 :get-tooltip) at_position))
  (getVGrowDirection
   [_]
   ((clojure.core/get m4130 :get-v-grow-direction)))
  (getVSizeFlags [_] ((clojure.core/get m4130 :get-v-size-flags)))
  (grabClickFocus [_] ((clojure.core/get m4130 :grab-click-focus)))
  (grabFocus [_] ((clojure.core/get m4130 :grab-focus)))
  (hasColor [_ name] ((clojure.core/get m4130 :has-color) name))
  (hasColor
   [_ name node_type]
   ((clojure.core/get m4130 :has-color) name node_type))
  (hasColorOverride
   [_ name]
   ((clojure.core/get m4130 :has-color-override) name))
  (hasConstant [_ name] ((clojure.core/get m4130 :has-constant) name))
  (hasConstant
   [_ name node_type]
   ((clojure.core/get m4130 :has-constant) name node_type))
  (hasConstantOverride
   [_ name]
   ((clojure.core/get m4130 :has-constant-override) name))
  (hasFocus [_] ((clojure.core/get m4130 :has-focus)))
  (hasFont [_ name] ((clojure.core/get m4130 :has-font) name))
  (hasFont
   [_ name node_type]
   ((clojure.core/get m4130 :has-font) name node_type))
  (hasFontOverride
   [_ name]
   ((clojure.core/get m4130 :has-font-override) name))
  (hasIcon [_ name] ((clojure.core/get m4130 :has-icon) name))
  (hasIcon
   [_ name node_type]
   ((clojure.core/get m4130 :has-icon) name node_type))
  (hasIconOverride
   [_ name]
   ((clojure.core/get m4130 :has-icon-override) name))
  (hasPoint [_ point] ((clojure.core/get m4130 :has-point) point))
  (hasShaderOverride
   [_ name]
   ((clojure.core/get m4130 :has-shader-override) name))
  (hasStylebox [_ name] ((clojure.core/get m4130 :has-stylebox) name))
  (hasStylebox
   [_ name node_type]
   ((clojure.core/get m4130 :has-stylebox) name node_type))
  (hasStyleboxOverride
   [_ name]
   ((clojure.core/get m4130 :has-stylebox-override) name))
  (isClippingContents
   [_]
   ((clojure.core/get m4130 :is-clipping-contents)))
  (minimumSizeChanged
   [_]
   ((clojure.core/get m4130 :minimum-size-changed)))
  (releaseFocus [_] ((clojure.core/get m4130 :release-focus)))
  (setAnchor
   [_ margin anchor]
   ((clojure.core/get m4130 :set-anchor) margin anchor))
  (setAnchor
   [_ margin anchor keep_margin]
   ((clojure.core/get m4130 :set-anchor) margin anchor keep_margin))
  (setAnchor
   [_ margin anchor keep_margin push_opposite_anchor]
   ((clojure.core/get m4130 :set-anchor)
    margin
    anchor
    keep_margin
    push_opposite_anchor))
  (setAnchorAndMargin
   [_ margin anchor offset]
   ((clojure.core/get m4130 :set-anchor-and-margin)
    margin
    anchor
    offset))
  (setAnchorAndMargin
   [_ margin anchor offset push_opposite_anchor]
   ((clojure.core/get m4130 :set-anchor-and-margin)
    margin
    anchor
    offset
    push_opposite_anchor))
  (setAnchorsAndMarginsPreset
   [_ preset]
   ((clojure.core/get m4130 :set-anchors-and-margins-preset) preset))
  (setAnchorsAndMarginsPreset
   [_ preset resize_mode]
   ((clojure.core/get m4130 :set-anchors-and-margins-preset)
    preset
    resize_mode))
  (setAnchorsAndMarginsPreset
   [_ preset resize_mode margin]
   ((clojure.core/get m4130 :set-anchors-and-margins-preset)
    preset
    resize_mode
    margin))
  (setAnchorsPreset
   [_ preset]
   ((clojure.core/get m4130 :set-anchors-preset) preset))
  (setAnchorsPreset
   [_ preset keep_margins]
   ((clojure.core/get m4130 :set-anchors-preset) preset keep_margins))
  (setBegin
   [_ position]
   ((clojure.core/get m4130 :set-begin) position))
  (setClipContents
   [_ enable]
   ((clojure.core/get m4130 :set-clip-contents) enable))
  (setCustomMinimumSize
   [_ size]
   ((clojure.core/get m4130 :set-custom-minimum-size) size))
  (setDefaultCursorShape
   [_ shape]
   ((clojure.core/get m4130 :set-default-cursor-shape) shape))
  (setDragForwarding
   [_ target]
   ((clojure.core/get m4130 :set-drag-forwarding) target))
  (setDragPreview
   [_ control]
   ((clojure.core/get m4130 :set-drag-preview) control))
  (setEnd [_ position] ((clojure.core/get m4130 :set-end) position))
  (setFocusMode
   [_ mode]
   ((clojure.core/get m4130 :set-focus-mode) mode))
  (setFocusNeighbour
   [_ margin neighbour]
   ((clojure.core/get m4130 :set-focus-neighbour) margin neighbour))
  (setFocusNext
   [_ next]
   ((clojure.core/get m4130 :set-focus-next) next))
  (setFocusPrevious
   [_ previous]
   ((clojure.core/get m4130 :set-focus-previous) previous))
  (setGlobalPosition
   [_ position]
   ((clojure.core/get m4130 :set-global-position) position))
  (setGlobalPosition
   [_ position keep_margins]
   ((clojure.core/get m4130 :set-global-position)
    position
    keep_margins))
  (setHGrowDirection
   [_ direction]
   ((clojure.core/get m4130 :set-h-grow-direction) direction))
  (setHSizeFlags
   [_ flags]
   ((clojure.core/get m4130 :set-h-size-flags) flags))
  (setMargin
   [_ margin offset]
   ((clojure.core/get m4130 :set-margin) margin offset))
  (setMarginsPreset
   [_ preset]
   ((clojure.core/get m4130 :set-margins-preset) preset))
  (setMarginsPreset
   [_ preset resize_mode]
   ((clojure.core/get m4130 :set-margins-preset) preset resize_mode))
  (setMarginsPreset
   [_ preset resize_mode margin]
   ((clojure.core/get m4130 :set-margins-preset)
    preset
    resize_mode
    margin))
  (setMouseFilter
   [_ filter]
   ((clojure.core/get m4130 :set-mouse-filter) filter))
  (setPassOnModalCloseClick
   [_ enabled]
   ((clojure.core/get m4130 :set-pass-on-modal-close-click) enabled))
  (setPivotOffset
   [_ pivot_offset]
   ((clojure.core/get m4130 :set-pivot-offset) pivot_offset))
  (setPosition
   [_ position]
   ((clojure.core/get m4130 :set-position) position))
  (setPosition
   [_ position keep_margins]
   ((clojure.core/get m4130 :set-position) position keep_margins))
  (setRotation
   [_ radians]
   ((clojure.core/get m4130 :set-rotation) radians))
  (setRotationDegrees
   [_ degrees]
   ((clojure.core/get m4130 :set-rotation-degrees) degrees))
  (setScale [_ scale] ((clojure.core/get m4130 :set-scale) scale))
  (setSize [_ size] ((clojure.core/get m4130 :set-size) size))
  (setSize
   [_ size keep_margins]
   ((clojure.core/get m4130 :set-size) size keep_margins))
  (setStretchRatio
   [_ ratio]
   ((clojure.core/get m4130 :set-stretch-ratio) ratio))
  (setTheme [_ theme] ((clojure.core/get m4130 :set-theme) theme))
  (setTooltip
   [_ tooltip]
   ((clojure.core/get m4130 :set-tooltip) tooltip))
  (setVGrowDirection
   [_ direction]
   ((clojure.core/get m4130 :set-v-grow-direction) direction))
  (setVSizeFlags
   [_ flags]
   ((clojure.core/get m4130 :set-v-size-flags) flags))
  (showModal [_] ((clojure.core/get m4130 :show-modal)))
  (showModal
   [_ exclusive]
   ((clojure.core/get m4130 :show-modal) exclusive))
  (warpMouse
   [_ to_position]
   ((clojure.core/get m4130 :warp-mouse) to_position)))
(deftype GodotPopup
  [m4131]
  proto/ToVariant
  (->variant [this] (proto/->variant m4131))
  clojure.lang.ILookup
  (valAt [_ k] (get m4131 k))
  godotclj.api.gdscript.IGodotPopup
  (addUserSignal
   [_ signal]
   ((clojure.core/get m4131 :add-user-signal) signal))
  (addUserSignal
   [_ signal arguments]
   ((clojure.core/get m4131 :add-user-signal) signal arguments))
  (call [_ method] ((clojure.core/get m4131 :call) method))
  (call [_ method v1] ((clojure.core/get m4131 :call) method v1))
  (call
   [_ method v1 v2]
   ((clojure.core/get m4131 :call) method v1 v2))
  (call
   [_ method v1 v2 v3]
   ((clojure.core/get m4131 :call) method v1 v2 v3))
  (call
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4131 :call) method v1 v2 v3 v4))
  (call
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4131 :call) method v1 v2 v3 v4 v5))
  (callDeferred
   [_ method]
   ((clojure.core/get m4131 :call-deferred) method))
  (callDeferred
   [_ method v1]
   ((clojure.core/get m4131 :call-deferred) method v1))
  (callDeferred
   [_ method v1 v2]
   ((clojure.core/get m4131 :call-deferred) method v1 v2))
  (callDeferred
   [_ method v1 v2 v3]
   ((clojure.core/get m4131 :call-deferred) method v1 v2 v3))
  (callDeferred
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4131 :call-deferred) method v1 v2 v3 v4))
  (callDeferred
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4131 :call-deferred) method v1 v2 v3 v4 v5))
  (callv
   [_ method arg_array]
   ((clojure.core/get m4131 :callv) method arg_array))
  (canTranslateMessages
   [_]
   ((clojure.core/get m4131 :can-translate-messages)))
  (connect
   [_ signal target method]
   ((clojure.core/get m4131 :connect) signal target method))
  (connect
   [_ signal target method binds]
   ((clojure.core/get m4131 :connect) signal target method binds))
  (connect
   [_ signal target method binds flags]
   ((clojure.core/get m4131 :connect)
    signal
    target
    method
    binds
    flags))
  (disconnect
   [_ signal target method]
   ((clojure.core/get m4131 :disconnect) signal target method))
  (emitSignal
   [_ signal]
   ((clojure.core/get m4131 :emit-signal) signal))
  (emitSignal
   [_ signal v1]
   ((clojure.core/get m4131 :emit-signal) signal v1))
  (emitSignal
   [_ signal v1 v2]
   ((clojure.core/get m4131 :emit-signal) signal v1 v2))
  (emitSignal
   [_ signal v1 v2 v3]
   ((clojure.core/get m4131 :emit-signal) signal v1 v2 v3))
  (emitSignal
   [_ signal v1 v2 v3 v4]
   ((clojure.core/get m4131 :emit-signal) signal v1 v2 v3 v4))
  (emitSignal
   [_ signal v1 v2 v3 v4 v5]
   ((clojure.core/get m4131 :emit-signal) signal v1 v2 v3 v4 v5))
  (free [_] ((clojure.core/get m4131 :free)))
  (get [_ property] ((clojure.core/get m4131 :get) property))
  (getClass [_] ((clojure.core/get m4131 :get-class)))
  (getIncomingConnections
   [_]
   ((clojure.core/get m4131 :get-incoming-connections)))
  (getIndexed
   [_ property]
   ((clojure.core/get m4131 :get-indexed) property))
  (getInstanceId [_] ((clojure.core/get m4131 :get-instance-id)))
  (getMeta [_ name] ((clojure.core/get m4131 :get-meta) name))
  (getMetaList [_] ((clojure.core/get m4131 :get-meta-list)))
  (getMethodList [_] ((clojure.core/get m4131 :get-method-list)))
  (getPropertyList [_] ((clojure.core/get m4131 :get-property-list)))
  (getScript [_] ((clojure.core/get m4131 :get-script)))
  (getSignalConnectionList
   [_ signal]
   ((clojure.core/get m4131 :get-signal-connection-list) signal))
  (getSignalList [_] ((clojure.core/get m4131 :get-signal-list)))
  (hasMeta [_ name] ((clojure.core/get m4131 :has-meta) name))
  (hasMethod [_ method] ((clojure.core/get m4131 :has-method) method))
  (hasSignal [_ signal] ((clojure.core/get m4131 :has-signal) signal))
  (hasUserSignal
   [_ signal]
   ((clojure.core/get m4131 :has-user-signal) signal))
  (isBlockingSignals
   [_]
   ((clojure.core/get m4131 :is-blocking-signals)))
  (isClass [_ class] ((clojure.core/get m4131 :is-class) class))
  (isConnected
   [_ signal target method]
   ((clojure.core/get m4131 :is-connected) signal target method))
  (isQueuedForDeletion
   [_]
   ((clojure.core/get m4131 :is-queued-for-deletion)))
  (notification
   [_ what]
   ((clojure.core/get m4131 :notification) what))
  (notification
   [_ what reversed]
   ((clojure.core/get m4131 :notification) what reversed))
  (propertyListChangedNotify
   [_]
   ((clojure.core/get m4131 :property-list-changed-notify)))
  (removeMeta [_ name] ((clojure.core/get m4131 :remove-meta) name))
  (set
   [_ property value]
   ((clojure.core/get m4131 :set) property value))
  (setBlockSignals
   [_ enable]
   ((clojure.core/get m4131 :set-block-signals) enable))
  (setDeferred
   [_ property value]
   ((clojure.core/get m4131 :set-deferred) property value))
  (setIndexed
   [_ property value]
   ((clojure.core/get m4131 :set-indexed) property value))
  (setMessageTranslation
   [_ enable]
   ((clojure.core/get m4131 :set-message-translation) enable))
  (setMeta
   [_ name value]
   ((clojure.core/get m4131 :set-meta) name value))
  (setScript [_ script] ((clojure.core/get m4131 :set-script) script))
  (tr [_ message] ((clojure.core/get m4131 :tr) message))
  (addChild [_ node] ((clojure.core/get m4131 :add-child) node))
  (addChild
   [_ node legible_unique_name]
   ((clojure.core/get m4131 :add-child) node legible_unique_name))
  (addChildBelowNode
   [_ node child_node]
   ((clojure.core/get m4131 :add-child-below-node) node child_node))
  (addChildBelowNode
   [_ node child_node legible_unique_name]
   ((clojure.core/get m4131 :add-child-below-node)
    node
    child_node
    legible_unique_name))
  (addToGroup
   [_ group]
   ((clojure.core/get m4131 :add-to-group) group))
  (addToGroup
   [_ group persistent]
   ((clojure.core/get m4131 :add-to-group) group persistent))
  (canProcess [_] ((clojure.core/get m4131 :can-process)))
  (duplicate [_] ((clojure.core/get m4131 :duplicate)))
  (duplicate [_ flags] ((clojure.core/get m4131 :duplicate) flags))
  (findNode [_ mask] ((clojure.core/get m4131 :find-node) mask))
  (findNode
   [_ mask recursive]
   ((clojure.core/get m4131 :find-node) mask recursive))
  (findNode
   [_ mask recursive owned]
   ((clojure.core/get m4131 :find-node) mask recursive owned))
  (findParent [_ mask] ((clojure.core/get m4131 :find-parent) mask))
  (getChild [_ idx] ((clojure.core/get m4131 :get-child) idx))
  (getChildCount [_] ((clojure.core/get m4131 :get-child-count)))
  (getChildren [_] ((clojure.core/get m4131 :get-children)))
  (getCustomMultiplayer
   [_]
   ((clojure.core/get m4131 :get-custom-multiplayer)))
  (getFilename [_] ((clojure.core/get m4131 :get-filename)))
  (getGroups [_] ((clojure.core/get m4131 :get-groups)))
  (getIndex [_] ((clojure.core/get m4131 :get-index)))
  (getMultiplayer [_] ((clojure.core/get m4131 :get-multiplayer)))
  (getName [_] ((clojure.core/get m4131 :get-name)))
  (getNetworkMaster
   [_]
   ((clojure.core/get m4131 :get-network-master)))
  (getNode [_ path] ((clojure.core/get m4131 :get-node) path))
  (getNodeAndResource
   [_ path]
   ((clojure.core/get m4131 :get-node-and-resource) path))
  (getNodeOrNull
   [_ path]
   ((clojure.core/get m4131 :get-node-or-null) path))
  (getOwner [_] ((clojure.core/get m4131 :get-owner)))
  (getParent [_] ((clojure.core/get m4131 :get-parent)))
  (getPath [_] ((clojure.core/get m4131 :get-path)))
  (getPathTo [_ node] ((clojure.core/get m4131 :get-path-to) node))
  (getPauseMode [_] ((clojure.core/get m4131 :get-pause-mode)))
  (getPhysicsProcessDeltaTime
   [_]
   ((clojure.core/get m4131 :get-physics-process-delta-time)))
  (getPositionInParent
   [_]
   ((clojure.core/get m4131 :get-position-in-parent)))
  (getProcessDeltaTime
   [_]
   ((clojure.core/get m4131 :get-process-delta-time)))
  (getProcessPriority
   [_]
   ((clojure.core/get m4131 :get-process-priority)))
  (getSceneInstanceLoadPlaceholder
   [_]
   ((clojure.core/get m4131 :get-scene-instance-load-placeholder)))
  (getTree [_] ((clojure.core/get m4131 :get-tree)))
  (getViewport [_] ((clojure.core/get m4131 :get-viewport)))
  (hasNode [_ path] ((clojure.core/get m4131 :has-node) path))
  (hasNodeAndResource
   [_ path]
   ((clojure.core/get m4131 :has-node-and-resource) path))
  (isAParentOf
   [_ node]
   ((clojure.core/get m4131 :is-a-parent-of) node))
  (isDisplayedFolded
   [_]
   ((clojure.core/get m4131 :is-displayed-folded)))
  (isGreaterThan
   [_ node]
   ((clojure.core/get m4131 :is-greater-than) node))
  (isInGroup [_ group] ((clojure.core/get m4131 :is-in-group) group))
  (isInsideTree [_] ((clojure.core/get m4131 :is-inside-tree)))
  (isNetworkMaster [_] ((clojure.core/get m4131 :is-network-master)))
  (isPhysicsProcessing
   [_]
   ((clojure.core/get m4131 :is-physics-processing)))
  (isPhysicsProcessingInternal
   [_]
   ((clojure.core/get m4131 :is-physics-processing-internal)))
  (isProcessing [_] ((clojure.core/get m4131 :is-processing)))
  (isProcessingInput
   [_]
   ((clojure.core/get m4131 :is-processing-input)))
  (isProcessingInternal
   [_]
   ((clojure.core/get m4131 :is-processing-internal)))
  (isProcessingUnhandledInput
   [_]
   ((clojure.core/get m4131 :is-processing-unhandled-input)))
  (isProcessingUnhandledKeyInput
   [_]
   ((clojure.core/get m4131 :is-processing-unhandled-key-input)))
  (moveChild
   [_ child_node to_position]
   ((clojure.core/get m4131 :move-child) child_node to_position))
  (printStrayNodes [_] ((clojure.core/get m4131 :print-stray-nodes)))
  (printTree [_] ((clojure.core/get m4131 :print-tree)))
  (printTreePretty [_] ((clojure.core/get m4131 :print-tree-pretty)))
  (propagateCall
   [_ method]
   ((clojure.core/get m4131 :propagate-call) method))
  (propagateCall
   [_ method args]
   ((clojure.core/get m4131 :propagate-call) method args))
  (propagateCall
   [_ method args parent_first]
   ((clojure.core/get m4131 :propagate-call) method args parent_first))
  (propagateNotification
   [_ what]
   ((clojure.core/get m4131 :propagate-notification) what))
  (queueFree [_] ((clojure.core/get m4131 :queue-free)))
  (raise [_] ((clojure.core/get m4131 :raise)))
  (removeAndSkip [_] ((clojure.core/get m4131 :remove-and-skip)))
  (removeChild [_ node] ((clojure.core/get m4131 :remove-child) node))
  (removeFromGroup
   [_ group]
   ((clojure.core/get m4131 :remove-from-group) group))
  (replaceBy [_ node] ((clojure.core/get m4131 :replace-by) node))
  (replaceBy
   [_ node keep_data]
   ((clojure.core/get m4131 :replace-by) node keep_data))
  (requestReady [_] ((clojure.core/get m4131 :request-ready)))
  (rpc [_ method] ((clojure.core/get m4131 :rpc) method))
  (rpc [_ method v1] ((clojure.core/get m4131 :rpc) method v1))
  (rpc [_ method v1 v2] ((clojure.core/get m4131 :rpc) method v1 v2))
  (rpc
   [_ method v1 v2 v3]
   ((clojure.core/get m4131 :rpc) method v1 v2 v3))
  (rpc
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4131 :rpc) method v1 v2 v3 v4))
  (rpc
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4131 :rpc) method v1 v2 v3 v4 v5))
  (rpcConfig
   [_ method mode]
   ((clojure.core/get m4131 :rpc-config) method mode))
  (rpcId
   [_ peer_id method]
   ((clojure.core/get m4131 :rpc-id) peer_id method))
  (rpcId
   [_ peer_id method v1]
   ((clojure.core/get m4131 :rpc-id) peer_id method v1))
  (rpcId
   [_ peer_id method v1 v2]
   ((clojure.core/get m4131 :rpc-id) peer_id method v1 v2))
  (rpcId
   [_ peer_id method v1 v2 v3]
   ((clojure.core/get m4131 :rpc-id) peer_id method v1 v2 v3))
  (rpcId
   [_ peer_id method v1 v2 v3 v4]
   ((clojure.core/get m4131 :rpc-id) peer_id method v1 v2 v3 v4))
  (rpcId
   [_ peer_id method v1 v2 v3 v4 v5]
   ((clojure.core/get m4131 :rpc-id) peer_id method v1 v2 v3 v4 v5))
  (rpcUnreliable
   [_ method]
   ((clojure.core/get m4131 :rpc-unreliable) method))
  (rpcUnreliable
   [_ method v1]
   ((clojure.core/get m4131 :rpc-unreliable) method v1))
  (rpcUnreliable
   [_ method v1 v2]
   ((clojure.core/get m4131 :rpc-unreliable) method v1 v2))
  (rpcUnreliable
   [_ method v1 v2 v3]
   ((clojure.core/get m4131 :rpc-unreliable) method v1 v2 v3))
  (rpcUnreliable
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4131 :rpc-unreliable) method v1 v2 v3 v4))
  (rpcUnreliable
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4131 :rpc-unreliable) method v1 v2 v3 v4 v5))
  (rpcUnreliableId
   [_ peer_id method]
   ((clojure.core/get m4131 :rpc-unreliable-id) peer_id method))
  (rpcUnreliableId
   [_ peer_id method v1]
   ((clojure.core/get m4131 :rpc-unreliable-id) peer_id method v1))
  (rpcUnreliableId
   [_ peer_id method v1 v2]
   ((clojure.core/get m4131 :rpc-unreliable-id) peer_id method v1 v2))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3]
   ((clojure.core/get m4131 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3 v4]
   ((clojure.core/get m4131 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3
    v4))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3 v4 v5]
   ((clojure.core/get m4131 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3
    v4
    v5))
  (rset
   [_ property value]
   ((clojure.core/get m4131 :rset) property value))
  (rsetConfig
   [_ property mode]
   ((clojure.core/get m4131 :rset-config) property mode))
  (rsetId
   [_ peer_id property value]
   ((clojure.core/get m4131 :rset-id) peer_id property value))
  (rsetUnreliable
   [_ property value]
   ((clojure.core/get m4131 :rset-unreliable) property value))
  (rsetUnreliableId
   [_ peer_id property value]
   ((clojure.core/get m4131 :rset-unreliable-id)
    peer_id
    property
    value))
  (setCustomMultiplayer
   [_ api]
   ((clojure.core/get m4131 :set-custom-multiplayer) api))
  (setDisplayFolded
   [_ fold]
   ((clojure.core/get m4131 :set-display-folded) fold))
  (setFilename
   [_ filename]
   ((clojure.core/get m4131 :set-filename) filename))
  (setName [_ name] ((clojure.core/get m4131 :set-name) name))
  (setNetworkMaster
   [_ id]
   ((clojure.core/get m4131 :set-network-master) id))
  (setNetworkMaster
   [_ id recursive]
   ((clojure.core/get m4131 :set-network-master) id recursive))
  (setOwner [_ owner] ((clojure.core/get m4131 :set-owner) owner))
  (setPauseMode
   [_ mode]
   ((clojure.core/get m4131 :set-pause-mode) mode))
  (setPhysicsProcess
   [_ enable]
   ((clojure.core/get m4131 :set-physics-process) enable))
  (setPhysicsProcessInternal
   [_ enable]
   ((clojure.core/get m4131 :set-physics-process-internal) enable))
  (setProcess
   [_ enable]
   ((clojure.core/get m4131 :set-process) enable))
  (setProcessInput
   [_ enable]
   ((clojure.core/get m4131 :set-process-input) enable))
  (setProcessInternal
   [_ enable]
   ((clojure.core/get m4131 :set-process-internal) enable))
  (setProcessPriority
   [_ priority]
   ((clojure.core/get m4131 :set-process-priority) priority))
  (setProcessUnhandledInput
   [_ enable]
   ((clojure.core/get m4131 :set-process-unhandled-input) enable))
  (setProcessUnhandledKeyInput
   [_ enable]
   ((clojure.core/get m4131 :set-process-unhandled-key-input) enable))
  (setSceneInstanceLoadPlaceholder
   [_ load_placeholder]
   ((clojure.core/get m4131 :set-scene-instance-load-placeholder)
    load_placeholder))
  (updateConfigurationWarning
   [_]
   ((clojure.core/get m4131 :update-configuration-warning)))
  (drawArc
   [_ center radius start_angle end_angle point_count color]
   ((clojure.core/get m4131 :draw-arc)
    center
    radius
    start_angle
    end_angle
    point_count
    color))
  (drawArc
   [_ center radius start_angle end_angle point_count color width]
   ((clojure.core/get m4131 :draw-arc)
    center
    radius
    start_angle
    end_angle
    point_count
    color
    width))
  (drawArc
   [_
    center
    radius
    start_angle
    end_angle
    point_count
    color
    width
    antialiased]
   ((clojure.core/get m4131 :draw-arc)
    center
    radius
    start_angle
    end_angle
    point_count
    color
    width
    antialiased))
  (drawChar
   [_ font position char next]
   ((clojure.core/get m4131 :draw-char) font position char next))
  (drawChar
   [_ font position char next modulate]
   ((clojure.core/get m4131 :draw-char)
    font
    position
    char
    next
    modulate))
  (drawCircle
   [_ position radius color]
   ((clojure.core/get m4131 :draw-circle) position radius color))
  (drawColoredPolygon
   [_ points color]
   ((clojure.core/get m4131 :draw-colored-polygon) points color))
  (drawColoredPolygon
   [_ points color uvs]
   ((clojure.core/get m4131 :draw-colored-polygon) points color uvs))
  (drawColoredPolygon
   [_ points color uvs texture]
   ((clojure.core/get m4131 :draw-colored-polygon)
    points
    color
    uvs
    texture))
  (drawColoredPolygon
   [_ points color uvs texture normal_map]
   ((clojure.core/get m4131 :draw-colored-polygon)
    points
    color
    uvs
    texture
    normal_map))
  (drawColoredPolygon
   [_ points color uvs texture normal_map antialiased]
   ((clojure.core/get m4131 :draw-colored-polygon)
    points
    color
    uvs
    texture
    normal_map
    antialiased))
  (drawLine
   [_ from to color]
   ((clojure.core/get m4131 :draw-line) from to color))
  (drawLine
   [_ from to color width]
   ((clojure.core/get m4131 :draw-line) from to color width))
  (drawLine
   [_ from to color width antialiased]
   ((clojure.core/get m4131 :draw-line)
    from
    to
    color
    width
    antialiased))
  (drawMesh
   [_ mesh texture]
   ((clojure.core/get m4131 :draw-mesh) mesh texture))
  (drawMesh
   [_ mesh texture normal_map]
   ((clojure.core/get m4131 :draw-mesh) mesh texture normal_map))
  (drawMesh
   [_ mesh texture normal_map transform]
   ((clojure.core/get m4131 :draw-mesh)
    mesh
    texture
    normal_map
    transform))
  (drawMesh
   [_ mesh texture normal_map transform modulate]
   ((clojure.core/get m4131 :draw-mesh)
    mesh
    texture
    normal_map
    transform
    modulate))
  (drawMultiline
   [_ points color]
   ((clojure.core/get m4131 :draw-multiline) points color))
  (drawMultiline
   [_ points color width]
   ((clojure.core/get m4131 :draw-multiline) points color width))
  (drawMultiline
   [_ points color width antialiased]
   ((clojure.core/get m4131 :draw-multiline)
    points
    color
    width
    antialiased))
  (drawMultilineColors
   [_ points colors]
   ((clojure.core/get m4131 :draw-multiline-colors) points colors))
  (drawMultilineColors
   [_ points colors width]
   ((clojure.core/get m4131 :draw-multiline-colors)
    points
    colors
    width))
  (drawMultilineColors
   [_ points colors width antialiased]
   ((clojure.core/get m4131 :draw-multiline-colors)
    points
    colors
    width
    antialiased))
  (drawMultimesh
   [_ multimesh texture]
   ((clojure.core/get m4131 :draw-multimesh) multimesh texture))
  (drawMultimesh
   [_ multimesh texture normal_map]
   ((clojure.core/get m4131 :draw-multimesh)
    multimesh
    texture
    normal_map))
  (drawPolygon
   [_ points colors]
   ((clojure.core/get m4131 :draw-polygon) points colors))
  (drawPolygon
   [_ points colors uvs]
   ((clojure.core/get m4131 :draw-polygon) points colors uvs))
  (drawPolygon
   [_ points colors uvs texture]
   ((clojure.core/get m4131 :draw-polygon) points colors uvs texture))
  (drawPolygon
   [_ points colors uvs texture normal_map]
   ((clojure.core/get m4131 :draw-polygon)
    points
    colors
    uvs
    texture
    normal_map))
  (drawPolygon
   [_ points colors uvs texture normal_map antialiased]
   ((clojure.core/get m4131 :draw-polygon)
    points
    colors
    uvs
    texture
    normal_map
    antialiased))
  (drawPolyline
   [_ points color]
   ((clojure.core/get m4131 :draw-polyline) points color))
  (drawPolyline
   [_ points color width]
   ((clojure.core/get m4131 :draw-polyline) points color width))
  (drawPolyline
   [_ points color width antialiased]
   ((clojure.core/get m4131 :draw-polyline)
    points
    color
    width
    antialiased))
  (drawPolylineColors
   [_ points colors]
   ((clojure.core/get m4131 :draw-polyline-colors) points colors))
  (drawPolylineColors
   [_ points colors width]
   ((clojure.core/get m4131 :draw-polyline-colors)
    points
    colors
    width))
  (drawPolylineColors
   [_ points colors width antialiased]
   ((clojure.core/get m4131 :draw-polyline-colors)
    points
    colors
    width
    antialiased))
  (drawPrimitive
   [_ points colors uvs]
   ((clojure.core/get m4131 :draw-primitive) points colors uvs))
  (drawPrimitive
   [_ points colors uvs texture]
   ((clojure.core/get m4131 :draw-primitive)
    points
    colors
    uvs
    texture))
  (drawPrimitive
   [_ points colors uvs texture width]
   ((clojure.core/get m4131 :draw-primitive)
    points
    colors
    uvs
    texture
    width))
  (drawPrimitive
   [_ points colors uvs texture width normal_map]
   ((clojure.core/get m4131 :draw-primitive)
    points
    colors
    uvs
    texture
    width
    normal_map))
  (drawRect
   [_ rect color]
   ((clojure.core/get m4131 :draw-rect) rect color))
  (drawRect
   [_ rect color filled]
   ((clojure.core/get m4131 :draw-rect) rect color filled))
  (drawRect
   [_ rect color filled width]
   ((clojure.core/get m4131 :draw-rect) rect color filled width))
  (drawRect
   [_ rect color filled width antialiased]
   ((clojure.core/get m4131 :draw-rect)
    rect
    color
    filled
    width
    antialiased))
  (drawSetTransform
   [_ position rotation scale]
   ((clojure.core/get m4131 :draw-set-transform)
    position
    rotation
    scale))
  (drawSetTransformMatrix
   [_ xform]
   ((clojure.core/get m4131 :draw-set-transform-matrix) xform))
  (drawString
   [_ font position text]
   ((clojure.core/get m4131 :draw-string) font position text))
  (drawString
   [_ font position text modulate]
   ((clojure.core/get m4131 :draw-string) font position text modulate))
  (drawString
   [_ font position text modulate clip_w]
   ((clojure.core/get m4131 :draw-string)
    font
    position
    text
    modulate
    clip_w))
  (drawStyleBox
   [_ style_box rect]
   ((clojure.core/get m4131 :draw-style-box) style_box rect))
  (drawTexture
   [_ texture position]
   ((clojure.core/get m4131 :draw-texture) texture position))
  (drawTexture
   [_ texture position modulate]
   ((clojure.core/get m4131 :draw-texture) texture position modulate))
  (drawTexture
   [_ texture position modulate normal_map]
   ((clojure.core/get m4131 :draw-texture)
    texture
    position
    modulate
    normal_map))
  (drawTextureRect
   [_ texture rect tile]
   ((clojure.core/get m4131 :draw-texture-rect) texture rect tile))
  (drawTextureRect
   [_ texture rect tile modulate]
   ((clojure.core/get m4131 :draw-texture-rect)
    texture
    rect
    tile
    modulate))
  (drawTextureRect
   [_ texture rect tile modulate transpose]
   ((clojure.core/get m4131 :draw-texture-rect)
    texture
    rect
    tile
    modulate
    transpose))
  (drawTextureRect
   [_ texture rect tile modulate transpose normal_map]
   ((clojure.core/get m4131 :draw-texture-rect)
    texture
    rect
    tile
    modulate
    transpose
    normal_map))
  (drawTextureRectRegion
   [_ texture rect src_rect]
   ((clojure.core/get m4131 :draw-texture-rect-region)
    texture
    rect
    src_rect))
  (drawTextureRectRegion
   [_ texture rect src_rect modulate]
   ((clojure.core/get m4131 :draw-texture-rect-region)
    texture
    rect
    src_rect
    modulate))
  (drawTextureRectRegion
   [_ texture rect src_rect modulate transpose]
   ((clojure.core/get m4131 :draw-texture-rect-region)
    texture
    rect
    src_rect
    modulate
    transpose))
  (drawTextureRectRegion
   [_ texture rect src_rect modulate transpose normal_map]
   ((clojure.core/get m4131 :draw-texture-rect-region)
    texture
    rect
    src_rect
    modulate
    transpose
    normal_map))
  (drawTextureRectRegion
   [_ texture rect src_rect modulate transpose normal_map clip_uv]
   ((clojure.core/get m4131 :draw-texture-rect-region)
    texture
    rect
    src_rect
    modulate
    transpose
    normal_map
    clip_uv))
  (forceUpdateTransform
   [_]
   ((clojure.core/get m4131 :force-update-transform)))
  (getCanvas [_] ((clojure.core/get m4131 :get-canvas)))
  (getCanvasItem [_] ((clojure.core/get m4131 :get-canvas-item)))
  (getCanvasTransform
   [_]
   ((clojure.core/get m4131 :get-canvas-transform)))
  (getGlobalMousePosition
   [_]
   ((clojure.core/get m4131 :get-global-mouse-position)))
  (getGlobalTransform
   [_]
   ((clojure.core/get m4131 :get-global-transform)))
  (getGlobalTransformWithCanvas
   [_]
   ((clojure.core/get m4131 :get-global-transform-with-canvas)))
  (getLightMask [_] ((clojure.core/get m4131 :get-light-mask)))
  (getLocalMousePosition
   [_]
   ((clojure.core/get m4131 :get-local-mouse-position)))
  (getMaterial [_] ((clojure.core/get m4131 :get-material)))
  (getModulate [_] ((clojure.core/get m4131 :get-modulate)))
  (getSelfModulate [_] ((clojure.core/get m4131 :get-self-modulate)))
  (getTransform [_] ((clojure.core/get m4131 :get-transform)))
  (getUseParentMaterial
   [_]
   ((clojure.core/get m4131 :get-use-parent-material)))
  (getViewportRect [_] ((clojure.core/get m4131 :get-viewport-rect)))
  (getViewportTransform
   [_]
   ((clojure.core/get m4131 :get-viewport-transform)))
  (getWorld2d [_] ((clojure.core/get m4131 :get-world-2d)))
  (hide [_] ((clojure.core/get m4131 :hide)))
  (isDrawBehindParentEnabled
   [_]
   ((clojure.core/get m4131 :is-draw-behind-parent-enabled)))
  (isLocalTransformNotificationEnabled
   [_]
   ((clojure.core/get m4131 :is-local-transform-notification-enabled)))
  (isSetAsToplevel [_] ((clojure.core/get m4131 :is-set-as-toplevel)))
  (isTransformNotificationEnabled
   [_]
   ((clojure.core/get m4131 :is-transform-notification-enabled)))
  (isVisible [_] ((clojure.core/get m4131 :is-visible)))
  (isVisibleInTree [_] ((clojure.core/get m4131 :is-visible-in-tree)))
  (makeCanvasPositionLocal
   [_ screen_point]
   ((clojure.core/get m4131 :make-canvas-position-local) screen_point))
  (makeInputLocal
   [_ event]
   ((clojure.core/get m4131 :make-input-local) event))
  (setAsToplevel
   [_ enable]
   ((clojure.core/get m4131 :set-as-toplevel) enable))
  (setDrawBehindParent
   [_ enable]
   ((clojure.core/get m4131 :set-draw-behind-parent) enable))
  (setLightMask
   [_ light_mask]
   ((clojure.core/get m4131 :set-light-mask) light_mask))
  (setMaterial
   [_ material]
   ((clojure.core/get m4131 :set-material) material))
  (setModulate
   [_ modulate]
   ((clojure.core/get m4131 :set-modulate) modulate))
  (setNotifyLocalTransform
   [_ enable]
   ((clojure.core/get m4131 :set-notify-local-transform) enable))
  (setNotifyTransform
   [_ enable]
   ((clojure.core/get m4131 :set-notify-transform) enable))
  (setSelfModulate
   [_ self_modulate]
   ((clojure.core/get m4131 :set-self-modulate) self_modulate))
  (setUseParentMaterial
   [_ enable]
   ((clojure.core/get m4131 :set-use-parent-material) enable))
  (setVisible
   [_ visible]
   ((clojure.core/get m4131 :set-visible) visible))
  (show [_] ((clojure.core/get m4131 :show)))
  (update [_] ((clojure.core/get m4131 :update)))
  (acceptEvent [_] ((clojure.core/get m4131 :accept-event)))
  (addColorOverride
   [_ name color]
   ((clojure.core/get m4131 :add-color-override) name color))
  (addConstantOverride
   [_ name constant]
   ((clojure.core/get m4131 :add-constant-override) name constant))
  (addFontOverride
   [_ name font]
   ((clojure.core/get m4131 :add-font-override) name font))
  (addIconOverride
   [_ name texture]
   ((clojure.core/get m4131 :add-icon-override) name texture))
  (addShaderOverride
   [_ name shader]
   ((clojure.core/get m4131 :add-shader-override) name shader))
  (addStyleboxOverride
   [_ name stylebox]
   ((clojure.core/get m4131 :add-stylebox-override) name stylebox))
  (canDropData
   [_ position data]
   ((clojure.core/get m4131 :can-drop-data) position data))
  (dropData
   [_ position data]
   ((clojure.core/get m4131 :drop-data) position data))
  (findNextValidFocus
   [_]
   ((clojure.core/get m4131 :find-next-valid-focus)))
  (findPrevValidFocus
   [_]
   ((clojure.core/get m4131 :find-prev-valid-focus)))
  (forceDrag
   [_ data preview]
   ((clojure.core/get m4131 :force-drag) data preview))
  (getAnchor [_ margin] ((clojure.core/get m4131 :get-anchor) margin))
  (getBegin [_] ((clojure.core/get m4131 :get-begin)))
  (getColor [_ name] ((clojure.core/get m4131 :get-color) name))
  (getColor
   [_ name node_type]
   ((clojure.core/get m4131 :get-color) name node_type))
  (getCombinedMinimumSize
   [_]
   ((clojure.core/get m4131 :get-combined-minimum-size)))
  (getConstant [_ name] ((clojure.core/get m4131 :get-constant) name))
  (getConstant
   [_ name node_type]
   ((clojure.core/get m4131 :get-constant) name node_type))
  (getCursorShape [_] ((clojure.core/get m4131 :get-cursor-shape)))
  (getCursorShape
   [_ position]
   ((clojure.core/get m4131 :get-cursor-shape) position))
  (getCustomMinimumSize
   [_]
   ((clojure.core/get m4131 :get-custom-minimum-size)))
  (getDefaultCursorShape
   [_]
   ((clojure.core/get m4131 :get-default-cursor-shape)))
  (getDragData
   [_ position]
   ((clojure.core/get m4131 :get-drag-data) position))
  (getEnd [_] ((clojure.core/get m4131 :get-end)))
  (getFocusMode [_] ((clojure.core/get m4131 :get-focus-mode)))
  (getFocusNeighbour
   [_ margin]
   ((clojure.core/get m4131 :get-focus-neighbour) margin))
  (getFocusNext [_] ((clojure.core/get m4131 :get-focus-next)))
  (getFocusOwner [_] ((clojure.core/get m4131 :get-focus-owner)))
  (getFocusPrevious
   [_]
   ((clojure.core/get m4131 :get-focus-previous)))
  (getFont [_ name] ((clojure.core/get m4131 :get-font) name))
  (getFont
   [_ name node_type]
   ((clojure.core/get m4131 :get-font) name node_type))
  (getGlobalPosition
   [_]
   ((clojure.core/get m4131 :get-global-position)))
  (getGlobalRect [_] ((clojure.core/get m4131 :get-global-rect)))
  (getHGrowDirection
   [_]
   ((clojure.core/get m4131 :get-h-grow-direction)))
  (getHSizeFlags [_] ((clojure.core/get m4131 :get-h-size-flags)))
  (getIcon [_ name] ((clojure.core/get m4131 :get-icon) name))
  (getIcon
   [_ name node_type]
   ((clojure.core/get m4131 :get-icon) name node_type))
  (getMargin [_ margin] ((clojure.core/get m4131 :get-margin) margin))
  (getMinimumSize [_] ((clojure.core/get m4131 :get-minimum-size)))
  (getMouseFilter [_] ((clojure.core/get m4131 :get-mouse-filter)))
  (getParentAreaSize
   [_]
   ((clojure.core/get m4131 :get-parent-area-size)))
  (getParentControl
   [_]
   ((clojure.core/get m4131 :get-parent-control)))
  (getPassOnModalCloseClick
   [_]
   ((clojure.core/get m4131 :get-pass-on-modal-close-click)))
  (getPivotOffset [_] ((clojure.core/get m4131 :get-pivot-offset)))
  (getPosition [_] ((clojure.core/get m4131 :get-position)))
  (getRect [_] ((clojure.core/get m4131 :get-rect)))
  (getRotation [_] ((clojure.core/get m4131 :get-rotation)))
  (getRotationDegrees
   [_]
   ((clojure.core/get m4131 :get-rotation-degrees)))
  (getScale [_] ((clojure.core/get m4131 :get-scale)))
  (getSize [_] ((clojure.core/get m4131 :get-size)))
  (getStretchRatio [_] ((clojure.core/get m4131 :get-stretch-ratio)))
  (getStylebox [_ name] ((clojure.core/get m4131 :get-stylebox) name))
  (getStylebox
   [_ name node_type]
   ((clojure.core/get m4131 :get-stylebox) name node_type))
  (getTheme [_] ((clojure.core/get m4131 :get-theme)))
  (getTooltip [_] ((clojure.core/get m4131 :get-tooltip)))
  (getTooltip
   [_ at_position]
   ((clojure.core/get m4131 :get-tooltip) at_position))
  (getVGrowDirection
   [_]
   ((clojure.core/get m4131 :get-v-grow-direction)))
  (getVSizeFlags [_] ((clojure.core/get m4131 :get-v-size-flags)))
  (grabClickFocus [_] ((clojure.core/get m4131 :grab-click-focus)))
  (grabFocus [_] ((clojure.core/get m4131 :grab-focus)))
  (hasColor [_ name] ((clojure.core/get m4131 :has-color) name))
  (hasColor
   [_ name node_type]
   ((clojure.core/get m4131 :has-color) name node_type))
  (hasColorOverride
   [_ name]
   ((clojure.core/get m4131 :has-color-override) name))
  (hasConstant [_ name] ((clojure.core/get m4131 :has-constant) name))
  (hasConstant
   [_ name node_type]
   ((clojure.core/get m4131 :has-constant) name node_type))
  (hasConstantOverride
   [_ name]
   ((clojure.core/get m4131 :has-constant-override) name))
  (hasFocus [_] ((clojure.core/get m4131 :has-focus)))
  (hasFont [_ name] ((clojure.core/get m4131 :has-font) name))
  (hasFont
   [_ name node_type]
   ((clojure.core/get m4131 :has-font) name node_type))
  (hasFontOverride
   [_ name]
   ((clojure.core/get m4131 :has-font-override) name))
  (hasIcon [_ name] ((clojure.core/get m4131 :has-icon) name))
  (hasIcon
   [_ name node_type]
   ((clojure.core/get m4131 :has-icon) name node_type))
  (hasIconOverride
   [_ name]
   ((clojure.core/get m4131 :has-icon-override) name))
  (hasPoint [_ point] ((clojure.core/get m4131 :has-point) point))
  (hasShaderOverride
   [_ name]
   ((clojure.core/get m4131 :has-shader-override) name))
  (hasStylebox [_ name] ((clojure.core/get m4131 :has-stylebox) name))
  (hasStylebox
   [_ name node_type]
   ((clojure.core/get m4131 :has-stylebox) name node_type))
  (hasStyleboxOverride
   [_ name]
   ((clojure.core/get m4131 :has-stylebox-override) name))
  (isClippingContents
   [_]
   ((clojure.core/get m4131 :is-clipping-contents)))
  (minimumSizeChanged
   [_]
   ((clojure.core/get m4131 :minimum-size-changed)))
  (releaseFocus [_] ((clojure.core/get m4131 :release-focus)))
  (setAnchor
   [_ margin anchor]
   ((clojure.core/get m4131 :set-anchor) margin anchor))
  (setAnchor
   [_ margin anchor keep_margin]
   ((clojure.core/get m4131 :set-anchor) margin anchor keep_margin))
  (setAnchor
   [_ margin anchor keep_margin push_opposite_anchor]
   ((clojure.core/get m4131 :set-anchor)
    margin
    anchor
    keep_margin
    push_opposite_anchor))
  (setAnchorAndMargin
   [_ margin anchor offset]
   ((clojure.core/get m4131 :set-anchor-and-margin)
    margin
    anchor
    offset))
  (setAnchorAndMargin
   [_ margin anchor offset push_opposite_anchor]
   ((clojure.core/get m4131 :set-anchor-and-margin)
    margin
    anchor
    offset
    push_opposite_anchor))
  (setAnchorsAndMarginsPreset
   [_ preset]
   ((clojure.core/get m4131 :set-anchors-and-margins-preset) preset))
  (setAnchorsAndMarginsPreset
   [_ preset resize_mode]
   ((clojure.core/get m4131 :set-anchors-and-margins-preset)
    preset
    resize_mode))
  (setAnchorsAndMarginsPreset
   [_ preset resize_mode margin]
   ((clojure.core/get m4131 :set-anchors-and-margins-preset)
    preset
    resize_mode
    margin))
  (setAnchorsPreset
   [_ preset]
   ((clojure.core/get m4131 :set-anchors-preset) preset))
  (setAnchorsPreset
   [_ preset keep_margins]
   ((clojure.core/get m4131 :set-anchors-preset) preset keep_margins))
  (setBegin
   [_ position]
   ((clojure.core/get m4131 :set-begin) position))
  (setClipContents
   [_ enable]
   ((clojure.core/get m4131 :set-clip-contents) enable))
  (setCustomMinimumSize
   [_ size]
   ((clojure.core/get m4131 :set-custom-minimum-size) size))
  (setDefaultCursorShape
   [_ shape]
   ((clojure.core/get m4131 :set-default-cursor-shape) shape))
  (setDragForwarding
   [_ target]
   ((clojure.core/get m4131 :set-drag-forwarding) target))
  (setDragPreview
   [_ control]
   ((clojure.core/get m4131 :set-drag-preview) control))
  (setEnd [_ position] ((clojure.core/get m4131 :set-end) position))
  (setFocusMode
   [_ mode]
   ((clojure.core/get m4131 :set-focus-mode) mode))
  (setFocusNeighbour
   [_ margin neighbour]
   ((clojure.core/get m4131 :set-focus-neighbour) margin neighbour))
  (setFocusNext
   [_ next]
   ((clojure.core/get m4131 :set-focus-next) next))
  (setFocusPrevious
   [_ previous]
   ((clojure.core/get m4131 :set-focus-previous) previous))
  (setGlobalPosition
   [_ position]
   ((clojure.core/get m4131 :set-global-position) position))
  (setGlobalPosition
   [_ position keep_margins]
   ((clojure.core/get m4131 :set-global-position)
    position
    keep_margins))
  (setHGrowDirection
   [_ direction]
   ((clojure.core/get m4131 :set-h-grow-direction) direction))
  (setHSizeFlags
   [_ flags]
   ((clojure.core/get m4131 :set-h-size-flags) flags))
  (setMargin
   [_ margin offset]
   ((clojure.core/get m4131 :set-margin) margin offset))
  (setMarginsPreset
   [_ preset]
   ((clojure.core/get m4131 :set-margins-preset) preset))
  (setMarginsPreset
   [_ preset resize_mode]
   ((clojure.core/get m4131 :set-margins-preset) preset resize_mode))
  (setMarginsPreset
   [_ preset resize_mode margin]
   ((clojure.core/get m4131 :set-margins-preset)
    preset
    resize_mode
    margin))
  (setMouseFilter
   [_ filter]
   ((clojure.core/get m4131 :set-mouse-filter) filter))
  (setPassOnModalCloseClick
   [_ enabled]
   ((clojure.core/get m4131 :set-pass-on-modal-close-click) enabled))
  (setPivotOffset
   [_ pivot_offset]
   ((clojure.core/get m4131 :set-pivot-offset) pivot_offset))
  (setPosition
   [_ position]
   ((clojure.core/get m4131 :set-position) position))
  (setPosition
   [_ position keep_margins]
   ((clojure.core/get m4131 :set-position) position keep_margins))
  (setRotation
   [_ radians]
   ((clojure.core/get m4131 :set-rotation) radians))
  (setRotationDegrees
   [_ degrees]
   ((clojure.core/get m4131 :set-rotation-degrees) degrees))
  (setScale [_ scale] ((clojure.core/get m4131 :set-scale) scale))
  (setSize [_ size] ((clojure.core/get m4131 :set-size) size))
  (setSize
   [_ size keep_margins]
   ((clojure.core/get m4131 :set-size) size keep_margins))
  (setStretchRatio
   [_ ratio]
   ((clojure.core/get m4131 :set-stretch-ratio) ratio))
  (setTheme [_ theme] ((clojure.core/get m4131 :set-theme) theme))
  (setTooltip
   [_ tooltip]
   ((clojure.core/get m4131 :set-tooltip) tooltip))
  (setVGrowDirection
   [_ direction]
   ((clojure.core/get m4131 :set-v-grow-direction) direction))
  (setVSizeFlags
   [_ flags]
   ((clojure.core/get m4131 :set-v-size-flags) flags))
  (showModal [_] ((clojure.core/get m4131 :show-modal)))
  (showModal
   [_ exclusive]
   ((clojure.core/get m4131 :show-modal) exclusive))
  (warpMouse
   [_ to_position]
   ((clojure.core/get m4131 :warp-mouse) to_position))
  (isExclusive [_] ((clojure.core/get m4131 :is-exclusive)))
  (popup [_] ((clojure.core/get m4131 :popup)))
  (popup [_ bounds] ((clojure.core/get m4131 :popup) bounds))
  (popupCentered [_] ((clojure.core/get m4131 :popup-centered)))
  (popupCentered
   [_ size]
   ((clojure.core/get m4131 :popup-centered) size))
  (popupCenteredClamped
   [_]
   ((clojure.core/get m4131 :popup-centered-clamped)))
  (popupCenteredClamped
   [_ size]
   ((clojure.core/get m4131 :popup-centered-clamped) size))
  (popupCenteredClamped
   [_ size fallback_ratio]
   ((clojure.core/get m4131 :popup-centered-clamped)
    size
    fallback_ratio))
  (popupCenteredMinsize
   [_]
   ((clojure.core/get m4131 :popup-centered-minsize)))
  (popupCenteredMinsize
   [_ minsize]
   ((clojure.core/get m4131 :popup-centered-minsize) minsize))
  (popupCenteredRatio
   [_]
   ((clojure.core/get m4131 :popup-centered-ratio)))
  (popupCenteredRatio
   [_ ratio]
   ((clojure.core/get m4131 :popup-centered-ratio) ratio))
  (setAsMinsize [_] ((clojure.core/get m4131 :set-as-minsize)))
  (setExclusive
   [_ enable]
   ((clojure.core/get m4131 :set-exclusive) enable)))
(deftype GodotWindowDialog
  [m4132]
  proto/ToVariant
  (->variant [this] (proto/->variant m4132))
  clojure.lang.ILookup
  (valAt [_ k] (get m4132 k))
  godotclj.api.gdscript.IGodotWindowDialog
  (addUserSignal
   [_ signal]
   ((clojure.core/get m4132 :add-user-signal) signal))
  (addUserSignal
   [_ signal arguments]
   ((clojure.core/get m4132 :add-user-signal) signal arguments))
  (call [_ method] ((clojure.core/get m4132 :call) method))
  (call [_ method v1] ((clojure.core/get m4132 :call) method v1))
  (call
   [_ method v1 v2]
   ((clojure.core/get m4132 :call) method v1 v2))
  (call
   [_ method v1 v2 v3]
   ((clojure.core/get m4132 :call) method v1 v2 v3))
  (call
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4132 :call) method v1 v2 v3 v4))
  (call
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4132 :call) method v1 v2 v3 v4 v5))
  (callDeferred
   [_ method]
   ((clojure.core/get m4132 :call-deferred) method))
  (callDeferred
   [_ method v1]
   ((clojure.core/get m4132 :call-deferred) method v1))
  (callDeferred
   [_ method v1 v2]
   ((clojure.core/get m4132 :call-deferred) method v1 v2))
  (callDeferred
   [_ method v1 v2 v3]
   ((clojure.core/get m4132 :call-deferred) method v1 v2 v3))
  (callDeferred
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4132 :call-deferred) method v1 v2 v3 v4))
  (callDeferred
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4132 :call-deferred) method v1 v2 v3 v4 v5))
  (callv
   [_ method arg_array]
   ((clojure.core/get m4132 :callv) method arg_array))
  (canTranslateMessages
   [_]
   ((clojure.core/get m4132 :can-translate-messages)))
  (connect
   [_ signal target method]
   ((clojure.core/get m4132 :connect) signal target method))
  (connect
   [_ signal target method binds]
   ((clojure.core/get m4132 :connect) signal target method binds))
  (connect
   [_ signal target method binds flags]
   ((clojure.core/get m4132 :connect)
    signal
    target
    method
    binds
    flags))
  (disconnect
   [_ signal target method]
   ((clojure.core/get m4132 :disconnect) signal target method))
  (emitSignal
   [_ signal]
   ((clojure.core/get m4132 :emit-signal) signal))
  (emitSignal
   [_ signal v1]
   ((clojure.core/get m4132 :emit-signal) signal v1))
  (emitSignal
   [_ signal v1 v2]
   ((clojure.core/get m4132 :emit-signal) signal v1 v2))
  (emitSignal
   [_ signal v1 v2 v3]
   ((clojure.core/get m4132 :emit-signal) signal v1 v2 v3))
  (emitSignal
   [_ signal v1 v2 v3 v4]
   ((clojure.core/get m4132 :emit-signal) signal v1 v2 v3 v4))
  (emitSignal
   [_ signal v1 v2 v3 v4 v5]
   ((clojure.core/get m4132 :emit-signal) signal v1 v2 v3 v4 v5))
  (free [_] ((clojure.core/get m4132 :free)))
  (get [_ property] ((clojure.core/get m4132 :get) property))
  (getClass [_] ((clojure.core/get m4132 :get-class)))
  (getIncomingConnections
   [_]
   ((clojure.core/get m4132 :get-incoming-connections)))
  (getIndexed
   [_ property]
   ((clojure.core/get m4132 :get-indexed) property))
  (getInstanceId [_] ((clojure.core/get m4132 :get-instance-id)))
  (getMeta [_ name] ((clojure.core/get m4132 :get-meta) name))
  (getMetaList [_] ((clojure.core/get m4132 :get-meta-list)))
  (getMethodList [_] ((clojure.core/get m4132 :get-method-list)))
  (getPropertyList [_] ((clojure.core/get m4132 :get-property-list)))
  (getScript [_] ((clojure.core/get m4132 :get-script)))
  (getSignalConnectionList
   [_ signal]
   ((clojure.core/get m4132 :get-signal-connection-list) signal))
  (getSignalList [_] ((clojure.core/get m4132 :get-signal-list)))
  (hasMeta [_ name] ((clojure.core/get m4132 :has-meta) name))
  (hasMethod [_ method] ((clojure.core/get m4132 :has-method) method))
  (hasSignal [_ signal] ((clojure.core/get m4132 :has-signal) signal))
  (hasUserSignal
   [_ signal]
   ((clojure.core/get m4132 :has-user-signal) signal))
  (isBlockingSignals
   [_]
   ((clojure.core/get m4132 :is-blocking-signals)))
  (isClass [_ class] ((clojure.core/get m4132 :is-class) class))
  (isConnected
   [_ signal target method]
   ((clojure.core/get m4132 :is-connected) signal target method))
  (isQueuedForDeletion
   [_]
   ((clojure.core/get m4132 :is-queued-for-deletion)))
  (notification
   [_ what]
   ((clojure.core/get m4132 :notification) what))
  (notification
   [_ what reversed]
   ((clojure.core/get m4132 :notification) what reversed))
  (propertyListChangedNotify
   [_]
   ((clojure.core/get m4132 :property-list-changed-notify)))
  (removeMeta [_ name] ((clojure.core/get m4132 :remove-meta) name))
  (set
   [_ property value]
   ((clojure.core/get m4132 :set) property value))
  (setBlockSignals
   [_ enable]
   ((clojure.core/get m4132 :set-block-signals) enable))
  (setDeferred
   [_ property value]
   ((clojure.core/get m4132 :set-deferred) property value))
  (setIndexed
   [_ property value]
   ((clojure.core/get m4132 :set-indexed) property value))
  (setMessageTranslation
   [_ enable]
   ((clojure.core/get m4132 :set-message-translation) enable))
  (setMeta
   [_ name value]
   ((clojure.core/get m4132 :set-meta) name value))
  (setScript [_ script] ((clojure.core/get m4132 :set-script) script))
  (tr [_ message] ((clojure.core/get m4132 :tr) message))
  (addChild [_ node] ((clojure.core/get m4132 :add-child) node))
  (addChild
   [_ node legible_unique_name]
   ((clojure.core/get m4132 :add-child) node legible_unique_name))
  (addChildBelowNode
   [_ node child_node]
   ((clojure.core/get m4132 :add-child-below-node) node child_node))
  (addChildBelowNode
   [_ node child_node legible_unique_name]
   ((clojure.core/get m4132 :add-child-below-node)
    node
    child_node
    legible_unique_name))
  (addToGroup
   [_ group]
   ((clojure.core/get m4132 :add-to-group) group))
  (addToGroup
   [_ group persistent]
   ((clojure.core/get m4132 :add-to-group) group persistent))
  (canProcess [_] ((clojure.core/get m4132 :can-process)))
  (duplicate [_] ((clojure.core/get m4132 :duplicate)))
  (duplicate [_ flags] ((clojure.core/get m4132 :duplicate) flags))
  (findNode [_ mask] ((clojure.core/get m4132 :find-node) mask))
  (findNode
   [_ mask recursive]
   ((clojure.core/get m4132 :find-node) mask recursive))
  (findNode
   [_ mask recursive owned]
   ((clojure.core/get m4132 :find-node) mask recursive owned))
  (findParent [_ mask] ((clojure.core/get m4132 :find-parent) mask))
  (getChild [_ idx] ((clojure.core/get m4132 :get-child) idx))
  (getChildCount [_] ((clojure.core/get m4132 :get-child-count)))
  (getChildren [_] ((clojure.core/get m4132 :get-children)))
  (getCustomMultiplayer
   [_]
   ((clojure.core/get m4132 :get-custom-multiplayer)))
  (getFilename [_] ((clojure.core/get m4132 :get-filename)))
  (getGroups [_] ((clojure.core/get m4132 :get-groups)))
  (getIndex [_] ((clojure.core/get m4132 :get-index)))
  (getMultiplayer [_] ((clojure.core/get m4132 :get-multiplayer)))
  (getName [_] ((clojure.core/get m4132 :get-name)))
  (getNetworkMaster
   [_]
   ((clojure.core/get m4132 :get-network-master)))
  (getNode [_ path] ((clojure.core/get m4132 :get-node) path))
  (getNodeAndResource
   [_ path]
   ((clojure.core/get m4132 :get-node-and-resource) path))
  (getNodeOrNull
   [_ path]
   ((clojure.core/get m4132 :get-node-or-null) path))
  (getOwner [_] ((clojure.core/get m4132 :get-owner)))
  (getParent [_] ((clojure.core/get m4132 :get-parent)))
  (getPath [_] ((clojure.core/get m4132 :get-path)))
  (getPathTo [_ node] ((clojure.core/get m4132 :get-path-to) node))
  (getPauseMode [_] ((clojure.core/get m4132 :get-pause-mode)))
  (getPhysicsProcessDeltaTime
   [_]
   ((clojure.core/get m4132 :get-physics-process-delta-time)))
  (getPositionInParent
   [_]
   ((clojure.core/get m4132 :get-position-in-parent)))
  (getProcessDeltaTime
   [_]
   ((clojure.core/get m4132 :get-process-delta-time)))
  (getProcessPriority
   [_]
   ((clojure.core/get m4132 :get-process-priority)))
  (getSceneInstanceLoadPlaceholder
   [_]
   ((clojure.core/get m4132 :get-scene-instance-load-placeholder)))
  (getTree [_] ((clojure.core/get m4132 :get-tree)))
  (getViewport [_] ((clojure.core/get m4132 :get-viewport)))
  (hasNode [_ path] ((clojure.core/get m4132 :has-node) path))
  (hasNodeAndResource
   [_ path]
   ((clojure.core/get m4132 :has-node-and-resource) path))
  (isAParentOf
   [_ node]
   ((clojure.core/get m4132 :is-a-parent-of) node))
  (isDisplayedFolded
   [_]
   ((clojure.core/get m4132 :is-displayed-folded)))
  (isGreaterThan
   [_ node]
   ((clojure.core/get m4132 :is-greater-than) node))
  (isInGroup [_ group] ((clojure.core/get m4132 :is-in-group) group))
  (isInsideTree [_] ((clojure.core/get m4132 :is-inside-tree)))
  (isNetworkMaster [_] ((clojure.core/get m4132 :is-network-master)))
  (isPhysicsProcessing
   [_]
   ((clojure.core/get m4132 :is-physics-processing)))
  (isPhysicsProcessingInternal
   [_]
   ((clojure.core/get m4132 :is-physics-processing-internal)))
  (isProcessing [_] ((clojure.core/get m4132 :is-processing)))
  (isProcessingInput
   [_]
   ((clojure.core/get m4132 :is-processing-input)))
  (isProcessingInternal
   [_]
   ((clojure.core/get m4132 :is-processing-internal)))
  (isProcessingUnhandledInput
   [_]
   ((clojure.core/get m4132 :is-processing-unhandled-input)))
  (isProcessingUnhandledKeyInput
   [_]
   ((clojure.core/get m4132 :is-processing-unhandled-key-input)))
  (moveChild
   [_ child_node to_position]
   ((clojure.core/get m4132 :move-child) child_node to_position))
  (printStrayNodes [_] ((clojure.core/get m4132 :print-stray-nodes)))
  (printTree [_] ((clojure.core/get m4132 :print-tree)))
  (printTreePretty [_] ((clojure.core/get m4132 :print-tree-pretty)))
  (propagateCall
   [_ method]
   ((clojure.core/get m4132 :propagate-call) method))
  (propagateCall
   [_ method args]
   ((clojure.core/get m4132 :propagate-call) method args))
  (propagateCall
   [_ method args parent_first]
   ((clojure.core/get m4132 :propagate-call) method args parent_first))
  (propagateNotification
   [_ what]
   ((clojure.core/get m4132 :propagate-notification) what))
  (queueFree [_] ((clojure.core/get m4132 :queue-free)))
  (raise [_] ((clojure.core/get m4132 :raise)))
  (removeAndSkip [_] ((clojure.core/get m4132 :remove-and-skip)))
  (removeChild [_ node] ((clojure.core/get m4132 :remove-child) node))
  (removeFromGroup
   [_ group]
   ((clojure.core/get m4132 :remove-from-group) group))
  (replaceBy [_ node] ((clojure.core/get m4132 :replace-by) node))
  (replaceBy
   [_ node keep_data]
   ((clojure.core/get m4132 :replace-by) node keep_data))
  (requestReady [_] ((clojure.core/get m4132 :request-ready)))
  (rpc [_ method] ((clojure.core/get m4132 :rpc) method))
  (rpc [_ method v1] ((clojure.core/get m4132 :rpc) method v1))
  (rpc [_ method v1 v2] ((clojure.core/get m4132 :rpc) method v1 v2))
  (rpc
   [_ method v1 v2 v3]
   ((clojure.core/get m4132 :rpc) method v1 v2 v3))
  (rpc
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4132 :rpc) method v1 v2 v3 v4))
  (rpc
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4132 :rpc) method v1 v2 v3 v4 v5))
  (rpcConfig
   [_ method mode]
   ((clojure.core/get m4132 :rpc-config) method mode))
  (rpcId
   [_ peer_id method]
   ((clojure.core/get m4132 :rpc-id) peer_id method))
  (rpcId
   [_ peer_id method v1]
   ((clojure.core/get m4132 :rpc-id) peer_id method v1))
  (rpcId
   [_ peer_id method v1 v2]
   ((clojure.core/get m4132 :rpc-id) peer_id method v1 v2))
  (rpcId
   [_ peer_id method v1 v2 v3]
   ((clojure.core/get m4132 :rpc-id) peer_id method v1 v2 v3))
  (rpcId
   [_ peer_id method v1 v2 v3 v4]
   ((clojure.core/get m4132 :rpc-id) peer_id method v1 v2 v3 v4))
  (rpcId
   [_ peer_id method v1 v2 v3 v4 v5]
   ((clojure.core/get m4132 :rpc-id) peer_id method v1 v2 v3 v4 v5))
  (rpcUnreliable
   [_ method]
   ((clojure.core/get m4132 :rpc-unreliable) method))
  (rpcUnreliable
   [_ method v1]
   ((clojure.core/get m4132 :rpc-unreliable) method v1))
  (rpcUnreliable
   [_ method v1 v2]
   ((clojure.core/get m4132 :rpc-unreliable) method v1 v2))
  (rpcUnreliable
   [_ method v1 v2 v3]
   ((clojure.core/get m4132 :rpc-unreliable) method v1 v2 v3))
  (rpcUnreliable
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4132 :rpc-unreliable) method v1 v2 v3 v4))
  (rpcUnreliable
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4132 :rpc-unreliable) method v1 v2 v3 v4 v5))
  (rpcUnreliableId
   [_ peer_id method]
   ((clojure.core/get m4132 :rpc-unreliable-id) peer_id method))
  (rpcUnreliableId
   [_ peer_id method v1]
   ((clojure.core/get m4132 :rpc-unreliable-id) peer_id method v1))
  (rpcUnreliableId
   [_ peer_id method v1 v2]
   ((clojure.core/get m4132 :rpc-unreliable-id) peer_id method v1 v2))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3]
   ((clojure.core/get m4132 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3 v4]
   ((clojure.core/get m4132 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3
    v4))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3 v4 v5]
   ((clojure.core/get m4132 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3
    v4
    v5))
  (rset
   [_ property value]
   ((clojure.core/get m4132 :rset) property value))
  (rsetConfig
   [_ property mode]
   ((clojure.core/get m4132 :rset-config) property mode))
  (rsetId
   [_ peer_id property value]
   ((clojure.core/get m4132 :rset-id) peer_id property value))
  (rsetUnreliable
   [_ property value]
   ((clojure.core/get m4132 :rset-unreliable) property value))
  (rsetUnreliableId
   [_ peer_id property value]
   ((clojure.core/get m4132 :rset-unreliable-id)
    peer_id
    property
    value))
  (setCustomMultiplayer
   [_ api]
   ((clojure.core/get m4132 :set-custom-multiplayer) api))
  (setDisplayFolded
   [_ fold]
   ((clojure.core/get m4132 :set-display-folded) fold))
  (setFilename
   [_ filename]
   ((clojure.core/get m4132 :set-filename) filename))
  (setName [_ name] ((clojure.core/get m4132 :set-name) name))
  (setNetworkMaster
   [_ id]
   ((clojure.core/get m4132 :set-network-master) id))
  (setNetworkMaster
   [_ id recursive]
   ((clojure.core/get m4132 :set-network-master) id recursive))
  (setOwner [_ owner] ((clojure.core/get m4132 :set-owner) owner))
  (setPauseMode
   [_ mode]
   ((clojure.core/get m4132 :set-pause-mode) mode))
  (setPhysicsProcess
   [_ enable]
   ((clojure.core/get m4132 :set-physics-process) enable))
  (setPhysicsProcessInternal
   [_ enable]
   ((clojure.core/get m4132 :set-physics-process-internal) enable))
  (setProcess
   [_ enable]
   ((clojure.core/get m4132 :set-process) enable))
  (setProcessInput
   [_ enable]
   ((clojure.core/get m4132 :set-process-input) enable))
  (setProcessInternal
   [_ enable]
   ((clojure.core/get m4132 :set-process-internal) enable))
  (setProcessPriority
   [_ priority]
   ((clojure.core/get m4132 :set-process-priority) priority))
  (setProcessUnhandledInput
   [_ enable]
   ((clojure.core/get m4132 :set-process-unhandled-input) enable))
  (setProcessUnhandledKeyInput
   [_ enable]
   ((clojure.core/get m4132 :set-process-unhandled-key-input) enable))
  (setSceneInstanceLoadPlaceholder
   [_ load_placeholder]
   ((clojure.core/get m4132 :set-scene-instance-load-placeholder)
    load_placeholder))
  (updateConfigurationWarning
   [_]
   ((clojure.core/get m4132 :update-configuration-warning)))
  (drawArc
   [_ center radius start_angle end_angle point_count color]
   ((clojure.core/get m4132 :draw-arc)
    center
    radius
    start_angle
    end_angle
    point_count
    color))
  (drawArc
   [_ center radius start_angle end_angle point_count color width]
   ((clojure.core/get m4132 :draw-arc)
    center
    radius
    start_angle
    end_angle
    point_count
    color
    width))
  (drawArc
   [_
    center
    radius
    start_angle
    end_angle
    point_count
    color
    width
    antialiased]
   ((clojure.core/get m4132 :draw-arc)
    center
    radius
    start_angle
    end_angle
    point_count
    color
    width
    antialiased))
  (drawChar
   [_ font position char next]
   ((clojure.core/get m4132 :draw-char) font position char next))
  (drawChar
   [_ font position char next modulate]
   ((clojure.core/get m4132 :draw-char)
    font
    position
    char
    next
    modulate))
  (drawCircle
   [_ position radius color]
   ((clojure.core/get m4132 :draw-circle) position radius color))
  (drawColoredPolygon
   [_ points color]
   ((clojure.core/get m4132 :draw-colored-polygon) points color))
  (drawColoredPolygon
   [_ points color uvs]
   ((clojure.core/get m4132 :draw-colored-polygon) points color uvs))
  (drawColoredPolygon
   [_ points color uvs texture]
   ((clojure.core/get m4132 :draw-colored-polygon)
    points
    color
    uvs
    texture))
  (drawColoredPolygon
   [_ points color uvs texture normal_map]
   ((clojure.core/get m4132 :draw-colored-polygon)
    points
    color
    uvs
    texture
    normal_map))
  (drawColoredPolygon
   [_ points color uvs texture normal_map antialiased]
   ((clojure.core/get m4132 :draw-colored-polygon)
    points
    color
    uvs
    texture
    normal_map
    antialiased))
  (drawLine
   [_ from to color]
   ((clojure.core/get m4132 :draw-line) from to color))
  (drawLine
   [_ from to color width]
   ((clojure.core/get m4132 :draw-line) from to color width))
  (drawLine
   [_ from to color width antialiased]
   ((clojure.core/get m4132 :draw-line)
    from
    to
    color
    width
    antialiased))
  (drawMesh
   [_ mesh texture]
   ((clojure.core/get m4132 :draw-mesh) mesh texture))
  (drawMesh
   [_ mesh texture normal_map]
   ((clojure.core/get m4132 :draw-mesh) mesh texture normal_map))
  (drawMesh
   [_ mesh texture normal_map transform]
   ((clojure.core/get m4132 :draw-mesh)
    mesh
    texture
    normal_map
    transform))
  (drawMesh
   [_ mesh texture normal_map transform modulate]
   ((clojure.core/get m4132 :draw-mesh)
    mesh
    texture
    normal_map
    transform
    modulate))
  (drawMultiline
   [_ points color]
   ((clojure.core/get m4132 :draw-multiline) points color))
  (drawMultiline
   [_ points color width]
   ((clojure.core/get m4132 :draw-multiline) points color width))
  (drawMultiline
   [_ points color width antialiased]
   ((clojure.core/get m4132 :draw-multiline)
    points
    color
    width
    antialiased))
  (drawMultilineColors
   [_ points colors]
   ((clojure.core/get m4132 :draw-multiline-colors) points colors))
  (drawMultilineColors
   [_ points colors width]
   ((clojure.core/get m4132 :draw-multiline-colors)
    points
    colors
    width))
  (drawMultilineColors
   [_ points colors width antialiased]
   ((clojure.core/get m4132 :draw-multiline-colors)
    points
    colors
    width
    antialiased))
  (drawMultimesh
   [_ multimesh texture]
   ((clojure.core/get m4132 :draw-multimesh) multimesh texture))
  (drawMultimesh
   [_ multimesh texture normal_map]
   ((clojure.core/get m4132 :draw-multimesh)
    multimesh
    texture
    normal_map))
  (drawPolygon
   [_ points colors]
   ((clojure.core/get m4132 :draw-polygon) points colors))
  (drawPolygon
   [_ points colors uvs]
   ((clojure.core/get m4132 :draw-polygon) points colors uvs))
  (drawPolygon
   [_ points colors uvs texture]
   ((clojure.core/get m4132 :draw-polygon) points colors uvs texture))
  (drawPolygon
   [_ points colors uvs texture normal_map]
   ((clojure.core/get m4132 :draw-polygon)
    points
    colors
    uvs
    texture
    normal_map))
  (drawPolygon
   [_ points colors uvs texture normal_map antialiased]
   ((clojure.core/get m4132 :draw-polygon)
    points
    colors
    uvs
    texture
    normal_map
    antialiased))
  (drawPolyline
   [_ points color]
   ((clojure.core/get m4132 :draw-polyline) points color))
  (drawPolyline
   [_ points color width]
   ((clojure.core/get m4132 :draw-polyline) points color width))
  (drawPolyline
   [_ points color width antialiased]
   ((clojure.core/get m4132 :draw-polyline)
    points
    color
    width
    antialiased))
  (drawPolylineColors
   [_ points colors]
   ((clojure.core/get m4132 :draw-polyline-colors) points colors))
  (drawPolylineColors
   [_ points colors width]
   ((clojure.core/get m4132 :draw-polyline-colors)
    points
    colors
    width))
  (drawPolylineColors
   [_ points colors width antialiased]
   ((clojure.core/get m4132 :draw-polyline-colors)
    points
    colors
    width
    antialiased))
  (drawPrimitive
   [_ points colors uvs]
   ((clojure.core/get m4132 :draw-primitive) points colors uvs))
  (drawPrimitive
   [_ points colors uvs texture]
   ((clojure.core/get m4132 :draw-primitive)
    points
    colors
    uvs
    texture))
  (drawPrimitive
   [_ points colors uvs texture width]
   ((clojure.core/get m4132 :draw-primitive)
    points
    colors
    uvs
    texture
    width))
  (drawPrimitive
   [_ points colors uvs texture width normal_map]
   ((clojure.core/get m4132 :draw-primitive)
    points
    colors
    uvs
    texture
    width
    normal_map))
  (drawRect
   [_ rect color]
   ((clojure.core/get m4132 :draw-rect) rect color))
  (drawRect
   [_ rect color filled]
   ((clojure.core/get m4132 :draw-rect) rect color filled))
  (drawRect
   [_ rect color filled width]
   ((clojure.core/get m4132 :draw-rect) rect color filled width))
  (drawRect
   [_ rect color filled width antialiased]
   ((clojure.core/get m4132 :draw-rect)
    rect
    color
    filled
    width
    antialiased))
  (drawSetTransform
   [_ position rotation scale]
   ((clojure.core/get m4132 :draw-set-transform)
    position
    rotation
    scale))
  (drawSetTransformMatrix
   [_ xform]
   ((clojure.core/get m4132 :draw-set-transform-matrix) xform))
  (drawString
   [_ font position text]
   ((clojure.core/get m4132 :draw-string) font position text))
  (drawString
   [_ font position text modulate]
   ((clojure.core/get m4132 :draw-string) font position text modulate))
  (drawString
   [_ font position text modulate clip_w]
   ((clojure.core/get m4132 :draw-string)
    font
    position
    text
    modulate
    clip_w))
  (drawStyleBox
   [_ style_box rect]
   ((clojure.core/get m4132 :draw-style-box) style_box rect))
  (drawTexture
   [_ texture position]
   ((clojure.core/get m4132 :draw-texture) texture position))
  (drawTexture
   [_ texture position modulate]
   ((clojure.core/get m4132 :draw-texture) texture position modulate))
  (drawTexture
   [_ texture position modulate normal_map]
   ((clojure.core/get m4132 :draw-texture)
    texture
    position
    modulate
    normal_map))
  (drawTextureRect
   [_ texture rect tile]
   ((clojure.core/get m4132 :draw-texture-rect) texture rect tile))
  (drawTextureRect
   [_ texture rect tile modulate]
   ((clojure.core/get m4132 :draw-texture-rect)
    texture
    rect
    tile
    modulate))
  (drawTextureRect
   [_ texture rect tile modulate transpose]
   ((clojure.core/get m4132 :draw-texture-rect)
    texture
    rect
    tile
    modulate
    transpose))
  (drawTextureRect
   [_ texture rect tile modulate transpose normal_map]
   ((clojure.core/get m4132 :draw-texture-rect)
    texture
    rect
    tile
    modulate
    transpose
    normal_map))
  (drawTextureRectRegion
   [_ texture rect src_rect]
   ((clojure.core/get m4132 :draw-texture-rect-region)
    texture
    rect
    src_rect))
  (drawTextureRectRegion
   [_ texture rect src_rect modulate]
   ((clojure.core/get m4132 :draw-texture-rect-region)
    texture
    rect
    src_rect
    modulate))
  (drawTextureRectRegion
   [_ texture rect src_rect modulate transpose]
   ((clojure.core/get m4132 :draw-texture-rect-region)
    texture
    rect
    src_rect
    modulate
    transpose))
  (drawTextureRectRegion
   [_ texture rect src_rect modulate transpose normal_map]
   ((clojure.core/get m4132 :draw-texture-rect-region)
    texture
    rect
    src_rect
    modulate
    transpose
    normal_map))
  (drawTextureRectRegion
   [_ texture rect src_rect modulate transpose normal_map clip_uv]
   ((clojure.core/get m4132 :draw-texture-rect-region)
    texture
    rect
    src_rect
    modulate
    transpose
    normal_map
    clip_uv))
  (forceUpdateTransform
   [_]
   ((clojure.core/get m4132 :force-update-transform)))
  (getCanvas [_] ((clojure.core/get m4132 :get-canvas)))
  (getCanvasItem [_] ((clojure.core/get m4132 :get-canvas-item)))
  (getCanvasTransform
   [_]
   ((clojure.core/get m4132 :get-canvas-transform)))
  (getGlobalMousePosition
   [_]
   ((clojure.core/get m4132 :get-global-mouse-position)))
  (getGlobalTransform
   [_]
   ((clojure.core/get m4132 :get-global-transform)))
  (getGlobalTransformWithCanvas
   [_]
   ((clojure.core/get m4132 :get-global-transform-with-canvas)))
  (getLightMask [_] ((clojure.core/get m4132 :get-light-mask)))
  (getLocalMousePosition
   [_]
   ((clojure.core/get m4132 :get-local-mouse-position)))
  (getMaterial [_] ((clojure.core/get m4132 :get-material)))
  (getModulate [_] ((clojure.core/get m4132 :get-modulate)))
  (getSelfModulate [_] ((clojure.core/get m4132 :get-self-modulate)))
  (getTransform [_] ((clojure.core/get m4132 :get-transform)))
  (getUseParentMaterial
   [_]
   ((clojure.core/get m4132 :get-use-parent-material)))
  (getViewportRect [_] ((clojure.core/get m4132 :get-viewport-rect)))
  (getViewportTransform
   [_]
   ((clojure.core/get m4132 :get-viewport-transform)))
  (getWorld2d [_] ((clojure.core/get m4132 :get-world-2d)))
  (hide [_] ((clojure.core/get m4132 :hide)))
  (isDrawBehindParentEnabled
   [_]
   ((clojure.core/get m4132 :is-draw-behind-parent-enabled)))
  (isLocalTransformNotificationEnabled
   [_]
   ((clojure.core/get m4132 :is-local-transform-notification-enabled)))
  (isSetAsToplevel [_] ((clojure.core/get m4132 :is-set-as-toplevel)))
  (isTransformNotificationEnabled
   [_]
   ((clojure.core/get m4132 :is-transform-notification-enabled)))
  (isVisible [_] ((clojure.core/get m4132 :is-visible)))
  (isVisibleInTree [_] ((clojure.core/get m4132 :is-visible-in-tree)))
  (makeCanvasPositionLocal
   [_ screen_point]
   ((clojure.core/get m4132 :make-canvas-position-local) screen_point))
  (makeInputLocal
   [_ event]
   ((clojure.core/get m4132 :make-input-local) event))
  (setAsToplevel
   [_ enable]
   ((clojure.core/get m4132 :set-as-toplevel) enable))
  (setDrawBehindParent
   [_ enable]
   ((clojure.core/get m4132 :set-draw-behind-parent) enable))
  (setLightMask
   [_ light_mask]
   ((clojure.core/get m4132 :set-light-mask) light_mask))
  (setMaterial
   [_ material]
   ((clojure.core/get m4132 :set-material) material))
  (setModulate
   [_ modulate]
   ((clojure.core/get m4132 :set-modulate) modulate))
  (setNotifyLocalTransform
   [_ enable]
   ((clojure.core/get m4132 :set-notify-local-transform) enable))
  (setNotifyTransform
   [_ enable]
   ((clojure.core/get m4132 :set-notify-transform) enable))
  (setSelfModulate
   [_ self_modulate]
   ((clojure.core/get m4132 :set-self-modulate) self_modulate))
  (setUseParentMaterial
   [_ enable]
   ((clojure.core/get m4132 :set-use-parent-material) enable))
  (setVisible
   [_ visible]
   ((clojure.core/get m4132 :set-visible) visible))
  (show [_] ((clojure.core/get m4132 :show)))
  (update [_] ((clojure.core/get m4132 :update)))
  (acceptEvent [_] ((clojure.core/get m4132 :accept-event)))
  (addColorOverride
   [_ name color]
   ((clojure.core/get m4132 :add-color-override) name color))
  (addConstantOverride
   [_ name constant]
   ((clojure.core/get m4132 :add-constant-override) name constant))
  (addFontOverride
   [_ name font]
   ((clojure.core/get m4132 :add-font-override) name font))
  (addIconOverride
   [_ name texture]
   ((clojure.core/get m4132 :add-icon-override) name texture))
  (addShaderOverride
   [_ name shader]
   ((clojure.core/get m4132 :add-shader-override) name shader))
  (addStyleboxOverride
   [_ name stylebox]
   ((clojure.core/get m4132 :add-stylebox-override) name stylebox))
  (canDropData
   [_ position data]
   ((clojure.core/get m4132 :can-drop-data) position data))
  (dropData
   [_ position data]
   ((clojure.core/get m4132 :drop-data) position data))
  (findNextValidFocus
   [_]
   ((clojure.core/get m4132 :find-next-valid-focus)))
  (findPrevValidFocus
   [_]
   ((clojure.core/get m4132 :find-prev-valid-focus)))
  (forceDrag
   [_ data preview]
   ((clojure.core/get m4132 :force-drag) data preview))
  (getAnchor [_ margin] ((clojure.core/get m4132 :get-anchor) margin))
  (getBegin [_] ((clojure.core/get m4132 :get-begin)))
  (getColor [_ name] ((clojure.core/get m4132 :get-color) name))
  (getColor
   [_ name node_type]
   ((clojure.core/get m4132 :get-color) name node_type))
  (getCombinedMinimumSize
   [_]
   ((clojure.core/get m4132 :get-combined-minimum-size)))
  (getConstant [_ name] ((clojure.core/get m4132 :get-constant) name))
  (getConstant
   [_ name node_type]
   ((clojure.core/get m4132 :get-constant) name node_type))
  (getCursorShape [_] ((clojure.core/get m4132 :get-cursor-shape)))
  (getCursorShape
   [_ position]
   ((clojure.core/get m4132 :get-cursor-shape) position))
  (getCustomMinimumSize
   [_]
   ((clojure.core/get m4132 :get-custom-minimum-size)))
  (getDefaultCursorShape
   [_]
   ((clojure.core/get m4132 :get-default-cursor-shape)))
  (getDragData
   [_ position]
   ((clojure.core/get m4132 :get-drag-data) position))
  (getEnd [_] ((clojure.core/get m4132 :get-end)))
  (getFocusMode [_] ((clojure.core/get m4132 :get-focus-mode)))
  (getFocusNeighbour
   [_ margin]
   ((clojure.core/get m4132 :get-focus-neighbour) margin))
  (getFocusNext [_] ((clojure.core/get m4132 :get-focus-next)))
  (getFocusOwner [_] ((clojure.core/get m4132 :get-focus-owner)))
  (getFocusPrevious
   [_]
   ((clojure.core/get m4132 :get-focus-previous)))
  (getFont [_ name] ((clojure.core/get m4132 :get-font) name))
  (getFont
   [_ name node_type]
   ((clojure.core/get m4132 :get-font) name node_type))
  (getGlobalPosition
   [_]
   ((clojure.core/get m4132 :get-global-position)))
  (getGlobalRect [_] ((clojure.core/get m4132 :get-global-rect)))
  (getHGrowDirection
   [_]
   ((clojure.core/get m4132 :get-h-grow-direction)))
  (getHSizeFlags [_] ((clojure.core/get m4132 :get-h-size-flags)))
  (getIcon [_ name] ((clojure.core/get m4132 :get-icon) name))
  (getIcon
   [_ name node_type]
   ((clojure.core/get m4132 :get-icon) name node_type))
  (getMargin [_ margin] ((clojure.core/get m4132 :get-margin) margin))
  (getMinimumSize [_] ((clojure.core/get m4132 :get-minimum-size)))
  (getMouseFilter [_] ((clojure.core/get m4132 :get-mouse-filter)))
  (getParentAreaSize
   [_]
   ((clojure.core/get m4132 :get-parent-area-size)))
  (getParentControl
   [_]
   ((clojure.core/get m4132 :get-parent-control)))
  (getPassOnModalCloseClick
   [_]
   ((clojure.core/get m4132 :get-pass-on-modal-close-click)))
  (getPivotOffset [_] ((clojure.core/get m4132 :get-pivot-offset)))
  (getPosition [_] ((clojure.core/get m4132 :get-position)))
  (getRect [_] ((clojure.core/get m4132 :get-rect)))
  (getRotation [_] ((clojure.core/get m4132 :get-rotation)))
  (getRotationDegrees
   [_]
   ((clojure.core/get m4132 :get-rotation-degrees)))
  (getScale [_] ((clojure.core/get m4132 :get-scale)))
  (getSize [_] ((clojure.core/get m4132 :get-size)))
  (getStretchRatio [_] ((clojure.core/get m4132 :get-stretch-ratio)))
  (getStylebox [_ name] ((clojure.core/get m4132 :get-stylebox) name))
  (getStylebox
   [_ name node_type]
   ((clojure.core/get m4132 :get-stylebox) name node_type))
  (getTheme [_] ((clojure.core/get m4132 :get-theme)))
  (getTooltip [_] ((clojure.core/get m4132 :get-tooltip)))
  (getTooltip
   [_ at_position]
   ((clojure.core/get m4132 :get-tooltip) at_position))
  (getVGrowDirection
   [_]
   ((clojure.core/get m4132 :get-v-grow-direction)))
  (getVSizeFlags [_] ((clojure.core/get m4132 :get-v-size-flags)))
  (grabClickFocus [_] ((clojure.core/get m4132 :grab-click-focus)))
  (grabFocus [_] ((clojure.core/get m4132 :grab-focus)))
  (hasColor [_ name] ((clojure.core/get m4132 :has-color) name))
  (hasColor
   [_ name node_type]
   ((clojure.core/get m4132 :has-color) name node_type))
  (hasColorOverride
   [_ name]
   ((clojure.core/get m4132 :has-color-override) name))
  (hasConstant [_ name] ((clojure.core/get m4132 :has-constant) name))
  (hasConstant
   [_ name node_type]
   ((clojure.core/get m4132 :has-constant) name node_type))
  (hasConstantOverride
   [_ name]
   ((clojure.core/get m4132 :has-constant-override) name))
  (hasFocus [_] ((clojure.core/get m4132 :has-focus)))
  (hasFont [_ name] ((clojure.core/get m4132 :has-font) name))
  (hasFont
   [_ name node_type]
   ((clojure.core/get m4132 :has-font) name node_type))
  (hasFontOverride
   [_ name]
   ((clojure.core/get m4132 :has-font-override) name))
  (hasIcon [_ name] ((clojure.core/get m4132 :has-icon) name))
  (hasIcon
   [_ name node_type]
   ((clojure.core/get m4132 :has-icon) name node_type))
  (hasIconOverride
   [_ name]
   ((clojure.core/get m4132 :has-icon-override) name))
  (hasPoint [_ point] ((clojure.core/get m4132 :has-point) point))
  (hasShaderOverride
   [_ name]
   ((clojure.core/get m4132 :has-shader-override) name))
  (hasStylebox [_ name] ((clojure.core/get m4132 :has-stylebox) name))
  (hasStylebox
   [_ name node_type]
   ((clojure.core/get m4132 :has-stylebox) name node_type))
  (hasStyleboxOverride
   [_ name]
   ((clojure.core/get m4132 :has-stylebox-override) name))
  (isClippingContents
   [_]
   ((clojure.core/get m4132 :is-clipping-contents)))
  (minimumSizeChanged
   [_]
   ((clojure.core/get m4132 :minimum-size-changed)))
  (releaseFocus [_] ((clojure.core/get m4132 :release-focus)))
  (setAnchor
   [_ margin anchor]
   ((clojure.core/get m4132 :set-anchor) margin anchor))
  (setAnchor
   [_ margin anchor keep_margin]
   ((clojure.core/get m4132 :set-anchor) margin anchor keep_margin))
  (setAnchor
   [_ margin anchor keep_margin push_opposite_anchor]
   ((clojure.core/get m4132 :set-anchor)
    margin
    anchor
    keep_margin
    push_opposite_anchor))
  (setAnchorAndMargin
   [_ margin anchor offset]
   ((clojure.core/get m4132 :set-anchor-and-margin)
    margin
    anchor
    offset))
  (setAnchorAndMargin
   [_ margin anchor offset push_opposite_anchor]
   ((clojure.core/get m4132 :set-anchor-and-margin)
    margin
    anchor
    offset
    push_opposite_anchor))
  (setAnchorsAndMarginsPreset
   [_ preset]
   ((clojure.core/get m4132 :set-anchors-and-margins-preset) preset))
  (setAnchorsAndMarginsPreset
   [_ preset resize_mode]
   ((clojure.core/get m4132 :set-anchors-and-margins-preset)
    preset
    resize_mode))
  (setAnchorsAndMarginsPreset
   [_ preset resize_mode margin]
   ((clojure.core/get m4132 :set-anchors-and-margins-preset)
    preset
    resize_mode
    margin))
  (setAnchorsPreset
   [_ preset]
   ((clojure.core/get m4132 :set-anchors-preset) preset))
  (setAnchorsPreset
   [_ preset keep_margins]
   ((clojure.core/get m4132 :set-anchors-preset) preset keep_margins))
  (setBegin
   [_ position]
   ((clojure.core/get m4132 :set-begin) position))
  (setClipContents
   [_ enable]
   ((clojure.core/get m4132 :set-clip-contents) enable))
  (setCustomMinimumSize
   [_ size]
   ((clojure.core/get m4132 :set-custom-minimum-size) size))
  (setDefaultCursorShape
   [_ shape]
   ((clojure.core/get m4132 :set-default-cursor-shape) shape))
  (setDragForwarding
   [_ target]
   ((clojure.core/get m4132 :set-drag-forwarding) target))
  (setDragPreview
   [_ control]
   ((clojure.core/get m4132 :set-drag-preview) control))
  (setEnd [_ position] ((clojure.core/get m4132 :set-end) position))
  (setFocusMode
   [_ mode]
   ((clojure.core/get m4132 :set-focus-mode) mode))
  (setFocusNeighbour
   [_ margin neighbour]
   ((clojure.core/get m4132 :set-focus-neighbour) margin neighbour))
  (setFocusNext
   [_ next]
   ((clojure.core/get m4132 :set-focus-next) next))
  (setFocusPrevious
   [_ previous]
   ((clojure.core/get m4132 :set-focus-previous) previous))
  (setGlobalPosition
   [_ position]
   ((clojure.core/get m4132 :set-global-position) position))
  (setGlobalPosition
   [_ position keep_margins]
   ((clojure.core/get m4132 :set-global-position)
    position
    keep_margins))
  (setHGrowDirection
   [_ direction]
   ((clojure.core/get m4132 :set-h-grow-direction) direction))
  (setHSizeFlags
   [_ flags]
   ((clojure.core/get m4132 :set-h-size-flags) flags))
  (setMargin
   [_ margin offset]
   ((clojure.core/get m4132 :set-margin) margin offset))
  (setMarginsPreset
   [_ preset]
   ((clojure.core/get m4132 :set-margins-preset) preset))
  (setMarginsPreset
   [_ preset resize_mode]
   ((clojure.core/get m4132 :set-margins-preset) preset resize_mode))
  (setMarginsPreset
   [_ preset resize_mode margin]
   ((clojure.core/get m4132 :set-margins-preset)
    preset
    resize_mode
    margin))
  (setMouseFilter
   [_ filter]
   ((clojure.core/get m4132 :set-mouse-filter) filter))
  (setPassOnModalCloseClick
   [_ enabled]
   ((clojure.core/get m4132 :set-pass-on-modal-close-click) enabled))
  (setPivotOffset
   [_ pivot_offset]
   ((clojure.core/get m4132 :set-pivot-offset) pivot_offset))
  (setPosition
   [_ position]
   ((clojure.core/get m4132 :set-position) position))
  (setPosition
   [_ position keep_margins]
   ((clojure.core/get m4132 :set-position) position keep_margins))
  (setRotation
   [_ radians]
   ((clojure.core/get m4132 :set-rotation) radians))
  (setRotationDegrees
   [_ degrees]
   ((clojure.core/get m4132 :set-rotation-degrees) degrees))
  (setScale [_ scale] ((clojure.core/get m4132 :set-scale) scale))
  (setSize [_ size] ((clojure.core/get m4132 :set-size) size))
  (setSize
   [_ size keep_margins]
   ((clojure.core/get m4132 :set-size) size keep_margins))
  (setStretchRatio
   [_ ratio]
   ((clojure.core/get m4132 :set-stretch-ratio) ratio))
  (setTheme [_ theme] ((clojure.core/get m4132 :set-theme) theme))
  (setTooltip
   [_ tooltip]
   ((clojure.core/get m4132 :set-tooltip) tooltip))
  (setVGrowDirection
   [_ direction]
   ((clojure.core/get m4132 :set-v-grow-direction) direction))
  (setVSizeFlags
   [_ flags]
   ((clojure.core/get m4132 :set-v-size-flags) flags))
  (showModal [_] ((clojure.core/get m4132 :show-modal)))
  (showModal
   [_ exclusive]
   ((clojure.core/get m4132 :show-modal) exclusive))
  (warpMouse
   [_ to_position]
   ((clojure.core/get m4132 :warp-mouse) to_position))
  (isExclusive [_] ((clojure.core/get m4132 :is-exclusive)))
  (popup [_] ((clojure.core/get m4132 :popup)))
  (popup [_ bounds] ((clojure.core/get m4132 :popup) bounds))
  (popupCentered [_] ((clojure.core/get m4132 :popup-centered)))
  (popupCentered
   [_ size]
   ((clojure.core/get m4132 :popup-centered) size))
  (popupCenteredClamped
   [_]
   ((clojure.core/get m4132 :popup-centered-clamped)))
  (popupCenteredClamped
   [_ size]
   ((clojure.core/get m4132 :popup-centered-clamped) size))
  (popupCenteredClamped
   [_ size fallback_ratio]
   ((clojure.core/get m4132 :popup-centered-clamped)
    size
    fallback_ratio))
  (popupCenteredMinsize
   [_]
   ((clojure.core/get m4132 :popup-centered-minsize)))
  (popupCenteredMinsize
   [_ minsize]
   ((clojure.core/get m4132 :popup-centered-minsize) minsize))
  (popupCenteredRatio
   [_]
   ((clojure.core/get m4132 :popup-centered-ratio)))
  (popupCenteredRatio
   [_ ratio]
   ((clojure.core/get m4132 :popup-centered-ratio) ratio))
  (setAsMinsize [_] ((clojure.core/get m4132 :set-as-minsize)))
  (setExclusive
   [_ enable]
   ((clojure.core/get m4132 :set-exclusive) enable))
  (getCloseButton [_] ((clojure.core/get m4132 :get-close-button)))
  (getResizable [_] ((clojure.core/get m4132 :get-resizable)))
  (getTitle [_] ((clojure.core/get m4132 :get-title)))
  (setResizable
   [_ resizable]
   ((clojure.core/get m4132 :set-resizable) resizable))
  (setTitle [_ title] ((clojure.core/get m4132 :set-title) title)))
(deftype GodotAcceptDialog
  [m4133]
  proto/ToVariant
  (->variant [this] (proto/->variant m4133))
  clojure.lang.ILookup
  (valAt [_ k] (get m4133 k))
  godotclj.api.gdscript.IGodotAcceptDialog
  (addUserSignal
   [_ signal]
   ((clojure.core/get m4133 :add-user-signal) signal))
  (addUserSignal
   [_ signal arguments]
   ((clojure.core/get m4133 :add-user-signal) signal arguments))
  (call [_ method] ((clojure.core/get m4133 :call) method))
  (call [_ method v1] ((clojure.core/get m4133 :call) method v1))
  (call
   [_ method v1 v2]
   ((clojure.core/get m4133 :call) method v1 v2))
  (call
   [_ method v1 v2 v3]
   ((clojure.core/get m4133 :call) method v1 v2 v3))
  (call
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4133 :call) method v1 v2 v3 v4))
  (call
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4133 :call) method v1 v2 v3 v4 v5))
  (callDeferred
   [_ method]
   ((clojure.core/get m4133 :call-deferred) method))
  (callDeferred
   [_ method v1]
   ((clojure.core/get m4133 :call-deferred) method v1))
  (callDeferred
   [_ method v1 v2]
   ((clojure.core/get m4133 :call-deferred) method v1 v2))
  (callDeferred
   [_ method v1 v2 v3]
   ((clojure.core/get m4133 :call-deferred) method v1 v2 v3))
  (callDeferred
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4133 :call-deferred) method v1 v2 v3 v4))
  (callDeferred
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4133 :call-deferred) method v1 v2 v3 v4 v5))
  (callv
   [_ method arg_array]
   ((clojure.core/get m4133 :callv) method arg_array))
  (canTranslateMessages
   [_]
   ((clojure.core/get m4133 :can-translate-messages)))
  (connect
   [_ signal target method]
   ((clojure.core/get m4133 :connect) signal target method))
  (connect
   [_ signal target method binds]
   ((clojure.core/get m4133 :connect) signal target method binds))
  (connect
   [_ signal target method binds flags]
   ((clojure.core/get m4133 :connect)
    signal
    target
    method
    binds
    flags))
  (disconnect
   [_ signal target method]
   ((clojure.core/get m4133 :disconnect) signal target method))
  (emitSignal
   [_ signal]
   ((clojure.core/get m4133 :emit-signal) signal))
  (emitSignal
   [_ signal v1]
   ((clojure.core/get m4133 :emit-signal) signal v1))
  (emitSignal
   [_ signal v1 v2]
   ((clojure.core/get m4133 :emit-signal) signal v1 v2))
  (emitSignal
   [_ signal v1 v2 v3]
   ((clojure.core/get m4133 :emit-signal) signal v1 v2 v3))
  (emitSignal
   [_ signal v1 v2 v3 v4]
   ((clojure.core/get m4133 :emit-signal) signal v1 v2 v3 v4))
  (emitSignal
   [_ signal v1 v2 v3 v4 v5]
   ((clojure.core/get m4133 :emit-signal) signal v1 v2 v3 v4 v5))
  (free [_] ((clojure.core/get m4133 :free)))
  (get [_ property] ((clojure.core/get m4133 :get) property))
  (getClass [_] ((clojure.core/get m4133 :get-class)))
  (getIncomingConnections
   [_]
   ((clojure.core/get m4133 :get-incoming-connections)))
  (getIndexed
   [_ property]
   ((clojure.core/get m4133 :get-indexed) property))
  (getInstanceId [_] ((clojure.core/get m4133 :get-instance-id)))
  (getMeta [_ name] ((clojure.core/get m4133 :get-meta) name))
  (getMetaList [_] ((clojure.core/get m4133 :get-meta-list)))
  (getMethodList [_] ((clojure.core/get m4133 :get-method-list)))
  (getPropertyList [_] ((clojure.core/get m4133 :get-property-list)))
  (getScript [_] ((clojure.core/get m4133 :get-script)))
  (getSignalConnectionList
   [_ signal]
   ((clojure.core/get m4133 :get-signal-connection-list) signal))
  (getSignalList [_] ((clojure.core/get m4133 :get-signal-list)))
  (hasMeta [_ name] ((clojure.core/get m4133 :has-meta) name))
  (hasMethod [_ method] ((clojure.core/get m4133 :has-method) method))
  (hasSignal [_ signal] ((clojure.core/get m4133 :has-signal) signal))
  (hasUserSignal
   [_ signal]
   ((clojure.core/get m4133 :has-user-signal) signal))
  (isBlockingSignals
   [_]
   ((clojure.core/get m4133 :is-blocking-signals)))
  (isClass [_ class] ((clojure.core/get m4133 :is-class) class))
  (isConnected
   [_ signal target method]
   ((clojure.core/get m4133 :is-connected) signal target method))
  (isQueuedForDeletion
   [_]
   ((clojure.core/get m4133 :is-queued-for-deletion)))
  (notification
   [_ what]
   ((clojure.core/get m4133 :notification) what))
  (notification
   [_ what reversed]
   ((clojure.core/get m4133 :notification) what reversed))
  (propertyListChangedNotify
   [_]
   ((clojure.core/get m4133 :property-list-changed-notify)))
  (removeMeta [_ name] ((clojure.core/get m4133 :remove-meta) name))
  (set
   [_ property value]
   ((clojure.core/get m4133 :set) property value))
  (setBlockSignals
   [_ enable]
   ((clojure.core/get m4133 :set-block-signals) enable))
  (setDeferred
   [_ property value]
   ((clojure.core/get m4133 :set-deferred) property value))
  (setIndexed
   [_ property value]
   ((clojure.core/get m4133 :set-indexed) property value))
  (setMessageTranslation
   [_ enable]
   ((clojure.core/get m4133 :set-message-translation) enable))
  (setMeta
   [_ name value]
   ((clojure.core/get m4133 :set-meta) name value))
  (setScript [_ script] ((clojure.core/get m4133 :set-script) script))
  (tr [_ message] ((clojure.core/get m4133 :tr) message))
  (addChild [_ node] ((clojure.core/get m4133 :add-child) node))
  (addChild
   [_ node legible_unique_name]
   ((clojure.core/get m4133 :add-child) node legible_unique_name))
  (addChildBelowNode
   [_ node child_node]
   ((clojure.core/get m4133 :add-child-below-node) node child_node))
  (addChildBelowNode
   [_ node child_node legible_unique_name]
   ((clojure.core/get m4133 :add-child-below-node)
    node
    child_node
    legible_unique_name))
  (addToGroup
   [_ group]
   ((clojure.core/get m4133 :add-to-group) group))
  (addToGroup
   [_ group persistent]
   ((clojure.core/get m4133 :add-to-group) group persistent))
  (canProcess [_] ((clojure.core/get m4133 :can-process)))
  (duplicate [_] ((clojure.core/get m4133 :duplicate)))
  (duplicate [_ flags] ((clojure.core/get m4133 :duplicate) flags))
  (findNode [_ mask] ((clojure.core/get m4133 :find-node) mask))
  (findNode
   [_ mask recursive]
   ((clojure.core/get m4133 :find-node) mask recursive))
  (findNode
   [_ mask recursive owned]
   ((clojure.core/get m4133 :find-node) mask recursive owned))
  (findParent [_ mask] ((clojure.core/get m4133 :find-parent) mask))
  (getChild [_ idx] ((clojure.core/get m4133 :get-child) idx))
  (getChildCount [_] ((clojure.core/get m4133 :get-child-count)))
  (getChildren [_] ((clojure.core/get m4133 :get-children)))
  (getCustomMultiplayer
   [_]
   ((clojure.core/get m4133 :get-custom-multiplayer)))
  (getFilename [_] ((clojure.core/get m4133 :get-filename)))
  (getGroups [_] ((clojure.core/get m4133 :get-groups)))
  (getIndex [_] ((clojure.core/get m4133 :get-index)))
  (getMultiplayer [_] ((clojure.core/get m4133 :get-multiplayer)))
  (getName [_] ((clojure.core/get m4133 :get-name)))
  (getNetworkMaster
   [_]
   ((clojure.core/get m4133 :get-network-master)))
  (getNode [_ path] ((clojure.core/get m4133 :get-node) path))
  (getNodeAndResource
   [_ path]
   ((clojure.core/get m4133 :get-node-and-resource) path))
  (getNodeOrNull
   [_ path]
   ((clojure.core/get m4133 :get-node-or-null) path))
  (getOwner [_] ((clojure.core/get m4133 :get-owner)))
  (getParent [_] ((clojure.core/get m4133 :get-parent)))
  (getPath [_] ((clojure.core/get m4133 :get-path)))
  (getPathTo [_ node] ((clojure.core/get m4133 :get-path-to) node))
  (getPauseMode [_] ((clojure.core/get m4133 :get-pause-mode)))
  (getPhysicsProcessDeltaTime
   [_]
   ((clojure.core/get m4133 :get-physics-process-delta-time)))
  (getPositionInParent
   [_]
   ((clojure.core/get m4133 :get-position-in-parent)))
  (getProcessDeltaTime
   [_]
   ((clojure.core/get m4133 :get-process-delta-time)))
  (getProcessPriority
   [_]
   ((clojure.core/get m4133 :get-process-priority)))
  (getSceneInstanceLoadPlaceholder
   [_]
   ((clojure.core/get m4133 :get-scene-instance-load-placeholder)))
  (getTree [_] ((clojure.core/get m4133 :get-tree)))
  (getViewport [_] ((clojure.core/get m4133 :get-viewport)))
  (hasNode [_ path] ((clojure.core/get m4133 :has-node) path))
  (hasNodeAndResource
   [_ path]
   ((clojure.core/get m4133 :has-node-and-resource) path))
  (isAParentOf
   [_ node]
   ((clojure.core/get m4133 :is-a-parent-of) node))
  (isDisplayedFolded
   [_]
   ((clojure.core/get m4133 :is-displayed-folded)))
  (isGreaterThan
   [_ node]
   ((clojure.core/get m4133 :is-greater-than) node))
  (isInGroup [_ group] ((clojure.core/get m4133 :is-in-group) group))
  (isInsideTree [_] ((clojure.core/get m4133 :is-inside-tree)))
  (isNetworkMaster [_] ((clojure.core/get m4133 :is-network-master)))
  (isPhysicsProcessing
   [_]
   ((clojure.core/get m4133 :is-physics-processing)))
  (isPhysicsProcessingInternal
   [_]
   ((clojure.core/get m4133 :is-physics-processing-internal)))
  (isProcessing [_] ((clojure.core/get m4133 :is-processing)))
  (isProcessingInput
   [_]
   ((clojure.core/get m4133 :is-processing-input)))
  (isProcessingInternal
   [_]
   ((clojure.core/get m4133 :is-processing-internal)))
  (isProcessingUnhandledInput
   [_]
   ((clojure.core/get m4133 :is-processing-unhandled-input)))
  (isProcessingUnhandledKeyInput
   [_]
   ((clojure.core/get m4133 :is-processing-unhandled-key-input)))
  (moveChild
   [_ child_node to_position]
   ((clojure.core/get m4133 :move-child) child_node to_position))
  (printStrayNodes [_] ((clojure.core/get m4133 :print-stray-nodes)))
  (printTree [_] ((clojure.core/get m4133 :print-tree)))
  (printTreePretty [_] ((clojure.core/get m4133 :print-tree-pretty)))
  (propagateCall
   [_ method]
   ((clojure.core/get m4133 :propagate-call) method))
  (propagateCall
   [_ method args]
   ((clojure.core/get m4133 :propagate-call) method args))
  (propagateCall
   [_ method args parent_first]
   ((clojure.core/get m4133 :propagate-call) method args parent_first))
  (propagateNotification
   [_ what]
   ((clojure.core/get m4133 :propagate-notification) what))
  (queueFree [_] ((clojure.core/get m4133 :queue-free)))
  (raise [_] ((clojure.core/get m4133 :raise)))
  (removeAndSkip [_] ((clojure.core/get m4133 :remove-and-skip)))
  (removeChild [_ node] ((clojure.core/get m4133 :remove-child) node))
  (removeFromGroup
   [_ group]
   ((clojure.core/get m4133 :remove-from-group) group))
  (replaceBy [_ node] ((clojure.core/get m4133 :replace-by) node))
  (replaceBy
   [_ node keep_data]
   ((clojure.core/get m4133 :replace-by) node keep_data))
  (requestReady [_] ((clojure.core/get m4133 :request-ready)))
  (rpc [_ method] ((clojure.core/get m4133 :rpc) method))
  (rpc [_ method v1] ((clojure.core/get m4133 :rpc) method v1))
  (rpc [_ method v1 v2] ((clojure.core/get m4133 :rpc) method v1 v2))
  (rpc
   [_ method v1 v2 v3]
   ((clojure.core/get m4133 :rpc) method v1 v2 v3))
  (rpc
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4133 :rpc) method v1 v2 v3 v4))
  (rpc
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4133 :rpc) method v1 v2 v3 v4 v5))
  (rpcConfig
   [_ method mode]
   ((clojure.core/get m4133 :rpc-config) method mode))
  (rpcId
   [_ peer_id method]
   ((clojure.core/get m4133 :rpc-id) peer_id method))
  (rpcId
   [_ peer_id method v1]
   ((clojure.core/get m4133 :rpc-id) peer_id method v1))
  (rpcId
   [_ peer_id method v1 v2]
   ((clojure.core/get m4133 :rpc-id) peer_id method v1 v2))
  (rpcId
   [_ peer_id method v1 v2 v3]
   ((clojure.core/get m4133 :rpc-id) peer_id method v1 v2 v3))
  (rpcId
   [_ peer_id method v1 v2 v3 v4]
   ((clojure.core/get m4133 :rpc-id) peer_id method v1 v2 v3 v4))
  (rpcId
   [_ peer_id method v1 v2 v3 v4 v5]
   ((clojure.core/get m4133 :rpc-id) peer_id method v1 v2 v3 v4 v5))
  (rpcUnreliable
   [_ method]
   ((clojure.core/get m4133 :rpc-unreliable) method))
  (rpcUnreliable
   [_ method v1]
   ((clojure.core/get m4133 :rpc-unreliable) method v1))
  (rpcUnreliable
   [_ method v1 v2]
   ((clojure.core/get m4133 :rpc-unreliable) method v1 v2))
  (rpcUnreliable
   [_ method v1 v2 v3]
   ((clojure.core/get m4133 :rpc-unreliable) method v1 v2 v3))
  (rpcUnreliable
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4133 :rpc-unreliable) method v1 v2 v3 v4))
  (rpcUnreliable
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4133 :rpc-unreliable) method v1 v2 v3 v4 v5))
  (rpcUnreliableId
   [_ peer_id method]
   ((clojure.core/get m4133 :rpc-unreliable-id) peer_id method))
  (rpcUnreliableId
   [_ peer_id method v1]
   ((clojure.core/get m4133 :rpc-unreliable-id) peer_id method v1))
  (rpcUnreliableId
   [_ peer_id method v1 v2]
   ((clojure.core/get m4133 :rpc-unreliable-id) peer_id method v1 v2))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3]
   ((clojure.core/get m4133 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3 v4]
   ((clojure.core/get m4133 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3
    v4))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3 v4 v5]
   ((clojure.core/get m4133 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3
    v4
    v5))
  (rset
   [_ property value]
   ((clojure.core/get m4133 :rset) property value))
  (rsetConfig
   [_ property mode]
   ((clojure.core/get m4133 :rset-config) property mode))
  (rsetId
   [_ peer_id property value]
   ((clojure.core/get m4133 :rset-id) peer_id property value))
  (rsetUnreliable
   [_ property value]
   ((clojure.core/get m4133 :rset-unreliable) property value))
  (rsetUnreliableId
   [_ peer_id property value]
   ((clojure.core/get m4133 :rset-unreliable-id)
    peer_id
    property
    value))
  (setCustomMultiplayer
   [_ api]
   ((clojure.core/get m4133 :set-custom-multiplayer) api))
  (setDisplayFolded
   [_ fold]
   ((clojure.core/get m4133 :set-display-folded) fold))
  (setFilename
   [_ filename]
   ((clojure.core/get m4133 :set-filename) filename))
  (setName [_ name] ((clojure.core/get m4133 :set-name) name))
  (setNetworkMaster
   [_ id]
   ((clojure.core/get m4133 :set-network-master) id))
  (setNetworkMaster
   [_ id recursive]
   ((clojure.core/get m4133 :set-network-master) id recursive))
  (setOwner [_ owner] ((clojure.core/get m4133 :set-owner) owner))
  (setPauseMode
   [_ mode]
   ((clojure.core/get m4133 :set-pause-mode) mode))
  (setPhysicsProcess
   [_ enable]
   ((clojure.core/get m4133 :set-physics-process) enable))
  (setPhysicsProcessInternal
   [_ enable]
   ((clojure.core/get m4133 :set-physics-process-internal) enable))
  (setProcess
   [_ enable]
   ((clojure.core/get m4133 :set-process) enable))
  (setProcessInput
   [_ enable]
   ((clojure.core/get m4133 :set-process-input) enable))
  (setProcessInternal
   [_ enable]
   ((clojure.core/get m4133 :set-process-internal) enable))
  (setProcessPriority
   [_ priority]
   ((clojure.core/get m4133 :set-process-priority) priority))
  (setProcessUnhandledInput
   [_ enable]
   ((clojure.core/get m4133 :set-process-unhandled-input) enable))
  (setProcessUnhandledKeyInput
   [_ enable]
   ((clojure.core/get m4133 :set-process-unhandled-key-input) enable))
  (setSceneInstanceLoadPlaceholder
   [_ load_placeholder]
   ((clojure.core/get m4133 :set-scene-instance-load-placeholder)
    load_placeholder))
  (updateConfigurationWarning
   [_]
   ((clojure.core/get m4133 :update-configuration-warning)))
  (drawArc
   [_ center radius start_angle end_angle point_count color]
   ((clojure.core/get m4133 :draw-arc)
    center
    radius
    start_angle
    end_angle
    point_count
    color))
  (drawArc
   [_ center radius start_angle end_angle point_count color width]
   ((clojure.core/get m4133 :draw-arc)
    center
    radius
    start_angle
    end_angle
    point_count
    color
    width))
  (drawArc
   [_
    center
    radius
    start_angle
    end_angle
    point_count
    color
    width
    antialiased]
   ((clojure.core/get m4133 :draw-arc)
    center
    radius
    start_angle
    end_angle
    point_count
    color
    width
    antialiased))
  (drawChar
   [_ font position char next]
   ((clojure.core/get m4133 :draw-char) font position char next))
  (drawChar
   [_ font position char next modulate]
   ((clojure.core/get m4133 :draw-char)
    font
    position
    char
    next
    modulate))
  (drawCircle
   [_ position radius color]
   ((clojure.core/get m4133 :draw-circle) position radius color))
  (drawColoredPolygon
   [_ points color]
   ((clojure.core/get m4133 :draw-colored-polygon) points color))
  (drawColoredPolygon
   [_ points color uvs]
   ((clojure.core/get m4133 :draw-colored-polygon) points color uvs))
  (drawColoredPolygon
   [_ points color uvs texture]
   ((clojure.core/get m4133 :draw-colored-polygon)
    points
    color
    uvs
    texture))
  (drawColoredPolygon
   [_ points color uvs texture normal_map]
   ((clojure.core/get m4133 :draw-colored-polygon)
    points
    color
    uvs
    texture
    normal_map))
  (drawColoredPolygon
   [_ points color uvs texture normal_map antialiased]
   ((clojure.core/get m4133 :draw-colored-polygon)
    points
    color
    uvs
    texture
    normal_map
    antialiased))
  (drawLine
   [_ from to color]
   ((clojure.core/get m4133 :draw-line) from to color))
  (drawLine
   [_ from to color width]
   ((clojure.core/get m4133 :draw-line) from to color width))
  (drawLine
   [_ from to color width antialiased]
   ((clojure.core/get m4133 :draw-line)
    from
    to
    color
    width
    antialiased))
  (drawMesh
   [_ mesh texture]
   ((clojure.core/get m4133 :draw-mesh) mesh texture))
  (drawMesh
   [_ mesh texture normal_map]
   ((clojure.core/get m4133 :draw-mesh) mesh texture normal_map))
  (drawMesh
   [_ mesh texture normal_map transform]
   ((clojure.core/get m4133 :draw-mesh)
    mesh
    texture
    normal_map
    transform))
  (drawMesh
   [_ mesh texture normal_map transform modulate]
   ((clojure.core/get m4133 :draw-mesh)
    mesh
    texture
    normal_map
    transform
    modulate))
  (drawMultiline
   [_ points color]
   ((clojure.core/get m4133 :draw-multiline) points color))
  (drawMultiline
   [_ points color width]
   ((clojure.core/get m4133 :draw-multiline) points color width))
  (drawMultiline
   [_ points color width antialiased]
   ((clojure.core/get m4133 :draw-multiline)
    points
    color
    width
    antialiased))
  (drawMultilineColors
   [_ points colors]
   ((clojure.core/get m4133 :draw-multiline-colors) points colors))
  (drawMultilineColors
   [_ points colors width]
   ((clojure.core/get m4133 :draw-multiline-colors)
    points
    colors
    width))
  (drawMultilineColors
   [_ points colors width antialiased]
   ((clojure.core/get m4133 :draw-multiline-colors)
    points
    colors
    width
    antialiased))
  (drawMultimesh
   [_ multimesh texture]
   ((clojure.core/get m4133 :draw-multimesh) multimesh texture))
  (drawMultimesh
   [_ multimesh texture normal_map]
   ((clojure.core/get m4133 :draw-multimesh)
    multimesh
    texture
    normal_map))
  (drawPolygon
   [_ points colors]
   ((clojure.core/get m4133 :draw-polygon) points colors))
  (drawPolygon
   [_ points colors uvs]
   ((clojure.core/get m4133 :draw-polygon) points colors uvs))
  (drawPolygon
   [_ points colors uvs texture]
   ((clojure.core/get m4133 :draw-polygon) points colors uvs texture))
  (drawPolygon
   [_ points colors uvs texture normal_map]
   ((clojure.core/get m4133 :draw-polygon)
    points
    colors
    uvs
    texture
    normal_map))
  (drawPolygon
   [_ points colors uvs texture normal_map antialiased]
   ((clojure.core/get m4133 :draw-polygon)
    points
    colors
    uvs
    texture
    normal_map
    antialiased))
  (drawPolyline
   [_ points color]
   ((clojure.core/get m4133 :draw-polyline) points color))
  (drawPolyline
   [_ points color width]
   ((clojure.core/get m4133 :draw-polyline) points color width))
  (drawPolyline
   [_ points color width antialiased]
   ((clojure.core/get m4133 :draw-polyline)
    points
    color
    width
    antialiased))
  (drawPolylineColors
   [_ points colors]
   ((clojure.core/get m4133 :draw-polyline-colors) points colors))
  (drawPolylineColors
   [_ points colors width]
   ((clojure.core/get m4133 :draw-polyline-colors)
    points
    colors
    width))
  (drawPolylineColors
   [_ points colors width antialiased]
   ((clojure.core/get m4133 :draw-polyline-colors)
    points
    colors
    width
    antialiased))
  (drawPrimitive
   [_ points colors uvs]
   ((clojure.core/get m4133 :draw-primitive) points colors uvs))
  (drawPrimitive
   [_ points colors uvs texture]
   ((clojure.core/get m4133 :draw-primitive)
    points
    colors
    uvs
    texture))
  (drawPrimitive
   [_ points colors uvs texture width]
   ((clojure.core/get m4133 :draw-primitive)
    points
    colors
    uvs
    texture
    width))
  (drawPrimitive
   [_ points colors uvs texture width normal_map]
   ((clojure.core/get m4133 :draw-primitive)
    points
    colors
    uvs
    texture
    width
    normal_map))
  (drawRect
   [_ rect color]
   ((clojure.core/get m4133 :draw-rect) rect color))
  (drawRect
   [_ rect color filled]
   ((clojure.core/get m4133 :draw-rect) rect color filled))
  (drawRect
   [_ rect color filled width]
   ((clojure.core/get m4133 :draw-rect) rect color filled width))
  (drawRect
   [_ rect color filled width antialiased]
   ((clojure.core/get m4133 :draw-rect)
    rect
    color
    filled
    width
    antialiased))
  (drawSetTransform
   [_ position rotation scale]
   ((clojure.core/get m4133 :draw-set-transform)
    position
    rotation
    scale))
  (drawSetTransformMatrix
   [_ xform]
   ((clojure.core/get m4133 :draw-set-transform-matrix) xform))
  (drawString
   [_ font position text]
   ((clojure.core/get m4133 :draw-string) font position text))
  (drawString
   [_ font position text modulate]
   ((clojure.core/get m4133 :draw-string) font position text modulate))
  (drawString
   [_ font position text modulate clip_w]
   ((clojure.core/get m4133 :draw-string)
    font
    position
    text
    modulate
    clip_w))
  (drawStyleBox
   [_ style_box rect]
   ((clojure.core/get m4133 :draw-style-box) style_box rect))
  (drawTexture
   [_ texture position]
   ((clojure.core/get m4133 :draw-texture) texture position))
  (drawTexture
   [_ texture position modulate]
   ((clojure.core/get m4133 :draw-texture) texture position modulate))
  (drawTexture
   [_ texture position modulate normal_map]
   ((clojure.core/get m4133 :draw-texture)
    texture
    position
    modulate
    normal_map))
  (drawTextureRect
   [_ texture rect tile]
   ((clojure.core/get m4133 :draw-texture-rect) texture rect tile))
  (drawTextureRect
   [_ texture rect tile modulate]
   ((clojure.core/get m4133 :draw-texture-rect)
    texture
    rect
    tile
    modulate))
  (drawTextureRect
   [_ texture rect tile modulate transpose]
   ((clojure.core/get m4133 :draw-texture-rect)
    texture
    rect
    tile
    modulate
    transpose))
  (drawTextureRect
   [_ texture rect tile modulate transpose normal_map]
   ((clojure.core/get m4133 :draw-texture-rect)
    texture
    rect
    tile
    modulate
    transpose
    normal_map))
  (drawTextureRectRegion
   [_ texture rect src_rect]
   ((clojure.core/get m4133 :draw-texture-rect-region)
    texture
    rect
    src_rect))
  (drawTextureRectRegion
   [_ texture rect src_rect modulate]
   ((clojure.core/get m4133 :draw-texture-rect-region)
    texture
    rect
    src_rect
    modulate))
  (drawTextureRectRegion
   [_ texture rect src_rect modulate transpose]
   ((clojure.core/get m4133 :draw-texture-rect-region)
    texture
    rect
    src_rect
    modulate
    transpose))
  (drawTextureRectRegion
   [_ texture rect src_rect modulate transpose normal_map]
   ((clojure.core/get m4133 :draw-texture-rect-region)
    texture
    rect
    src_rect
    modulate
    transpose
    normal_map))
  (drawTextureRectRegion
   [_ texture rect src_rect modulate transpose normal_map clip_uv]
   ((clojure.core/get m4133 :draw-texture-rect-region)
    texture
    rect
    src_rect
    modulate
    transpose
    normal_map
    clip_uv))
  (forceUpdateTransform
   [_]
   ((clojure.core/get m4133 :force-update-transform)))
  (getCanvas [_] ((clojure.core/get m4133 :get-canvas)))
  (getCanvasItem [_] ((clojure.core/get m4133 :get-canvas-item)))
  (getCanvasTransform
   [_]
   ((clojure.core/get m4133 :get-canvas-transform)))
  (getGlobalMousePosition
   [_]
   ((clojure.core/get m4133 :get-global-mouse-position)))
  (getGlobalTransform
   [_]
   ((clojure.core/get m4133 :get-global-transform)))
  (getGlobalTransformWithCanvas
   [_]
   ((clojure.core/get m4133 :get-global-transform-with-canvas)))
  (getLightMask [_] ((clojure.core/get m4133 :get-light-mask)))
  (getLocalMousePosition
   [_]
   ((clojure.core/get m4133 :get-local-mouse-position)))
  (getMaterial [_] ((clojure.core/get m4133 :get-material)))
  (getModulate [_] ((clojure.core/get m4133 :get-modulate)))
  (getSelfModulate [_] ((clojure.core/get m4133 :get-self-modulate)))
  (getTransform [_] ((clojure.core/get m4133 :get-transform)))
  (getUseParentMaterial
   [_]
   ((clojure.core/get m4133 :get-use-parent-material)))
  (getViewportRect [_] ((clojure.core/get m4133 :get-viewport-rect)))
  (getViewportTransform
   [_]
   ((clojure.core/get m4133 :get-viewport-transform)))
  (getWorld2d [_] ((clojure.core/get m4133 :get-world-2d)))
  (hide [_] ((clojure.core/get m4133 :hide)))
  (isDrawBehindParentEnabled
   [_]
   ((clojure.core/get m4133 :is-draw-behind-parent-enabled)))
  (isLocalTransformNotificationEnabled
   [_]
   ((clojure.core/get m4133 :is-local-transform-notification-enabled)))
  (isSetAsToplevel [_] ((clojure.core/get m4133 :is-set-as-toplevel)))
  (isTransformNotificationEnabled
   [_]
   ((clojure.core/get m4133 :is-transform-notification-enabled)))
  (isVisible [_] ((clojure.core/get m4133 :is-visible)))
  (isVisibleInTree [_] ((clojure.core/get m4133 :is-visible-in-tree)))
  (makeCanvasPositionLocal
   [_ screen_point]
   ((clojure.core/get m4133 :make-canvas-position-local) screen_point))
  (makeInputLocal
   [_ event]
   ((clojure.core/get m4133 :make-input-local) event))
  (setAsToplevel
   [_ enable]
   ((clojure.core/get m4133 :set-as-toplevel) enable))
  (setDrawBehindParent
   [_ enable]
   ((clojure.core/get m4133 :set-draw-behind-parent) enable))
  (setLightMask
   [_ light_mask]
   ((clojure.core/get m4133 :set-light-mask) light_mask))
  (setMaterial
   [_ material]
   ((clojure.core/get m4133 :set-material) material))
  (setModulate
   [_ modulate]
   ((clojure.core/get m4133 :set-modulate) modulate))
  (setNotifyLocalTransform
   [_ enable]
   ((clojure.core/get m4133 :set-notify-local-transform) enable))
  (setNotifyTransform
   [_ enable]
   ((clojure.core/get m4133 :set-notify-transform) enable))
  (setSelfModulate
   [_ self_modulate]
   ((clojure.core/get m4133 :set-self-modulate) self_modulate))
  (setUseParentMaterial
   [_ enable]
   ((clojure.core/get m4133 :set-use-parent-material) enable))
  (setVisible
   [_ visible]
   ((clojure.core/get m4133 :set-visible) visible))
  (show [_] ((clojure.core/get m4133 :show)))
  (update [_] ((clojure.core/get m4133 :update)))
  (acceptEvent [_] ((clojure.core/get m4133 :accept-event)))
  (addColorOverride
   [_ name color]
   ((clojure.core/get m4133 :add-color-override) name color))
  (addConstantOverride
   [_ name constant]
   ((clojure.core/get m4133 :add-constant-override) name constant))
  (addFontOverride
   [_ name font]
   ((clojure.core/get m4133 :add-font-override) name font))
  (addIconOverride
   [_ name texture]
   ((clojure.core/get m4133 :add-icon-override) name texture))
  (addShaderOverride
   [_ name shader]
   ((clojure.core/get m4133 :add-shader-override) name shader))
  (addStyleboxOverride
   [_ name stylebox]
   ((clojure.core/get m4133 :add-stylebox-override) name stylebox))
  (canDropData
   [_ position data]
   ((clojure.core/get m4133 :can-drop-data) position data))
  (dropData
   [_ position data]
   ((clojure.core/get m4133 :drop-data) position data))
  (findNextValidFocus
   [_]
   ((clojure.core/get m4133 :find-next-valid-focus)))
  (findPrevValidFocus
   [_]
   ((clojure.core/get m4133 :find-prev-valid-focus)))
  (forceDrag
   [_ data preview]
   ((clojure.core/get m4133 :force-drag) data preview))
  (getAnchor [_ margin] ((clojure.core/get m4133 :get-anchor) margin))
  (getBegin [_] ((clojure.core/get m4133 :get-begin)))
  (getColor [_ name] ((clojure.core/get m4133 :get-color) name))
  (getColor
   [_ name node_type]
   ((clojure.core/get m4133 :get-color) name node_type))
  (getCombinedMinimumSize
   [_]
   ((clojure.core/get m4133 :get-combined-minimum-size)))
  (getConstant [_ name] ((clojure.core/get m4133 :get-constant) name))
  (getConstant
   [_ name node_type]
   ((clojure.core/get m4133 :get-constant) name node_type))
  (getCursorShape [_] ((clojure.core/get m4133 :get-cursor-shape)))
  (getCursorShape
   [_ position]
   ((clojure.core/get m4133 :get-cursor-shape) position))
  (getCustomMinimumSize
   [_]
   ((clojure.core/get m4133 :get-custom-minimum-size)))
  (getDefaultCursorShape
   [_]
   ((clojure.core/get m4133 :get-default-cursor-shape)))
  (getDragData
   [_ position]
   ((clojure.core/get m4133 :get-drag-data) position))
  (getEnd [_] ((clojure.core/get m4133 :get-end)))
  (getFocusMode [_] ((clojure.core/get m4133 :get-focus-mode)))
  (getFocusNeighbour
   [_ margin]
   ((clojure.core/get m4133 :get-focus-neighbour) margin))
  (getFocusNext [_] ((clojure.core/get m4133 :get-focus-next)))
  (getFocusOwner [_] ((clojure.core/get m4133 :get-focus-owner)))
  (getFocusPrevious
   [_]
   ((clojure.core/get m4133 :get-focus-previous)))
  (getFont [_ name] ((clojure.core/get m4133 :get-font) name))
  (getFont
   [_ name node_type]
   ((clojure.core/get m4133 :get-font) name node_type))
  (getGlobalPosition
   [_]
   ((clojure.core/get m4133 :get-global-position)))
  (getGlobalRect [_] ((clojure.core/get m4133 :get-global-rect)))
  (getHGrowDirection
   [_]
   ((clojure.core/get m4133 :get-h-grow-direction)))
  (getHSizeFlags [_] ((clojure.core/get m4133 :get-h-size-flags)))
  (getIcon [_ name] ((clojure.core/get m4133 :get-icon) name))
  (getIcon
   [_ name node_type]
   ((clojure.core/get m4133 :get-icon) name node_type))
  (getMargin [_ margin] ((clojure.core/get m4133 :get-margin) margin))
  (getMinimumSize [_] ((clojure.core/get m4133 :get-minimum-size)))
  (getMouseFilter [_] ((clojure.core/get m4133 :get-mouse-filter)))
  (getParentAreaSize
   [_]
   ((clojure.core/get m4133 :get-parent-area-size)))
  (getParentControl
   [_]
   ((clojure.core/get m4133 :get-parent-control)))
  (getPassOnModalCloseClick
   [_]
   ((clojure.core/get m4133 :get-pass-on-modal-close-click)))
  (getPivotOffset [_] ((clojure.core/get m4133 :get-pivot-offset)))
  (getPosition [_] ((clojure.core/get m4133 :get-position)))
  (getRect [_] ((clojure.core/get m4133 :get-rect)))
  (getRotation [_] ((clojure.core/get m4133 :get-rotation)))
  (getRotationDegrees
   [_]
   ((clojure.core/get m4133 :get-rotation-degrees)))
  (getScale [_] ((clojure.core/get m4133 :get-scale)))
  (getSize [_] ((clojure.core/get m4133 :get-size)))
  (getStretchRatio [_] ((clojure.core/get m4133 :get-stretch-ratio)))
  (getStylebox [_ name] ((clojure.core/get m4133 :get-stylebox) name))
  (getStylebox
   [_ name node_type]
   ((clojure.core/get m4133 :get-stylebox) name node_type))
  (getTheme [_] ((clojure.core/get m4133 :get-theme)))
  (getTooltip [_] ((clojure.core/get m4133 :get-tooltip)))
  (getTooltip
   [_ at_position]
   ((clojure.core/get m4133 :get-tooltip) at_position))
  (getVGrowDirection
   [_]
   ((clojure.core/get m4133 :get-v-grow-direction)))
  (getVSizeFlags [_] ((clojure.core/get m4133 :get-v-size-flags)))
  (grabClickFocus [_] ((clojure.core/get m4133 :grab-click-focus)))
  (grabFocus [_] ((clojure.core/get m4133 :grab-focus)))
  (hasColor [_ name] ((clojure.core/get m4133 :has-color) name))
  (hasColor
   [_ name node_type]
   ((clojure.core/get m4133 :has-color) name node_type))
  (hasColorOverride
   [_ name]
   ((clojure.core/get m4133 :has-color-override) name))
  (hasConstant [_ name] ((clojure.core/get m4133 :has-constant) name))
  (hasConstant
   [_ name node_type]
   ((clojure.core/get m4133 :has-constant) name node_type))
  (hasConstantOverride
   [_ name]
   ((clojure.core/get m4133 :has-constant-override) name))
  (hasFocus [_] ((clojure.core/get m4133 :has-focus)))
  (hasFont [_ name] ((clojure.core/get m4133 :has-font) name))
  (hasFont
   [_ name node_type]
   ((clojure.core/get m4133 :has-font) name node_type))
  (hasFontOverride
   [_ name]
   ((clojure.core/get m4133 :has-font-override) name))
  (hasIcon [_ name] ((clojure.core/get m4133 :has-icon) name))
  (hasIcon
   [_ name node_type]
   ((clojure.core/get m4133 :has-icon) name node_type))
  (hasIconOverride
   [_ name]
   ((clojure.core/get m4133 :has-icon-override) name))
  (hasPoint [_ point] ((clojure.core/get m4133 :has-point) point))
  (hasShaderOverride
   [_ name]
   ((clojure.core/get m4133 :has-shader-override) name))
  (hasStylebox [_ name] ((clojure.core/get m4133 :has-stylebox) name))
  (hasStylebox
   [_ name node_type]
   ((clojure.core/get m4133 :has-stylebox) name node_type))
  (hasStyleboxOverride
   [_ name]
   ((clojure.core/get m4133 :has-stylebox-override) name))
  (isClippingContents
   [_]
   ((clojure.core/get m4133 :is-clipping-contents)))
  (minimumSizeChanged
   [_]
   ((clojure.core/get m4133 :minimum-size-changed)))
  (releaseFocus [_] ((clojure.core/get m4133 :release-focus)))
  (setAnchor
   [_ margin anchor]
   ((clojure.core/get m4133 :set-anchor) margin anchor))
  (setAnchor
   [_ margin anchor keep_margin]
   ((clojure.core/get m4133 :set-anchor) margin anchor keep_margin))
  (setAnchor
   [_ margin anchor keep_margin push_opposite_anchor]
   ((clojure.core/get m4133 :set-anchor)
    margin
    anchor
    keep_margin
    push_opposite_anchor))
  (setAnchorAndMargin
   [_ margin anchor offset]
   ((clojure.core/get m4133 :set-anchor-and-margin)
    margin
    anchor
    offset))
  (setAnchorAndMargin
   [_ margin anchor offset push_opposite_anchor]
   ((clojure.core/get m4133 :set-anchor-and-margin)
    margin
    anchor
    offset
    push_opposite_anchor))
  (setAnchorsAndMarginsPreset
   [_ preset]
   ((clojure.core/get m4133 :set-anchors-and-margins-preset) preset))
  (setAnchorsAndMarginsPreset
   [_ preset resize_mode]
   ((clojure.core/get m4133 :set-anchors-and-margins-preset)
    preset
    resize_mode))
  (setAnchorsAndMarginsPreset
   [_ preset resize_mode margin]
   ((clojure.core/get m4133 :set-anchors-and-margins-preset)
    preset
    resize_mode
    margin))
  (setAnchorsPreset
   [_ preset]
   ((clojure.core/get m4133 :set-anchors-preset) preset))
  (setAnchorsPreset
   [_ preset keep_margins]
   ((clojure.core/get m4133 :set-anchors-preset) preset keep_margins))
  (setBegin
   [_ position]
   ((clojure.core/get m4133 :set-begin) position))
  (setClipContents
   [_ enable]
   ((clojure.core/get m4133 :set-clip-contents) enable))
  (setCustomMinimumSize
   [_ size]
   ((clojure.core/get m4133 :set-custom-minimum-size) size))
  (setDefaultCursorShape
   [_ shape]
   ((clojure.core/get m4133 :set-default-cursor-shape) shape))
  (setDragForwarding
   [_ target]
   ((clojure.core/get m4133 :set-drag-forwarding) target))
  (setDragPreview
   [_ control]
   ((clojure.core/get m4133 :set-drag-preview) control))
  (setEnd [_ position] ((clojure.core/get m4133 :set-end) position))
  (setFocusMode
   [_ mode]
   ((clojure.core/get m4133 :set-focus-mode) mode))
  (setFocusNeighbour
   [_ margin neighbour]
   ((clojure.core/get m4133 :set-focus-neighbour) margin neighbour))
  (setFocusNext
   [_ next]
   ((clojure.core/get m4133 :set-focus-next) next))
  (setFocusPrevious
   [_ previous]
   ((clojure.core/get m4133 :set-focus-previous) previous))
  (setGlobalPosition
   [_ position]
   ((clojure.core/get m4133 :set-global-position) position))
  (setGlobalPosition
   [_ position keep_margins]
   ((clojure.core/get m4133 :set-global-position)
    position
    keep_margins))
  (setHGrowDirection
   [_ direction]
   ((clojure.core/get m4133 :set-h-grow-direction) direction))
  (setHSizeFlags
   [_ flags]
   ((clojure.core/get m4133 :set-h-size-flags) flags))
  (setMargin
   [_ margin offset]
   ((clojure.core/get m4133 :set-margin) margin offset))
  (setMarginsPreset
   [_ preset]
   ((clojure.core/get m4133 :set-margins-preset) preset))
  (setMarginsPreset
   [_ preset resize_mode]
   ((clojure.core/get m4133 :set-margins-preset) preset resize_mode))
  (setMarginsPreset
   [_ preset resize_mode margin]
   ((clojure.core/get m4133 :set-margins-preset)
    preset
    resize_mode
    margin))
  (setMouseFilter
   [_ filter]
   ((clojure.core/get m4133 :set-mouse-filter) filter))
  (setPassOnModalCloseClick
   [_ enabled]
   ((clojure.core/get m4133 :set-pass-on-modal-close-click) enabled))
  (setPivotOffset
   [_ pivot_offset]
   ((clojure.core/get m4133 :set-pivot-offset) pivot_offset))
  (setPosition
   [_ position]
   ((clojure.core/get m4133 :set-position) position))
  (setPosition
   [_ position keep_margins]
   ((clojure.core/get m4133 :set-position) position keep_margins))
  (setRotation
   [_ radians]
   ((clojure.core/get m4133 :set-rotation) radians))
  (setRotationDegrees
   [_ degrees]
   ((clojure.core/get m4133 :set-rotation-degrees) degrees))
  (setScale [_ scale] ((clojure.core/get m4133 :set-scale) scale))
  (setSize [_ size] ((clojure.core/get m4133 :set-size) size))
  (setSize
   [_ size keep_margins]
   ((clojure.core/get m4133 :set-size) size keep_margins))
  (setStretchRatio
   [_ ratio]
   ((clojure.core/get m4133 :set-stretch-ratio) ratio))
  (setTheme [_ theme] ((clojure.core/get m4133 :set-theme) theme))
  (setTooltip
   [_ tooltip]
   ((clojure.core/get m4133 :set-tooltip) tooltip))
  (setVGrowDirection
   [_ direction]
   ((clojure.core/get m4133 :set-v-grow-direction) direction))
  (setVSizeFlags
   [_ flags]
   ((clojure.core/get m4133 :set-v-size-flags) flags))
  (showModal [_] ((clojure.core/get m4133 :show-modal)))
  (showModal
   [_ exclusive]
   ((clojure.core/get m4133 :show-modal) exclusive))
  (warpMouse
   [_ to_position]
   ((clojure.core/get m4133 :warp-mouse) to_position))
  (isExclusive [_] ((clojure.core/get m4133 :is-exclusive)))
  (popup [_] ((clojure.core/get m4133 :popup)))
  (popup [_ bounds] ((clojure.core/get m4133 :popup) bounds))
  (popupCentered [_] ((clojure.core/get m4133 :popup-centered)))
  (popupCentered
   [_ size]
   ((clojure.core/get m4133 :popup-centered) size))
  (popupCenteredClamped
   [_]
   ((clojure.core/get m4133 :popup-centered-clamped)))
  (popupCenteredClamped
   [_ size]
   ((clojure.core/get m4133 :popup-centered-clamped) size))
  (popupCenteredClamped
   [_ size fallback_ratio]
   ((clojure.core/get m4133 :popup-centered-clamped)
    size
    fallback_ratio))
  (popupCenteredMinsize
   [_]
   ((clojure.core/get m4133 :popup-centered-minsize)))
  (popupCenteredMinsize
   [_ minsize]
   ((clojure.core/get m4133 :popup-centered-minsize) minsize))
  (popupCenteredRatio
   [_]
   ((clojure.core/get m4133 :popup-centered-ratio)))
  (popupCenteredRatio
   [_ ratio]
   ((clojure.core/get m4133 :popup-centered-ratio) ratio))
  (setAsMinsize [_] ((clojure.core/get m4133 :set-as-minsize)))
  (setExclusive
   [_ enable]
   ((clojure.core/get m4133 :set-exclusive) enable))
  (getCloseButton [_] ((clojure.core/get m4133 :get-close-button)))
  (getResizable [_] ((clojure.core/get m4133 :get-resizable)))
  (getTitle [_] ((clojure.core/get m4133 :get-title)))
  (setResizable
   [_ resizable]
   ((clojure.core/get m4133 :set-resizable) resizable))
  (setTitle [_ title] ((clojure.core/get m4133 :set-title) title))
  (addButton [_ text] ((clojure.core/get m4133 :add-button) text))
  (addButton
   [_ text right]
   ((clojure.core/get m4133 :add-button) text right))
  (addButton
   [_ text right action]
   ((clojure.core/get m4133 :add-button) text right action))
  (addCancel [_ name] ((clojure.core/get m4133 :add-cancel) name))
  (getHideOnOk [_] ((clojure.core/get m4133 :get-hide-on-ok)))
  (getLabel [_] ((clojure.core/get m4133 :get-label)))
  (getOk [_] ((clojure.core/get m4133 :get-ok)))
  (getText [_] ((clojure.core/get m4133 :get-text)))
  (hasAutowrap [_] ((clojure.core/get m4133 :has-autowrap)))
  (registerTextEnter
   [_ line_edit]
   ((clojure.core/get m4133 :register-text-enter) line_edit))
  (setAutowrap
   [_ autowrap]
   ((clojure.core/get m4133 :set-autowrap) autowrap))
  (setHideOnOk
   [_ enabled]
   ((clojure.core/get m4133 :set-hide-on-ok) enabled))
  (setText [_ text] ((clojure.core/get m4133 :set-text) text)))
(deftype GodotConfirmationDialog
  [m4134]
  proto/ToVariant
  (->variant [this] (proto/->variant m4134))
  clojure.lang.ILookup
  (valAt [_ k] (get m4134 k))
  godotclj.api.gdscript.IGodotConfirmationDialog
  (addUserSignal
   [_ signal]
   ((clojure.core/get m4134 :add-user-signal) signal))
  (addUserSignal
   [_ signal arguments]
   ((clojure.core/get m4134 :add-user-signal) signal arguments))
  (call [_ method] ((clojure.core/get m4134 :call) method))
  (call [_ method v1] ((clojure.core/get m4134 :call) method v1))
  (call
   [_ method v1 v2]
   ((clojure.core/get m4134 :call) method v1 v2))
  (call
   [_ method v1 v2 v3]
   ((clojure.core/get m4134 :call) method v1 v2 v3))
  (call
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4134 :call) method v1 v2 v3 v4))
  (call
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4134 :call) method v1 v2 v3 v4 v5))
  (callDeferred
   [_ method]
   ((clojure.core/get m4134 :call-deferred) method))
  (callDeferred
   [_ method v1]
   ((clojure.core/get m4134 :call-deferred) method v1))
  (callDeferred
   [_ method v1 v2]
   ((clojure.core/get m4134 :call-deferred) method v1 v2))
  (callDeferred
   [_ method v1 v2 v3]
   ((clojure.core/get m4134 :call-deferred) method v1 v2 v3))
  (callDeferred
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4134 :call-deferred) method v1 v2 v3 v4))
  (callDeferred
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4134 :call-deferred) method v1 v2 v3 v4 v5))
  (callv
   [_ method arg_array]
   ((clojure.core/get m4134 :callv) method arg_array))
  (canTranslateMessages
   [_]
   ((clojure.core/get m4134 :can-translate-messages)))
  (connect
   [_ signal target method]
   ((clojure.core/get m4134 :connect) signal target method))
  (connect
   [_ signal target method binds]
   ((clojure.core/get m4134 :connect) signal target method binds))
  (connect
   [_ signal target method binds flags]
   ((clojure.core/get m4134 :connect)
    signal
    target
    method
    binds
    flags))
  (disconnect
   [_ signal target method]
   ((clojure.core/get m4134 :disconnect) signal target method))
  (emitSignal
   [_ signal]
   ((clojure.core/get m4134 :emit-signal) signal))
  (emitSignal
   [_ signal v1]
   ((clojure.core/get m4134 :emit-signal) signal v1))
  (emitSignal
   [_ signal v1 v2]
   ((clojure.core/get m4134 :emit-signal) signal v1 v2))
  (emitSignal
   [_ signal v1 v2 v3]
   ((clojure.core/get m4134 :emit-signal) signal v1 v2 v3))
  (emitSignal
   [_ signal v1 v2 v3 v4]
   ((clojure.core/get m4134 :emit-signal) signal v1 v2 v3 v4))
  (emitSignal
   [_ signal v1 v2 v3 v4 v5]
   ((clojure.core/get m4134 :emit-signal) signal v1 v2 v3 v4 v5))
  (free [_] ((clojure.core/get m4134 :free)))
  (get [_ property] ((clojure.core/get m4134 :get) property))
  (getClass [_] ((clojure.core/get m4134 :get-class)))
  (getIncomingConnections
   [_]
   ((clojure.core/get m4134 :get-incoming-connections)))
  (getIndexed
   [_ property]
   ((clojure.core/get m4134 :get-indexed) property))
  (getInstanceId [_] ((clojure.core/get m4134 :get-instance-id)))
  (getMeta [_ name] ((clojure.core/get m4134 :get-meta) name))
  (getMetaList [_] ((clojure.core/get m4134 :get-meta-list)))
  (getMethodList [_] ((clojure.core/get m4134 :get-method-list)))
  (getPropertyList [_] ((clojure.core/get m4134 :get-property-list)))
  (getScript [_] ((clojure.core/get m4134 :get-script)))
  (getSignalConnectionList
   [_ signal]
   ((clojure.core/get m4134 :get-signal-connection-list) signal))
  (getSignalList [_] ((clojure.core/get m4134 :get-signal-list)))
  (hasMeta [_ name] ((clojure.core/get m4134 :has-meta) name))
  (hasMethod [_ method] ((clojure.core/get m4134 :has-method) method))
  (hasSignal [_ signal] ((clojure.core/get m4134 :has-signal) signal))
  (hasUserSignal
   [_ signal]
   ((clojure.core/get m4134 :has-user-signal) signal))
  (isBlockingSignals
   [_]
   ((clojure.core/get m4134 :is-blocking-signals)))
  (isClass [_ class] ((clojure.core/get m4134 :is-class) class))
  (isConnected
   [_ signal target method]
   ((clojure.core/get m4134 :is-connected) signal target method))
  (isQueuedForDeletion
   [_]
   ((clojure.core/get m4134 :is-queued-for-deletion)))
  (notification
   [_ what]
   ((clojure.core/get m4134 :notification) what))
  (notification
   [_ what reversed]
   ((clojure.core/get m4134 :notification) what reversed))
  (propertyListChangedNotify
   [_]
   ((clojure.core/get m4134 :property-list-changed-notify)))
  (removeMeta [_ name] ((clojure.core/get m4134 :remove-meta) name))
  (set
   [_ property value]
   ((clojure.core/get m4134 :set) property value))
  (setBlockSignals
   [_ enable]
   ((clojure.core/get m4134 :set-block-signals) enable))
  (setDeferred
   [_ property value]
   ((clojure.core/get m4134 :set-deferred) property value))
  (setIndexed
   [_ property value]
   ((clojure.core/get m4134 :set-indexed) property value))
  (setMessageTranslation
   [_ enable]
   ((clojure.core/get m4134 :set-message-translation) enable))
  (setMeta
   [_ name value]
   ((clojure.core/get m4134 :set-meta) name value))
  (setScript [_ script] ((clojure.core/get m4134 :set-script) script))
  (tr [_ message] ((clojure.core/get m4134 :tr) message))
  (addChild [_ node] ((clojure.core/get m4134 :add-child) node))
  (addChild
   [_ node legible_unique_name]
   ((clojure.core/get m4134 :add-child) node legible_unique_name))
  (addChildBelowNode
   [_ node child_node]
   ((clojure.core/get m4134 :add-child-below-node) node child_node))
  (addChildBelowNode
   [_ node child_node legible_unique_name]
   ((clojure.core/get m4134 :add-child-below-node)
    node
    child_node
    legible_unique_name))
  (addToGroup
   [_ group]
   ((clojure.core/get m4134 :add-to-group) group))
  (addToGroup
   [_ group persistent]
   ((clojure.core/get m4134 :add-to-group) group persistent))
  (canProcess [_] ((clojure.core/get m4134 :can-process)))
  (duplicate [_] ((clojure.core/get m4134 :duplicate)))
  (duplicate [_ flags] ((clojure.core/get m4134 :duplicate) flags))
  (findNode [_ mask] ((clojure.core/get m4134 :find-node) mask))
  (findNode
   [_ mask recursive]
   ((clojure.core/get m4134 :find-node) mask recursive))
  (findNode
   [_ mask recursive owned]
   ((clojure.core/get m4134 :find-node) mask recursive owned))
  (findParent [_ mask] ((clojure.core/get m4134 :find-parent) mask))
  (getChild [_ idx] ((clojure.core/get m4134 :get-child) idx))
  (getChildCount [_] ((clojure.core/get m4134 :get-child-count)))
  (getChildren [_] ((clojure.core/get m4134 :get-children)))
  (getCustomMultiplayer
   [_]
   ((clojure.core/get m4134 :get-custom-multiplayer)))
  (getFilename [_] ((clojure.core/get m4134 :get-filename)))
  (getGroups [_] ((clojure.core/get m4134 :get-groups)))
  (getIndex [_] ((clojure.core/get m4134 :get-index)))
  (getMultiplayer [_] ((clojure.core/get m4134 :get-multiplayer)))
  (getName [_] ((clojure.core/get m4134 :get-name)))
  (getNetworkMaster
   [_]
   ((clojure.core/get m4134 :get-network-master)))
  (getNode [_ path] ((clojure.core/get m4134 :get-node) path))
  (getNodeAndResource
   [_ path]
   ((clojure.core/get m4134 :get-node-and-resource) path))
  (getNodeOrNull
   [_ path]
   ((clojure.core/get m4134 :get-node-or-null) path))
  (getOwner [_] ((clojure.core/get m4134 :get-owner)))
  (getParent [_] ((clojure.core/get m4134 :get-parent)))
  (getPath [_] ((clojure.core/get m4134 :get-path)))
  (getPathTo [_ node] ((clojure.core/get m4134 :get-path-to) node))
  (getPauseMode [_] ((clojure.core/get m4134 :get-pause-mode)))
  (getPhysicsProcessDeltaTime
   [_]
   ((clojure.core/get m4134 :get-physics-process-delta-time)))
  (getPositionInParent
   [_]
   ((clojure.core/get m4134 :get-position-in-parent)))
  (getProcessDeltaTime
   [_]
   ((clojure.core/get m4134 :get-process-delta-time)))
  (getProcessPriority
   [_]
   ((clojure.core/get m4134 :get-process-priority)))
  (getSceneInstanceLoadPlaceholder
   [_]
   ((clojure.core/get m4134 :get-scene-instance-load-placeholder)))
  (getTree [_] ((clojure.core/get m4134 :get-tree)))
  (getViewport [_] ((clojure.core/get m4134 :get-viewport)))
  (hasNode [_ path] ((clojure.core/get m4134 :has-node) path))
  (hasNodeAndResource
   [_ path]
   ((clojure.core/get m4134 :has-node-and-resource) path))
  (isAParentOf
   [_ node]
   ((clojure.core/get m4134 :is-a-parent-of) node))
  (isDisplayedFolded
   [_]
   ((clojure.core/get m4134 :is-displayed-folded)))
  (isGreaterThan
   [_ node]
   ((clojure.core/get m4134 :is-greater-than) node))
  (isInGroup [_ group] ((clojure.core/get m4134 :is-in-group) group))
  (isInsideTree [_] ((clojure.core/get m4134 :is-inside-tree)))
  (isNetworkMaster [_] ((clojure.core/get m4134 :is-network-master)))
  (isPhysicsProcessing
   [_]
   ((clojure.core/get m4134 :is-physics-processing)))
  (isPhysicsProcessingInternal
   [_]
   ((clojure.core/get m4134 :is-physics-processing-internal)))
  (isProcessing [_] ((clojure.core/get m4134 :is-processing)))
  (isProcessingInput
   [_]
   ((clojure.core/get m4134 :is-processing-input)))
  (isProcessingInternal
   [_]
   ((clojure.core/get m4134 :is-processing-internal)))
  (isProcessingUnhandledInput
   [_]
   ((clojure.core/get m4134 :is-processing-unhandled-input)))
  (isProcessingUnhandledKeyInput
   [_]
   ((clojure.core/get m4134 :is-processing-unhandled-key-input)))
  (moveChild
   [_ child_node to_position]
   ((clojure.core/get m4134 :move-child) child_node to_position))
  (printStrayNodes [_] ((clojure.core/get m4134 :print-stray-nodes)))
  (printTree [_] ((clojure.core/get m4134 :print-tree)))
  (printTreePretty [_] ((clojure.core/get m4134 :print-tree-pretty)))
  (propagateCall
   [_ method]
   ((clojure.core/get m4134 :propagate-call) method))
  (propagateCall
   [_ method args]
   ((clojure.core/get m4134 :propagate-call) method args))
  (propagateCall
   [_ method args parent_first]
   ((clojure.core/get m4134 :propagate-call) method args parent_first))
  (propagateNotification
   [_ what]
   ((clojure.core/get m4134 :propagate-notification) what))
  (queueFree [_] ((clojure.core/get m4134 :queue-free)))
  (raise [_] ((clojure.core/get m4134 :raise)))
  (removeAndSkip [_] ((clojure.core/get m4134 :remove-and-skip)))
  (removeChild [_ node] ((clojure.core/get m4134 :remove-child) node))
  (removeFromGroup
   [_ group]
   ((clojure.core/get m4134 :remove-from-group) group))
  (replaceBy [_ node] ((clojure.core/get m4134 :replace-by) node))
  (replaceBy
   [_ node keep_data]
   ((clojure.core/get m4134 :replace-by) node keep_data))
  (requestReady [_] ((clojure.core/get m4134 :request-ready)))
  (rpc [_ method] ((clojure.core/get m4134 :rpc) method))
  (rpc [_ method v1] ((clojure.core/get m4134 :rpc) method v1))
  (rpc [_ method v1 v2] ((clojure.core/get m4134 :rpc) method v1 v2))
  (rpc
   [_ method v1 v2 v3]
   ((clojure.core/get m4134 :rpc) method v1 v2 v3))
  (rpc
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4134 :rpc) method v1 v2 v3 v4))
  (rpc
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4134 :rpc) method v1 v2 v3 v4 v5))
  (rpcConfig
   [_ method mode]
   ((clojure.core/get m4134 :rpc-config) method mode))
  (rpcId
   [_ peer_id method]
   ((clojure.core/get m4134 :rpc-id) peer_id method))
  (rpcId
   [_ peer_id method v1]
   ((clojure.core/get m4134 :rpc-id) peer_id method v1))
  (rpcId
   [_ peer_id method v1 v2]
   ((clojure.core/get m4134 :rpc-id) peer_id method v1 v2))
  (rpcId
   [_ peer_id method v1 v2 v3]
   ((clojure.core/get m4134 :rpc-id) peer_id method v1 v2 v3))
  (rpcId
   [_ peer_id method v1 v2 v3 v4]
   ((clojure.core/get m4134 :rpc-id) peer_id method v1 v2 v3 v4))
  (rpcId
   [_ peer_id method v1 v2 v3 v4 v5]
   ((clojure.core/get m4134 :rpc-id) peer_id method v1 v2 v3 v4 v5))
  (rpcUnreliable
   [_ method]
   ((clojure.core/get m4134 :rpc-unreliable) method))
  (rpcUnreliable
   [_ method v1]
   ((clojure.core/get m4134 :rpc-unreliable) method v1))
  (rpcUnreliable
   [_ method v1 v2]
   ((clojure.core/get m4134 :rpc-unreliable) method v1 v2))
  (rpcUnreliable
   [_ method v1 v2 v3]
   ((clojure.core/get m4134 :rpc-unreliable) method v1 v2 v3))
  (rpcUnreliable
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4134 :rpc-unreliable) method v1 v2 v3 v4))
  (rpcUnreliable
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4134 :rpc-unreliable) method v1 v2 v3 v4 v5))
  (rpcUnreliableId
   [_ peer_id method]
   ((clojure.core/get m4134 :rpc-unreliable-id) peer_id method))
  (rpcUnreliableId
   [_ peer_id method v1]
   ((clojure.core/get m4134 :rpc-unreliable-id) peer_id method v1))
  (rpcUnreliableId
   [_ peer_id method v1 v2]
   ((clojure.core/get m4134 :rpc-unreliable-id) peer_id method v1 v2))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3]
   ((clojure.core/get m4134 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3 v4]
   ((clojure.core/get m4134 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3
    v4))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3 v4 v5]
   ((clojure.core/get m4134 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3
    v4
    v5))
  (rset
   [_ property value]
   ((clojure.core/get m4134 :rset) property value))
  (rsetConfig
   [_ property mode]
   ((clojure.core/get m4134 :rset-config) property mode))
  (rsetId
   [_ peer_id property value]
   ((clojure.core/get m4134 :rset-id) peer_id property value))
  (rsetUnreliable
   [_ property value]
   ((clojure.core/get m4134 :rset-unreliable) property value))
  (rsetUnreliableId
   [_ peer_id property value]
   ((clojure.core/get m4134 :rset-unreliable-id)
    peer_id
    property
    value))
  (setCustomMultiplayer
   [_ api]
   ((clojure.core/get m4134 :set-custom-multiplayer) api))
  (setDisplayFolded
   [_ fold]
   ((clojure.core/get m4134 :set-display-folded) fold))
  (setFilename
   [_ filename]
   ((clojure.core/get m4134 :set-filename) filename))
  (setName [_ name] ((clojure.core/get m4134 :set-name) name))
  (setNetworkMaster
   [_ id]
   ((clojure.core/get m4134 :set-network-master) id))
  (setNetworkMaster
   [_ id recursive]
   ((clojure.core/get m4134 :set-network-master) id recursive))
  (setOwner [_ owner] ((clojure.core/get m4134 :set-owner) owner))
  (setPauseMode
   [_ mode]
   ((clojure.core/get m4134 :set-pause-mode) mode))
  (setPhysicsProcess
   [_ enable]
   ((clojure.core/get m4134 :set-physics-process) enable))
  (setPhysicsProcessInternal
   [_ enable]
   ((clojure.core/get m4134 :set-physics-process-internal) enable))
  (setProcess
   [_ enable]
   ((clojure.core/get m4134 :set-process) enable))
  (setProcessInput
   [_ enable]
   ((clojure.core/get m4134 :set-process-input) enable))
  (setProcessInternal
   [_ enable]
   ((clojure.core/get m4134 :set-process-internal) enable))
  (setProcessPriority
   [_ priority]
   ((clojure.core/get m4134 :set-process-priority) priority))
  (setProcessUnhandledInput
   [_ enable]
   ((clojure.core/get m4134 :set-process-unhandled-input) enable))
  (setProcessUnhandledKeyInput
   [_ enable]
   ((clojure.core/get m4134 :set-process-unhandled-key-input) enable))
  (setSceneInstanceLoadPlaceholder
   [_ load_placeholder]
   ((clojure.core/get m4134 :set-scene-instance-load-placeholder)
    load_placeholder))
  (updateConfigurationWarning
   [_]
   ((clojure.core/get m4134 :update-configuration-warning)))
  (drawArc
   [_ center radius start_angle end_angle point_count color]
   ((clojure.core/get m4134 :draw-arc)
    center
    radius
    start_angle
    end_angle
    point_count
    color))
  (drawArc
   [_ center radius start_angle end_angle point_count color width]
   ((clojure.core/get m4134 :draw-arc)
    center
    radius
    start_angle
    end_angle
    point_count
    color
    width))
  (drawArc
   [_
    center
    radius
    start_angle
    end_angle
    point_count
    color
    width
    antialiased]
   ((clojure.core/get m4134 :draw-arc)
    center
    radius
    start_angle
    end_angle
    point_count
    color
    width
    antialiased))
  (drawChar
   [_ font position char next]
   ((clojure.core/get m4134 :draw-char) font position char next))
  (drawChar
   [_ font position char next modulate]
   ((clojure.core/get m4134 :draw-char)
    font
    position
    char
    next
    modulate))
  (drawCircle
   [_ position radius color]
   ((clojure.core/get m4134 :draw-circle) position radius color))
  (drawColoredPolygon
   [_ points color]
   ((clojure.core/get m4134 :draw-colored-polygon) points color))
  (drawColoredPolygon
   [_ points color uvs]
   ((clojure.core/get m4134 :draw-colored-polygon) points color uvs))
  (drawColoredPolygon
   [_ points color uvs texture]
   ((clojure.core/get m4134 :draw-colored-polygon)
    points
    color
    uvs
    texture))
  (drawColoredPolygon
   [_ points color uvs texture normal_map]
   ((clojure.core/get m4134 :draw-colored-polygon)
    points
    color
    uvs
    texture
    normal_map))
  (drawColoredPolygon
   [_ points color uvs texture normal_map antialiased]
   ((clojure.core/get m4134 :draw-colored-polygon)
    points
    color
    uvs
    texture
    normal_map
    antialiased))
  (drawLine
   [_ from to color]
   ((clojure.core/get m4134 :draw-line) from to color))
  (drawLine
   [_ from to color width]
   ((clojure.core/get m4134 :draw-line) from to color width))
  (drawLine
   [_ from to color width antialiased]
   ((clojure.core/get m4134 :draw-line)
    from
    to
    color
    width
    antialiased))
  (drawMesh
   [_ mesh texture]
   ((clojure.core/get m4134 :draw-mesh) mesh texture))
  (drawMesh
   [_ mesh texture normal_map]
   ((clojure.core/get m4134 :draw-mesh) mesh texture normal_map))
  (drawMesh
   [_ mesh texture normal_map transform]
   ((clojure.core/get m4134 :draw-mesh)
    mesh
    texture
    normal_map
    transform))
  (drawMesh
   [_ mesh texture normal_map transform modulate]
   ((clojure.core/get m4134 :draw-mesh)
    mesh
    texture
    normal_map
    transform
    modulate))
  (drawMultiline
   [_ points color]
   ((clojure.core/get m4134 :draw-multiline) points color))
  (drawMultiline
   [_ points color width]
   ((clojure.core/get m4134 :draw-multiline) points color width))
  (drawMultiline
   [_ points color width antialiased]
   ((clojure.core/get m4134 :draw-multiline)
    points
    color
    width
    antialiased))
  (drawMultilineColors
   [_ points colors]
   ((clojure.core/get m4134 :draw-multiline-colors) points colors))
  (drawMultilineColors
   [_ points colors width]
   ((clojure.core/get m4134 :draw-multiline-colors)
    points
    colors
    width))
  (drawMultilineColors
   [_ points colors width antialiased]
   ((clojure.core/get m4134 :draw-multiline-colors)
    points
    colors
    width
    antialiased))
  (drawMultimesh
   [_ multimesh texture]
   ((clojure.core/get m4134 :draw-multimesh) multimesh texture))
  (drawMultimesh
   [_ multimesh texture normal_map]
   ((clojure.core/get m4134 :draw-multimesh)
    multimesh
    texture
    normal_map))
  (drawPolygon
   [_ points colors]
   ((clojure.core/get m4134 :draw-polygon) points colors))
  (drawPolygon
   [_ points colors uvs]
   ((clojure.core/get m4134 :draw-polygon) points colors uvs))
  (drawPolygon
   [_ points colors uvs texture]
   ((clojure.core/get m4134 :draw-polygon) points colors uvs texture))
  (drawPolygon
   [_ points colors uvs texture normal_map]
   ((clojure.core/get m4134 :draw-polygon)
    points
    colors
    uvs
    texture
    normal_map))
  (drawPolygon
   [_ points colors uvs texture normal_map antialiased]
   ((clojure.core/get m4134 :draw-polygon)
    points
    colors
    uvs
    texture
    normal_map
    antialiased))
  (drawPolyline
   [_ points color]
   ((clojure.core/get m4134 :draw-polyline) points color))
  (drawPolyline
   [_ points color width]
   ((clojure.core/get m4134 :draw-polyline) points color width))
  (drawPolyline
   [_ points color width antialiased]
   ((clojure.core/get m4134 :draw-polyline)
    points
    color
    width
    antialiased))
  (drawPolylineColors
   [_ points colors]
   ((clojure.core/get m4134 :draw-polyline-colors) points colors))
  (drawPolylineColors
   [_ points colors width]
   ((clojure.core/get m4134 :draw-polyline-colors)
    points
    colors
    width))
  (drawPolylineColors
   [_ points colors width antialiased]
   ((clojure.core/get m4134 :draw-polyline-colors)
    points
    colors
    width
    antialiased))
  (drawPrimitive
   [_ points colors uvs]
   ((clojure.core/get m4134 :draw-primitive) points colors uvs))
  (drawPrimitive
   [_ points colors uvs texture]
   ((clojure.core/get m4134 :draw-primitive)
    points
    colors
    uvs
    texture))
  (drawPrimitive
   [_ points colors uvs texture width]
   ((clojure.core/get m4134 :draw-primitive)
    points
    colors
    uvs
    texture
    width))
  (drawPrimitive
   [_ points colors uvs texture width normal_map]
   ((clojure.core/get m4134 :draw-primitive)
    points
    colors
    uvs
    texture
    width
    normal_map))
  (drawRect
   [_ rect color]
   ((clojure.core/get m4134 :draw-rect) rect color))
  (drawRect
   [_ rect color filled]
   ((clojure.core/get m4134 :draw-rect) rect color filled))
  (drawRect
   [_ rect color filled width]
   ((clojure.core/get m4134 :draw-rect) rect color filled width))
  (drawRect
   [_ rect color filled width antialiased]
   ((clojure.core/get m4134 :draw-rect)
    rect
    color
    filled
    width
    antialiased))
  (drawSetTransform
   [_ position rotation scale]
   ((clojure.core/get m4134 :draw-set-transform)
    position
    rotation
    scale))
  (drawSetTransformMatrix
   [_ xform]
   ((clojure.core/get m4134 :draw-set-transform-matrix) xform))
  (drawString
   [_ font position text]
   ((clojure.core/get m4134 :draw-string) font position text))
  (drawString
   [_ font position text modulate]
   ((clojure.core/get m4134 :draw-string) font position text modulate))
  (drawString
   [_ font position text modulate clip_w]
   ((clojure.core/get m4134 :draw-string)
    font
    position
    text
    modulate
    clip_w))
  (drawStyleBox
   [_ style_box rect]
   ((clojure.core/get m4134 :draw-style-box) style_box rect))
  (drawTexture
   [_ texture position]
   ((clojure.core/get m4134 :draw-texture) texture position))
  (drawTexture
   [_ texture position modulate]
   ((clojure.core/get m4134 :draw-texture) texture position modulate))
  (drawTexture
   [_ texture position modulate normal_map]
   ((clojure.core/get m4134 :draw-texture)
    texture
    position
    modulate
    normal_map))
  (drawTextureRect
   [_ texture rect tile]
   ((clojure.core/get m4134 :draw-texture-rect) texture rect tile))
  (drawTextureRect
   [_ texture rect tile modulate]
   ((clojure.core/get m4134 :draw-texture-rect)
    texture
    rect
    tile
    modulate))
  (drawTextureRect
   [_ texture rect tile modulate transpose]
   ((clojure.core/get m4134 :draw-texture-rect)
    texture
    rect
    tile
    modulate
    transpose))
  (drawTextureRect
   [_ texture rect tile modulate transpose normal_map]
   ((clojure.core/get m4134 :draw-texture-rect)
    texture
    rect
    tile
    modulate
    transpose
    normal_map))
  (drawTextureRectRegion
   [_ texture rect src_rect]
   ((clojure.core/get m4134 :draw-texture-rect-region)
    texture
    rect
    src_rect))
  (drawTextureRectRegion
   [_ texture rect src_rect modulate]
   ((clojure.core/get m4134 :draw-texture-rect-region)
    texture
    rect
    src_rect
    modulate))
  (drawTextureRectRegion
   [_ texture rect src_rect modulate transpose]
   ((clojure.core/get m4134 :draw-texture-rect-region)
    texture
    rect
    src_rect
    modulate
    transpose))
  (drawTextureRectRegion
   [_ texture rect src_rect modulate transpose normal_map]
   ((clojure.core/get m4134 :draw-texture-rect-region)
    texture
    rect
    src_rect
    modulate
    transpose
    normal_map))
  (drawTextureRectRegion
   [_ texture rect src_rect modulate transpose normal_map clip_uv]
   ((clojure.core/get m4134 :draw-texture-rect-region)
    texture
    rect
    src_rect
    modulate
    transpose
    normal_map
    clip_uv))
  (forceUpdateTransform
   [_]
   ((clojure.core/get m4134 :force-update-transform)))
  (getCanvas [_] ((clojure.core/get m4134 :get-canvas)))
  (getCanvasItem [_] ((clojure.core/get m4134 :get-canvas-item)))
  (getCanvasTransform
   [_]
   ((clojure.core/get m4134 :get-canvas-transform)))
  (getGlobalMousePosition
   [_]
   ((clojure.core/get m4134 :get-global-mouse-position)))
  (getGlobalTransform
   [_]
   ((clojure.core/get m4134 :get-global-transform)))
  (getGlobalTransformWithCanvas
   [_]
   ((clojure.core/get m4134 :get-global-transform-with-canvas)))
  (getLightMask [_] ((clojure.core/get m4134 :get-light-mask)))
  (getLocalMousePosition
   [_]
   ((clojure.core/get m4134 :get-local-mouse-position)))
  (getMaterial [_] ((clojure.core/get m4134 :get-material)))
  (getModulate [_] ((clojure.core/get m4134 :get-modulate)))
  (getSelfModulate [_] ((clojure.core/get m4134 :get-self-modulate)))
  (getTransform [_] ((clojure.core/get m4134 :get-transform)))
  (getUseParentMaterial
   [_]
   ((clojure.core/get m4134 :get-use-parent-material)))
  (getViewportRect [_] ((clojure.core/get m4134 :get-viewport-rect)))
  (getViewportTransform
   [_]
   ((clojure.core/get m4134 :get-viewport-transform)))
  (getWorld2d [_] ((clojure.core/get m4134 :get-world-2d)))
  (hide [_] ((clojure.core/get m4134 :hide)))
  (isDrawBehindParentEnabled
   [_]
   ((clojure.core/get m4134 :is-draw-behind-parent-enabled)))
  (isLocalTransformNotificationEnabled
   [_]
   ((clojure.core/get m4134 :is-local-transform-notification-enabled)))
  (isSetAsToplevel [_] ((clojure.core/get m4134 :is-set-as-toplevel)))
  (isTransformNotificationEnabled
   [_]
   ((clojure.core/get m4134 :is-transform-notification-enabled)))
  (isVisible [_] ((clojure.core/get m4134 :is-visible)))
  (isVisibleInTree [_] ((clojure.core/get m4134 :is-visible-in-tree)))
  (makeCanvasPositionLocal
   [_ screen_point]
   ((clojure.core/get m4134 :make-canvas-position-local) screen_point))
  (makeInputLocal
   [_ event]
   ((clojure.core/get m4134 :make-input-local) event))
  (setAsToplevel
   [_ enable]
   ((clojure.core/get m4134 :set-as-toplevel) enable))
  (setDrawBehindParent
   [_ enable]
   ((clojure.core/get m4134 :set-draw-behind-parent) enable))
  (setLightMask
   [_ light_mask]
   ((clojure.core/get m4134 :set-light-mask) light_mask))
  (setMaterial
   [_ material]
   ((clojure.core/get m4134 :set-material) material))
  (setModulate
   [_ modulate]
   ((clojure.core/get m4134 :set-modulate) modulate))
  (setNotifyLocalTransform
   [_ enable]
   ((clojure.core/get m4134 :set-notify-local-transform) enable))
  (setNotifyTransform
   [_ enable]
   ((clojure.core/get m4134 :set-notify-transform) enable))
  (setSelfModulate
   [_ self_modulate]
   ((clojure.core/get m4134 :set-self-modulate) self_modulate))
  (setUseParentMaterial
   [_ enable]
   ((clojure.core/get m4134 :set-use-parent-material) enable))
  (setVisible
   [_ visible]
   ((clojure.core/get m4134 :set-visible) visible))
  (show [_] ((clojure.core/get m4134 :show)))
  (update [_] ((clojure.core/get m4134 :update)))
  (acceptEvent [_] ((clojure.core/get m4134 :accept-event)))
  (addColorOverride
   [_ name color]
   ((clojure.core/get m4134 :add-color-override) name color))
  (addConstantOverride
   [_ name constant]
   ((clojure.core/get m4134 :add-constant-override) name constant))
  (addFontOverride
   [_ name font]
   ((clojure.core/get m4134 :add-font-override) name font))
  (addIconOverride
   [_ name texture]
   ((clojure.core/get m4134 :add-icon-override) name texture))
  (addShaderOverride
   [_ name shader]
   ((clojure.core/get m4134 :add-shader-override) name shader))
  (addStyleboxOverride
   [_ name stylebox]
   ((clojure.core/get m4134 :add-stylebox-override) name stylebox))
  (canDropData
   [_ position data]
   ((clojure.core/get m4134 :can-drop-data) position data))
  (dropData
   [_ position data]
   ((clojure.core/get m4134 :drop-data) position data))
  (findNextValidFocus
   [_]
   ((clojure.core/get m4134 :find-next-valid-focus)))
  (findPrevValidFocus
   [_]
   ((clojure.core/get m4134 :find-prev-valid-focus)))
  (forceDrag
   [_ data preview]
   ((clojure.core/get m4134 :force-drag) data preview))
  (getAnchor [_ margin] ((clojure.core/get m4134 :get-anchor) margin))
  (getBegin [_] ((clojure.core/get m4134 :get-begin)))
  (getColor [_ name] ((clojure.core/get m4134 :get-color) name))
  (getColor
   [_ name node_type]
   ((clojure.core/get m4134 :get-color) name node_type))
  (getCombinedMinimumSize
   [_]
   ((clojure.core/get m4134 :get-combined-minimum-size)))
  (getConstant [_ name] ((clojure.core/get m4134 :get-constant) name))
  (getConstant
   [_ name node_type]
   ((clojure.core/get m4134 :get-constant) name node_type))
  (getCursorShape [_] ((clojure.core/get m4134 :get-cursor-shape)))
  (getCursorShape
   [_ position]
   ((clojure.core/get m4134 :get-cursor-shape) position))
  (getCustomMinimumSize
   [_]
   ((clojure.core/get m4134 :get-custom-minimum-size)))
  (getDefaultCursorShape
   [_]
   ((clojure.core/get m4134 :get-default-cursor-shape)))
  (getDragData
   [_ position]
   ((clojure.core/get m4134 :get-drag-data) position))
  (getEnd [_] ((clojure.core/get m4134 :get-end)))
  (getFocusMode [_] ((clojure.core/get m4134 :get-focus-mode)))
  (getFocusNeighbour
   [_ margin]
   ((clojure.core/get m4134 :get-focus-neighbour) margin))
  (getFocusNext [_] ((clojure.core/get m4134 :get-focus-next)))
  (getFocusOwner [_] ((clojure.core/get m4134 :get-focus-owner)))
  (getFocusPrevious
   [_]
   ((clojure.core/get m4134 :get-focus-previous)))
  (getFont [_ name] ((clojure.core/get m4134 :get-font) name))
  (getFont
   [_ name node_type]
   ((clojure.core/get m4134 :get-font) name node_type))
  (getGlobalPosition
   [_]
   ((clojure.core/get m4134 :get-global-position)))
  (getGlobalRect [_] ((clojure.core/get m4134 :get-global-rect)))
  (getHGrowDirection
   [_]
   ((clojure.core/get m4134 :get-h-grow-direction)))
  (getHSizeFlags [_] ((clojure.core/get m4134 :get-h-size-flags)))
  (getIcon [_ name] ((clojure.core/get m4134 :get-icon) name))
  (getIcon
   [_ name node_type]
   ((clojure.core/get m4134 :get-icon) name node_type))
  (getMargin [_ margin] ((clojure.core/get m4134 :get-margin) margin))
  (getMinimumSize [_] ((clojure.core/get m4134 :get-minimum-size)))
  (getMouseFilter [_] ((clojure.core/get m4134 :get-mouse-filter)))
  (getParentAreaSize
   [_]
   ((clojure.core/get m4134 :get-parent-area-size)))
  (getParentControl
   [_]
   ((clojure.core/get m4134 :get-parent-control)))
  (getPassOnModalCloseClick
   [_]
   ((clojure.core/get m4134 :get-pass-on-modal-close-click)))
  (getPivotOffset [_] ((clojure.core/get m4134 :get-pivot-offset)))
  (getPosition [_] ((clojure.core/get m4134 :get-position)))
  (getRect [_] ((clojure.core/get m4134 :get-rect)))
  (getRotation [_] ((clojure.core/get m4134 :get-rotation)))
  (getRotationDegrees
   [_]
   ((clojure.core/get m4134 :get-rotation-degrees)))
  (getScale [_] ((clojure.core/get m4134 :get-scale)))
  (getSize [_] ((clojure.core/get m4134 :get-size)))
  (getStretchRatio [_] ((clojure.core/get m4134 :get-stretch-ratio)))
  (getStylebox [_ name] ((clojure.core/get m4134 :get-stylebox) name))
  (getStylebox
   [_ name node_type]
   ((clojure.core/get m4134 :get-stylebox) name node_type))
  (getTheme [_] ((clojure.core/get m4134 :get-theme)))
  (getTooltip [_] ((clojure.core/get m4134 :get-tooltip)))
  (getTooltip
   [_ at_position]
   ((clojure.core/get m4134 :get-tooltip) at_position))
  (getVGrowDirection
   [_]
   ((clojure.core/get m4134 :get-v-grow-direction)))
  (getVSizeFlags [_] ((clojure.core/get m4134 :get-v-size-flags)))
  (grabClickFocus [_] ((clojure.core/get m4134 :grab-click-focus)))
  (grabFocus [_] ((clojure.core/get m4134 :grab-focus)))
  (hasColor [_ name] ((clojure.core/get m4134 :has-color) name))
  (hasColor
   [_ name node_type]
   ((clojure.core/get m4134 :has-color) name node_type))
  (hasColorOverride
   [_ name]
   ((clojure.core/get m4134 :has-color-override) name))
  (hasConstant [_ name] ((clojure.core/get m4134 :has-constant) name))
  (hasConstant
   [_ name node_type]
   ((clojure.core/get m4134 :has-constant) name node_type))
  (hasConstantOverride
   [_ name]
   ((clojure.core/get m4134 :has-constant-override) name))
  (hasFocus [_] ((clojure.core/get m4134 :has-focus)))
  (hasFont [_ name] ((clojure.core/get m4134 :has-font) name))
  (hasFont
   [_ name node_type]
   ((clojure.core/get m4134 :has-font) name node_type))
  (hasFontOverride
   [_ name]
   ((clojure.core/get m4134 :has-font-override) name))
  (hasIcon [_ name] ((clojure.core/get m4134 :has-icon) name))
  (hasIcon
   [_ name node_type]
   ((clojure.core/get m4134 :has-icon) name node_type))
  (hasIconOverride
   [_ name]
   ((clojure.core/get m4134 :has-icon-override) name))
  (hasPoint [_ point] ((clojure.core/get m4134 :has-point) point))
  (hasShaderOverride
   [_ name]
   ((clojure.core/get m4134 :has-shader-override) name))
  (hasStylebox [_ name] ((clojure.core/get m4134 :has-stylebox) name))
  (hasStylebox
   [_ name node_type]
   ((clojure.core/get m4134 :has-stylebox) name node_type))
  (hasStyleboxOverride
   [_ name]
   ((clojure.core/get m4134 :has-stylebox-override) name))
  (isClippingContents
   [_]
   ((clojure.core/get m4134 :is-clipping-contents)))
  (minimumSizeChanged
   [_]
   ((clojure.core/get m4134 :minimum-size-changed)))
  (releaseFocus [_] ((clojure.core/get m4134 :release-focus)))
  (setAnchor
   [_ margin anchor]
   ((clojure.core/get m4134 :set-anchor) margin anchor))
  (setAnchor
   [_ margin anchor keep_margin]
   ((clojure.core/get m4134 :set-anchor) margin anchor keep_margin))
  (setAnchor
   [_ margin anchor keep_margin push_opposite_anchor]
   ((clojure.core/get m4134 :set-anchor)
    margin
    anchor
    keep_margin
    push_opposite_anchor))
  (setAnchorAndMargin
   [_ margin anchor offset]
   ((clojure.core/get m4134 :set-anchor-and-margin)
    margin
    anchor
    offset))
  (setAnchorAndMargin
   [_ margin anchor offset push_opposite_anchor]
   ((clojure.core/get m4134 :set-anchor-and-margin)
    margin
    anchor
    offset
    push_opposite_anchor))
  (setAnchorsAndMarginsPreset
   [_ preset]
   ((clojure.core/get m4134 :set-anchors-and-margins-preset) preset))
  (setAnchorsAndMarginsPreset
   [_ preset resize_mode]
   ((clojure.core/get m4134 :set-anchors-and-margins-preset)
    preset
    resize_mode))
  (setAnchorsAndMarginsPreset
   [_ preset resize_mode margin]
   ((clojure.core/get m4134 :set-anchors-and-margins-preset)
    preset
    resize_mode
    margin))
  (setAnchorsPreset
   [_ preset]
   ((clojure.core/get m4134 :set-anchors-preset) preset))
  (setAnchorsPreset
   [_ preset keep_margins]
   ((clojure.core/get m4134 :set-anchors-preset) preset keep_margins))
  (setBegin
   [_ position]
   ((clojure.core/get m4134 :set-begin) position))
  (setClipContents
   [_ enable]
   ((clojure.core/get m4134 :set-clip-contents) enable))
  (setCustomMinimumSize
   [_ size]
   ((clojure.core/get m4134 :set-custom-minimum-size) size))
  (setDefaultCursorShape
   [_ shape]
   ((clojure.core/get m4134 :set-default-cursor-shape) shape))
  (setDragForwarding
   [_ target]
   ((clojure.core/get m4134 :set-drag-forwarding) target))
  (setDragPreview
   [_ control]
   ((clojure.core/get m4134 :set-drag-preview) control))
  (setEnd [_ position] ((clojure.core/get m4134 :set-end) position))
  (setFocusMode
   [_ mode]
   ((clojure.core/get m4134 :set-focus-mode) mode))
  (setFocusNeighbour
   [_ margin neighbour]
   ((clojure.core/get m4134 :set-focus-neighbour) margin neighbour))
  (setFocusNext
   [_ next]
   ((clojure.core/get m4134 :set-focus-next) next))
  (setFocusPrevious
   [_ previous]
   ((clojure.core/get m4134 :set-focus-previous) previous))
  (setGlobalPosition
   [_ position]
   ((clojure.core/get m4134 :set-global-position) position))
  (setGlobalPosition
   [_ position keep_margins]
   ((clojure.core/get m4134 :set-global-position)
    position
    keep_margins))
  (setHGrowDirection
   [_ direction]
   ((clojure.core/get m4134 :set-h-grow-direction) direction))
  (setHSizeFlags
   [_ flags]
   ((clojure.core/get m4134 :set-h-size-flags) flags))
  (setMargin
   [_ margin offset]
   ((clojure.core/get m4134 :set-margin) margin offset))
  (setMarginsPreset
   [_ preset]
   ((clojure.core/get m4134 :set-margins-preset) preset))
  (setMarginsPreset
   [_ preset resize_mode]
   ((clojure.core/get m4134 :set-margins-preset) preset resize_mode))
  (setMarginsPreset
   [_ preset resize_mode margin]
   ((clojure.core/get m4134 :set-margins-preset)
    preset
    resize_mode
    margin))
  (setMouseFilter
   [_ filter]
   ((clojure.core/get m4134 :set-mouse-filter) filter))
  (setPassOnModalCloseClick
   [_ enabled]
   ((clojure.core/get m4134 :set-pass-on-modal-close-click) enabled))
  (setPivotOffset
   [_ pivot_offset]
   ((clojure.core/get m4134 :set-pivot-offset) pivot_offset))
  (setPosition
   [_ position]
   ((clojure.core/get m4134 :set-position) position))
  (setPosition
   [_ position keep_margins]
   ((clojure.core/get m4134 :set-position) position keep_margins))
  (setRotation
   [_ radians]
   ((clojure.core/get m4134 :set-rotation) radians))
  (setRotationDegrees
   [_ degrees]
   ((clojure.core/get m4134 :set-rotation-degrees) degrees))
  (setScale [_ scale] ((clojure.core/get m4134 :set-scale) scale))
  (setSize [_ size] ((clojure.core/get m4134 :set-size) size))
  (setSize
   [_ size keep_margins]
   ((clojure.core/get m4134 :set-size) size keep_margins))
  (setStretchRatio
   [_ ratio]
   ((clojure.core/get m4134 :set-stretch-ratio) ratio))
  (setTheme [_ theme] ((clojure.core/get m4134 :set-theme) theme))
  (setTooltip
   [_ tooltip]
   ((clojure.core/get m4134 :set-tooltip) tooltip))
  (setVGrowDirection
   [_ direction]
   ((clojure.core/get m4134 :set-v-grow-direction) direction))
  (setVSizeFlags
   [_ flags]
   ((clojure.core/get m4134 :set-v-size-flags) flags))
  (showModal [_] ((clojure.core/get m4134 :show-modal)))
  (showModal
   [_ exclusive]
   ((clojure.core/get m4134 :show-modal) exclusive))
  (warpMouse
   [_ to_position]
   ((clojure.core/get m4134 :warp-mouse) to_position))
  (isExclusive [_] ((clojure.core/get m4134 :is-exclusive)))
  (popup [_] ((clojure.core/get m4134 :popup)))
  (popup [_ bounds] ((clojure.core/get m4134 :popup) bounds))
  (popupCentered [_] ((clojure.core/get m4134 :popup-centered)))
  (popupCentered
   [_ size]
   ((clojure.core/get m4134 :popup-centered) size))
  (popupCenteredClamped
   [_]
   ((clojure.core/get m4134 :popup-centered-clamped)))
  (popupCenteredClamped
   [_ size]
   ((clojure.core/get m4134 :popup-centered-clamped) size))
  (popupCenteredClamped
   [_ size fallback_ratio]
   ((clojure.core/get m4134 :popup-centered-clamped)
    size
    fallback_ratio))
  (popupCenteredMinsize
   [_]
   ((clojure.core/get m4134 :popup-centered-minsize)))
  (popupCenteredMinsize
   [_ minsize]
   ((clojure.core/get m4134 :popup-centered-minsize) minsize))
  (popupCenteredRatio
   [_]
   ((clojure.core/get m4134 :popup-centered-ratio)))
  (popupCenteredRatio
   [_ ratio]
   ((clojure.core/get m4134 :popup-centered-ratio) ratio))
  (setAsMinsize [_] ((clojure.core/get m4134 :set-as-minsize)))
  (setExclusive
   [_ enable]
   ((clojure.core/get m4134 :set-exclusive) enable))
  (getCloseButton [_] ((clojure.core/get m4134 :get-close-button)))
  (getResizable [_] ((clojure.core/get m4134 :get-resizable)))
  (getTitle [_] ((clojure.core/get m4134 :get-title)))
  (setResizable
   [_ resizable]
   ((clojure.core/get m4134 :set-resizable) resizable))
  (setTitle [_ title] ((clojure.core/get m4134 :set-title) title))
  (addButton [_ text] ((clojure.core/get m4134 :add-button) text))
  (addButton
   [_ text right]
   ((clojure.core/get m4134 :add-button) text right))
  (addButton
   [_ text right action]
   ((clojure.core/get m4134 :add-button) text right action))
  (addCancel [_ name] ((clojure.core/get m4134 :add-cancel) name))
  (getHideOnOk [_] ((clojure.core/get m4134 :get-hide-on-ok)))
  (getLabel [_] ((clojure.core/get m4134 :get-label)))
  (getOk [_] ((clojure.core/get m4134 :get-ok)))
  (getText [_] ((clojure.core/get m4134 :get-text)))
  (hasAutowrap [_] ((clojure.core/get m4134 :has-autowrap)))
  (registerTextEnter
   [_ line_edit]
   ((clojure.core/get m4134 :register-text-enter) line_edit))
  (setAutowrap
   [_ autowrap]
   ((clojure.core/get m4134 :set-autowrap) autowrap))
  (setHideOnOk
   [_ enabled]
   ((clojure.core/get m4134 :set-hide-on-ok) enabled))
  (setText [_ text] ((clojure.core/get m4134 :set-text) text))
  (getCancel [_] ((clojure.core/get m4134 :get-cancel))))
(deftype GodotTween
  [m4135]
  proto/ToVariant
  (->variant [this] (proto/->variant m4135))
  clojure.lang.ILookup
  (valAt [_ k] (get m4135 k))
  godotclj.api.gdscript.IGodotTween
  (addUserSignal
   [_ signal]
   ((clojure.core/get m4135 :add-user-signal) signal))
  (addUserSignal
   [_ signal arguments]
   ((clojure.core/get m4135 :add-user-signal) signal arguments))
  (call [_ method] ((clojure.core/get m4135 :call) method))
  (call [_ method v1] ((clojure.core/get m4135 :call) method v1))
  (call
   [_ method v1 v2]
   ((clojure.core/get m4135 :call) method v1 v2))
  (call
   [_ method v1 v2 v3]
   ((clojure.core/get m4135 :call) method v1 v2 v3))
  (call
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4135 :call) method v1 v2 v3 v4))
  (call
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4135 :call) method v1 v2 v3 v4 v5))
  (callDeferred
   [_ method]
   ((clojure.core/get m4135 :call-deferred) method))
  (callDeferred
   [_ method v1]
   ((clojure.core/get m4135 :call-deferred) method v1))
  (callDeferred
   [_ method v1 v2]
   ((clojure.core/get m4135 :call-deferred) method v1 v2))
  (callDeferred
   [_ method v1 v2 v3]
   ((clojure.core/get m4135 :call-deferred) method v1 v2 v3))
  (callDeferred
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4135 :call-deferred) method v1 v2 v3 v4))
  (callDeferred
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4135 :call-deferred) method v1 v2 v3 v4 v5))
  (callv
   [_ method arg_array]
   ((clojure.core/get m4135 :callv) method arg_array))
  (canTranslateMessages
   [_]
   ((clojure.core/get m4135 :can-translate-messages)))
  (connect
   [_ signal target method]
   ((clojure.core/get m4135 :connect) signal target method))
  (connect
   [_ signal target method binds]
   ((clojure.core/get m4135 :connect) signal target method binds))
  (connect
   [_ signal target method binds flags]
   ((clojure.core/get m4135 :connect)
    signal
    target
    method
    binds
    flags))
  (disconnect
   [_ signal target method]
   ((clojure.core/get m4135 :disconnect) signal target method))
  (emitSignal
   [_ signal]
   ((clojure.core/get m4135 :emit-signal) signal))
  (emitSignal
   [_ signal v1]
   ((clojure.core/get m4135 :emit-signal) signal v1))
  (emitSignal
   [_ signal v1 v2]
   ((clojure.core/get m4135 :emit-signal) signal v1 v2))
  (emitSignal
   [_ signal v1 v2 v3]
   ((clojure.core/get m4135 :emit-signal) signal v1 v2 v3))
  (emitSignal
   [_ signal v1 v2 v3 v4]
   ((clojure.core/get m4135 :emit-signal) signal v1 v2 v3 v4))
  (emitSignal
   [_ signal v1 v2 v3 v4 v5]
   ((clojure.core/get m4135 :emit-signal) signal v1 v2 v3 v4 v5))
  (free [_] ((clojure.core/get m4135 :free)))
  (get [_ property] ((clojure.core/get m4135 :get) property))
  (getClass [_] ((clojure.core/get m4135 :get-class)))
  (getIncomingConnections
   [_]
   ((clojure.core/get m4135 :get-incoming-connections)))
  (getIndexed
   [_ property]
   ((clojure.core/get m4135 :get-indexed) property))
  (getInstanceId [_] ((clojure.core/get m4135 :get-instance-id)))
  (getMeta [_ name] ((clojure.core/get m4135 :get-meta) name))
  (getMetaList [_] ((clojure.core/get m4135 :get-meta-list)))
  (getMethodList [_] ((clojure.core/get m4135 :get-method-list)))
  (getPropertyList [_] ((clojure.core/get m4135 :get-property-list)))
  (getScript [_] ((clojure.core/get m4135 :get-script)))
  (getSignalConnectionList
   [_ signal]
   ((clojure.core/get m4135 :get-signal-connection-list) signal))
  (getSignalList [_] ((clojure.core/get m4135 :get-signal-list)))
  (hasMeta [_ name] ((clojure.core/get m4135 :has-meta) name))
  (hasMethod [_ method] ((clojure.core/get m4135 :has-method) method))
  (hasSignal [_ signal] ((clojure.core/get m4135 :has-signal) signal))
  (hasUserSignal
   [_ signal]
   ((clojure.core/get m4135 :has-user-signal) signal))
  (isBlockingSignals
   [_]
   ((clojure.core/get m4135 :is-blocking-signals)))
  (isClass [_ class] ((clojure.core/get m4135 :is-class) class))
  (isConnected
   [_ signal target method]
   ((clojure.core/get m4135 :is-connected) signal target method))
  (isQueuedForDeletion
   [_]
   ((clojure.core/get m4135 :is-queued-for-deletion)))
  (notification
   [_ what]
   ((clojure.core/get m4135 :notification) what))
  (notification
   [_ what reversed]
   ((clojure.core/get m4135 :notification) what reversed))
  (propertyListChangedNotify
   [_]
   ((clojure.core/get m4135 :property-list-changed-notify)))
  (removeMeta [_ name] ((clojure.core/get m4135 :remove-meta) name))
  (set
   [_ property value]
   ((clojure.core/get m4135 :set) property value))
  (setBlockSignals
   [_ enable]
   ((clojure.core/get m4135 :set-block-signals) enable))
  (setDeferred
   [_ property value]
   ((clojure.core/get m4135 :set-deferred) property value))
  (setIndexed
   [_ property value]
   ((clojure.core/get m4135 :set-indexed) property value))
  (setMessageTranslation
   [_ enable]
   ((clojure.core/get m4135 :set-message-translation) enable))
  (setMeta
   [_ name value]
   ((clojure.core/get m4135 :set-meta) name value))
  (setScript [_ script] ((clojure.core/get m4135 :set-script) script))
  (tr [_ message] ((clojure.core/get m4135 :tr) message))
  (addChild [_ node] ((clojure.core/get m4135 :add-child) node))
  (addChild
   [_ node legible_unique_name]
   ((clojure.core/get m4135 :add-child) node legible_unique_name))
  (addChildBelowNode
   [_ node child_node]
   ((clojure.core/get m4135 :add-child-below-node) node child_node))
  (addChildBelowNode
   [_ node child_node legible_unique_name]
   ((clojure.core/get m4135 :add-child-below-node)
    node
    child_node
    legible_unique_name))
  (addToGroup
   [_ group]
   ((clojure.core/get m4135 :add-to-group) group))
  (addToGroup
   [_ group persistent]
   ((clojure.core/get m4135 :add-to-group) group persistent))
  (canProcess [_] ((clojure.core/get m4135 :can-process)))
  (duplicate [_] ((clojure.core/get m4135 :duplicate)))
  (duplicate [_ flags] ((clojure.core/get m4135 :duplicate) flags))
  (findNode [_ mask] ((clojure.core/get m4135 :find-node) mask))
  (findNode
   [_ mask recursive]
   ((clojure.core/get m4135 :find-node) mask recursive))
  (findNode
   [_ mask recursive owned]
   ((clojure.core/get m4135 :find-node) mask recursive owned))
  (findParent [_ mask] ((clojure.core/get m4135 :find-parent) mask))
  (getChild [_ idx] ((clojure.core/get m4135 :get-child) idx))
  (getChildCount [_] ((clojure.core/get m4135 :get-child-count)))
  (getChildren [_] ((clojure.core/get m4135 :get-children)))
  (getCustomMultiplayer
   [_]
   ((clojure.core/get m4135 :get-custom-multiplayer)))
  (getFilename [_] ((clojure.core/get m4135 :get-filename)))
  (getGroups [_] ((clojure.core/get m4135 :get-groups)))
  (getIndex [_] ((clojure.core/get m4135 :get-index)))
  (getMultiplayer [_] ((clojure.core/get m4135 :get-multiplayer)))
  (getName [_] ((clojure.core/get m4135 :get-name)))
  (getNetworkMaster
   [_]
   ((clojure.core/get m4135 :get-network-master)))
  (getNode [_ path] ((clojure.core/get m4135 :get-node) path))
  (getNodeAndResource
   [_ path]
   ((clojure.core/get m4135 :get-node-and-resource) path))
  (getNodeOrNull
   [_ path]
   ((clojure.core/get m4135 :get-node-or-null) path))
  (getOwner [_] ((clojure.core/get m4135 :get-owner)))
  (getParent [_] ((clojure.core/get m4135 :get-parent)))
  (getPath [_] ((clojure.core/get m4135 :get-path)))
  (getPathTo [_ node] ((clojure.core/get m4135 :get-path-to) node))
  (getPauseMode [_] ((clojure.core/get m4135 :get-pause-mode)))
  (getPhysicsProcessDeltaTime
   [_]
   ((clojure.core/get m4135 :get-physics-process-delta-time)))
  (getPositionInParent
   [_]
   ((clojure.core/get m4135 :get-position-in-parent)))
  (getProcessDeltaTime
   [_]
   ((clojure.core/get m4135 :get-process-delta-time)))
  (getProcessPriority
   [_]
   ((clojure.core/get m4135 :get-process-priority)))
  (getSceneInstanceLoadPlaceholder
   [_]
   ((clojure.core/get m4135 :get-scene-instance-load-placeholder)))
  (getTree [_] ((clojure.core/get m4135 :get-tree)))
  (getViewport [_] ((clojure.core/get m4135 :get-viewport)))
  (hasNode [_ path] ((clojure.core/get m4135 :has-node) path))
  (hasNodeAndResource
   [_ path]
   ((clojure.core/get m4135 :has-node-and-resource) path))
  (isAParentOf
   [_ node]
   ((clojure.core/get m4135 :is-a-parent-of) node))
  (isDisplayedFolded
   [_]
   ((clojure.core/get m4135 :is-displayed-folded)))
  (isGreaterThan
   [_ node]
   ((clojure.core/get m4135 :is-greater-than) node))
  (isInGroup [_ group] ((clojure.core/get m4135 :is-in-group) group))
  (isInsideTree [_] ((clojure.core/get m4135 :is-inside-tree)))
  (isNetworkMaster [_] ((clojure.core/get m4135 :is-network-master)))
  (isPhysicsProcessing
   [_]
   ((clojure.core/get m4135 :is-physics-processing)))
  (isPhysicsProcessingInternal
   [_]
   ((clojure.core/get m4135 :is-physics-processing-internal)))
  (isProcessing [_] ((clojure.core/get m4135 :is-processing)))
  (isProcessingInput
   [_]
   ((clojure.core/get m4135 :is-processing-input)))
  (isProcessingInternal
   [_]
   ((clojure.core/get m4135 :is-processing-internal)))
  (isProcessingUnhandledInput
   [_]
   ((clojure.core/get m4135 :is-processing-unhandled-input)))
  (isProcessingUnhandledKeyInput
   [_]
   ((clojure.core/get m4135 :is-processing-unhandled-key-input)))
  (moveChild
   [_ child_node to_position]
   ((clojure.core/get m4135 :move-child) child_node to_position))
  (printStrayNodes [_] ((clojure.core/get m4135 :print-stray-nodes)))
  (printTree [_] ((clojure.core/get m4135 :print-tree)))
  (printTreePretty [_] ((clojure.core/get m4135 :print-tree-pretty)))
  (propagateCall
   [_ method]
   ((clojure.core/get m4135 :propagate-call) method))
  (propagateCall
   [_ method args]
   ((clojure.core/get m4135 :propagate-call) method args))
  (propagateCall
   [_ method args parent_first]
   ((clojure.core/get m4135 :propagate-call) method args parent_first))
  (propagateNotification
   [_ what]
   ((clojure.core/get m4135 :propagate-notification) what))
  (queueFree [_] ((clojure.core/get m4135 :queue-free)))
  (raise [_] ((clojure.core/get m4135 :raise)))
  (removeAndSkip [_] ((clojure.core/get m4135 :remove-and-skip)))
  (removeChild [_ node] ((clojure.core/get m4135 :remove-child) node))
  (removeFromGroup
   [_ group]
   ((clojure.core/get m4135 :remove-from-group) group))
  (replaceBy [_ node] ((clojure.core/get m4135 :replace-by) node))
  (replaceBy
   [_ node keep_data]
   ((clojure.core/get m4135 :replace-by) node keep_data))
  (requestReady [_] ((clojure.core/get m4135 :request-ready)))
  (rpc [_ method] ((clojure.core/get m4135 :rpc) method))
  (rpc [_ method v1] ((clojure.core/get m4135 :rpc) method v1))
  (rpc [_ method v1 v2] ((clojure.core/get m4135 :rpc) method v1 v2))
  (rpc
   [_ method v1 v2 v3]
   ((clojure.core/get m4135 :rpc) method v1 v2 v3))
  (rpc
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4135 :rpc) method v1 v2 v3 v4))
  (rpc
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4135 :rpc) method v1 v2 v3 v4 v5))
  (rpcConfig
   [_ method mode]
   ((clojure.core/get m4135 :rpc-config) method mode))
  (rpcId
   [_ peer_id method]
   ((clojure.core/get m4135 :rpc-id) peer_id method))
  (rpcId
   [_ peer_id method v1]
   ((clojure.core/get m4135 :rpc-id) peer_id method v1))
  (rpcId
   [_ peer_id method v1 v2]
   ((clojure.core/get m4135 :rpc-id) peer_id method v1 v2))
  (rpcId
   [_ peer_id method v1 v2 v3]
   ((clojure.core/get m4135 :rpc-id) peer_id method v1 v2 v3))
  (rpcId
   [_ peer_id method v1 v2 v3 v4]
   ((clojure.core/get m4135 :rpc-id) peer_id method v1 v2 v3 v4))
  (rpcId
   [_ peer_id method v1 v2 v3 v4 v5]
   ((clojure.core/get m4135 :rpc-id) peer_id method v1 v2 v3 v4 v5))
  (rpcUnreliable
   [_ method]
   ((clojure.core/get m4135 :rpc-unreliable) method))
  (rpcUnreliable
   [_ method v1]
   ((clojure.core/get m4135 :rpc-unreliable) method v1))
  (rpcUnreliable
   [_ method v1 v2]
   ((clojure.core/get m4135 :rpc-unreliable) method v1 v2))
  (rpcUnreliable
   [_ method v1 v2 v3]
   ((clojure.core/get m4135 :rpc-unreliable) method v1 v2 v3))
  (rpcUnreliable
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4135 :rpc-unreliable) method v1 v2 v3 v4))
  (rpcUnreliable
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4135 :rpc-unreliable) method v1 v2 v3 v4 v5))
  (rpcUnreliableId
   [_ peer_id method]
   ((clojure.core/get m4135 :rpc-unreliable-id) peer_id method))
  (rpcUnreliableId
   [_ peer_id method v1]
   ((clojure.core/get m4135 :rpc-unreliable-id) peer_id method v1))
  (rpcUnreliableId
   [_ peer_id method v1 v2]
   ((clojure.core/get m4135 :rpc-unreliable-id) peer_id method v1 v2))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3]
   ((clojure.core/get m4135 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3 v4]
   ((clojure.core/get m4135 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3
    v4))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3 v4 v5]
   ((clojure.core/get m4135 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3
    v4
    v5))
  (rset
   [_ property value]
   ((clojure.core/get m4135 :rset) property value))
  (rsetConfig
   [_ property mode]
   ((clojure.core/get m4135 :rset-config) property mode))
  (rsetId
   [_ peer_id property value]
   ((clojure.core/get m4135 :rset-id) peer_id property value))
  (rsetUnreliable
   [_ property value]
   ((clojure.core/get m4135 :rset-unreliable) property value))
  (rsetUnreliableId
   [_ peer_id property value]
   ((clojure.core/get m4135 :rset-unreliable-id)
    peer_id
    property
    value))
  (setCustomMultiplayer
   [_ api]
   ((clojure.core/get m4135 :set-custom-multiplayer) api))
  (setDisplayFolded
   [_ fold]
   ((clojure.core/get m4135 :set-display-folded) fold))
  (setFilename
   [_ filename]
   ((clojure.core/get m4135 :set-filename) filename))
  (setName [_ name] ((clojure.core/get m4135 :set-name) name))
  (setNetworkMaster
   [_ id]
   ((clojure.core/get m4135 :set-network-master) id))
  (setNetworkMaster
   [_ id recursive]
   ((clojure.core/get m4135 :set-network-master) id recursive))
  (setOwner [_ owner] ((clojure.core/get m4135 :set-owner) owner))
  (setPauseMode
   [_ mode]
   ((clojure.core/get m4135 :set-pause-mode) mode))
  (setPhysicsProcess
   [_ enable]
   ((clojure.core/get m4135 :set-physics-process) enable))
  (setPhysicsProcessInternal
   [_ enable]
   ((clojure.core/get m4135 :set-physics-process-internal) enable))
  (setProcess
   [_ enable]
   ((clojure.core/get m4135 :set-process) enable))
  (setProcessInput
   [_ enable]
   ((clojure.core/get m4135 :set-process-input) enable))
  (setProcessInternal
   [_ enable]
   ((clojure.core/get m4135 :set-process-internal) enable))
  (setProcessPriority
   [_ priority]
   ((clojure.core/get m4135 :set-process-priority) priority))
  (setProcessUnhandledInput
   [_ enable]
   ((clojure.core/get m4135 :set-process-unhandled-input) enable))
  (setProcessUnhandledKeyInput
   [_ enable]
   ((clojure.core/get m4135 :set-process-unhandled-key-input) enable))
  (setSceneInstanceLoadPlaceholder
   [_ load_placeholder]
   ((clojure.core/get m4135 :set-scene-instance-load-placeholder)
    load_placeholder))
  (updateConfigurationWarning
   [_]
   ((clojure.core/get m4135 :update-configuration-warning)))
  (followMethod
   [_ object method initial_val target target_method duration]
   ((clojure.core/get m4135 :follow-method)
    object
    method
    initial_val
    target
    target_method
    duration))
  (followMethod
   [_
    object
    method
    initial_val
    target
    target_method
    duration
    trans_type]
   ((clojure.core/get m4135 :follow-method)
    object
    method
    initial_val
    target
    target_method
    duration
    trans_type))
  (followMethod
   [_
    object
    method
    initial_val
    target
    target_method
    duration
    trans_type
    ease_type]
   ((clojure.core/get m4135 :follow-method)
    object
    method
    initial_val
    target
    target_method
    duration
    trans_type
    ease_type))
  (followMethod
   [_
    object
    method
    initial_val
    target
    target_method
    duration
    trans_type
    ease_type
    delay]
   ((clojure.core/get m4135 :follow-method)
    object
    method
    initial_val
    target
    target_method
    duration
    trans_type
    ease_type
    delay))
  (followProperty
   [_ object property initial_val target target_property duration]
   ((clojure.core/get m4135 :follow-property)
    object
    property
    initial_val
    target
    target_property
    duration))
  (followProperty
   [_
    object
    property
    initial_val
    target
    target_property
    duration
    trans_type]
   ((clojure.core/get m4135 :follow-property)
    object
    property
    initial_val
    target
    target_property
    duration
    trans_type))
  (followProperty
   [_
    object
    property
    initial_val
    target
    target_property
    duration
    trans_type
    ease_type]
   ((clojure.core/get m4135 :follow-property)
    object
    property
    initial_val
    target
    target_property
    duration
    trans_type
    ease_type))
  (followProperty
   [_
    object
    property
    initial_val
    target
    target_property
    duration
    trans_type
    ease_type
    delay]
   ((clojure.core/get m4135 :follow-property)
    object
    property
    initial_val
    target
    target_property
    duration
    trans_type
    ease_type
    delay))
  (getRuntime [_] ((clojure.core/get m4135 :get-runtime)))
  (getSpeedScale [_] ((clojure.core/get m4135 :get-speed-scale)))
  (getTweenProcessMode
   [_]
   ((clojure.core/get m4135 :get-tween-process-mode)))
  (interpolateCallback
   [_ object duration callback]
   ((clojure.core/get m4135 :interpolate-callback)
    object
    duration
    callback))
  (interpolateCallback
   [_ object duration callback arg1]
   ((clojure.core/get m4135 :interpolate-callback)
    object
    duration
    callback
    arg1))
  (interpolateCallback
   [_ object duration callback arg1 arg2]
   ((clojure.core/get m4135 :interpolate-callback)
    object
    duration
    callback
    arg1
    arg2))
  (interpolateCallback
   [_ object duration callback arg1 arg2 arg3]
   ((clojure.core/get m4135 :interpolate-callback)
    object
    duration
    callback
    arg1
    arg2
    arg3))
  (interpolateCallback
   [_ object duration callback arg1 arg2 arg3 arg4]
   ((clojure.core/get m4135 :interpolate-callback)
    object
    duration
    callback
    arg1
    arg2
    arg3
    arg4))
  (interpolateCallback
   [_ object duration callback arg1 arg2 arg3 arg4 arg5]
   ((clojure.core/get m4135 :interpolate-callback)
    object
    duration
    callback
    arg1
    arg2
    arg3
    arg4
    arg5))
  (interpolateDeferredCallback
   [_ object duration callback]
   ((clojure.core/get m4135 :interpolate-deferred-callback)
    object
    duration
    callback))
  (interpolateDeferredCallback
   [_ object duration callback arg1]
   ((clojure.core/get m4135 :interpolate-deferred-callback)
    object
    duration
    callback
    arg1))
  (interpolateDeferredCallback
   [_ object duration callback arg1 arg2]
   ((clojure.core/get m4135 :interpolate-deferred-callback)
    object
    duration
    callback
    arg1
    arg2))
  (interpolateDeferredCallback
   [_ object duration callback arg1 arg2 arg3]
   ((clojure.core/get m4135 :interpolate-deferred-callback)
    object
    duration
    callback
    arg1
    arg2
    arg3))
  (interpolateDeferredCallback
   [_ object duration callback arg1 arg2 arg3 arg4]
   ((clojure.core/get m4135 :interpolate-deferred-callback)
    object
    duration
    callback
    arg1
    arg2
    arg3
    arg4))
  (interpolateDeferredCallback
   [_ object duration callback arg1 arg2 arg3 arg4 arg5]
   ((clojure.core/get m4135 :interpolate-deferred-callback)
    object
    duration
    callback
    arg1
    arg2
    arg3
    arg4
    arg5))
  (interpolateMethod
   [_ object method initial_val final_val duration]
   ((clojure.core/get m4135 :interpolate-method)
    object
    method
    initial_val
    final_val
    duration))
  (interpolateMethod
   [_ object method initial_val final_val duration trans_type]
   ((clojure.core/get m4135 :interpolate-method)
    object
    method
    initial_val
    final_val
    duration
    trans_type))
  (interpolateMethod
   [_
    object
    method
    initial_val
    final_val
    duration
    trans_type
    ease_type]
   ((clojure.core/get m4135 :interpolate-method)
    object
    method
    initial_val
    final_val
    duration
    trans_type
    ease_type))
  (interpolateMethod
   [_
    object
    method
    initial_val
    final_val
    duration
    trans_type
    ease_type
    delay]
   ((clojure.core/get m4135 :interpolate-method)
    object
    method
    initial_val
    final_val
    duration
    trans_type
    ease_type
    delay))
  (interpolateProperty
   [_ object property initial_val final_val duration]
   ((clojure.core/get m4135 :interpolate-property)
    object
    property
    initial_val
    final_val
    duration))
  (interpolateProperty
   [_ object property initial_val final_val duration trans_type]
   ((clojure.core/get m4135 :interpolate-property)
    object
    property
    initial_val
    final_val
    duration
    trans_type))
  (interpolateProperty
   [_
    object
    property
    initial_val
    final_val
    duration
    trans_type
    ease_type]
   ((clojure.core/get m4135 :interpolate-property)
    object
    property
    initial_val
    final_val
    duration
    trans_type
    ease_type))
  (interpolateProperty
   [_
    object
    property
    initial_val
    final_val
    duration
    trans_type
    ease_type
    delay]
   ((clojure.core/get m4135 :interpolate-property)
    object
    property
    initial_val
    final_val
    duration
    trans_type
    ease_type
    delay))
  (isActive [_] ((clojure.core/get m4135 :is-active)))
  (isRepeat [_] ((clojure.core/get m4135 :is-repeat)))
  (remove [_ object] ((clojure.core/get m4135 :remove) object))
  (remove
   [_ object key]
   ((clojure.core/get m4135 :remove) object key))
  (removeAll [_] ((clojure.core/get m4135 :remove-all)))
  (reset [_ object] ((clojure.core/get m4135 :reset) object))
  (reset [_ object key] ((clojure.core/get m4135 :reset) object key))
  (resetAll [_] ((clojure.core/get m4135 :reset-all)))
  (resume [_ object] ((clojure.core/get m4135 :resume) object))
  (resume
   [_ object key]
   ((clojure.core/get m4135 :resume) object key))
  (resumeAll [_] ((clojure.core/get m4135 :resume-all)))
  (seek [_ time] ((clojure.core/get m4135 :seek) time))
  (setActive [_ active] ((clojure.core/get m4135 :set-active) active))
  (setRepeat [_ repeat] ((clojure.core/get m4135 :set-repeat) repeat))
  (setSpeedScale
   [_ speed]
   ((clojure.core/get m4135 :set-speed-scale) speed))
  (setTweenProcessMode
   [_ mode]
   ((clojure.core/get m4135 :set-tween-process-mode) mode))
  (start [_] ((clojure.core/get m4135 :start)))
  (stop [_ object] ((clojure.core/get m4135 :stop) object))
  (stop [_ object key] ((clojure.core/get m4135 :stop) object key))
  (stopAll [_] ((clojure.core/get m4135 :stop-all)))
  (targetingMethod
   [_ object method initial initial_method final_val duration]
   ((clojure.core/get m4135 :targeting-method)
    object
    method
    initial
    initial_method
    final_val
    duration))
  (targetingMethod
   [_
    object
    method
    initial
    initial_method
    final_val
    duration
    trans_type]
   ((clojure.core/get m4135 :targeting-method)
    object
    method
    initial
    initial_method
    final_val
    duration
    trans_type))
  (targetingMethod
   [_
    object
    method
    initial
    initial_method
    final_val
    duration
    trans_type
    ease_type]
   ((clojure.core/get m4135 :targeting-method)
    object
    method
    initial
    initial_method
    final_val
    duration
    trans_type
    ease_type))
  (targetingMethod
   [_
    object
    method
    initial
    initial_method
    final_val
    duration
    trans_type
    ease_type
    delay]
   ((clojure.core/get m4135 :targeting-method)
    object
    method
    initial
    initial_method
    final_val
    duration
    trans_type
    ease_type
    delay))
  (targetingProperty
   [_ object property initial initial_val final_val duration]
   ((clojure.core/get m4135 :targeting-property)
    object
    property
    initial
    initial_val
    final_val
    duration))
  (targetingProperty
   [_
    object
    property
    initial
    initial_val
    final_val
    duration
    trans_type]
   ((clojure.core/get m4135 :targeting-property)
    object
    property
    initial
    initial_val
    final_val
    duration
    trans_type))
  (targetingProperty
   [_
    object
    property
    initial
    initial_val
    final_val
    duration
    trans_type
    ease_type]
   ((clojure.core/get m4135 :targeting-property)
    object
    property
    initial
    initial_val
    final_val
    duration
    trans_type
    ease_type))
  (targetingProperty
   [_
    object
    property
    initial
    initial_val
    final_val
    duration
    trans_type
    ease_type
    delay]
   ((clojure.core/get m4135 :targeting-property)
    object
    property
    initial
    initial_val
    final_val
    duration
    trans_type
    ease_type
    delay))
  (tell [_] ((clojure.core/get m4135 :tell))))
(deftype GodotXMLParser
  [m4136]
  proto/ToVariant
  (->variant [this] (proto/->variant m4136))
  clojure.lang.ILookup
  (valAt [_ k] (get m4136 k))
  godotclj.api.gdscript.IGodotXMLParser
  (addUserSignal
   [_ signal]
   ((clojure.core/get m4136 :add-user-signal) signal))
  (addUserSignal
   [_ signal arguments]
   ((clojure.core/get m4136 :add-user-signal) signal arguments))
  (call [_ method] ((clojure.core/get m4136 :call) method))
  (call [_ method v1] ((clojure.core/get m4136 :call) method v1))
  (call
   [_ method v1 v2]
   ((clojure.core/get m4136 :call) method v1 v2))
  (call
   [_ method v1 v2 v3]
   ((clojure.core/get m4136 :call) method v1 v2 v3))
  (call
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4136 :call) method v1 v2 v3 v4))
  (call
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4136 :call) method v1 v2 v3 v4 v5))
  (callDeferred
   [_ method]
   ((clojure.core/get m4136 :call-deferred) method))
  (callDeferred
   [_ method v1]
   ((clojure.core/get m4136 :call-deferred) method v1))
  (callDeferred
   [_ method v1 v2]
   ((clojure.core/get m4136 :call-deferred) method v1 v2))
  (callDeferred
   [_ method v1 v2 v3]
   ((clojure.core/get m4136 :call-deferred) method v1 v2 v3))
  (callDeferred
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4136 :call-deferred) method v1 v2 v3 v4))
  (callDeferred
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4136 :call-deferred) method v1 v2 v3 v4 v5))
  (callv
   [_ method arg_array]
   ((clojure.core/get m4136 :callv) method arg_array))
  (canTranslateMessages
   [_]
   ((clojure.core/get m4136 :can-translate-messages)))
  (connect
   [_ signal target method]
   ((clojure.core/get m4136 :connect) signal target method))
  (connect
   [_ signal target method binds]
   ((clojure.core/get m4136 :connect) signal target method binds))
  (connect
   [_ signal target method binds flags]
   ((clojure.core/get m4136 :connect)
    signal
    target
    method
    binds
    flags))
  (disconnect
   [_ signal target method]
   ((clojure.core/get m4136 :disconnect) signal target method))
  (emitSignal
   [_ signal]
   ((clojure.core/get m4136 :emit-signal) signal))
  (emitSignal
   [_ signal v1]
   ((clojure.core/get m4136 :emit-signal) signal v1))
  (emitSignal
   [_ signal v1 v2]
   ((clojure.core/get m4136 :emit-signal) signal v1 v2))
  (emitSignal
   [_ signal v1 v2 v3]
   ((clojure.core/get m4136 :emit-signal) signal v1 v2 v3))
  (emitSignal
   [_ signal v1 v2 v3 v4]
   ((clojure.core/get m4136 :emit-signal) signal v1 v2 v3 v4))
  (emitSignal
   [_ signal v1 v2 v3 v4 v5]
   ((clojure.core/get m4136 :emit-signal) signal v1 v2 v3 v4 v5))
  (free [_] ((clojure.core/get m4136 :free)))
  (get [_ property] ((clojure.core/get m4136 :get) property))
  (getClass [_] ((clojure.core/get m4136 :get-class)))
  (getIncomingConnections
   [_]
   ((clojure.core/get m4136 :get-incoming-connections)))
  (getIndexed
   [_ property]
   ((clojure.core/get m4136 :get-indexed) property))
  (getInstanceId [_] ((clojure.core/get m4136 :get-instance-id)))
  (getMeta [_ name] ((clojure.core/get m4136 :get-meta) name))
  (getMetaList [_] ((clojure.core/get m4136 :get-meta-list)))
  (getMethodList [_] ((clojure.core/get m4136 :get-method-list)))
  (getPropertyList [_] ((clojure.core/get m4136 :get-property-list)))
  (getScript [_] ((clojure.core/get m4136 :get-script)))
  (getSignalConnectionList
   [_ signal]
   ((clojure.core/get m4136 :get-signal-connection-list) signal))
  (getSignalList [_] ((clojure.core/get m4136 :get-signal-list)))
  (hasMeta [_ name] ((clojure.core/get m4136 :has-meta) name))
  (hasMethod [_ method] ((clojure.core/get m4136 :has-method) method))
  (hasSignal [_ signal] ((clojure.core/get m4136 :has-signal) signal))
  (hasUserSignal
   [_ signal]
   ((clojure.core/get m4136 :has-user-signal) signal))
  (isBlockingSignals
   [_]
   ((clojure.core/get m4136 :is-blocking-signals)))
  (isClass [_ class] ((clojure.core/get m4136 :is-class) class))
  (isConnected
   [_ signal target method]
   ((clojure.core/get m4136 :is-connected) signal target method))
  (isQueuedForDeletion
   [_]
   ((clojure.core/get m4136 :is-queued-for-deletion)))
  (notification
   [_ what]
   ((clojure.core/get m4136 :notification) what))
  (notification
   [_ what reversed]
   ((clojure.core/get m4136 :notification) what reversed))
  (propertyListChangedNotify
   [_]
   ((clojure.core/get m4136 :property-list-changed-notify)))
  (removeMeta [_ name] ((clojure.core/get m4136 :remove-meta) name))
  (set
   [_ property value]
   ((clojure.core/get m4136 :set) property value))
  (setBlockSignals
   [_ enable]
   ((clojure.core/get m4136 :set-block-signals) enable))
  (setDeferred
   [_ property value]
   ((clojure.core/get m4136 :set-deferred) property value))
  (setIndexed
   [_ property value]
   ((clojure.core/get m4136 :set-indexed) property value))
  (setMessageTranslation
   [_ enable]
   ((clojure.core/get m4136 :set-message-translation) enable))
  (setMeta
   [_ name value]
   ((clojure.core/get m4136 :set-meta) name value))
  (setScript [_ script] ((clojure.core/get m4136 :set-script) script))
  (tr [_ message] ((clojure.core/get m4136 :tr) message))
  (initRef [_] ((clojure.core/get m4136 :init-ref)))
  (reference [_] ((clojure.core/get m4136 :reference)))
  (unreference [_] ((clojure.core/get m4136 :unreference)))
  (getAttributeCount
   [_]
   ((clojure.core/get m4136 :get-attribute-count)))
  (getAttributeName
   [_ idx]
   ((clojure.core/get m4136 :get-attribute-name) idx))
  (getAttributeValue
   [_ idx]
   ((clojure.core/get m4136 :get-attribute-value) idx))
  (getCurrentLine [_] ((clojure.core/get m4136 :get-current-line)))
  (getNamedAttributeValue
   [_ name]
   ((clojure.core/get m4136 :get-named-attribute-value) name))
  (getNamedAttributeValueSafe
   [_ name]
   ((clojure.core/get m4136 :get-named-attribute-value-safe) name))
  (getNodeData [_] ((clojure.core/get m4136 :get-node-data)))
  (getNodeName [_] ((clojure.core/get m4136 :get-node-name)))
  (getNodeOffset [_] ((clojure.core/get m4136 :get-node-offset)))
  (getNodeType [_] ((clojure.core/get m4136 :get-node-type)))
  (hasAttribute
   [_ name]
   ((clojure.core/get m4136 :has-attribute) name))
  (isEmpty [_] ((clojure.core/get m4136 :is-empty)))
  (open [_ file] ((clojure.core/get m4136 :open) file))
  (openBuffer
   [_ buffer]
   ((clojure.core/get m4136 :open-buffer) buffer))
  (read [_] ((clojure.core/get m4136 :read)))
  (seek [_ position] ((clojure.core/get m4136 :seek) position))
  (skipSection [_] ((clojure.core/get m4136 :skip-section))))
(deftype GodotSpatial
  [m4137]
  proto/ToVariant
  (->variant [this] (proto/->variant m4137))
  clojure.lang.ILookup
  (valAt [_ k] (get m4137 k))
  godotclj.api.gdscript.IGodotSpatial
  (addUserSignal
   [_ signal]
   ((clojure.core/get m4137 :add-user-signal) signal))
  (addUserSignal
   [_ signal arguments]
   ((clojure.core/get m4137 :add-user-signal) signal arguments))
  (call [_ method] ((clojure.core/get m4137 :call) method))
  (call [_ method v1] ((clojure.core/get m4137 :call) method v1))
  (call
   [_ method v1 v2]
   ((clojure.core/get m4137 :call) method v1 v2))
  (call
   [_ method v1 v2 v3]
   ((clojure.core/get m4137 :call) method v1 v2 v3))
  (call
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4137 :call) method v1 v2 v3 v4))
  (call
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4137 :call) method v1 v2 v3 v4 v5))
  (callDeferred
   [_ method]
   ((clojure.core/get m4137 :call-deferred) method))
  (callDeferred
   [_ method v1]
   ((clojure.core/get m4137 :call-deferred) method v1))
  (callDeferred
   [_ method v1 v2]
   ((clojure.core/get m4137 :call-deferred) method v1 v2))
  (callDeferred
   [_ method v1 v2 v3]
   ((clojure.core/get m4137 :call-deferred) method v1 v2 v3))
  (callDeferred
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4137 :call-deferred) method v1 v2 v3 v4))
  (callDeferred
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4137 :call-deferred) method v1 v2 v3 v4 v5))
  (callv
   [_ method arg_array]
   ((clojure.core/get m4137 :callv) method arg_array))
  (canTranslateMessages
   [_]
   ((clojure.core/get m4137 :can-translate-messages)))
  (connect
   [_ signal target method]
   ((clojure.core/get m4137 :connect) signal target method))
  (connect
   [_ signal target method binds]
   ((clojure.core/get m4137 :connect) signal target method binds))
  (connect
   [_ signal target method binds flags]
   ((clojure.core/get m4137 :connect)
    signal
    target
    method
    binds
    flags))
  (disconnect
   [_ signal target method]
   ((clojure.core/get m4137 :disconnect) signal target method))
  (emitSignal
   [_ signal]
   ((clojure.core/get m4137 :emit-signal) signal))
  (emitSignal
   [_ signal v1]
   ((clojure.core/get m4137 :emit-signal) signal v1))
  (emitSignal
   [_ signal v1 v2]
   ((clojure.core/get m4137 :emit-signal) signal v1 v2))
  (emitSignal
   [_ signal v1 v2 v3]
   ((clojure.core/get m4137 :emit-signal) signal v1 v2 v3))
  (emitSignal
   [_ signal v1 v2 v3 v4]
   ((clojure.core/get m4137 :emit-signal) signal v1 v2 v3 v4))
  (emitSignal
   [_ signal v1 v2 v3 v4 v5]
   ((clojure.core/get m4137 :emit-signal) signal v1 v2 v3 v4 v5))
  (free [_] ((clojure.core/get m4137 :free)))
  (get [_ property] ((clojure.core/get m4137 :get) property))
  (getClass [_] ((clojure.core/get m4137 :get-class)))
  (getIncomingConnections
   [_]
   ((clojure.core/get m4137 :get-incoming-connections)))
  (getIndexed
   [_ property]
   ((clojure.core/get m4137 :get-indexed) property))
  (getInstanceId [_] ((clojure.core/get m4137 :get-instance-id)))
  (getMeta [_ name] ((clojure.core/get m4137 :get-meta) name))
  (getMetaList [_] ((clojure.core/get m4137 :get-meta-list)))
  (getMethodList [_] ((clojure.core/get m4137 :get-method-list)))
  (getPropertyList [_] ((clojure.core/get m4137 :get-property-list)))
  (getScript [_] ((clojure.core/get m4137 :get-script)))
  (getSignalConnectionList
   [_ signal]
   ((clojure.core/get m4137 :get-signal-connection-list) signal))
  (getSignalList [_] ((clojure.core/get m4137 :get-signal-list)))
  (hasMeta [_ name] ((clojure.core/get m4137 :has-meta) name))
  (hasMethod [_ method] ((clojure.core/get m4137 :has-method) method))
  (hasSignal [_ signal] ((clojure.core/get m4137 :has-signal) signal))
  (hasUserSignal
   [_ signal]
   ((clojure.core/get m4137 :has-user-signal) signal))
  (isBlockingSignals
   [_]
   ((clojure.core/get m4137 :is-blocking-signals)))
  (isClass [_ class] ((clojure.core/get m4137 :is-class) class))
  (isConnected
   [_ signal target method]
   ((clojure.core/get m4137 :is-connected) signal target method))
  (isQueuedForDeletion
   [_]
   ((clojure.core/get m4137 :is-queued-for-deletion)))
  (notification
   [_ what]
   ((clojure.core/get m4137 :notification) what))
  (notification
   [_ what reversed]
   ((clojure.core/get m4137 :notification) what reversed))
  (propertyListChangedNotify
   [_]
   ((clojure.core/get m4137 :property-list-changed-notify)))
  (removeMeta [_ name] ((clojure.core/get m4137 :remove-meta) name))
  (set
   [_ property value]
   ((clojure.core/get m4137 :set) property value))
  (setBlockSignals
   [_ enable]
   ((clojure.core/get m4137 :set-block-signals) enable))
  (setDeferred
   [_ property value]
   ((clojure.core/get m4137 :set-deferred) property value))
  (setIndexed
   [_ property value]
   ((clojure.core/get m4137 :set-indexed) property value))
  (setMessageTranslation
   [_ enable]
   ((clojure.core/get m4137 :set-message-translation) enable))
  (setMeta
   [_ name value]
   ((clojure.core/get m4137 :set-meta) name value))
  (setScript [_ script] ((clojure.core/get m4137 :set-script) script))
  (tr [_ message] ((clojure.core/get m4137 :tr) message))
  (addChild [_ node] ((clojure.core/get m4137 :add-child) node))
  (addChild
   [_ node legible_unique_name]
   ((clojure.core/get m4137 :add-child) node legible_unique_name))
  (addChildBelowNode
   [_ node child_node]
   ((clojure.core/get m4137 :add-child-below-node) node child_node))
  (addChildBelowNode
   [_ node child_node legible_unique_name]
   ((clojure.core/get m4137 :add-child-below-node)
    node
    child_node
    legible_unique_name))
  (addToGroup
   [_ group]
   ((clojure.core/get m4137 :add-to-group) group))
  (addToGroup
   [_ group persistent]
   ((clojure.core/get m4137 :add-to-group) group persistent))
  (canProcess [_] ((clojure.core/get m4137 :can-process)))
  (duplicate [_] ((clojure.core/get m4137 :duplicate)))
  (duplicate [_ flags] ((clojure.core/get m4137 :duplicate) flags))
  (findNode [_ mask] ((clojure.core/get m4137 :find-node) mask))
  (findNode
   [_ mask recursive]
   ((clojure.core/get m4137 :find-node) mask recursive))
  (findNode
   [_ mask recursive owned]
   ((clojure.core/get m4137 :find-node) mask recursive owned))
  (findParent [_ mask] ((clojure.core/get m4137 :find-parent) mask))
  (getChild [_ idx] ((clojure.core/get m4137 :get-child) idx))
  (getChildCount [_] ((clojure.core/get m4137 :get-child-count)))
  (getChildren [_] ((clojure.core/get m4137 :get-children)))
  (getCustomMultiplayer
   [_]
   ((clojure.core/get m4137 :get-custom-multiplayer)))
  (getFilename [_] ((clojure.core/get m4137 :get-filename)))
  (getGroups [_] ((clojure.core/get m4137 :get-groups)))
  (getIndex [_] ((clojure.core/get m4137 :get-index)))
  (getMultiplayer [_] ((clojure.core/get m4137 :get-multiplayer)))
  (getName [_] ((clojure.core/get m4137 :get-name)))
  (getNetworkMaster
   [_]
   ((clojure.core/get m4137 :get-network-master)))
  (getNode [_ path] ((clojure.core/get m4137 :get-node) path))
  (getNodeAndResource
   [_ path]
   ((clojure.core/get m4137 :get-node-and-resource) path))
  (getNodeOrNull
   [_ path]
   ((clojure.core/get m4137 :get-node-or-null) path))
  (getOwner [_] ((clojure.core/get m4137 :get-owner)))
  (getParent [_] ((clojure.core/get m4137 :get-parent)))
  (getPath [_] ((clojure.core/get m4137 :get-path)))
  (getPathTo [_ node] ((clojure.core/get m4137 :get-path-to) node))
  (getPauseMode [_] ((clojure.core/get m4137 :get-pause-mode)))
  (getPhysicsProcessDeltaTime
   [_]
   ((clojure.core/get m4137 :get-physics-process-delta-time)))
  (getPositionInParent
   [_]
   ((clojure.core/get m4137 :get-position-in-parent)))
  (getProcessDeltaTime
   [_]
   ((clojure.core/get m4137 :get-process-delta-time)))
  (getProcessPriority
   [_]
   ((clojure.core/get m4137 :get-process-priority)))
  (getSceneInstanceLoadPlaceholder
   [_]
   ((clojure.core/get m4137 :get-scene-instance-load-placeholder)))
  (getTree [_] ((clojure.core/get m4137 :get-tree)))
  (getViewport [_] ((clojure.core/get m4137 :get-viewport)))
  (hasNode [_ path] ((clojure.core/get m4137 :has-node) path))
  (hasNodeAndResource
   [_ path]
   ((clojure.core/get m4137 :has-node-and-resource) path))
  (isAParentOf
   [_ node]
   ((clojure.core/get m4137 :is-a-parent-of) node))
  (isDisplayedFolded
   [_]
   ((clojure.core/get m4137 :is-displayed-folded)))
  (isGreaterThan
   [_ node]
   ((clojure.core/get m4137 :is-greater-than) node))
  (isInGroup [_ group] ((clojure.core/get m4137 :is-in-group) group))
  (isInsideTree [_] ((clojure.core/get m4137 :is-inside-tree)))
  (isNetworkMaster [_] ((clojure.core/get m4137 :is-network-master)))
  (isPhysicsProcessing
   [_]
   ((clojure.core/get m4137 :is-physics-processing)))
  (isPhysicsProcessingInternal
   [_]
   ((clojure.core/get m4137 :is-physics-processing-internal)))
  (isProcessing [_] ((clojure.core/get m4137 :is-processing)))
  (isProcessingInput
   [_]
   ((clojure.core/get m4137 :is-processing-input)))
  (isProcessingInternal
   [_]
   ((clojure.core/get m4137 :is-processing-internal)))
  (isProcessingUnhandledInput
   [_]
   ((clojure.core/get m4137 :is-processing-unhandled-input)))
  (isProcessingUnhandledKeyInput
   [_]
   ((clojure.core/get m4137 :is-processing-unhandled-key-input)))
  (moveChild
   [_ child_node to_position]
   ((clojure.core/get m4137 :move-child) child_node to_position))
  (printStrayNodes [_] ((clojure.core/get m4137 :print-stray-nodes)))
  (printTree [_] ((clojure.core/get m4137 :print-tree)))
  (printTreePretty [_] ((clojure.core/get m4137 :print-tree-pretty)))
  (propagateCall
   [_ method]
   ((clojure.core/get m4137 :propagate-call) method))
  (propagateCall
   [_ method args]
   ((clojure.core/get m4137 :propagate-call) method args))
  (propagateCall
   [_ method args parent_first]
   ((clojure.core/get m4137 :propagate-call) method args parent_first))
  (propagateNotification
   [_ what]
   ((clojure.core/get m4137 :propagate-notification) what))
  (queueFree [_] ((clojure.core/get m4137 :queue-free)))
  (raise [_] ((clojure.core/get m4137 :raise)))
  (removeAndSkip [_] ((clojure.core/get m4137 :remove-and-skip)))
  (removeChild [_ node] ((clojure.core/get m4137 :remove-child) node))
  (removeFromGroup
   [_ group]
   ((clojure.core/get m4137 :remove-from-group) group))
  (replaceBy [_ node] ((clojure.core/get m4137 :replace-by) node))
  (replaceBy
   [_ node keep_data]
   ((clojure.core/get m4137 :replace-by) node keep_data))
  (requestReady [_] ((clojure.core/get m4137 :request-ready)))
  (rpc [_ method] ((clojure.core/get m4137 :rpc) method))
  (rpc [_ method v1] ((clojure.core/get m4137 :rpc) method v1))
  (rpc [_ method v1 v2] ((clojure.core/get m4137 :rpc) method v1 v2))
  (rpc
   [_ method v1 v2 v3]
   ((clojure.core/get m4137 :rpc) method v1 v2 v3))
  (rpc
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4137 :rpc) method v1 v2 v3 v4))
  (rpc
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4137 :rpc) method v1 v2 v3 v4 v5))
  (rpcConfig
   [_ method mode]
   ((clojure.core/get m4137 :rpc-config) method mode))
  (rpcId
   [_ peer_id method]
   ((clojure.core/get m4137 :rpc-id) peer_id method))
  (rpcId
   [_ peer_id method v1]
   ((clojure.core/get m4137 :rpc-id) peer_id method v1))
  (rpcId
   [_ peer_id method v1 v2]
   ((clojure.core/get m4137 :rpc-id) peer_id method v1 v2))
  (rpcId
   [_ peer_id method v1 v2 v3]
   ((clojure.core/get m4137 :rpc-id) peer_id method v1 v2 v3))
  (rpcId
   [_ peer_id method v1 v2 v3 v4]
   ((clojure.core/get m4137 :rpc-id) peer_id method v1 v2 v3 v4))
  (rpcId
   [_ peer_id method v1 v2 v3 v4 v5]
   ((clojure.core/get m4137 :rpc-id) peer_id method v1 v2 v3 v4 v5))
  (rpcUnreliable
   [_ method]
   ((clojure.core/get m4137 :rpc-unreliable) method))
  (rpcUnreliable
   [_ method v1]
   ((clojure.core/get m4137 :rpc-unreliable) method v1))
  (rpcUnreliable
   [_ method v1 v2]
   ((clojure.core/get m4137 :rpc-unreliable) method v1 v2))
  (rpcUnreliable
   [_ method v1 v2 v3]
   ((clojure.core/get m4137 :rpc-unreliable) method v1 v2 v3))
  (rpcUnreliable
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4137 :rpc-unreliable) method v1 v2 v3 v4))
  (rpcUnreliable
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4137 :rpc-unreliable) method v1 v2 v3 v4 v5))
  (rpcUnreliableId
   [_ peer_id method]
   ((clojure.core/get m4137 :rpc-unreliable-id) peer_id method))
  (rpcUnreliableId
   [_ peer_id method v1]
   ((clojure.core/get m4137 :rpc-unreliable-id) peer_id method v1))
  (rpcUnreliableId
   [_ peer_id method v1 v2]
   ((clojure.core/get m4137 :rpc-unreliable-id) peer_id method v1 v2))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3]
   ((clojure.core/get m4137 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3 v4]
   ((clojure.core/get m4137 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3
    v4))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3 v4 v5]
   ((clojure.core/get m4137 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3
    v4
    v5))
  (rset
   [_ property value]
   ((clojure.core/get m4137 :rset) property value))
  (rsetConfig
   [_ property mode]
   ((clojure.core/get m4137 :rset-config) property mode))
  (rsetId
   [_ peer_id property value]
   ((clojure.core/get m4137 :rset-id) peer_id property value))
  (rsetUnreliable
   [_ property value]
   ((clojure.core/get m4137 :rset-unreliable) property value))
  (rsetUnreliableId
   [_ peer_id property value]
   ((clojure.core/get m4137 :rset-unreliable-id)
    peer_id
    property
    value))
  (setCustomMultiplayer
   [_ api]
   ((clojure.core/get m4137 :set-custom-multiplayer) api))
  (setDisplayFolded
   [_ fold]
   ((clojure.core/get m4137 :set-display-folded) fold))
  (setFilename
   [_ filename]
   ((clojure.core/get m4137 :set-filename) filename))
  (setName [_ name] ((clojure.core/get m4137 :set-name) name))
  (setNetworkMaster
   [_ id]
   ((clojure.core/get m4137 :set-network-master) id))
  (setNetworkMaster
   [_ id recursive]
   ((clojure.core/get m4137 :set-network-master) id recursive))
  (setOwner [_ owner] ((clojure.core/get m4137 :set-owner) owner))
  (setPauseMode
   [_ mode]
   ((clojure.core/get m4137 :set-pause-mode) mode))
  (setPhysicsProcess
   [_ enable]
   ((clojure.core/get m4137 :set-physics-process) enable))
  (setPhysicsProcessInternal
   [_ enable]
   ((clojure.core/get m4137 :set-physics-process-internal) enable))
  (setProcess
   [_ enable]
   ((clojure.core/get m4137 :set-process) enable))
  (setProcessInput
   [_ enable]
   ((clojure.core/get m4137 :set-process-input) enable))
  (setProcessInternal
   [_ enable]
   ((clojure.core/get m4137 :set-process-internal) enable))
  (setProcessPriority
   [_ priority]
   ((clojure.core/get m4137 :set-process-priority) priority))
  (setProcessUnhandledInput
   [_ enable]
   ((clojure.core/get m4137 :set-process-unhandled-input) enable))
  (setProcessUnhandledKeyInput
   [_ enable]
   ((clojure.core/get m4137 :set-process-unhandled-key-input) enable))
  (setSceneInstanceLoadPlaceholder
   [_ load_placeholder]
   ((clojure.core/get m4137 :set-scene-instance-load-placeholder)
    load_placeholder))
  (updateConfigurationWarning
   [_]
   ((clojure.core/get m4137 :update-configuration-warning)))
  (forceUpdateTransform
   [_]
   ((clojure.core/get m4137 :force-update-transform)))
  (getGizmo [_] ((clojure.core/get m4137 :get-gizmo)))
  (getGlobalTransform
   [_]
   ((clojure.core/get m4137 :get-global-transform)))
  (getParentSpatial
   [_]
   ((clojure.core/get m4137 :get-parent-spatial)))
  (getRotation [_] ((clojure.core/get m4137 :get-rotation)))
  (getRotationDegrees
   [_]
   ((clojure.core/get m4137 :get-rotation-degrees)))
  (getScale [_] ((clojure.core/get m4137 :get-scale)))
  (getTransform [_] ((clojure.core/get m4137 :get-transform)))
  (getTranslation [_] ((clojure.core/get m4137 :get-translation)))
  (getWorld [_] ((clojure.core/get m4137 :get-world)))
  (globalRotate
   [_ axis angle]
   ((clojure.core/get m4137 :global-rotate) axis angle))
  (globalScale
   [_ scale]
   ((clojure.core/get m4137 :global-scale) scale))
  (globalTranslate
   [_ offset]
   ((clojure.core/get m4137 :global-translate) offset))
  (hide [_] ((clojure.core/get m4137 :hide)))
  (isLocalTransformNotificationEnabled
   [_]
   ((clojure.core/get m4137 :is-local-transform-notification-enabled)))
  (isScaleDisabled [_] ((clojure.core/get m4137 :is-scale-disabled)))
  (isSetAsToplevel [_] ((clojure.core/get m4137 :is-set-as-toplevel)))
  (isTransformNotificationEnabled
   [_]
   ((clojure.core/get m4137 :is-transform-notification-enabled)))
  (isVisible [_] ((clojure.core/get m4137 :is-visible)))
  (isVisibleInTree [_] ((clojure.core/get m4137 :is-visible-in-tree)))
  (lookAt [_ target up] ((clojure.core/get m4137 :look-at) target up))
  (lookAtFromPosition
   [_ position target up]
   ((clojure.core/get m4137 :look-at-from-position)
    position
    target
    up))
  (orthonormalize [_] ((clojure.core/get m4137 :orthonormalize)))
  (rotate
   [_ axis angle]
   ((clojure.core/get m4137 :rotate) axis angle))
  (rotateObjectLocal
   [_ axis angle]
   ((clojure.core/get m4137 :rotate-object-local) axis angle))
  (rotateX [_ angle] ((clojure.core/get m4137 :rotate-x) angle))
  (rotateY [_ angle] ((clojure.core/get m4137 :rotate-y) angle))
  (rotateZ [_ angle] ((clojure.core/get m4137 :rotate-z) angle))
  (scaleObjectLocal
   [_ scale]
   ((clojure.core/get m4137 :scale-object-local) scale))
  (setAsToplevel
   [_ enable]
   ((clojure.core/get m4137 :set-as-toplevel) enable))
  (setDisableScale
   [_ disable]
   ((clojure.core/get m4137 :set-disable-scale) disable))
  (setGizmo [_ gizmo] ((clojure.core/get m4137 :set-gizmo) gizmo))
  (setGlobalTransform
   [_ global]
   ((clojure.core/get m4137 :set-global-transform) global))
  (setIdentity [_] ((clojure.core/get m4137 :set-identity)))
  (setIgnoreTransformNotification
   [_ enabled]
   ((clojure.core/get m4137 :set-ignore-transform-notification)
    enabled))
  (setNotifyLocalTransform
   [_ enable]
   ((clojure.core/get m4137 :set-notify-local-transform) enable))
  (setNotifyTransform
   [_ enable]
   ((clojure.core/get m4137 :set-notify-transform) enable))
  (setRotation
   [_ euler]
   ((clojure.core/get m4137 :set-rotation) euler))
  (setRotationDegrees
   [_ euler_degrees]
   ((clojure.core/get m4137 :set-rotation-degrees) euler_degrees))
  (setScale [_ scale] ((clojure.core/get m4137 :set-scale) scale))
  (setTransform
   [_ local]
   ((clojure.core/get m4137 :set-transform) local))
  (setTranslation
   [_ translation]
   ((clojure.core/get m4137 :set-translation) translation))
  (setVisible
   [_ visible]
   ((clojure.core/get m4137 :set-visible) visible))
  (show [_] ((clojure.core/get m4137 :show)))
  (toGlobal
   [_ local_point]
   ((clojure.core/get m4137 :to-global) local_point))
  (toLocal
   [_ global_point]
   ((clojure.core/get m4137 :to-local) global_point))
  (translate [_ offset] ((clojure.core/get m4137 :translate) offset))
  (translateObjectLocal
   [_ offset]
   ((clojure.core/get m4137 :translate-object-local) offset))
  (updateGizmo [_] ((clojure.core/get m4137 :update-gizmo))))
(deftype GodotSkeleton
  [m4138]
  proto/ToVariant
  (->variant [this] (proto/->variant m4138))
  clojure.lang.ILookup
  (valAt [_ k] (get m4138 k))
  godotclj.api.gdscript.IGodotSkeleton
  (addUserSignal
   [_ signal]
   ((clojure.core/get m4138 :add-user-signal) signal))
  (addUserSignal
   [_ signal arguments]
   ((clojure.core/get m4138 :add-user-signal) signal arguments))
  (call [_ method] ((clojure.core/get m4138 :call) method))
  (call [_ method v1] ((clojure.core/get m4138 :call) method v1))
  (call
   [_ method v1 v2]
   ((clojure.core/get m4138 :call) method v1 v2))
  (call
   [_ method v1 v2 v3]
   ((clojure.core/get m4138 :call) method v1 v2 v3))
  (call
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4138 :call) method v1 v2 v3 v4))
  (call
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4138 :call) method v1 v2 v3 v4 v5))
  (callDeferred
   [_ method]
   ((clojure.core/get m4138 :call-deferred) method))
  (callDeferred
   [_ method v1]
   ((clojure.core/get m4138 :call-deferred) method v1))
  (callDeferred
   [_ method v1 v2]
   ((clojure.core/get m4138 :call-deferred) method v1 v2))
  (callDeferred
   [_ method v1 v2 v3]
   ((clojure.core/get m4138 :call-deferred) method v1 v2 v3))
  (callDeferred
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4138 :call-deferred) method v1 v2 v3 v4))
  (callDeferred
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4138 :call-deferred) method v1 v2 v3 v4 v5))
  (callv
   [_ method arg_array]
   ((clojure.core/get m4138 :callv) method arg_array))
  (canTranslateMessages
   [_]
   ((clojure.core/get m4138 :can-translate-messages)))
  (connect
   [_ signal target method]
   ((clojure.core/get m4138 :connect) signal target method))
  (connect
   [_ signal target method binds]
   ((clojure.core/get m4138 :connect) signal target method binds))
  (connect
   [_ signal target method binds flags]
   ((clojure.core/get m4138 :connect)
    signal
    target
    method
    binds
    flags))
  (disconnect
   [_ signal target method]
   ((clojure.core/get m4138 :disconnect) signal target method))
  (emitSignal
   [_ signal]
   ((clojure.core/get m4138 :emit-signal) signal))
  (emitSignal
   [_ signal v1]
   ((clojure.core/get m4138 :emit-signal) signal v1))
  (emitSignal
   [_ signal v1 v2]
   ((clojure.core/get m4138 :emit-signal) signal v1 v2))
  (emitSignal
   [_ signal v1 v2 v3]
   ((clojure.core/get m4138 :emit-signal) signal v1 v2 v3))
  (emitSignal
   [_ signal v1 v2 v3 v4]
   ((clojure.core/get m4138 :emit-signal) signal v1 v2 v3 v4))
  (emitSignal
   [_ signal v1 v2 v3 v4 v5]
   ((clojure.core/get m4138 :emit-signal) signal v1 v2 v3 v4 v5))
  (free [_] ((clojure.core/get m4138 :free)))
  (get [_ property] ((clojure.core/get m4138 :get) property))
  (getClass [_] ((clojure.core/get m4138 :get-class)))
  (getIncomingConnections
   [_]
   ((clojure.core/get m4138 :get-incoming-connections)))
  (getIndexed
   [_ property]
   ((clojure.core/get m4138 :get-indexed) property))
  (getInstanceId [_] ((clojure.core/get m4138 :get-instance-id)))
  (getMeta [_ name] ((clojure.core/get m4138 :get-meta) name))
  (getMetaList [_] ((clojure.core/get m4138 :get-meta-list)))
  (getMethodList [_] ((clojure.core/get m4138 :get-method-list)))
  (getPropertyList [_] ((clojure.core/get m4138 :get-property-list)))
  (getScript [_] ((clojure.core/get m4138 :get-script)))
  (getSignalConnectionList
   [_ signal]
   ((clojure.core/get m4138 :get-signal-connection-list) signal))
  (getSignalList [_] ((clojure.core/get m4138 :get-signal-list)))
  (hasMeta [_ name] ((clojure.core/get m4138 :has-meta) name))
  (hasMethod [_ method] ((clojure.core/get m4138 :has-method) method))
  (hasSignal [_ signal] ((clojure.core/get m4138 :has-signal) signal))
  (hasUserSignal
   [_ signal]
   ((clojure.core/get m4138 :has-user-signal) signal))
  (isBlockingSignals
   [_]
   ((clojure.core/get m4138 :is-blocking-signals)))
  (isClass [_ class] ((clojure.core/get m4138 :is-class) class))
  (isConnected
   [_ signal target method]
   ((clojure.core/get m4138 :is-connected) signal target method))
  (isQueuedForDeletion
   [_]
   ((clojure.core/get m4138 :is-queued-for-deletion)))
  (notification
   [_ what]
   ((clojure.core/get m4138 :notification) what))
  (notification
   [_ what reversed]
   ((clojure.core/get m4138 :notification) what reversed))
  (propertyListChangedNotify
   [_]
   ((clojure.core/get m4138 :property-list-changed-notify)))
  (removeMeta [_ name] ((clojure.core/get m4138 :remove-meta) name))
  (set
   [_ property value]
   ((clojure.core/get m4138 :set) property value))
  (setBlockSignals
   [_ enable]
   ((clojure.core/get m4138 :set-block-signals) enable))
  (setDeferred
   [_ property value]
   ((clojure.core/get m4138 :set-deferred) property value))
  (setIndexed
   [_ property value]
   ((clojure.core/get m4138 :set-indexed) property value))
  (setMessageTranslation
   [_ enable]
   ((clojure.core/get m4138 :set-message-translation) enable))
  (setMeta
   [_ name value]
   ((clojure.core/get m4138 :set-meta) name value))
  (setScript [_ script] ((clojure.core/get m4138 :set-script) script))
  (tr [_ message] ((clojure.core/get m4138 :tr) message))
  (addChild [_ node] ((clojure.core/get m4138 :add-child) node))
  (addChild
   [_ node legible_unique_name]
   ((clojure.core/get m4138 :add-child) node legible_unique_name))
  (addChildBelowNode
   [_ node child_node]
   ((clojure.core/get m4138 :add-child-below-node) node child_node))
  (addChildBelowNode
   [_ node child_node legible_unique_name]
   ((clojure.core/get m4138 :add-child-below-node)
    node
    child_node
    legible_unique_name))
  (addToGroup
   [_ group]
   ((clojure.core/get m4138 :add-to-group) group))
  (addToGroup
   [_ group persistent]
   ((clojure.core/get m4138 :add-to-group) group persistent))
  (canProcess [_] ((clojure.core/get m4138 :can-process)))
  (duplicate [_] ((clojure.core/get m4138 :duplicate)))
  (duplicate [_ flags] ((clojure.core/get m4138 :duplicate) flags))
  (findNode [_ mask] ((clojure.core/get m4138 :find-node) mask))
  (findNode
   [_ mask recursive]
   ((clojure.core/get m4138 :find-node) mask recursive))
  (findNode
   [_ mask recursive owned]
   ((clojure.core/get m4138 :find-node) mask recursive owned))
  (findParent [_ mask] ((clojure.core/get m4138 :find-parent) mask))
  (getChild [_ idx] ((clojure.core/get m4138 :get-child) idx))
  (getChildCount [_] ((clojure.core/get m4138 :get-child-count)))
  (getChildren [_] ((clojure.core/get m4138 :get-children)))
  (getCustomMultiplayer
   [_]
   ((clojure.core/get m4138 :get-custom-multiplayer)))
  (getFilename [_] ((clojure.core/get m4138 :get-filename)))
  (getGroups [_] ((clojure.core/get m4138 :get-groups)))
  (getIndex [_] ((clojure.core/get m4138 :get-index)))
  (getMultiplayer [_] ((clojure.core/get m4138 :get-multiplayer)))
  (getName [_] ((clojure.core/get m4138 :get-name)))
  (getNetworkMaster
   [_]
   ((clojure.core/get m4138 :get-network-master)))
  (getNode [_ path] ((clojure.core/get m4138 :get-node) path))
  (getNodeAndResource
   [_ path]
   ((clojure.core/get m4138 :get-node-and-resource) path))
  (getNodeOrNull
   [_ path]
   ((clojure.core/get m4138 :get-node-or-null) path))
  (getOwner [_] ((clojure.core/get m4138 :get-owner)))
  (getParent [_] ((clojure.core/get m4138 :get-parent)))
  (getPath [_] ((clojure.core/get m4138 :get-path)))
  (getPathTo [_ node] ((clojure.core/get m4138 :get-path-to) node))
  (getPauseMode [_] ((clojure.core/get m4138 :get-pause-mode)))
  (getPhysicsProcessDeltaTime
   [_]
   ((clojure.core/get m4138 :get-physics-process-delta-time)))
  (getPositionInParent
   [_]
   ((clojure.core/get m4138 :get-position-in-parent)))
  (getProcessDeltaTime
   [_]
   ((clojure.core/get m4138 :get-process-delta-time)))
  (getProcessPriority
   [_]
   ((clojure.core/get m4138 :get-process-priority)))
  (getSceneInstanceLoadPlaceholder
   [_]
   ((clojure.core/get m4138 :get-scene-instance-load-placeholder)))
  (getTree [_] ((clojure.core/get m4138 :get-tree)))
  (getViewport [_] ((clojure.core/get m4138 :get-viewport)))
  (hasNode [_ path] ((clojure.core/get m4138 :has-node) path))
  (hasNodeAndResource
   [_ path]
   ((clojure.core/get m4138 :has-node-and-resource) path))
  (isAParentOf
   [_ node]
   ((clojure.core/get m4138 :is-a-parent-of) node))
  (isDisplayedFolded
   [_]
   ((clojure.core/get m4138 :is-displayed-folded)))
  (isGreaterThan
   [_ node]
   ((clojure.core/get m4138 :is-greater-than) node))
  (isInGroup [_ group] ((clojure.core/get m4138 :is-in-group) group))
  (isInsideTree [_] ((clojure.core/get m4138 :is-inside-tree)))
  (isNetworkMaster [_] ((clojure.core/get m4138 :is-network-master)))
  (isPhysicsProcessing
   [_]
   ((clojure.core/get m4138 :is-physics-processing)))
  (isPhysicsProcessingInternal
   [_]
   ((clojure.core/get m4138 :is-physics-processing-internal)))
  (isProcessing [_] ((clojure.core/get m4138 :is-processing)))
  (isProcessingInput
   [_]
   ((clojure.core/get m4138 :is-processing-input)))
  (isProcessingInternal
   [_]
   ((clojure.core/get m4138 :is-processing-internal)))
  (isProcessingUnhandledInput
   [_]
   ((clojure.core/get m4138 :is-processing-unhandled-input)))
  (isProcessingUnhandledKeyInput
   [_]
   ((clojure.core/get m4138 :is-processing-unhandled-key-input)))
  (moveChild
   [_ child_node to_position]
   ((clojure.core/get m4138 :move-child) child_node to_position))
  (printStrayNodes [_] ((clojure.core/get m4138 :print-stray-nodes)))
  (printTree [_] ((clojure.core/get m4138 :print-tree)))
  (printTreePretty [_] ((clojure.core/get m4138 :print-tree-pretty)))
  (propagateCall
   [_ method]
   ((clojure.core/get m4138 :propagate-call) method))
  (propagateCall
   [_ method args]
   ((clojure.core/get m4138 :propagate-call) method args))
  (propagateCall
   [_ method args parent_first]
   ((clojure.core/get m4138 :propagate-call) method args parent_first))
  (propagateNotification
   [_ what]
   ((clojure.core/get m4138 :propagate-notification) what))
  (queueFree [_] ((clojure.core/get m4138 :queue-free)))
  (raise [_] ((clojure.core/get m4138 :raise)))
  (removeAndSkip [_] ((clojure.core/get m4138 :remove-and-skip)))
  (removeChild [_ node] ((clojure.core/get m4138 :remove-child) node))
  (removeFromGroup
   [_ group]
   ((clojure.core/get m4138 :remove-from-group) group))
  (replaceBy [_ node] ((clojure.core/get m4138 :replace-by) node))
  (replaceBy
   [_ node keep_data]
   ((clojure.core/get m4138 :replace-by) node keep_data))
  (requestReady [_] ((clojure.core/get m4138 :request-ready)))
  (rpc [_ method] ((clojure.core/get m4138 :rpc) method))
  (rpc [_ method v1] ((clojure.core/get m4138 :rpc) method v1))
  (rpc [_ method v1 v2] ((clojure.core/get m4138 :rpc) method v1 v2))
  (rpc
   [_ method v1 v2 v3]
   ((clojure.core/get m4138 :rpc) method v1 v2 v3))
  (rpc
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4138 :rpc) method v1 v2 v3 v4))
  (rpc
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4138 :rpc) method v1 v2 v3 v4 v5))
  (rpcConfig
   [_ method mode]
   ((clojure.core/get m4138 :rpc-config) method mode))
  (rpcId
   [_ peer_id method]
   ((clojure.core/get m4138 :rpc-id) peer_id method))
  (rpcId
   [_ peer_id method v1]
   ((clojure.core/get m4138 :rpc-id) peer_id method v1))
  (rpcId
   [_ peer_id method v1 v2]
   ((clojure.core/get m4138 :rpc-id) peer_id method v1 v2))
  (rpcId
   [_ peer_id method v1 v2 v3]
   ((clojure.core/get m4138 :rpc-id) peer_id method v1 v2 v3))
  (rpcId
   [_ peer_id method v1 v2 v3 v4]
   ((clojure.core/get m4138 :rpc-id) peer_id method v1 v2 v3 v4))
  (rpcId
   [_ peer_id method v1 v2 v3 v4 v5]
   ((clojure.core/get m4138 :rpc-id) peer_id method v1 v2 v3 v4 v5))
  (rpcUnreliable
   [_ method]
   ((clojure.core/get m4138 :rpc-unreliable) method))
  (rpcUnreliable
   [_ method v1]
   ((clojure.core/get m4138 :rpc-unreliable) method v1))
  (rpcUnreliable
   [_ method v1 v2]
   ((clojure.core/get m4138 :rpc-unreliable) method v1 v2))
  (rpcUnreliable
   [_ method v1 v2 v3]
   ((clojure.core/get m4138 :rpc-unreliable) method v1 v2 v3))
  (rpcUnreliable
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4138 :rpc-unreliable) method v1 v2 v3 v4))
  (rpcUnreliable
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4138 :rpc-unreliable) method v1 v2 v3 v4 v5))
  (rpcUnreliableId
   [_ peer_id method]
   ((clojure.core/get m4138 :rpc-unreliable-id) peer_id method))
  (rpcUnreliableId
   [_ peer_id method v1]
   ((clojure.core/get m4138 :rpc-unreliable-id) peer_id method v1))
  (rpcUnreliableId
   [_ peer_id method v1 v2]
   ((clojure.core/get m4138 :rpc-unreliable-id) peer_id method v1 v2))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3]
   ((clojure.core/get m4138 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3 v4]
   ((clojure.core/get m4138 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3
    v4))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3 v4 v5]
   ((clojure.core/get m4138 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3
    v4
    v5))
  (rset
   [_ property value]
   ((clojure.core/get m4138 :rset) property value))
  (rsetConfig
   [_ property mode]
   ((clojure.core/get m4138 :rset-config) property mode))
  (rsetId
   [_ peer_id property value]
   ((clojure.core/get m4138 :rset-id) peer_id property value))
  (rsetUnreliable
   [_ property value]
   ((clojure.core/get m4138 :rset-unreliable) property value))
  (rsetUnreliableId
   [_ peer_id property value]
   ((clojure.core/get m4138 :rset-unreliable-id)
    peer_id
    property
    value))
  (setCustomMultiplayer
   [_ api]
   ((clojure.core/get m4138 :set-custom-multiplayer) api))
  (setDisplayFolded
   [_ fold]
   ((clojure.core/get m4138 :set-display-folded) fold))
  (setFilename
   [_ filename]
   ((clojure.core/get m4138 :set-filename) filename))
  (setName [_ name] ((clojure.core/get m4138 :set-name) name))
  (setNetworkMaster
   [_ id]
   ((clojure.core/get m4138 :set-network-master) id))
  (setNetworkMaster
   [_ id recursive]
   ((clojure.core/get m4138 :set-network-master) id recursive))
  (setOwner [_ owner] ((clojure.core/get m4138 :set-owner) owner))
  (setPauseMode
   [_ mode]
   ((clojure.core/get m4138 :set-pause-mode) mode))
  (setPhysicsProcess
   [_ enable]
   ((clojure.core/get m4138 :set-physics-process) enable))
  (setPhysicsProcessInternal
   [_ enable]
   ((clojure.core/get m4138 :set-physics-process-internal) enable))
  (setProcess
   [_ enable]
   ((clojure.core/get m4138 :set-process) enable))
  (setProcessInput
   [_ enable]
   ((clojure.core/get m4138 :set-process-input) enable))
  (setProcessInternal
   [_ enable]
   ((clojure.core/get m4138 :set-process-internal) enable))
  (setProcessPriority
   [_ priority]
   ((clojure.core/get m4138 :set-process-priority) priority))
  (setProcessUnhandledInput
   [_ enable]
   ((clojure.core/get m4138 :set-process-unhandled-input) enable))
  (setProcessUnhandledKeyInput
   [_ enable]
   ((clojure.core/get m4138 :set-process-unhandled-key-input) enable))
  (setSceneInstanceLoadPlaceholder
   [_ load_placeholder]
   ((clojure.core/get m4138 :set-scene-instance-load-placeholder)
    load_placeholder))
  (updateConfigurationWarning
   [_]
   ((clojure.core/get m4138 :update-configuration-warning)))
  (forceUpdateTransform
   [_]
   ((clojure.core/get m4138 :force-update-transform)))
  (getGizmo [_] ((clojure.core/get m4138 :get-gizmo)))
  (getGlobalTransform
   [_]
   ((clojure.core/get m4138 :get-global-transform)))
  (getParentSpatial
   [_]
   ((clojure.core/get m4138 :get-parent-spatial)))
  (getRotation [_] ((clojure.core/get m4138 :get-rotation)))
  (getRotationDegrees
   [_]
   ((clojure.core/get m4138 :get-rotation-degrees)))
  (getScale [_] ((clojure.core/get m4138 :get-scale)))
  (getTransform [_] ((clojure.core/get m4138 :get-transform)))
  (getTranslation [_] ((clojure.core/get m4138 :get-translation)))
  (getWorld [_] ((clojure.core/get m4138 :get-world)))
  (globalRotate
   [_ axis angle]
   ((clojure.core/get m4138 :global-rotate) axis angle))
  (globalScale
   [_ scale]
   ((clojure.core/get m4138 :global-scale) scale))
  (globalTranslate
   [_ offset]
   ((clojure.core/get m4138 :global-translate) offset))
  (hide [_] ((clojure.core/get m4138 :hide)))
  (isLocalTransformNotificationEnabled
   [_]
   ((clojure.core/get m4138 :is-local-transform-notification-enabled)))
  (isScaleDisabled [_] ((clojure.core/get m4138 :is-scale-disabled)))
  (isSetAsToplevel [_] ((clojure.core/get m4138 :is-set-as-toplevel)))
  (isTransformNotificationEnabled
   [_]
   ((clojure.core/get m4138 :is-transform-notification-enabled)))
  (isVisible [_] ((clojure.core/get m4138 :is-visible)))
  (isVisibleInTree [_] ((clojure.core/get m4138 :is-visible-in-tree)))
  (lookAt [_ target up] ((clojure.core/get m4138 :look-at) target up))
  (lookAtFromPosition
   [_ position target up]
   ((clojure.core/get m4138 :look-at-from-position)
    position
    target
    up))
  (orthonormalize [_] ((clojure.core/get m4138 :orthonormalize)))
  (rotate
   [_ axis angle]
   ((clojure.core/get m4138 :rotate) axis angle))
  (rotateObjectLocal
   [_ axis angle]
   ((clojure.core/get m4138 :rotate-object-local) axis angle))
  (rotateX [_ angle] ((clojure.core/get m4138 :rotate-x) angle))
  (rotateY [_ angle] ((clojure.core/get m4138 :rotate-y) angle))
  (rotateZ [_ angle] ((clojure.core/get m4138 :rotate-z) angle))
  (scaleObjectLocal
   [_ scale]
   ((clojure.core/get m4138 :scale-object-local) scale))
  (setAsToplevel
   [_ enable]
   ((clojure.core/get m4138 :set-as-toplevel) enable))
  (setDisableScale
   [_ disable]
   ((clojure.core/get m4138 :set-disable-scale) disable))
  (setGizmo [_ gizmo] ((clojure.core/get m4138 :set-gizmo) gizmo))
  (setGlobalTransform
   [_ global]
   ((clojure.core/get m4138 :set-global-transform) global))
  (setIdentity [_] ((clojure.core/get m4138 :set-identity)))
  (setIgnoreTransformNotification
   [_ enabled]
   ((clojure.core/get m4138 :set-ignore-transform-notification)
    enabled))
  (setNotifyLocalTransform
   [_ enable]
   ((clojure.core/get m4138 :set-notify-local-transform) enable))
  (setNotifyTransform
   [_ enable]
   ((clojure.core/get m4138 :set-notify-transform) enable))
  (setRotation
   [_ euler]
   ((clojure.core/get m4138 :set-rotation) euler))
  (setRotationDegrees
   [_ euler_degrees]
   ((clojure.core/get m4138 :set-rotation-degrees) euler_degrees))
  (setScale [_ scale] ((clojure.core/get m4138 :set-scale) scale))
  (setTransform
   [_ local]
   ((clojure.core/get m4138 :set-transform) local))
  (setTranslation
   [_ translation]
   ((clojure.core/get m4138 :set-translation) translation))
  (setVisible
   [_ visible]
   ((clojure.core/get m4138 :set-visible) visible))
  (show [_] ((clojure.core/get m4138 :show)))
  (toGlobal
   [_ local_point]
   ((clojure.core/get m4138 :to-global) local_point))
  (toLocal
   [_ global_point]
   ((clojure.core/get m4138 :to-local) global_point))
  (translate [_ offset] ((clojure.core/get m4138 :translate) offset))
  (translateObjectLocal
   [_ offset]
   ((clojure.core/get m4138 :translate-object-local) offset))
  (updateGizmo [_] ((clojure.core/get m4138 :update-gizmo)))
  (addBone [_ name] ((clojure.core/get m4138 :add-bone) name))
  (bindChildNodeToBone
   [_ bone_idx node]
   ((clojure.core/get m4138 :bind-child-node-to-bone) bone_idx node))
  (clearBones [_] ((clojure.core/get m4138 :clear-bones)))
  (clearBonesGlobalPoseOverride
   [_]
   ((clojure.core/get m4138 :clear-bones-global-pose-override)))
  (findBone [_ name] ((clojure.core/get m4138 :find-bone) name))
  (getBoneCount [_] ((clojure.core/get m4138 :get-bone-count)))
  (getBoneCustomPose
   [_ bone_idx]
   ((clojure.core/get m4138 :get-bone-custom-pose) bone_idx))
  (getBoneGlobalPose
   [_ bone_idx]
   ((clojure.core/get m4138 :get-bone-global-pose) bone_idx))
  (getBoneGlobalPoseNoOverride
   [_ bone_idx]
   ((clojure.core/get m4138 :get-bone-global-pose-no-override)
    bone_idx))
  (getBoneName
   [_ bone_idx]
   ((clojure.core/get m4138 :get-bone-name) bone_idx))
  (getBoneParent
   [_ bone_idx]
   ((clojure.core/get m4138 :get-bone-parent) bone_idx))
  (getBonePose
   [_ bone_idx]
   ((clojure.core/get m4138 :get-bone-pose) bone_idx))
  (getBoneRest
   [_ bone_idx]
   ((clojure.core/get m4138 :get-bone-rest) bone_idx))
  (getBoundChildNodesToBone
   [_ bone_idx]
   ((clojure.core/get m4138 :get-bound-child-nodes-to-bone) bone_idx))
  (isBoneRestDisabled
   [_ bone_idx]
   ((clojure.core/get m4138 :is-bone-rest-disabled) bone_idx))
  (localizeRests [_] ((clojure.core/get m4138 :localize-rests)))
  (physicalBonesAddCollisionException
   [_ exception]
   ((clojure.core/get m4138 :physical-bones-add-collision-exception)
    exception))
  (physicalBonesRemoveCollisionException
   [_ exception]
   ((clojure.core/get
     m4138
     :physical-bones-remove-collision-exception)
    exception))
  (physicalBonesStartSimulation
   [_]
   ((clojure.core/get m4138 :physical-bones-start-simulation)))
  (physicalBonesStartSimulation
   [_ bones]
   ((clojure.core/get m4138 :physical-bones-start-simulation) bones))
  (physicalBonesStopSimulation
   [_]
   ((clojure.core/get m4138 :physical-bones-stop-simulation)))
  (registerSkin
   [_ skin]
   ((clojure.core/get m4138 :register-skin) skin))
  (setBoneCustomPose
   [_ bone_idx custom_pose]
   ((clojure.core/get m4138 :set-bone-custom-pose)
    bone_idx
    custom_pose))
  (setBoneDisableRest
   [_ bone_idx disable]
   ((clojure.core/get m4138 :set-bone-disable-rest) bone_idx disable))
  (setBoneGlobalPoseOverride
   [_ bone_idx pose amount]
   ((clojure.core/get m4138 :set-bone-global-pose-override)
    bone_idx
    pose
    amount))
  (setBoneGlobalPoseOverride
   [_ bone_idx pose amount persistent]
   ((clojure.core/get m4138 :set-bone-global-pose-override)
    bone_idx
    pose
    amount
    persistent))
  (setBoneParent
   [_ bone_idx parent_idx]
   ((clojure.core/get m4138 :set-bone-parent) bone_idx parent_idx))
  (setBonePose
   [_ bone_idx pose]
   ((clojure.core/get m4138 :set-bone-pose) bone_idx pose))
  (setBoneRest
   [_ bone_idx rest]
   ((clojure.core/get m4138 :set-bone-rest) bone_idx rest))
  (unbindChildNodeFromBone
   [_ bone_idx node]
   ((clojure.core/get m4138 :unbind-child-node-from-bone)
    bone_idx
    node))
  (unparentBoneAndRest
   [_ bone_idx]
   ((clojure.core/get m4138 :unparent-bone-and-rest) bone_idx)))
(deftype GodotInputEvent
  [m4139]
  proto/ToVariant
  (->variant [this] (proto/->variant m4139))
  clojure.lang.ILookup
  (valAt [_ k] (get m4139 k))
  godotclj.api.gdscript.IGodotInputEvent
  (addUserSignal
   [_ signal]
   ((clojure.core/get m4139 :add-user-signal) signal))
  (addUserSignal
   [_ signal arguments]
   ((clojure.core/get m4139 :add-user-signal) signal arguments))
  (call [_ method] ((clojure.core/get m4139 :call) method))
  (call [_ method v1] ((clojure.core/get m4139 :call) method v1))
  (call
   [_ method v1 v2]
   ((clojure.core/get m4139 :call) method v1 v2))
  (call
   [_ method v1 v2 v3]
   ((clojure.core/get m4139 :call) method v1 v2 v3))
  (call
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4139 :call) method v1 v2 v3 v4))
  (call
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4139 :call) method v1 v2 v3 v4 v5))
  (callDeferred
   [_ method]
   ((clojure.core/get m4139 :call-deferred) method))
  (callDeferred
   [_ method v1]
   ((clojure.core/get m4139 :call-deferred) method v1))
  (callDeferred
   [_ method v1 v2]
   ((clojure.core/get m4139 :call-deferred) method v1 v2))
  (callDeferred
   [_ method v1 v2 v3]
   ((clojure.core/get m4139 :call-deferred) method v1 v2 v3))
  (callDeferred
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4139 :call-deferred) method v1 v2 v3 v4))
  (callDeferred
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4139 :call-deferred) method v1 v2 v3 v4 v5))
  (callv
   [_ method arg_array]
   ((clojure.core/get m4139 :callv) method arg_array))
  (canTranslateMessages
   [_]
   ((clojure.core/get m4139 :can-translate-messages)))
  (connect
   [_ signal target method]
   ((clojure.core/get m4139 :connect) signal target method))
  (connect
   [_ signal target method binds]
   ((clojure.core/get m4139 :connect) signal target method binds))
  (connect
   [_ signal target method binds flags]
   ((clojure.core/get m4139 :connect)
    signal
    target
    method
    binds
    flags))
  (disconnect
   [_ signal target method]
   ((clojure.core/get m4139 :disconnect) signal target method))
  (emitSignal
   [_ signal]
   ((clojure.core/get m4139 :emit-signal) signal))
  (emitSignal
   [_ signal v1]
   ((clojure.core/get m4139 :emit-signal) signal v1))
  (emitSignal
   [_ signal v1 v2]
   ((clojure.core/get m4139 :emit-signal) signal v1 v2))
  (emitSignal
   [_ signal v1 v2 v3]
   ((clojure.core/get m4139 :emit-signal) signal v1 v2 v3))
  (emitSignal
   [_ signal v1 v2 v3 v4]
   ((clojure.core/get m4139 :emit-signal) signal v1 v2 v3 v4))
  (emitSignal
   [_ signal v1 v2 v3 v4 v5]
   ((clojure.core/get m4139 :emit-signal) signal v1 v2 v3 v4 v5))
  (free [_] ((clojure.core/get m4139 :free)))
  (get [_ property] ((clojure.core/get m4139 :get) property))
  (getClass [_] ((clojure.core/get m4139 :get-class)))
  (getIncomingConnections
   [_]
   ((clojure.core/get m4139 :get-incoming-connections)))
  (getIndexed
   [_ property]
   ((clojure.core/get m4139 :get-indexed) property))
  (getInstanceId [_] ((clojure.core/get m4139 :get-instance-id)))
  (getMeta [_ name] ((clojure.core/get m4139 :get-meta) name))
  (getMetaList [_] ((clojure.core/get m4139 :get-meta-list)))
  (getMethodList [_] ((clojure.core/get m4139 :get-method-list)))
  (getPropertyList [_] ((clojure.core/get m4139 :get-property-list)))
  (getScript [_] ((clojure.core/get m4139 :get-script)))
  (getSignalConnectionList
   [_ signal]
   ((clojure.core/get m4139 :get-signal-connection-list) signal))
  (getSignalList [_] ((clojure.core/get m4139 :get-signal-list)))
  (hasMeta [_ name] ((clojure.core/get m4139 :has-meta) name))
  (hasMethod [_ method] ((clojure.core/get m4139 :has-method) method))
  (hasSignal [_ signal] ((clojure.core/get m4139 :has-signal) signal))
  (hasUserSignal
   [_ signal]
   ((clojure.core/get m4139 :has-user-signal) signal))
  (isBlockingSignals
   [_]
   ((clojure.core/get m4139 :is-blocking-signals)))
  (isClass [_ class] ((clojure.core/get m4139 :is-class) class))
  (isConnected
   [_ signal target method]
   ((clojure.core/get m4139 :is-connected) signal target method))
  (isQueuedForDeletion
   [_]
   ((clojure.core/get m4139 :is-queued-for-deletion)))
  (notification
   [_ what]
   ((clojure.core/get m4139 :notification) what))
  (notification
   [_ what reversed]
   ((clojure.core/get m4139 :notification) what reversed))
  (propertyListChangedNotify
   [_]
   ((clojure.core/get m4139 :property-list-changed-notify)))
  (removeMeta [_ name] ((clojure.core/get m4139 :remove-meta) name))
  (set
   [_ property value]
   ((clojure.core/get m4139 :set) property value))
  (setBlockSignals
   [_ enable]
   ((clojure.core/get m4139 :set-block-signals) enable))
  (setDeferred
   [_ property value]
   ((clojure.core/get m4139 :set-deferred) property value))
  (setIndexed
   [_ property value]
   ((clojure.core/get m4139 :set-indexed) property value))
  (setMessageTranslation
   [_ enable]
   ((clojure.core/get m4139 :set-message-translation) enable))
  (setMeta
   [_ name value]
   ((clojure.core/get m4139 :set-meta) name value))
  (setScript [_ script] ((clojure.core/get m4139 :set-script) script))
  (tr [_ message] ((clojure.core/get m4139 :tr) message))
  (initRef [_] ((clojure.core/get m4139 :init-ref)))
  (reference [_] ((clojure.core/get m4139 :reference)))
  (unreference [_] ((clojure.core/get m4139 :unreference)))
  (duplicate [_] ((clojure.core/get m4139 :duplicate)))
  (duplicate
   [_ subresources]
   ((clojure.core/get m4139 :duplicate) subresources))
  (emitChanged [_] ((clojure.core/get m4139 :emit-changed)))
  (getLocalScene [_] ((clojure.core/get m4139 :get-local-scene)))
  (getName [_] ((clojure.core/get m4139 :get-name)))
  (getPath [_] ((clojure.core/get m4139 :get-path)))
  (getRid [_] ((clojure.core/get m4139 :get-rid)))
  (isLocalToScene [_] ((clojure.core/get m4139 :is-local-to-scene)))
  (setLocalToScene
   [_ enable]
   ((clojure.core/get m4139 :set-local-to-scene) enable))
  (setName [_ name] ((clojure.core/get m4139 :set-name) name))
  (setPath [_ path] ((clojure.core/get m4139 :set-path) path))
  (setupLocalToScene
   [_]
   ((clojure.core/get m4139 :setup-local-to-scene)))
  (takeOverPath
   [_ path]
   ((clojure.core/get m4139 :take-over-path) path))
  (accumulate
   [_ with_event]
   ((clojure.core/get m4139 :accumulate) with_event))
  (asText [_] ((clojure.core/get m4139 :as-text)))
  (getActionStrength
   [_ action]
   ((clojure.core/get m4139 :get-action-strength) action))
  (getDevice [_] ((clojure.core/get m4139 :get-device)))
  (isAction [_ action] ((clojure.core/get m4139 :is-action) action))
  (isActionPressed
   [_ action]
   ((clojure.core/get m4139 :is-action-pressed) action))
  (isActionPressed
   [_ action allow_echo]
   ((clojure.core/get m4139 :is-action-pressed) action allow_echo))
  (isActionReleased
   [_ action]
   ((clojure.core/get m4139 :is-action-released) action))
  (isActionType [_] ((clojure.core/get m4139 :is-action-type)))
  (isEcho [_] ((clojure.core/get m4139 :is-echo)))
  (isPressed [_] ((clojure.core/get m4139 :is-pressed)))
  (setDevice [_ device] ((clojure.core/get m4139 :set-device) device))
  (shortcutMatch
   [_ event]
   ((clojure.core/get m4139 :shortcut-match) event))
  (xformedBy [_ xform] ((clojure.core/get m4139 :xformed-by) xform))
  (xformedBy
   [_ xform local_ofs]
   ((clojure.core/get m4139 :xformed-by) xform local_ofs)))
(deftype GodotInputEventJoypadButton
  [m4140]
  proto/ToVariant
  (->variant [this] (proto/->variant m4140))
  clojure.lang.ILookup
  (valAt [_ k] (get m4140 k))
  godotclj.api.gdscript.IGodotInputEventJoypadButton
  (addUserSignal
   [_ signal]
   ((clojure.core/get m4140 :add-user-signal) signal))
  (addUserSignal
   [_ signal arguments]
   ((clojure.core/get m4140 :add-user-signal) signal arguments))
  (call [_ method] ((clojure.core/get m4140 :call) method))
  (call [_ method v1] ((clojure.core/get m4140 :call) method v1))
  (call
   [_ method v1 v2]
   ((clojure.core/get m4140 :call) method v1 v2))
  (call
   [_ method v1 v2 v3]
   ((clojure.core/get m4140 :call) method v1 v2 v3))
  (call
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4140 :call) method v1 v2 v3 v4))
  (call
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4140 :call) method v1 v2 v3 v4 v5))
  (callDeferred
   [_ method]
   ((clojure.core/get m4140 :call-deferred) method))
  (callDeferred
   [_ method v1]
   ((clojure.core/get m4140 :call-deferred) method v1))
  (callDeferred
   [_ method v1 v2]
   ((clojure.core/get m4140 :call-deferred) method v1 v2))
  (callDeferred
   [_ method v1 v2 v3]
   ((clojure.core/get m4140 :call-deferred) method v1 v2 v3))
  (callDeferred
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4140 :call-deferred) method v1 v2 v3 v4))
  (callDeferred
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4140 :call-deferred) method v1 v2 v3 v4 v5))
  (callv
   [_ method arg_array]
   ((clojure.core/get m4140 :callv) method arg_array))
  (canTranslateMessages
   [_]
   ((clojure.core/get m4140 :can-translate-messages)))
  (connect
   [_ signal target method]
   ((clojure.core/get m4140 :connect) signal target method))
  (connect
   [_ signal target method binds]
   ((clojure.core/get m4140 :connect) signal target method binds))
  (connect
   [_ signal target method binds flags]
   ((clojure.core/get m4140 :connect)
    signal
    target
    method
    binds
    flags))
  (disconnect
   [_ signal target method]
   ((clojure.core/get m4140 :disconnect) signal target method))
  (emitSignal
   [_ signal]
   ((clojure.core/get m4140 :emit-signal) signal))
  (emitSignal
   [_ signal v1]
   ((clojure.core/get m4140 :emit-signal) signal v1))
  (emitSignal
   [_ signal v1 v2]
   ((clojure.core/get m4140 :emit-signal) signal v1 v2))
  (emitSignal
   [_ signal v1 v2 v3]
   ((clojure.core/get m4140 :emit-signal) signal v1 v2 v3))
  (emitSignal
   [_ signal v1 v2 v3 v4]
   ((clojure.core/get m4140 :emit-signal) signal v1 v2 v3 v4))
  (emitSignal
   [_ signal v1 v2 v3 v4 v5]
   ((clojure.core/get m4140 :emit-signal) signal v1 v2 v3 v4 v5))
  (free [_] ((clojure.core/get m4140 :free)))
  (get [_ property] ((clojure.core/get m4140 :get) property))
  (getClass [_] ((clojure.core/get m4140 :get-class)))
  (getIncomingConnections
   [_]
   ((clojure.core/get m4140 :get-incoming-connections)))
  (getIndexed
   [_ property]
   ((clojure.core/get m4140 :get-indexed) property))
  (getInstanceId [_] ((clojure.core/get m4140 :get-instance-id)))
  (getMeta [_ name] ((clojure.core/get m4140 :get-meta) name))
  (getMetaList [_] ((clojure.core/get m4140 :get-meta-list)))
  (getMethodList [_] ((clojure.core/get m4140 :get-method-list)))
  (getPropertyList [_] ((clojure.core/get m4140 :get-property-list)))
  (getScript [_] ((clojure.core/get m4140 :get-script)))
  (getSignalConnectionList
   [_ signal]
   ((clojure.core/get m4140 :get-signal-connection-list) signal))
  (getSignalList [_] ((clojure.core/get m4140 :get-signal-list)))
  (hasMeta [_ name] ((clojure.core/get m4140 :has-meta) name))
  (hasMethod [_ method] ((clojure.core/get m4140 :has-method) method))
  (hasSignal [_ signal] ((clojure.core/get m4140 :has-signal) signal))
  (hasUserSignal
   [_ signal]
   ((clojure.core/get m4140 :has-user-signal) signal))
  (isBlockingSignals
   [_]
   ((clojure.core/get m4140 :is-blocking-signals)))
  (isClass [_ class] ((clojure.core/get m4140 :is-class) class))
  (isConnected
   [_ signal target method]
   ((clojure.core/get m4140 :is-connected) signal target method))
  (isQueuedForDeletion
   [_]
   ((clojure.core/get m4140 :is-queued-for-deletion)))
  (notification
   [_ what]
   ((clojure.core/get m4140 :notification) what))
  (notification
   [_ what reversed]
   ((clojure.core/get m4140 :notification) what reversed))
  (propertyListChangedNotify
   [_]
   ((clojure.core/get m4140 :property-list-changed-notify)))
  (removeMeta [_ name] ((clojure.core/get m4140 :remove-meta) name))
  (set
   [_ property value]
   ((clojure.core/get m4140 :set) property value))
  (setBlockSignals
   [_ enable]
   ((clojure.core/get m4140 :set-block-signals) enable))
  (setDeferred
   [_ property value]
   ((clojure.core/get m4140 :set-deferred) property value))
  (setIndexed
   [_ property value]
   ((clojure.core/get m4140 :set-indexed) property value))
  (setMessageTranslation
   [_ enable]
   ((clojure.core/get m4140 :set-message-translation) enable))
  (setMeta
   [_ name value]
   ((clojure.core/get m4140 :set-meta) name value))
  (setScript [_ script] ((clojure.core/get m4140 :set-script) script))
  (tr [_ message] ((clojure.core/get m4140 :tr) message))
  (initRef [_] ((clojure.core/get m4140 :init-ref)))
  (reference [_] ((clojure.core/get m4140 :reference)))
  (unreference [_] ((clojure.core/get m4140 :unreference)))
  (duplicate [_] ((clojure.core/get m4140 :duplicate)))
  (duplicate
   [_ subresources]
   ((clojure.core/get m4140 :duplicate) subresources))
  (emitChanged [_] ((clojure.core/get m4140 :emit-changed)))
  (getLocalScene [_] ((clojure.core/get m4140 :get-local-scene)))
  (getName [_] ((clojure.core/get m4140 :get-name)))
  (getPath [_] ((clojure.core/get m4140 :get-path)))
  (getRid [_] ((clojure.core/get m4140 :get-rid)))
  (isLocalToScene [_] ((clojure.core/get m4140 :is-local-to-scene)))
  (setLocalToScene
   [_ enable]
   ((clojure.core/get m4140 :set-local-to-scene) enable))
  (setName [_ name] ((clojure.core/get m4140 :set-name) name))
  (setPath [_ path] ((clojure.core/get m4140 :set-path) path))
  (setupLocalToScene
   [_]
   ((clojure.core/get m4140 :setup-local-to-scene)))
  (takeOverPath
   [_ path]
   ((clojure.core/get m4140 :take-over-path) path))
  (accumulate
   [_ with_event]
   ((clojure.core/get m4140 :accumulate) with_event))
  (asText [_] ((clojure.core/get m4140 :as-text)))
  (getActionStrength
   [_ action]
   ((clojure.core/get m4140 :get-action-strength) action))
  (getDevice [_] ((clojure.core/get m4140 :get-device)))
  (isAction [_ action] ((clojure.core/get m4140 :is-action) action))
  (isActionPressed
   [_ action]
   ((clojure.core/get m4140 :is-action-pressed) action))
  (isActionPressed
   [_ action allow_echo]
   ((clojure.core/get m4140 :is-action-pressed) action allow_echo))
  (isActionReleased
   [_ action]
   ((clojure.core/get m4140 :is-action-released) action))
  (isActionType [_] ((clojure.core/get m4140 :is-action-type)))
  (isEcho [_] ((clojure.core/get m4140 :is-echo)))
  (isPressed [_] ((clojure.core/get m4140 :is-pressed)))
  (setDevice [_ device] ((clojure.core/get m4140 :set-device) device))
  (shortcutMatch
   [_ event]
   ((clojure.core/get m4140 :shortcut-match) event))
  (xformedBy [_ xform] ((clojure.core/get m4140 :xformed-by) xform))
  (xformedBy
   [_ xform local_ofs]
   ((clojure.core/get m4140 :xformed-by) xform local_ofs))
  (getButtonIndex [_] ((clojure.core/get m4140 :get-button-index)))
  (getPressure [_] ((clojure.core/get m4140 :get-pressure)))
  (setButtonIndex
   [_ button_index]
   ((clojure.core/get m4140 :set-button-index) button_index))
  (setPressed
   [_ pressed]
   ((clojure.core/get m4140 :set-pressed) pressed))
  (setPressure
   [_ pressure]
   ((clojure.core/get m4140 :set-pressure) pressure)))
(deftype GodotPopupMenu
  [m4141]
  proto/ToVariant
  (->variant [this] (proto/->variant m4141))
  clojure.lang.ILookup
  (valAt [_ k] (get m4141 k))
  godotclj.api.gdscript.IGodotPopupMenu
  (addUserSignal
   [_ signal]
   ((clojure.core/get m4141 :add-user-signal) signal))
  (addUserSignal
   [_ signal arguments]
   ((clojure.core/get m4141 :add-user-signal) signal arguments))
  (call [_ method] ((clojure.core/get m4141 :call) method))
  (call [_ method v1] ((clojure.core/get m4141 :call) method v1))
  (call
   [_ method v1 v2]
   ((clojure.core/get m4141 :call) method v1 v2))
  (call
   [_ method v1 v2 v3]
   ((clojure.core/get m4141 :call) method v1 v2 v3))
  (call
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4141 :call) method v1 v2 v3 v4))
  (call
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4141 :call) method v1 v2 v3 v4 v5))
  (callDeferred
   [_ method]
   ((clojure.core/get m4141 :call-deferred) method))
  (callDeferred
   [_ method v1]
   ((clojure.core/get m4141 :call-deferred) method v1))
  (callDeferred
   [_ method v1 v2]
   ((clojure.core/get m4141 :call-deferred) method v1 v2))
  (callDeferred
   [_ method v1 v2 v3]
   ((clojure.core/get m4141 :call-deferred) method v1 v2 v3))
  (callDeferred
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4141 :call-deferred) method v1 v2 v3 v4))
  (callDeferred
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4141 :call-deferred) method v1 v2 v3 v4 v5))
  (callv
   [_ method arg_array]
   ((clojure.core/get m4141 :callv) method arg_array))
  (canTranslateMessages
   [_]
   ((clojure.core/get m4141 :can-translate-messages)))
  (connect
   [_ signal target method]
   ((clojure.core/get m4141 :connect) signal target method))
  (connect
   [_ signal target method binds]
   ((clojure.core/get m4141 :connect) signal target method binds))
  (connect
   [_ signal target method binds flags]
   ((clojure.core/get m4141 :connect)
    signal
    target
    method
    binds
    flags))
  (disconnect
   [_ signal target method]
   ((clojure.core/get m4141 :disconnect) signal target method))
  (emitSignal
   [_ signal]
   ((clojure.core/get m4141 :emit-signal) signal))
  (emitSignal
   [_ signal v1]
   ((clojure.core/get m4141 :emit-signal) signal v1))
  (emitSignal
   [_ signal v1 v2]
   ((clojure.core/get m4141 :emit-signal) signal v1 v2))
  (emitSignal
   [_ signal v1 v2 v3]
   ((clojure.core/get m4141 :emit-signal) signal v1 v2 v3))
  (emitSignal
   [_ signal v1 v2 v3 v4]
   ((clojure.core/get m4141 :emit-signal) signal v1 v2 v3 v4))
  (emitSignal
   [_ signal v1 v2 v3 v4 v5]
   ((clojure.core/get m4141 :emit-signal) signal v1 v2 v3 v4 v5))
  (free [_] ((clojure.core/get m4141 :free)))
  (get [_ property] ((clojure.core/get m4141 :get) property))
  (getClass [_] ((clojure.core/get m4141 :get-class)))
  (getIncomingConnections
   [_]
   ((clojure.core/get m4141 :get-incoming-connections)))
  (getIndexed
   [_ property]
   ((clojure.core/get m4141 :get-indexed) property))
  (getInstanceId [_] ((clojure.core/get m4141 :get-instance-id)))
  (getMeta [_ name] ((clojure.core/get m4141 :get-meta) name))
  (getMetaList [_] ((clojure.core/get m4141 :get-meta-list)))
  (getMethodList [_] ((clojure.core/get m4141 :get-method-list)))
  (getPropertyList [_] ((clojure.core/get m4141 :get-property-list)))
  (getScript [_] ((clojure.core/get m4141 :get-script)))
  (getSignalConnectionList
   [_ signal]
   ((clojure.core/get m4141 :get-signal-connection-list) signal))
  (getSignalList [_] ((clojure.core/get m4141 :get-signal-list)))
  (hasMeta [_ name] ((clojure.core/get m4141 :has-meta) name))
  (hasMethod [_ method] ((clojure.core/get m4141 :has-method) method))
  (hasSignal [_ signal] ((clojure.core/get m4141 :has-signal) signal))
  (hasUserSignal
   [_ signal]
   ((clojure.core/get m4141 :has-user-signal) signal))
  (isBlockingSignals
   [_]
   ((clojure.core/get m4141 :is-blocking-signals)))
  (isClass [_ class] ((clojure.core/get m4141 :is-class) class))
  (isConnected
   [_ signal target method]
   ((clojure.core/get m4141 :is-connected) signal target method))
  (isQueuedForDeletion
   [_]
   ((clojure.core/get m4141 :is-queued-for-deletion)))
  (notification
   [_ what]
   ((clojure.core/get m4141 :notification) what))
  (notification
   [_ what reversed]
   ((clojure.core/get m4141 :notification) what reversed))
  (propertyListChangedNotify
   [_]
   ((clojure.core/get m4141 :property-list-changed-notify)))
  (removeMeta [_ name] ((clojure.core/get m4141 :remove-meta) name))
  (set
   [_ property value]
   ((clojure.core/get m4141 :set) property value))
  (setBlockSignals
   [_ enable]
   ((clojure.core/get m4141 :set-block-signals) enable))
  (setDeferred
   [_ property value]
   ((clojure.core/get m4141 :set-deferred) property value))
  (setIndexed
   [_ property value]
   ((clojure.core/get m4141 :set-indexed) property value))
  (setMessageTranslation
   [_ enable]
   ((clojure.core/get m4141 :set-message-translation) enable))
  (setMeta
   [_ name value]
   ((clojure.core/get m4141 :set-meta) name value))
  (setScript [_ script] ((clojure.core/get m4141 :set-script) script))
  (tr [_ message] ((clojure.core/get m4141 :tr) message))
  (addChild [_ node] ((clojure.core/get m4141 :add-child) node))
  (addChild
   [_ node legible_unique_name]
   ((clojure.core/get m4141 :add-child) node legible_unique_name))
  (addChildBelowNode
   [_ node child_node]
   ((clojure.core/get m4141 :add-child-below-node) node child_node))
  (addChildBelowNode
   [_ node child_node legible_unique_name]
   ((clojure.core/get m4141 :add-child-below-node)
    node
    child_node
    legible_unique_name))
  (addToGroup
   [_ group]
   ((clojure.core/get m4141 :add-to-group) group))
  (addToGroup
   [_ group persistent]
   ((clojure.core/get m4141 :add-to-group) group persistent))
  (canProcess [_] ((clojure.core/get m4141 :can-process)))
  (duplicate [_] ((clojure.core/get m4141 :duplicate)))
  (duplicate [_ flags] ((clojure.core/get m4141 :duplicate) flags))
  (findNode [_ mask] ((clojure.core/get m4141 :find-node) mask))
  (findNode
   [_ mask recursive]
   ((clojure.core/get m4141 :find-node) mask recursive))
  (findNode
   [_ mask recursive owned]
   ((clojure.core/get m4141 :find-node) mask recursive owned))
  (findParent [_ mask] ((clojure.core/get m4141 :find-parent) mask))
  (getChild [_ idx] ((clojure.core/get m4141 :get-child) idx))
  (getChildCount [_] ((clojure.core/get m4141 :get-child-count)))
  (getChildren [_] ((clojure.core/get m4141 :get-children)))
  (getCustomMultiplayer
   [_]
   ((clojure.core/get m4141 :get-custom-multiplayer)))
  (getFilename [_] ((clojure.core/get m4141 :get-filename)))
  (getGroups [_] ((clojure.core/get m4141 :get-groups)))
  (getIndex [_] ((clojure.core/get m4141 :get-index)))
  (getMultiplayer [_] ((clojure.core/get m4141 :get-multiplayer)))
  (getName [_] ((clojure.core/get m4141 :get-name)))
  (getNetworkMaster
   [_]
   ((clojure.core/get m4141 :get-network-master)))
  (getNode [_ path] ((clojure.core/get m4141 :get-node) path))
  (getNodeAndResource
   [_ path]
   ((clojure.core/get m4141 :get-node-and-resource) path))
  (getNodeOrNull
   [_ path]
   ((clojure.core/get m4141 :get-node-or-null) path))
  (getOwner [_] ((clojure.core/get m4141 :get-owner)))
  (getParent [_] ((clojure.core/get m4141 :get-parent)))
  (getPath [_] ((clojure.core/get m4141 :get-path)))
  (getPathTo [_ node] ((clojure.core/get m4141 :get-path-to) node))
  (getPauseMode [_] ((clojure.core/get m4141 :get-pause-mode)))
  (getPhysicsProcessDeltaTime
   [_]
   ((clojure.core/get m4141 :get-physics-process-delta-time)))
  (getPositionInParent
   [_]
   ((clojure.core/get m4141 :get-position-in-parent)))
  (getProcessDeltaTime
   [_]
   ((clojure.core/get m4141 :get-process-delta-time)))
  (getProcessPriority
   [_]
   ((clojure.core/get m4141 :get-process-priority)))
  (getSceneInstanceLoadPlaceholder
   [_]
   ((clojure.core/get m4141 :get-scene-instance-load-placeholder)))
  (getTree [_] ((clojure.core/get m4141 :get-tree)))
  (getViewport [_] ((clojure.core/get m4141 :get-viewport)))
  (hasNode [_ path] ((clojure.core/get m4141 :has-node) path))
  (hasNodeAndResource
   [_ path]
   ((clojure.core/get m4141 :has-node-and-resource) path))
  (isAParentOf
   [_ node]
   ((clojure.core/get m4141 :is-a-parent-of) node))
  (isDisplayedFolded
   [_]
   ((clojure.core/get m4141 :is-displayed-folded)))
  (isGreaterThan
   [_ node]
   ((clojure.core/get m4141 :is-greater-than) node))
  (isInGroup [_ group] ((clojure.core/get m4141 :is-in-group) group))
  (isInsideTree [_] ((clojure.core/get m4141 :is-inside-tree)))
  (isNetworkMaster [_] ((clojure.core/get m4141 :is-network-master)))
  (isPhysicsProcessing
   [_]
   ((clojure.core/get m4141 :is-physics-processing)))
  (isPhysicsProcessingInternal
   [_]
   ((clojure.core/get m4141 :is-physics-processing-internal)))
  (isProcessing [_] ((clojure.core/get m4141 :is-processing)))
  (isProcessingInput
   [_]
   ((clojure.core/get m4141 :is-processing-input)))
  (isProcessingInternal
   [_]
   ((clojure.core/get m4141 :is-processing-internal)))
  (isProcessingUnhandledInput
   [_]
   ((clojure.core/get m4141 :is-processing-unhandled-input)))
  (isProcessingUnhandledKeyInput
   [_]
   ((clojure.core/get m4141 :is-processing-unhandled-key-input)))
  (moveChild
   [_ child_node to_position]
   ((clojure.core/get m4141 :move-child) child_node to_position))
  (printStrayNodes [_] ((clojure.core/get m4141 :print-stray-nodes)))
  (printTree [_] ((clojure.core/get m4141 :print-tree)))
  (printTreePretty [_] ((clojure.core/get m4141 :print-tree-pretty)))
  (propagateCall
   [_ method]
   ((clojure.core/get m4141 :propagate-call) method))
  (propagateCall
   [_ method args]
   ((clojure.core/get m4141 :propagate-call) method args))
  (propagateCall
   [_ method args parent_first]
   ((clojure.core/get m4141 :propagate-call) method args parent_first))
  (propagateNotification
   [_ what]
   ((clojure.core/get m4141 :propagate-notification) what))
  (queueFree [_] ((clojure.core/get m4141 :queue-free)))
  (raise [_] ((clojure.core/get m4141 :raise)))
  (removeAndSkip [_] ((clojure.core/get m4141 :remove-and-skip)))
  (removeChild [_ node] ((clojure.core/get m4141 :remove-child) node))
  (removeFromGroup
   [_ group]
   ((clojure.core/get m4141 :remove-from-group) group))
  (replaceBy [_ node] ((clojure.core/get m4141 :replace-by) node))
  (replaceBy
   [_ node keep_data]
   ((clojure.core/get m4141 :replace-by) node keep_data))
  (requestReady [_] ((clojure.core/get m4141 :request-ready)))
  (rpc [_ method] ((clojure.core/get m4141 :rpc) method))
  (rpc [_ method v1] ((clojure.core/get m4141 :rpc) method v1))
  (rpc [_ method v1 v2] ((clojure.core/get m4141 :rpc) method v1 v2))
  (rpc
   [_ method v1 v2 v3]
   ((clojure.core/get m4141 :rpc) method v1 v2 v3))
  (rpc
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4141 :rpc) method v1 v2 v3 v4))
  (rpc
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4141 :rpc) method v1 v2 v3 v4 v5))
  (rpcConfig
   [_ method mode]
   ((clojure.core/get m4141 :rpc-config) method mode))
  (rpcId
   [_ peer_id method]
   ((clojure.core/get m4141 :rpc-id) peer_id method))
  (rpcId
   [_ peer_id method v1]
   ((clojure.core/get m4141 :rpc-id) peer_id method v1))
  (rpcId
   [_ peer_id method v1 v2]
   ((clojure.core/get m4141 :rpc-id) peer_id method v1 v2))
  (rpcId
   [_ peer_id method v1 v2 v3]
   ((clojure.core/get m4141 :rpc-id) peer_id method v1 v2 v3))
  (rpcId
   [_ peer_id method v1 v2 v3 v4]
   ((clojure.core/get m4141 :rpc-id) peer_id method v1 v2 v3 v4))
  (rpcId
   [_ peer_id method v1 v2 v3 v4 v5]
   ((clojure.core/get m4141 :rpc-id) peer_id method v1 v2 v3 v4 v5))
  (rpcUnreliable
   [_ method]
   ((clojure.core/get m4141 :rpc-unreliable) method))
  (rpcUnreliable
   [_ method v1]
   ((clojure.core/get m4141 :rpc-unreliable) method v1))
  (rpcUnreliable
   [_ method v1 v2]
   ((clojure.core/get m4141 :rpc-unreliable) method v1 v2))
  (rpcUnreliable
   [_ method v1 v2 v3]
   ((clojure.core/get m4141 :rpc-unreliable) method v1 v2 v3))
  (rpcUnreliable
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4141 :rpc-unreliable) method v1 v2 v3 v4))
  (rpcUnreliable
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4141 :rpc-unreliable) method v1 v2 v3 v4 v5))
  (rpcUnreliableId
   [_ peer_id method]
   ((clojure.core/get m4141 :rpc-unreliable-id) peer_id method))
  (rpcUnreliableId
   [_ peer_id method v1]
   ((clojure.core/get m4141 :rpc-unreliable-id) peer_id method v1))
  (rpcUnreliableId
   [_ peer_id method v1 v2]
   ((clojure.core/get m4141 :rpc-unreliable-id) peer_id method v1 v2))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3]
   ((clojure.core/get m4141 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3 v4]
   ((clojure.core/get m4141 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3
    v4))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3 v4 v5]
   ((clojure.core/get m4141 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3
    v4
    v5))
  (rset
   [_ property value]
   ((clojure.core/get m4141 :rset) property value))
  (rsetConfig
   [_ property mode]
   ((clojure.core/get m4141 :rset-config) property mode))
  (rsetId
   [_ peer_id property value]
   ((clojure.core/get m4141 :rset-id) peer_id property value))
  (rsetUnreliable
   [_ property value]
   ((clojure.core/get m4141 :rset-unreliable) property value))
  (rsetUnreliableId
   [_ peer_id property value]
   ((clojure.core/get m4141 :rset-unreliable-id)
    peer_id
    property
    value))
  (setCustomMultiplayer
   [_ api]
   ((clojure.core/get m4141 :set-custom-multiplayer) api))
  (setDisplayFolded
   [_ fold]
   ((clojure.core/get m4141 :set-display-folded) fold))
  (setFilename
   [_ filename]
   ((clojure.core/get m4141 :set-filename) filename))
  (setName [_ name] ((clojure.core/get m4141 :set-name) name))
  (setNetworkMaster
   [_ id]
   ((clojure.core/get m4141 :set-network-master) id))
  (setNetworkMaster
   [_ id recursive]
   ((clojure.core/get m4141 :set-network-master) id recursive))
  (setOwner [_ owner] ((clojure.core/get m4141 :set-owner) owner))
  (setPauseMode
   [_ mode]
   ((clojure.core/get m4141 :set-pause-mode) mode))
  (setPhysicsProcess
   [_ enable]
   ((clojure.core/get m4141 :set-physics-process) enable))
  (setPhysicsProcessInternal
   [_ enable]
   ((clojure.core/get m4141 :set-physics-process-internal) enable))
  (setProcess
   [_ enable]
   ((clojure.core/get m4141 :set-process) enable))
  (setProcessInput
   [_ enable]
   ((clojure.core/get m4141 :set-process-input) enable))
  (setProcessInternal
   [_ enable]
   ((clojure.core/get m4141 :set-process-internal) enable))
  (setProcessPriority
   [_ priority]
   ((clojure.core/get m4141 :set-process-priority) priority))
  (setProcessUnhandledInput
   [_ enable]
   ((clojure.core/get m4141 :set-process-unhandled-input) enable))
  (setProcessUnhandledKeyInput
   [_ enable]
   ((clojure.core/get m4141 :set-process-unhandled-key-input) enable))
  (setSceneInstanceLoadPlaceholder
   [_ load_placeholder]
   ((clojure.core/get m4141 :set-scene-instance-load-placeholder)
    load_placeholder))
  (updateConfigurationWarning
   [_]
   ((clojure.core/get m4141 :update-configuration-warning)))
  (drawArc
   [_ center radius start_angle end_angle point_count color]
   ((clojure.core/get m4141 :draw-arc)
    center
    radius
    start_angle
    end_angle
    point_count
    color))
  (drawArc
   [_ center radius start_angle end_angle point_count color width]
   ((clojure.core/get m4141 :draw-arc)
    center
    radius
    start_angle
    end_angle
    point_count
    color
    width))
  (drawArc
   [_
    center
    radius
    start_angle
    end_angle
    point_count
    color
    width
    antialiased]
   ((clojure.core/get m4141 :draw-arc)
    center
    radius
    start_angle
    end_angle
    point_count
    color
    width
    antialiased))
  (drawChar
   [_ font position char next]
   ((clojure.core/get m4141 :draw-char) font position char next))
  (drawChar
   [_ font position char next modulate]
   ((clojure.core/get m4141 :draw-char)
    font
    position
    char
    next
    modulate))
  (drawCircle
   [_ position radius color]
   ((clojure.core/get m4141 :draw-circle) position radius color))
  (drawColoredPolygon
   [_ points color]
   ((clojure.core/get m4141 :draw-colored-polygon) points color))
  (drawColoredPolygon
   [_ points color uvs]
   ((clojure.core/get m4141 :draw-colored-polygon) points color uvs))
  (drawColoredPolygon
   [_ points color uvs texture]
   ((clojure.core/get m4141 :draw-colored-polygon)
    points
    color
    uvs
    texture))
  (drawColoredPolygon
   [_ points color uvs texture normal_map]
   ((clojure.core/get m4141 :draw-colored-polygon)
    points
    color
    uvs
    texture
    normal_map))
  (drawColoredPolygon
   [_ points color uvs texture normal_map antialiased]
   ((clojure.core/get m4141 :draw-colored-polygon)
    points
    color
    uvs
    texture
    normal_map
    antialiased))
  (drawLine
   [_ from to color]
   ((clojure.core/get m4141 :draw-line) from to color))
  (drawLine
   [_ from to color width]
   ((clojure.core/get m4141 :draw-line) from to color width))
  (drawLine
   [_ from to color width antialiased]
   ((clojure.core/get m4141 :draw-line)
    from
    to
    color
    width
    antialiased))
  (drawMesh
   [_ mesh texture]
   ((clojure.core/get m4141 :draw-mesh) mesh texture))
  (drawMesh
   [_ mesh texture normal_map]
   ((clojure.core/get m4141 :draw-mesh) mesh texture normal_map))
  (drawMesh
   [_ mesh texture normal_map transform]
   ((clojure.core/get m4141 :draw-mesh)
    mesh
    texture
    normal_map
    transform))
  (drawMesh
   [_ mesh texture normal_map transform modulate]
   ((clojure.core/get m4141 :draw-mesh)
    mesh
    texture
    normal_map
    transform
    modulate))
  (drawMultiline
   [_ points color]
   ((clojure.core/get m4141 :draw-multiline) points color))
  (drawMultiline
   [_ points color width]
   ((clojure.core/get m4141 :draw-multiline) points color width))
  (drawMultiline
   [_ points color width antialiased]
   ((clojure.core/get m4141 :draw-multiline)
    points
    color
    width
    antialiased))
  (drawMultilineColors
   [_ points colors]
   ((clojure.core/get m4141 :draw-multiline-colors) points colors))
  (drawMultilineColors
   [_ points colors width]
   ((clojure.core/get m4141 :draw-multiline-colors)
    points
    colors
    width))
  (drawMultilineColors
   [_ points colors width antialiased]
   ((clojure.core/get m4141 :draw-multiline-colors)
    points
    colors
    width
    antialiased))
  (drawMultimesh
   [_ multimesh texture]
   ((clojure.core/get m4141 :draw-multimesh) multimesh texture))
  (drawMultimesh
   [_ multimesh texture normal_map]
   ((clojure.core/get m4141 :draw-multimesh)
    multimesh
    texture
    normal_map))
  (drawPolygon
   [_ points colors]
   ((clojure.core/get m4141 :draw-polygon) points colors))
  (drawPolygon
   [_ points colors uvs]
   ((clojure.core/get m4141 :draw-polygon) points colors uvs))
  (drawPolygon
   [_ points colors uvs texture]
   ((clojure.core/get m4141 :draw-polygon) points colors uvs texture))
  (drawPolygon
   [_ points colors uvs texture normal_map]
   ((clojure.core/get m4141 :draw-polygon)
    points
    colors
    uvs
    texture
    normal_map))
  (drawPolygon
   [_ points colors uvs texture normal_map antialiased]
   ((clojure.core/get m4141 :draw-polygon)
    points
    colors
    uvs
    texture
    normal_map
    antialiased))
  (drawPolyline
   [_ points color]
   ((clojure.core/get m4141 :draw-polyline) points color))
  (drawPolyline
   [_ points color width]
   ((clojure.core/get m4141 :draw-polyline) points color width))
  (drawPolyline
   [_ points color width antialiased]
   ((clojure.core/get m4141 :draw-polyline)
    points
    color
    width
    antialiased))
  (drawPolylineColors
   [_ points colors]
   ((clojure.core/get m4141 :draw-polyline-colors) points colors))
  (drawPolylineColors
   [_ points colors width]
   ((clojure.core/get m4141 :draw-polyline-colors)
    points
    colors
    width))
  (drawPolylineColors
   [_ points colors width antialiased]
   ((clojure.core/get m4141 :draw-polyline-colors)
    points
    colors
    width
    antialiased))
  (drawPrimitive
   [_ points colors uvs]
   ((clojure.core/get m4141 :draw-primitive) points colors uvs))
  (drawPrimitive
   [_ points colors uvs texture]
   ((clojure.core/get m4141 :draw-primitive)
    points
    colors
    uvs
    texture))
  (drawPrimitive
   [_ points colors uvs texture width]
   ((clojure.core/get m4141 :draw-primitive)
    points
    colors
    uvs
    texture
    width))
  (drawPrimitive
   [_ points colors uvs texture width normal_map]
   ((clojure.core/get m4141 :draw-primitive)
    points
    colors
    uvs
    texture
    width
    normal_map))
  (drawRect
   [_ rect color]
   ((clojure.core/get m4141 :draw-rect) rect color))
  (drawRect
   [_ rect color filled]
   ((clojure.core/get m4141 :draw-rect) rect color filled))
  (drawRect
   [_ rect color filled width]
   ((clojure.core/get m4141 :draw-rect) rect color filled width))
  (drawRect
   [_ rect color filled width antialiased]
   ((clojure.core/get m4141 :draw-rect)
    rect
    color
    filled
    width
    antialiased))
  (drawSetTransform
   [_ position rotation scale]
   ((clojure.core/get m4141 :draw-set-transform)
    position
    rotation
    scale))
  (drawSetTransformMatrix
   [_ xform]
   ((clojure.core/get m4141 :draw-set-transform-matrix) xform))
  (drawString
   [_ font position text]
   ((clojure.core/get m4141 :draw-string) font position text))
  (drawString
   [_ font position text modulate]
   ((clojure.core/get m4141 :draw-string) font position text modulate))
  (drawString
   [_ font position text modulate clip_w]
   ((clojure.core/get m4141 :draw-string)
    font
    position
    text
    modulate
    clip_w))
  (drawStyleBox
   [_ style_box rect]
   ((clojure.core/get m4141 :draw-style-box) style_box rect))
  (drawTexture
   [_ texture position]
   ((clojure.core/get m4141 :draw-texture) texture position))
  (drawTexture
   [_ texture position modulate]
   ((clojure.core/get m4141 :draw-texture) texture position modulate))
  (drawTexture
   [_ texture position modulate normal_map]
   ((clojure.core/get m4141 :draw-texture)
    texture
    position
    modulate
    normal_map))
  (drawTextureRect
   [_ texture rect tile]
   ((clojure.core/get m4141 :draw-texture-rect) texture rect tile))
  (drawTextureRect
   [_ texture rect tile modulate]
   ((clojure.core/get m4141 :draw-texture-rect)
    texture
    rect
    tile
    modulate))
  (drawTextureRect
   [_ texture rect tile modulate transpose]
   ((clojure.core/get m4141 :draw-texture-rect)
    texture
    rect
    tile
    modulate
    transpose))
  (drawTextureRect
   [_ texture rect tile modulate transpose normal_map]
   ((clojure.core/get m4141 :draw-texture-rect)
    texture
    rect
    tile
    modulate
    transpose
    normal_map))
  (drawTextureRectRegion
   [_ texture rect src_rect]
   ((clojure.core/get m4141 :draw-texture-rect-region)
    texture
    rect
    src_rect))
  (drawTextureRectRegion
   [_ texture rect src_rect modulate]
   ((clojure.core/get m4141 :draw-texture-rect-region)
    texture
    rect
    src_rect
    modulate))
  (drawTextureRectRegion
   [_ texture rect src_rect modulate transpose]
   ((clojure.core/get m4141 :draw-texture-rect-region)
    texture
    rect
    src_rect
    modulate
    transpose))
  (drawTextureRectRegion
   [_ texture rect src_rect modulate transpose normal_map]
   ((clojure.core/get m4141 :draw-texture-rect-region)
    texture
    rect
    src_rect
    modulate
    transpose
    normal_map))
  (drawTextureRectRegion
   [_ texture rect src_rect modulate transpose normal_map clip_uv]
   ((clojure.core/get m4141 :draw-texture-rect-region)
    texture
    rect
    src_rect
    modulate
    transpose
    normal_map
    clip_uv))
  (forceUpdateTransform
   [_]
   ((clojure.core/get m4141 :force-update-transform)))
  (getCanvas [_] ((clojure.core/get m4141 :get-canvas)))
  (getCanvasItem [_] ((clojure.core/get m4141 :get-canvas-item)))
  (getCanvasTransform
   [_]
   ((clojure.core/get m4141 :get-canvas-transform)))
  (getGlobalMousePosition
   [_]
   ((clojure.core/get m4141 :get-global-mouse-position)))
  (getGlobalTransform
   [_]
   ((clojure.core/get m4141 :get-global-transform)))
  (getGlobalTransformWithCanvas
   [_]
   ((clojure.core/get m4141 :get-global-transform-with-canvas)))
  (getLightMask [_] ((clojure.core/get m4141 :get-light-mask)))
  (getLocalMousePosition
   [_]
   ((clojure.core/get m4141 :get-local-mouse-position)))
  (getMaterial [_] ((clojure.core/get m4141 :get-material)))
  (getModulate [_] ((clojure.core/get m4141 :get-modulate)))
  (getSelfModulate [_] ((clojure.core/get m4141 :get-self-modulate)))
  (getTransform [_] ((clojure.core/get m4141 :get-transform)))
  (getUseParentMaterial
   [_]
   ((clojure.core/get m4141 :get-use-parent-material)))
  (getViewportRect [_] ((clojure.core/get m4141 :get-viewport-rect)))
  (getViewportTransform
   [_]
   ((clojure.core/get m4141 :get-viewport-transform)))
  (getWorld2d [_] ((clojure.core/get m4141 :get-world-2d)))
  (hide [_] ((clojure.core/get m4141 :hide)))
  (isDrawBehindParentEnabled
   [_]
   ((clojure.core/get m4141 :is-draw-behind-parent-enabled)))
  (isLocalTransformNotificationEnabled
   [_]
   ((clojure.core/get m4141 :is-local-transform-notification-enabled)))
  (isSetAsToplevel [_] ((clojure.core/get m4141 :is-set-as-toplevel)))
  (isTransformNotificationEnabled
   [_]
   ((clojure.core/get m4141 :is-transform-notification-enabled)))
  (isVisible [_] ((clojure.core/get m4141 :is-visible)))
  (isVisibleInTree [_] ((clojure.core/get m4141 :is-visible-in-tree)))
  (makeCanvasPositionLocal
   [_ screen_point]
   ((clojure.core/get m4141 :make-canvas-position-local) screen_point))
  (makeInputLocal
   [_ event]
   ((clojure.core/get m4141 :make-input-local) event))
  (setAsToplevel
   [_ enable]
   ((clojure.core/get m4141 :set-as-toplevel) enable))
  (setDrawBehindParent
   [_ enable]
   ((clojure.core/get m4141 :set-draw-behind-parent) enable))
  (setLightMask
   [_ light_mask]
   ((clojure.core/get m4141 :set-light-mask) light_mask))
  (setMaterial
   [_ material]
   ((clojure.core/get m4141 :set-material) material))
  (setModulate
   [_ modulate]
   ((clojure.core/get m4141 :set-modulate) modulate))
  (setNotifyLocalTransform
   [_ enable]
   ((clojure.core/get m4141 :set-notify-local-transform) enable))
  (setNotifyTransform
   [_ enable]
   ((clojure.core/get m4141 :set-notify-transform) enable))
  (setSelfModulate
   [_ self_modulate]
   ((clojure.core/get m4141 :set-self-modulate) self_modulate))
  (setUseParentMaterial
   [_ enable]
   ((clojure.core/get m4141 :set-use-parent-material) enable))
  (setVisible
   [_ visible]
   ((clojure.core/get m4141 :set-visible) visible))
  (show [_] ((clojure.core/get m4141 :show)))
  (update [_] ((clojure.core/get m4141 :update)))
  (acceptEvent [_] ((clojure.core/get m4141 :accept-event)))
  (addColorOverride
   [_ name color]
   ((clojure.core/get m4141 :add-color-override) name color))
  (addConstantOverride
   [_ name constant]
   ((clojure.core/get m4141 :add-constant-override) name constant))
  (addFontOverride
   [_ name font]
   ((clojure.core/get m4141 :add-font-override) name font))
  (addIconOverride
   [_ name texture]
   ((clojure.core/get m4141 :add-icon-override) name texture))
  (addShaderOverride
   [_ name shader]
   ((clojure.core/get m4141 :add-shader-override) name shader))
  (addStyleboxOverride
   [_ name stylebox]
   ((clojure.core/get m4141 :add-stylebox-override) name stylebox))
  (canDropData
   [_ position data]
   ((clojure.core/get m4141 :can-drop-data) position data))
  (dropData
   [_ position data]
   ((clojure.core/get m4141 :drop-data) position data))
  (findNextValidFocus
   [_]
   ((clojure.core/get m4141 :find-next-valid-focus)))
  (findPrevValidFocus
   [_]
   ((clojure.core/get m4141 :find-prev-valid-focus)))
  (forceDrag
   [_ data preview]
   ((clojure.core/get m4141 :force-drag) data preview))
  (getAnchor [_ margin] ((clojure.core/get m4141 :get-anchor) margin))
  (getBegin [_] ((clojure.core/get m4141 :get-begin)))
  (getColor [_ name] ((clojure.core/get m4141 :get-color) name))
  (getColor
   [_ name node_type]
   ((clojure.core/get m4141 :get-color) name node_type))
  (getCombinedMinimumSize
   [_]
   ((clojure.core/get m4141 :get-combined-minimum-size)))
  (getConstant [_ name] ((clojure.core/get m4141 :get-constant) name))
  (getConstant
   [_ name node_type]
   ((clojure.core/get m4141 :get-constant) name node_type))
  (getCursorShape [_] ((clojure.core/get m4141 :get-cursor-shape)))
  (getCursorShape
   [_ position]
   ((clojure.core/get m4141 :get-cursor-shape) position))
  (getCustomMinimumSize
   [_]
   ((clojure.core/get m4141 :get-custom-minimum-size)))
  (getDefaultCursorShape
   [_]
   ((clojure.core/get m4141 :get-default-cursor-shape)))
  (getDragData
   [_ position]
   ((clojure.core/get m4141 :get-drag-data) position))
  (getEnd [_] ((clojure.core/get m4141 :get-end)))
  (getFocusMode [_] ((clojure.core/get m4141 :get-focus-mode)))
  (getFocusNeighbour
   [_ margin]
   ((clojure.core/get m4141 :get-focus-neighbour) margin))
  (getFocusNext [_] ((clojure.core/get m4141 :get-focus-next)))
  (getFocusOwner [_] ((clojure.core/get m4141 :get-focus-owner)))
  (getFocusPrevious
   [_]
   ((clojure.core/get m4141 :get-focus-previous)))
  (getFont [_ name] ((clojure.core/get m4141 :get-font) name))
  (getFont
   [_ name node_type]
   ((clojure.core/get m4141 :get-font) name node_type))
  (getGlobalPosition
   [_]
   ((clojure.core/get m4141 :get-global-position)))
  (getGlobalRect [_] ((clojure.core/get m4141 :get-global-rect)))
  (getHGrowDirection
   [_]
   ((clojure.core/get m4141 :get-h-grow-direction)))
  (getHSizeFlags [_] ((clojure.core/get m4141 :get-h-size-flags)))
  (getIcon [_ name] ((clojure.core/get m4141 :get-icon) name))
  (getIcon
   [_ name node_type]
   ((clojure.core/get m4141 :get-icon) name node_type))
  (getMargin [_ margin] ((clojure.core/get m4141 :get-margin) margin))
  (getMinimumSize [_] ((clojure.core/get m4141 :get-minimum-size)))
  (getMouseFilter [_] ((clojure.core/get m4141 :get-mouse-filter)))
  (getParentAreaSize
   [_]
   ((clojure.core/get m4141 :get-parent-area-size)))
  (getParentControl
   [_]
   ((clojure.core/get m4141 :get-parent-control)))
  (getPassOnModalCloseClick
   [_]
   ((clojure.core/get m4141 :get-pass-on-modal-close-click)))
  (getPivotOffset [_] ((clojure.core/get m4141 :get-pivot-offset)))
  (getPosition [_] ((clojure.core/get m4141 :get-position)))
  (getRect [_] ((clojure.core/get m4141 :get-rect)))
  (getRotation [_] ((clojure.core/get m4141 :get-rotation)))
  (getRotationDegrees
   [_]
   ((clojure.core/get m4141 :get-rotation-degrees)))
  (getScale [_] ((clojure.core/get m4141 :get-scale)))
  (getSize [_] ((clojure.core/get m4141 :get-size)))
  (getStretchRatio [_] ((clojure.core/get m4141 :get-stretch-ratio)))
  (getStylebox [_ name] ((clojure.core/get m4141 :get-stylebox) name))
  (getStylebox
   [_ name node_type]
   ((clojure.core/get m4141 :get-stylebox) name node_type))
  (getTheme [_] ((clojure.core/get m4141 :get-theme)))
  (getTooltip [_] ((clojure.core/get m4141 :get-tooltip)))
  (getTooltip
   [_ at_position]
   ((clojure.core/get m4141 :get-tooltip) at_position))
  (getVGrowDirection
   [_]
   ((clojure.core/get m4141 :get-v-grow-direction)))
  (getVSizeFlags [_] ((clojure.core/get m4141 :get-v-size-flags)))
  (grabClickFocus [_] ((clojure.core/get m4141 :grab-click-focus)))
  (grabFocus [_] ((clojure.core/get m4141 :grab-focus)))
  (hasColor [_ name] ((clojure.core/get m4141 :has-color) name))
  (hasColor
   [_ name node_type]
   ((clojure.core/get m4141 :has-color) name node_type))
  (hasColorOverride
   [_ name]
   ((clojure.core/get m4141 :has-color-override) name))
  (hasConstant [_ name] ((clojure.core/get m4141 :has-constant) name))
  (hasConstant
   [_ name node_type]
   ((clojure.core/get m4141 :has-constant) name node_type))
  (hasConstantOverride
   [_ name]
   ((clojure.core/get m4141 :has-constant-override) name))
  (hasFocus [_] ((clojure.core/get m4141 :has-focus)))
  (hasFont [_ name] ((clojure.core/get m4141 :has-font) name))
  (hasFont
   [_ name node_type]
   ((clojure.core/get m4141 :has-font) name node_type))
  (hasFontOverride
   [_ name]
   ((clojure.core/get m4141 :has-font-override) name))
  (hasIcon [_ name] ((clojure.core/get m4141 :has-icon) name))
  (hasIcon
   [_ name node_type]
   ((clojure.core/get m4141 :has-icon) name node_type))
  (hasIconOverride
   [_ name]
   ((clojure.core/get m4141 :has-icon-override) name))
  (hasPoint [_ point] ((clojure.core/get m4141 :has-point) point))
  (hasShaderOverride
   [_ name]
   ((clojure.core/get m4141 :has-shader-override) name))
  (hasStylebox [_ name] ((clojure.core/get m4141 :has-stylebox) name))
  (hasStylebox
   [_ name node_type]
   ((clojure.core/get m4141 :has-stylebox) name node_type))
  (hasStyleboxOverride
   [_ name]
   ((clojure.core/get m4141 :has-stylebox-override) name))
  (isClippingContents
   [_]
   ((clojure.core/get m4141 :is-clipping-contents)))
  (minimumSizeChanged
   [_]
   ((clojure.core/get m4141 :minimum-size-changed)))
  (releaseFocus [_] ((clojure.core/get m4141 :release-focus)))
  (setAnchor
   [_ margin anchor]
   ((clojure.core/get m4141 :set-anchor) margin anchor))
  (setAnchor
   [_ margin anchor keep_margin]
   ((clojure.core/get m4141 :set-anchor) margin anchor keep_margin))
  (setAnchor
   [_ margin anchor keep_margin push_opposite_anchor]
   ((clojure.core/get m4141 :set-anchor)
    margin
    anchor
    keep_margin
    push_opposite_anchor))
  (setAnchorAndMargin
   [_ margin anchor offset]
   ((clojure.core/get m4141 :set-anchor-and-margin)
    margin
    anchor
    offset))
  (setAnchorAndMargin
   [_ margin anchor offset push_opposite_anchor]
   ((clojure.core/get m4141 :set-anchor-and-margin)
    margin
    anchor
    offset
    push_opposite_anchor))
  (setAnchorsAndMarginsPreset
   [_ preset]
   ((clojure.core/get m4141 :set-anchors-and-margins-preset) preset))
  (setAnchorsAndMarginsPreset
   [_ preset resize_mode]
   ((clojure.core/get m4141 :set-anchors-and-margins-preset)
    preset
    resize_mode))
  (setAnchorsAndMarginsPreset
   [_ preset resize_mode margin]
   ((clojure.core/get m4141 :set-anchors-and-margins-preset)
    preset
    resize_mode
    margin))
  (setAnchorsPreset
   [_ preset]
   ((clojure.core/get m4141 :set-anchors-preset) preset))
  (setAnchorsPreset
   [_ preset keep_margins]
   ((clojure.core/get m4141 :set-anchors-preset) preset keep_margins))
  (setBegin
   [_ position]
   ((clojure.core/get m4141 :set-begin) position))
  (setClipContents
   [_ enable]
   ((clojure.core/get m4141 :set-clip-contents) enable))
  (setCustomMinimumSize
   [_ size]
   ((clojure.core/get m4141 :set-custom-minimum-size) size))
  (setDefaultCursorShape
   [_ shape]
   ((clojure.core/get m4141 :set-default-cursor-shape) shape))
  (setDragForwarding
   [_ target]
   ((clojure.core/get m4141 :set-drag-forwarding) target))
  (setDragPreview
   [_ control]
   ((clojure.core/get m4141 :set-drag-preview) control))
  (setEnd [_ position] ((clojure.core/get m4141 :set-end) position))
  (setFocusMode
   [_ mode]
   ((clojure.core/get m4141 :set-focus-mode) mode))
  (setFocusNeighbour
   [_ margin neighbour]
   ((clojure.core/get m4141 :set-focus-neighbour) margin neighbour))
  (setFocusNext
   [_ next]
   ((clojure.core/get m4141 :set-focus-next) next))
  (setFocusPrevious
   [_ previous]
   ((clojure.core/get m4141 :set-focus-previous) previous))
  (setGlobalPosition
   [_ position]
   ((clojure.core/get m4141 :set-global-position) position))
  (setGlobalPosition
   [_ position keep_margins]
   ((clojure.core/get m4141 :set-global-position)
    position
    keep_margins))
  (setHGrowDirection
   [_ direction]
   ((clojure.core/get m4141 :set-h-grow-direction) direction))
  (setHSizeFlags
   [_ flags]
   ((clojure.core/get m4141 :set-h-size-flags) flags))
  (setMargin
   [_ margin offset]
   ((clojure.core/get m4141 :set-margin) margin offset))
  (setMarginsPreset
   [_ preset]
   ((clojure.core/get m4141 :set-margins-preset) preset))
  (setMarginsPreset
   [_ preset resize_mode]
   ((clojure.core/get m4141 :set-margins-preset) preset resize_mode))
  (setMarginsPreset
   [_ preset resize_mode margin]
   ((clojure.core/get m4141 :set-margins-preset)
    preset
    resize_mode
    margin))
  (setMouseFilter
   [_ filter]
   ((clojure.core/get m4141 :set-mouse-filter) filter))
  (setPassOnModalCloseClick
   [_ enabled]
   ((clojure.core/get m4141 :set-pass-on-modal-close-click) enabled))
  (setPivotOffset
   [_ pivot_offset]
   ((clojure.core/get m4141 :set-pivot-offset) pivot_offset))
  (setPosition
   [_ position]
   ((clojure.core/get m4141 :set-position) position))
  (setPosition
   [_ position keep_margins]
   ((clojure.core/get m4141 :set-position) position keep_margins))
  (setRotation
   [_ radians]
   ((clojure.core/get m4141 :set-rotation) radians))
  (setRotationDegrees
   [_ degrees]
   ((clojure.core/get m4141 :set-rotation-degrees) degrees))
  (setScale [_ scale] ((clojure.core/get m4141 :set-scale) scale))
  (setSize [_ size] ((clojure.core/get m4141 :set-size) size))
  (setSize
   [_ size keep_margins]
   ((clojure.core/get m4141 :set-size) size keep_margins))
  (setStretchRatio
   [_ ratio]
   ((clojure.core/get m4141 :set-stretch-ratio) ratio))
  (setTheme [_ theme] ((clojure.core/get m4141 :set-theme) theme))
  (setTooltip
   [_ tooltip]
   ((clojure.core/get m4141 :set-tooltip) tooltip))
  (setVGrowDirection
   [_ direction]
   ((clojure.core/get m4141 :set-v-grow-direction) direction))
  (setVSizeFlags
   [_ flags]
   ((clojure.core/get m4141 :set-v-size-flags) flags))
  (showModal [_] ((clojure.core/get m4141 :show-modal)))
  (showModal
   [_ exclusive]
   ((clojure.core/get m4141 :show-modal) exclusive))
  (warpMouse
   [_ to_position]
   ((clojure.core/get m4141 :warp-mouse) to_position))
  (isExclusive [_] ((clojure.core/get m4141 :is-exclusive)))
  (popup [_] ((clojure.core/get m4141 :popup)))
  (popup [_ bounds] ((clojure.core/get m4141 :popup) bounds))
  (popupCentered [_] ((clojure.core/get m4141 :popup-centered)))
  (popupCentered
   [_ size]
   ((clojure.core/get m4141 :popup-centered) size))
  (popupCenteredClamped
   [_]
   ((clojure.core/get m4141 :popup-centered-clamped)))
  (popupCenteredClamped
   [_ size]
   ((clojure.core/get m4141 :popup-centered-clamped) size))
  (popupCenteredClamped
   [_ size fallback_ratio]
   ((clojure.core/get m4141 :popup-centered-clamped)
    size
    fallback_ratio))
  (popupCenteredMinsize
   [_]
   ((clojure.core/get m4141 :popup-centered-minsize)))
  (popupCenteredMinsize
   [_ minsize]
   ((clojure.core/get m4141 :popup-centered-minsize) minsize))
  (popupCenteredRatio
   [_]
   ((clojure.core/get m4141 :popup-centered-ratio)))
  (popupCenteredRatio
   [_ ratio]
   ((clojure.core/get m4141 :popup-centered-ratio) ratio))
  (setAsMinsize [_] ((clojure.core/get m4141 :set-as-minsize)))
  (setExclusive
   [_ enable]
   ((clojure.core/get m4141 :set-exclusive) enable))
  (addCheckItem
   [_ label]
   ((clojure.core/get m4141 :add-check-item) label))
  (addCheckItem
   [_ label id]
   ((clojure.core/get m4141 :add-check-item) label id))
  (addCheckItem
   [_ label id accel]
   ((clojure.core/get m4141 :add-check-item) label id accel))
  (addCheckShortcut
   [_ shortcut]
   ((clojure.core/get m4141 :add-check-shortcut) shortcut))
  (addCheckShortcut
   [_ shortcut id]
   ((clojure.core/get m4141 :add-check-shortcut) shortcut id))
  (addCheckShortcut
   [_ shortcut id global]
   ((clojure.core/get m4141 :add-check-shortcut) shortcut id global))
  (addIconCheckItem
   [_ texture label]
   ((clojure.core/get m4141 :add-icon-check-item) texture label))
  (addIconCheckItem
   [_ texture label id]
   ((clojure.core/get m4141 :add-icon-check-item) texture label id))
  (addIconCheckItem
   [_ texture label id accel]
   ((clojure.core/get m4141 :add-icon-check-item)
    texture
    label
    id
    accel))
  (addIconCheckShortcut
   [_ texture shortcut]
   ((clojure.core/get m4141 :add-icon-check-shortcut)
    texture
    shortcut))
  (addIconCheckShortcut
   [_ texture shortcut id]
   ((clojure.core/get m4141 :add-icon-check-shortcut)
    texture
    shortcut
    id))
  (addIconCheckShortcut
   [_ texture shortcut id global]
   ((clojure.core/get m4141 :add-icon-check-shortcut)
    texture
    shortcut
    id
    global))
  (addIconItem
   [_ texture label]
   ((clojure.core/get m4141 :add-icon-item) texture label))
  (addIconItem
   [_ texture label id]
   ((clojure.core/get m4141 :add-icon-item) texture label id))
  (addIconItem
   [_ texture label id accel]
   ((clojure.core/get m4141 :add-icon-item) texture label id accel))
  (addIconRadioCheckItem
   [_ texture label]
   ((clojure.core/get m4141 :add-icon-radio-check-item) texture label))
  (addIconRadioCheckItem
   [_ texture label id]
   ((clojure.core/get m4141 :add-icon-radio-check-item)
    texture
    label
    id))
  (addIconRadioCheckItem
   [_ texture label id accel]
   ((clojure.core/get m4141 :add-icon-radio-check-item)
    texture
    label
    id
    accel))
  (addIconRadioCheckShortcut
   [_ texture shortcut]
   ((clojure.core/get m4141 :add-icon-radio-check-shortcut)
    texture
    shortcut))
  (addIconRadioCheckShortcut
   [_ texture shortcut id]
   ((clojure.core/get m4141 :add-icon-radio-check-shortcut)
    texture
    shortcut
    id))
  (addIconRadioCheckShortcut
   [_ texture shortcut id global]
   ((clojure.core/get m4141 :add-icon-radio-check-shortcut)
    texture
    shortcut
    id
    global))
  (addIconShortcut
   [_ texture shortcut]
   ((clojure.core/get m4141 :add-icon-shortcut) texture shortcut))
  (addIconShortcut
   [_ texture shortcut id]
   ((clojure.core/get m4141 :add-icon-shortcut) texture shortcut id))
  (addIconShortcut
   [_ texture shortcut id global]
   ((clojure.core/get m4141 :add-icon-shortcut)
    texture
    shortcut
    id
    global))
  (addItem [_ label] ((clojure.core/get m4141 :add-item) label))
  (addItem [_ label id] ((clojure.core/get m4141 :add-item) label id))
  (addItem
   [_ label id accel]
   ((clojure.core/get m4141 :add-item) label id accel))
  (addMultistateItem
   [_ label max_states]
   ((clojure.core/get m4141 :add-multistate-item) label max_states))
  (addMultistateItem
   [_ label max_states default_state]
   ((clojure.core/get m4141 :add-multistate-item)
    label
    max_states
    default_state))
  (addMultistateItem
   [_ label max_states default_state id]
   ((clojure.core/get m4141 :add-multistate-item)
    label
    max_states
    default_state
    id))
  (addMultistateItem
   [_ label max_states default_state id accel]
   ((clojure.core/get m4141 :add-multistate-item)
    label
    max_states
    default_state
    id
    accel))
  (addRadioCheckItem
   [_ label]
   ((clojure.core/get m4141 :add-radio-check-item) label))
  (addRadioCheckItem
   [_ label id]
   ((clojure.core/get m4141 :add-radio-check-item) label id))
  (addRadioCheckItem
   [_ label id accel]
   ((clojure.core/get m4141 :add-radio-check-item) label id accel))
  (addRadioCheckShortcut
   [_ shortcut]
   ((clojure.core/get m4141 :add-radio-check-shortcut) shortcut))
  (addRadioCheckShortcut
   [_ shortcut id]
   ((clojure.core/get m4141 :add-radio-check-shortcut) shortcut id))
  (addRadioCheckShortcut
   [_ shortcut id global]
   ((clojure.core/get m4141 :add-radio-check-shortcut)
    shortcut
    id
    global))
  (addSeparator [_] ((clojure.core/get m4141 :add-separator)))
  (addSeparator
   [_ label]
   ((clojure.core/get m4141 :add-separator) label))
  (addSeparator
   [_ label id]
   ((clojure.core/get m4141 :add-separator) label id))
  (addShortcut
   [_ shortcut]
   ((clojure.core/get m4141 :add-shortcut) shortcut))
  (addShortcut
   [_ shortcut id]
   ((clojure.core/get m4141 :add-shortcut) shortcut id))
  (addShortcut
   [_ shortcut id global]
   ((clojure.core/get m4141 :add-shortcut) shortcut id global))
  (addSubmenuItem
   [_ label submenu]
   ((clojure.core/get m4141 :add-submenu-item) label submenu))
  (addSubmenuItem
   [_ label submenu id]
   ((clojure.core/get m4141 :add-submenu-item) label submenu id))
  (clear [_] ((clojure.core/get m4141 :clear)))
  (getAllowSearch [_] ((clojure.core/get m4141 :get-allow-search)))
  (getCurrentIndex [_] ((clojure.core/get m4141 :get-current-index)))
  (getItemAccelerator
   [_ idx]
   ((clojure.core/get m4141 :get-item-accelerator) idx))
  (getItemCount [_] ((clojure.core/get m4141 :get-item-count)))
  (getItemIcon [_ idx] ((clojure.core/get m4141 :get-item-icon) idx))
  (getItemId [_ idx] ((clojure.core/get m4141 :get-item-id) idx))
  (getItemIndex [_ id] ((clojure.core/get m4141 :get-item-index) id))
  (getItemMetadata
   [_ idx]
   ((clojure.core/get m4141 :get-item-metadata) idx))
  (getItemShortcut
   [_ idx]
   ((clojure.core/get m4141 :get-item-shortcut) idx))
  (getItemSubmenu
   [_ idx]
   ((clojure.core/get m4141 :get-item-submenu) idx))
  (getItemText [_ idx] ((clojure.core/get m4141 :get-item-text) idx))
  (getItemTooltip
   [_ idx]
   ((clojure.core/get m4141 :get-item-tooltip) idx))
  (getSubmenuPopupDelay
   [_]
   ((clojure.core/get m4141 :get-submenu-popup-delay)))
  (isHideOnCheckableItemSelection
   [_]
   ((clojure.core/get m4141 :is-hide-on-checkable-item-selection)))
  (isHideOnItemSelection
   [_]
   ((clojure.core/get m4141 :is-hide-on-item-selection)))
  (isHideOnStateItemSelection
   [_]
   ((clojure.core/get m4141 :is-hide-on-state-item-selection)))
  (isHideOnWindowLoseFocus
   [_]
   ((clojure.core/get m4141 :is-hide-on-window-lose-focus)))
  (isItemCheckable
   [_ idx]
   ((clojure.core/get m4141 :is-item-checkable) idx))
  (isItemChecked
   [_ idx]
   ((clojure.core/get m4141 :is-item-checked) idx))
  (isItemDisabled
   [_ idx]
   ((clojure.core/get m4141 :is-item-disabled) idx))
  (isItemRadioCheckable
   [_ idx]
   ((clojure.core/get m4141 :is-item-radio-checkable) idx))
  (isItemSeparator
   [_ idx]
   ((clojure.core/get m4141 :is-item-separator) idx))
  (isItemShortcutDisabled
   [_ idx]
   ((clojure.core/get m4141 :is-item-shortcut-disabled) idx))
  (removeItem [_ idx] ((clojure.core/get m4141 :remove-item) idx))
  (setAllowSearch
   [_ allow]
   ((clojure.core/get m4141 :set-allow-search) allow))
  (setHideOnCheckableItemSelection
   [_ enable]
   ((clojure.core/get m4141 :set-hide-on-checkable-item-selection)
    enable))
  (setHideOnItemSelection
   [_ enable]
   ((clojure.core/get m4141 :set-hide-on-item-selection) enable))
  (setHideOnStateItemSelection
   [_ enable]
   ((clojure.core/get m4141 :set-hide-on-state-item-selection) enable))
  (setHideOnWindowLoseFocus
   [_ enable]
   ((clojure.core/get m4141 :set-hide-on-window-lose-focus) enable))
  (setItemAccelerator
   [_ idx accel]
   ((clojure.core/get m4141 :set-item-accelerator) idx accel))
  (setItemAsCheckable
   [_ idx enable]
   ((clojure.core/get m4141 :set-item-as-checkable) idx enable))
  (setItemAsRadioCheckable
   [_ idx enable]
   ((clojure.core/get m4141 :set-item-as-radio-checkable) idx enable))
  (setItemAsSeparator
   [_ idx enable]
   ((clojure.core/get m4141 :set-item-as-separator) idx enable))
  (setItemChecked
   [_ idx checked]
   ((clojure.core/get m4141 :set-item-checked) idx checked))
  (setItemDisabled
   [_ idx disabled]
   ((clojure.core/get m4141 :set-item-disabled) idx disabled))
  (setItemIcon
   [_ idx icon]
   ((clojure.core/get m4141 :set-item-icon) idx icon))
  (setItemId
   [_ idx id]
   ((clojure.core/get m4141 :set-item-id) idx id))
  (setItemMetadata
   [_ idx metadata]
   ((clojure.core/get m4141 :set-item-metadata) idx metadata))
  (setItemMultistate
   [_ idx state]
   ((clojure.core/get m4141 :set-item-multistate) idx state))
  (setItemShortcut
   [_ idx shortcut]
   ((clojure.core/get m4141 :set-item-shortcut) idx shortcut))
  (setItemShortcut
   [_ idx shortcut global]
   ((clojure.core/get m4141 :set-item-shortcut) idx shortcut global))
  (setItemShortcutDisabled
   [_ idx disabled]
   ((clojure.core/get m4141 :set-item-shortcut-disabled) idx disabled))
  (setItemSubmenu
   [_ idx submenu]
   ((clojure.core/get m4141 :set-item-submenu) idx submenu))
  (setItemText
   [_ idx text]
   ((clojure.core/get m4141 :set-item-text) idx text))
  (setItemTooltip
   [_ idx tooltip]
   ((clojure.core/get m4141 :set-item-tooltip) idx tooltip))
  (setSubmenuPopupDelay
   [_ seconds]
   ((clojure.core/get m4141 :set-submenu-popup-delay) seconds))
  (toggleItemChecked
   [_ idx]
   ((clojure.core/get m4141 :toggle-item-checked) idx))
  (toggleItemMultistate
   [_ idx]
   ((clojure.core/get m4141 :toggle-item-multistate) idx)))
(deftype GodotConfigFile
  [m4142]
  proto/ToVariant
  (->variant [this] (proto/->variant m4142))
  clojure.lang.ILookup
  (valAt [_ k] (get m4142 k))
  godotclj.api.gdscript.IGodotConfigFile
  (addUserSignal
   [_ signal]
   ((clojure.core/get m4142 :add-user-signal) signal))
  (addUserSignal
   [_ signal arguments]
   ((clojure.core/get m4142 :add-user-signal) signal arguments))
  (call [_ method] ((clojure.core/get m4142 :call) method))
  (call [_ method v1] ((clojure.core/get m4142 :call) method v1))
  (call
   [_ method v1 v2]
   ((clojure.core/get m4142 :call) method v1 v2))
  (call
   [_ method v1 v2 v3]
   ((clojure.core/get m4142 :call) method v1 v2 v3))
  (call
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4142 :call) method v1 v2 v3 v4))
  (call
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4142 :call) method v1 v2 v3 v4 v5))
  (callDeferred
   [_ method]
   ((clojure.core/get m4142 :call-deferred) method))
  (callDeferred
   [_ method v1]
   ((clojure.core/get m4142 :call-deferred) method v1))
  (callDeferred
   [_ method v1 v2]
   ((clojure.core/get m4142 :call-deferred) method v1 v2))
  (callDeferred
   [_ method v1 v2 v3]
   ((clojure.core/get m4142 :call-deferred) method v1 v2 v3))
  (callDeferred
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4142 :call-deferred) method v1 v2 v3 v4))
  (callDeferred
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4142 :call-deferred) method v1 v2 v3 v4 v5))
  (callv
   [_ method arg_array]
   ((clojure.core/get m4142 :callv) method arg_array))
  (canTranslateMessages
   [_]
   ((clojure.core/get m4142 :can-translate-messages)))
  (connect
   [_ signal target method]
   ((clojure.core/get m4142 :connect) signal target method))
  (connect
   [_ signal target method binds]
   ((clojure.core/get m4142 :connect) signal target method binds))
  (connect
   [_ signal target method binds flags]
   ((clojure.core/get m4142 :connect)
    signal
    target
    method
    binds
    flags))
  (disconnect
   [_ signal target method]
   ((clojure.core/get m4142 :disconnect) signal target method))
  (emitSignal
   [_ signal]
   ((clojure.core/get m4142 :emit-signal) signal))
  (emitSignal
   [_ signal v1]
   ((clojure.core/get m4142 :emit-signal) signal v1))
  (emitSignal
   [_ signal v1 v2]
   ((clojure.core/get m4142 :emit-signal) signal v1 v2))
  (emitSignal
   [_ signal v1 v2 v3]
   ((clojure.core/get m4142 :emit-signal) signal v1 v2 v3))
  (emitSignal
   [_ signal v1 v2 v3 v4]
   ((clojure.core/get m4142 :emit-signal) signal v1 v2 v3 v4))
  (emitSignal
   [_ signal v1 v2 v3 v4 v5]
   ((clojure.core/get m4142 :emit-signal) signal v1 v2 v3 v4 v5))
  (free [_] ((clojure.core/get m4142 :free)))
  (get [_ property] ((clojure.core/get m4142 :get) property))
  (getClass [_] ((clojure.core/get m4142 :get-class)))
  (getIncomingConnections
   [_]
   ((clojure.core/get m4142 :get-incoming-connections)))
  (getIndexed
   [_ property]
   ((clojure.core/get m4142 :get-indexed) property))
  (getInstanceId [_] ((clojure.core/get m4142 :get-instance-id)))
  (getMeta [_ name] ((clojure.core/get m4142 :get-meta) name))
  (getMetaList [_] ((clojure.core/get m4142 :get-meta-list)))
  (getMethodList [_] ((clojure.core/get m4142 :get-method-list)))
  (getPropertyList [_] ((clojure.core/get m4142 :get-property-list)))
  (getScript [_] ((clojure.core/get m4142 :get-script)))
  (getSignalConnectionList
   [_ signal]
   ((clojure.core/get m4142 :get-signal-connection-list) signal))
  (getSignalList [_] ((clojure.core/get m4142 :get-signal-list)))
  (hasMeta [_ name] ((clojure.core/get m4142 :has-meta) name))
  (hasMethod [_ method] ((clojure.core/get m4142 :has-method) method))
  (hasSignal [_ signal] ((clojure.core/get m4142 :has-signal) signal))
  (hasUserSignal
   [_ signal]
   ((clojure.core/get m4142 :has-user-signal) signal))
  (isBlockingSignals
   [_]
   ((clojure.core/get m4142 :is-blocking-signals)))
  (isClass [_ class] ((clojure.core/get m4142 :is-class) class))
  (isConnected
   [_ signal target method]
   ((clojure.core/get m4142 :is-connected) signal target method))
  (isQueuedForDeletion
   [_]
   ((clojure.core/get m4142 :is-queued-for-deletion)))
  (notification
   [_ what]
   ((clojure.core/get m4142 :notification) what))
  (notification
   [_ what reversed]
   ((clojure.core/get m4142 :notification) what reversed))
  (propertyListChangedNotify
   [_]
   ((clojure.core/get m4142 :property-list-changed-notify)))
  (removeMeta [_ name] ((clojure.core/get m4142 :remove-meta) name))
  (set
   [_ property value]
   ((clojure.core/get m4142 :set) property value))
  (setBlockSignals
   [_ enable]
   ((clojure.core/get m4142 :set-block-signals) enable))
  (setDeferred
   [_ property value]
   ((clojure.core/get m4142 :set-deferred) property value))
  (setIndexed
   [_ property value]
   ((clojure.core/get m4142 :set-indexed) property value))
  (setMessageTranslation
   [_ enable]
   ((clojure.core/get m4142 :set-message-translation) enable))
  (setMeta
   [_ name value]
   ((clojure.core/get m4142 :set-meta) name value))
  (setScript [_ script] ((clojure.core/get m4142 :set-script) script))
  (tr [_ message] ((clojure.core/get m4142 :tr) message))
  (initRef [_] ((clojure.core/get m4142 :init-ref)))
  (reference [_] ((clojure.core/get m4142 :reference)))
  (unreference [_] ((clojure.core/get m4142 :unreference)))
  (clear [_] ((clojure.core/get m4142 :clear)))
  (eraseSection
   [_ section]
   ((clojure.core/get m4142 :erase-section) section))
  (eraseSectionKey
   [_ section key]
   ((clojure.core/get m4142 :erase-section-key) section key))
  (getSectionKeys
   [_ section]
   ((clojure.core/get m4142 :get-section-keys) section))
  (getSections [_] ((clojure.core/get m4142 :get-sections)))
  (getValue
   [_ section key]
   ((clojure.core/get m4142 :get-value) section key))
  (getValue
   [_ section key default]
   ((clojure.core/get m4142 :get-value) section key default))
  (hasSection
   [_ section]
   ((clojure.core/get m4142 :has-section) section))
  (hasSectionKey
   [_ section key]
   ((clojure.core/get m4142 :has-section-key) section key))
  (load [_ path] ((clojure.core/get m4142 :load) path))
  (loadEncrypted
   [_ path key]
   ((clojure.core/get m4142 :load-encrypted) path key))
  (loadEncryptedPass
   [_ path password]
   ((clojure.core/get m4142 :load-encrypted-pass) path password))
  (parse [_ data] ((clojure.core/get m4142 :parse) data))
  (save [_ path] ((clojure.core/get m4142 :save) path))
  (saveEncrypted
   [_ path key]
   ((clojure.core/get m4142 :save-encrypted) path key))
  (saveEncryptedPass
   [_ path password]
   ((clojure.core/get m4142 :save-encrypted-pass) path password))
  (setValue
   [_ section key value]
   ((clojure.core/get m4142 :set-value) section key value)))
(deftype GodotVisualShaderNodeTransformDecompose
  [m4143]
  proto/ToVariant
  (->variant [this] (proto/->variant m4143))
  clojure.lang.ILookup
  (valAt [_ k] (get m4143 k))
  godotclj.api.gdscript.IGodotVisualShaderNodeTransformDecompose
  (addUserSignal
   [_ signal]
   ((clojure.core/get m4143 :add-user-signal) signal))
  (addUserSignal
   [_ signal arguments]
   ((clojure.core/get m4143 :add-user-signal) signal arguments))
  (call [_ method] ((clojure.core/get m4143 :call) method))
  (call [_ method v1] ((clojure.core/get m4143 :call) method v1))
  (call
   [_ method v1 v2]
   ((clojure.core/get m4143 :call) method v1 v2))
  (call
   [_ method v1 v2 v3]
   ((clojure.core/get m4143 :call) method v1 v2 v3))
  (call
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4143 :call) method v1 v2 v3 v4))
  (call
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4143 :call) method v1 v2 v3 v4 v5))
  (callDeferred
   [_ method]
   ((clojure.core/get m4143 :call-deferred) method))
  (callDeferred
   [_ method v1]
   ((clojure.core/get m4143 :call-deferred) method v1))
  (callDeferred
   [_ method v1 v2]
   ((clojure.core/get m4143 :call-deferred) method v1 v2))
  (callDeferred
   [_ method v1 v2 v3]
   ((clojure.core/get m4143 :call-deferred) method v1 v2 v3))
  (callDeferred
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4143 :call-deferred) method v1 v2 v3 v4))
  (callDeferred
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4143 :call-deferred) method v1 v2 v3 v4 v5))
  (callv
   [_ method arg_array]
   ((clojure.core/get m4143 :callv) method arg_array))
  (canTranslateMessages
   [_]
   ((clojure.core/get m4143 :can-translate-messages)))
  (connect
   [_ signal target method]
   ((clojure.core/get m4143 :connect) signal target method))
  (connect
   [_ signal target method binds]
   ((clojure.core/get m4143 :connect) signal target method binds))
  (connect
   [_ signal target method binds flags]
   ((clojure.core/get m4143 :connect)
    signal
    target
    method
    binds
    flags))
  (disconnect
   [_ signal target method]
   ((clojure.core/get m4143 :disconnect) signal target method))
  (emitSignal
   [_ signal]
   ((clojure.core/get m4143 :emit-signal) signal))
  (emitSignal
   [_ signal v1]
   ((clojure.core/get m4143 :emit-signal) signal v1))
  (emitSignal
   [_ signal v1 v2]
   ((clojure.core/get m4143 :emit-signal) signal v1 v2))
  (emitSignal
   [_ signal v1 v2 v3]
   ((clojure.core/get m4143 :emit-signal) signal v1 v2 v3))
  (emitSignal
   [_ signal v1 v2 v3 v4]
   ((clojure.core/get m4143 :emit-signal) signal v1 v2 v3 v4))
  (emitSignal
   [_ signal v1 v2 v3 v4 v5]
   ((clojure.core/get m4143 :emit-signal) signal v1 v2 v3 v4 v5))
  (free [_] ((clojure.core/get m4143 :free)))
  (get [_ property] ((clojure.core/get m4143 :get) property))
  (getClass [_] ((clojure.core/get m4143 :get-class)))
  (getIncomingConnections
   [_]
   ((clojure.core/get m4143 :get-incoming-connections)))
  (getIndexed
   [_ property]
   ((clojure.core/get m4143 :get-indexed) property))
  (getInstanceId [_] ((clojure.core/get m4143 :get-instance-id)))
  (getMeta [_ name] ((clojure.core/get m4143 :get-meta) name))
  (getMetaList [_] ((clojure.core/get m4143 :get-meta-list)))
  (getMethodList [_] ((clojure.core/get m4143 :get-method-list)))
  (getPropertyList [_] ((clojure.core/get m4143 :get-property-list)))
  (getScript [_] ((clojure.core/get m4143 :get-script)))
  (getSignalConnectionList
   [_ signal]
   ((clojure.core/get m4143 :get-signal-connection-list) signal))
  (getSignalList [_] ((clojure.core/get m4143 :get-signal-list)))
  (hasMeta [_ name] ((clojure.core/get m4143 :has-meta) name))
  (hasMethod [_ method] ((clojure.core/get m4143 :has-method) method))
  (hasSignal [_ signal] ((clojure.core/get m4143 :has-signal) signal))
  (hasUserSignal
   [_ signal]
   ((clojure.core/get m4143 :has-user-signal) signal))
  (isBlockingSignals
   [_]
   ((clojure.core/get m4143 :is-blocking-signals)))
  (isClass [_ class] ((clojure.core/get m4143 :is-class) class))
  (isConnected
   [_ signal target method]
   ((clojure.core/get m4143 :is-connected) signal target method))
  (isQueuedForDeletion
   [_]
   ((clojure.core/get m4143 :is-queued-for-deletion)))
  (notification
   [_ what]
   ((clojure.core/get m4143 :notification) what))
  (notification
   [_ what reversed]
   ((clojure.core/get m4143 :notification) what reversed))
  (propertyListChangedNotify
   [_]
   ((clojure.core/get m4143 :property-list-changed-notify)))
  (removeMeta [_ name] ((clojure.core/get m4143 :remove-meta) name))
  (set
   [_ property value]
   ((clojure.core/get m4143 :set) property value))
  (setBlockSignals
   [_ enable]
   ((clojure.core/get m4143 :set-block-signals) enable))
  (setDeferred
   [_ property value]
   ((clojure.core/get m4143 :set-deferred) property value))
  (setIndexed
   [_ property value]
   ((clojure.core/get m4143 :set-indexed) property value))
  (setMessageTranslation
   [_ enable]
   ((clojure.core/get m4143 :set-message-translation) enable))
  (setMeta
   [_ name value]
   ((clojure.core/get m4143 :set-meta) name value))
  (setScript [_ script] ((clojure.core/get m4143 :set-script) script))
  (tr [_ message] ((clojure.core/get m4143 :tr) message))
  (initRef [_] ((clojure.core/get m4143 :init-ref)))
  (reference [_] ((clojure.core/get m4143 :reference)))
  (unreference [_] ((clojure.core/get m4143 :unreference)))
  (duplicate [_] ((clojure.core/get m4143 :duplicate)))
  (duplicate
   [_ subresources]
   ((clojure.core/get m4143 :duplicate) subresources))
  (emitChanged [_] ((clojure.core/get m4143 :emit-changed)))
  (getLocalScene [_] ((clojure.core/get m4143 :get-local-scene)))
  (getName [_] ((clojure.core/get m4143 :get-name)))
  (getPath [_] ((clojure.core/get m4143 :get-path)))
  (getRid [_] ((clojure.core/get m4143 :get-rid)))
  (isLocalToScene [_] ((clojure.core/get m4143 :is-local-to-scene)))
  (setLocalToScene
   [_ enable]
   ((clojure.core/get m4143 :set-local-to-scene) enable))
  (setName [_ name] ((clojure.core/get m4143 :set-name) name))
  (setPath [_ path] ((clojure.core/get m4143 :set-path) path))
  (setupLocalToScene
   [_]
   ((clojure.core/get m4143 :setup-local-to-scene)))
  (takeOverPath
   [_ path]
   ((clojure.core/get m4143 :take-over-path) path))
  (getDefaultInputValues
   [_]
   ((clojure.core/get m4143 :get-default-input-values)))
  (getInputPortDefaultValue
   [_ port]
   ((clojure.core/get m4143 :get-input-port-default-value) port))
  (getOutputPortForPreview
   [_]
   ((clojure.core/get m4143 :get-output-port-for-preview)))
  (setDefaultInputValues
   [_ values]
   ((clojure.core/get m4143 :set-default-input-values) values))
  (setInputPortDefaultValue
   [_ port value]
   ((clojure.core/get m4143 :set-input-port-default-value) port value))
  (setOutputPortForPreview
   [_ port]
   ((clojure.core/get m4143 :set-output-port-for-preview) port)))
(deftype GodotContainer
  [m4144]
  proto/ToVariant
  (->variant [this] (proto/->variant m4144))
  clojure.lang.ILookup
  (valAt [_ k] (get m4144 k))
  godotclj.api.gdscript.IGodotContainer
  (addUserSignal
   [_ signal]
   ((clojure.core/get m4144 :add-user-signal) signal))
  (addUserSignal
   [_ signal arguments]
   ((clojure.core/get m4144 :add-user-signal) signal arguments))
  (call [_ method] ((clojure.core/get m4144 :call) method))
  (call [_ method v1] ((clojure.core/get m4144 :call) method v1))
  (call
   [_ method v1 v2]
   ((clojure.core/get m4144 :call) method v1 v2))
  (call
   [_ method v1 v2 v3]
   ((clojure.core/get m4144 :call) method v1 v2 v3))
  (call
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4144 :call) method v1 v2 v3 v4))
  (call
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4144 :call) method v1 v2 v3 v4 v5))
  (callDeferred
   [_ method]
   ((clojure.core/get m4144 :call-deferred) method))
  (callDeferred
   [_ method v1]
   ((clojure.core/get m4144 :call-deferred) method v1))
  (callDeferred
   [_ method v1 v2]
   ((clojure.core/get m4144 :call-deferred) method v1 v2))
  (callDeferred
   [_ method v1 v2 v3]
   ((clojure.core/get m4144 :call-deferred) method v1 v2 v3))
  (callDeferred
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4144 :call-deferred) method v1 v2 v3 v4))
  (callDeferred
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4144 :call-deferred) method v1 v2 v3 v4 v5))
  (callv
   [_ method arg_array]
   ((clojure.core/get m4144 :callv) method arg_array))
  (canTranslateMessages
   [_]
   ((clojure.core/get m4144 :can-translate-messages)))
  (connect
   [_ signal target method]
   ((clojure.core/get m4144 :connect) signal target method))
  (connect
   [_ signal target method binds]
   ((clojure.core/get m4144 :connect) signal target method binds))
  (connect
   [_ signal target method binds flags]
   ((clojure.core/get m4144 :connect)
    signal
    target
    method
    binds
    flags))
  (disconnect
   [_ signal target method]
   ((clojure.core/get m4144 :disconnect) signal target method))
  (emitSignal
   [_ signal]
   ((clojure.core/get m4144 :emit-signal) signal))
  (emitSignal
   [_ signal v1]
   ((clojure.core/get m4144 :emit-signal) signal v1))
  (emitSignal
   [_ signal v1 v2]
   ((clojure.core/get m4144 :emit-signal) signal v1 v2))
  (emitSignal
   [_ signal v1 v2 v3]
   ((clojure.core/get m4144 :emit-signal) signal v1 v2 v3))
  (emitSignal
   [_ signal v1 v2 v3 v4]
   ((clojure.core/get m4144 :emit-signal) signal v1 v2 v3 v4))
  (emitSignal
   [_ signal v1 v2 v3 v4 v5]
   ((clojure.core/get m4144 :emit-signal) signal v1 v2 v3 v4 v5))
  (free [_] ((clojure.core/get m4144 :free)))
  (get [_ property] ((clojure.core/get m4144 :get) property))
  (getClass [_] ((clojure.core/get m4144 :get-class)))
  (getIncomingConnections
   [_]
   ((clojure.core/get m4144 :get-incoming-connections)))
  (getIndexed
   [_ property]
   ((clojure.core/get m4144 :get-indexed) property))
  (getInstanceId [_] ((clojure.core/get m4144 :get-instance-id)))
  (getMeta [_ name] ((clojure.core/get m4144 :get-meta) name))
  (getMetaList [_] ((clojure.core/get m4144 :get-meta-list)))
  (getMethodList [_] ((clojure.core/get m4144 :get-method-list)))
  (getPropertyList [_] ((clojure.core/get m4144 :get-property-list)))
  (getScript [_] ((clojure.core/get m4144 :get-script)))
  (getSignalConnectionList
   [_ signal]
   ((clojure.core/get m4144 :get-signal-connection-list) signal))
  (getSignalList [_] ((clojure.core/get m4144 :get-signal-list)))
  (hasMeta [_ name] ((clojure.core/get m4144 :has-meta) name))
  (hasMethod [_ method] ((clojure.core/get m4144 :has-method) method))
  (hasSignal [_ signal] ((clojure.core/get m4144 :has-signal) signal))
  (hasUserSignal
   [_ signal]
   ((clojure.core/get m4144 :has-user-signal) signal))
  (isBlockingSignals
   [_]
   ((clojure.core/get m4144 :is-blocking-signals)))
  (isClass [_ class] ((clojure.core/get m4144 :is-class) class))
  (isConnected
   [_ signal target method]
   ((clojure.core/get m4144 :is-connected) signal target method))
  (isQueuedForDeletion
   [_]
   ((clojure.core/get m4144 :is-queued-for-deletion)))
  (notification
   [_ what]
   ((clojure.core/get m4144 :notification) what))
  (notification
   [_ what reversed]
   ((clojure.core/get m4144 :notification) what reversed))
  (propertyListChangedNotify
   [_]
   ((clojure.core/get m4144 :property-list-changed-notify)))
  (removeMeta [_ name] ((clojure.core/get m4144 :remove-meta) name))
  (set
   [_ property value]
   ((clojure.core/get m4144 :set) property value))
  (setBlockSignals
   [_ enable]
   ((clojure.core/get m4144 :set-block-signals) enable))
  (setDeferred
   [_ property value]
   ((clojure.core/get m4144 :set-deferred) property value))
  (setIndexed
   [_ property value]
   ((clojure.core/get m4144 :set-indexed) property value))
  (setMessageTranslation
   [_ enable]
   ((clojure.core/get m4144 :set-message-translation) enable))
  (setMeta
   [_ name value]
   ((clojure.core/get m4144 :set-meta) name value))
  (setScript [_ script] ((clojure.core/get m4144 :set-script) script))
  (tr [_ message] ((clojure.core/get m4144 :tr) message))
  (addChild [_ node] ((clojure.core/get m4144 :add-child) node))
  (addChild
   [_ node legible_unique_name]
   ((clojure.core/get m4144 :add-child) node legible_unique_name))
  (addChildBelowNode
   [_ node child_node]
   ((clojure.core/get m4144 :add-child-below-node) node child_node))
  (addChildBelowNode
   [_ node child_node legible_unique_name]
   ((clojure.core/get m4144 :add-child-below-node)
    node
    child_node
    legible_unique_name))
  (addToGroup
   [_ group]
   ((clojure.core/get m4144 :add-to-group) group))
  (addToGroup
   [_ group persistent]
   ((clojure.core/get m4144 :add-to-group) group persistent))
  (canProcess [_] ((clojure.core/get m4144 :can-process)))
  (duplicate [_] ((clojure.core/get m4144 :duplicate)))
  (duplicate [_ flags] ((clojure.core/get m4144 :duplicate) flags))
  (findNode [_ mask] ((clojure.core/get m4144 :find-node) mask))
  (findNode
   [_ mask recursive]
   ((clojure.core/get m4144 :find-node) mask recursive))
  (findNode
   [_ mask recursive owned]
   ((clojure.core/get m4144 :find-node) mask recursive owned))
  (findParent [_ mask] ((clojure.core/get m4144 :find-parent) mask))
  (getChild [_ idx] ((clojure.core/get m4144 :get-child) idx))
  (getChildCount [_] ((clojure.core/get m4144 :get-child-count)))
  (getChildren [_] ((clojure.core/get m4144 :get-children)))
  (getCustomMultiplayer
   [_]
   ((clojure.core/get m4144 :get-custom-multiplayer)))
  (getFilename [_] ((clojure.core/get m4144 :get-filename)))
  (getGroups [_] ((clojure.core/get m4144 :get-groups)))
  (getIndex [_] ((clojure.core/get m4144 :get-index)))
  (getMultiplayer [_] ((clojure.core/get m4144 :get-multiplayer)))
  (getName [_] ((clojure.core/get m4144 :get-name)))
  (getNetworkMaster
   [_]
   ((clojure.core/get m4144 :get-network-master)))
  (getNode [_ path] ((clojure.core/get m4144 :get-node) path))
  (getNodeAndResource
   [_ path]
   ((clojure.core/get m4144 :get-node-and-resource) path))
  (getNodeOrNull
   [_ path]
   ((clojure.core/get m4144 :get-node-or-null) path))
  (getOwner [_] ((clojure.core/get m4144 :get-owner)))
  (getParent [_] ((clojure.core/get m4144 :get-parent)))
  (getPath [_] ((clojure.core/get m4144 :get-path)))
  (getPathTo [_ node] ((clojure.core/get m4144 :get-path-to) node))
  (getPauseMode [_] ((clojure.core/get m4144 :get-pause-mode)))
  (getPhysicsProcessDeltaTime
   [_]
   ((clojure.core/get m4144 :get-physics-process-delta-time)))
  (getPositionInParent
   [_]
   ((clojure.core/get m4144 :get-position-in-parent)))
  (getProcessDeltaTime
   [_]
   ((clojure.core/get m4144 :get-process-delta-time)))
  (getProcessPriority
   [_]
   ((clojure.core/get m4144 :get-process-priority)))
  (getSceneInstanceLoadPlaceholder
   [_]
   ((clojure.core/get m4144 :get-scene-instance-load-placeholder)))
  (getTree [_] ((clojure.core/get m4144 :get-tree)))
  (getViewport [_] ((clojure.core/get m4144 :get-viewport)))
  (hasNode [_ path] ((clojure.core/get m4144 :has-node) path))
  (hasNodeAndResource
   [_ path]
   ((clojure.core/get m4144 :has-node-and-resource) path))
  (isAParentOf
   [_ node]
   ((clojure.core/get m4144 :is-a-parent-of) node))
  (isDisplayedFolded
   [_]
   ((clojure.core/get m4144 :is-displayed-folded)))
  (isGreaterThan
   [_ node]
   ((clojure.core/get m4144 :is-greater-than) node))
  (isInGroup [_ group] ((clojure.core/get m4144 :is-in-group) group))
  (isInsideTree [_] ((clojure.core/get m4144 :is-inside-tree)))
  (isNetworkMaster [_] ((clojure.core/get m4144 :is-network-master)))
  (isPhysicsProcessing
   [_]
   ((clojure.core/get m4144 :is-physics-processing)))
  (isPhysicsProcessingInternal
   [_]
   ((clojure.core/get m4144 :is-physics-processing-internal)))
  (isProcessing [_] ((clojure.core/get m4144 :is-processing)))
  (isProcessingInput
   [_]
   ((clojure.core/get m4144 :is-processing-input)))
  (isProcessingInternal
   [_]
   ((clojure.core/get m4144 :is-processing-internal)))
  (isProcessingUnhandledInput
   [_]
   ((clojure.core/get m4144 :is-processing-unhandled-input)))
  (isProcessingUnhandledKeyInput
   [_]
   ((clojure.core/get m4144 :is-processing-unhandled-key-input)))
  (moveChild
   [_ child_node to_position]
   ((clojure.core/get m4144 :move-child) child_node to_position))
  (printStrayNodes [_] ((clojure.core/get m4144 :print-stray-nodes)))
  (printTree [_] ((clojure.core/get m4144 :print-tree)))
  (printTreePretty [_] ((clojure.core/get m4144 :print-tree-pretty)))
  (propagateCall
   [_ method]
   ((clojure.core/get m4144 :propagate-call) method))
  (propagateCall
   [_ method args]
   ((clojure.core/get m4144 :propagate-call) method args))
  (propagateCall
   [_ method args parent_first]
   ((clojure.core/get m4144 :propagate-call) method args parent_first))
  (propagateNotification
   [_ what]
   ((clojure.core/get m4144 :propagate-notification) what))
  (queueFree [_] ((clojure.core/get m4144 :queue-free)))
  (raise [_] ((clojure.core/get m4144 :raise)))
  (removeAndSkip [_] ((clojure.core/get m4144 :remove-and-skip)))
  (removeChild [_ node] ((clojure.core/get m4144 :remove-child) node))
  (removeFromGroup
   [_ group]
   ((clojure.core/get m4144 :remove-from-group) group))
  (replaceBy [_ node] ((clojure.core/get m4144 :replace-by) node))
  (replaceBy
   [_ node keep_data]
   ((clojure.core/get m4144 :replace-by) node keep_data))
  (requestReady [_] ((clojure.core/get m4144 :request-ready)))
  (rpc [_ method] ((clojure.core/get m4144 :rpc) method))
  (rpc [_ method v1] ((clojure.core/get m4144 :rpc) method v1))
  (rpc [_ method v1 v2] ((clojure.core/get m4144 :rpc) method v1 v2))
  (rpc
   [_ method v1 v2 v3]
   ((clojure.core/get m4144 :rpc) method v1 v2 v3))
  (rpc
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4144 :rpc) method v1 v2 v3 v4))
  (rpc
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4144 :rpc) method v1 v2 v3 v4 v5))
  (rpcConfig
   [_ method mode]
   ((clojure.core/get m4144 :rpc-config) method mode))
  (rpcId
   [_ peer_id method]
   ((clojure.core/get m4144 :rpc-id) peer_id method))
  (rpcId
   [_ peer_id method v1]
   ((clojure.core/get m4144 :rpc-id) peer_id method v1))
  (rpcId
   [_ peer_id method v1 v2]
   ((clojure.core/get m4144 :rpc-id) peer_id method v1 v2))
  (rpcId
   [_ peer_id method v1 v2 v3]
   ((clojure.core/get m4144 :rpc-id) peer_id method v1 v2 v3))
  (rpcId
   [_ peer_id method v1 v2 v3 v4]
   ((clojure.core/get m4144 :rpc-id) peer_id method v1 v2 v3 v4))
  (rpcId
   [_ peer_id method v1 v2 v3 v4 v5]
   ((clojure.core/get m4144 :rpc-id) peer_id method v1 v2 v3 v4 v5))
  (rpcUnreliable
   [_ method]
   ((clojure.core/get m4144 :rpc-unreliable) method))
  (rpcUnreliable
   [_ method v1]
   ((clojure.core/get m4144 :rpc-unreliable) method v1))
  (rpcUnreliable
   [_ method v1 v2]
   ((clojure.core/get m4144 :rpc-unreliable) method v1 v2))
  (rpcUnreliable
   [_ method v1 v2 v3]
   ((clojure.core/get m4144 :rpc-unreliable) method v1 v2 v3))
  (rpcUnreliable
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4144 :rpc-unreliable) method v1 v2 v3 v4))
  (rpcUnreliable
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4144 :rpc-unreliable) method v1 v2 v3 v4 v5))
  (rpcUnreliableId
   [_ peer_id method]
   ((clojure.core/get m4144 :rpc-unreliable-id) peer_id method))
  (rpcUnreliableId
   [_ peer_id method v1]
   ((clojure.core/get m4144 :rpc-unreliable-id) peer_id method v1))
  (rpcUnreliableId
   [_ peer_id method v1 v2]
   ((clojure.core/get m4144 :rpc-unreliable-id) peer_id method v1 v2))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3]
   ((clojure.core/get m4144 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3 v4]
   ((clojure.core/get m4144 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3
    v4))
  (rpcUnreliableId
   [_ peer_id method v1 v2 v3 v4 v5]
   ((clojure.core/get m4144 :rpc-unreliable-id)
    peer_id
    method
    v1
    v2
    v3
    v4
    v5))
  (rset
   [_ property value]
   ((clojure.core/get m4144 :rset) property value))
  (rsetConfig
   [_ property mode]
   ((clojure.core/get m4144 :rset-config) property mode))
  (rsetId
   [_ peer_id property value]
   ((clojure.core/get m4144 :rset-id) peer_id property value))
  (rsetUnreliable
   [_ property value]
   ((clojure.core/get m4144 :rset-unreliable) property value))
  (rsetUnreliableId
   [_ peer_id property value]
   ((clojure.core/get m4144 :rset-unreliable-id)
    peer_id
    property
    value))
  (setCustomMultiplayer
   [_ api]
   ((clojure.core/get m4144 :set-custom-multiplayer) api))
  (setDisplayFolded
   [_ fold]
   ((clojure.core/get m4144 :set-display-folded) fold))
  (setFilename
   [_ filename]
   ((clojure.core/get m4144 :set-filename) filename))
  (setName [_ name] ((clojure.core/get m4144 :set-name) name))
  (setNetworkMaster
   [_ id]
   ((clojure.core/get m4144 :set-network-master) id))
  (setNetworkMaster
   [_ id recursive]
   ((clojure.core/get m4144 :set-network-master) id recursive))
  (setOwner [_ owner] ((clojure.core/get m4144 :set-owner) owner))
  (setPauseMode
   [_ mode]
   ((clojure.core/get m4144 :set-pause-mode) mode))
  (setPhysicsProcess
   [_ enable]
   ((clojure.core/get m4144 :set-physics-process) enable))
  (setPhysicsProcessInternal
   [_ enable]
   ((clojure.core/get m4144 :set-physics-process-internal) enable))
  (setProcess
   [_ enable]
   ((clojure.core/get m4144 :set-process) enable))
  (setProcessInput
   [_ enable]
   ((clojure.core/get m4144 :set-process-input) enable))
  (setProcessInternal
   [_ enable]
   ((clojure.core/get m4144 :set-process-internal) enable))
  (setProcessPriority
   [_ priority]
   ((clojure.core/get m4144 :set-process-priority) priority))
  (setProcessUnhandledInput
   [_ enable]
   ((clojure.core/get m4144 :set-process-unhandled-input) enable))
  (setProcessUnhandledKeyInput
   [_ enable]
   ((clojure.core/get m4144 :set-process-unhandled-key-input) enable))
  (setSceneInstanceLoadPlaceholder
   [_ load_placeholder]
   ((clojure.core/get m4144 :set-scene-instance-load-placeholder)
    load_placeholder))
  (updateConfigurationWarning
   [_]
   ((clojure.core/get m4144 :update-configuration-warning)))
  (drawArc
   [_ center radius start_angle end_angle point_count color]
   ((clojure.core/get m4144 :draw-arc)
    center
    radius
    start_angle
    end_angle
    point_count
    color))
  (drawArc
   [_ center radius start_angle end_angle point_count color width]
   ((clojure.core/get m4144 :draw-arc)
    center
    radius
    start_angle
    end_angle
    point_count
    color
    width))
  (drawArc
   [_
    center
    radius
    start_angle
    end_angle
    point_count
    color
    width
    antialiased]
   ((clojure.core/get m4144 :draw-arc)
    center
    radius
    start_angle
    end_angle
    point_count
    color
    width
    antialiased))
  (drawChar
   [_ font position char next]
   ((clojure.core/get m4144 :draw-char) font position char next))
  (drawChar
   [_ font position char next modulate]
   ((clojure.core/get m4144 :draw-char)
    font
    position
    char
    next
    modulate))
  (drawCircle
   [_ position radius color]
   ((clojure.core/get m4144 :draw-circle) position radius color))
  (drawColoredPolygon
   [_ points color]
   ((clojure.core/get m4144 :draw-colored-polygon) points color))
  (drawColoredPolygon
   [_ points color uvs]
   ((clojure.core/get m4144 :draw-colored-polygon) points color uvs))
  (drawColoredPolygon
   [_ points color uvs texture]
   ((clojure.core/get m4144 :draw-colored-polygon)
    points
    color
    uvs
    texture))
  (drawColoredPolygon
   [_ points color uvs texture normal_map]
   ((clojure.core/get m4144 :draw-colored-polygon)
    points
    color
    uvs
    texture
    normal_map))
  (drawColoredPolygon
   [_ points color uvs texture normal_map antialiased]
   ((clojure.core/get m4144 :draw-colored-polygon)
    points
    color
    uvs
    texture
    normal_map
    antialiased))
  (drawLine
   [_ from to color]
   ((clojure.core/get m4144 :draw-line) from to color))
  (drawLine
   [_ from to color width]
   ((clojure.core/get m4144 :draw-line) from to color width))
  (drawLine
   [_ from to color width antialiased]
   ((clojure.core/get m4144 :draw-line)
    from
    to
    color
    width
    antialiased))
  (drawMesh
   [_ mesh texture]
   ((clojure.core/get m4144 :draw-mesh) mesh texture))
  (drawMesh
   [_ mesh texture normal_map]
   ((clojure.core/get m4144 :draw-mesh) mesh texture normal_map))
  (drawMesh
   [_ mesh texture normal_map transform]
   ((clojure.core/get m4144 :draw-mesh)
    mesh
    texture
    normal_map
    transform))
  (drawMesh
   [_ mesh texture normal_map transform modulate]
   ((clojure.core/get m4144 :draw-mesh)
    mesh
    texture
    normal_map
    transform
    modulate))
  (drawMultiline
   [_ points color]
   ((clojure.core/get m4144 :draw-multiline) points color))
  (drawMultiline
   [_ points color width]
   ((clojure.core/get m4144 :draw-multiline) points color width))
  (drawMultiline
   [_ points color width antialiased]
   ((clojure.core/get m4144 :draw-multiline)
    points
    color
    width
    antialiased))
  (drawMultilineColors
   [_ points colors]
   ((clojure.core/get m4144 :draw-multiline-colors) points colors))
  (drawMultilineColors
   [_ points colors width]
   ((clojure.core/get m4144 :draw-multiline-colors)
    points
    colors
    width))
  (drawMultilineColors
   [_ points colors width antialiased]
   ((clojure.core/get m4144 :draw-multiline-colors)
    points
    colors
    width
    antialiased))
  (drawMultimesh
   [_ multimesh texture]
   ((clojure.core/get m4144 :draw-multimesh) multimesh texture))
  (drawMultimesh
   [_ multimesh texture normal_map]
   ((clojure.core/get m4144 :draw-multimesh)
    multimesh
    texture
    normal_map))
  (drawPolygon
   [_ points colors]
   ((clojure.core/get m4144 :draw-polygon) points colors))
  (drawPolygon
   [_ points colors uvs]
   ((clojure.core/get m4144 :draw-polygon) points colors uvs))
  (drawPolygon
   [_ points colors uvs texture]
   ((clojure.core/get m4144 :draw-polygon) points colors uvs texture))
  (drawPolygon
   [_ points colors uvs texture normal_map]
   ((clojure.core/get m4144 :draw-polygon)
    points
    colors
    uvs
    texture
    normal_map))
  (drawPolygon
   [_ points colors uvs texture normal_map antialiased]
   ((clojure.core/get m4144 :draw-polygon)
    points
    colors
    uvs
    texture
    normal_map
    antialiased))
  (drawPolyline
   [_ points color]
   ((clojure.core/get m4144 :draw-polyline) points color))
  (drawPolyline
   [_ points color width]
   ((clojure.core/get m4144 :draw-polyline) points color width))
  (drawPolyline
   [_ points color width antialiased]
   ((clojure.core/get m4144 :draw-polyline)
    points
    color
    width
    antialiased))
  (drawPolylineColors
   [_ points colors]
   ((clojure.core/get m4144 :draw-polyline-colors) points colors))
  (drawPolylineColors
   [_ points colors width]
   ((clojure.core/get m4144 :draw-polyline-colors)
    points
    colors
    width))
  (drawPolylineColors
   [_ points colors width antialiased]
   ((clojure.core/get m4144 :draw-polyline-colors)
    points
    colors
    width
    antialiased))
  (drawPrimitive
   [_ points colors uvs]
   ((clojure.core/get m4144 :draw-primitive) points colors uvs))
  (drawPrimitive
   [_ points colors uvs texture]
   ((clojure.core/get m4144 :draw-primitive)
    points
    colors
    uvs
    texture))
  (drawPrimitive
   [_ points colors uvs texture width]
   ((clojure.core/get m4144 :draw-primitive)
    points
    colors
    uvs
    texture
    width))
  (drawPrimitive
   [_ points colors uvs texture width normal_map]
   ((clojure.core/get m4144 :draw-primitive)
    points
    colors
    uvs
    texture
    width
    normal_map))
  (drawRect
   [_ rect color]
   ((clojure.core/get m4144 :draw-rect) rect color))
  (drawRect
   [_ rect color filled]
   ((clojure.core/get m4144 :draw-rect) rect color filled))
  (drawRect
   [_ rect color filled width]
   ((clojure.core/get m4144 :draw-rect) rect color filled width))
  (drawRect
   [_ rect color filled width antialiased]
   ((clojure.core/get m4144 :draw-rect)
    rect
    color
    filled
    width
    antialiased))
  (drawSetTransform
   [_ position rotation scale]
   ((clojure.core/get m4144 :draw-set-transform)
    position
    rotation
    scale))
  (drawSetTransformMatrix
   [_ xform]
   ((clojure.core/get m4144 :draw-set-transform-matrix) xform))
  (drawString
   [_ font position text]
   ((clojure.core/get m4144 :draw-string) font position text))
  (drawString
   [_ font position text modulate]
   ((clojure.core/get m4144 :draw-string) font position text modulate))
  (drawString
   [_ font position text modulate clip_w]
   ((clojure.core/get m4144 :draw-string)
    font
    position
    text
    modulate
    clip_w))
  (drawStyleBox
   [_ style_box rect]
   ((clojure.core/get m4144 :draw-style-box) style_box rect))
  (drawTexture
   [_ texture position]
   ((clojure.core/get m4144 :draw-texture) texture position))
  (drawTexture
   [_ texture position modulate]
   ((clojure.core/get m4144 :draw-texture) texture position modulate))
  (drawTexture
   [_ texture position modulate normal_map]
   ((clojure.core/get m4144 :draw-texture)
    texture
    position
    modulate
    normal_map))
  (drawTextureRect
   [_ texture rect tile]
   ((clojure.core/get m4144 :draw-texture-rect) texture rect tile))
  (drawTextureRect
   [_ texture rect tile modulate]
   ((clojure.core/get m4144 :draw-texture-rect)
    texture
    rect
    tile
    modulate))
  (drawTextureRect
   [_ texture rect tile modulate transpose]
   ((clojure.core/get m4144 :draw-texture-rect)
    texture
    rect
    tile
    modulate
    transpose))
  (drawTextureRect
   [_ texture rect tile modulate transpose normal_map]
   ((clojure.core/get m4144 :draw-texture-rect)
    texture
    rect
    tile
    modulate
    transpose
    normal_map))
  (drawTextureRectRegion
   [_ texture rect src_rect]
   ((clojure.core/get m4144 :draw-texture-rect-region)
    texture
    rect
    src_rect))
  (drawTextureRectRegion
   [_ texture rect src_rect modulate]
   ((clojure.core/get m4144 :draw-texture-rect-region)
    texture
    rect
    src_rect
    modulate))
  (drawTextureRectRegion
   [_ texture rect src_rect modulate transpose]
   ((clojure.core/get m4144 :draw-texture-rect-region)
    texture
    rect
    src_rect
    modulate
    transpose))
  (drawTextureRectRegion
   [_ texture rect src_rect modulate transpose normal_map]
   ((clojure.core/get m4144 :draw-texture-rect-region)
    texture
    rect
    src_rect
    modulate
    transpose
    normal_map))
  (drawTextureRectRegion
   [_ texture rect src_rect modulate transpose normal_map clip_uv]
   ((clojure.core/get m4144 :draw-texture-rect-region)
    texture
    rect
    src_rect
    modulate
    transpose
    normal_map
    clip_uv))
  (forceUpdateTransform
   [_]
   ((clojure.core/get m4144 :force-update-transform)))
  (getCanvas [_] ((clojure.core/get m4144 :get-canvas)))
  (getCanvasItem [_] ((clojure.core/get m4144 :get-canvas-item)))
  (getCanvasTransform
   [_]
   ((clojure.core/get m4144 :get-canvas-transform)))
  (getGlobalMousePosition
   [_]
   ((clojure.core/get m4144 :get-global-mouse-position)))
  (getGlobalTransform
   [_]
   ((clojure.core/get m4144 :get-global-transform)))
  (getGlobalTransformWithCanvas
   [_]
   ((clojure.core/get m4144 :get-global-transform-with-canvas)))
  (getLightMask [_] ((clojure.core/get m4144 :get-light-mask)))
  (getLocalMousePosition
   [_]
   ((clojure.core/get m4144 :get-local-mouse-position)))
  (getMaterial [_] ((clojure.core/get m4144 :get-material)))
  (getModulate [_] ((clojure.core/get m4144 :get-modulate)))
  (getSelfModulate [_] ((clojure.core/get m4144 :get-self-modulate)))
  (getTransform [_] ((clojure.core/get m4144 :get-transform)))
  (getUseParentMaterial
   [_]
   ((clojure.core/get m4144 :get-use-parent-material)))
  (getViewportRect [_] ((clojure.core/get m4144 :get-viewport-rect)))
  (getViewportTransform
   [_]
   ((clojure.core/get m4144 :get-viewport-transform)))
  (getWorld2d [_] ((clojure.core/get m4144 :get-world-2d)))
  (hide [_] ((clojure.core/get m4144 :hide)))
  (isDrawBehindParentEnabled
   [_]
   ((clojure.core/get m4144 :is-draw-behind-parent-enabled)))
  (isLocalTransformNotificationEnabled
   [_]
   ((clojure.core/get m4144 :is-local-transform-notification-enabled)))
  (isSetAsToplevel [_] ((clojure.core/get m4144 :is-set-as-toplevel)))
  (isTransformNotificationEnabled
   [_]
   ((clojure.core/get m4144 :is-transform-notification-enabled)))
  (isVisible [_] ((clojure.core/get m4144 :is-visible)))
  (isVisibleInTree [_] ((clojure.core/get m4144 :is-visible-in-tree)))
  (makeCanvasPositionLocal
   [_ screen_point]
   ((clojure.core/get m4144 :make-canvas-position-local) screen_point))
  (makeInputLocal
   [_ event]
   ((clojure.core/get m4144 :make-input-local) event))
  (setAsToplevel
   [_ enable]
   ((clojure.core/get m4144 :set-as-toplevel) enable))
  (setDrawBehindParent
   [_ enable]
   ((clojure.core/get m4144 :set-draw-behind-parent) enable))
  (setLightMask
   [_ light_mask]
   ((clojure.core/get m4144 :set-light-mask) light_mask))
  (setMaterial
   [_ material]
   ((clojure.core/get m4144 :set-material) material))
  (setModulate
   [_ modulate]
   ((clojure.core/get m4144 :set-modulate) modulate))
  (setNotifyLocalTransform
   [_ enable]
   ((clojure.core/get m4144 :set-notify-local-transform) enable))
  (setNotifyTransform
   [_ enable]
   ((clojure.core/get m4144 :set-notify-transform) enable))
  (setSelfModulate
   [_ self_modulate]
   ((clojure.core/get m4144 :set-self-modulate) self_modulate))
  (setUseParentMaterial
   [_ enable]
   ((clojure.core/get m4144 :set-use-parent-material) enable))
  (setVisible
   [_ visible]
   ((clojure.core/get m4144 :set-visible) visible))
  (show [_] ((clojure.core/get m4144 :show)))
  (update [_] ((clojure.core/get m4144 :update)))
  (acceptEvent [_] ((clojure.core/get m4144 :accept-event)))
  (addColorOverride
   [_ name color]
   ((clojure.core/get m4144 :add-color-override) name color))
  (addConstantOverride
   [_ name constant]
   ((clojure.core/get m4144 :add-constant-override) name constant))
  (addFontOverride
   [_ name font]
   ((clojure.core/get m4144 :add-font-override) name font))
  (addIconOverride
   [_ name texture]
   ((clojure.core/get m4144 :add-icon-override) name texture))
  (addShaderOverride
   [_ name shader]
   ((clojure.core/get m4144 :add-shader-override) name shader))
  (addStyleboxOverride
   [_ name stylebox]
   ((clojure.core/get m4144 :add-stylebox-override) name stylebox))
  (canDropData
   [_ position data]
   ((clojure.core/get m4144 :can-drop-data) position data))
  (dropData
   [_ position data]
   ((clojure.core/get m4144 :drop-data) position data))
  (findNextValidFocus
   [_]
   ((clojure.core/get m4144 :find-next-valid-focus)))
  (findPrevValidFocus
   [_]
   ((clojure.core/get m4144 :find-prev-valid-focus)))
  (forceDrag
   [_ data preview]
   ((clojure.core/get m4144 :force-drag) data preview))
  (getAnchor [_ margin] ((clojure.core/get m4144 :get-anchor) margin))
  (getBegin [_] ((clojure.core/get m4144 :get-begin)))
  (getColor [_ name] ((clojure.core/get m4144 :get-color) name))
  (getColor
   [_ name node_type]
   ((clojure.core/get m4144 :get-color) name node_type))
  (getCombinedMinimumSize
   [_]
   ((clojure.core/get m4144 :get-combined-minimum-size)))
  (getConstant [_ name] ((clojure.core/get m4144 :get-constant) name))
  (getConstant
   [_ name node_type]
   ((clojure.core/get m4144 :get-constant) name node_type))
  (getCursorShape [_] ((clojure.core/get m4144 :get-cursor-shape)))
  (getCursorShape
   [_ position]
   ((clojure.core/get m4144 :get-cursor-shape) position))
  (getCustomMinimumSize
   [_]
   ((clojure.core/get m4144 :get-custom-minimum-size)))
  (getDefaultCursorShape
   [_]
   ((clojure.core/get m4144 :get-default-cursor-shape)))
  (getDragData
   [_ position]
   ((clojure.core/get m4144 :get-drag-data) position))
  (getEnd [_] ((clojure.core/get m4144 :get-end)))
  (getFocusMode [_] ((clojure.core/get m4144 :get-focus-mode)))
  (getFocusNeighbour
   [_ margin]
   ((clojure.core/get m4144 :get-focus-neighbour) margin))
  (getFocusNext [_] ((clojure.core/get m4144 :get-focus-next)))
  (getFocusOwner [_] ((clojure.core/get m4144 :get-focus-owner)))
  (getFocusPrevious
   [_]
   ((clojure.core/get m4144 :get-focus-previous)))
  (getFont [_ name] ((clojure.core/get m4144 :get-font) name))
  (getFont
   [_ name node_type]
   ((clojure.core/get m4144 :get-font) name node_type))
  (getGlobalPosition
   [_]
   ((clojure.core/get m4144 :get-global-position)))
  (getGlobalRect [_] ((clojure.core/get m4144 :get-global-rect)))
  (getHGrowDirection
   [_]
   ((clojure.core/get m4144 :get-h-grow-direction)))
  (getHSizeFlags [_] ((clojure.core/get m4144 :get-h-size-flags)))
  (getIcon [_ name] ((clojure.core/get m4144 :get-icon) name))
  (getIcon
   [_ name node_type]
   ((clojure.core/get m4144 :get-icon) name node_type))
  (getMargin [_ margin] ((clojure.core/get m4144 :get-margin) margin))
  (getMinimumSize [_] ((clojure.core/get m4144 :get-minimum-size)))
  (getMouseFilter [_] ((clojure.core/get m4144 :get-mouse-filter)))
  (getParentAreaSize
   [_]
   ((clojure.core/get m4144 :get-parent-area-size)))
  (getParentControl
   [_]
   ((clojure.core/get m4144 :get-parent-control)))
  (getPassOnModalCloseClick
   [_]
   ((clojure.core/get m4144 :get-pass-on-modal-close-click)))
  (getPivotOffset [_] ((clojure.core/get m4144 :get-pivot-offset)))
  (getPosition [_] ((clojure.core/get m4144 :get-position)))
  (getRect [_] ((clojure.core/get m4144 :get-rect)))
  (getRotation [_] ((clojure.core/get m4144 :get-rotation)))
  (getRotationDegrees
   [_]
   ((clojure.core/get m4144 :get-rotation-degrees)))
  (getScale [_] ((clojure.core/get m4144 :get-scale)))
  (getSize [_] ((clojure.core/get m4144 :get-size)))
  (getStretchRatio [_] ((clojure.core/get m4144 :get-stretch-ratio)))
  (getStylebox [_ name] ((clojure.core/get m4144 :get-stylebox) name))
  (getStylebox
   [_ name node_type]
   ((clojure.core/get m4144 :get-stylebox) name node_type))
  (getTheme [_] ((clojure.core/get m4144 :get-theme)))
  (getTooltip [_] ((clojure.core/get m4144 :get-tooltip)))
  (getTooltip
   [_ at_position]
   ((clojure.core/get m4144 :get-tooltip) at_position))
  (getVGrowDirection
   [_]
   ((clojure.core/get m4144 :get-v-grow-direction)))
  (getVSizeFlags [_] ((clojure.core/get m4144 :get-v-size-flags)))
  (grabClickFocus [_] ((clojure.core/get m4144 :grab-click-focus)))
  (grabFocus [_] ((clojure.core/get m4144 :grab-focus)))
  (hasColor [_ name] ((clojure.core/get m4144 :has-color) name))
  (hasColor
   [_ name node_type]
   ((clojure.core/get m4144 :has-color) name node_type))
  (hasColorOverride
   [_ name]
   ((clojure.core/get m4144 :has-color-override) name))
  (hasConstant [_ name] ((clojure.core/get m4144 :has-constant) name))
  (hasConstant
   [_ name node_type]
   ((clojure.core/get m4144 :has-constant) name node_type))
  (hasConstantOverride
   [_ name]
   ((clojure.core/get m4144 :has-constant-override) name))
  (hasFocus [_] ((clojure.core/get m4144 :has-focus)))
  (hasFont [_ name] ((clojure.core/get m4144 :has-font) name))
  (hasFont
   [_ name node_type]
   ((clojure.core/get m4144 :has-font) name node_type))
  (hasFontOverride
   [_ name]
   ((clojure.core/get m4144 :has-font-override) name))
  (hasIcon [_ name] ((clojure.core/get m4144 :has-icon) name))
  (hasIcon
   [_ name node_type]
   ((clojure.core/get m4144 :has-icon) name node_type))
  (hasIconOverride
   [_ name]
   ((clojure.core/get m4144 :has-icon-override) name))
  (hasPoint [_ point] ((clojure.core/get m4144 :has-point) point))
  (hasShaderOverride
   [_ name]
   ((clojure.core/get m4144 :has-shader-override) name))
  (hasStylebox [_ name] ((clojure.core/get m4144 :has-stylebox) name))
  (hasStylebox
   [_ name node_type]
   ((clojure.core/get m4144 :has-stylebox) name node_type))
  (hasStyleboxOverride
   [_ name]
   ((clojure.core/get m4144 :has-stylebox-override) name))
  (isClippingContents
   [_]
   ((clojure.core/get m4144 :is-clipping-contents)))
  (minimumSizeChanged
   [_]
   ((clojure.core/get m4144 :minimum-size-changed)))
  (releaseFocus [_] ((clojure.core/get m4144 :release-focus)))
  (setAnchor
   [_ margin anchor]
   ((clojure.core/get m4144 :set-anchor) margin anchor))
  (setAnchor
   [_ margin anchor keep_margin]
   ((clojure.core/get m4144 :set-anchor) margin anchor keep_margin))
  (setAnchor
   [_ margin anchor keep_margin push_opposite_anchor]
   ((clojure.core/get m4144 :set-anchor)
    margin
    anchor
    keep_margin
    push_opposite_anchor))
  (setAnchorAndMargin
   [_ margin anchor offset]
   ((clojure.core/get m4144 :set-anchor-and-margin)
    margin
    anchor
    offset))
  (setAnchorAndMargin
   [_ margin anchor offset push_opposite_anchor]
   ((clojure.core/get m4144 :set-anchor-and-margin)
    margin
    anchor
    offset
    push_opposite_anchor))
  (setAnchorsAndMarginsPreset
   [_ preset]
   ((clojure.core/get m4144 :set-anchors-and-margins-preset) preset))
  (setAnchorsAndMarginsPreset
   [_ preset resize_mode]
   ((clojure.core/get m4144 :set-anchors-and-margins-preset)
    preset
    resize_mode))
  (setAnchorsAndMarginsPreset
   [_ preset resize_mode margin]
   ((clojure.core/get m4144 :set-anchors-and-margins-preset)
    preset
    resize_mode
    margin))
  (setAnchorsPreset
   [_ preset]
   ((clojure.core/get m4144 :set-anchors-preset) preset))
  (setAnchorsPreset
   [_ preset keep_margins]
   ((clojure.core/get m4144 :set-anchors-preset) preset keep_margins))
  (setBegin
   [_ position]
   ((clojure.core/get m4144 :set-begin) position))
  (setClipContents
   [_ enable]
   ((clojure.core/get m4144 :set-clip-contents) enable))
  (setCustomMinimumSize
   [_ size]
   ((clojure.core/get m4144 :set-custom-minimum-size) size))
  (setDefaultCursorShape
   [_ shape]
   ((clojure.core/get m4144 :set-default-cursor-shape) shape))
  (setDragForwarding
   [_ target]
   ((clojure.core/get m4144 :set-drag-forwarding) target))
  (setDragPreview
   [_ control]
   ((clojure.core/get m4144 :set-drag-preview) control))
  (setEnd [_ position] ((clojure.core/get m4144 :set-end) position))
  (setFocusMode
   [_ mode]
   ((clojure.core/get m4144 :set-focus-mode) mode))
  (setFocusNeighbour
   [_ margin neighbour]
   ((clojure.core/get m4144 :set-focus-neighbour) margin neighbour))
  (setFocusNext
   [_ next]
   ((clojure.core/get m4144 :set-focus-next) next))
  (setFocusPrevious
   [_ previous]
   ((clojure.core/get m4144 :set-focus-previous) previous))
  (setGlobalPosition
   [_ position]
   ((clojure.core/get m4144 :set-global-position) position))
  (setGlobalPosition
   [_ position keep_margins]
   ((clojure.core/get m4144 :set-global-position)
    position
    keep_margins))
  (setHGrowDirection
   [_ direction]
   ((clojure.core/get m4144 :set-h-grow-direction) direction))
  (setHSizeFlags
   [_ flags]
   ((clojure.core/get m4144 :set-h-size-flags) flags))
  (setMargin
   [_ margin offset]
   ((clojure.core/get m4144 :set-margin) margin offset))
  (setMarginsPreset
   [_ preset]
   ((clojure.core/get m4144 :set-margins-preset) preset))
  (setMarginsPreset
   [_ preset resize_mode]
   ((clojure.core/get m4144 :set-margins-preset) preset resize_mode))
  (setMarginsPreset
   [_ preset resize_mode margin]
   ((clojure.core/get m4144 :set-margins-preset)
    preset
    resize_mode
    margin))
  (setMouseFilter
   [_ filter]
   ((clojure.core/get m4144 :set-mouse-filter) filter))
  (setPassOnModalCloseClick
   [_ enabled]
   ((clojure.core/get m4144 :set-pass-on-modal-close-click) enabled))
  (setPivotOffset
   [_ pivot_offset]
   ((clojure.core/get m4144 :set-pivot-offset) pivot_offset))
  (setPosition
   [_ position]
   ((clojure.core/get m4144 :set-position) position))
  (setPosition
   [_ position keep_margins]
   ((clojure.core/get m4144 :set-position) position keep_margins))
  (setRotation
   [_ radians]
   ((clojure.core/get m4144 :set-rotation) radians))
  (setRotationDegrees
   [_ degrees]
   ((clojure.core/get m4144 :set-rotation-degrees) degrees))
  (setScale [_ scale] ((clojure.core/get m4144 :set-scale) scale))
  (setSize [_ size] ((clojure.core/get m4144 :set-size) size))
  (setSize
   [_ size keep_margins]
   ((clojure.core/get m4144 :set-size) size keep_margins))
  (setStretchRatio
   [_ ratio]
   ((clojure.core/get m4144 :set-stretch-ratio) ratio))
  (setTheme [_ theme] ((clojure.core/get m4144 :set-theme) theme))
  (setTooltip
   [_ tooltip]
   ((clojure.core/get m4144 :set-tooltip) tooltip))
  (setVGrowDirection
   [_ direction]
   ((clojure.core/get m4144 :set-v-grow-direction) direction))
  (setVSizeFlags
   [_ flags]
   ((clojure.core/get m4144 :set-v-size-flags) flags))
  (showModal [_] ((clojure.core/get m4144 :show-modal)))
  (showModal
   [_ exclusive]
   ((clojure.core/get m4144 :show-modal) exclusive))
  (warpMouse
   [_ to_position]
   ((clojure.core/get m4144 :warp-mouse) to_position))
  (fitChildInRect
   [_ child rect]
   ((clojure.core/get m4144 :fit-child-in-rect) child rect))
  (queueSort [_] ((clojure.core/get m4144 :queue-sort))))
(deftype GodotBoxContainer
  [m4145]
  proto/ToVariant
  (->variant [this] (proto/->variant m4145))
  clojure.lang.ILookup
  (valAt [_ k] (get m4145 k))
  godotclj.api.gdscript.IGodotBoxContainer
  (addUserSignal
   [_ signal]
   ((clojure.core/get m4145 :add-user-signal) signal))
  (addUserSignal
   [_ signal arguments]
   ((clojure.core/get m4145 :add-user-signal) signal arguments))
  (call [_ method] ((clojure.core/get m4145 :call) method))
  (call [_ method v1] ((clojure.core/get m4145 :call) method v1))
  (call
   [_ method v1 v2]
   ((clojure.core/get m4145 :call) method v1 v2))
  (call
   [_ method v1 v2 v3]
   ((clojure.core/get m4145 :call) method v1 v2 v3))
  (call
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4145 :call) method v1 v2 v3 v4))
  (call
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4145 :call) method v1 v2 v3 v4 v5))
  (callDeferred
   [_ method]
   ((clojure.core/get m4145 :call-deferred) method))
  (callDeferred
   [_ method v1]
   ((clojure.core/get m4145 :call-deferred) method v1))
  (callDeferred
   [_ method v1 v2]
   ((clojure.core/get m4145 :call-deferred) method v1 v2))
  (callDeferred
   [_ method v1 v2 v3]
   ((clojure.core/get m4145 :call-deferred) method v1 v2 v3))
  (callDeferred
   [_ method v1 v2 v3 v4]
   ((clojure.core/get m4145 :call-deferred) method v1 v2 v3 v4))
  (callDeferred
   [_ method v1 v2 v3 v4 v5]
   ((clojure.core/get m4145 :call-deferred) method v1 v2 v3 v4 v5))
  (callv
   [_ method arg_array]
   ((clojure.core/get m4145 :callv) method arg_array))
  (canTranslateMessages
   [_]
   ((clojure.core/get m4145 :can-translate-messages)))
  (connect
   [_ signal target method]
   ((clojure.core/get m4145 :connect) signal target method))
  (connect
   [_ signal target method binds]
   ((clojure.core/get m4145 :connect) signal target method binds))
  (connect
   [_ signal target method binds flags]
   ((clojure.core/get m4145 :connect)
    signal
    target
    method
    binds
    flags))
  (disconnect
   [_ signal target method]
   ((clojure.core/get m4145 :disconnect) signal target method))
  (emitSignal
   [_ signal]
   ((clojure.core/get m4145 :emit-signal) signal))
  (emitSignal
   [_ signal v1]
   ((clojure.core/get m4145 :emit-signal) signal v1))
  (emitSignal
   [_ signal v1 v2]
   ((clojure.core/get m4145 :emit-signal) signal v1 v2))
  (emitSignal
   [_ signal v1 v2 v3]
   ((clojure.core/get m4145 :emit-signal) signal v1 v2 v3))
  (emitSignal
   [_ signal v1 v2 v3 v4]
   ((clojure.core/get m4145 :emit-signal) signal v1 v2 v3 v4))
  (emitSignal
   [_ signal v1 v2 v3 v4 v5]
   ((clojure.core/get m4145 :emit-signal) signal v1 v2 v3 v4 v5))
  (free [_] ((clojure.core/get m4145 :free)))
  (get [_ property] ((clojure.core/get m4145 :get) property))
  (getClass [_] ((clojure.core/get m4145 :get-class)))
  (getIncomingConnections
   [_]
   ((clojure.core/get m4145 :get-incoming-connections)))
  (getIndexed
   [_ property]
   ((clojure.core/get m4145 :get-indexed) property))
  (getInstanceId [_] ((clojure.core/get m4145 :get-instance-id)))
  (getMeta [_ name] ((clojure.core/get m4145 :get-meta) name))
  (getMetaList [_] ((clojure.core/get m4145 :get-meta-list)))
  (getMethodList [_] ((clojure.core/get m4145 :get-method-list)))
  (getPropertyList [_] ((clojure.core/get m4145 :get-property-list)))
  (getScript [_] ((clojure.core/get m4145 :get-script)))
  (getSignalConnectionList
   [_ signal]
   ((clojure.core/get m4145 :get-signal-connection-list) signal))
  (getSignalList [_] ((clojure.core/get m4145 :get-signal-list)))
  (hasMeta [_ name] ((clojure.core/get m4145 :has-meta) name))
  (hasMethod [_ method] ((clojure.core/get m4145 :has-method) method))
  (hasSignal [_ signal] ((clojure.core/get m4145 :has-signal) signal))
  (hasUserSignal
   [_ signal]
   ((clojure.core/get m4145 :has-user-signal) signal))
  (isBlockingSignals
   [_]
   ((clojure.core/get m4145 :is-blocking-signals)))
  (isClass [_ class] ((clojure.core/get m4145 :is-class) class))
  (isConnected
   [_ signal target method]
   ((clojure.core/get m4145 :is-connected) signal target method))
  (isQueuedForDeletion
   [_]
   ((clojure.core/get m4145 :is-queued-for-deletion)))
  (notification
   [_ what]
   ((clojure.core/get m4145 :notification) what))
  (notification
   [_ what reversed]
   ((clojure.core/get m4145 :notification) what reversed))
  (propertyListChangedNotify
   [_]
   ((clojure.core/get m4145 :property-list-changed-notify)))
  (removeMeta [_ name] ((clojure.core/get m4145 :remove-meta) name))
  (set
   [_ property value]
   ((clojure.core/get m4145 :set) property value))
  (setBlockSignals
   [_ enable]
   ((clojure.core/get m4145 :set-block-signals) enable))
  (setDeferred
   [_ property value]
   ((clojure.core/get m4145 :set-deferred) property value))
  (setIndexed
   [_ property value]
   ((cloj