(ns sade.cli
  (:require [clojure.edn :as edn]
            [sade.parser :as parser]
            [sade.core :as core]
            [sade.version :as version])
  (:gen-class))

(def help-text
  "sade - convert input written in sade, a DSL with Ruby‑like expressions, into HTML

Usage:
  sade [options]

Options:
  -h, --help       Show this help message and exit
  -v, --version    Show version information and exit
  -V, --vector     Read EDN vector instead of sade DSL

Examples:
  echo \"div.p Hello\" | sade
  echo \"[:p {:class \\\"x\\\"} \\\"Hi\\\"]\" | sade -V")

(defn -main [& args]
  (let [opts (set args)]
    
    ;; --- help ---
    (when (or (opts "-h") (opts "--help"))
      (println help-text)
      (System/exit 0))

    ;; --- version ---
    (when (or (opts "-v") (opts "--version"))
      (println (str "sade " version/version))
      (System/exit 0))

    ;; --- normal processing ---
    (let [input (slurp *in*)
          ast   (if (or (opts "-V") (opts "--vector"))
                  (edn/read-string input)
                  (parser/parse-sade input))
          html  (core/render-document ast)]
      (println html))))

