/*
 * Decompiled with CFR 0.152.
 */
package sade;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.tree.ParseTree;
import sade.SadeParser;
import sade.SadeParserBaseVisitor;

public class SadeAstVisitor
extends SadeParserBaseVisitor<String> {
    @Override
    public String visitDocument(SadeParser.DocumentContext documentContext) {
        List<String> list = this.processElements(documentContext.element(), true);
        return "[" + String.join((CharSequence)" ", list) + "]";
    }

    private List<String> processElements(List<SadeParser.ElementContext> list, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            SadeParser.ElementContext elementContext = list.get(i);
            if (elementContext.tag() != null) {
                Object object;
                Object object2;
                Object object3;
                SadeParser.TagContext tagContext = elementContext.tag();
                TagInfo tagInfo = this.collectTagInfo(tagContext);
                ArrayList<String> arrayList2 = new ArrayList<String>();
                while (i + 1 < list.size()) {
                    object3 = list.get(i + 1);
                    if (((SadeParser.ElementContext)((Object)object3)).text() != null) {
                        arrayList2.add((String)this.visit((ParseTree)((SadeParser.ElementContext)((Object)object3)).text()));
                        ++i;
                        continue;
                    }
                    if (((SadeParser.ElementContext)((Object)object3)).string() != null) {
                        arrayList2.add((String)this.visit((ParseTree)((SadeParser.ElementContext)((Object)object3)).string()));
                        ++i;
                        continue;
                    }
                    if (((SadeParser.ElementContext)((Object)object3)).raw() == null) break;
                    arrayList2.add((String)this.visit((ParseTree)((SadeParser.ElementContext)((Object)object3)).raw()));
                    ++i;
                }
                object3 = new ArrayList();
                if (tagContext.block() != null && arrayList2.isEmpty()) {
                    object3.addAll(this.processElements(tagContext.block().element(), false));
                }
                if (!tagInfo.suffixTags.isEmpty()) {
                    object2 = !arrayList2.isEmpty() ? arrayList2 : object3;
                    String string = this.buildSuffixChain(tagInfo.suffixTags, (List<String>)object2);
                    object = List.of(string);
                } else {
                    object = !arrayList2.isEmpty() ? arrayList2 : object3;
                }
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("[:tag \"").append(tagInfo.name).append("\" ");
                ((StringBuilder)object2).append(tagInfo.attrMap).append(" ");
                ((StringBuilder)object2).append("[");
                for (int j = 0; j < object.size(); ++j) {
                    ((StringBuilder)object2).append((String)object.get(j));
                    if (j + 1 >= object.size()) continue;
                    ((StringBuilder)object2).append(" ");
                }
                ((StringBuilder)object2).append("]]");
                arrayList.add(((StringBuilder)object2).toString());
                continue;
            }
            if (elementContext.text() != null) {
                if (bl) continue;
                arrayList.add((String)this.visit((ParseTree)elementContext.text()));
                continue;
            }
            if (elementContext.string() != null) {
                if (bl) continue;
                arrayList.add((String)this.visit((ParseTree)elementContext.string()));
                continue;
            }
            if (elementContext.raw() == null || bl) continue;
            arrayList.add((String)this.visit((ParseTree)elementContext.raw()));
        }
        return arrayList;
    }

    private String buildSuffixChain(List<String> list, List<String> list2) {
        String string = list2.isEmpty() ? "[]" : "[" + String.join((CharSequence)" ", list2) + "]";
        String string2 = null;
        Object object = string;
        for (int i = list.size() - 1; i >= 0; --i) {
            String string3 = list.get(i);
            string2 = "[:tag \"" + string3 + "\" {} " + (String)object + "]";
            object = "[" + string2 + "]";
        }
        return string2;
    }

    private TagInfo collectTagInfo(SadeParser.TagContext tagContext) {
        TagInfo tagInfo = new TagInfo();
        tagInfo.name = tagContext.IDENT().getText();
        String string = null;
        String string2 = null;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (Object object : tagContext.tagSuffix()) {
            if (object.idShort() != null) {
                string = object.idShort().IDENT().getText();
                continue;
            }
            if (object.tagCall() != null) {
                tagInfo.suffixTags.add(object.tagCall().IDENT().getText());
                continue;
            }
            if (object.attrs() == null) continue;
            for (SadeParser.AttrContext attrContext : object.attrs().attr()) {
                String string3 = attrContext.IDENT().getText();
                String string4 = (String)this.visit((ParseTree)attrContext.value());
                if (string3.equals("class")) {
                    string2 = string4;
                    continue;
                }
                linkedHashMap.put(string3, string4);
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (string != null) {
            stringBuilder.append(":id \"" + string + "\" ");
        }
        if (string2 != null) {
            stringBuilder.append(":class " + string2 + " ");
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            stringBuilder.append(":" + (String)entry.getKey() + " " + (String)entry.getValue() + " ");
        }
        stringBuilder.append("}");
        tagInfo.attrMap = stringBuilder.toString();
        return tagInfo;
    }

    @Override
    public String visitText(SadeParser.TextContext textContext) {
        return "\"" + textContext.getText() + "\"";
    }

    @Override
    public String visitString(SadeParser.StringContext stringContext) {
        return stringContext.STRING().getText();
    }

    @Override
    public String visitRaw(SadeParser.RawContext rawContext) {
        String string = rawContext.getText().replace("\"", "\\\"");
        return "[:raw \"" + string + "\"]";
    }

    @Override
    public String visitValue(SadeParser.ValueContext valueContext) {
        if (valueContext.IDENT() != null) {
            return "\"" + valueContext.IDENT().getText() + "\"";
        }
        if (valueContext.TEXT() != null) {
            return "\"" + valueContext.TEXT().getText() + "\"";
        }
        if (valueContext.STRING() != null) {
            return valueContext.STRING().getText();
        }
        if (valueContext.array() != null) {
            return (String)this.visit((ParseTree)valueContext.array());
        }
        return "\"\"";
    }

    @Override
    public String visitArray(SadeParser.ArrayContext arrayContext) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SadeParser.ValueContext valueContext : arrayContext.value()) {
            arrayList.add((String)this.visit((ParseTree)valueContext));
        }
        return "[" + String.join((CharSequence)" ", arrayList) + "]";
    }

    private static class TagInfo {
        String name;
        String attrMap;
        List<String> suffixTags = new ArrayList<String>();

        private TagInfo() {
        }
    }
}

