(ns sade.cli
  (:require [clojure.edn :as edn]
            [sade.parser :as parser]
            [sade.core :as core])
  (:gen-class))

(defn -main [& args]
  (let [opts (set args)
        input (slurp *in*)
        ast (if (or (opts "-V") (opts "--vector"))
              ;; ベクタデータをそのまま読む
              (edn/read-string input)
              ;; sade DSL を ANTLR でパース
              (parser/parse-sade input))
        html (core/render-document ast)]
    (println html)))

