/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.utils;

import io.slingr.services.utils.Json;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Strings {
    private static final Logger logger = LoggerFactory.getLogger(Strings.class);

    public static UUID randomUUID() {
        return UUID.randomUUID();
    }

    public static String randomUUIDString() {
        return Strings.randomUUID().toString();
    }

    public static String randomAlphabetic(int count) {
        return RandomStringUtils.randomAlphabetic((int)count);
    }

    public static String randomAlphanumeric(int count) {
        return RandomStringUtils.randomAlphanumeric((int)count);
    }

    public static byte[] readBytes(InputStream inputStream) {
        try {
            return IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (IOException e) {
            logger.warn("Error parsing JSON from input stream", (Throwable)e);
            return null;
        }
    }

    public static String readAsString(InputStream inputStream) {
        return Strings.readAsString(inputStream, StandardCharsets.UTF_8);
    }

    public static String readAsString(InputStream inputStream, Charset encoding) {
        try {
            return IOUtils.toString((InputStream)inputStream, (Charset)encoding);
        }
        catch (IOException e) {
            logger.warn("Error getting string from input stream", (Throwable)e);
            return null;
        }
    }

    public static InputStream readAsInputStream(String string) {
        if (string == null) {
            string = "";
        }
        return new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
    }

    public static String maskToken(String string) {
        if (string == null) {
            return "-";
        }
        Object maskedToken = StringUtils.repeat((String)".", (int)string.length());
        if (((String)maskedToken).length() > 20) {
            maskedToken = string.substring(0, 4) + ((String)maskedToken).substring(8) + string.substring(string.length() - 4);
        } else if (((String)maskedToken).length() > 10) {
            maskedToken = string.substring(0, 2) + ((String)maskedToken).substring(4) + string.substring(string.length() - 2);
        }
        return maskedToken;
    }

    public static Json parseQueryString(String queryString) {
        return Strings.parseQueryString(queryString, true);
    }

    public static Json parseQueryString(String queryString, boolean includeKeyWithoutValues) {
        String[] pm;
        Json parameters = Json.map();
        if (StringUtils.isNotBlank((CharSequence)queryString) && (pm = queryString.split("&")).length > 0) {
            for (String p : pm) {
                int i = (p = p.trim()).indexOf("=");
                if (i > 0 && i + 1 < p.length()) {
                    String k = p.substring(0, i);
                    if (!StringUtils.isNotBlank((CharSequence)k)) continue;
                    parameters.set(k.trim(), p.substring(i + 1).trim());
                    continue;
                }
                if (!includeKeyWithoutValues || !StringUtils.isNotBlank((CharSequence)p)) continue;
                parameters.set(p, "true");
            }
        }
        return parameters;
    }

    public static List<String> urlEncode(List<String> parameters) {
        return parameters.stream().map(Strings::urlEncode).collect(Collectors.toList());
    }

    public static String urlEncode(String string) {
        try {
            return Strings.urlEncode(string, false);
        }
        catch (Exception ex) {
            logger.warn(String.format("Error when try to encode string [%s]: %s", string, ex.getMessage()));
            return "";
        }
    }

    public static String urlEncode(String string, boolean throwExceptionOnError) {
        if (StringUtils.isNotBlank((CharSequence)string)) {
            try {
                return URLEncoder.encode(string, StandardCharsets.UTF_8).replace("+", "%20").replace("*", "%2A");
            }
            catch (Exception ex) {
                if (throwExceptionOnError) {
                    throw ex;
                }
                logger.warn(String.format("Error when try to encode string [%s]: %s", string, ex.getMessage()));
                return string;
            }
        }
        return "";
    }

    public static String urlDecode(String string) {
        try {
            return Strings.urlDecode(string, false);
        }
        catch (Exception ex) {
            logger.warn(String.format("Error when try to decode string: %s", ex.getMessage()));
            Object[] objectArray = new Object[1];
            objectArray[0] = string != null ? (string.length() < 500 ? string : string.substring(497) + "...") : "-";
            logger.debug(String.format("String to decode: %s", objectArray));
            return "";
        }
    }

    public static String urlDecode(String string, boolean throwExceptionOnError) {
        if (StringUtils.isNotBlank((CharSequence)string)) {
            try {
                return URLDecoder.decode(string, StandardCharsets.UTF_8);
            }
            catch (Exception ex) {
                if (throwExceptionOnError) {
                    throw ex;
                }
                logger.warn(String.format("Error when try to decode string: %s", ex.getMessage()));
                logger.debug(String.format("String to decode: %s", string.length() < 500 ? string : string.substring(497) + "..."));
                return string;
            }
        }
        return "";
    }
}

