/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.utils.converters;

import io.slingr.services.utils.EmailUtils;
import io.slingr.services.utils.Json;
import io.slingr.services.utils.Strings;
import io.slingr.services.utils.XmlUtils;
import io.slingr.services.utils.converters.ContentTypeFormat;
import io.slingr.services.utils.converters.JsonSource;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.mail.Multipart;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonConverter {
    private static final Logger logger = LoggerFactory.getLogger(JsonConverter.class);

    public static Json fromObject(Object message) {
        try {
            return JsonConverter.baseFromObject(message);
        }
        catch (Exception ex) {
            logger.error("Error parsing JSON from input stream", (Throwable)ex);
            return JsonConverter.fromString("{ \"error\":\"" + ex + "\"}");
        }
    }

    public static Json baseFromObject(Object message) {
        return JsonConverter.baseFromObject(message, true);
    }

    public static Json baseFromObject(Object message, boolean showErrors) {
        if (message == null) {
            return Json.map();
        }
        if (message instanceof Json) {
            return JsonConverter.fromJson((Json)message);
        }
        if (message instanceof JsonSource) {
            return JsonConverter.fromJsonSource((JsonSource)message);
        }
        if (message instanceof Map) {
            return JsonConverter.fromMap((Map)message);
        }
        if (message instanceof List) {
            return JsonConverter.fromList((List)message);
        }
        if (message instanceof InputStream) {
            return JsonConverter.fromInputStream((InputStream)message);
        }
        if (message instanceof Multipart) {
            return JsonConverter.fromMultipart((Multipart)message);
        }
        return JsonConverter.fromString(message.toString(), showErrors);
    }

    public static Json fromJson(Json message) {
        if (message == null) {
            return Json.map();
        }
        return message;
    }

    public static Json fromJsonSource(JsonSource message) {
        if (message == null) {
            return Json.map();
        }
        return message.toJson();
    }

    public static Json fromMap(Map message) {
        if (message == null) {
            return Json.map();
        }
        return Json.fromMap(message);
    }

    public static Json fromList(List message) {
        if (message == null) {
            return Json.list();
        }
        return Json.fromList(message);
    }

    private static Json fromString(String message) {
        return JsonConverter.fromString(message, true);
    }

    private static Json fromString(String message, boolean showErrors) {
        return Json.parse(message, showErrors);
    }

    public static Json fromInputStream(InputStream is) {
        String value = Strings.readAsString(is);
        if (value != null) {
            return JsonConverter.convertString(value);
        }
        return null;
    }

    public static Json fromMultipart(Multipart multipart) {
        return EmailUtils.convertMultipart(multipart);
    }

    public static Json convertString(String value) {
        return JsonConverter.convertString(value, (String)null);
    }

    public static Json convertString(String value, Json headers) {
        String contentType = null;
        if (headers != null) {
            contentType = headers.string("Content-Type");
        }
        return JsonConverter.convertString(value, contentType);
    }

    public static Json convertString(String value, Map<String, Object> headers) {
        Object contentTypeObject;
        String contentType = null;
        if (headers != null && (contentTypeObject = headers.get("Content-Type")) instanceof String) {
            contentType = (String)contentTypeObject;
        }
        return JsonConverter.convertString(value, contentType);
    }

    public static Json convertString(String value, String contentType) {
        return JsonConverter.convertString(value, contentType, true);
    }

    public static Json convertString(String value, String contentType, boolean showErrors) {
        Json response;
        block30: {
            response = null;
            if (StringUtils.isNotBlank((CharSequence)contentType)) {
                if (ContentTypeFormat.isJsonContentType(contentType)) {
                    try {
                        response = Json.parse(value);
                    }
                    catch (Exception e) {
                        if (showErrors) {
                            logger.warn(String.format("Error parsing JSON from input stream [%s]", value));
                        }
                        return null;
                    }
                } else if (ContentTypeFormat.isUrlEncodedFormContentType(contentType)) {
                    try {
                        response = JsonConverter.convertFormToJson(value);
                    }
                    catch (Exception e) {
                        if (showErrors) {
                            logger.warn(String.format("Error parsing JSON from URL encoded form [%s]", value));
                        }
                        return null;
                    }
                } else if (ContentTypeFormat.isXmlContentType(contentType)) {
                    try {
                        response = XmlUtils.xmlToJson(value);
                    }
                    catch (Exception e) {
                        if (showErrors) {
                            logger.warn(String.format("Error parsing JSON from XML document [%s]", value));
                        }
                        return null;
                    }
                } else if (ContentTypeFormat.isPlainTextContentType(contentType)) {
                    if (StringUtils.isNotEmpty((CharSequence)value) && (value.startsWith("{") || value.startsWith("["))) {
                        try {
                            response = Json.parse(value);
                        }
                        catch (Exception e) {
                            response = Json.map().set("body", StringUtils.isNotEmpty((CharSequence)value) ? value : "");
                        }
                    } else {
                        response = Json.map().set("body", StringUtils.isNotEmpty((CharSequence)value) ? value : "");
                    }
                } else if (ContentTypeFormat.isHtmlContentType(contentType)) {
                    response = Json.map().set("body", StringUtils.isNotEmpty((CharSequence)value) ? value : "");
                }
            }
            if (response == null) {
                try {
                    response = Json.parse(value, showErrors);
                }
                catch (Exception ex) {
                    try {
                        response = XmlUtils.xmlToJson(value);
                    }
                    catch (Exception e2) {
                        try {
                            response = JsonConverter.convertFormToJson(value, showErrors);
                        }
                        catch (Exception ex3) {
                            if (!showErrors) break block30;
                            logger.warn(String.format("Error parsing JSON from input stream [%s]", value));
                        }
                    }
                }
            }
        }
        return response;
    }

    public static Json convertFormToJson(String value) {
        return JsonConverter.convertFormToJson(value, true);
    }

    public static Json convertFormToJson(String value, boolean showErrors) {
        String[] parameters;
        if (StringUtils.isBlank((CharSequence)value)) {
            return Json.map();
        }
        Json response = Json.map();
        Json parametersError = Json.list();
        for (String parameter : parameters = value.split("&")) {
            try {
                String[] parts = Strings.urlDecode(parameter).split("=", 2);
                if (parts.length <= 1) continue;
                Object val = JsonConverter.parse(parts[1]);
                if (parts[0].contains("[")) {
                    String[] ks = parts[0].split("[\\[\\]]+");
                    ArrayList<String> keys = new ArrayList<String>(Arrays.asList(ks));
                    JsonConverter.setInternalValue(response, keys, val);
                    continue;
                }
                response.set(parts[0], val);
            }
            catch (Exception ex) {
                if (showErrors) {
                    logger.warn(String.format("Exception when try to parse parameter from form: %s", ex.getMessage()), (Throwable)ex);
                }
                parametersError.push(parameter);
            }
        }
        response.setIfNotEmpty("nonParsableParameters", parametersError);
        return response;
    }

    private static Json setInternalValue(Json parent, List<String> keys, Object value) {
        if (parent == null || keys == null || keys.isEmpty() || value == null) {
            return parent;
        }
        if (keys.size() == 1) {
            parent.set(keys.get(0), value);
        } else {
            String key = keys.remove(0);
            Json current = parent.json(key);
            if (current == null) {
                current = Json.map();
            }
            current = JsonConverter.setInternalValue(current, keys, value);
            parent.setIfNotNull(key, current);
        }
        return parent;
    }

    private static Object parse(String value) {
        if (value != null) {
            try {
                Json response = Json.fromObject(value, true, true);
                return Objects.requireNonNullElse(response, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }
}

