/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.services;

import io.slingr.services.exceptions.ErrorCode;
import io.slingr.services.exceptions.ServiceException;
import io.slingr.services.services.ExtensionBroker;
import io.slingr.services.services.ExtensionBrokerApi;
import io.slingr.services.services.rest.DownloadedFile;
import io.slingr.services.utils.Base64Utils;
import io.slingr.services.utils.Json;
import io.slingr.services.utils.Strings;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Files {
    private static final Logger logger = LoggerFactory.getLogger(Files.class);
    private final ExtensionBrokerApi api;
    private final boolean debug;

    public Files(ExtensionBrokerApi api, boolean debug) {
        this.api = api;
        this.debug = debug;
    }

    public Json upload(String filename, String content, String contentType, boolean base64) throws ServiceException {
        ExtensionBroker.isNotBlank(content, "empty file content");
        try {
            byte[] byteContent;
            if (base64) {
                content = content.replace(" ", "+");
                byteContent = Base64Utils.decodeData(content.getBytes());
            } else {
                byteContent = content.getBytes();
            }
            return this.upload(filename, new ByteArrayInputStream(byteContent), contentType);
        }
        catch (ServiceException rex) {
            throw rex;
        }
        catch (Exception ex) {
            throw ServiceException.retryable(ErrorCode.CLIENT, (Object)String.format("Exception when try to upload file [%s]: %s", filename, ex.getMessage()), ex);
        }
    }

    public Json upload(String filename, InputStream content, String contentType) throws ServiceException {
        ExtensionBroker.isNotBlank(filename, "empty file name");
        ExtensionBroker.isNotNull(content, "empty file content");
        if (this.debug) {
            logger.info(String.format("%s uploading file [%s] to application.", "DEBUG>", filename));
        }
        try {
            Json response = this.api.uploadFile(filename, content, contentType);
            if (this.debug) {
                logger.info(String.format("%s file [%s] uploaded to application - file id [%s]", "DEBUG>", filename, response.string("fileId")));
            }
            return response;
        }
        catch (ServiceException rex) {
            throw rex;
        }
        catch (Exception ex) {
            throw ServiceException.retryable(ErrorCode.CLIENT, (Object)String.format("Exception when try to upload file [%s]: %s", filename, ex.getMessage()), ex);
        }
    }

    public Json upload(String filename, DownloadedFile file) throws ServiceException {
        ExtensionBroker.isNotBlank(filename, "empty file name");
        ExtensionBroker.isNotNull(file, "empty downloaded file");
        try {
            String ct;
            String contentType = "";
            if (file.headers() != null && StringUtils.isNotBlank((CharSequence)(ct = file.headers().string("Content-Type")))) {
                contentType = ct;
            }
            return this.upload(filename, file.file(), contentType);
        }
        catch (ServiceException rex) {
            throw rex;
        }
        catch (Exception ex) {
            throw ServiceException.retryable(ErrorCode.CLIENT, (Object)String.format("Exception when try to upload file [%s]: %s", filename, ex.getMessage()), ex);
        }
    }

    public String download(String fileId, boolean base64) throws ServiceException {
        try {
            DownloadedFile response = this.download(fileId);
            return this.extractContent(response, base64);
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ServiceException.permanent(ErrorCode.CLIENT, (Object)String.format("Exception when try to download file [%s] - Exception [%s]", fileId, ex.getMessage()), ex);
        }
    }

    public DownloadedFile download(String fileId) throws ServiceException {
        ExtensionBroker.isNotBlank(fileId, "empty file id");
        if (this.debug) {
            logger.info(String.format("%s downloading file [%s] from application.", "DEBUG>", fileId));
        }
        try {
            DownloadedFile response = this.api.downloadFile(fileId);
            if (response == null || response.file() == null) {
                throw ServiceException.permanent(ErrorCode.CLIENT, String.format("File [%s] not found on application.", fileId));
            }
            if (this.debug) {
                logger.info(String.format("%s file [%s] downloaded from application.", "DEBUG>", fileId));
            }
            return response;
        }
        catch (ServiceException rex) {
            throw rex;
        }
        catch (Exception ex) {
            throw ServiceException.retryable(ErrorCode.CLIENT, (Object)String.format("Exception when try to download file [%s]: %s", fileId, ex.getMessage()), ex);
        }
    }

    public String extractContent(DownloadedFile fileDownloaded, boolean base64) throws ServiceException {
        ExtensionBroker.isNotNull(fileDownloaded, "Invalid file");
        ExtensionBroker.isNotNull(fileDownloaded.file(), "Empty file content");
        try {
            if (base64) {
                return Base64Utils.encode(fileDownloaded.file());
            }
            return Strings.readAsString(fileDownloaded.file());
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ServiceException.permanent(ErrorCode.CLIENT, (Object)String.format("Exception when try to convert downloaded file - Exception [%s]", ex.getMessage()), ex);
        }
    }

    public Json metadata(String fileId) throws ServiceException {
        ExtensionBroker.isNotBlank(fileId, "empty file id");
        if (this.debug) {
            logger.info(String.format("%s getting file [%s] metadata from application.", "DEBUG>", fileId));
        }
        try {
            Json response = this.api.getFileMetadata(fileId);
            if (this.debug) {
                logger.info(String.format("%s file [%s] metadata received from application - name [%s]", "DEBUG>", fileId, response.string("fileName")));
            }
            return response;
        }
        catch (ServiceException rex) {
            throw rex;
        }
        catch (Exception ex) {
            throw ServiceException.retryable(ErrorCode.CLIENT, (Object)String.format("Exception when try to download file [%s]: %s", fileId, ex.getMessage()), ex);
        }
    }
}

