/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.ws.exchange;

import io.slingr.services.utils.Json;
import io.slingr.services.utils.converters.JsonSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionRequest
implements JsonSource {
    private static final Logger logger = LoggerFactory.getLogger(FunctionRequest.class);
    private final Json request;
    private final boolean redelivered;
    private final int redeliveredCounter;
    private final int redeliveredMaxCounter;

    public FunctionRequest(Object request) {
        this(request, false, 1, 1);
    }

    public FunctionRequest(Object request, boolean redelivered, int redeliveredCounter, int redeliveredMaxCounter) {
        Json body = null;
        if (request != null && (body = FunctionRequest.convertRequest(request, false)) != null && body.isMap() && body.contains("__request_params__")) {
            body = FunctionRequest.convertRequest(body.object("__request_params__"), true);
        }
        if (body == null) {
            body = Json.map();
        }
        this.request = body;
        this.redelivered = redelivered;
        this.redeliveredCounter = Math.max(redeliveredCounter, 0);
        this.redeliveredMaxCounter = Math.max(redeliveredMaxCounter, 0);
    }

    private static Json convertRequest(Object request, boolean isWrapped) {
        Json body = null;
        if (request instanceof Json) {
            body = (Json)request;
        } else if (request instanceof JsonSource) {
            body = ((JsonSource)request).toJson();
        } else {
            try {
                body = Json.fromObject(request);
            }
            catch (Exception ex) {
                if (isWrapped) {
                    logger.info(String.format("Wrapped request of function is not a Json object [%s]: %s", request.toString(), ex.getMessage()));
                }
                logger.info(String.format("Body of function request is not a Json object [%s]: %s", request.toString(), ex.getMessage()));
            }
        }
        return body;
    }

    public Json getRequest() {
        return this.request;
    }

    public Object getParams() {
        return this.request.object("params");
    }

    public Json getJsonParams() {
        Object bd = this.getParams();
        if (bd == null) {
            return Json.map();
        }
        if (bd instanceof Json) {
            return (Json)bd;
        }
        return Json.fromObject(bd);
    }

    public long getDate() {
        Long value = this.request.longInteger("date");
        if (value == null) {
            value = 0L;
        }
        return value;
    }

    public String getFunctionName() {
        return this.request.string("function");
    }

    public String getFunctionId() {
        return this.request.string("id");
    }

    public String getUserId() {
        return this.request.string("userId");
    }

    public String getUserEmail() {
        return this.request.string("userEmail");
    }

    public boolean isRedelivered() {
        return this.redelivered;
    }

    public int getRedeliveredCounter() {
        return this.redeliveredCounter;
    }

    public int getRedeliveredMaxCounter() {
        return this.redeliveredMaxCounter;
    }

    public String getApp() {
        return this.request.string("app");
    }

    public String getEnv() {
        return this.request.string("env");
    }

    @Override
    public Json toJson() {
        return Json.map().set("date", this.getDate()).setIfNotEmpty("function", this.getFunctionName()).setIfNotEmpty("id", this.getFunctionId()).setIfNotEmpty("params", this.getParams()).setIfNotEmpty("userId", this.getUserId()).setIfNotEmpty("userEmail", this.getUserEmail());
    }

    public String toString() {
        return this.toJson().toString();
    }
}

