/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.services.rest;

import io.slingr.services.exceptions.ServiceException;
import io.slingr.services.services.rest.DownloadedFile;
import io.slingr.services.services.rest.RestClient;
import io.slingr.services.services.rest.RestClientFactory;
import io.slingr.services.utils.Json;
import java.io.InputStream;
import javax.ws.rs.client.WebTarget;

public class RestClientBuilder
extends RestClient {
    RestClientBuilder(String apiUri, RestClientFactory factory) throws ServiceException {
        super(apiUri, factory);
    }

    public RestClientBuilder header(String name, Object value) {
        super.setupDefaultHeader(name, value);
        return this;
    }

    public RestClientBuilder parameter(String name, String value) {
        super.setupDefaultParam(name, value);
        return this;
    }

    public RestClientBuilder path(String path) {
        super.setPath(path);
        return this;
    }

    public RestClientBuilder connectionTimeout(Integer connectionTimeout) {
        this.setConnectionTimeout(connectionTimeout);
        return this;
    }

    public RestClientBuilder readTimeout(Integer readTimeout) {
        this.setReadTimeout(readTimeout);
        return this;
    }

    public RestClientBuilder followRedirects(Boolean followRedirects) {
        super.setFollowRedirects(followRedirects);
        return this;
    }

    public RestClientBuilder emptyPath(String defaultEmptyPath) {
        this.setDefaultEmptyPath(defaultEmptyPath);
        return this;
    }

    public RestClientBuilder allowExternalUrl(boolean allowExternalUrl) {
        this.setAllowExternalUrl(allowExternalUrl);
        return this;
    }

    public RestClientBuilder uploadParameter(String uploadParameter) {
        this.setUploadParameter(uploadParameter);
        return this;
    }

    public RestClientBuilder uploadBody(String uploadBody) {
        this.setUploadBody(uploadBody);
        return this;
    }

    public RestClientBuilder disableSslOptions() {
        this.setDisabledSslOptions();
        return this;
    }

    public RestClientBuilder basicAuthentication(String username, String password) {
        this.setupBasicAuthentication(username, password);
        return this;
    }

    public RestClientBuilder digestAuthentication(String username, String password) {
        this.setupDigestAuthentication(username, password);
        return this;
    }

    public RestClientBuilder basicAuthenticationHeader(String username, String password) {
        this.setupBasicAuthenticationHeader(username, password);
        return this;
    }

    public RestClientBuilder basicAuthenticationHeader(String authorizationToken) {
        this.setupBasicAuthenticationHeader(authorizationToken);
        return this;
    }

    public RestClientBuilder bearerAuthenticationHeader(String username, String password) {
        this.setupBearerAuthenticationHeader(username, password);
        return this;
    }

    public RestClientBuilder bearerAuthenticationHeader(String authorizationToken) {
        this.setupBearerAuthenticationHeader(authorizationToken);
        return this;
    }

    public RestClientBuilder authenticationHeader(String type, String username, String password) {
        this.setupAuthenticationHeader(type, username, password);
        return this;
    }

    public RestClientBuilder authenticationHeader(String type, String authorizationToken) {
        this.setupAuthenticationHeader(type, authorizationToken);
        return this;
    }

    @Override
    public Json get() throws ServiceException {
        return super.get();
    }

    @Override
    public Json post() throws ServiceException {
        return super.post();
    }

    public Json post(Json content) throws ServiceException {
        return super.post(content);
    }

    @Override
    public Json put() throws ServiceException {
        return super.put();
    }

    public Json put(Json content) throws ServiceException {
        return super.put(content);
    }

    @Override
    public Json patch() throws ServiceException {
        return super.patch();
    }

    public Json patch(Json content) throws ServiceException {
        return super.patch(content);
    }

    @Override
    public Json delete() throws ServiceException {
        return super.delete();
    }

    @Override
    public Json options() throws ServiceException {
        return super.options();
    }

    @Override
    public DownloadedFile download() throws ServiceException {
        return super.download();
    }

    @Override
    public Json upload(InputStream inputStream, String filename, String contentType) throws ServiceException {
        return super.upload(inputStream, filename, contentType);
    }

    public WebTarget target() {
        return this.getApiTarget();
    }
}

