/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.framework.annotations.classes;

import io.slingr.services.framework.annotations.ServiceProperty;
import io.slingr.services.framework.annotations.classes.AccessorType;
import io.slingr.services.framework.annotations.classes.PropertyType;
import io.slingr.services.framework.annotations.classes.SettableProperty;
import io.slingr.services.framework.annotations.processor.AnnotationsUtils;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import org.apache.commons.lang3.StringUtils;

public class ClassProperty
implements SettableProperty {
    public static final String SP_NAME = ServiceProperty.class.getSimpleName();
    public static final String NULL_DEFAULT_VALUE = "----NULL----";
    private final String simpleName;
    private final String name;
    private PropertyType type;
    private final String defaultValue;
    private final AccessorType accessorType;
    private final String accessor;
    private final boolean isServiceConfiguration;

    public ClassProperty(Element sPropertyElement, boolean isServiceConfiguration) throws IllegalArgumentException {
        this(sPropertyElement, sPropertyElement.getAnnotation(ServiceProperty.class), isServiceConfiguration);
    }

    private ClassProperty(Element sPropertyElement, ServiceProperty annotation, boolean isServiceConfiguration) throws IllegalArgumentException {
        this(sPropertyElement, annotation != null ? annotation.name() : null, annotation != null ? annotation.defaultValue() : null, isServiceConfiguration);
    }

    public ClassProperty(Element sPropertyElement, String propertyName, String propertyDefaultValue, boolean isServiceConfiguration) throws IllegalArgumentException {
        Object dv;
        this.isServiceConfiguration = isServiceConfiguration;
        VariableElement annotatedElement = (VariableElement)sPropertyElement;
        this.simpleName = annotatedElement.getSimpleName().toString().trim();
        this.name = StringUtils.isNotBlank((CharSequence)propertyName) ? propertyName : this.simpleName;
        AnnotationsUtils.checkNotEmpty(this.name, "name", SP_NAME, "property", this.name);
        String setterName = String.format("set%S%s", Character.valueOf(this.simpleName.charAt(0)), this.simpleName.length() > 1 ? this.simpleName.substring(1) : "");
        this.type = AnnotationsUtils.isValidSetter(null, annotatedElement, this.simpleName, setterName, this.isServiceConfiguration);
        if (!(this.isServiceConfiguration || this.type != PropertyType.BOOLEAN && this.type != PropertyType.STRING && this.type != PropertyType.JSON)) {
            this.accessorType = AccessorType.SETTER;
            this.accessor = setterName;
        } else if (this.isServiceConfiguration && this.type == PropertyType.CONFIG) {
            this.accessorType = AccessorType.SETTER;
            this.accessor = setterName;
        } else {
            this.accessor = this.simpleName;
            this.type = AnnotationsUtils.isValidProperty(null, annotatedElement, this.simpleName, this.accessor, this.isServiceConfiguration);
            if (this.type == null || this.type == PropertyType.OTHER) {
                throw new IllegalStateException(String.format("ServiceProperty [%s] is not valid", this.getName()));
            }
            this.accessorType = annotatedElement.getModifiers().contains((Object)Modifier.PRIVATE) || annotatedElement.getModifiers().contains((Object)Modifier.PROTECTED) ? AccessorType.REFLECTION : AccessorType.PROPERTY;
        }
        AnnotationsUtils.checkNotNull((Object)this.type, "type", SP_NAME, "property", this.name);
        Object object = dv = StringUtils.isNotBlank((CharSequence)propertyDefaultValue) ? propertyDefaultValue : "";
        if (((String)dv).equals(NULL_DEFAULT_VALUE)) {
            dv = null;
        } else if (this.type == PropertyType.BOOLEAN) {
            dv = "" + Boolean.parseBoolean((String)dv);
        }
        this.defaultValue = dv;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getAccessor() {
        return this.accessor;
    }

    @Override
    public AccessorType getAccessorType() {
        return this.accessorType;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public PropertyType getType() {
        return this.type;
    }

    public boolean isServiceConfiguration() {
        return this.isServiceConfiguration;
    }
}

