/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.framework;

import io.slingr.services.configurations.Configuration;
import io.slingr.services.configurations.ServiceDefinitions;
import io.slingr.services.configurations.ServicesProperties;
import io.slingr.services.exceptions.ErrorCode;
import io.slingr.services.exceptions.ServiceException;
import io.slingr.services.framework.IBaseService;
import io.slingr.services.framework.IService;
import io.slingr.services.framework.RegisteredFunction;
import io.slingr.services.framework.RegisteredWebService;
import io.slingr.services.framework.ServiceLifecycleListener;
import io.slingr.services.framework.annotations.classes.FunctionResponseType;
import io.slingr.services.framework.annotations.classes.MethodAccessorType;
import io.slingr.services.framework.annotations.classes.MethodParameterType;
import io.slingr.services.framework.annotations.classes.WebServiceResponseType;
import io.slingr.services.services.AppLogs;
import io.slingr.services.services.AppUsers;
import io.slingr.services.services.DataStores;
import io.slingr.services.services.EBConfigurations;
import io.slingr.services.services.Events;
import io.slingr.services.services.ExtensionBroker;
import io.slingr.services.services.ExtensionBrokerApi;
import io.slingr.services.services.Files;
import io.slingr.services.services.Locks;
import io.slingr.services.services.Management;
import io.slingr.services.services.datastores.DataStore;
import io.slingr.services.services.logs.ServiceLayout;
import io.slingr.services.utils.Json;
import io.slingr.services.utils.tests.ExtensionBrokerMock;
import io.slingr.services.ws.WebServices;
import io.slingr.services.ws.WebServicesProcessor;
import io.slingr.services.ws.exchange.FunctionRequest;
import io.slingr.services.ws.exchange.WebServiceRequest;
import io.slingr.services.ws.exchange.WebServiceResponse;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseModule
implements IService,
IBaseService {
    private static final Logger logger = LoggerFactory.getLogger(BaseModule.class);
    private IService service = null;
    private ServicesProperties properties = null;
    private ServiceDefinitions definitions = null;
    private WebServices webServicesServer = null;
    private final List<ServiceLifecycleListener> systemLifecycleListeners = new ArrayList<ServiceLifecycleListener>();
    private final List<ServiceLifecycleListener> lifecycleListeners = new ArrayList<ServiceLifecycleListener>();
    private ExtensionBrokerApi extensionBroker;
    private Events events;
    private AppLogs appLogs;
    private Locks locks;
    private Files files;
    private DataStores dataStores;
    private EBConfigurations configurations;
    private AppUsers appUsers;
    private Management management;
    private final Map<String, Method> declaredMethodsCache = Collections.synchronizedMap(new HashMap());
    private final Map<String, RegisteredFunction> functions = new HashMap<String, RegisteredFunction>();
    private final ReentrantReadWriteLock functionsLock = new ReentrantReadWriteLock();
    private final List<RegisteredWebService> webServices = new ArrayList<RegisteredWebService>();
    private final ReentrantReadWriteLock webServicesLock = new ReentrantReadWriteLock();
    private final ReentrantLock configureLock = new ReentrantLock();
    private final AtomicBoolean starting = new AtomicBoolean(false);
    private final AtomicBoolean configured = new AtomicBoolean(false);
    private final AtomicBoolean extensionBrokerApiConfigured = new AtomicBoolean(false);
    private final AtomicBoolean webServicesConfigured = new AtomicBoolean(false);
    private final AtomicBoolean enabledConfiguratorInterceptor = new AtomicBoolean(false);
    private final AtomicBoolean enabledFunctionInterceptor = new AtomicBoolean(false);

    void addSystemLifecycleListener(ServiceLifecycleListener listener) {
        if (listener != null && !this.lifecycleListeners.contains(listener) && !this.systemLifecycleListeners.contains(listener)) {
            this.systemLifecycleListeners.add(listener);
        }
    }

    public void addLifecycleListener(ServiceLifecycleListener listener) {
        if (listener != null && !this.lifecycleListeners.contains(listener) && !this.systemLifecycleListeners.contains(listener)) {
            this.lifecycleListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void configure(String propertyFile, IService service) {
        this.configureLock.lock();
        try {
            Object configuration;
            if (!this.starting.get()) {
                if (service == null) {
                    throw new IllegalArgumentException("Invalid service object");
                }
                this.service = service;
                if (StringUtils.isBlank((CharSequence)propertyFile)) {
                    logger.info(String.format("Configuring service [%s]...", service.getClass().getSimpleName()));
                } else {
                    logger.info(String.format("Configuring service [%s] from [%s]...", service.getClass().getSimpleName(), propertyFile));
                }
                this.starting.set(true);
            }
            if (!this.configured.get()) {
                configuration = new Configuration(propertyFile);
                this.definitions = ((Configuration)configuration).definitions();
                this.properties = ((Configuration)configuration).properties();
                this.configured.set(true);
                ServiceLayout.setApplication(this.properties.getApplicationName());
                ServiceLayout.setEnvironment(this.properties.getEnvironment());
                ServiceLayout.setService(this.properties.getServiceName());
                ServiceLayout.setPodId(this.properties.getPodId());
                ServiceLayout.setComponent(String.format("service-%s", this.definitions().getType()));
                if (this.properties().isLocalDeployment()) {
                    ServiceLayout.setDeployment("local");
                } else {
                    ServiceLayout.setDeployment("cloud");
                }
                logger.info(String.format("Starting service [%s][%s][%s]", this.properties.getApplicationName(), this.properties.getEnvironment(), this.properties.getServiceName()));
                if (this.properties.isDebug()) {
                    logger.info(String.format("%s --------------", "DEBUG>"));
                    logger.info(String.format("%s Definitions: %s", "DEBUG>", this.definitions.toJson()));
                    logger.info(String.format("%s Properties: %s", "DEBUG>", this.properties.toJson()));
                }
                for (ServiceLifecycleListener listener : this.systemLifecycleListeners) {
                    listener.serviceConfigured();
                }
                for (ServiceLifecycleListener listener : this.lifecycleListeners) {
                    listener.serviceConfigured();
                }
                if (this.properties.isDebug()) {
                    logger.info(String.format("%s --------------", "DEBUG>"));
                }
            }
            if (!this.extensionBrokerApiConfigured.get()) {
                if (!this.properties.isTestingMode()) {
                    this.extensionBroker = new ExtensionBroker(this.properties.getServicesApi(), this.properties.getToken(), this.properties.getServicesApiVersion());
                } else {
                    logger.info(String.format("%s --------------", "TEST>"));
                    logger.info(String.format("%s Testing mode ", "TEST>"));
                    this.extensionBroker = new ExtensionBrokerMock();
                    logger.info(String.format("%s --------------", "TEST>"));
                }
                this.events = new Events(this.extensionBroker, this.properties.isDebug());
                this.appLogs = new AppLogs(this.extensionBroker, this.properties.isDebug());
                this.locks = new Locks(this.extensionBroker, this.properties.isDebug());
                this.files = new Files(this.extensionBroker, this.properties.isDebug());
                this.dataStores = new DataStores(this.extensionBroker, this.definitions.getDataStoresNames(), this.properties.isDebug());
                this.configurations = new EBConfigurations(this.extensionBroker, this.properties.isDebug());
                this.appUsers = new AppUsers(this.extensionBroker, this.properties.isDebug());
                this.management = new Management(this.extensionBroker);
                this.extensionBrokerApiConfigured.set(true);
                logger.info("Checking Extension Broker connection...");
                try {
                    configuration = this.extensionBroker.getConfiguration();
                    if (configuration != null) {
                        boolean usingProxy = ((Json)configuration).is("proxy", false);
                        this.properties().setUsingProxy(usingProxy);
                        String webServiceUri = ((Json)configuration).string("webServiceUri");
                        if (StringUtils.isNotBlank((CharSequence)webServiceUri)) {
                            this.properties().setDefaultWebServicesUri(webServiceUri);
                            logger.info(String.format("Services is working through the proxy [%s]", webServiceUri));
                        }
                    }
                }
                catch (Exception ex) {
                    logger.warn(String.format("Extension Broker  app is not ready yet: %s", ex.getMessage()), (Throwable)ex);
                }
                logger.info("Extension Broker  API enabled");
                for (ServiceLifecycleListener listener : this.systemLifecycleListeners) {
                    listener.extensionBrokerConfigured();
                }
                for (ServiceLifecycleListener listener : this.lifecycleListeners) {
                    listener.extensionBrokerConfigured();
                }
                if (this.properties.isDebug()) {
                    logger.info(String.format("%s --------------", "DEBUG>"));
                }
            }
            if (!this.webServicesConfigured.get()) {
                WebServicesProcessor webServicesProcessor = new WebServicesProcessor(this, this.properties.getToken(), this.properties.isLocalDeployment(), this.properties.isDebug());
                this.webServicesServer = new WebServices(this.properties, webServicesProcessor);
                this.webServicesServer.start();
                this.webServicesConfigured.set(true);
                for (ServiceLifecycleListener listener : this.systemLifecycleListeners) {
                    listener.webServicesConfigured();
                }
                for (ServiceLifecycleListener listener : this.lifecycleListeners) {
                    listener.webServicesConfigured();
                }
                if (this.properties.isDebug()) {
                    logger.info(String.format("%s --------------", "DEBUG>"));
                }
            }
        }
        finally {
            this.configureLock.unlock();
        }
    }

    public final void finishedStart() {
        this.appLogs().info(String.format("Services [%s] started", this.properties.getServiceName()));
        for (ServiceLifecycleListener listener : this.systemLifecycleListeners) {
            listener.serviceStarted();
        }
        if (this.properties.isDebug()) {
            logger.info(String.format("%s --------------", "DEBUG>"));
        }
        for (ServiceLifecycleListener listener : this.lifecycleListeners) {
            listener.serviceStarted();
        }
        this.management.clearCache();
    }

    private void errorIfNotConfigured() throws ServiceException {
        if (!this.configured.get()) {
            throw ServiceException.permanent(ErrorCode.CLIENT, "Services is not already configured.");
        }
    }

    private void errorIfExtensionBrokerNotConfigured() throws ServiceException {
        if (!this.extensionBrokerApiConfigured.get()) {
            throw ServiceException.permanent(ErrorCode.CLIENT, "Extension Broker services are not already configured.");
        }
        if (this.extensionBroker == null) {
            throw ServiceException.permanent(ErrorCode.CLIENT, "Extension Broker services are not properly configured.");
        }
    }

    private void errorIfWebServicesNotConfigured() {
        if (!this.webServicesConfigured.get()) {
            throw ServiceException.permanent(ErrorCode.CLIENT, "Web service is not ready to be used yet. Use it in Service.webServicesConfigured() hook or after its execution.");
        }
    }

    @Override
    public final void stopService(String cause) {
        this.webServicesServer.stop();
        for (ServiceLifecycleListener listener : this.systemLifecycleListeners) {
            listener.serviceStopped(cause);
        }
        for (ServiceLifecycleListener listener : this.lifecycleListeners) {
            listener.serviceStopped(cause);
        }
        Executors.newSingleThreadScheduledExecutor().schedule(() -> {
            logger.info(String.format("Services stopped [%s]", cause));
            System.exit(0);
        }, 2L, TimeUnit.SECONDS);
    }

    @Override
    public ServicesProperties properties() {
        return this.properties;
    }

    @Override
    public ServiceDefinitions definitions() {
        return this.definitions;
    }

    public ExtensionBrokerApi getExtensionBroker() {
        this.errorIfExtensionBrokerNotConfigured();
        return this.extensionBroker;
    }

    @Override
    public Events events() {
        this.errorIfExtensionBrokerNotConfigured();
        return this.events;
    }

    @Override
    public AppLogs appLogs() {
        this.errorIfExtensionBrokerNotConfigured();
        return this.appLogs;
    }

    @Override
    public Locks locks() {
        this.errorIfExtensionBrokerNotConfigured();
        return this.locks;
    }

    @Override
    public Files files() {
        this.errorIfExtensionBrokerNotConfigured();
        return this.files;
    }

    @Override
    public EBConfigurations serviceConfigurations() {
        this.errorIfExtensionBrokerNotConfigured();
        return this.configurations;
    }

    @Override
    public AppUsers appUsers() {
        this.errorIfExtensionBrokerNotConfigured();
        return this.appUsers;
    }

    @Override
    public Management management() {
        this.errorIfExtensionBrokerNotConfigured();
        return this.management;
    }

    @Override
    public DataStores dataStores() {
        this.errorIfExtensionBrokerNotConfigured();
        return this.dataStores;
    }

    @Override
    public DataStore dataStore(String dataStoreName) throws ServiceException {
        this.errorIfExtensionBrokerNotConfigured();
        return this.dataStores.getDataStore(dataStoreName);
    }

    @Override
    public DataStore userDataStore() throws ServiceException {
        this.errorIfExtensionBrokerNotConfigured();
        return this.dataStores.getUserDataStore();
    }

    @Override
    public Json toJson() {
        this.errorIfNotConfigured();
        return Json.map().set("properties", this.properties.toJson()).set("definitions", this.definitions.toJson());
    }

    @Override
    public final Json getConfiguration() throws ServiceException {
        Json response;
        this.errorIfNotConfigured();
        try {
            Json serviceConfiguration = this.properties.toJson();
            if (serviceConfiguration.contains("_token")) {
                serviceConfiguration.set("_token", "-");
            }
            response = Json.map().set("app", this.properties.getApplicationName()).set("name", this.properties.getServiceName()).set("env", this.properties.getEnvironment()).set("perUser", this.definitions.isPerUserService()).setIfNotNull("configuration", serviceConfiguration).setIfNotEmpty("apiVersion", this.definitions.getApiVersion()).setIfNotNull("dataStores", this.definitions.getDataStores()).setIfNotNull("functions", this.definitions.getFunctions()).setIfNotNull("events", this.definitions.getEvents()).setIfNotEmpty("configurationHelpUrl", this.definitions.getConfigurationHelpUrl()).setIfNotEmpty("conf", this.definitions.getUIConfiguration()).setIfNotEmpty("userConf", this.definitions.getUIUserConfiguration()).setIfNotEmpty("userConfButtons", this.definitions.getUIUserConfigurationButtons());
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception ex) {
            throw ServiceException.permanent(ErrorCode.CLIENT, (Object)String.format("Exception when process configuration: %s", ex.getMessage()), ex);
        }
        if (this.enabledConfiguratorInterceptor.get()) {
            try {
                response = this.configurationInterceptor(response);
            }
            catch (ServiceException e) {
                throw e;
            }
            catch (Exception ex) {
                throw ServiceException.permanent(ErrorCode.CLIENT, (Object)String.format("Exception when process configuration on interceptor: %s", ex.getMessage()), ex);
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerFunction(RegisteredFunction function, Boolean throwExceptionIfInvalid) {
        this.functionsLock.writeLock().lock();
        try {
            if (function == null) {
                throw ServiceException.permanent(ErrorCode.ARGUMENT, "Invalid function definition");
            }
            if (StringUtils.isBlank((CharSequence)function.getName())) {
                throw ServiceException.permanent(ErrorCode.ARGUMENT, String.format("Invalid function name [%s]", function.getName()));
            }
            String functionName = function.getName().trim();
            if (this.functions.containsKey(functionName)) {
                throw ServiceException.permanent(ErrorCode.ARGUMENT, String.format("Function [%s] for method [%s] is already defined for method [%s]", functionName, function.getMethod(), this.functions.get(functionName).getMethod()));
            }
            if (StringUtils.isBlank((CharSequence)function.getMethod())) {
                throw ServiceException.permanent(ErrorCode.ARGUMENT, String.format("Invalid function method [%s] for function [%s]", function.getMethod(), functionName));
            }
            if (function.getAccessorType() == null || function.getResponseType() == null || function.getParameterType() == null) {
                throw ServiceException.permanent(ErrorCode.ARGUMENT, String.format("Invalid definitions for function [%s]: accessor [%s] - response [%s] - parameter [%s]", new Object[]{functionName, function.getAccessorType(), function.getResponseType(), function.getParameterType()}));
            }
            if (!this.definitions().isValidFunction(functionName)) {
                if (throwExceptionIfInvalid == null || throwExceptionIfInvalid.booleanValue()) {
                    throw ServiceException.permanent(ErrorCode.ARGUMENT, String.format("Invalid function name [%s] because is not defined on the appService.json file", functionName));
                }
                if (this.properties.isDebug()) {
                    logger.info(String.format("%s Auto generated function [%s] is disabled because is not defined on the appService.json file", "DEBUG>", functionName));
                }
                return;
            }
            this.functions.put(functionName, function);
        }
        finally {
            this.functionsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Json executeFunction(FunctionRequest request) throws ServiceException {
        RegisteredFunction function;
        if (request == null || StringUtils.isBlank((CharSequence)request.getFunctionName())) {
            throw ServiceException.permanent(ErrorCode.ARGUMENT, "Empty function name").returnCode(400);
        }
        if (this.enabledFunctionInterceptor.get()) {
            try {
                Json response = this.executeOnInterceptor(request);
                if (response != null) {
                    return response;
                }
            }
            catch (ServiceException e) {
                throw e;
            }
            catch (Exception e) {
                logger.warn(String.format("An error happens when try to execute the interceptor for function [%s]: %s", request.getFunctionName(), e.getMessage()), (Throwable)e);
                String msg = e.getMessage();
                if (StringUtils.isBlank((CharSequence)msg) || "null".equalsIgnoreCase(msg) || "undefined".equalsIgnoreCase(msg)) {
                    msg = String.format("An error happens when try to execute the interceptor for function [%s]", request.getFunctionName());
                }
                throw ServiceException.permanent(ErrorCode.GENERAL, (Object)msg, e).returnCode(500);
            }
            logger.warn(String.format("The function interceptor returns a null response, the request [%s] will be processed as a regular function.", request.getFunctionName()));
        }
        this.functionsLock.readLock().lock();
        try {
            function = this.functions.get(request.getFunctionName());
        }
        catch (Exception ex) {
            function = null;
        }
        finally {
            this.functionsLock.readLock().unlock();
        }
        if (function == null) {
            if (this.definitions().isValidFunction(request.getFunctionName())) {
                String error = String.format("Function [%s] is defined on the appService.json file but not implemented", request.getFunctionName());
                logger.error(error);
                throw ServiceException.permanent(ErrorCode.ARGUMENT, error).returnCode(500);
            }
            String error = String.format("Function [%s] is not defined for the services", request.getFunctionName());
            logger.error(error);
            throw ServiceException.permanent(ErrorCode.CLIENT, error).returnCode(400);
        }
        try {
            Method method;
            Method declaredMethod = this.declaredMethodsCache.getOrDefault(function.getName(), null);
            if (declaredMethod != null) {
                method = declaredMethod;
            } else {
                Class<?> serviceClass;
                Class<?> clazz = serviceClass = function.getServiceClass() != null ? function.getServiceClass() : this.service.getClass();
                method = function.getParameterType() == MethodParameterType.STRING ? serviceClass.getDeclaredMethod(function.getMethod(), String.class) : (function.getParameterType() == MethodParameterType.JSON ? serviceClass.getDeclaredMethod(function.getMethod(), Json.class) : (function.getParameterType() == MethodParameterType.REQUEST ? serviceClass.getDeclaredMethod(function.getMethod(), FunctionRequest.class) : (function.getParameterType() == MethodParameterType.OBJECT ? serviceClass.getDeclaredMethod(function.getMethod(), Object.class) : serviceClass.getMethod(function.getMethod(), new Class[0]))));
            }
            try {
                this.declaredMethodsCache.put(function.getName(), method);
            }
            catch (Exception e) {
                logger.error(String.format("Method [%s] for function [%s] is not defined for the services: [%s]", function.getMethod(), function.getName(), e.getMessage()));
                throw ServiceException.permanent(ErrorCode.CLIENT, String.format("Function [%s] is not implemented on the services", function.getName())).returnCode(500);
            }
            if (function.getAccessorType() == MethodAccessorType.PRIVATE) {
                method.setAccessible(true);
            }
            Object response = function.getParameterType() == MethodParameterType.STRING ? method.invoke((Object)this.service, request.getParams() != null ? request.getParams().toString() : null) : (function.getParameterType() == MethodParameterType.JSON ? method.invoke((Object)this.service, request.getJsonParams()) : (function.getParameterType() == MethodParameterType.REQUEST ? method.invoke((Object)this.service, request) : (function.getParameterType() == MethodParameterType.OBJECT ? method.invoke((Object)this.service, request.getParams()) : method.invoke((Object)this.service, new Object[0]))));
            if (function.getAccessorType() == MethodAccessorType.PRIVATE) {
                method.setAccessible(false);
            }
            if (response == null || function.getResponseType() == FunctionResponseType.VOID) {
                return Json.map();
            }
            if (function.getResponseType() == FunctionResponseType.OTHER) {
                return Json.map().setIfNotEmpty("body", response);
            }
            return Json.fromObject(response);
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            String msg;
            Throwable tw = e.getTargetException();
            String string = msg = tw != null ? tw.getMessage() : e.getMessage();
            if (StringUtils.isBlank((CharSequence)msg) || "null".equalsIgnoreCase(msg) || "undefined".equalsIgnoreCase(msg)) {
                msg = String.format("An error happens when try to execute the function [%s]", function.getName());
                logger.warn(msg, tw);
            } else {
                logger.warn(String.format("An error happens when try to execute the function [%s]: %s", function.getName(), msg), tw);
            }
            if (tw instanceof ServiceException) {
                throw (ServiceException)tw;
            }
            throw ServiceException.permanent(ErrorCode.GENERAL, (Object)msg, tw).returnCode(500);
        }
        catch (Exception e) {
            logger.warn(String.format("An error happens when try to execute the function [%s]: %s", function.getName(), e.getMessage()), (Throwable)e);
            String msg = e.getMessage();
            if (StringUtils.isBlank((CharSequence)msg) || "null".equalsIgnoreCase(msg) || "undefined".equalsIgnoreCase(msg)) {
                msg = String.format("An error happens when try to execute the function [%s]", function.getName());
            }
            throw ServiceException.permanent(ErrorCode.GENERAL, (Object)msg, e).returnCode(500);
        }
    }

    public final void registerWebService(RegisteredWebService webService) {
        this.webServicesLock.writeLock().lock();
        try {
            if (webService == null) {
                throw ServiceException.permanent(ErrorCode.ARGUMENT, "Invalid web service definition");
            }
            if (StringUtils.isBlank((CharSequence)webService.getPath())) {
                throw ServiceException.permanent(ErrorCode.ARGUMENT, String.format("Invalid web service path [%s]", webService.getPath()));
            }
            if (webService.getRestMethod() == null) {
                throw ServiceException.permanent(ErrorCode.ARGUMENT, String.format("Invalid web service rest method [%s]", new Object[]{webService.getRestMethod()}));
            }
            if (StringUtils.isBlank((CharSequence)webService.getMethod())) {
                throw ServiceException.permanent(ErrorCode.ARGUMENT, String.format("Invalid function method [%s] for web service", webService.getMethod()));
            }
            if (webService.getAccessorType() == null || webService.getResponseType() == null || webService.getParameterType() == null) {
                throw ServiceException.permanent(ErrorCode.ARGUMENT, String.format("Invalid definitions for web service: accessor [%s] - response [%s] - parameter [%s]", new Object[]{webService.getAccessorType(), webService.getResponseType(), webService.getParameterType()}));
            }
            this.webServices.add(webService);
        }
        finally {
            this.webServicesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final WebServiceResponse executeWebServices(WebServiceRequest request) throws ServiceException {
        Json variables;
        if (request == null) {
            throw ServiceException.permanent(ErrorCode.ARGUMENT, "Empty web service name").returnCode(400);
        }
        RegisteredWebService webService = null;
        this.webServicesLock.readLock().lock();
        try {
            List validWebServices = this.webServices.stream().filter(ws -> request.getMethod() == ws.getRestMethod()).filter(ws -> ws.isValidRoute(request.getPath())).sorted(RegisteredWebService::compareTo).collect(Collectors.toList());
            if (!validWebServices.isEmpty()) {
                if (validWebServices.size() > 1) {
                    logger.info(String.format("More than one valid routes for [%s %s]: %s", request.getMethod().name(), request.getPath(), validWebServices.stream().map(ws -> String.format("[%s %s %s]", ws.getRestMethod().name(), ws.getPath(), ws.getMethod())).reduce("", (s, s2) -> s + " " + s2)));
                }
                webService = (RegisteredWebService)validWebServices.get(0);
            }
        }
        finally {
            this.webServicesLock.readLock().unlock();
        }
        if (webService == null) {
            if (this.enabledFunctionInterceptor.get()) {
                try {
                    return this.executeOnInterceptor(request);
                }
                catch (ServiceException e) {
                    throw e;
                }
                catch (Exception e) {
                    logger.warn(String.format("An error happens when try to execute the interceptor for web service [%s %s]: %s", request.getMethod().name(), request.getPath(), e.getMessage()), (Throwable)e);
                    String msg = e.getMessage();
                    if (StringUtils.isBlank((CharSequence)msg) || "null".equalsIgnoreCase(msg) || "undefined".equalsIgnoreCase(msg)) {
                        msg = String.format("An error happens when try to execute the interceptor for web service [%s %s]", request.getMethod().name(), request.getPath());
                    }
                    throw ServiceException.permanent(ErrorCode.GENERAL, (Object)msg, e).returnCode(500);
                }
            }
            throw ServiceException.permanent(ErrorCode.ARGUMENT, "Web service not found").returnCode(404);
        }
        if (this.properties.isDebug()) {
            logger.info(String.format("%s selected route [%s %s]: method [%s]", "DEBUG>", webService.getRestMethod().name(), webService.getPath(), webService.getMethod()));
        }
        if ((variables = webService.getPathVariables(request.getPath())).isNotEmpty()) {
            variables.forEachMap((s, o) -> request.setPathVariable((String)s, o != null ? o.toString() : ""));
        }
        try {
            Method method;
            Method declaredMethod = this.declaredMethodsCache.getOrDefault(webService.getName(), null);
            if (declaredMethod != null) {
                method = declaredMethod;
            } else {
                Class<?> serviceClass;
                Class<?> clazz = serviceClass = webService.getServiceClass() != null ? webService.getServiceClass() : this.service.getClass();
                method = webService.getParameterType() == MethodParameterType.STRING ? serviceClass.getDeclaredMethod(webService.getMethod(), String.class) : (webService.getParameterType() == MethodParameterType.JSON ? serviceClass.getDeclaredMethod(webService.getMethod(), Json.class) : (webService.getParameterType() == MethodParameterType.REQUEST ? serviceClass.getDeclaredMethod(webService.getMethod(), WebServiceRequest.class) : (webService.getParameterType() == MethodParameterType.OBJECT ? serviceClass.getDeclaredMethod(webService.getMethod(), Object.class) : serviceClass.getMethod(webService.getMethod(), new Class[0]))));
            }
            try {
                this.declaredMethodsCache.put(webService.getName(), method);
            }
            catch (Exception e) {
                logger.error(String.format("Method [%s] for web service [%s %s] is not defined for the service [%s]", webService.getMethod(), webService.getRestMethod().name(), webService.getPath(), e.getMessage()));
                throw ServiceException.permanent(ErrorCode.CLIENT, String.format("Web service [%s %s] is not implemented on the service", webService.getRestMethod().name(), webService.getPath())).returnCode(500);
            }
            if (webService.getAccessorType() == MethodAccessorType.PRIVATE) {
                method.setAccessible(true);
            }
            Object response = webService.getParameterType() == MethodParameterType.STRING ? method.invoke((Object)this.service, request.getBody() != null ? request.getBody().toString() : null) : (webService.getParameterType() == MethodParameterType.JSON ? method.invoke((Object)this.service, request.getJsonBody()) : (webService.getParameterType() == MethodParameterType.REQUEST ? method.invoke((Object)this.service, request) : (webService.getParameterType() == MethodParameterType.OBJECT ? method.invoke((Object)this.service, request.getBody()) : method.invoke((Object)this.service, new Object[0]))));
            if (webService.getAccessorType() == MethodAccessorType.PRIVATE) {
                method.setAccessible(false);
            }
            if (response == null || webService.getResponseType() == WebServiceResponseType.VOID) {
                return new WebServiceResponse(Json.map());
            }
            if (webService.getResponseType() == WebServiceResponseType.STRING) {
                return new WebServiceResponse((Object)response.toString(), Json.map().set("Content-Type", ContentType.TEXT_PLAIN.getMimeType()));
            }
            if (webService.getResponseType() == WebServiceResponseType.RESPONSE) {
                if (response instanceof WebServiceResponse) {
                    return (WebServiceResponse)response;
                }
                return new WebServiceResponse(Json.map());
            }
            if (webService.getResponseType() == WebServiceResponseType.JSON) {
                return new WebServiceResponse(Json.fromObject(response));
            }
            return new WebServiceResponse(response);
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            String msg;
            Throwable tw = e.getTargetException();
            String string = msg = tw != null ? tw.getMessage() : e.getMessage();
            if (StringUtils.isBlank((CharSequence)msg) || "null".equalsIgnoreCase(msg) || "undefined".equalsIgnoreCase(msg)) {
                msg = String.format("An error happens when try to execute the web service [%s %s]", webService.getRestMethod().name(), webService.getPath());
                logger.warn(msg, tw);
            } else {
                logger.warn(String.format("An error happens when try to execute the web service [%s %s]: %s", webService.getRestMethod().name(), webService.getPath(), msg), tw);
            }
            if (tw instanceof ServiceException) {
                throw (ServiceException)tw;
            }
            throw ServiceException.permanent(ErrorCode.GENERAL, (Object)msg, e).returnCode(500);
        }
        catch (Exception e) {
            logger.warn(String.format("An error happens when try to execute the web service [%s %s]: %s", webService.getRestMethod().name(), webService.getPath(), e.getMessage()), (Throwable)e);
            String msg = e.getMessage();
            if (StringUtils.isBlank((CharSequence)msg) || "null".equalsIgnoreCase(msg) || "undefined".equalsIgnoreCase(msg)) {
                msg = String.format("An error happens when try to execute the web service [%s %s]", webService.getRestMethod().name(), webService.getPath());
            }
            throw ServiceException.permanent(ErrorCode.GENERAL, (Object)msg, e).returnCode(500);
        }
    }

    @Override
    public final void enableConfiguratorInterceptor() {
        this.enabledConfiguratorInterceptor.set(true);
        if (this.properties.isDebug()) {
            logger.info(String.format("%s configurator interceptor enabled", "DEBUG>"));
        }
    }

    @Override
    public final void enableFunctionInterceptor() {
        this.enabledFunctionInterceptor.set(true);
        if (this.properties.isDebug()) {
            logger.info(String.format("%s functions interceptor enabled", "DEBUG>"));
        }
    }

    @Override
    public final void enableWebServicesInterceptor() {
        if (this.properties.isDebug()) {
            logger.info(String.format("%s web services interceptor enabled", "DEBUG>"));
        }
    }

    @Override
    public void setupDefaultExceptionsProperties(int maxRedelivers) {
        this.errorIfWebServicesNotConfigured();
        this.webServicesServer.setupDefaultExceptionsProperties(maxRedelivers);
    }

    @Override
    public void setupPermanentExceptionsProperties(int maxRedelivers, long delay) {
        this.errorIfWebServicesNotConfigured();
        this.webServicesServer.setupPermanentExceptionsProperties(maxRedelivers, delay);
    }

    @Override
    public void setupRetryableExceptionsProperties(int maxRedelivers, long delay) {
        this.errorIfWebServicesNotConfigured();
        this.webServicesServer.setupRetryableExceptionsProperties(maxRedelivers, delay);
    }

    private Json executeOnInterceptor(FunctionRequest request) throws ServiceException {
        Json jsonResponse;
        Object response;
        if (this.properties.isDebug()) {
            logger.info(String.format("%s function interceptor: function [%s] id [%s]", "DEBUG>", request.getFunctionName(), request.getFunctionName()));
        }
        if ((response = this.functionInterceptor(request)) == null) {
            jsonResponse = Json.map();
        } else {
            jsonResponse = Json.fromObject(response, false, true);
            if (jsonResponse == null) {
                jsonResponse = Json.map().setIfNotEmpty("body", response);
            }
        }
        return jsonResponse;
    }

    private WebServiceResponse executeOnInterceptor(WebServiceRequest request) throws ServiceException {
        if (this.properties.isDebug()) {
            logger.info(String.format("%s web service interceptor: request [%s %s]", "DEBUG>", request.getMethod().name(), request.getPath()));
        }
        Object response = this.webServicesInterceptor(request);
        WebServiceResponse wsResponse = null;
        if (response == null) {
            wsResponse = new WebServiceResponse(Json.map());
        } else if (response instanceof WebServiceResponse) {
            wsResponse = (WebServiceResponse)response;
        } else {
            Json jsonResponse = Json.fromObject(response, false, true);
            if (jsonResponse != null) {
                wsResponse = new WebServiceResponse(jsonResponse);
            }
            if (wsResponse == null) {
                wsResponse = response instanceof String ? new WebServiceResponse((Object)response.toString(), ContentType.TEXT_PLAIN.getMimeType()) : new WebServiceResponse(response);
            }
        }
        return wsResponse;
    }

    @Override
    public final Json configurationInterceptor(Json configuration) throws ServiceException {
        return this.service.configurationInterceptor(configuration);
    }

    @Override
    public final Object functionInterceptor(FunctionRequest request) throws ServiceException {
        return this.service.functionInterceptor(request);
    }

    @Override
    public final Object webServicesInterceptor(WebServiceRequest request) throws ServiceException {
        return this.service.webServicesInterceptor(request);
    }
}

