/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.framework.annotations.classes;

import io.slingr.services.framework.annotations.classes.AccessorType;
import io.slingr.services.framework.annotations.classes.PropertyType;
import io.slingr.services.framework.annotations.classes.SettableProperty;
import io.slingr.services.framework.annotations.processor.AnnotationsUtils;
import io.slingr.services.services.datastores.DataStore;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;

public class ClassUserDataStore
implements SettableProperty {
    private final String simpleName;
    private final AccessorType accessorType;
    private final String accessor;

    public ClassUserDataStore(Element sDataStoreElement) throws IllegalArgumentException {
        VariableElement annotatedElement = (VariableElement)sDataStoreElement;
        this.simpleName = annotatedElement.getSimpleName().toString().trim();
        String setterName = String.format("set%S%s", this.simpleName.substring(0, 1), this.simpleName.length() > 1 ? this.simpleName.substring(1) : "");
        PropertyType type = AnnotationsUtils.isValidSetter(DataStore.class, annotatedElement, this.simpleName, setterName);
        if (type != null) {
            this.accessorType = AccessorType.SETTER;
            this.accessor = setterName;
        } else {
            this.accessor = this.simpleName;
            type = AnnotationsUtils.isValidProperty(DataStore.class, annotatedElement, this.simpleName, this.accessor);
            if (type == null) {
                throw new IllegalStateException(String.format("User data Store [%s] is not valid", this.simpleName));
            }
            this.accessorType = annotatedElement.getModifiers().contains((Object)Modifier.PRIVATE) || annotatedElement.getModifiers().contains((Object)Modifier.PROTECTED) ? AccessorType.REFLECTION : AccessorType.PROPERTY;
        }
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    @Override
    public String getAccessor() {
        return this.accessor;
    }

    @Override
    public AccessorType getAccessorType() {
        return this.accessorType;
    }
}

