/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.ws;

import io.slingr.services.configurations.ServiceContext;
import io.slingr.services.exceptions.ErrorCode;
import io.slingr.services.exceptions.ServiceException;
import io.slingr.services.framework.IBaseService;
import io.slingr.services.services.rest.RestMethod;
import io.slingr.services.utils.FilesUtils;
import io.slingr.services.utils.Json;
import io.slingr.services.utils.Strings;
import io.slingr.services.utils.converters.ContentTypeFormat;
import io.slingr.services.utils.converters.JsonConverter;
import io.slingr.services.ws.exchange.FunctionRequest;
import io.slingr.services.ws.exchange.UploadedFile;
import io.slingr.services.ws.exchange.WebServiceRequest;
import io.slingr.services.ws.exchange.WebServiceResponse;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServicesProcessor
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(WebServicesProcessor.class);
    private static final int DEFAULT_MAX_REDELIVERS = 3;
    private static final int DEFAULT_PERMANENT_MAX_REDELIVERS = 0;
    private static final int DEFAULT_RETRYABLE_MAX_REDELIVERS = 3;
    private static final long DEFAULT_PERMANENT_DELAY = 4000L;
    private static final long DEFAULT_RETRYABLE_DELAY = 2000L;
    private final IBaseService baseService;
    private final String token;
    private final boolean localDeployment;
    private final boolean debug;
    private final AtomicBoolean firstLocalDeploymentWarning = new AtomicBoolean(false);
    private int maxRedelivers = 3;
    private int permanentMaxRedelivers = 0;
    private long permanentDelay = 4000L;
    private int retryableMaxRedelivers = 3;
    private long retryableDelay = 2000L;

    public WebServicesProcessor(IBaseService baseService, String token, boolean localDeployment, boolean debug) {
        if (baseService == null) {
            throw new IllegalArgumentException("Base service is required to instance a web service processor");
        }
        this.baseService = baseService;
        this.token = token;
        this.localDeployment = localDeployment;
        this.debug = debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String path, Request baseRequest, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        logger.info(String.format("WS request [%s %s]", servletRequest.getMethod(), path));
        ServiceContext.initContext(servletRequest.getHeader("app"), servletRequest.getHeader("env"));
        try {
            WebServiceRequest webServiceRequest = this.prepareRequest(path, servletRequest);
            if (this.debug) {
                logger.info(String.format("%s request %s", "DEBUG>", webServiceRequest));
            }
            WebServiceResponse response = this.processRequest(webServiceRequest);
            this.sendResponse(response, servletResponse);
            baseRequest.setHandled(true);
        }
        finally {
            ServiceContext.endContext();
        }
    }

    private WebServiceResponse processRequest(WebServiceRequest request) {
        WebServiceResponse response = request.getPath().equals("/api/system/alive") || request.getPath().equals("/api/system/terminate") || request.getPath().equals("/api/configuration") || request.getPath().equals("/api/function") ? this.processApiRequest(request) : this.processWSRequest(request);
        return response;
    }

    private WebServiceResponse processApiRequest(WebServiceRequest request) {
        int code = 200;
        Object body = null;
        Json headers = Json.map();
        boolean validToken = true;
        if (!this.token.equals(request.getHeader("token"))) {
            if (this.localDeployment) {
                if (this.firstLocalDeploymentWarning.compareAndSet(false, true)) {
                    logger.warn("Invalid or empty token on request. Ignored exceptions of this kind because the service is running in local deployment.");
                }
            } else {
                validToken = false;
                code = 401;
                body = "Invalid token";
                headers.set("Content-Type", ContentTypeFormat.PLAIN_TEXT.getMimeType());
            }
        }
        boolean processedRequest = false;
        if (validToken) {
            if ("/api/system/alive".equals(request.getPath())) {
                body = Json.map().set("started", true);
                processedRequest = true;
            } else if ("/api/system/terminate".equals(request.getPath())) {
                this.baseService.stopService("termination signal received");
                body = "ok";
                headers.set("Content-Type", ContentTypeFormat.PLAIN_TEXT.getMimeType());
                processedRequest = true;
            } else if ("/api/configuration".equals(request.getPath())) {
                body = this.baseService.getConfiguration();
                processedRequest = true;
            } else if ("/api/function".equals(request.getPath())) {
                FunctionRequest functionRequest = new FunctionRequest(request.getBody(), false, 0, 3);
                return this.executeFunction(functionRequest);
            }
        }
        if (validToken && !processedRequest) {
            code = 404;
            body = "Invalid API request";
            headers.set("Content-Type", ContentTypeFormat.PLAIN_TEXT.getMimeType());
        }
        if (body == null) {
            body = Json.map();
        }
        return new WebServiceResponse(code, body, headers);
    }

    private WebServiceResponse executeFunction(FunctionRequest functionRequest) {
        if (functionRequest == null) {
            return new WebServiceResponse(400, (Object)"Invalid API request", ContentTypeFormat.PLAIN_TEXT.getMimeType());
        }
        Json originalRequest = null;
        try {
            originalRequest = functionRequest.getRequest().cloneJson();
            Json response = this.baseService.executeFunction(functionRequest);
            return new WebServiceResponse(response != null && response.isMap() && response.is("__service_exception__") ? 500 : 200, (Object)Json.map().set("date", System.currentTimeMillis()).setIfNotNull("data", response));
        }
        catch (ServiceException ee) {
            int maxRedelivers = Math.min(this.maxRedelivers, ee.isRetryable() ? this.retryableMaxRedelivers : this.permanentMaxRedelivers);
            maxRedelivers = Math.min(maxRedelivers, functionRequest.getRedeliveredMaxCounter());
            if (originalRequest != null && maxRedelivers > functionRequest.getRedeliveredCounter()) {
                try {
                    Thread.sleep(ee.isRetryable() ? this.retryableDelay : this.permanentDelay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                FunctionRequest newFunctionRequest = new FunctionRequest(originalRequest, true, functionRequest.getRedeliveredCounter() + 1, maxRedelivers);
                return this.executeFunction(newFunctionRequest);
            }
            return new WebServiceResponse(ee.getReturnCode(), (Object)Json.map().set("date", System.currentTimeMillis()).setIfNotNull("data", ee.toJson()));
        }
        catch (Exception ex) {
            return new WebServiceResponse(500, (Object)Json.map().set("date", System.currentTimeMillis()).setIfNotNull("data", ServiceException.json(ErrorCode.GENERAL, String.format("Exception when execute function: %s", ex.getMessage()), functionRequest.toJson(), (Throwable)ex)));
        }
    }

    private WebServiceResponse processWSRequest(WebServiceRequest request) {
        try {
            return this.baseService.executeWebServices(request);
        }
        catch (ServiceException ee) {
            return new WebServiceResponse(ee.getReturnCode(), (Object)ee.toJson());
        }
        catch (Exception ex) {
            return new WebServiceResponse(500, (Object)ServiceException.json(ErrorCode.GENERAL, String.format("Exception when execute web service: %s", ex.getMessage()), request.toJson(), (Throwable)ex));
        }
    }

    private WebServiceRequest prepareRequest(String path, HttpServletRequest servletRequest) {
        RestMethod method = RestMethod.fromString(servletRequest.getMethod());
        ArrayList<UploadedFile> files = new ArrayList<UploadedFile>();
        Object body = "";
        String rawBody = null;
        try {
            Object bodyInputStream = null;
            if (ContentTypeFormat.isMultipartContentType(servletRequest.getContentType())) {
                MultipartConfigElement multipartConfigElement = new MultipartConfigElement((String)null);
                servletRequest.setAttribute("org.eclipse.jetty.multipartConfig", (Object)multipartConfigElement);
                servletRequest.setCharacterEncoding(StandardCharsets.ISO_8859_1.name());
                for (Part part : servletRequest.getParts()) {
                    if (bodyInputStream == null && ContentTypeFormat.isJsonContentType(part.getContentType())) {
                        bodyInputStream = part.getInputStream();
                        continue;
                    }
                    Json headers = Json.map();
                    for (String header : part.getHeaderNames()) {
                        headers.setIfNotEmpty(header.toLowerCase(), part.getHeader(header));
                    }
                    UploadedFile uploadedFile = new UploadedFile(part.getName(), part.getSubmittedFileName(), part.getContentType(), part.getSize(), part.getInputStream(), headers);
                    files.add(uploadedFile);
                }
            } else {
                bodyInputStream = servletRequest.getInputStream();
            }
            if (bodyInputStream != null && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{rawBody = Strings.readAsString((InputStream)bodyInputStream)}) && (body = JsonConverter.convertString(rawBody, servletRequest.getContentType(), false)) == null) {
                body = rawBody;
            }
        }
        catch (Exception ex) {
            logger.warn(String.format("Invalid body on web service servletRequest body: %s", ex.getMessage()), (Throwable)ex);
        }
        Json headers = Json.map();
        Json.fromEnumeration(servletRequest.getHeaderNames()).forEachList(k -> headers.set(k.toString(), servletRequest.getHeader(k.toString())));
        Json parameters = Strings.parseQueryString(Strings.urlDecode(servletRequest.getQueryString()), true);
        Json requestInfo = Json.map();
        try {
            requestInfo.set("method", servletRequest.getMethod());
        }
        catch (Exception part) {
            // empty catch block
        }
        try {
            requestInfo.set("path", servletRequest.getPathInfo());
        }
        catch (Exception part) {
            // empty catch block
        }
        try {
            requestInfo.set("query", servletRequest.getQueryString());
        }
        catch (Exception part) {
            // empty catch block
        }
        try {
            requestInfo.set("contentType", servletRequest.getContentType());
        }
        catch (Exception part) {
            // empty catch block
        }
        try {
            requestInfo.set("url", servletRequest.getRequestURL());
        }
        catch (Exception part) {
            // empty catch block
        }
        try {
            requestInfo.set("uri", servletRequest.getRequestURI());
        }
        catch (Exception part) {
            // empty catch block
        }
        try {
            requestInfo.set("encoding", servletRequest.getCharacterEncoding());
        }
        catch (Exception part) {
            // empty catch block
        }
        try {
            requestInfo.set("localAddress", servletRequest.getLocalAddr());
        }
        catch (Exception part) {
            // empty catch block
        }
        try {
            requestInfo.set("localName", servletRequest.getLocalName());
        }
        catch (Exception part) {
            // empty catch block
        }
        try {
            requestInfo.set("scheme", servletRequest.getScheme());
        }
        catch (Exception part) {
            // empty catch block
        }
        try {
            requestInfo.set("serverName", servletRequest.getServerName());
        }
        catch (Exception part) {
            // empty catch block
        }
        try {
            requestInfo.set("remoteHost", servletRequest.getRemoteHost());
        }
        catch (Exception part) {
            // empty catch block
        }
        try {
            requestInfo.set("remoteAddress", servletRequest.getRemoteAddr());
        }
        catch (Exception part) {
            // empty catch block
        }
        try {
            requestInfo.set("protocol", servletRequest.getProtocol());
        }
        catch (Exception part) {
            // empty catch block
        }
        WebServiceRequest webServiceRequest = new WebServiceRequest(method, path, body, headers, parameters, requestInfo, files);
        webServiceRequest.setRawBody(rawBody);
        return webServiceRequest;
    }

    private void sendResponse(WebServiceResponse response, HttpServletResponse servletResponse) throws IOException {
        if (this.debug) {
            logger.info(String.format("%s response %s", "DEBUG>", response.toString()));
        }
        response.getHeaders().forEachMap((key, value) -> servletResponse.addHeader(key, value != null ? value.toString() : "true"));
        String contentType = response.getStringHeader("Content-Type");
        if (StringUtils.isBlank((CharSequence)contentType)) {
            contentType = ContentTypeFormat.JSON.getMimeType();
        }
        servletResponse.setContentType(contentType);
        Object body = response.getBody();
        if (body != null) {
            if (body instanceof InputStream) {
                FilesUtils.copyStreamAndFlush((InputStream)body, (OutputStream)servletResponse.getOutputStream());
            } else if (body instanceof byte[]) {
                FilesUtils.copyStreamAndFlush(new ByteArrayInputStream((byte[])body), (OutputStream)servletResponse.getOutputStream());
            } else if (body instanceof ByteArrayOutputStream) {
                ((ByteArrayOutputStream)body).writeTo((OutputStream)servletResponse.getOutputStream());
            } else {
                servletResponse.getWriter().print(body);
            }
        }
        servletResponse.setStatus(response.getHttpCode());
    }

    void setupDefaultExceptionsProperties(int maxRedelivers) {
        this.maxRedelivers = maxRedelivers >= 0 ? maxRedelivers : 3;
    }

    void setupPermanentExceptionsProperties(int maxRedelivers, long delay) {
        this.permanentMaxRedelivers = maxRedelivers >= 0 ? maxRedelivers : 0;
        this.permanentDelay = delay >= 0L ? delay : 4000L;
    }

    void setupRetryableExceptionsProperties(int maxRedelivers, long delay) {
        this.retryableMaxRedelivers = maxRedelivers >= 0 ? maxRedelivers : 3;
        this.retryableDelay = delay >= 0L ? delay : 2000L;
    }
}

