/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.ws;

import io.slingr.services.configurations.Configuration;
import io.slingr.services.configurations.ServicesProperties;
import io.slingr.services.configurations.sources.EnvVarsSource;
import io.slingr.services.configurations.sources.PropertySource;
import io.slingr.services.ws.WebServicesProcessor;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServices {
    private static final Logger logger = LoggerFactory.getLogger(WebServices.class);
    private static final int TIMEOUT_10_MINUTES = 600000;
    private final Server server = new Server();
    private final WebServicesProcessor webServicesProcessor;
    private final AtomicBoolean status = new AtomicBoolean(false);
    private final ReentrantLock statusLock = new ReentrantLock();
    private static final List<PropertySource> envVarsSource = List.of(new EnvVarsSource());
    private static final String USE_SSL_PROPERTY = "USE_SSL";
    private static final String SSL_KEYSTORE_PATH_PROPERTY = "SSL_KEYSTORE_PATH";
    private static final String SSL_PASS_PROPERTY = "SSL_PASS";

    public WebServices(ServicesProperties properties, WebServicesProcessor webServicesProcessor) {
        ServerConnector connector;
        boolean useSsl = !properties.isLocalDeployment() || WebServices.useSsl();
        logger.info(String.format("Use SSL connection: [%s]", useSsl));
        if (useSsl) {
            HttpConfiguration https = new HttpConfiguration();
            https.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            sslContextFactory.setKeyStorePath(WebServices.getKeystorePath());
            sslContextFactory.setKeyStorePassword(WebServices.getKeystorePass());
            sslContextFactory.setKeyManagerPassword(WebServices.getKeystorePass());
            connector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(https)});
        } else {
            connector = new ServerConnector(this.server);
        }
        connector.setPort(properties.getWebServicesPort());
        connector.setHost("0.0.0.0");
        connector.setIdleTimeout(600000L);
        connector.setIdleTimeout(600000L);
        this.server.setConnectors(new Connector[]{connector});
        this.server.setHandler((Handler)webServicesProcessor);
        this.webServicesProcessor = webServicesProcessor;
    }

    public void start() {
        this.statusLock.lock();
        logger.info("Starting Web Services server...");
        try {
            if (this.status.get()) {
                logger.warn("Web Services is already started.");
            } else {
                this.server.start();
                this.status.set(true);
                logger.info("Web Services started");
            }
        }
        catch (Exception ex) {
            logger.error(String.format("Exception when start Web Services: %s", ex.getMessage()), (Throwable)ex);
        }
        finally {
            this.statusLock.unlock();
        }
    }

    public void stop() {
        this.statusLock.lock();
        logger.info("Stopping Web Services server...");
        try {
            if (this.status.get()) {
                this.server.setStopTimeout(-1L);
                this.server.stop();
                this.status.set(false);
                logger.info("Web Services stopped");
            } else {
                logger.warn("Web Services is already stopped.");
            }
        }
        catch (Exception ex) {
            logger.error(String.format("Exception when stop Web Services: %s", ex.getMessage()), (Throwable)ex);
        }
        finally {
            this.statusLock.unlock();
        }
    }

    public void setupDefaultExceptionsProperties(int maxRedelivers) {
        this.webServicesProcessor.setupDefaultExceptionsProperties(maxRedelivers);
    }

    public void setupPermanentExceptionsProperties(int maxRedelivers, long delay) {
        this.webServicesProcessor.setupPermanentExceptionsProperties(maxRedelivers, delay);
    }

    public void setupRetryableExceptionsProperties(int maxRedelivers, long delay) {
        this.webServicesProcessor.setupRetryableExceptionsProperties(maxRedelivers, delay);
    }

    private static String getKeystorePath() {
        return Configuration.resolveProperty(envVarsSource, SSL_KEYSTORE_PATH_PROPERTY);
    }

    private static String getKeystorePass() {
        return Configuration.resolveProperty(envVarsSource, SSL_PASS_PROPERTY);
    }

    private static boolean useSsl() {
        return Configuration.resolveBooleanProperty(envVarsSource, USE_SSL_PROPERTY);
    }
}

