/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.configurations.sources;

import io.slingr.services.configurations.sources.PropertySource;
import io.slingr.services.utils.Json;
import io.slingr.services.utils.converters.JsonSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonMapSource
implements PropertySource {
    private static final Logger logger = LoggerFactory.getLogger(JsonMapSource.class);
    private final Json json;

    public JsonMapSource(JsonSource jsonSource) {
        Json json;
        if (jsonSource == null) {
            logger.error("Invalid Json to use as source. This source will be ignored");
            jsonSource = Json.map();
        }
        if ((json = jsonSource.toJson()) == null || !json.isMap()) {
            logger.error(String.format("Invalid Json to use as source. This source will be ignored: %s", json));
            json = Json.map();
        }
        this.json = json;
    }

    @Override
    public String findProperty(String propertyName) {
        if (StringUtils.isNotBlank((CharSequence)propertyName) && this.json.contains(propertyName)) {
            try {
                return this.json.string(propertyName);
            }
            catch (Exception ex) {
                logger.warn(String.format("Property [%s] on json is invalid and will be ignored [%s]: %s", propertyName, this.json.object(propertyName), ex.getMessage()));
            }
        }
        return null;
    }
}

