/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.utils.converters;

import io.slingr.services.utils.EmailUtils;
import io.slingr.services.utils.Json;
import io.slingr.services.utils.Strings;
import io.slingr.services.utils.converters.JsonSource;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.mail.Multipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StringConverter {
    private static final Logger logger = LoggerFactory.getLogger(StringConverter.class);

    public static String fromJsonSource(JsonSource message) {
        if (message != null) {
            return message.toJson().toString();
        }
        return "";
    }

    public static String fromJson(Json message) {
        if (message != null) {
            return message.toString();
        }
        return "";
    }

    public static String fromMap(Map message) {
        if (message != null) {
            return Json.fromMap(message).toString();
        }
        return "";
    }

    public static String fromList(List message) {
        if (message != null) {
            return Json.fromList(message).toString();
        }
        return "";
    }

    public static String fromObject(Object message) {
        if (message == null) {
            return "";
        }
        if (message instanceof Json) {
            return StringConverter.fromJson((Json)message);
        }
        if (message instanceof JsonSource) {
            return StringConverter.fromJsonSource((JsonSource)message);
        }
        if (message instanceof Map) {
            return StringConverter.fromMap((Map)message);
        }
        if (message instanceof List) {
            return StringConverter.fromList((List)message);
        }
        if (message instanceof InputStream) {
            return Strings.readAsString((InputStream)message);
        }
        if (message instanceof Multipart) {
            return EmailUtils.convertMultipart((Multipart)message).toString();
        }
        return message.toString();
    }
}

