/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.utils;

import io.slingr.services.utils.Json;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class MapsUtils {
    public static Map<String, Object> cleanDotKeys(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (map != null && !map.isEmpty()) {
            for (String key : map.keySet()) {
                String newKey = MapsUtils.cleanDotKey(key);
                result.put(newKey, MapsUtils.cleanDotKeys(map.get(key)));
            }
        }
        return result;
    }

    public static Object cleanDotKeys(Object object) {
        if (object instanceof Json) {
            if (((Json)object).isList()) {
                return MapsUtils.cleanDotKeys(((Json)object).toList());
            }
            if (((Json)object).isMap()) {
                return MapsUtils.cleanDotKeys(((Json)object).toMap());
            }
            return null;
        }
        if (object instanceof Map) {
            return MapsUtils.cleanDotKeys((Map)object);
        }
        if (object instanceof List) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object o : (List)object) {
                list.add(MapsUtils.cleanDotKeys(o));
            }
            return list;
        }
        return object;
    }

    public static String cleanDotKey(String key) {
        if (StringUtils.isBlank((String)key)) {
            return "";
        }
        return key.replaceAll("\\.", "_").trim();
    }
}

