/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.services.rest.authentication;

import io.slingr.services.services.rest.authentication.AuthenticationType;
import io.slingr.services.services.rest.authentication.strategy.AuthenticationStrategy;
import io.slingr.services.services.rest.authentication.strategy.BasicAuthenticationStrategy;
import io.slingr.services.services.rest.authentication.strategy.DigestAuthenticationStrategy;
import io.slingr.services.services.rest.authentication.strategy.OAuth2AuthenticationStrategy;
import io.slingr.services.services.rest.authentication.strategy.OAuthAuthenticationStrategy;
import io.slingr.services.services.rest.authentication.strategy.OAuthTwitterAuthenticationStrategy;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationFactory {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationFactory.class);

    public static AuthenticationStrategy createAuthenticationStrategy(AuthenticationType type, Map<String, String> params) {
        logger.info(String.format("Authenticating with %s", type.name()));
        switch (type) {
            case BASIC: {
                return new BasicAuthenticationStrategy(params);
            }
            case OAUTH_TWITTER: {
                return new OAuthTwitterAuthenticationStrategy(params);
            }
            case OAUTH2: {
                return new OAuth2AuthenticationStrategy(params);
            }
            case OAUTH: {
                return new OAuthAuthenticationStrategy(params);
            }
            case DIGEST: {
                return new DigestAuthenticationStrategy(params);
            }
        }
        throw new IllegalArgumentException("Invalid authentication type: " + String.valueOf((Object)type));
    }
}

