/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.configurations;

import io.slingr.services.configurations.ServicesProperties;
import io.slingr.services.utils.Json;
import org.apache.commons.lang3.StringUtils;

public class Properties
implements ServicesProperties {
    private final String serviceName;
    private final String applicationName;
    private final String environment;
    private final String podId;
    private final String profile;
    private final String customDomain;
    private final String baseDomain;
    private final int webServicesPort;
    private String defaultWebServicesUri;
    private final String webServicesUri;
    private final String extensionBrokerApi;
    private final String extensionBrokerApiVersion;
    private final boolean localDeployment;
    private final String token;
    private final Json serviceConfiguration;
    private final boolean debug;
    private final boolean testingMode;
    private final boolean shared;
    private boolean usingProxy = false;

    Properties(String serviceName, String applicationName, String environment, String podId, String profile, String customDomain, String baseDomain, int webServicesPort, String webServicesUri, String extensionBrokerApi, String extensionBrokerApiVersion, boolean localDeployment, String token, Json serviceConfiguration, boolean debug, boolean testingMode, boolean shared) {
        this.serviceName = serviceName;
        this.applicationName = applicationName;
        this.environment = environment;
        this.podId = podId;
        this.profile = profile;
        this.customDomain = customDomain;
        this.baseDomain = baseDomain;
        this.webServicesPort = webServicesPort;
        this.webServicesUri = webServicesUri;
        this.extensionBrokerApi = extensionBrokerApi;
        this.extensionBrokerApiVersion = extensionBrokerApiVersion;
        this.localDeployment = localDeployment;
        this.token = token;
        this.serviceConfiguration = serviceConfiguration;
        this.debug = debug;
        this.testingMode = testingMode;
        this.shared = shared;
    }

    @Override
    public void setDefaultWebServicesUri(String defaultWebServicesUri) {
        this.defaultWebServicesUri = defaultWebServicesUri;
    }

    @Override
    public void setUsingProxy(boolean usingProxy) {
        this.usingProxy = usingProxy;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public String getEnvironment() {
        return this.environment;
    }

    @Override
    public String getPodId() {
        return this.podId;
    }

    @Override
    public String getProfile() {
        return this.profile;
    }

    @Override
    public String getCustomDomain() {
        return this.customDomain;
    }

    @Override
    public String getBaseDomain() {
        return this.baseDomain;
    }

    @Override
    public int getWebServicesPort() {
        return this.webServicesPort;
    }

    @Override
    public String getWebServicesUri() {
        if (StringUtils.isNotBlank((CharSequence)this.defaultWebServicesUri)) {
            return this.defaultWebServicesUri;
        }
        return this.webServicesUri;
    }

    @Override
    public String getOriginalWebServicesUri() {
        return this.webServicesUri;
    }

    @Override
    public boolean isUsingProxy() {
        return this.usingProxy;
    }

    @Override
    public String getServicesApi() {
        return this.extensionBrokerApi;
    }

    @Override
    public String getServicesApiVersion() {
        return this.extensionBrokerApiVersion;
    }

    @Override
    public boolean isLocalDeployment() {
        return this.localDeployment;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public Json getServiceConfiguration() {
        return this.serviceConfiguration;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public boolean isShared() {
        return this.shared;
    }

    @Override
    public boolean isTestingMode() {
        return this.testingMode;
    }

    @Override
    public Json toJson() {
        return Json.map().set("_service_name", this.getServiceName()).set("_app_name", this.getApplicationName()).set("_environment", this.getEnvironment()).set("_pod_id", this.getPodId()).set("_profile", this.getProfile()).set("_custom_domain", this.getCustomDomain()).set("_base_domain", this.getBaseDomain()).set("_webservices_port", this.getWebServicesPort()).set("_webservices_uri", this.getWebServicesUri()).set("_extension_broker_api", this.getServicesApi()).set("_extension_broker_version", this.getServicesApiVersion()).set("_local_deployment", this.isLocalDeployment()).set("_token", this.getToken()).set("_service_config", this.getServiceConfiguration()).set("_debug", this.isDebug()).set("_shared", this.isShared()).set("_original_webservices_uri", this.getOriginalWebServicesUri()).set("_testing_mode", this.isTestingMode()).set("_using_proxy", this.isUsingProxy());
    }
}

