/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.configurations;

import io.slingr.services.configurations.Definitions;
import io.slingr.services.configurations.Properties;
import io.slingr.services.configurations.ServiceDefinitions;
import io.slingr.services.configurations.ServicesProperties;
import io.slingr.services.configurations.sources.EnvVarsSource;
import io.slingr.services.configurations.sources.JsonMapSource;
import io.slingr.services.configurations.sources.JvmPropertiesSource;
import io.slingr.services.configurations.sources.PropertiesFileSource;
import io.slingr.services.configurations.sources.PropertySource;
import io.slingr.services.exceptions.ErrorCode;
import io.slingr.services.exceptions.ServiceException;
import io.slingr.services.utils.Json;
import io.slingr.services.utils.converters.JsonSource;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger logger = LoggerFactory.getLogger(Configuration.class);
    public static final String PROPERTY_SERVICE_NAME = "_service_name";
    public static final String PROPERTY_APPLICATION_NAME = "_app_name";
    public static final String PROPERTY_ENVIRONMENT = "_environment";
    public static final String PROPERTY_POD_ID = "_pod_id";
    public static final String PROPERTY_PROFILE = "_profile";
    public static final String PROPERTY_CUSTOM_DOMAIN = "_custom_domain";
    public static final String PROPERTY_BASE_DOMAIN = "_base_domain";
    public static final String PROPERTY_WEBSERVICES_PORT = "_webservices_port";
    public static final String PROPERTY_WEBSERVICES_URI = "_webservices_uri";
    public static final String PROPERTY_ORIGINAL_WEBSERVICES_URI = "_original_webservices_uri";
    public static final String PROPERTY_EXTENSION_BROKER_API = "_extension_broker_api";
    public static final String PROPERTY_EXTENSION_BROKER_VERSION = "_extension_broker_version";
    public static final String PROPERTY_LOCAL_DEPLOYMENT = "_local_deployment";
    public static final String PROPERTY_TOKEN = "_token";
    public static final String PROPERTY_SERVICE_CONFIG = "_service_config";
    public static final String PROPERTY_DEBUG = "_debug";
    public static final String PROPERTY_IS_SHARED = "_shared";
    public static final String PROPERTY_USING_PROXY = "_using_proxy";
    public static final String PROPERTY_TESTING_MODE = "_testing_mode";
    public static final String PROPERTY_USE_SSL = "_use_ssl";
    public static final String DEFINITION_LABEL = "label";
    public static final String DEFINITION_TYPE = "name";
    public static final String DEFINITION_API_VERSION = "apiVersion";
    public static final String DEFINITION_INTERNAL = "internal";
    public static final String DEFINITION_CONFIGURATION_TYPE = "configurationType";
    public static final String DEFINITION_CONFIGURATION_TYPE_PER_USER = "PER_USER";
    public static final String DEFINITION_CONFIGURATION_TYPE_GLOBAL = "GLOBAL";
    public static final String DEFINITION_DEPLOYMENT = "deployment";
    public static final String DEFINITION_DEPLOYMENT_PROFILES = "profiles";
    public static final String DEFINITION_DEPLOYMENT_PROFILES_NAME = "name";
    public static final String DEFINITION_DEPLOYMENT_ALLOW_INSTANCES = "allowMultipleInstances";
    public static final String DEFINITION_ICON = "icon48";
    public static final String DEFINITION_HELP_URL = "configurationHelpUrl";
    public static final String DEFINITION_STATUS = "status";
    public static final String DEFINITION_STATUS_ACTIVE = "ACTIVE";
    public static final String DEFINITION_STATUS_DISABLED = "DISABLED";
    public static final String DEFINITION_DATA_STORES = "stores";
    public static final String DEFINITION_DATA_STORES_NAME = "name";
    public static final String DEFINITION_EVENTS = "events";
    public static final String DEFINITION_EVENTS_NAME = "name";
    public static final String DEFINITION_FUNCTIONS = "functions";
    public static final String DEFINITION_FUNCTIONS_NAME = "name";
    public static final String DEFINITION_UI_CONFIGURATION = "configuration";
    public static final String DEFINITION_UI_USER_CONFIGURATION = "userConfiguration";
    public static final String DEFINITION_UI_USER_CONFIGURATION_BUTTONS = "userConfigurationButtons";
    private final String definitionsFile;
    private final List<PropertySource> sources = new ArrayList<PropertySource>();

    public Configuration(JsonSource jsonSource) {
        this(jsonSource, null);
    }

    public Configuration(String propertyFile) {
        this(null, propertyFile);
    }

    public Configuration() {
        this(null, null);
    }

    public Configuration(JsonSource jsonSource, String propertyFile) {
        this(null, jsonSource, propertyFile);
    }

    public Configuration(String definitionsFile, JsonSource jsonSource, String propertyFile) {
        if (jsonSource != null) {
            this.sources.add(new JsonMapSource(jsonSource));
        }
        if (StringUtils.isNotBlank((CharSequence)propertyFile)) {
            this.sources.add(new PropertiesFileSource(propertyFile, true));
        }
        this.sources.add(new EnvVarsSource());
        this.sources.add(new JvmPropertiesSource());
        this.sources.add(new PropertiesFileSource("default.properties", true));
        this.definitionsFile = StringUtils.isNotBlank((CharSequence)definitionsFile) ? definitionsFile : "appService.json";
    }

    public ServiceDefinitions definitions() throws ServiceException {
        if (StringUtils.isBlank((CharSequence)this.definitionsFile)) {
            throw ServiceException.permanent(ErrorCode.GENERAL, "Definitions file name is invalid");
        }
        try {
            Json definitions = Json.fromLocalFile(this.definitionsFile);
            return this.definitions(definitions);
        }
        catch (ServiceException ee) {
            throw ee;
        }
        catch (Exception ex) {
            throw ServiceException.permanent(ErrorCode.GENERAL, (Object)String.format("Exception when try to read the service definitions: %s", ex.getMessage()), ex);
        }
    }

    ServiceDefinitions definitions(Json definitions) throws ServiceException {
        if (definitions == null || definitions.isEmpty()) {
            throw ServiceException.permanent(ErrorCode.GENERAL, "Empty definitions content");
        }
        DefinitionsBuilder builder = new DefinitionsBuilder();
        try {
            Json userConfigurationButtons;
            List<Json> userConfiguration;
            List<Json> configuration;
            List<Json> functions;
            List<Json> events;
            String status;
            String configurationHelpUrl;
            String label = definitions.string(DEFINITION_LABEL);
            if (StringUtils.isBlank((CharSequence)label)) {
                throw ServiceException.permanent(ErrorCode.GENERAL, String.format("Empty service label on service definitions [%s]. Service label is required.", label));
            }
            builder.label = label;
            String type = definitions.string("name");
            if (StringUtils.isBlank((CharSequence)type)) {
                throw ServiceException.permanent(ErrorCode.GENERAL, String.format("Empty service name on service definitions [%s]. Service name is required.", type));
            }
            builder.type = type;
            String apiVersion = definitions.string(DEFINITION_API_VERSION);
            if (StringUtils.isNotBlank((CharSequence)apiVersion)) {
                builder.apiVersion = apiVersion;
            }
            builder.internal = definitions.bool(DEFINITION_INTERNAL, false);
            String configurationType = definitions.string(DEFINITION_CONFIGURATION_TYPE, "");
            builder.perUserService = StringUtils.isNotBlank((CharSequence)configurationType) ? DEFINITION_CONFIGURATION_TYPE_PER_USER.equalsIgnoreCase(configurationType) : definitions.bool(DEFINITION_CONFIGURATION_TYPE_PER_USER, false);
            Json deployment = definitions.json(DEFINITION_DEPLOYMENT, null);
            if (deployment == null || deployment.isEmpty()) {
                throw ServiceException.permanent(ErrorCode.GENERAL, String.format("Empty deployment on service definitions [%s]. At least one deployment profile is required.", deployment));
            }
            List<Json> deploymentProfiles = deployment.jsons(DEFINITION_DEPLOYMENT_PROFILES);
            if (deploymentProfiles == null || deploymentProfiles.isEmpty()) {
                throw ServiceException.permanent(ErrorCode.GENERAL, String.format("Empty deployment profiles on service definitions [%s]. At least one deployment profile is required.", deploymentProfiles));
            }
            builder.deploymentProfiles = deploymentProfiles;
            builder.allowMultipleInstances = deployment.bool(DEFINITION_DEPLOYMENT_ALLOW_INSTANCES, false);
            String icon = definitions.string(DEFINITION_ICON);
            if (StringUtils.isNotBlank((CharSequence)icon)) {
                builder.icon = icon;
            }
            if (StringUtils.isNotBlank((CharSequence)(configurationHelpUrl = definitions.string(DEFINITION_HELP_URL)))) {
                builder.configurationHelpUrl = configurationHelpUrl;
            }
            builder.active = StringUtils.isNotBlank((CharSequence)(status = definitions.string(DEFINITION_STATUS, ""))) ? DEFINITION_STATUS_ACTIVE.equalsIgnoreCase(status) : definitions.bool(DEFINITION_STATUS_ACTIVE, false);
            List<Json> dataStores = definitions.jsons(DEFINITION_DATA_STORES);
            if (dataStores != null && !dataStores.isEmpty()) {
                builder.dataStores = dataStores;
            }
            if ((events = definitions.jsons(DEFINITION_EVENTS)) != null && !events.isEmpty()) {
                builder.events = events;
            }
            if ((functions = definitions.jsons(DEFINITION_FUNCTIONS)) != null && !functions.isEmpty()) {
                builder.functions = functions;
            }
            if ((configuration = definitions.jsons(DEFINITION_UI_CONFIGURATION)) != null && !configuration.isEmpty()) {
                builder.configuration = configuration;
            }
            if ((userConfiguration = definitions.jsons(DEFINITION_UI_USER_CONFIGURATION)) != null && !userConfiguration.isEmpty()) {
                builder.userConfiguration = userConfiguration;
            }
            if ((userConfigurationButtons = definitions.json(DEFINITION_UI_USER_CONFIGURATION_BUTTONS)) != null && !userConfigurationButtons.isEmpty()) {
                builder.userConfigurationButtons = userConfigurationButtons;
            }
        }
        catch (ServiceException ee) {
            throw ee;
        }
        catch (Exception ex) {
            throw ServiceException.permanent(ErrorCode.GENERAL, (Object)String.format("Exception when try to read the service definitions: %s", ex.getMessage()), ex);
        }
        return builder.build();
    }

    public ServicesProperties properties() throws ServiceException {
        PropertiesBuilder builder = new PropertiesBuilder();
        try {
            String token;
            String extensionBrokerApi;
            boolean localDeployment;
            Integer webServicesPort;
            String baseDomain;
            String customDomain;
            String profile;
            String serviceName = Configuration.resolveProperty(this.sources, PROPERTY_SERVICE_NAME);
            if (StringUtils.isBlank((CharSequence)serviceName)) {
                throw ServiceException.permanent(ErrorCode.GENERAL, String.format("Empty service name on properties [%s]. Service name is required.", serviceName));
            }
            builder.serviceName = serviceName;
            String applicationName = Configuration.resolveProperty(this.sources, PROPERTY_APPLICATION_NAME);
            if (StringUtils.isBlank((CharSequence)applicationName)) {
                throw ServiceException.permanent(ErrorCode.GENERAL, String.format("Empty application name on properties [%s]. Application name is required.", applicationName));
            }
            builder.applicationName = applicationName;
            String environment = Configuration.resolveProperty(this.sources, PROPERTY_ENVIRONMENT);
            if (StringUtils.isBlank((CharSequence)environment)) {
                throw ServiceException.permanent(ErrorCode.GENERAL, String.format("Empty environment name on properties [%s]. Environment name is required.", environment));
            }
            builder.environment = environment;
            String podId = Configuration.resolveProperty(this.sources, PROPERTY_POD_ID, "-");
            if (podId != null) {
                builder.podId = podId;
            }
            if ((profile = Configuration.resolveProperty(this.sources, PROPERTY_PROFILE, "default")) != null) {
                builder.profile = profile;
            }
            if ((customDomain = Configuration.resolveProperty(this.sources, PROPERTY_CUSTOM_DOMAIN, "")) != null) {
                builder.customDomain = customDomain;
            }
            if ((baseDomain = Configuration.resolveProperty(this.sources, PROPERTY_BASE_DOMAIN, "")) != null) {
                builder.baseDomain = baseDomain;
            }
            if ((webServicesPort = Configuration.resolveIntegerProperty(this.sources, PROPERTY_WEBSERVICES_PORT, 10000)) != null) {
                builder.webServicesPort = webServicesPort;
            }
            builder.localDeployment = localDeployment = Configuration.resolveBooleanProperty(this.sources, PROPERTY_LOCAL_DEPLOYMENT, false);
            String webServicesUri = Configuration.resolveProperty(this.sources, PROPERTY_WEBSERVICES_URI, "");
            if (StringUtils.isBlank((CharSequence)webServicesUri)) {
                if (localDeployment) {
                    webServicesUri = String.format("http://localhost:%s", webServicesPort);
                } else {
                    String domain = String.format("https://%s.%s/%s", applicationName, baseDomain, environment).toLowerCase();
                    webServicesUri = String.format("%s/services/%s", domain, serviceName);
                }
            }
            if (webServicesUri != null) {
                builder.webServicesUri = webServicesUri;
            }
            if (StringUtils.isBlank((CharSequence)(extensionBrokerApi = Configuration.resolveProperty(this.sources, PROPERTY_EXTENSION_BROKER_API, "https://extension-broker/api")))) {
                throw ServiceException.permanent(ErrorCode.GENERAL, String.format("Empty Service Services API URI on properties [%s]. URI is required.", extensionBrokerApi));
            }
            builder.extensionBrokerApi = extensionBrokerApi;
            String extensionBrokerApiVersion = Configuration.resolveProperty(this.sources, PROPERTY_EXTENSION_BROKER_VERSION, "v1");
            if (extensionBrokerApiVersion != null) {
                builder.extensionBrokerApiVersion = extensionBrokerApiVersion;
            }
            if (StringUtils.isNotBlank((CharSequence)(token = Configuration.resolveProperty(this.sources, PROPERTY_TOKEN)))) {
                builder.token = token;
            } else if (localDeployment) {
                builder.token = String.format("%s/%s/%s", applicationName, environment, serviceName);
            } else {
                throw ServiceException.permanent(ErrorCode.GENERAL, String.format("Empty token on properties [%s]. Token is required.", token));
            }
            Json serviceConfiguration = Configuration.resolveJsonProperty(this.sources, PROPERTY_SERVICE_CONFIG);
            if (serviceConfiguration != null) {
                builder.serviceConfiguration = serviceConfiguration;
            }
            builder.debug = Configuration.resolveBooleanProperty(this.sources, PROPERTY_DEBUG, false);
            builder.testingMode = Configuration.resolveBooleanProperty(this.sources, PROPERTY_TESTING_MODE, false);
            builder.shared = Configuration.resolveBooleanProperty(this.sources, PROPERTY_IS_SHARED, false);
        }
        catch (ServiceException ee) {
            throw ee;
        }
        catch (Exception ex) {
            throw ServiceException.permanent(ErrorCode.GENERAL, (Object)String.format("Exception when try to read the properties: %s", ex.getMessage()), ex);
        }
        return builder.build();
    }

    public static Json resolveJsonProperty(List<PropertySource> sources, String propertyName) {
        return Configuration.resolveJsonProperty(sources, propertyName, null);
    }

    public static Json resolveJsonProperty(List<PropertySource> sources, String propertyName, Json defaultValue) {
        String response = Configuration.resolveProperty(sources, propertyName);
        Json json = null;
        if (StringUtils.isNotBlank((CharSequence)response)) {
            try {
                json = Json.parse(response);
            }
            catch (Exception ex) {
                logger.warn(String.format("Exception when try to convert json for property [%s], json [%s]: [%s]", propertyName, response, ex.getMessage()));
                json = null;
            }
        }
        return json != null ? json : (defaultValue != null ? defaultValue : Json.map());
    }

    public static boolean resolveBooleanProperty(List<PropertySource> sources, String propertyName) {
        return Configuration.resolveBooleanProperty(sources, propertyName, null);
    }

    public static boolean resolveBooleanProperty(List<PropertySource> sources, String propertyName, Boolean defaultValue) {
        String response = Configuration.resolveProperty(sources, propertyName);
        return Configuration.parseBooleanValue(response, defaultValue);
    }

    public static boolean parseBooleanValue(String value) {
        return Configuration.parseBooleanValue(value, null);
    }

    public static boolean parseBooleanValue(String value, Boolean defaultValue) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            switch (value.trim().toLowerCase()) {
                case "0": 
                case "no": 
                case "false": 
                case "disable": 
                case "disabled": 
                case "off": {
                    return false;
                }
                case "1": 
                case "yes": 
                case "true": 
                case "enable": 
                case "enabled": 
                case "on": 
                case "ok": {
                    return true;
                }
            }
        }
        return defaultValue != null && Boolean.TRUE.equals(defaultValue);
    }

    public static Integer resolveIntegerProperty(List<PropertySource> sources, String propertyName) {
        return Configuration.resolveIntegerProperty(sources, propertyName, null);
    }

    public static Integer resolveIntegerProperty(List<PropertySource> sources, String propertyName, Integer defaultValue) {
        String response = Configuration.resolveProperty(sources, propertyName);
        Integer value = null;
        if (StringUtils.isNotBlank((CharSequence)response)) {
            try {
                value = Integer.parseInt(response);
            }
            catch (Exception ex) {
                value = null;
            }
        }
        return value != null ? value.intValue() : (defaultValue != null ? defaultValue : null).intValue();
    }

    public static String resolveProperty(List<PropertySource> sources, String propertyName) {
        return Configuration.resolveProperty(sources, propertyName, null);
    }

    private static String resolveProperty(List<PropertySource> sources, String propertyName, String defaultValue) {
        String response = null;
        try {
            for (PropertySource source : sources) {
                response = source.findProperty(propertyName);
                if (response == null) continue;
                return response;
            }
        }
        catch (Exception e) {
            logger.warn(String.format("Exception when try to read [%s] property: [%s]", propertyName, e.getMessage()));
            response = "";
        }
        return StringUtils.isNotBlank(response) ? response : defaultValue;
    }

    private static class PropertiesBuilder {
        private String serviceName = "";
        private String applicationName = "";
        private String environment = "";
        private String podId = "";
        private String profile = "default";
        private String customDomain = "";
        private String baseDomain = "";
        private int webServicesPort = 10000;
        private String webServicesUri = "";
        private String extensionBrokerApi = "https://extension-broker/api";
        private String extensionBrokerApiVersion = "v1";
        private boolean localDeployment = false;
        private String token = "";
        private Json serviceConfiguration = Json.map();
        private boolean debug = false;
        private boolean shared = false;
        private boolean testingMode = false;

        private PropertiesBuilder() {
        }

        public ServicesProperties build() {
            return new Properties(this.serviceName, this.applicationName, this.environment, this.podId, this.profile, this.customDomain, this.baseDomain, this.webServicesPort, this.webServicesUri, this.extensionBrokerApi, this.extensionBrokerApiVersion, this.localDeployment, this.token, this.serviceConfiguration, this.debug, this.testingMode, this.shared);
        }
    }

    private static class DefinitionsBuilder {
        private String label = "";
        private String type = "";
        private String apiVersion = "v1";
        private boolean internal = false;
        private boolean perUserService = false;
        private List<Json> deploymentProfiles = new ArrayList<Json>();
        private boolean allowMultipleInstances = false;
        private String icon = "";
        private String configurationHelpUrl = "";
        private boolean active = true;
        private List<Json> dataStores = new ArrayList<Json>();
        private List<Json> events = new ArrayList<Json>();
        private List<Json> functions = new ArrayList<Json>();
        private List<Json> configuration = new ArrayList<Json>();
        private List<Json> userConfiguration = new ArrayList<Json>();
        private Json userConfigurationButtons = Json.map();

        private DefinitionsBuilder() {
        }

        public ServiceDefinitions build() {
            return new Definitions(this.label, this.type, this.apiVersion, this.internal, this.perUserService, this.deploymentProfiles, this.allowMultipleInstances, this.icon, this.configurationHelpUrl, this.active, this.dataStores, this.events, this.functions, this.configuration, this.userConfiguration, this.userConfigurationButtons);
        }
    }
}

