/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.services;

import io.slingr.services.configurations.ServiceContext;
import io.slingr.services.exceptions.ErrorCode;
import io.slingr.services.exceptions.ServiceException;
import io.slingr.services.services.Events;
import io.slingr.services.services.Files;
import io.slingr.services.services.IHttpExceptionConverter;
import io.slingr.services.services.rest.DownloadedFile;
import io.slingr.services.services.rest.HttpRequest;
import io.slingr.services.services.rest.RestClient;
import io.slingr.services.services.rest.RestMethod;
import io.slingr.services.utils.Json;
import io.slingr.services.utils.converters.XmlToJsonParser;
import io.slingr.services.ws.exchange.FunctionRequest;
import io.slingr.services.ws.exchange.WebServiceRequest;
import io.slingr.services.ws.exchange.WebServiceResponse;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpService
extends RestClient {
    private static final Logger logger = LoggerFactory.getLogger(HttpService.class);
    public static final String FILE_DOWNLOADED_EVENT = "fileDownloaded";
    public static final String WEBHOOK_EVENT = "webhook";
    public static final String CALLBACK_EVENT = "callback";
    private final Events events;
    private final Files files;
    private IHttpExceptionConverter exceptionConverter = null;

    public HttpService(String apiUri, Events events, Files files, boolean debug) {
        super(apiUri);
        this.setDebug(debug);
        this.events = events;
        this.files = files;
    }

    public void setupExceptionConverter(IHttpExceptionConverter exceptionConverter) {
        this.exceptionConverter = exceptionConverter;
    }

    public Json defaultGetRequest(FunctionRequest request) {
        Json params = request.getJsonParams();
        params.set("app", request.getApp());
        params.set("env", request.getEnv());
        return this.defaultGetRequest(params, request.getFunctionId());
    }

    public Json defaultGetRequest(Json request) {
        return this.defaultGetRequest(request, null);
    }

    public Json defaultGetRequest(Json request, String fromFunctionId) {
        return this.defaultGetRequest(HttpRequest.fromJson(RestMethod.GET, request), fromFunctionId);
    }

    public Json defaultGetRequest(HttpRequest request, String fromFunctionId) {
        try {
            if (request.isForceDownload()) {
                if (request.isDownloadSync()) {
                    return this.downloadFileAndUploadToPlatform(request);
                }
                String app = ServiceContext.getCurrentApp();
                String env = ServiceContext.getCurrentEnv();
                Executors.newSingleThreadExecutor().execute(() -> {
                    try {
                        ServiceContext.initContext(app, env);
                        Json uploadedFileToPlatform = this.downloadFileAndUploadToPlatform(request);
                        this.events.send(null, FILE_DOWNLOADED_EVENT, uploadedFileToPlatform, fromFunctionId, null, null, 1);
                    }
                    catch (Exception e) {
                        logger.warn(String.format("Exception when try to send the 'fileDownloaded' event - exception: %s", e.getMessage()), (Throwable)e);
                    }
                });
                if (request.isFullResponse()) {
                    return Json.map().set("body", "ok").set("fullResponse", true);
                }
                return Json.map().set("body", "ok");
            }
            this.processCallback(request, fromFunctionId);
            return this.httpGet(request);
        }
        catch (Exception ex) {
            throw this.convertToServiceException(ex);
        }
    }

    private Json downloadFileAndUploadToPlatform(HttpRequest request) {
        String path;
        DownloadedFile file = this.httpDownload(request);
        String fileName = request.getFilename();
        if ((StringUtils.isBlank((CharSequence)fileName) || fileName.equals("file")) && (fileName = HttpService.extractFileNameFromHeader(file, fileName)).equals("file") && StringUtils.isEmpty((CharSequence)(fileName = HttpService.extractFileName(path = request.getPath())))) {
            fileName = "file";
        }
        return this.files.upload(fileName, file);
    }

    private static String extractFileNameFromHeader(DownloadedFile file, String fileName) {
        if (file.getHeaders().string("content-disposition") != null) {
            String[] parts;
            for (String part : parts = file.getHeaders().string("content-disposition").split(";")) {
                if (!part.trim().startsWith("filename")) continue;
                return part.substring(part.indexOf(61) + 1).trim().replace("\"", "");
            }
        }
        return "file";
    }

    public static String extractFileName(String path) {
        String fileName;
        if (StringUtils.isEmpty((CharSequence)path)) {
            fileName = "";
        } else {
            String[] parts = StringUtils.split((String)path.trim(), (String)"/");
            fileName = parts[parts.length - 1];
            parts = StringUtils.split((String)fileName, (String)"?");
            fileName = parts[0];
        }
        return fileName;
    }

    public Json defaultPostRequest(FunctionRequest request) {
        return this.defaultPostRequest(request.getJsonParams(), request.getFunctionId());
    }

    public Json defaultPostRequest(Json request, String functionId) {
        return this.defaultPostRequest(HttpRequest.fromJson(RestMethod.POST, request), functionId);
    }

    public Json defaultPostRequest(HttpRequest request, String functionId) {
        try {
            if (request.isMultipart()) {
                return this.httpMultipart(request, this.files);
            }
            this.processCallback(request, functionId);
            return this.httpPost(request);
        }
        catch (Exception ex) {
            throw this.convertToServiceException(ex);
        }
    }

    public Json defaultPutRequest(FunctionRequest request) {
        return this.defaultPutRequest(request.getJsonParams(), request.getFunctionId());
    }

    public Json defaultPutRequest(Json request, String functionId) {
        return this.defaultPutRequest(HttpRequest.fromJson(RestMethod.PUT, request), functionId);
    }

    public Json defaultPutRequest(HttpRequest request, String functionId) {
        try {
            if (request.isMultipart()) {
                return this.httpMultipart(request, this.files);
            }
            this.processCallback(request, functionId);
            return this.httpPut(request);
        }
        catch (Exception ex) {
            throw this.convertToServiceException(ex);
        }
    }

    public Json defaultDeleteRequest(FunctionRequest request) {
        return this.defaultDeleteRequest(request.getJsonParams(), request.getFunctionId());
    }

    public Json defaultDeleteRequest(Json request, String functionId) {
        return this.defaultDeleteRequest(HttpRequest.fromJson(RestMethod.DELETE, request), functionId);
    }

    public Json defaultDeleteRequest(HttpRequest request, String functionId) {
        try {
            this.processCallback(request, functionId);
            return this.httpDelete(request);
        }
        catch (Exception ex) {
            throw this.convertToServiceException(ex);
        }
    }

    public Json defaultHeadRequest(FunctionRequest request) {
        return this.defaultHeadRequest(request.getJsonParams(), request.getFunctionId());
    }

    public Json defaultHeadRequest(Json request, String functionId) {
        return this.defaultHeadRequest(HttpRequest.fromJson(RestMethod.HEAD, request), functionId);
    }

    public Json defaultHeadRequest(HttpRequest request, String functionId) {
        try {
            this.processCallback(request, functionId);
            return this.httpHead(request);
        }
        catch (Exception ex) {
            throw this.convertToServiceException(ex);
        }
    }

    public Json defaultPatchRequest(FunctionRequest request) {
        return this.defaultPatchRequest(request.getJsonParams(), request.getFunctionId());
    }

    public Json defaultPatchRequest(Json request, String functionId) {
        return this.defaultPatchRequest(HttpRequest.fromJson(RestMethod.PATCH, request), functionId);
    }

    public Json defaultPatchRequest(HttpRequest request, String functionId) {
        try {
            this.processCallback(request, functionId);
            return this.httpPatch(request);
        }
        catch (Exception ex) {
            throw this.convertToServiceException(ex);
        }
    }

    public Json defaultOptionsRequest(FunctionRequest request) {
        return this.defaultOptionsRequest(request.getJsonParams(), request.getFunctionId());
    }

    public Json defaultOptionsRequest(Json request, String functionId) {
        return this.defaultOptionsRequest(HttpRequest.fromJson(RestMethod.OPTIONS, request), functionId);
    }

    public Json defaultOptionsRequest(HttpRequest request, String functionId) {
        try {
            this.processCallback(request, functionId);
            return this.httpOptions(request);
        }
        catch (Exception ex) {
            throw this.convertToServiceException(ex);
        }
    }

    public WebServiceResponse defaultWebhookProcessor(WebServiceRequest request) {
        this.events.send(WEBHOOK_EVENT, HttpService.defaultWebhookConverter(request));
        return HttpService.defaultWebhookResponse();
    }

    public ServiceException convertToServiceException(Exception exception) {
        ServiceException response = null;
        if (this.exceptionConverter != null) {
            response = this.exceptionConverter.convertToServiceException(exception);
        }
        if (response == null) {
            response = HttpService.defaultConvertToServiceException(exception);
        }
        return response;
    }

    public static ServiceException defaultConvertToServiceException(Exception exception) {
        ServiceException response;
        if (exception instanceof ServiceException) {
            String description;
            Json dt;
            Json ai;
            Json ex = ((ServiceException)exception).toJson(true);
            if (ex.string("message").startsWith("HTTP ") && ex.contains("additionalInfo") && (ai = ex.json("additionalInfo")).contains("details") && (dt = ai.json("details")).contains("error") && StringUtils.isNotBlank((CharSequence)(description = dt.json("error").string("description")))) {
                ai.set("originalMessage", ex.string("message"));
                return ServiceException.permanent(((ServiceException)exception).getCode(), description, ai, exception);
            }
            response = (ServiceException)exception;
        } else {
            response = ServiceException.permanent(ErrorCode.API, (Object)exception.getMessage(), exception);
        }
        return response;
    }

    public static Json defaultWebhookConverter(WebServiceRequest request) {
        Json json = request.toJson();
        if (request.getBody() != null) {
            String contentType = request.getHeader("Content-Type");
            if (StringUtils.isNotBlank((CharSequence)contentType)) {
                if ((contentType = contentType.toLowerCase()).contains("json")) {
                    try {
                        json.set("body", request.getJsonBody());
                    }
                    catch (Exception ex) {
                        json.set("body", request.getBody());
                    }
                } else if (contentType.contains("xml")) {
                    try {
                        json.set("body", XmlToJsonParser.parse(request.getBody().toString().trim()));
                    }
                    catch (Exception ex) {
                        json.set("body", request.getBody());
                    }
                } else {
                    json.set("body", request.getBody());
                }
            } else {
                json.set("body", request.getBody());
            }
        } else {
            json.set("body", "");
        }
        return json;
    }

    public static WebServiceResponse defaultWebhookResponse() {
        return HttpService.defaultWebhookResponse(null);
    }

    public static WebServiceResponse defaultWebhookResponse(String response) {
        return HttpService.defaultWebhookResponse(response, 200);
    }

    public static WebServiceResponse defaultWebhookResponse(String response, int code) {
        return new WebServiceResponse(code, (Object)(StringUtils.isBlank((CharSequence)response) ? "ok" : response), ContentType.TEXT_PLAIN.toString());
    }

    private void processCallback(HttpRequest request, String functionId) {
        if (request.isDefaultCallback()) {
            Executors.newSingleThreadExecutor().execute(() -> {
                try {
                    Json body = request.getJsonBody();
                    this.events.send(CALLBACK_EVENT, body, functionId);
                }
                catch (Exception e) {
                    logger.warn(String.format("Exception when try to send the 'callback' event - exception: %s", e.getMessage()), (Throwable)e);
                }
            });
        }
    }
}

