/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.services;

import io.slingr.services.configurations.ServiceContext;
import io.slingr.services.exceptions.ErrorCode;
import io.slingr.services.exceptions.ServiceException;
import io.slingr.services.services.ExtensionBrokerApi;
import io.slingr.services.services.application.AppUser;
import io.slingr.services.services.datastores.DataStoreResponse;
import io.slingr.services.services.exchange.ApiUri;
import io.slingr.services.services.logs.AppLogLevel;
import io.slingr.services.services.rest.DownloadedFile;
import io.slingr.services.services.rest.RestClient;
import io.slingr.services.utils.FilesUtils;
import io.slingr.services.utils.Json;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionBroker
extends RestClient
implements ExtensionBrokerApi {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionBroker.class);

    public ExtensionBroker(String uri, String token, String version) throws ServiceException {
        super(uri);
        this.setupDefaultHeader("token", token);
        this.setupDefaultHeader("version", version);
        this.setDefaultEmptyPath("");
        this.setFollowRedirects(true);
        this.setAllowExternalUrl(false);
        this.setUploadParameter("file");
        this.setUploadBody("data");
    }

    @Override
    public void newEvent(Long date, String event, Object data, String fromFunctionId, String userId, String userEmail) throws ServiceException {
        ExtensionBroker.isNotBlank(event, "empty event name");
        if (date == null) {
            date = System.currentTimeMillis();
        }
        Json restContent = Json.map().set("date", date).set("event", event).setIfNotNull("data", data).setIfNotEmpty("fromFunction", fromFunctionId).setIfNotEmpty("userId", userId).setIfNotEmpty("userEmail", userEmail);
        try {
            this.post(this.target("/services/events"), (Object)restContent, this.buildHeaders());
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ServiceException.retryable(ErrorCode.CLIENT, (Object)String.format("Exception when try to send the event [%s]: %s", event, ex.getMessage()), ex);
        }
    }

    @Override
    public Object newSyncEvent(Long date, String event, Object data, String fromFunctionId, String userId, String userEmail) throws ServiceException {
        ExtensionBroker.isNotBlank(event, "empty event name");
        if (date == null) {
            date = System.currentTimeMillis();
        }
        Json restContent = Json.map().set("date", date).set("event", event).setIfNotNull("data", data).setIfNotEmpty("fromFunction", fromFunctionId).setIfNotEmpty("userId", userId).setIfNotEmpty("userEmail", userEmail);
        try {
            Json jsonResponse = this.post(this.target("/services/events/sync"), (Object)restContent, this.buildHeaders());
            return this.getSyncObject(jsonResponse);
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ServiceException.retryable(ErrorCode.CLIENT, (Object)String.format("Exception when try to send the sync event [%s]: %s", event, ex.getMessage()), ex);
        }
    }

    @Override
    public void newAppLogs(Long date, String level, String message, Json additionalInfo) throws ServiceException {
        ExtensionBroker.isNotBlank(message, "empty app log message");
        if (date == null) {
            date = System.currentTimeMillis();
        }
        level = AppLogLevel.checkStringValue(level);
        if (additionalInfo == null) {
            additionalInfo = Json.map();
        }
        Json restContent = Json.map().set("date", date).set("level", level).set("message", message).setIfNotEmpty("additionalInfo", additionalInfo);
        try {
            this.post(this.target("/services/logs"), (Object)restContent, this.buildHeaders());
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ServiceException.retryable(ErrorCode.CLIENT, (Object)String.format("Exception when try to send an app log: %s", ex.getMessage()), ex);
        }
    }

    @Override
    public Json acquireLock(String key) throws ServiceException {
        ExtensionBroker.isNotBlank(key, "empty key to lock");
        try {
            return this.post(this.target(ApiUri.esLockUrl(key)), null, this.buildHeaders());
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ServiceException.retryable(ErrorCode.CLIENT, (Object)String.format("Exception when try to lock key [%s]: %s", key, ex.getMessage()), ex);
        }
    }

    @Override
    public Json releaseLock(String key) throws ServiceException {
        ExtensionBroker.isNotBlank(key, "empty key to unlock");
        try {
            return this.delete(this.target(ApiUri.esLockUrl(key)), this.buildHeaders());
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ServiceException.retryable(ErrorCode.CLIENT, (Object)String.format("Exception when try to lock key [%s]: %s", key, ex.getMessage()), ex);
        }
    }

    @Override
    public Json uploadFile(String filename, InputStream content, String contentType) throws ServiceException {
        Json uploadResult;
        FileInputStream inputStream;
        ExtensionBroker.isNotBlank(filename, "empty file name");
        ExtensionBroker.isNotNull(content, "empty file content");
        File tmp = FilesUtils.copyInputStreamToTemporaryFile(filename, content);
        if (tmp == null || !tmp.exists()) {
            logger.warn(String.format("Local copy not created for file [%s]. The file will not be uploaded.", filename));
            throw ServiceException.permanent(ErrorCode.CONVERSION, String.format("File [%s] was not uploaded. The file could not be downloaded.", filename));
        }
        long fileLength = tmp.length();
        if (fileLength < 1L) {
            logger.warn(String.format("Empty local copy of file [%s]. The file will not be uploaded.", filename));
            return null;
        }
        try {
            inputStream = new FileInputStream(tmp);
        }
        catch (Exception ex) {
            throw ServiceException.permanent(ErrorCode.CONVERSION, (Object)String.format("File [%s] was not uploaded. The local copy of file was not readable - Exception: %s", filename, ex.getMessage()), ex);
        }
        MediaType mediaType = FilesUtils.getMediaTypeForMultipart(contentType, filename);
        if (mediaType != null) {
            contentType = mediaType.toString();
        }
        if ((uploadResult = this.upload(this.target("/services/files"), null, this.buildHeaders(), false, inputStream, filename, contentType)) == null || uploadResult.isEmpty()) {
            throw ServiceException.permanent(ErrorCode.CLIENT, String.format("File [%s] was not uploaded. Empty response from extension broker.", filename));
        }
        String fileId = uploadResult.string("fileId");
        if (StringUtils.isBlank((CharSequence)fileId)) {
            throw ServiceException.permanent(ErrorCode.CLIENT, String.format("File [%s] was not uploaded. Result message: %s", filename, uploadResult));
        }
        return Json.map().setIfNotEmpty("fileId", fileId).setIfNotEmpty("fileName", filename).setIfNotEmpty("contentType", contentType);
    }

    @Override
    public DownloadedFile downloadFile(String fileId) throws ServiceException {
        ExtensionBroker.isNotBlank(fileId, "empty file id");
        try {
            return this.download(this.target(ApiUri.esFileDownloadUrl(fileId)), this.buildHeaders());
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ServiceException.retryable(ErrorCode.CLIENT, (Object)String.format("Exception when try to download file [%s]: %s", fileId, ex.getMessage()), ex);
        }
    }

    @Override
    public Json getFileMetadata(String fileId) throws ServiceException {
        ExtensionBroker.isNotBlank(fileId, "empty file id");
        try {
            return this.get(this.target(ApiUri.esFileMetadataUrl(fileId)), this.buildHeaders());
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ServiceException.retryable(ErrorCode.CLIENT, (Object)String.format("Exception when try to get file [%s] metadata: %s", fileId, ex.getMessage()), ex);
        }
    }

    @Override
    public DataStoreResponse findDocuments(String dataStoreName, Json filter) throws ServiceException {
        DataStoreResponse dsResponse;
        block7: {
            ExtensionBroker.isNotBlank(dataStoreName, "empty data store name");
            filter = ExtensionBroker.checkDataStoreFilter(filter);
            dsResponse = null;
            try {
                WebTarget path = this.target(ApiUri.esDataStoreUrl(dataStoreName), filter);
                Json response = this.get(path, this.buildHeaders());
                if (response == null || !response.contains("items")) break block7;
                try {
                    dsResponse = new DataStoreResponse(response.jsons("items"), response.integer("total"), response.string("_offset"));
                }
                catch (Exception ex) {
                    throw ServiceException.retryable(ErrorCode.CONVERSION, (Object)String.format("Exception when convert data store response [%s]: %s", dataStoreName, ex.getMessage()), ex);
                }
            }
            catch (ServiceException ex) {
                throw ex;
            }
            catch (Exception ex) {
                String message = ex.getMessage();
                if (!message.startsWith("Exception when try to find documents on data store")) {
                    message = String.format("Exception when try to find documents on data store [%s]: %s", dataStoreName, ex.getMessage());
                }
                throw ServiceException.retryable(ErrorCode.CLIENT, (Object)message, ex);
            }
        }
        if (dsResponse == null) {
            dsResponse = new DataStoreResponse(null, 0, null);
        }
        return dsResponse;
    }

    @Override
    public Json countDocuments(String dataStoreName, Json filter) throws ServiceException {
        ExtensionBroker.isNotBlank(dataStoreName, "empty data store name");
        filter = ExtensionBroker.checkDataStoreFilter(filter);
        try {
            WebTarget path = this.target(ApiUri.esDataStoreCountUrl(dataStoreName), filter);
            return this.get(path, this.buildHeaders());
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String message = ex.getMessage();
            if (!message.startsWith("Exception when try to count documents on data store")) {
                message = String.format("Exception when try to count documents on data store [%s]: %s", dataStoreName, ex.getMessage());
            }
            throw ServiceException.retryable(ErrorCode.CLIENT, (Object)message, ex);
        }
    }

    @Override
    public Json getDocument(String dataStoreName, String documentId) throws ServiceException {
        ExtensionBroker.isNotBlank(dataStoreName, "empty data store name");
        ExtensionBroker.isNotBlank(documentId, "empty document id");
        try {
            return this.get(this.target(ApiUri.esDataStoreByIdUrl(dataStoreName, documentId)), this.buildHeaders());
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ServiceException.retryable(ErrorCode.CLIENT, (Object)String.format("Exception when try to find document [%s] on data store [%s]: %s", documentId, dataStoreName, ex.getMessage()), ex);
        }
    }

    @Override
    public Json saveDocument(String dataStoreName, Json document) throws ServiceException {
        ExtensionBroker.isNotBlank(dataStoreName, "empty data store name");
        ExtensionBroker.isNotNull(document, "empty document");
        try {
            return this.post(this.target(ApiUri.esDataStoreUrl(dataStoreName)), (Object)document, this.buildHeaders());
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ServiceException.retryable(ErrorCode.CLIENT, (Object)String.format("Exception when try to save document on data store [%s]: %s", dataStoreName, ex.getMessage()), ex);
        }
    }

    @Override
    public Json updateDocument(String dataStoreName, String documentId, Json document) throws ServiceException {
        ExtensionBroker.isNotBlank(dataStoreName, "empty data store name");
        ExtensionBroker.isNotBlank(documentId, "empty document id");
        ExtensionBroker.isNotNull(document, "empty document");
        try {
            return this.put(this.target(ApiUri.esDataStoreByIdUrl(dataStoreName, documentId)), (Object)document, this.buildHeaders());
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ServiceException.retryable(ErrorCode.CLIENT, (Object)String.format("Exception when try to update document [%s] on data store [%s]: %s", documentId, dataStoreName, ex.getMessage()), ex);
        }
    }

    @Override
    public Json removeDocuments(String dataStoreName, Json filter) throws ServiceException {
        ExtensionBroker.isNotBlank(dataStoreName, "empty data store name");
        filter = ExtensionBroker.checkDataStoreFilter(filter);
        try {
            WebTarget path = this.target(ApiUri.esDataStoreUrl(dataStoreName), filter);
            return this.delete(path, this.buildHeaders());
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ServiceException.retryable(ErrorCode.CLIENT, (Object)String.format("Exception when try to remove document on data store [%s]: %s", dataStoreName, ex.getMessage()), ex);
        }
    }

    @Override
    public Json removeDocument(String dataStoreName, String documentId) throws ServiceException {
        ExtensionBroker.isNotBlank(dataStoreName, "empty data store name");
        ExtensionBroker.isNotBlank(documentId, "empty document id");
        try {
            WebTarget path = this.target(ApiUri.esDataStoreByIdUrl(dataStoreName, documentId));
            return this.delete(path, this.buildHeaders());
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ServiceException.retryable(ErrorCode.CLIENT, (Object)String.format("Exception when try to remove document [%s] on data store [%s]: %s", documentId, dataStoreName, ex.getMessage()), ex);
        }
    }

    @Override
    public Json getConfiguration() throws ServiceException {
        try {
            return this.get(this.target("/services/configuration"), this.buildHeaders());
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ServiceException.retryable(ErrorCode.CLIENT, (Object)String.format("Exception when try to request the configuration: %s", ex.getMessage()), ex);
        }
    }

    @Override
    public AppUser getUserInformationByToken(String token) throws ServiceException {
        ExtensionBroker.isNotBlank(token, "empty token");
        try {
            Json response = this.get(this.target("/services/users").queryParam("userToken", new Object[]{token}), this.buildHeaders());
            AppUser user = AppUser.fromJson(response);
            if (user != null) {
                return user;
            }
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ServiceException.retryable(ErrorCode.CLIENT, (Object)String.format("Exception when try to find user by token [%s]: %s", token, ex.getMessage()), ex);
        }
        throw ServiceException.permanent(ErrorCode.ARGUMENT, String.format("User not found with token [%s]", token));
    }

    @Override
    public AppUser getUserInformationByEmail(String email) throws ServiceException {
        ExtensionBroker.isNotBlank(email, "empty email");
        try {
            Json response = this.get(this.target("/services/users").queryParam("userEmail", new Object[]{email}), this.buildHeaders());
            AppUser user = AppUser.fromJson(response);
            if (user != null) {
                return user;
            }
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ServiceException.retryable(ErrorCode.CLIENT, (Object)String.format("Exception when try to find user by email [%s]: %s", email, ex.getMessage()), ex);
        }
        throw ServiceException.permanent(ErrorCode.ARGUMENT, String.format("User not found with email [%s]", email));
    }

    @Override
    public void clearCache() throws ServiceException {
        try {
            this.put(this.target("/services/management/clearCache"), null, this.buildHeaders());
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ServiceException.retryable(ErrorCode.CLIENT, (Object)"Exception when trying to clear cache of the app", ex);
        }
    }

    public static void isNotBlank(String value, String message) throws ServiceException {
        if (StringUtils.isBlank((CharSequence)value)) {
            logger.error(message);
            throw ServiceException.permanent(ErrorCode.ARGUMENT, message);
        }
    }

    public static void isNotNull(Object value, String message) throws ServiceException {
        if (value == null) {
            logger.error(message);
            throw ServiceException.permanent(ErrorCode.ARGUMENT, message);
        }
    }

    public static Json checkDataStoreFilter(Json filter) {
        if (filter == null) {
            filter = Json.map();
        } else if (filter.isList()) {
            if (!filter.isEmpty()) {
                logger.warn(String.format("data store filter will be ignored because is a list: %s", filter));
            }
            filter = Json.map();
        }
        return filter;
    }

    private Object getSyncObject(Json jsonResponse) {
        Object response = null;
        if (jsonResponse != null) {
            response = jsonResponse;
            if (jsonResponse.isMap()) {
                if (jsonResponse.contains("__sync_response__")) {
                    response = jsonResponse.object("__sync_response__");
                } else if (jsonResponse.contains("__sync_error_response__")) {
                    throw ServiceException.permanent(ErrorCode.CLIENT, jsonResponse.object("__sync_error_response__"));
                }
            }
        }
        if (response == null) {
            response = Json.map();
        }
        if (response instanceof Map || response instanceof List) {
            response = Json.fromObject(response);
        }
        return response;
    }

    private Json buildHeaders() {
        Json headers = Json.map();
        headers.setIfNotEmpty("app", ServiceContext.getCurrentApp());
        headers.setIfNotEmpty("env", ServiceContext.getCurrentEnv());
        return headers;
    }
}

