/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.utils;

import com.sun.mail.imap.IMAPBodyPart;
import io.slingr.services.utils.Base64Utils;
import io.slingr.services.utils.FilesUtils;
import io.slingr.services.utils.Json;
import io.slingr.services.utils.converters.JsonConverter;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.MimetypesFileTypeMap;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import net.htmlparser.jericho.Source;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailUtils {
    private static final Logger logger = LoggerFactory.getLogger(FilesUtils.class);
    public static final String PARAMETER_ID = "messageId";
    public static final String PARAMETER_TEXT = "textBody";
    public static final String PARAMETER_HTML = "htmlBody";
    public static final String PARAMETER_FROM = "fromEmail";
    private static final String spacers = "[\\s,/\\.\\-]";
    private static final String dayPattern = "(?:(?:Mon(?:day)?)|(?:Tue(?:sday)?)|(?:Wed(?:nesday)?)|(?:Thu(?:rsday)?)|(?:Fri(?:day)?)|(?:Sat(?:urday)?)|(?:Sun(?:day)?))";
    private static final String dayOfMonthPattern = String.format("[0-3]?[0-9]%s*(?:(?:th)|(?:st)|(?:nd)|(?:rd))?", "[\\s,/\\.\\-]");
    private static final String monthPattern = "(?:(?:Jan(?:uary)?)|(?:Feb(?:uary)?)|(?:Mar(?:ch)?)|(?:Apr(?:il)?)|(?:May)|(?:Jun(?:e)?)|(?:Jul(?:y)?)|(?:Aug(?:ust)?)|(?:Sep(?:tember)?)|(?:Oct(?:ober)?)|(?:Nov(?:ember)?)|(?:Dec(?:ember)?)|(?:[0-1]?[0-9]))";
    private static final String yearPattern = "(?:[1-2]?[0-9])[0-9][0-9]";
    private static final String timePattern = "(?:[0-2])?[0-9]:[0-5][0-9](?::[0-5][0-9])?(?:(?:\\s)?[AP]M)?";
    private static final String datePattern = String.format("(?:%s%s+)?(?:(?:%s%s+%s)|(?:%s%s+%s))%s+%s", "(?:(?:Mon(?:day)?)|(?:Tue(?:sday)?)|(?:Wed(?:nesday)?)|(?:Thu(?:rsday)?)|(?:Fri(?:day)?)|(?:Sat(?:urday)?)|(?:Sun(?:day)?))", "[\\s,/\\.\\-]", dayOfMonthPattern, "[\\s,/\\.\\-]", "(?:(?:Jan(?:uary)?)|(?:Feb(?:uary)?)|(?:Mar(?:ch)?)|(?:Apr(?:il)?)|(?:May)|(?:Jun(?:e)?)|(?:Jul(?:y)?)|(?:Aug(?:ust)?)|(?:Sep(?:tember)?)|(?:Oct(?:ober)?)|(?:Nov(?:ember)?)|(?:Dec(?:ember)?)|(?:[0-1]?[0-9]))", "(?:(?:Jan(?:uary)?)|(?:Feb(?:uary)?)|(?:Mar(?:ch)?)|(?:Apr(?:il)?)|(?:May)|(?:Jun(?:e)?)|(?:Jul(?:y)?)|(?:Aug(?:ust)?)|(?:Sep(?:tember)?)|(?:Oct(?:ober)?)|(?:Nov(?:ember)?)|(?:Dec(?:ember)?)|(?:[0-1]?[0-9]))", "[\\s,/\\.\\-]", dayOfMonthPattern, "[\\s,/\\.\\-]", "(?:[1-2]?[0-9])[0-9][0-9]");
    private static final String dateTimePattern = String.format("(?:%s[\\s,]*(?:(?:at)|(?:@))?\\s*%s)|(?:%s[\\s,]*(?:on)?\\s*%s)", datePattern, "(?:[0-2])?[0-9]:[0-5][0-9](?::[0-5][0-9])?(?:(?:\\s)?[AP]M)?", "(?:[0-2])?[0-9]:[0-5][0-9](?::[0-5][0-9])?(?:(?:\\s)?[AP]M)?", datePattern);
    private static final Pattern CONTENT_TYPE_REMOVE_PATTERN = Pattern.compile("\\s*[;\\n\\r]+.*$", 8);
    private static final String originalMessageSeparator = "-+\\s*(?:Original(?:\\sMessage)?)?\\s*-+(\n|\\<br\\>)";
    private static final Pattern ORIGINAL_MESSAGE_SEPARATOR_PATTERN = Pattern.compile("-+\\s*(?:Original(?:\\sMessage)?)?\\s*-+(\n|\\<br\\>)");
    private static final String gmailQuotedTextBeginning = String.format("(On\\s+%s.*wrote:(\n|\\<br\\>))", dateTimePattern);
    private static final Pattern GMAIL_SEPARATOR_PATTERN = Pattern.compile(gmailQuotedTextBeginning);
    private static final String outlookSeparator = "(From:\\s+.*(\n|\\<br\\>))(Sent:\\s+.*(\n|\\<br\\>))";
    private static final Pattern OUTLOOK_SEPARATOR_PATTERN = Pattern.compile("(From:\\s+.*(\n|\\<br\\>))(Sent:\\s+.*(\n|\\<br\\>))", 8);
    private static final String datePatternIphone = "([0-9]{4})-([0-9]{2})-([0-9]{2})";
    private static final String dateTimePatternIphone = String.format("(?:%s[\\s,]*(?:(?:at)|(?:@))?\\s*%s)|(?:%s[\\s,]*(?:on)?\\s*%s)", "([0-9]{4})-([0-9]{2})-([0-9]{2})", "(?:[0-2])?[0-9]:[0-5][0-9](?::[0-5][0-9])?(?:(?:\\s)?[AP]M)?", "(?:[0-2])?[0-9]:[0-5][0-9](?::[0-5][0-9])?(?:(?:\\s)?[AP]M)?", datePattern);
    private static final String iphoneQuotedTextBeginning = String.format("(On\\s+%s.*wrote:(\n|\\<br\\>))", dateTimePatternIphone);
    private static final Pattern IPHONE_SEPARATOR_PATTERN = Pattern.compile(iphoneQuotedTextBeginning);
    private static final String htmlBlockQuotedTextBeginning = "\\<blockquote.*id.*replyBlockquote";
    private static final Pattern HTML_BLOCKQUOTED_SEPARATOR_PATTERN = Pattern.compile("\\<blockquote.*id.*replyBlockquote");
    public static final int ATTACHMENT_MAX_SIZE = 0x200000;
    private static final String emailAddressPattern = "^[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,}$";
    private static final Pattern EMAIL_ADDRESS_PATTERN = Pattern.compile("^[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,}$");

    public static boolean isValidEmail(String value) {
        Matcher matcher;
        return StringUtils.isNotBlank((CharSequence)value) && (matcher = EMAIL_ADDRESS_PATTERN.matcher(value.toUpperCase())).find();
    }

    public static String stripOutOriginalMessage(String email) {
        int startIndex;
        if (email == null) {
            return null;
        }
        Matcher matcher = ORIGINAL_MESSAGE_SEPARATOR_PATTERN.matcher(email = email.replaceAll("\\r", ""));
        if (matcher.find()) {
            startIndex = matcher.start();
            email = email.substring(0, startIndex);
        }
        if ((matcher = GMAIL_SEPARATOR_PATTERN.matcher(email)).find()) {
            startIndex = matcher.start();
            email = email.substring(0, startIndex);
        }
        if ((matcher = OUTLOOK_SEPARATOR_PATTERN.matcher(email)).find()) {
            startIndex = matcher.start();
            email = email.substring(0, startIndex);
        }
        if ((matcher = IPHONE_SEPARATOR_PATTERN.matcher(email)).find()) {
            startIndex = matcher.start();
            email = email.substring(0, startIndex);
        }
        if ((matcher = HTML_BLOCKQUOTED_SEPARATOR_PATTERN.matcher(email)).find()) {
            startIndex = matcher.start();
            email = email.substring(0, startIndex);
        }
        return email.trim();
    }

    public static String parseEmail(String email) {
        if (StringUtils.isNotBlank((CharSequence)email)) {
            return email.trim().toLowerCase();
        }
        return email;
    }

    public static String convertToTextBody(String htmlBody) {
        if (StringUtils.isNotBlank((CharSequence)htmlBody)) {
            Source htmlSource = new Source((CharSequence)StringEscapeUtils.unescapeHtml((String)htmlBody));
            return htmlSource.getRenderer().toString();
        }
        return "";
    }

    public static String parseTextBody(String strippedTextBody, String originalTextBody) {
        if (StringUtils.isBlank((CharSequence)strippedTextBody)) {
            if (StringUtils.isNotBlank((CharSequence)originalTextBody)) {
                strippedTextBody = EmailUtils.stripOutOriginalMessage(originalTextBody);
            }
            if (StringUtils.isBlank((CharSequence)strippedTextBody)) {
                strippedTextBody = "";
            }
        }
        return strippedTextBody;
    }

    public static String parseHtmlBody(String strippedHtmlBody, String htmlBody) {
        if (StringUtils.isBlank((CharSequence)strippedHtmlBody)) {
            strippedHtmlBody = StringUtils.isNotBlank((CharSequence)htmlBody) ? EmailUtils.stripOutOriginalMessage(htmlBody) : "";
        }
        return strippedHtmlBody;
    }

    public static Json generateNotification(String messageId, String fromEmail, String htmlBody, String textBody, String originalTextBody) {
        HashMap<String, String> data = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)messageId)) {
            data.put(PARAMETER_ID, messageId);
        }
        if (StringUtils.isNotBlank((CharSequence)fromEmail)) {
            data.put(PARAMETER_FROM, EmailUtils.parseEmail(fromEmail));
        }
        if (StringUtils.isBlank((CharSequence)originalTextBody)) {
            originalTextBody = EmailUtils.convertToTextBody(htmlBody);
        }
        data.put(PARAMETER_TEXT, EmailUtils.parseTextBody(textBody, originalTextBody));
        data.put(PARAMETER_HTML, EmailUtils.parseHtmlBody(null, htmlBody));
        return Json.fromMap(data);
    }

    public static String getNameFromEmailLine(String from) {
        if (from == null) {
            return "";
        }
        if (from.lastIndexOf("<") != -1 && from.lastIndexOf(">") != -1) {
            int start = from.lastIndexOf("<");
            String name = from.substring(0, start);
            return name.replaceAll("^\\s*\\\"", "").replaceAll("\\\"\\s*$", "").trim();
        }
        return "";
    }

    public static String getEmailFromEmailLine(String from) {
        if (from == null) {
            return "";
        }
        if (from.lastIndexOf("<") != -1 && from.lastIndexOf(">") != -1) {
            int start = from.lastIndexOf("<");
            int end = from.lastIndexOf(">");
            String email = from.substring(start + 1, end);
            return email.trim();
        }
        return from.trim();
    }

    public static long getDate(Object date) {
        if (date instanceof String) {
            FastDateFormat sdf = FastDateFormat.getInstance((String)"EEE MMM dd HH:mm:ss z yyyy");
            try {
                Date dateObj = sdf.parse((String)date);
                return dateObj.getTime();
            }
            catch (Exception e) {
                return new Date().getTime();
            }
        }
        if (date instanceof Date) {
            return ((Date)date).getTime();
        }
        return new Date().getTime();
    }

    public static String convertToHtml(String body) {
        return StringEscapeUtils.escapeHtml((String)body);
    }

    public static String convertToText(String body) {
        Source htmlBody = new Source((CharSequence)StringEscapeUtils.unescapeHtml((String)body));
        return htmlBody.getRenderer().toString();
    }

    public static String getContentType(String contentType) {
        if (StringUtils.isBlank((CharSequence)contentType)) {
            return "text/plain";
        }
        contentType = CONTENT_TYPE_REMOVE_PATTERN.matcher(contentType).replaceAll("");
        return contentType.trim().toLowerCase();
    }

    public static String getContentType(String contentType, String fileName) {
        if (StringUtils.isBlank((CharSequence)contentType) && StringUtils.isBlank((CharSequence)(contentType = URLConnection.guessContentTypeFromName(fileName)))) {
            contentType = MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(fileName);
        }
        return contentType;
    }

    public static Json convertMultipart(Multipart multipart) {
        Json response = Json.map();
        if (multipart != null) {
            String contentType = multipart.getContentType();
            response.setIfNotEmpty("originalContentType", contentType);
            contentType = EmailUtils.getContentType(contentType);
            response.setIfNotEmpty("contentType", contentType);
            try {
                ArrayList<Json> parts = new ArrayList<Json>();
                int partsSize = multipart.getCount();
                for (int i = 0; i < partsSize; ++i) {
                    Json part = EmailUtils.convertPart((Part)multipart.getBodyPart(i), true, 0x200000L);
                    if (part.isEmpty()) continue;
                    parts.add(part);
                    if (part.bool("attachment", false)) continue;
                    if (response.isEmpty("text")) {
                        response.setIfNotEmpty("text", part.string("text"));
                    }
                    if (!response.isEmpty("html")) continue;
                    response.setIfNotEmpty("html", part.string("html"));
                }
                response.setIfNotEmpty("parts", parts);
            }
            catch (MessagingException e) {
                logger.warn("Error checking part of email", (Throwable)e);
            }
            try {
                Json parent = EmailUtils.convertPart(multipart.getParent(), false, 0L);
                response.merge(parent);
            }
            catch (MessagingException e) {
                logger.warn("Error checking parent of email", (Throwable)e);
            }
        }
        return response;
    }

    public static Json convertPart(Part part, boolean expandContent, long attachmentMaxSize) throws MessagingException {
        Json json = Json.map();
        if (part != null) {
            boolean attachment = false;
            boolean base64 = false;
            String stringContent = null;
            Json objectContent = null;
            String contentType = part.getContentType();
            String contentDisposition = part.getDisposition();
            int size = part.getSize();
            if (expandContent && part instanceof BodyPart) {
                if ((long)size > attachmentMaxSize) {
                    logger.warn(String.format("Attachment size [%s] is too big", size));
                } else {
                    try {
                        Object contentObject = part.getContent();
                        if (contentObject != null) {
                            if (StringUtils.isNotBlank((CharSequence)contentDisposition) && (contentDisposition.equalsIgnoreCase("ATTACHMENT") || contentDisposition.equalsIgnoreCase("INLINE"))) {
                                attachment = true;
                                if (contentObject instanceof InputStream) {
                                    stringContent = Base64Utils.encode((InputStream)contentObject);
                                    base64 = true;
                                } else {
                                    stringContent = contentObject.toString();
                                }
                            } else {
                                try {
                                    objectContent = JsonConverter.baseFromObject(contentObject);
                                }
                                catch (Exception e) {
                                    stringContent = contentObject.toString();
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.warn("Exception when try to parse the part content of the email", (Throwable)e);
                    }
                }
            }
            if (size >= 0) {
                json.set("size", size);
            }
            Json headers = Json.map();
            Enumeration hds = part.getAllHeaders();
            while (hds.hasMoreElements()) {
                Header hd = (Header)hds.nextElement();
                String name = hd.getName().trim();
                if (!StringUtils.isNotBlank((CharSequence)name)) continue;
                String value = StringUtils.isNotBlank((CharSequence)hd.getValue()) ? hd.getValue().trim() : "";
                headers.setIfNotEmpty(name, value);
                switch (name.toLowerCase()) {
                    case "from": {
                        List<Json> from = EmailUtils.processReceiversLine(value);
                        if (from == null || from.isEmpty()) break;
                        json.setIfNotEmpty("fromName", from.get(0).string("name"));
                        json.setIfNotEmpty(PARAMETER_FROM, from.get(0).string("email"));
                        break;
                    }
                    case "to": {
                        List<Json> to = EmailUtils.processReceiversLine(value);
                        if (to == null || to.isEmpty()) break;
                        json.setIfNotEmpty("to", to);
                        json.setIfNotEmpty("toName", to.get(0).string("name"));
                        json.setIfNotEmpty("toEmail", to.get(0).string("email"));
                        break;
                    }
                    case "cc": {
                        List<Json> cc = EmailUtils.processReceiversLine(value);
                        if (cc == null || cc.isEmpty()) break;
                        json.setIfNotEmpty("cc", cc);
                        break;
                    }
                    case "bcc": {
                        List<Json> bcc = EmailUtils.processReceiversLine(value);
                        if (bcc == null || bcc.isEmpty()) break;
                        json.setIfNotEmpty("bcc", bcc);
                        break;
                    }
                    case "date": {
                        json.setIfNotEmpty("date", EmailUtils.getDate(value));
                        break;
                    }
                    case "subject": {
                        json.setIfNotEmpty("subject", value);
                        break;
                    }
                    case "content-type": {
                        if (!StringUtils.isBlank((CharSequence)contentType)) break;
                        json.setIfNotEmpty("subject", value);
                    }
                }
            }
            json.setIfNotEmpty("headers", headers);
            if (part instanceof IMAPBodyPart) {
                json.setIfNotEmpty("contentId", ((IMAPBodyPart)part).getContentID());
                json.setIfNotEmpty("contentMD5", ((IMAPBodyPart)part).getContentMD5());
                json.setIfNotEmpty("encoding", ((IMAPBodyPart)part).getEncoding());
            }
            json.setIfNotEmpty("description", part.getDescription());
            json.setIfNotEmpty("contentDisposition", contentDisposition);
            json.setIfNotEmpty("fileName", part.getFileName());
            json.setIfNotEmpty("originalContentType", contentType);
            contentType = EmailUtils.getContentType(contentType);
            json.setIfNotEmpty("contentType", contentType);
            json.setIfNotEmpty("attachment", attachment);
            json.setIfNotEmpty("base64", base64);
            if (StringUtils.isNotBlank((CharSequence)contentType)) {
                if (StringUtils.isNotBlank((CharSequence)stringContent)) {
                    if (contentType.equalsIgnoreCase("text/plain")) {
                        json.setIfNotEmpty("content", stringContent);
                        json.setIfNotEmpty("text", stringContent);
                    } else if (contentType.equalsIgnoreCase("text/html")) {
                        json.setIfNotEmpty("content", stringContent);
                        json.setIfNotEmpty("html", stringContent);
                    } else {
                        json.setIfNotEmpty("content", stringContent);
                    }
                } else if (objectContent != null) {
                    json.setIfNotEmpty("content", objectContent);
                    if (json.isEmpty("text")) {
                        json.setIfNotEmpty("text", objectContent.string("text"));
                    }
                    if (json.isEmpty("html")) {
                        json.setIfNotEmpty("html", objectContent.string("html"));
                    }
                }
            }
        }
        return json;
    }

    public static List<Json> processReceiversLine(String value) {
        ArrayList<Json> receiver = new ArrayList<Json>();
        if (StringUtils.isNotBlank((CharSequence)value)) {
            String[] emails;
            for (String email : emails = value.split(",")) {
                String e = EmailUtils.getEmailFromEmailLine(email);
                if (!StringUtils.isNotBlank((CharSequence)e)) continue;
                receiver.add(Json.map().set("email", e).setIfNotEmpty("name", EmailUtils.getNameFromEmailLine(email)));
            }
        }
        return receiver;
    }
}

