/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.services;

import io.slingr.services.configurations.ServiceContext;
import io.slingr.services.exceptions.ErrorCode;
import io.slingr.services.exceptions.ServiceException;
import io.slingr.services.services.ExtensionBroker;
import io.slingr.services.services.ExtensionBrokerApi;
import io.slingr.services.utils.converters.JsonSource;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Events {
    private static final Logger logger = LoggerFactory.getLogger(Events.class);
    private static final int SYNC_MAX_RETRIES = 5;
    private static final int SYNC_SECONDS_BETWEEN_RETRIES = 5;
    private static final int ASYNC_MAX_RETRIES = 20;
    private static final int ASYNC_SECONDS_BETWEEN_RETRIES = 5;
    private final ExtensionBrokerApi api;
    private final boolean debug;

    public Events(ExtensionBrokerApi api, boolean debug) {
        this.api = api;
        this.debug = debug;
    }

    public void send(String event) throws ServiceException {
        this.send(null, event, null, null, null, null, null);
    }

    public void send(String event, Object data) throws ServiceException {
        this.send(null, event, data, null, null, null, null);
    }

    public void send(String event, String app, String env, Object data) throws ServiceException {
        this.send(null, event, data, null, null, null, app, env, null);
    }

    public void send(String event, Object data, String fromFunctionId) throws ServiceException {
        this.send(null, event, data, fromFunctionId, null, null, null);
    }

    public void send(String event, String app, String env, Object data, String fromFunctionId) throws ServiceException {
        this.send(null, event, data, fromFunctionId, null, null, app, env, null);
    }

    public void send(String event, Object data, String fromFunctionId, String userId) throws ServiceException {
        this.send(null, event, data, fromFunctionId, userId, null, null);
    }

    public void send(String event, Object data, String fromFunctionId, String userId, String userEmail) throws ServiceException {
        this.send(null, event, data, fromFunctionId, userId, userEmail, null);
    }

    public void send(Long date, String event, Object data, String fromFunctionId, String userId, String userEmail) throws ServiceException {
        this.send(date, event, data, fromFunctionId, userId, userEmail, null);
    }

    public void send(Long date, String event, Object data, String fromFunctionId, String userId, String userEmail, Integer retries) throws ServiceException {
        this.send(date, event, data, fromFunctionId, userId, userEmail, null, null, retries);
    }

    public void send(Long date, String event, Object data, String fromFunctionId, String userId, String userEmail, String app, String env, Integer retries) throws ServiceException {
        ExtensionBroker.isNotBlank(event, "empty event name");
        if (date == null) {
            date = System.currentTimeMillis();
        }
        if (retries == null) {
            retries = 20;
        }
        if (retries < 0) {
            retries = 0;
        }
        this.sendAsyncEvent(date, event, data, fromFunctionId, userId, userEmail, app, env, retries, retries);
    }

    public Object sendSync(String event) throws ServiceException {
        return this.sendSync(null, event, null, null, null, null, null);
    }

    public Object sendSync(String event, Object data) throws ServiceException {
        return this.sendSync(null, event, data, null, null, null, null);
    }

    public Object sendSync(String event, String app, String env, Object data) throws ServiceException {
        return this.sendSync(null, event, data, null, null, null, app, env, null);
    }

    public Object sendSync(String event, Object data, String fromFunctionId) throws ServiceException {
        return this.sendSync(null, event, data, fromFunctionId, null, null, null);
    }

    public Object sendSync(String event, Object data, String fromFunctionId, String userId) throws ServiceException {
        return this.sendSync(null, event, data, fromFunctionId, userId, null, null);
    }

    public Object sendSync(String event, Object data, String fromFunctionId, String userId, String userEmail) throws ServiceException {
        return this.sendSync(null, event, data, fromFunctionId, userId, userEmail, null);
    }

    public Object sendSync(Long date, String event, Object data, String fromFunctionId, String userId, String userEmail) throws ServiceException {
        return this.sendSync(date, event, data, fromFunctionId, userId, userEmail, null);
    }

    public Object sendSync(Long date, String event, Object data, String fromFunctionId, String userId, String userEmail, Integer retries) throws ServiceException {
        return this.sendSync(date, event, data, fromFunctionId, userId, userEmail, null, null, retries);
    }

    public Object sendSync(Long date, String event, Object data, String fromFunctionId, String userId, String userEmail, String app, String env, Integer retries) throws ServiceException {
        ExtensionBroker.isNotBlank(event, "empty event name");
        if (date == null) {
            date = System.currentTimeMillis();
        }
        if (retries == null) {
            retries = 5;
        }
        if (retries < 0) {
            retries = 0;
        }
        if (this.debug) {
            logger.info(String.format("%s Sending sync event [%s] [%s]", "DEBUG>", event, data == null ? "-" : (data instanceof String || data instanceof JsonSource ? data.toString() : data.getClass().getName())));
        }
        return this.sendSyncEvent(date, event, data, fromFunctionId, userId, userEmail, app, env, retries, retries);
    }

    private void sendAsyncEvent(long date, String event, Object data, String fromFunctionId, String userId, String userEmail, String app, String env, int retries, int maxRetries) {
        boolean received = false;
        String eventName = StringUtils.isNotBlank((CharSequence)event) ? event : "-";
        ServiceContext.initContext(app, env);
        try {
            if (retries == maxRetries) {
                if (this.debug) {
                    logger.info(String.format("%s Sending async event [%s] [%s]", "DEBUG>", eventName, data == null ? "-" : (data instanceof String || data instanceof JsonSource ? data.toString() : data.getClass().getName())));
                }
            } else {
                logger.info(String.format("Retrying async event [%s], retry [%s/%s]", eventName, maxRetries - retries + 1, maxRetries));
            }
            this.api.newEvent(date, event, data, fromFunctionId, userId, userEmail);
            if (this.debug) {
                logger.info(String.format("%s Async event [%s] sent", "DEBUG>", eventName));
            }
            received = true;
        }
        catch (ServiceException ex) {
            logger.warn(String.format("Exception when try to send async event [%s]: %s", eventName, ex.getMessage()));
        }
        catch (Exception ex) {
            logger.warn(String.format("Exception when try to send async event [%s]: %s", eventName, ex.getMessage()), (Throwable)ex);
        }
        if (!received && retries > 0) {
            int newRetries;
            if (retries > 20) {
                retries = 20;
            }
            if ((newRetries = retries - 1) > 0) {
                Executors.newSingleThreadScheduledExecutor().schedule(() -> this.sendAsyncEvent(date, event, data, fromFunctionId, userId, userEmail, app, env, newRetries, maxRetries), (long)(5 * (21 - retries)), TimeUnit.SECONDS);
            } else {
                logger.warn(String.format("Async event can not be sent to application [%s]", eventName));
            }
        }
    }

    private Object sendSyncEvent(long date, String event, Object data, String fromFunctionId, String userId, String userEmail, String app, String env, int retries, int maxRetries) throws ServiceException {
        ServiceContext.initContext(app, env);
        String eventName = StringUtils.isNotBlank((CharSequence)event) ? event : "-";
        Object response = null;
        ServiceException lastError = null;
        try {
            try {
                response = this.api.newSyncEvent(date, event, data, fromFunctionId, userId, userEmail);
            }
            catch (ServiceException rex) {
                throw rex;
            }
            catch (Exception ex) {
                throw ServiceException.retryable(ErrorCode.CLIENT, (Object)String.format("Exception when try to send sync event [%s]: %s", eventName, ex.getMessage()), ex);
            }
        }
        catch (ServiceException ex) {
            logger.warn(String.format("Exception when try to send sync event [%s]: %s", eventName, ex.getMessage()));
            if (ex.isRetryable()) {
                lastError = ex;
            }
            logger.warn(ex.getMessage());
            throw ex;
        }
        if (response == null) {
            if (retries > 0) {
                int newRetries;
                if (retries > 5) {
                    retries = 5;
                }
                if ((newRetries = retries - 1) > 0) {
                    try {
                        Thread.sleep(5 * (6 - retries) * 1000);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    logger.info(String.format("Retrying sync event [%s], retry [%s/%s]", eventName, maxRetries - newRetries + 1, maxRetries));
                    response = this.sendSyncEvent(date, event, data, fromFunctionId, userId, userEmail, app, env, newRetries, maxRetries);
                } else {
                    lastError = ServiceException.permanent(ErrorCode.CLIENT, String.format("Sync event can not be sent to application [%s]", event));
                }
            }
            if (response == null && lastError != null) {
                logger.warn(lastError.getMessage(), (Throwable)lastError);
                throw lastError;
            }
        } else if (this.debug) {
            logger.info(String.format("%s Sync event [%s] sent - response [%s]", "DEBUG>", eventName, response instanceof JsonSource ? ((JsonSource)response).toJson() : response.toString()));
        }
        return response;
    }
}

