/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.services.rest.authentication.strategy;

import io.slingr.services.services.rest.authentication.strategy.AuthenticationStrategy;
import java.net.URI;
import java.util.Map;
import javax.ws.rs.client.Client;
import oauth.signpost.basic.DefaultOAuthConsumer;

public class OAuthAuthenticationStrategy
implements AuthenticationStrategy {
    private final String consumerKey;
    private final String consumerSecret;

    public OAuthAuthenticationStrategy(Map<String, String> params) {
        this.consumerKey = params.get("consumerKey");
        this.consumerSecret = params.get("consumerSecret");
    }

    @Override
    public void addAuthentication(Client client) {
        client.register(requestContext -> {
            String url = requestContext.getUri().toString();
            DefaultOAuthConsumer consumer = new DefaultOAuthConsumer(this.consumerKey, this.consumerSecret);
            try {
                String signedUrl = consumer.sign(url);
                requestContext.setUri(URI.create(signedUrl));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid authentication: " + e);
            }
        });
    }
}

