/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.services;

import io.slingr.services.exceptions.ErrorCode;
import io.slingr.services.exceptions.ServiceException;
import io.slingr.services.services.ExtensionBrokerApi;
import io.slingr.services.services.application.AppUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppUsers {
    private static final Logger logger = LoggerFactory.getLogger(AppUsers.class);
    private final ExtensionBrokerApi api;
    private final boolean debug;

    public AppUsers(ExtensionBrokerApi api, boolean debug) {
        this.api = api;
        this.debug = debug;
    }

    public AppUser findByToken(String token) throws ServiceException {
        if (this.debug) {
            logger.info(String.format("%s find app user by token [%s]", "DEBUG>", token));
        }
        try {
            AppUser user = this.api.getUserInformationByToken(token);
            if (this.debug) {
                logger.info(String.format("%s found app user by token [%s]: %s", "DEBUG>", token, user != null ? user.toString() : "-"));
            }
            return user;
        }
        catch (ServiceException ex) {
            logger.warn(String.format("Exception when find app user by token: %s", ex.getMessage()), (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            String log = String.format("Exception when find app user by token: %s", ex.getMessage());
            logger.warn(log, (Throwable)ex);
            throw ServiceException.retryable(ErrorCode.CLIENT, (Object)log, ex);
        }
    }

    public AppUser findByEmail(String email) throws ServiceException {
        if (this.debug) {
            logger.info(String.format("%s find app user by email [%s]", "DEBUG>", email));
        }
        try {
            AppUser user = this.api.getUserInformationByEmail(email);
            if (this.debug) {
                logger.info(String.format("%s found app user by email [%s]: %s", "DEBUG>", email, user != null ? user.toString() : "-"));
            }
            return user;
        }
        catch (ServiceException ex) {
            logger.warn(String.format("Exception when find app user by email: %s", ex.getMessage()), (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            String log = String.format("Exception when find app user by email: %s", ex.getMessage());
            logger.warn(log, (Throwable)ex);
            throw ServiceException.retryable(ErrorCode.CLIENT, (Object)log, ex);
        }
    }
}

