/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.utils.converters;

import io.slingr.services.utils.EmailUtils;
import java.util.ArrayList;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;

public enum ContentTypeFormat {
    JSON("application/json", MediaType.APPLICATION_JSON_TYPE),
    FORM_URLENCODED("application/x-www-form-urlencoded", MediaType.APPLICATION_FORM_URLENCODED_TYPE),
    XML("text/xml", MediaType.TEXT_XML_TYPE),
    XML_APP("application/xml", MediaType.APPLICATION_XML_TYPE),
    XML_ATOM("application/atom+xml", MediaType.APPLICATION_ATOM_XML_TYPE),
    XML_SVG("application/svg+xml", MediaType.APPLICATION_SVG_XML_TYPE),
    XML_XHTML("application/xhtml+xml", MediaType.APPLICATION_XHTML_XML_TYPE),
    HTML("text/html", MediaType.TEXT_HTML_TYPE),
    PLAIN_TEXT("text/plain", MediaType.TEXT_PLAIN_TYPE),
    MULTIPART("multipart/form-data", MediaType.MULTIPART_FORM_DATA_TYPE);

    private String mimeType;
    private MediaType mediaType;

    private ContentTypeFormat(String mimeType, MediaType mediaType) {
        this.mimeType = mimeType;
        this.mediaType = mediaType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public boolean match(String contentTypeString) {
        String contentType = EmailUtils.getContentType(contentTypeString);
        return this.mimeType.equalsIgnoreCase(contentType);
    }

    public boolean match(MediaType contentType) {
        return this.mediaType.isCompatible(contentType);
    }

    public static String[] getAcceptedFormats() {
        ArrayList<String> mediaTypes = new ArrayList<String>();
        for (ContentTypeFormat contentTypeFormat : ContentTypeFormat.values()) {
            mediaTypes.add(contentTypeFormat.getMimeType());
        }
        return mediaTypes.toArray(new String[mediaTypes.size()]);
    }

    public static boolean isJsonContentType(MediaType contentType) {
        return contentType != null && JSON.match(contentType);
    }

    public static boolean isJsonContentType(String contentType) {
        return StringUtils.isNotBlank((CharSequence)contentType) && JSON.match(contentType);
    }

    public static boolean isUrlEncodedFormContentType(MediaType contentType) {
        return contentType != null && FORM_URLENCODED.match(contentType);
    }

    public static boolean isUrlEncodedFormContentType(String contentType) {
        return StringUtils.isNotBlank((CharSequence)contentType) && FORM_URLENCODED.match(contentType);
    }

    public static boolean isXmlContentType(MediaType contentType) {
        return contentType != null && (XML.match(contentType) || XML_APP.match(contentType) || XML_ATOM.match(contentType) || XML_SVG.match(contentType) || XML_XHTML.match(contentType));
    }

    public static boolean isXmlContentType(String contentType) {
        return StringUtils.isNotBlank((CharSequence)contentType) && (XML.match(contentType) || XML_APP.match(contentType) || XML_ATOM.match(contentType) || XML_SVG.match(contentType) || XML_XHTML.match(contentType));
    }

    public static boolean isHtmlContentType(MediaType contentType) {
        return contentType != null && HTML.match(contentType);
    }

    public static boolean isHtmlContentType(String contentType) {
        return StringUtils.isNotBlank((CharSequence)contentType) && HTML.match(contentType);
    }

    public static boolean isPlainTextContentType(MediaType contentType) {
        return contentType != null && PLAIN_TEXT.match(contentType);
    }

    public static boolean isPlainTextContentType(String contentType) {
        return StringUtils.isNotBlank((CharSequence)contentType) && PLAIN_TEXT.match(contentType);
    }

    public static boolean isMultipartContentType(MediaType contentType) {
        return contentType != null && MULTIPART.match(contentType);
    }

    public static boolean isMultipartContentType(String contentType) {
        return StringUtils.isNotBlank((CharSequence)contentType) && MULTIPART.match(contentType);
    }
}

