/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.slingr.services.utils.FilesUtils;
import io.slingr.services.utils.converters.JsonConverter;
import io.slingr.services.utils.converters.JsonSource;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Json
implements JsonSource {
    private static final Logger logger = LoggerFactory.getLogger(Json.class);
    private final Map<String, Object> map;
    private final List<Object> list;
    private final boolean isMap;

    private Json(boolean isMap) {
        this.isMap = isMap;
        if (isMap) {
            this.map = new LinkedHashMap<String, Object>();
            this.list = null;
        } else {
            this.map = null;
            this.list = new ArrayList<Object>();
        }
    }

    public static Json map() {
        return new Json(true);
    }

    public static <T> Json map(T obj, MapGenerator<T> mapGenerator) {
        return Json.map().generate(obj, mapGenerator);
    }

    public static Json list() {
        return new Json(false);
    }

    public static <T> Json list(Collection<T> items, ListGenerator<T> listGenerator) {
        return Json.list().generate(items, listGenerator);
    }

    public static Json fromMap(Map<String, ?> map) {
        Json json = Json.map();
        if (map != null) {
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                Json jsonObject;
                Object value = entry.getValue();
                if (value != null && (jsonObject = Json.objectItemToJson(value)) != null) {
                    value = jsonObject;
                }
                json.map.put(entry.getKey(), value);
            }
        }
        return json;
    }

    public static Json fromList(Iterable<Object> list) {
        Json json = Json.list();
        if (list != null) {
            Iterator<Object> iterator = list.iterator();
            while (iterator.hasNext()) {
                Json jsonObject;
                Object item;
                Object value = item = iterator.next();
                if (item != null && (jsonObject = Json.objectItemToJson(item)) != null) {
                    value = jsonObject;
                }
                json.list.add(value);
            }
        }
        return json;
    }

    public static Json fromEnumeration(Enumeration list) {
        if (list != null) {
            return Json.fromList(Collections.list(list));
        }
        return Json.list();
    }

    public static Json fromObject(Object object) {
        return Json.fromObject(object, true);
    }

    public static Json fromObject(Object object, boolean clone) {
        return Json.fromObject(object, clone, false);
    }

    public static Json fromObject(Object object, boolean clone, boolean returnsNullIfInvalid) {
        if (object != null) {
            if (object instanceof Json) {
                if (clone) {
                    return ((Json)object).cloneJson();
                }
                return (Json)object;
            }
            try {
                return JsonConverter.baseFromObject(object, !returnsNullIfInvalid);
            }
            catch (Exception ex) {
                if (returnsNullIfInvalid) {
                    return null;
                }
                throw ex;
            }
        }
        return returnsNullIfInvalid ? null : Json.map();
    }

    public static Json parse(String jsonString) {
        return Json.parse(jsonString, true);
    }

    public static Json parse(String jsonString, boolean showErrors) {
        if (StringUtils.isNotBlank((String)jsonString) && jsonString.trim().startsWith("[")) {
            return Json.fromList(Json.stringToList(jsonString, showErrors));
        }
        return Json.fromMap(Json.stringToMap(jsonString, showErrors));
    }

    public static Map stringToMap(String jsonString) {
        return Json.stringToMap(jsonString, true);
    }

    public static Map stringToMap(String jsonString, boolean showErrors) {
        LinkedHashMap result = Json.stringToObject(jsonString, Map.class, showErrors);
        if (result == null) {
            result = new LinkedHashMap();
        }
        return result;
    }

    public static List stringToList(String jsonString) {
        return Json.stringToList(jsonString, true);
    }

    public static List stringToList(String jsonString, boolean showErrors) {
        ArrayList result = Json.stringToObject(jsonString, List.class, showErrors);
        if (result == null) {
            result = new ArrayList();
        }
        return result;
    }

    public static <T> T stringToObject(String jsonString, Class<T> valueType) {
        return Json.stringToObject(jsonString, valueType, true);
    }

    public static <T> T stringToObject(String jsonString, Class<T> valueType, boolean showErrors) {
        if (StringUtils.isBlank((String)jsonString)) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (T)mapper.readValue(jsonString, valueType);
        }
        catch (UnrecognizedPropertyException upe) {
            throw new RuntimeException(String.format("Unrecognized field [%s]", upe.getPropertyName()));
        }
        catch (IOException e) {
            if (showErrors) {
                logger.trace(String.format("Error parsing JSON string: %s", jsonString));
            }
            throw new RuntimeException("Error parsing JSON string", e);
        }
    }

    public static Json fromLocalFile(String pathName) throws IOException {
        return Json.parse(FilesUtils.readLocalFile(pathName));
    }

    public static Json fromInternalFile(String filename) throws IOException {
        return Json.fromInternalFile(filename, false);
    }

    public static Json fromInternalFile(String filename, boolean absolute) throws IOException {
        return Json.parse(FilesUtils.readInternalFile(filename, absolute));
    }

    public boolean isMap() {
        return this.isMap;
    }

    public boolean isList() {
        return !this.isMap;
    }

    public boolean isEmpty() {
        if (this.isMap()) {
            return this.map.isEmpty();
        }
        return this.list.isEmpty();
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public int size() {
        if (this.isMap()) {
            return this.map.size();
        }
        return this.list.size();
    }

    public <T> Json generate(T obj, MapGenerator<T> mapGenerator) {
        this.notSupportedByList("generate map");
        if (obj != null && mapGenerator != null) {
            mapGenerator.process(obj, this);
        }
        return this;
    }

    public <T> Json generate(Collection<T> items, ListGenerator<T> listGenerator) {
        this.notSupportedByMap("generate list");
        if (items != null && listGenerator != null) {
            for (T item : items) {
                this.pushIfNotNull(listGenerator.element(item));
            }
        }
        return this;
    }

    public void forEachMap(BiConsumer<? super String, ? super Object> action) {
        this.notSupportedByList("for each map");
        this.map.forEach(action);
    }

    public void forEachMapString(BiConsumer<? super String, ? super String> action) {
        this.notSupportedByList("for each map string");
        this.toMapString().forEach(action);
    }

    public void forEachList(Consumer<? super Object> action) {
        this.notSupportedByMap("for each list");
        this.list.forEach(action);
    }

    public Stream<Object> streamList() {
        this.notSupportedByMap("stream list");
        return this.list.stream();
    }

    public Json cloneJson() {
        if (this.isMap()) {
            return Json.fromMap(this.toMap());
        }
        return Json.fromList(this.toList());
    }

    public Map<String, Object> toMap() {
        this.notSupportedByList("to map");
        LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            response.put(entry.getKey(), Json.jsonItemToObject(entry.getValue()));
        }
        return response;
    }

    public Map<String, String> toMapString() {
        this.notSupportedByList("to map string");
        LinkedHashMap<String, String> response = new LinkedHashMap<String, String>();
        Iterator<Map.Entry<String, Object>> iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Object value;
            Map.Entry<String, Object> entry;
            response.put(entry.getKey(), (value = Json.jsonItemToObject((entry = iterator.next()).getValue())) != null ? value.toString() : null);
        }
        return response;
    }

    public List<Object> toList() {
        this.notSupportedByMap("to list");
        ArrayList<Object> response = new ArrayList<Object>();
        for (Object item : this.list) {
            response.add(Json.jsonItemToObject(item));
        }
        return response;
    }

    public Object toObject() {
        if (this.isMap()) {
            return this.toMap();
        }
        return this.toList();
    }

    public Json push(Object value) {
        this.notSupportedByMap("push");
        this.list.add(value);
        return this;
    }

    public Json pushIfNotNull(Object value) {
        if (value != null) {
            return this.push(value);
        }
        return this;
    }

    public Json pushIfNotEmpty(Object value) {
        return this.pushIfNotNull(Json.returnIfNotEmpty(value));
    }

    public Json set(String property, Object value) {
        this.notSupportedByList("set");
        Json.notBlankPropertyName(property);
        if (value instanceof Json) {
            this.set(property, ((Json)value).toObject());
        } else if (value instanceof List) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object o : (List)value) {
                if (o instanceof Json) {
                    list.add(((Json)o).toObject());
                    continue;
                }
                if (o == null) continue;
                list.add(o);
            }
            this.map.put(property, list);
        } else if (value != null) {
            this.map.put(property, value);
        } else {
            this.map.remove(property);
        }
        return this;
    }

    public Json setIfNotEmpty(String property, Object value) {
        return this.setIfNotNull(property, Json.returnIfNotEmpty(value));
    }

    public Json setIfNotNull(String property, Object value) {
        return this.setIf(value != null, property, value);
    }

    public Json setIf(boolean condition, String property, Object value) {
        if (condition) {
            this.set(property, value);
        }
        return this;
    }

    public Json remove(String property) {
        this.notSupportedByList("remove");
        Json.notBlankPropertyName(property);
        this.map.remove(property);
        return this;
    }

    public List<Object> objects() {
        this.notSupportedByMap("objects list");
        return this.list;
    }

    public Object object(int index) {
        this.notSupportedByMap("object by index");
        return this.list.get(index);
    }

    public List<Json> jsons() {
        return this.jsons(true);
    }

    public List<Json> jsons(boolean ignoreInvalidItems) {
        this.notSupportedByMap("jsons list");
        ArrayList<Json> response = new ArrayList<Json>();
        for (Object object : this.list) {
            if (object == null) {
                if (ignoreInvalidItems) continue;
                response.add(null);
                continue;
            }
            Json item = Json.objectItemToJson(object);
            if (item != null) {
                response.add(item);
                continue;
            }
            if (ignoreInvalidItems) continue;
            throw new IllegalStateException("Objects on list cannot be converted to JSON");
        }
        return response;
    }

    public boolean containsObject(Object object) {
        return this.containsObject(true, object);
    }

    private boolean containsObject(boolean validations, Object object) {
        if (validations) {
            this.notSupportedByMap("contains object");
        }
        return this.list.contains(object);
    }

    public Map<String, Object> objectsMap() {
        this.notSupportedByList("objects map");
        return this.map;
    }

    public Set<String> keys() {
        return this.keys(true);
    }

    private Set<String> keys(boolean validations) {
        if (validations) {
            this.notSupportedByList("keys");
        }
        return this.map.keySet();
    }

    public boolean contains(String property) {
        return this.contains(true, property);
    }

    private boolean contains(boolean validations, String property) {
        if (validations) {
            this.notSupportedByList("contains");
            Json.notBlankPropertyName(property);
        }
        return this.map.containsKey(property);
    }

    public Object object(String property) {
        return this.object(true, property);
    }

    public Object object(String property, Object defaultValue) {
        return this.object(true, property, defaultValue);
    }

    private Object object(boolean validations, String property) {
        if (validations) {
            this.notSupportedByList("object");
            Json.notBlankPropertyName(property);
        }
        return this.map.get(property);
    }

    private Object object(boolean validations, String property, Object defaultValue) {
        Object r = null;
        try {
            r = this.object(validations, property);
        }
        catch (Exception ex) {
            logger.trace(String.format("Exception when process property [%s]: %s", property, ex.getMessage()));
        }
        return r != null ? r : defaultValue;
    }

    public boolean isEmpty(String property) {
        return this.isEmpty(true, property);
    }

    private boolean isEmpty(boolean validations, String property) {
        if (validations) {
            this.notSupportedByList("is empty property");
            Json.notBlankPropertyName(property);
        }
        return Json.isEmptyProperty(this.map, property);
    }

    public Json json(String property) {
        return this.json(true, property);
    }

    public Json json(String property, Json defaultValue) {
        return this.json(true, property, defaultValue);
    }

    public Json json(boolean validations, String property) {
        Object obj;
        if (validations) {
            this.notSupportedByList("json");
            Json.notBlankPropertyName(property);
        }
        if ((obj = this.object(false, property)) == null) {
            return null;
        }
        return Json.fromObject(obj, false);
    }

    public Json json(boolean validations, String property, Json defaultValue) {
        Json r = null;
        try {
            r = this.json(validations, property);
        }
        catch (Exception ex) {
            logger.trace(String.format("Exception when process property [%s]: %s", property, ex.getMessage()));
        }
        return r != null ? r : defaultValue;
    }

    public List<Object> objects(String property) {
        return this.objects(true, property);
    }

    public List<Object> objects(String property, List<Object> defaultValue) {
        return this.objects(true, property, defaultValue);
    }

    private List<Object> objects(boolean validations, String property) {
        Json json;
        if (validations) {
            this.notSupportedByList("objects");
            Json.notBlankPropertyName(property);
        }
        if (!this.isEmpty(property) && (json = this.json(false, property)) != null) {
            return json.toList();
        }
        return null;
    }

    private List<Object> objects(boolean validations, String property, List<Object> defaultValue) {
        List<Object> r = null;
        try {
            r = this.objects(validations, property);
        }
        catch (Exception ex) {
            logger.trace(String.format("Exception when process property [%s]: %s", property, ex.getMessage()));
        }
        return r != null ? r : defaultValue;
    }

    public boolean isList(String property) {
        return this.isList(true, property);
    }

    private boolean isList(boolean validations, String property) {
        try {
            List<Object> list;
            if (validations) {
                this.notSupportedByList("is list property");
                Json.notBlankPropertyName(property);
            }
            return (list = this.objects(false, property)) != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean isMap(String property) {
        return this.isMap(true, property);
    }

    private boolean isMap(boolean validations, String property) {
        try {
            Json aMap;
            if (validations) {
                this.notSupportedByList("is map property");
                Json.notBlankPropertyName(property);
            }
            return (aMap = this.json(false, property)) != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public Map objectsMap(String property) {
        return this.objectsMap(true, property);
    }

    public Map objectsMap(String property, Map defaultValue) {
        return this.objectsMap(true, property, defaultValue);
    }

    private Map objectsMap(boolean validations, String property) {
        Json json;
        if (validations) {
            this.notSupportedByList("object maps");
            Json.notBlankPropertyName(property);
        }
        if (!this.isEmpty(property) && (json = this.json(false, property)) != null) {
            return json.objectsMap();
        }
        return null;
    }

    private Map objectsMap(boolean validations, String property, Map defaultValue) {
        Map r = null;
        try {
            r = this.objectsMap(validations, property);
        }
        catch (Exception ex) {
            logger.trace(String.format("Exception when process property [%s]: %s", property, ex.getMessage()));
        }
        return r != null ? r : defaultValue;
    }

    public List<Map> objectsMaps(String property) {
        return this.objectsMaps(true, property);
    }

    public List<Map> objectsMaps(String property, List<Map> defaultValue) {
        return this.objectsMaps(true, property, defaultValue);
    }

    private List<Map> objectsMaps(boolean validations, String property) {
        List<Object> objects;
        if (validations) {
            this.notSupportedByList("object maps");
            Json.notBlankPropertyName(property);
        }
        if (!this.isEmpty(property) && (objects = this.objects(false, property)) != null) {
            ArrayList<Map> list = new ArrayList<Map>();
            for (Object object : objects) {
                list.add(Json.fromObject(object, false).toMap());
            }
            return list;
        }
        return null;
    }

    private List<Map> objectsMaps(boolean validations, String property, List<Map> defaultValue) {
        List<Map> r = null;
        try {
            r = this.objectsMaps(validations, property);
        }
        catch (Exception ex) {
            logger.trace(String.format("Exception when process property [%s]: %s", property, ex.getMessage()));
        }
        return r != null ? r : defaultValue;
    }

    public List<List> lists(String property) {
        return this.lists(true, property);
    }

    public List<List> lists(String property, List<List> defaultValue) {
        return this.lists(true, property, defaultValue);
    }

    private List<List> lists(boolean validations, String property) {
        List<Object> objects;
        if (validations) {
            this.notSupportedByList("lists");
            Json.notBlankPropertyName(property);
        }
        if (!this.isEmpty(property) && (objects = this.objects(false, property)) != null) {
            ArrayList<List> list = new ArrayList<List>();
            for (Object object : objects) {
                list.add(Json.fromObject(object, false).toList());
            }
            return list;
        }
        return null;
    }

    private List<List> lists(boolean validations, String property, List<List> defaultValue) {
        List<List> r = null;
        try {
            r = this.lists(validations, property);
        }
        catch (Exception ex) {
            logger.trace(String.format("Exception when process property [%s]: %s", property, ex.getMessage()));
        }
        return r != null ? r : defaultValue;
    }

    public List<Json> jsons(String property) {
        return this.jsons(true, property);
    }

    public List<Json> jsons(String property, List<Json> defaultValue) {
        return this.jsons(true, property, defaultValue);
    }

    private List<Json> jsons(boolean validations, String property) {
        List<Object> objects;
        if (validations) {
            this.notSupportedByList("jsons");
            Json.notBlankPropertyName(property);
        }
        if (!this.isEmpty(property) && (objects = this.objects(false, property)) != null) {
            ArrayList<Json> list = new ArrayList<Json>();
            for (Object object : objects) {
                list.add(Json.fromObject(object, false));
            }
            return list;
        }
        return null;
    }

    private List<Json> jsons(boolean validations, String property, List<Json> defaultValue) {
        List<Json> r = null;
        try {
            r = this.jsons(validations, property);
        }
        catch (Exception ex) {
            logger.trace(String.format("Exception when process property [%s]: %s", property, ex.getMessage()));
        }
        return r != null ? r : defaultValue;
    }

    public String string(String property) {
        return this.string(true, property);
    }

    public String string(String property, String defaultValue) {
        return this.string(true, property, defaultValue);
    }

    private String string(boolean validations, String property) {
        if (validations) {
            this.notSupportedByList("string");
            Json.notBlankPropertyName(property);
        }
        if (!this.isEmpty(property)) {
            Object object = this.object(false, property);
            if (object != null) {
                return object.toString();
            }
            return null;
        }
        return null;
    }

    private String string(boolean validations, String property, String defaultValue) {
        String r = null;
        try {
            r = this.string(validations, property);
        }
        catch (Exception ex) {
            logger.trace(String.format("Exception when process property [%s]: %s", property, ex.getMessage()));
        }
        return r != null ? r : defaultValue;
    }

    public List<String> strings(String property) {
        return this.strings(true, property);
    }

    public List<String> strings(String property, List<String> defaultValue) {
        return this.strings(true, property, defaultValue);
    }

    private List<String> strings(boolean validations, String property) {
        List<Object> objects;
        if (validations) {
            this.notSupportedByList("strings");
            Json.notBlankPropertyName(property);
        }
        if (!this.isEmpty(property) && (objects = this.objects(false, property)) != null) {
            ArrayList<String> list = new ArrayList<String>();
            for (Object object : objects) {
                if (object == null) continue;
                list.add(object.toString());
            }
            return list;
        }
        return null;
    }

    private List<String> strings(boolean validations, String property, List<String> defaultValue) {
        List<String> r = null;
        try {
            r = this.strings(validations, property);
        }
        catch (Exception ex) {
            logger.trace(String.format("Exception when process property [%s]: %s", property, ex.getMessage()));
        }
        return r != null ? r : defaultValue;
    }

    public Boolean bool(String property) {
        return this.bool(true, property);
    }

    public boolean bool(String property, boolean defaultValue) {
        return this.bool(true, property, defaultValue);
    }

    private Boolean bool(boolean validations, String property) {
        if (validations) {
            this.notSupportedByList("bool");
            Json.notBlankPropertyName(property);
        }
        if (!this.isEmpty(property)) {
            Object object = this.object(false, property);
            return Json.convertToBoolean(object);
        }
        return null;
    }

    private boolean bool(boolean validations, String property, boolean defaultValue) {
        Boolean r = null;
        try {
            r = this.bool(validations, property);
        }
        catch (Exception ex) {
            logger.trace(String.format("Exception when process property [%s]: %s", property, ex.getMessage()));
        }
        return r != null ? r : defaultValue;
    }

    public boolean is(String property) {
        return Boolean.TRUE.equals(this.bool(property));
    }

    public boolean is(String property, boolean defaultValue) {
        return Boolean.TRUE.equals(this.bool(property, defaultValue));
    }

    public List<Boolean> bools(String property) {
        return this.bools(true, property);
    }

    public List<Boolean> bools(String property, List<Boolean> defaultValue) {
        return this.bools(true, property, defaultValue);
    }

    private List<Boolean> bools(boolean validations, String property) {
        List<Object> objects;
        if (validations) {
            this.notSupportedByList("bools");
            Json.notBlankPropertyName(property);
        }
        if (!this.isEmpty(property) && (objects = this.objects(false, property)) != null) {
            ArrayList<Boolean> list = new ArrayList<Boolean>();
            for (Object object : objects) {
                Boolean b = Json.convertToBoolean(object);
                if (b == null) continue;
                list.add(b);
            }
            return list;
        }
        return null;
    }

    private List<Boolean> bools(boolean validations, String property, List<Boolean> defaultValue) {
        List<Boolean> r = null;
        try {
            r = this.bools(validations, property);
        }
        catch (Exception ex) {
            logger.trace(String.format("Exception when process property [%s]: %s", property, ex.getMessage()));
        }
        return r != null ? r : defaultValue;
    }

    public Integer integer(String property) {
        return this.integer(true, property);
    }

    public int integer(String property, int defaultValue) {
        return this.integer(true, property, defaultValue);
    }

    private Integer integer(boolean validations, String property) {
        if (validations) {
            this.notSupportedByList("integer");
            Json.notBlankPropertyName(property);
        }
        if (!this.isEmpty(property)) {
            Object object = this.object(false, property);
            return Json.convertToInteger(object);
        }
        return null;
    }

    private int integer(boolean validations, String property, int defaultValue) {
        Integer r = null;
        try {
            r = this.integer(validations, property);
        }
        catch (Exception ex) {
            logger.trace(String.format("Exception when process property [%s]: %s", property, ex.getMessage()));
        }
        return r != null ? r : defaultValue;
    }

    public List<Integer> integers(String property) {
        return this.integers(true, property);
    }

    public List<Integer> integers(String property, List<Integer> defaultValue) {
        return this.integers(true, property, defaultValue);
    }

    private List<Integer> integers(boolean validations, String property) {
        List<Object> objects;
        if (validations) {
            this.notSupportedByList("integers");
            Json.notBlankPropertyName(property);
        }
        if (!this.isEmpty(property) && (objects = this.objects(false, property)) != null) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (Object object : objects) {
                Integer i = Json.convertToInteger(object);
                if (i == null) continue;
                list.add(i);
            }
            return list;
        }
        return null;
    }

    private List<Integer> integers(boolean validations, String property, List<Integer> defaultValue) {
        List<Integer> r = null;
        try {
            r = this.integers(validations, property);
        }
        catch (Exception ex) {
            logger.trace(String.format("Exception when process property [%s]: %s", property, ex.getMessage()));
        }
        return r != null ? r : defaultValue;
    }

    public Long longInteger(String property) {
        return this.longInteger(true, property);
    }

    public long longInteger(String property, long defaultValue) {
        return this.longInteger(true, property, defaultValue);
    }

    private Long longInteger(boolean validations, String property) {
        if (validations) {
            this.notSupportedByList("long integer");
            Json.notBlankPropertyName(property);
        }
        if (!this.isEmpty(property)) {
            Object object = this.object(false, property);
            return Json.convertToLong(object);
        }
        return null;
    }

    private long longInteger(boolean validations, String property, long defaultValue) {
        Long r = null;
        try {
            r = this.longInteger(validations, property);
        }
        catch (Exception ex) {
            logger.trace(String.format("Exception when process property [%s]: %s", property, ex.getMessage()));
        }
        return r != null ? r : defaultValue;
    }

    public List<Long> longIntegers(String property) {
        return this.longIntegers(true, property);
    }

    public List<Long> longIntegers(String property, List<Long> defaultValue) {
        return this.longIntegers(true, property, defaultValue);
    }

    private List<Long> longIntegers(boolean validations, String property) {
        List<Object> objects;
        if (validations) {
            this.notSupportedByList("long integers");
            Json.notBlankPropertyName(property);
        }
        if (!this.isEmpty(property) && (objects = this.objects(false, property)) != null) {
            ArrayList<Long> list = new ArrayList<Long>();
            for (Object object : objects) {
                Long li = Json.convertToLong(object);
                if (li == null) continue;
                list.add(li);
            }
            return list;
        }
        return null;
    }

    private List<Long> longIntegers(boolean validations, String property, List<Long> defaultValue) {
        List<Long> r = null;
        try {
            r = this.longIntegers(validations, property);
        }
        catch (Exception ex) {
            logger.trace(String.format("Exception when process property [%s]: %s", property, ex.getMessage()));
        }
        return r != null ? r : defaultValue;
    }

    public Double decimal(String property) {
        return this.decimal(true, property);
    }

    public double decimal(String property, double defaultValue) {
        return this.decimal(true, property, defaultValue);
    }

    private Double decimal(boolean validations, String property) {
        if (validations) {
            this.notSupportedByList("decimal");
            Json.notBlankPropertyName(property);
        }
        if (!this.isEmpty(property)) {
            Object object = this.object(false, property);
            return Json.convertToDouble(object);
        }
        return null;
    }

    private Double decimal(boolean validations, String property, double defaultValue) {
        Double r = null;
        try {
            r = this.decimal(validations, property);
        }
        catch (Exception ex) {
            logger.trace(String.format("Exception when process property [%s]: %s", property, ex.getMessage()));
        }
        return r != null ? r : defaultValue;
    }

    public List<Double> decimals(String property) {
        return this.decimals(true, property);
    }

    public List<Double> decimals(String property, List<Double> defaultValue) {
        return this.decimals(true, property, defaultValue);
    }

    private List<Double> decimals(boolean validations, String property) {
        List<Object> objects;
        if (validations) {
            this.notSupportedByList("decimals");
            Json.notBlankPropertyName(property);
        }
        if (!this.isEmpty(property) && (objects = this.objects(false, property)) != null) {
            ArrayList<Double> list = new ArrayList<Double>();
            for (Object object : objects) {
                Double d = Json.convertToDouble(object);
                if (d == null) continue;
                list.add(d);
            }
            return list;
        }
        return null;
    }

    private List<Double> decimals(boolean validations, String property, List<Double> defaultValue) {
        List<Double> r = null;
        try {
            r = this.decimals(validations, property);
        }
        catch (Exception ex) {
            logger.trace(String.format("Exception when process property [%s]: %s", property, ex.getMessage()));
        }
        return r != null ? r : defaultValue;
    }

    public Date date(String property) {
        return this.date(true, property);
    }

    public Date date(String property, Date defaultValue) {
        return this.date(true, property, defaultValue);
    }

    private Date date(boolean validations, String property) {
        if (validations) {
            this.notSupportedByList("date");
            Json.notBlankPropertyName(property);
        }
        if (!this.isEmpty(property)) {
            Object object = this.object(false, property);
            return Json.convertToDate(object);
        }
        return null;
    }

    private Date date(boolean validations, String property, Date defaultValue) {
        Date r = null;
        try {
            r = this.date(validations, property);
        }
        catch (Exception ex) {
            logger.trace(String.format("Exception when process property [%s]: %s", property, ex.getMessage()));
        }
        return r != null ? r : defaultValue;
    }

    public List<Date> dates(String property) {
        return this.dates(true, property);
    }

    public List<Date> dates(String property, List<Date> defaultValue) {
        return this.dates(true, property, defaultValue);
    }

    private List<Date> dates(boolean validations, String property) {
        List<Object> objects;
        if (validations) {
            this.notSupportedByList("dates");
            Json.notBlankPropertyName(property);
        }
        if (!this.isEmpty(property) && (objects = this.objects(false, property)) != null) {
            ArrayList<Date> list = new ArrayList<Date>();
            for (Object object : objects) {
                Date d = Json.convertToDate(object);
                if (d == null) continue;
                list.add(d);
            }
            return list;
        }
        return null;
    }

    private List<Date> dates(boolean validations, String property, List<Date> defaultValue) {
        List<Date> r = null;
        try {
            r = this.dates(validations, property);
        }
        catch (Exception ex) {
            logger.trace(String.format("Exception when process property [%s]: %s", property, ex.getMessage()));
        }
        return r != null ? r : defaultValue;
    }

    public BigInteger bigInteger(String property) {
        return this.bigInteger(true, property);
    }

    public BigInteger bigInteger(String property, BigInteger defaultValue) {
        return this.bigInteger(true, property, defaultValue);
    }

    private BigInteger bigInteger(boolean validations, String property) {
        if (validations) {
            this.notSupportedByList("big integer");
            Json.notBlankPropertyName(property);
        }
        if (!this.isEmpty(property)) {
            Object object = this.object(false, property);
            return Json.convertToBigInteger(object);
        }
        return null;
    }

    private BigInteger bigInteger(boolean validations, String property, BigInteger defaultValue) {
        BigInteger r = null;
        try {
            r = this.bigInteger(validations, property);
        }
        catch (Exception ex) {
            logger.trace(String.format("Exception when process property [%s]: %s", property, ex.getMessage()));
        }
        return r != null ? r : defaultValue;
    }

    public List<BigInteger> bigIntegers(String property) {
        return this.bigIntegers(true, property);
    }

    public List<BigInteger> bigIntegers(String property, List<BigInteger> defaultValue) {
        return this.bigIntegers(true, property, defaultValue);
    }

    private List<BigInteger> bigIntegers(boolean validations, String property) {
        List<Object> objects;
        if (validations) {
            this.notSupportedByList("big integers");
            Json.notBlankPropertyName(property);
        }
        if (!this.isEmpty(property) && (objects = this.objects(false, property)) != null) {
            ArrayList<BigInteger> list = new ArrayList<BigInteger>();
            for (Object object : objects) {
                BigInteger bi = Json.convertToBigInteger(object);
                if (bi == null) continue;
                list.add(bi);
            }
            return list;
        }
        return null;
    }

    private List<BigInteger> bigIntegers(boolean validations, String property, List<BigInteger> defaultValue) {
        List<BigInteger> r = null;
        try {
            r = this.bigIntegers(validations, property);
        }
        catch (Exception ex) {
            logger.trace(String.format("Exception when process property [%s]: %s", property, ex.getMessage()));
        }
        return r != null ? r : defaultValue;
    }

    public BigDecimal bigDecimal(String property) {
        return this.bigDecimal(true, property);
    }

    public BigDecimal bigDecimal(String property, BigDecimal defaultValue) {
        return this.bigDecimal(true, property, defaultValue);
    }

    private BigDecimal bigDecimal(boolean validations, String property) {
        if (validations) {
            this.notSupportedByList("big decimal");
            Json.notBlankPropertyName(property);
        }
        if (!this.isEmpty(property)) {
            Object object = this.object(false, property);
            return Json.convertToBigDecimal(object);
        }
        return null;
    }

    private BigDecimal bigDecimal(boolean validations, String property, BigDecimal defaultValue) {
        BigDecimal r = null;
        try {
            r = this.bigDecimal(validations, property);
        }
        catch (Exception ex) {
            logger.trace(String.format("Exception when process property [%s]: %s", property, ex.getMessage()));
        }
        return r != null ? r : defaultValue;
    }

    public List<BigDecimal> bigDecimals(String property) {
        return this.bigDecimals(true, property);
    }

    public List<BigDecimal> bigDecimals(String property, List<BigDecimal> defaultValue) {
        return this.bigDecimals(true, property, defaultValue);
    }

    private List<BigDecimal> bigDecimals(boolean validations, String property) {
        List<Object> objects;
        if (validations) {
            this.notSupportedByList("big decimals");
            Json.notBlankPropertyName(property);
        }
        if (!this.isEmpty(property) && (objects = this.objects(false, property)) != null) {
            ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
            for (Object object : objects) {
                BigDecimal bd = Json.convertToBigDecimal(object);
                if (bd == null) continue;
                list.add(bd);
            }
            return list;
        }
        return null;
    }

    private List<BigDecimal> bigDecimals(boolean validations, String property, List<BigDecimal> defaultValue) {
        List<BigDecimal> r = null;
        try {
            r = this.bigDecimals(validations, property);
        }
        catch (Exception ex) {
            logger.trace(String.format("Exception when process property [%s]: %s", property, ex.getMessage()));
        }
        return r != null ? r : defaultValue;
    }

    private void notSupportedByMap(String operation) {
        if (this.isMap()) {
            throw new IllegalStateException(String.format("Operation [%s] not supported for a map", operation));
        }
    }

    private void notSupportedByList(String operation) {
        if (this.isList()) {
            throw new IllegalStateException(String.format("Operation [%s] not supported for a list", operation));
        }
    }

    private static void notBlankPropertyName(String propertyName) {
        if (StringUtils.isBlank((String)propertyName)) {
            throw new IllegalArgumentException("Property name is empty");
        }
    }

    private static Object returnIfNotEmpty(Object value) {
        Object notEmptyValue = null;
        if (value != null) {
            if (value instanceof Json) {
                if (((Json)value).isNotEmpty()) {
                    notEmptyValue = value;
                }
            } else if (value instanceof String) {
                if (StringUtils.isNotBlank((String)((String)value))) {
                    notEmptyValue = value;
                }
            } else if (value instanceof Collection) {
                if (!((Collection)value).isEmpty()) {
                    notEmptyValue = value;
                }
            } else if (value instanceof Map && !((Map)value).isEmpty()) {
                notEmptyValue = value;
            }
        }
        return notEmptyValue;
    }

    private static Json objectItemToJson(Object item) {
        Json value = null;
        if (item != null) {
            if (item instanceof Json) {
                value = (Json)item;
            } else if (Map.class.isAssignableFrom(item.getClass())) {
                value = Json.fromMap((Map)item);
            } else if (List.class.isAssignableFrom(item.getClass())) {
                value = Json.fromList((List)item);
            }
        }
        return value;
    }

    private static Object jsonItemToObject(Object item) {
        Object value = item;
        if (item != null) {
            if (item instanceof Json) {
                value = ((Json)((Object)item)).toObject();
            } else if (item instanceof List) {
                value = Json.fromObject(item).toList();
            } else if (item instanceof Map) {
                value = Json.fromObject(item).toMap();
            }
        }
        return value;
    }

    private static boolean isEmptyProperty(Map<String, Object> map, String property) {
        if (map == null || StringUtils.isBlank((String)property)) {
            return true;
        }
        Object value = map.get(property);
        return value == null || value instanceof String && StringUtils.isBlank((String)((String)value));
    }

    private static Integer convertToInteger(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.parseInt(value.toString());
    }

    private static Long convertToLong(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return Long.parseLong(value.toString());
    }

    private static Double convertToDouble(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return Double.parseDouble(value.toString());
    }

    private static Boolean convertToBoolean(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue() != 0L;
        }
        return Boolean.parseBoolean(value.toString());
    }

    private static Date convertToDate(Object value) {
        Long lg;
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        try {
            lg = Json.convertToLong(value);
        }
        catch (Exception ex) {
            lg = null;
        }
        if (lg != null) {
            return new Date(lg);
        }
        try {
            return DateFormat.getDateInstance().parse(value.toString());
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static BigInteger convertToBigInteger(Object value) {
        Long lg;
        if (value == null) {
            return null;
        }
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toBigInteger();
        }
        try {
            lg = Json.convertToLong(value);
        }
        catch (Exception ex) {
            lg = null;
        }
        if (lg != null) {
            return BigInteger.valueOf(lg);
        }
        return null;
    }

    private static BigDecimal convertToBigDecimal(Object value) {
        Double db;
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        try {
            db = Json.convertToDouble(value);
        }
        catch (Exception ex) {
            db = null;
        }
        if (db != null) {
            return BigDecimal.valueOf(db);
        }
        return null;
    }

    public String toString() {
        return Json.objectToString(this.toObject());
    }

    public String toPrettyString() {
        return Json.objectToPrettyString(this.toObject());
    }

    public static String objectToString(Object object) {
        return Json.objectToString(object, false);
    }

    public static String objectToPrettyString(Object object) {
        return Json.objectToString(object, true);
    }

    private static String objectToString(Object object, boolean pretty) {
        String result;
        if (object == null) {
            return "null";
        }
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule mod = new SimpleModule("JSON parser Module");
        mod.addSerializer((JsonSerializer)new CustomSerializer(Json.class));
        mod.addSerializer((JsonSerializer)new CustomFormSerializer());
        mapper.registerModule((Module)mod);
        try {
            result = pretty ? mapper.writerWithDefaultPrettyPrinter().writeValueAsString(object) : mapper.writeValueAsString(object);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not convert object to string", e);
        }
        return result;
    }

    public boolean equals(String jsonString) {
        return StringUtils.isNotBlank((String)jsonString) && this.equals((Object)jsonString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        try {
            if (!Json.class.equals(o.getClass()) && (o = Json.fromObject(o.toString())) == null) {
                return false;
            }
            Json json = (Json)o;
            if (this.isMap() != json.isMap()) {
                return false;
            }
            if (this.isList()) {
                if (this.list.isEmpty()) {
                    return json.list.isEmpty();
                }
                if (json.list.isEmpty()) {
                    return false;
                }
                if (this.list.size() != json.list.size()) {
                    return false;
                }
                if (!this.list.containsAll(json.list) || !json.list.containsAll(this.list)) {
                    return false;
                }
                for (int i = 0; i < this.list.size(); ++i) {
                    if (this.list.get(0) == null || this.list.get(0).equals(json.list.get(0))) continue;
                    return false;
                }
                return true;
            }
            if (this.map.isEmpty()) {
                return json.map.isEmpty();
            }
            if (json.map.isEmpty()) {
                return false;
            }
            if (this.map.size() != json.map.size()) {
                return false;
            }
            if (!this.map.keySet().containsAll(json.map.keySet()) || !json.map.keySet().containsAll(this.map.keySet())) {
                return false;
            }
            for (Map.Entry<String, Object> entry : this.map.entrySet()) {
                Object ov = json.map.get(entry.getKey());
                if (!(entry.getValue() instanceof Json ? !entry.getValue().equals(Json.fromObject(ov)) : (entry.getValue() instanceof Map ? !Json.fromMap((Map)entry.getValue()).equals(Json.fromObject(ov)) : (entry.getValue() instanceof List ? !Json.fromList((List)entry.getValue()).equals(Json.fromObject(ov)) : (entry.getValue() instanceof Number && ov instanceof Number ? this.compareNumbers((Number)entry.getValue(), (Number)ov) != 0 : !entry.getValue().equals(ov)))))) continue;
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private int compareNumbers(Number x, Number y) {
        if (Json.isSpecialNumber(x) || Json.isSpecialNumber(y)) {
            return Double.compare(x.doubleValue(), y.doubleValue());
        }
        return Json.toBigDecimal(x).compareTo(Json.toBigDecimal(y));
    }

    private static boolean isSpecialNumber(Number number) {
        boolean specialDouble = number instanceof Double && (Double.isNaN((Double)number) || Double.isInfinite((Double)number));
        boolean specialFloat = number instanceof Float && (Float.isNaN(((Float)number).floatValue()) || Float.isInfinite(((Float)number).floatValue()));
        return specialDouble || specialFloat;
    }

    private static BigDecimal toBigDecimal(Number number) {
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        if (number instanceof Byte || number instanceof Short || number instanceof Integer || number instanceof Long) {
            return new BigDecimal(number.longValue());
        }
        if (number instanceof Float || number instanceof Double) {
            return new BigDecimal(number.doubleValue());
        }
        try {
            return new BigDecimal(number.toString());
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(String.format("The given number [%s] of class [%s] does not have a parsable string representation", number, number.getClass().getName()), e);
        }
    }

    public int hashCode() {
        int result = 17;
        result += 31 * (this.map != null ? this.map.hashCode() : 0);
        return result += 47 * (this.list != null ? this.list.hashCode() : 0);
    }

    public void merge(Json json) {
        this.merge(json, true);
    }

    public void merge(Json json, boolean mergeInternalValues) {
        if (json == null) {
            return;
        }
        if (this.isMap() != json.isMap()) {
            throw new IllegalArgumentException("You cannot merge a list with a map");
        }
        if (this.isList()) {
            if (mergeInternalValues) {
                json.streamList().filter(o -> !this.containsObject(o)).forEach(this.list::add);
            } else {
                this.list.addAll(json.objects());
            }
        } else if (mergeInternalValues) {
            json.forEachMap((key, value) -> {
                if (value instanceof Json || value instanceof Map || value instanceof List) {
                    Json jsonValue = Json.fromObject(value);
                    boolean saved = false;
                    Object originalValue = this.map.get(key);
                    if (originalValue instanceof Json || originalValue instanceof Map || originalValue instanceof List) {
                        Json originalJsonValue = Json.fromObject(originalValue);
                        if (jsonValue.isMap() == originalJsonValue.isMap()) {
                            try {
                                originalJsonValue.merge(jsonValue, true);
                                this.map.put((String)key, originalJsonValue);
                                saved = true;
                            }
                            catch (Exception ex) {
                                saved = false;
                            }
                        }
                    }
                    if (!saved) {
                        if (jsonValue.isMap()) {
                            this.map.put((String)key, jsonValue.toMap());
                        } else if (jsonValue.isList()) {
                            this.map.put((String)key, jsonValue.toList());
                        } else {
                            this.map.remove(key);
                        }
                    }
                } else {
                    this.map.put((String)key, value);
                }
            });
        } else {
            json.forEachMap((key, value) -> {
                if (value instanceof Json || value instanceof Map || value instanceof List) {
                    this.map.put((String)key, Json.fromObject(value));
                } else {
                    this.map.put((String)key, value);
                }
            });
        }
    }

    public void traverse(Visitor visitor) {
        if (this.isMap()) {
            visitor.enrich("", this);
        }
        this.traverseRecursive(visitor, "", this);
    }

    private void traverseRecursive(Visitor visitor, String path, Json currentLevel) {
        if (currentLevel.isMap()) {
            Map<String, Object> originalLevel = currentLevel.map;
            LinkedHashMap<String, Object> newLevel = new LinkedHashMap<String, Object>();
            for (String key : originalLevel.keySet()) {
                Object newValue;
                Object value = originalLevel.get(key);
                if (value instanceof Json || value instanceof Map || value instanceof List) {
                    Json nested = Json.fromObject(value);
                    if (nested.isMap()) {
                        visitor.enrich(this.buildPath(path, key), nested);
                    }
                    this.traverseRecursive(visitor, this.buildPath(path, key), nested);
                    newValue = visitor.convertValue(key, nested, this.buildPath(path, key));
                } else {
                    newValue = visitor.convertValue(key, value, this.buildPath(path, key));
                }
                newLevel.put(visitor.convertKey(key, path), newValue);
            }
            currentLevel.map.clear();
            currentLevel.map.putAll(newLevel);
        } else {
            List<Object> originalList = currentLevel.list;
            ArrayList<Object> newLevel = new ArrayList<Object>();
            ListIterator<Object> it = originalList.listIterator();
            int index = 0;
            while (it.hasNext()) {
                Object newValue;
                Object item = it.next();
                if (item instanceof Json || item instanceof Map || item instanceof List) {
                    Json nested = Json.fromObject(item);
                    if (nested.isMap()) {
                        visitor.enrich(this.buildPath(path, index), nested);
                    }
                    this.traverseRecursive(visitor, this.buildPath(path, index), nested);
                    newValue = visitor.convertValue(this.buildPath(this.lastPathPart(path), index), nested, this.buildPath(path, index));
                } else {
                    newValue = visitor.convertValue(this.lastPathPart(path), item, this.buildPath(path, index));
                }
                newLevel.add(newValue);
                ++index;
            }
            currentLevel.list.clear();
            currentLevel.list.addAll(newLevel);
        }
    }

    private String buildPath(String prefix, String fieldName) {
        if (StringUtils.isBlank((String)prefix)) {
            return fieldName;
        }
        return prefix + "." + fieldName;
    }

    private String buildPath(String base, int index) {
        return base + "[" + index + "]";
    }

    private String buildPath(String prefix, String fieldName, int index) {
        String base = this.buildPath(prefix, fieldName);
        return base + "[" + index + "]";
    }

    private String lastPathPart(String path) {
        if (StringUtils.isBlank((String)path)) {
            return "";
        }
        String[] parts = StringUtils.split((String)path, (String)".");
        return parts[parts.length - 1];
    }

    @Override
    public Json toJson() {
        return this;
    }

    public static class Visitor {
        public Object convertValue(String key, Object value, String path) {
            return value;
        }

        public void enrich(String path, Json json) {
        }

        public String convertKey(String key, String path) {
            return key;
        }
    }

    private static class CustomFormSerializer
    extends StdSerializer<Form> {
        public CustomFormSerializer() {
            super(Form.class);
        }

        public void serialize(Form form, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            MultivaluedMap obj = form.asMap();
            if (obj != null) {
                JsonSerializer listSerializer = provider.findValueSerializer(Map.class, null);
                listSerializer.serialize((Object)obj, jsonGenerator, provider);
            } else {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeEndObject();
            }
        }
    }

    private static class CustomSerializer
    extends StdSerializer<Json> {
        public CustomSerializer(Class<Json> t) {
            super(t);
        }

        public void serialize(Json json, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            if (json.isMap()) {
                JsonSerializer listSerializer = provider.findValueSerializer(Map.class, null);
                listSerializer.serialize(json.toMap(), jsonGenerator, provider);
            } else if (json.isList()) {
                JsonSerializer listSerializer = provider.findValueSerializer(List.class, null);
                listSerializer.serialize(json.toList(), jsonGenerator, provider);
            } else {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeEndObject();
            }
        }
    }

    public static interface ListGenerator<T> {
        public Object element(T var1);
    }

    public static interface MapGenerator<T> {
        public void process(T var1, Json var2);
    }
}

