/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.services.rest;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public enum RestMethod {
    GET,
    POST,
    PUT,
    PATCH,
    DELETE,
    HEAD,
    OPTIONS;


    public String toInitials() {
        return this.name().substring(0, 2);
    }

    public static RestMethod fromString(String method) {
        if (StringUtils.isNotBlank((CharSequence)method)) {
            try {
                return RestMethod.valueOf(method.toUpperCase());
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static String checkStringValue(String method) {
        RestMethod val = RestMethod.fromString(method);
        if (val == null) {
            val = GET;
        }
        return val.name();
    }

    public static List<RestMethod> all() {
        return Arrays.asList(RestMethod.values());
    }
}

