/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.services;

import io.slingr.services.exceptions.ServiceException;
import io.slingr.services.services.ExtensionBrokerApi;
import io.slingr.services.services.logs.AppLogLevel;
import io.slingr.services.utils.Json;
import io.slingr.services.utils.converters.JsonSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppLogs {
    private static final Logger logger = LoggerFactory.getLogger(AppLogs.class);
    private static final int MAX_LAST_ERRORS_NOTIFIED = 5;
    private final ExtensionBrokerApi api;
    private final boolean debug;
    private int lastErrors = 0;

    public AppLogs(ExtensionBrokerApi api, boolean debug) {
        this.api = api;
        this.debug = debug;
    }

    public void info(String message) {
        this.info(message, null, null);
    }

    public void info(String message, Json additionalInfo) {
        this.info(message, additionalInfo, null);
    }

    public void info(String message, Throwable throwable) {
        this.info(message, null, throwable);
    }

    public void info(String message, Json additionalInfo, Throwable throwable) {
        this.sendAppLog(AppLogLevel.INFO, message, additionalInfo, throwable);
    }

    public void warn(String message) {
        this.warn(message, null, null);
    }

    public void warn(String message, Json additionalInfo) {
        this.warn(message, additionalInfo, null);
    }

    public void warn(String message, Throwable throwable) {
        this.warn(message, null, throwable);
    }

    public void warn(String message, Json additionalInfo, Throwable throwable) {
        this.sendAppLog(AppLogLevel.WARN, message, additionalInfo, throwable);
    }

    public void error(String message) {
        this.error(message, null, null);
    }

    public void error(String message, Json additionalInfo) {
        this.error(message, additionalInfo, null);
    }

    public void error(String message, Throwable throwable) {
        this.error(message, null, throwable);
    }

    public void error(String message, Json additionalInfo, Throwable throwable) {
        this.sendAppLog(AppLogLevel.ERROR, message, additionalInfo, throwable);
    }

    public void sendAppLog(AppLogLevel level, String message) {
        this.sendAppLog(level, message, null, null);
    }

    public void sendAppLog(AppLogLevel level, String message, Json additionalInfo) {
        this.sendAppLog(level, message, additionalInfo, null);
    }

    public void sendAppLog(AppLogLevel level, String message, Throwable throwable) {
        this.sendAppLog(level, message, null, throwable);
    }

    public void sendAppLog(AppLogLevel level, String message, Json additionalInfo, Throwable throwable) {
        this.sendAppLog(System.currentTimeMillis(), level, message, additionalInfo, throwable);
    }

    public void sendAppLog(Long date, AppLogLevel level, String message) {
        this.sendAppLog(date, level, message, null);
    }

    public void sendAppLog(Long date, AppLogLevel level, String message, Json additionalInfo) {
        this.sendAppLog(date, level, message, additionalInfo, null);
    }

    public void sendAppLog(Long date, AppLogLevel level, String message, Json additionalInfo, Throwable throwable) {
        boolean sent;
        block11: {
            if (this.debug) {
                logger.info(String.format("%s Sending app log to application", "DEBUG>"));
            }
            sent = false;
            try {
                Json json = additionalInfo = additionalInfo != null ? additionalInfo : Json.map();
                if (throwable != null && !additionalInfo.contains("exception")) {
                    additionalInfo.setIfNotEmpty("exception", this.parseCause(throwable, 0L));
                }
                this.api.newAppLogs(date, level.name(), message, additionalInfo);
                sent = true;
                this.lastErrors = 0;
            }
            catch (ServiceException ex) {
                ++this.lastErrors;
                if (this.lastErrors < 5) {
                    logger.warn(String.format("Error when try to send an App Log: [%s]", ex.toJson(false)));
                }
            }
            catch (Exception ex) {
                ++this.lastErrors;
                if (this.lastErrors >= 5) break block11;
                logger.warn(String.format("Error when try to send an App Log: [%s]", ex instanceof JsonSource ? ((JsonSource)((Object)ex)).toJson() : ex.getMessage()));
            }
        }
        switch (level) {
            case ERROR: {
                logger.warn(String.format("App Log: %s%s", message, sent ? "" : " [it was no sent to platform]"), throwable);
                break;
            }
            case WARN: {
                logger.warn(String.format("App Log: %s%s", message, sent ? "" : " [it was no sent to platform]"), throwable);
                break;
            }
            case INFO: {
                logger.info(String.format("App Log: %s%s", message, sent ? "" : " [it was no sent to platform]"));
                break;
            }
            default: {
                logger.warn(String.format("App Log: [Invalid level: %s] %s%s", new Object[]{level, message, sent ? "" : " [it was no sent to platform]"}), throwable);
            }
        }
    }

    private Json parseCause(Throwable throwable, long internalLevel) {
        Json cause = null;
        if (throwable != null) {
            cause = Json.map();
            if (throwable instanceof ServiceException) {
                cause.setIfNotEmpty("detail", ((ServiceException)throwable).toJson(false));
            } else {
                cause.setIfNotEmpty("detail", throwable.getMessage());
            }
            Json stack = Json.list();
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                stack.push(stackTraceElement.toString());
            }
            cause.setIfNotEmpty("stacktrace", stack);
            if (internalLevel < 10L) {
                cause.setIfNotEmpty("cause", this.parseCause(throwable.getCause(), internalLevel + 1L));
            }
        }
        return cause;
    }
}

