/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.utils.converters;

import io.slingr.services.exceptions.ErrorCode;
import io.slingr.services.exceptions.ServiceException;
import io.slingr.services.utils.Json;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class JsonToXmlParser {
    public static String parse(Json json) {
        try {
            return JsonToXmlParser.parse(json, true);
        }
        catch (Exception ex) {
            throw ServiceException.permanent(ErrorCode.CONVERSION, (Object)ex.getMessage(), ex);
        }
    }

    public static String parse(Json json, boolean complete) {
        StringBuilder xml = new StringBuilder();
        if (complete) {
            xml.append("<?xml version=\"1.0\"?>\n");
        }
        if (json != null && !json.isEmpty()) {
            JsonToXmlParser.parse(xml, json, complete);
        }
        return xml.toString();
    }

    private static void parse(StringBuilder xml, Json json, boolean complete) {
        JsonToXmlParser.parseElement(xml, "root", json, 0, complete, true);
    }

    private static void parseElement(StringBuilder xml, String name, Object value, int level, boolean complete, boolean root) {
        StringBuilder iniString = new StringBuilder();
        String endString = "";
        if (complete) {
            for (int i = 0; i < level; ++i) {
                iniString.append("\t");
            }
            endString = "\n";
        }
        if (value instanceof Json || value instanceof Map || value instanceof List) {
            Json json = Json.fromObject(value);
            if (json.isMap()) {
                Json attributes = Json.map();
                Json elements = Json.map();
                String lastElement = null;
                boolean cdata = false;
                String text = "";
                for (String key : json.keys()) {
                    if ("keyValue".equals(key)) {
                        text = json.string("keyValue");
                        continue;
                    }
                    if ("useCDATA".equals(key)) {
                        cdata = json.bool("useCDATA", false);
                        continue;
                    }
                    if (key.startsWith("@")) {
                        attributes.set(key.substring(1), json.string(key));
                        continue;
                    }
                    lastElement = key;
                    elements.set(lastElement, json.object(key));
                }
                if (cdata) {
                    text = String.format("<![CDATA[%s]]>", text);
                }
                boolean parsed = false;
                if (root && StringUtils.isBlank((CharSequence)text) && attributes.isEmpty() && elements.size() == 1) {
                    JsonToXmlParser.parseElement(xml, lastElement, json.object(lastElement), 0, complete, false);
                    parsed = true;
                }
                if (!parsed) {
                    xml.append((CharSequence)iniString).append(JsonToXmlParser.iniElement(name, attributes)).append(text);
                    if (!elements.isEmpty()) {
                        xml.append(endString);
                        for (String element : elements.keys()) {
                            JsonToXmlParser.parseElement(xml, element, json.object(element), level + 1, complete, false);
                        }
                        xml.append((CharSequence)iniString);
                    }
                    xml.append(JsonToXmlParser.endElement(name)).append(endString);
                }
            } else {
                for (Object element : json.objects()) {
                    JsonToXmlParser.parseElement(xml, name, element, level, complete, false);
                }
            }
        } else {
            xml.append((CharSequence)iniString);
            if (value == null) {
                xml.append(JsonToXmlParser.emptyElement(name));
            } else {
                xml.append(JsonToXmlParser.simpleElement(name, value.toString()));
            }
            xml.append(endString);
        }
    }

    private static String emptyElement(String name) {
        return JsonToXmlParser.emptyElement(name, null);
    }

    private static String emptyElement(String name, Json attributes) {
        return String.format("<%s%s />", name, JsonToXmlParser.appendAttributes(attributes));
    }

    private static String simpleElement(String name, String value) {
        return JsonToXmlParser.simpleElement(name, null, value);
    }

    private static String simpleElement(String name, Json attributes, String value) {
        return String.format("%s%s%s", JsonToXmlParser.iniElement(name, attributes), value, JsonToXmlParser.endElement(name));
    }

    private static String iniElement(String name, Json attributes) {
        return String.format("<%s%s>", name, JsonToXmlParser.appendAttributes(attributes));
    }

    private static String endElement(String name) {
        return String.format("</%s>", name);
    }

    private static String appendAttributes(Json attributes) {
        StringBuilder sb = new StringBuilder();
        if (attributes != null) {
            for (String key : attributes.keys()) {
                sb.append(" ").append(key).append("=\"").append(attributes.string(key)).append("\"");
            }
        }
        return sb.toString();
    }
}

