/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.services;

import io.slingr.services.exceptions.ErrorCode;
import io.slingr.services.exceptions.ServiceException;
import io.slingr.services.services.ExtensionBroker;
import io.slingr.services.services.ExtensionBrokerApi;
import io.slingr.services.services.datastores.DataStore;
import io.slingr.services.services.datastores.DataStoreResponse;
import io.slingr.services.utils.Json;
import io.slingr.services.utils.Strings;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStores {
    private static final Logger logger = LoggerFactory.getLogger(DataStores.class);
    public static final String USER_DATA_STORE = "__services_users__";
    private final ExtensionBrokerApi api;
    private final List<String> dataStores = new ArrayList<String>();
    private final boolean debug;

    public DataStores(ExtensionBrokerApi api, List<String> validDataStores, boolean debug) {
        this.api = api;
        this.debug = debug;
        if (validDataStores != null) {
            for (String dataStore : validDataStores) {
                if (!StringUtils.isNotBlank((CharSequence)dataStore)) continue;
                this.dataStores.add(dataStore);
            }
        }
    }

    public DataStore getUserDataStore() throws ServiceException {
        return this.getDataStore(USER_DATA_STORE);
    }

    public DataStore getDataStore(String dataStoreName) throws ServiceException {
        if (StringUtils.isBlank((CharSequence)dataStoreName)) {
            throw ServiceException.permanent(ErrorCode.ARGUMENT, "DataStores: Empty data store name");
        }
        if (!this.dataStores.contains(dataStoreName = dataStoreName.trim())) {
            throw ServiceException.permanent(ErrorCode.ARGUMENT, String.format("DataStores: Invalid data store name to register [%s]", dataStoreName));
        }
        return new DataStore(dataStoreName, this);
    }

    public DataStoreResponse find(String dataStoreName) throws ServiceException {
        return this.find(dataStoreName, null);
    }

    public DataStoreResponse find(String dataStoreName, Json filter) throws ServiceException {
        ExtensionBroker.isNotBlank(dataStoreName, "empty data store name");
        String log = "find all";
        if (filter == null || filter.isEmpty()) {
            filter = null;
        } else {
            log = String.format("find [%s]", filter.toString());
        }
        if (this.debug) {
            logger.info(String.format("%s dataStore=%s - %s", "DEBUG>", dataStoreName, log));
        }
        try {
            DataStoreResponse response = this.api.findDocuments(dataStoreName, filter);
            if (response == null) {
                response = new DataStoreResponse(null, 0, null);
            }
            if (this.debug) {
                logger.info(String.format("%s dataStore=%s - %s - items [%s] - total [%s]", "DEBUG>", dataStoreName, log, response.getItems().size(), response.getTotal()));
            }
            return response;
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ServiceException.retryable(ErrorCode.CONVERSION, (Object)String.format("Exception when find documents on data store [%s]: %s", dataStoreName, ex.getMessage()), ex);
        }
    }

    public DataStoreResponse find(String dataStoreName, Json filter, String offset, Integer size) throws ServiceException {
        if (filter == null) {
            filter = Json.map();
        }
        if (StringUtils.isNotBlank((CharSequence)offset)) {
            filter.set("_offset", offset);
        }
        if (size != null) {
            filter.set("_size", size);
        }
        return this.find(dataStoreName, filter);
    }

    public int count(String dataStoreName) throws ServiceException {
        return this.count(dataStoreName, null);
    }

    public int count(String dataStoreName, Json filter) throws ServiceException {
        ExtensionBroker.isNotBlank(dataStoreName, "empty data store name");
        String log = "count all";
        if (filter == null || filter.isEmpty()) {
            filter = null;
        } else {
            log = String.format("count [%s]", filter.toString());
        }
        if (this.debug) {
            logger.info(String.format("%s dataStore=%s - %s", "DEBUG>", dataStoreName, log));
        }
        try {
            Json response = this.api.countDocuments(dataStoreName, filter);
            if (response != null) {
                try {
                    Integer total = response.integer("total");
                    if (total == null || total < 0) {
                        total = 0;
                    }
                    if (this.debug) {
                        logger.info(String.format("%s dataStore=%s - %s - total [%s]", "DEBUG>", dataStoreName, log, total));
                    }
                    return total;
                }
                catch (Exception ex) {
                    throw ServiceException.retryable(ErrorCode.CONVERSION, (Object)String.format("Exception when convert response of data store [%s]: %s", dataStoreName, ex.getMessage()), ex);
                }
            }
            throw ServiceException.retryable(ErrorCode.CLIENT, String.format("Invalid data store response [%s]", dataStoreName));
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ServiceException.retryable(ErrorCode.CONVERSION, (Object)String.format("Exception when count documents on data store [%s]: %s", dataStoreName, ex.getMessage()), ex);
        }
    }

    public Json findById(String dataStoreName, String documentId) throws ServiceException {
        ExtensionBroker.isNotBlank(dataStoreName, "empty data store name");
        ExtensionBroker.isNotBlank(dataStoreName, "empty document id");
        String log = String.format("find by id [%s]", documentId);
        if (this.debug) {
            logger.info(String.format("%s dataStore=%s - %s", "DEBUG>", dataStoreName, log));
        }
        try {
            Json response = this.api.getDocument(dataStoreName, documentId);
            if (this.debug) {
                if (response != null) {
                    logger.info(String.format("%s dataStore=%s - %s - found document id [%s]", "DEBUG>", dataStoreName, log, response.string("_id")));
                } else {
                    logger.info(String.format("%s dataStore=%s - %s - not found document", "DEBUG>", dataStoreName, log));
                }
            }
            return response;
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ServiceException.retryable(ErrorCode.CONVERSION, (Object)String.format("Exception when find a document by id on data store [%s]: %s", dataStoreName, ex.getMessage()), ex);
        }
    }

    public Json findOne(String dataStoreName, Json filter) throws ServiceException {
        ExtensionBroker.isNotBlank(dataStoreName, "empty data store name");
        String log = "find one";
        if (filter == null || filter.isEmpty()) {
            filter = null;
        } else {
            log = String.format("find one [%s]", filter.toString());
        }
        if (this.debug) {
            logger.info(String.format("%s dataStore=%s - %s", "DEBUG>", dataStoreName, log));
        }
        try {
            Json item;
            DataStoreResponse response = this.api.findDocuments(dataStoreName, filter);
            if (response == null) {
                throw ServiceException.retryable(ErrorCode.CLIENT, String.format("Invalid data store response [%s]", dataStoreName));
            }
            if (response.getItems() != null && !response.getItems().isEmpty() && (item = response.getItems().get(0)) != null) {
                if (this.debug) {
                    logger.info(String.format("%s dataStore=%s - %s - found document id [%s]", "DEBUG>", dataStoreName, log, item.string("_id")));
                }
                return item;
            }
            if (this.debug) {
                logger.info(String.format("%s dataStore=%s - %s - not found document", "DEBUG>", dataStoreName, log));
            }
            return null;
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ServiceException.retryable(ErrorCode.CONVERSION, (Object)String.format("Exception when find one document on data store [%s]: %s", dataStoreName, ex.getMessage()), ex);
        }
    }

    public Json save(String dataStoreName, Json document) throws ServiceException {
        ExtensionBroker.isNotBlank(dataStoreName, "empty data store name");
        if (document == null) {
            document = Json.map();
        }
        if (StringUtils.isBlank((CharSequence)document.string("_id"))) {
            document.set("_id", Strings.randomUUIDString());
        }
        String documentId = document.string("_id");
        String log = "save document";
        if (StringUtils.isNotBlank((CharSequence)documentId)) {
            log = String.format("save document [%s]", documentId);
        }
        if (this.debug) {
            logger.info(String.format("%s dataStore=%s - %s", "DEBUG>", dataStoreName, log));
        }
        try {
            Json response = this.api.saveDocument(dataStoreName, document);
            if (response != null) {
                if (this.debug) {
                    logger.info(String.format("%s dataStore=%s - saved document - id [%s]", "DEBUG>", dataStoreName, response.string("_id")));
                }
                return response;
            }
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ServiceException.retryable(ErrorCode.CONVERSION, (Object)String.format("Exception when save document on data store [%s]: %s", dataStoreName, ex.getMessage()), ex);
        }
        logger.warn(String.format("dataStore=%s - %s - Error: there is not response from Extension Broker", dataStoreName, document.string("_id")));
        throw ServiceException.permanent(ErrorCode.CLIENT, "There is not response from Extension Broker");
    }

    public Json update(String dataStoreName, Json document) throws ServiceException {
        return this.update(dataStoreName, null, document);
    }

    public Json update(String dataStoreName, String documentId, Json document) throws ServiceException {
        ExtensionBroker.isNotBlank(dataStoreName, "empty data store name");
        if (document == null) {
            document = Json.map();
        }
        String docId = StringUtils.isNotBlank((CharSequence)documentId) ? documentId.trim() : document.string("_id");
        ExtensionBroker.isNotBlank(docId, "empty document id");
        document.set("_id", docId);
        String log = String.format("update document [%s]", docId);
        if (this.debug) {
            logger.info(String.format("%s dataStore=%s - %s", "DEBUG>", dataStoreName, log));
        }
        try {
            Json response = this.api.updateDocument(dataStoreName, docId, document);
            if (response != null) {
                if (this.debug) {
                    logger.info(String.format("%s dataStore=%s - updated document - id [%s]", "DEBUG>", dataStoreName, response.string("_id")));
                }
                return response;
            }
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ServiceException.retryable(ErrorCode.CONVERSION, (Object)String.format("Exception when update document on data store [%s]: %s", dataStoreName, ex.getMessage()), ex);
        }
        logger.warn(String.format("dataStore=%s - %s - Error: there is not response from Extension Broker", dataStoreName, document.string("_id")));
        throw ServiceException.permanent(ErrorCode.CLIENT, "There is not response from Extension Broker");
    }

    public boolean remove(String dataStoreName) throws ServiceException {
        return this.remove(dataStoreName, null);
    }

    public boolean remove(String dataStoreName, Json filter) throws ServiceException {
        ExtensionBroker.isNotBlank(dataStoreName, "empty data store name");
        String log = "remove all";
        if (filter == null || filter.isEmpty()) {
            filter = null;
        } else {
            log = String.format("remove [%s]", filter.toString());
        }
        if (this.debug) {
            logger.info(String.format("%s dataStore=%s - %s", "DEBUG>", dataStoreName, log));
        }
        try {
            Json response = this.api.removeDocuments(dataStoreName, filter);
            return this.processRemoveResponse(dataStoreName, response);
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ServiceException.retryable(ErrorCode.CONVERSION, (Object)String.format("Exception when remove documents on data store [%s]: %s", dataStoreName, ex.getMessage()), ex);
        }
    }

    public boolean removeById(String dataStoreName, String documentId) throws ServiceException {
        ExtensionBroker.isNotBlank(dataStoreName, "empty data store name");
        ExtensionBroker.isNotBlank(dataStoreName, "empty document id");
        String log = String.format("remove by id [%s]", documentId);
        if (this.debug) {
            logger.info(String.format("%s dataStore=%s - %s", "DEBUG>", dataStoreName, log));
        }
        try {
            Json response = this.api.removeDocument(dataStoreName, documentId);
            return this.processRemoveResponse(dataStoreName, response);
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ServiceException.retryable(ErrorCode.CONVERSION, (Object)String.format("Exception when remove a document by id on data store [%s]: %s", dataStoreName, ex.getMessage()), ex);
        }
    }

    private boolean processRemoveResponse(String dataStoreName, Json response) throws ServiceException {
        if (response != null) {
            try {
                Boolean result = response.bool("result");
                if (result != null) {
                    if (this.debug) {
                        logger.info(String.format("%s dataStore=%s - removed [%s] - total [%s]", "DEBUG>", dataStoreName, result, response.integer("total")));
                    }
                    return result;
                }
            }
            catch (Exception ex) {
                throw ServiceException.retryable(ErrorCode.CONVERSION, (Object)String.format("Exception when convert data store response [%s]: %s", dataStoreName, ex.getMessage()), ex);
            }
        }
        throw ServiceException.retryable(ErrorCode.CLIENT, String.format("Invalid data store response [%s]: %s", dataStoreName, response));
    }
}

