/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.framework.annotations.classes;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.slingr.services.Service;
import io.slingr.services.framework.IRunner;
import io.slingr.services.framework.RegisteredFunction;
import io.slingr.services.framework.RegisteredWebService;
import io.slingr.services.framework.annotations.SlingrService;
import io.slingr.services.framework.annotations.classes.AccessorType;
import io.slingr.services.framework.annotations.classes.ClassApplicationLogger;
import io.slingr.services.framework.annotations.classes.ClassDataStore;
import io.slingr.services.framework.annotations.classes.ClassFunction;
import io.slingr.services.framework.annotations.classes.ClassProperty;
import io.slingr.services.framework.annotations.classes.ClassUserDataStore;
import io.slingr.services.framework.annotations.classes.ClassWebService;
import io.slingr.services.framework.annotations.classes.CodeGenerator;
import io.slingr.services.framework.annotations.classes.FunctionResponseType;
import io.slingr.services.framework.annotations.classes.MethodAccessorType;
import io.slingr.services.framework.annotations.classes.MethodParameterType;
import io.slingr.services.framework.annotations.classes.PropertyType;
import io.slingr.services.framework.annotations.classes.SettableProperty;
import io.slingr.services.framework.annotations.classes.WebServiceResponseType;
import io.slingr.services.framework.annotations.processor.AnnotationsUtils;
import io.slingr.services.services.rest.RestMethod;
import io.slingr.services.utils.Json;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.JavaFileObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassService {
    public static final String SE_NAME = SlingrService.class.getSimpleName();
    private static final String _methodMain = "main";
    private static final String _methodStartService = "startService";
    private static final String _methodExtractArgument = "extractArgument";
    private static final String _methodCreateService = "createService";
    private static final String _generatedClassName = "Runner";
    private static final String _staticLogger = "logger";
    private static final String _commandLineParameterConfigurationFile = "configurationFile";
    private static final String _commandLineParameterDefaultWebServiceUri = "defaultWebServiceUri";
    private static final String _parameterService = "serviceInstance";
    private static final String _parameterConfigurationFile = "configurationFile";
    private static final String _parameterDefaultWebServiceUri = "defaultWebServiceUri";
    private static final String _parameterArgs = "args";
    private static final String _parameterKey = "key";
    private static final String _literalEquals = "=";
    private static final String _variableService = "service";
    private static final String _variableServiceType = "serviceType";
    private static final String _variableConfigurationFile = "configurationFile";
    private static final String _variableDefaultWebServiceUri = "defaultWebServiceUri";
    private static final String _variableField = "field";
    private static final String _variableClazz = "clazz";
    private static final String _variableAccessible = "accessible";
    private static final String _variableEx = "ex";
    private static final String _variableStartMethod = "startMethod";
    private static final String _javaMethodFinishedStart = "finishedStart";
    private static final String _javaMethodInternalRegisterWebService = "internalRegisterWebService";
    private static final String _javaMethodInternalRegisterFunction = "internalRegisterFunction";
    private TypeElement annotatedElement;
    private final String qualifiedName;
    private final String simpleName;
    private final String name;
    private final String functionPrefix;
    private final List<CodeGenerator> codeGenerators = new ArrayList<CodeGenerator>();
    private final List<ClassApplicationLogger> appLoggers = new ArrayList<ClassApplicationLogger>();
    private final List<ClassProperty> properties = new ArrayList<ClassProperty>();
    private final List<ClassDataStore> dataStores = new ArrayList<ClassDataStore>();
    private final List<ClassUserDataStore> userDataStores = new ArrayList<ClassUserDataStore>();
    private final Map<String, ClassFunction> functions = new HashMap<String, ClassFunction>();
    private final Map<String, ClassWebService> webServices = new HashMap<String, ClassWebService>();
    private final Map<String, Map<RestMethod, Boolean>> webServiceControl = new HashMap<String, Map<RestMethod, Boolean>>();

    public ClassService(Element sServiceElement) throws IllegalArgumentException {
        this.annotatedElement = (TypeElement)sServiceElement;
        this.qualifiedName = this.annotatedElement.getQualifiedName().toString();
        this.simpleName = this.annotatedElement.getSimpleName().toString();
        SlingrService annotation = this.annotatedElement.getAnnotation(SlingrService.class);
        this.name = annotation.name();
        this.functionPrefix = StringUtils.isNotBlank((CharSequence)annotation.functionPrefix()) ? annotation.functionPrefix() : "";
        AnnotationsUtils.checkNotEmpty(this.name, "name", SE_NAME, "class", this.qualifiedName);
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public Set<String> getAppLoggerNames() {
        return this.appLoggers.stream().map(ClassApplicationLogger::getSimpleName).collect(Collectors.toSet());
    }

    public Set<String> getPropertiesNames() {
        return this.properties.stream().map(ClassProperty::getSimpleName).collect(Collectors.toSet());
    }

    public Set<String> getDataStoreNames() {
        return this.dataStores.stream().map(ClassDataStore::getName).collect(Collectors.toSet());
    }

    public Set<String> getUserDataStoreNames() {
        return this.userDataStores.stream().map(ClassUserDataStore::getSimpleName).collect(Collectors.toSet());
    }

    public Set<String> getFunctionsNames() {
        return this.functions.keySet();
    }

    public Set<String> getWebServicesNames() {
        return this.webServices.keySet();
    }

    public String getName() {
        return this.name;
    }

    public String getFunctionPrefix() {
        return this.functionPrefix;
    }

    public void registerCodeGenerator(CodeGenerator codeGenerator) {
        if (codeGenerator != null) {
            this.codeGenerators.add(codeGenerator);
        }
    }

    public void registerAppLogger(ClassApplicationLogger appLogger) {
        if (appLogger != null) {
            this.appLoggers.add(appLogger);
        }
    }

    public void registerProperty(ClassProperty property) {
        if (property != null) {
            this.properties.add(property);
        }
    }

    public void registerDataStore(ClassDataStore dataStore) {
        if (dataStore != null) {
            this.dataStores.add(dataStore);
        }
    }

    public void registerUserDataStore(ClassUserDataStore userDataStore) {
        if (userDataStore != null) {
            this.userDataStores.add(userDataStore);
        }
    }

    public boolean isFunctionRegistered(String name) {
        return StringUtils.isNotBlank((CharSequence)name) && this.functions.containsKey(name);
    }

    public void registerFunction(ClassFunction function) {
        if (function != null) {
            if (this.isFunctionRegistered(function.getName())) {
                throw new IllegalStateException(String.format("Function [%s] is already registered on [%s]", function.getName(), this.getSimpleName()));
            }
            boolean generated = false;
            if (StringUtils.isNotBlank((CharSequence)this.getFunctionPrefix())) {
                String name = function.getName();
                if (name.startsWith(this.getFunctionPrefix())) {
                    name = name.substring(this.getFunctionPrefix().length());
                }
                if ("connectUser".equals(name)) {
                    this.functions.put(name, function.clone(name, true));
                    this.functions.put(this.getFunctionPrefix() + name, function.clone(this.getFunctionPrefix() + name, true));
                    generated = true;
                } else if ("disconnectUser".equals(name)) {
                    this.functions.put(name, function.clone(name, true));
                    this.functions.put(this.getFunctionPrefix() + name, function.clone(this.getFunctionPrefix() + name, true));
                    generated = true;
                }
            }
            if (!generated) {
                this.functions.put(function.getName(), function);
            }
        }
    }

    public boolean isWebServiceRegistered(String path, RestMethod method) {
        return StringUtils.isNotBlank((CharSequence)path) && method != null && this.webServiceControl.containsKey(path) && Boolean.TRUE.equals(this.webServiceControl.get(path).get((Object)method));
    }

    public void registerWebService(ClassWebService webService) {
        if (webService != null) {
            if (this.webServices.containsKey(webService.getName())) {
                throw new IllegalStateException(String.format("Web service [%s] is already registered on [%s]", webService.getName(), this.getSimpleName()));
            }
            String path = webService.getPath();
            if (!this.webServiceControl.containsKey(path)) {
                HashMap reg = new HashMap();
                RestMethod.all().forEach(restMethod -> reg.put(restMethod, false));
                this.webServiceControl.put(path, reg);
            }
            List<RestMethod> restMethods = webService.getMethods().isEmpty() ? RestMethod.all() : webService.getMethods();
            restMethods.forEach(restMethod -> {
                if (this.isWebServiceRegistered(path, (RestMethod)((Object)restMethod))) {
                    throw new IllegalStateException(String.format("Web service [%s] contains [%s][%s] that is already registered on [%s]", webService.getName(), restMethod, path, this.getSimpleName()));
                }
                this.webServiceControl.get(path).put((RestMethod)((Object)restMethod), true);
            });
            this.webServices.put(webService.getName(), webService);
        }
    }

    public TypeElement getTypeElement() {
        return this.annotatedElement;
    }

    public void generateRunner(Elements elementUtils, Filer filer) throws Exception {
        PackageElement pkg = elementUtils.getPackageOf(elementUtils.getTypeElement(this.annotatedElement.getQualifiedName()));
        TypeElement serviceClass = elementUtils.getTypeElement(this.annotatedElement.getQualifiedName());
        TypeName serviceClassType = TypeName.get((TypeMirror)serviceClass.asType());
        MethodSpec.Builder startServiceBuilder = MethodSpec.methodBuilder((String)_methodStartService).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(serviceClassType).addParameter(Service.class, _parameterService, new Modifier[]{Modifier.FINAL}).addParameter(String.class, "configurationFile", new Modifier[]{Modifier.FINAL}).addParameter(String.class, "defaultWebServiceUri", new Modifier[]{Modifier.FINAL}).addException(Exception.class).addAnnotation(Override.class).addCode("\n", new Object[0]).addComment("start service configuration", new Object[0]).beginControlFlow("if($N == null)", new Object[]{_parameterService}).addStatement("throw new $T($S)", new Object[]{IllegalStateException.class, "Invalid service object"}).endControlFlow().beginControlFlow("if(!($N instanceof $T))", new Object[]{_parameterService, serviceClassType}).addStatement("throw new $T($S+$T.class.getName()+$S+$N.getClass().getName()+$S)", new Object[]{IllegalStateException.class, "Invalid service instance: expected [", serviceClassType, "], current [", _parameterService, "]"}).endControlFlow().addStatement("final $T $N = ($T) $N", new Object[]{serviceClassType, _variableService, serviceClassType, _parameterService}).addStatement("$N.configure($N)", new Object[]{_variableService, "configurationFile"}).addCode("\n", new Object[0]).addComment("check service type", new Object[0]).addStatement("final $T $N = $S", new Object[]{String.class, _variableServiceType, this.getName()}).beginControlFlow("if(!$N.equals($N.definitions().getType()))", new Object[]{_variableServiceType, _variableService}).addStatement("throw new $T($T.format($S, $N, $N.definitions().getType()))", new Object[]{IllegalStateException.class, String.class, "Invalid the defined service name [%s] on service instead to use the value of definitions [%s]", _variableServiceType, _variableService}).endControlFlow().addCode("\n", new Object[0]).addComment("set web service uri", new Object[0]).beginControlFlow("if($T.isNotBlank($N))", new Object[]{StringUtils.class, "defaultWebServiceUri"}).addStatement("$N.properties().setDefaultWebServicesUri($N)", new Object[]{_variableService, "defaultWebServiceUri"}).endControlFlow().addCode("\n", new Object[0]).addComment("configure properties and methods", new Object[0]).addStatement("$T accessible", new Object[]{Boolean.TYPE}).addStatement("$T $N", new Object[]{Field.class, _variableField}).addStatement("final $T $N = $T.class", new Object[]{Class.class, _variableClazz, serviceClass});
        this.codeGenerators.forEach(codeGenerator -> codeGenerator.generate(startServiceBuilder));
        this.appLoggers.forEach(appLogger -> ClassService.generateSet(startServiceBuilder, appLogger));
        this.properties.forEach(properties -> ClassService.generateSet(startServiceBuilder, properties));
        this.dataStores.forEach(dataStore -> ClassService.generateSet(startServiceBuilder, dataStore));
        this.userDataStores.forEach(dataStore -> ClassService.generateSet(startServiceBuilder, dataStore));
        if (!this.functions.isEmpty()) {
            String registerFunction = "function";
            startServiceBuilder.addCode("\n", new Object[0]).addComment("FUNCTIONS", new Object[0]).addStatement("final $T $N = $T.class.getDeclaredMethod($S, $T.class, $T.class)", new Object[]{Method.class, "function", Service.class, _javaMethodInternalRegisterFunction, RegisteredFunction.class, Boolean.class}).addStatement("$N.setAccessible(true)", new Object[]{"function"});
            this.functions.forEach((key, classFunction) -> ClassService.generateRegister(startServiceBuilder, "function", classFunction));
            startServiceBuilder.addCode("\n", new Object[0]).addComment("FUNCTIONS (END)", new Object[0]).addStatement("$N.setAccessible(false)", new Object[]{"function"});
        }
        if (!this.webServices.isEmpty()) {
            String registerWebService = "webService";
            startServiceBuilder.addCode("\n", new Object[0]).addComment("WEB SERVICES", new Object[0]).addStatement("final $T $N = $T.class.getDeclaredMethod($S, $T.class)", new Object[]{Method.class, "webService", Service.class, _javaMethodInternalRegisterWebService, RegisteredWebService.class}).addStatement("$N.setAccessible(true)", new Object[]{"webService"});
            this.webServices.values().forEach(webService -> ClassService.generateRegister(startServiceBuilder, "webService", webService));
            startServiceBuilder.addCode("\n", new Object[0]).addComment("WEB SERVICES (END)", new Object[0]).addStatement("$N.setAccessible(false)", new Object[]{"webService"});
        }
        startServiceBuilder.addCode("\n", new Object[0]).addComment("finished start process", new Object[0]).addStatement("final $T $N = $T.class.getDeclaredMethod($S)", new Object[]{Method.class, _variableStartMethod, Service.class, _javaMethodFinishedStart}).addStatement("$N.setAccessible(true)", new Object[]{_variableStartMethod}).addStatement("$N.invoke($N)", new Object[]{_variableStartMethod, _variableService}).addStatement("$N.setAccessible(false)", new Object[]{_variableStartMethod}).addStatement("return $N", new Object[]{_variableService});
        MethodSpec startService = startServiceBuilder.build();
        MethodSpec createService = MethodSpec.methodBuilder((String)_methodCreateService).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(serviceClassType).addAnnotation(Override.class).addStatement("return new $T()", new Object[]{serviceClass}).build();
        MethodSpec main = MethodSpec.methodBuilder((String)_methodMain).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(TypeName.VOID).addParameter(String[].class, _parameterArgs, new Modifier[]{Modifier.FINAL}).addException(Exception.class).addJavadoc("Entry point of the service\n\n", new Object[0]).addJavadoc("@param $N command line arguments.\n", new Object[]{_parameterArgs}).addComment("extract command line parameters", new Object[0]).addStatement("final $T $N = $N($S, $N)", new Object[]{String.class, "configurationFile", _methodExtractArgument, "configurationFile", _parameterArgs}).addStatement("final $T $N = $N($S, $N)", new Object[]{String.class, "defaultWebServiceUri", _methodExtractArgument, "defaultWebServiceUri", _parameterArgs}).addCode("\n", new Object[0]).addComment("start service configuration", new Object[0]).addStatement("new $N().$N($N, $N)", new Object[]{_generatedClassName, startService, "configurationFile", "defaultWebServiceUri"}).build();
        TypeSpec runnerClass = TypeSpec.classBuilder((String)_generatedClassName).superclass(IRunner.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addJavadoc("Class used to initialize and run the service\n\n", new Object[0]).addJavadoc("<p>Created by <b>Slingr</b> on $N.\n", new Object[]{DateFormat.getDateInstance().format(System.currentTimeMillis())}).addField(FieldSpec.builder(Logger.class, (String)_staticLogger, (Modifier[])new Modifier[]{Modifier.STATIC, Modifier.FINAL, Modifier.PRIVATE}).initializer("$T.getLogger($T.class)", new Object[]{LoggerFactory.class, Service.class}).build()).addMethod(main).addMethod(createService).addMethod(startService).build();
        JavaFileObject jfo = filer.createSourceFile(_generatedClassName, new Element[0]);
        Writer writer = jfo.openWriter();
        JavaFile javaFile = JavaFile.builder((String)pkg.getQualifiedName().toString(), (TypeSpec)runnerClass).build();
        javaFile.writeTo((Appendable)writer);
        writer.flush();
        writer.close();
    }

    private static void generateSetToProperty(MethodSpec.Builder builder, SettableProperty property, String value) {
        builder.beginControlFlow("try", new Object[0]);
        if (property.getAccessorType() == AccessorType.REFLECTION) {
            builder.addStatement("$N = $N.getDeclaredField($S)", new Object[]{_variableField, _variableClazz, property.getAccessor()}).addStatement("$N = $N.isAccessible()", new Object[]{_variableAccessible, _variableField}).addStatement("$N.setAccessible(true)", new Object[]{_variableField}).addStatement("$N.set($N, $N)", new Object[]{_variableField, _variableService, value}).addStatement("$N.setAccessible($N)", new Object[]{_variableField, _variableAccessible});
        } else if (property.getAccessorType() == AccessorType.SETTER) {
            builder.addStatement("$N.$N($N)", new Object[]{_variableService, property.getAccessor(), value});
        } else {
            builder.addStatement("$N.$N = $N", new Object[]{_variableService, property.getAccessor(), value});
        }
        builder.nextControlFlow("catch ($T $N)", new Object[]{Exception.class, _variableEx}).addStatement("$N.info($S+$N.getMessage())", new Object[]{_staticLogger, String.format("Exception when try to set [%s] on [%s]: ", value, property.getAccessor()), _variableEx}).addStatement("throw $N", new Object[]{_variableEx}).endControlFlow();
    }

    private static void generateSet(MethodSpec.Builder builder, ClassApplicationLogger appLogger) {
        if (appLogger != null) {
            builder.addCode("\n", new Object[0]).addComment("APP LOGGER > FIELD [$N]", new Object[]{appLogger.getSimpleName()});
            ClassService.generateSetToProperty(builder, appLogger, String.format("%s.appLogs()", _variableService));
        }
    }

    private static void generateSet(MethodSpec.Builder builder, ClassProperty property) {
        if (property != null) {
            if (property.isServiceConfiguration()) {
                builder.addCode("\n", new Object[0]).addComment("SERVICE CONFIGURATION > FIELD [$N]", new Object[]{property.getSimpleName()});
            } else {
                builder.addCode("\n", new Object[0]).addComment("PROPERTY [$N] > FIELD [$N]", new Object[]{property.getName(), property.getSimpleName()});
            }
            CodeBlock.Builder code = CodeBlock.builder().add("$N.properties().getServiceConfiguration()", new Object[]{_variableService});
            if (!property.getType().equals((Object)PropertyType.CONFIG)) {
                if (property.getType().equals((Object)PropertyType.BOOLEAN)) {
                    code.add(".is", new Object[0]);
                } else if (property.getType().equals((Object)PropertyType.JSON)) {
                    code.add(".json", new Object[0]);
                } else {
                    code.add(".string", new Object[0]);
                }
                code.add("($S", new Object[]{property.getName()});
                if (property.getDefaultValue() != null) {
                    code.add(", ", new Object[0]);
                    if (property.getType().equals((Object)PropertyType.BOOLEAN)) {
                        code.add("$N", new Object[]{property.getDefaultValue()});
                    } else if (property.getType().equals((Object)PropertyType.JSON)) {
                        code.add("$T.parse($S)", new Object[]{Json.class, property.getDefaultValue()});
                    } else {
                        code.add("$S", new Object[]{property.getDefaultValue()});
                    }
                }
                code.add(")", new Object[0]);
            }
            ClassService.generateSetToProperty(builder, property, code.build().toString());
        }
    }

    private static void generateSet(MethodSpec.Builder builder, ClassDataStore dataStore) {
        if (dataStore != null) {
            builder.addCode("\n", new Object[0]).addComment("DATA STORE [$N] > FIELD [$N]", new Object[]{dataStore.getName(), dataStore.getSimpleName()});
            ClassService.generateSetToProperty(builder, dataStore, String.format("%s.dataStore(\"%s\")", _variableService, dataStore.getName()));
        }
    }

    private static void generateSet(MethodSpec.Builder builder, ClassUserDataStore userDataStore) {
        if (userDataStore != null) {
            builder.addCode("\n", new Object[0]).addComment("USER DATA STORE > FIELD [$N]", new Object[]{userDataStore.getSimpleName()});
            ClassService.generateSetToProperty(builder, userDataStore, String.format("%s.userDataStore()", _variableService));
        }
    }

    private static void generateRegister(MethodSpec.Builder builder, String registerFunction, ClassFunction function) {
        if (function != null) {
            builder.addCode("\n", new Object[0]).addComment("FUNCTION [$N] > JAVA METHOD [$N]", new Object[]{function.getName(), function.getSimpleName()});
            if (function.getMethodClass() == null) {
                builder.addStatement("$N.invoke($N, new $T($S, $S, $T.$N, $T.$N, $T.$N), $T.$N)", new Object[]{registerFunction, _variableService, RegisteredFunction.class, function.getName(), function.getSimpleName(), MethodParameterType.class, function.getParameterType().name(), FunctionResponseType.class, function.getResponseType().name(), MethodAccessorType.class, function.getAccessorType().name(), Boolean.class, ("" + !function.isGenerated()).toUpperCase()});
            } else {
                builder.addStatement("$N.invoke($N, new $T($S, $S, $T.$N, $T.$N, $T.$N, $T.class), $T.$N)", new Object[]{registerFunction, _variableService, RegisteredFunction.class, function.getName(), function.getSimpleName(), MethodParameterType.class, function.getParameterType().name(), FunctionResponseType.class, function.getResponseType().name(), MethodAccessorType.class, function.getAccessorType().name(), function.getMethodClass(), Boolean.class, ("" + !function.isGenerated()).toUpperCase()});
            }
        }
    }

    private static void generateRegister(MethodSpec.Builder builder, String registerWebService, ClassWebService webService) {
        block4: {
            if (webService == null) break block4;
            builder.addCode("\n", new Object[0]).addComment("WEB SERVICE [$N] > JAVA METHOD [$N]", new Object[]{webService.getPath(), webService.getSimpleName()});
            if (webService.getMethodClass() == null) {
                for (RestMethod method : webService.getMethods()) {
                    builder.addStatement("$N.invoke($N, new $T($S, $T.$N, $S, $S, $T.$N, $T.$N, $T.$N))", new Object[]{registerWebService, _variableService, RegisteredWebService.class, ClassWebService.generateName(webService.getPath(), method.toInitials()), RestMethod.class, method.name(), webService.getPath(), webService.getSimpleName(), MethodParameterType.class, webService.getParameterType().name(), WebServiceResponseType.class, webService.getResponseType().name(), MethodAccessorType.class, webService.getAccessorType().name()});
                }
            } else {
                for (RestMethod method : webService.getMethods()) {
                    builder.addStatement("$N.invoke($N, new $T($S, $T.$N, $S, $S, $T.$N, $T.$N, $T.$N, $T.class))", new Object[]{registerWebService, _variableService, RegisteredWebService.class, ClassWebService.generateName(webService.getPath(), method.toInitials()), RestMethod.class, method.name(), webService.getPath(), webService.getSimpleName(), MethodParameterType.class, webService.getParameterType().name(), WebServiceResponseType.class, webService.getResponseType().name(), MethodAccessorType.class, webService.getAccessorType().name(), webService.getMethodClass()});
                }
            }
        }
    }

    public boolean isValidClass() {
        if (!this.annotatedElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
            AnnotationsUtils.error(this.annotatedElement, "The class [%s] is not public.", this.qualifiedName);
            return false;
        }
        if (this.annotatedElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            AnnotationsUtils.error(this.annotatedElement, "The class [%s] is abstract. You can't annotate abstract classes with @%s", this.qualifiedName, SE_NAME);
            return false;
        }
        TypeElement currentClass = this.annotatedElement;
        while (true) {
            TypeMirror superClassType;
            if ((superClassType = currentClass.getSuperclass()).getKind() == TypeKind.NONE) {
                AnnotationsUtils.error(this.annotatedElement, "The class [%s] annotated with @%s must inherit from [%s]", this.qualifiedName, SE_NAME, Service.class.getCanonicalName());
                return false;
            }
            if (superClassType.toString().equals(Service.class.getCanonicalName())) break;
            currentClass = (TypeElement)AnnotationsUtils.asElement(superClassType);
        }
        boolean foundConstructor = false;
        for (Element element : this.annotatedElement.getEnclosedElements()) {
            ExecutableElement constructorElement;
            if (element.getKind() != ElementKind.CONSTRUCTOR || (constructorElement = (ExecutableElement)element).getParameters().size() != 0 || !constructorElement.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            foundConstructor = true;
            break;
        }
        if (!foundConstructor) {
            AnnotationsUtils.error(this.annotatedElement, "The class [%s] must provide an public empty default constructor", this.qualifiedName);
            return false;
        }
        return true;
    }
}

