/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.services.framework;

import io.slingr.services.exceptions.ErrorCode;
import io.slingr.services.exceptions.ServiceException;
import io.slingr.services.framework.BaseModule;
import io.slingr.services.framework.DefaultServiceLifecycleListener;
import io.slingr.services.framework.IApiUriSource;
import io.slingr.services.framework.IHttpService;
import io.slingr.services.services.HttpService;
import io.slingr.services.utils.Json;
import io.slingr.services.ws.exchange.FunctionRequest;
import io.slingr.services.ws.exchange.WebServiceRequest;
import io.slingr.services.ws.exchange.WebServiceResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpModule
implements IHttpService {
    private static final Logger logger = LoggerFactory.getLogger(HttpModule.class);
    private final IApiUriSource apiUriSource;
    private final BaseModule baseModule;
    private HttpService httpService = null;

    public HttpModule(IApiUriSource apiUriSource, BaseModule baseModule) {
        this.apiUriSource = apiUriSource;
        this.baseModule = baseModule;
        this.baseModule.addSystemLifecycleListener(new DefaultServiceLifecycleListener(){

            @Override
            public void serviceStarted() {
                HttpModule.this.initialize();
            }
        });
    }

    private void initialize() {
        this.httpService = new HttpService(this.apiUriSource.getApiUri(), this.baseModule.events(), this.baseModule.files(), this.baseModule.properties().isDebug());
        logger.info("HTTP module enabled");
    }

    private void errorIfHttpServiceNotConfigured() {
        if (this.httpService == null) {
            throw ServiceException.permanent(ErrorCode.CLIENT, "HTTP service is not ready to be used yet. Use it in Service.serviceStarted() hook or after its execution.");
        }
    }

    @Override
    public HttpService httpService() {
        this.errorIfHttpServiceNotConfigured();
        return this.httpService;
    }

    @Override
    public Json defaultGetRequest(FunctionRequest request) {
        this.errorIfHttpServiceNotConfigured();
        return this.httpService.defaultGetRequest(request);
    }

    @Override
    public Json defaultPostRequest(FunctionRequest request) {
        this.errorIfHttpServiceNotConfigured();
        return this.httpService.defaultPostRequest(request);
    }

    @Override
    public Json defaultPutRequest(FunctionRequest request) {
        this.errorIfHttpServiceNotConfigured();
        return this.httpService.defaultPutRequest(request);
    }

    @Override
    public Json defaultDeleteRequest(FunctionRequest request) {
        this.errorIfHttpServiceNotConfigured();
        return this.httpService.defaultDeleteRequest(request);
    }

    @Override
    public Json defaultHeadRequest(FunctionRequest request) {
        this.errorIfHttpServiceNotConfigured();
        return this.httpService.defaultHeadRequest(request);
    }

    @Override
    public Json defaultPatchRequest(FunctionRequest request) {
        this.errorIfHttpServiceNotConfigured();
        return this.httpService.defaultPatchRequest(request);
    }

    @Override
    public Json defaultOptionsRequest(FunctionRequest request) {
        this.errorIfHttpServiceNotConfigured();
        return this.httpService.defaultOptionsRequest(request);
    }

    @Override
    public WebServiceResponse defaultWebhookProcessor(WebServiceRequest request) {
        this.errorIfHttpServiceNotConfigured();
        return this.httpService.defaultWebhookProcessor(request);
    }
}

