/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.service.http;

import io.slingr.services.HttpService;
import io.slingr.services.configurations.Configuration;
import io.slingr.services.exceptions.ErrorCode;
import io.slingr.services.exceptions.ServiceException;
import io.slingr.services.services.AppLogs;
import io.slingr.services.utils.Json;
import io.slingr.services.ws.exchange.WebServiceRequest;
import io.slingr.services.ws.exchange.WebServiceResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http
extends HttpService {
    private static final String SERVICE_NAME = "http";
    private static final Logger logger = LoggerFactory.getLogger(Http.class);
    private AppLogs appLogs;
    private String baseUrl;
    private Json configuration;

    public String getApiUri() {
        return StringUtils.isNotBlank((CharSequence)this.baseUrl) ? this.baseUrl : "";
    }

    public void serviceStarted() {
        logger.info(String.format("Initializing service [%s]", SERVICE_NAME));
        this.appLogs.info(String.format("Initializing service [%s]", SERVICE_NAME));
        String headers = this.configuration.string("defaultHeaders", "");
        try {
            Json jHeaders = Http.checkHeaders(headers);
            jHeaders.forEachMapString((arg_0, arg_1) -> ((io.slingr.services.services.HttpService)this.httpService()).setupDefaultHeader(arg_0, arg_1));
        }
        catch (Exception ex) {
            this.appLogs.error(String.format("Invalid default headers defined for HTTP service. Please check them [%s]", headers));
        }
        this.httpService().setDefaultEmptyPath(this.configuration.string("emptyPath", ""));
        this.httpService().setRememberCookies(Configuration.parseBooleanValue((String)this.configuration.string("rememberCookies"), (Boolean)false));
        if (StringUtils.isBlank((CharSequence)this.baseUrl)) {
            this.httpService().setAllowExternalUrl(true);
        } else {
            this.httpService().setAllowExternalUrl(Configuration.parseBooleanValue((String)this.configuration.string("allowExternalUrl"), (Boolean)false));
        }
        this.httpService().setFollowRedirects(Boolean.valueOf(Configuration.parseBooleanValue((String)this.configuration.string("followRedirects"), (Boolean)true)));
        this.httpService().setConnectionTimeout(Integer.valueOf(this.configuration.integer("connectionTimeout", 5000)));
        this.httpService().setReadTimeout(Integer.valueOf(this.configuration.integer("readTimeout", 60000)));
        logger.info(String.format("Configured service [%s]: baseUrl [%s]", SERVICE_NAME, this.baseUrl));
    }

    private static Json checkHeaders(String stringHeaders) {
        Json headers = Json.map();
        try {
            if (StringUtils.isNotBlank((CharSequence)stringHeaders)) {
                String[] pairs;
                for (String pair : pairs = StringUtils.split((String)stringHeaders, (String)",")) {
                    String[] keyValue = StringUtils.split((String)pair, (String)"=");
                    headers.set(keyValue[0].trim(), keyValue.length > 1 ? keyValue[1].trim() : Boolean.valueOf(true));
                }
            }
        }
        catch (Exception e) {
            throw ServiceException.permanent((ErrorCode)ErrorCode.ARGUMENT, (Object)String.format("Default headers [%s] are invalid", stringHeaders));
        }
        return headers;
    }

    public WebServiceResponse asyncWebhook(WebServiceRequest request) {
        logger.info(String.format("Webhook received for service [%s]", SERVICE_NAME));
        try {
            this.events().send("webhook", (Object)io.slingr.services.services.HttpService.defaultWebhookConverter((WebServiceRequest)request));
            return new WebServiceResponse((Object)"Ok");
        }
        catch (ClassCastException cce) {
            this.appLogs.error("The response to the webhook from the listener is not a valid JSON");
        }
        catch (Exception e) {
            this.appLogs.error("There was an error processing webhook: " + e.getMessage(), (Throwable)e);
        }
        return new WebServiceResponse((Object)Json.map(), ContentType.APPLICATION_JSON.toString());
    }

    public WebServiceResponse optionsLoad(WebServiceRequest request) {
        logger.info(String.format("Webhook sync received for service [%s]", SERVICE_NAME));
        try {
            Json options = (Json)this.events().sendSync("webhookSync", (Object)io.slingr.services.services.HttpService.defaultWebhookConverter((WebServiceRequest)request));
            return new WebServiceResponse((Object)options, ContentType.APPLICATION_JSON.toString());
        }
        catch (ClassCastException cce) {
            this.appLogs.error("The response to the sync webhook from the listener is not a valid JSON");
        }
        catch (Exception e) {
            this.appLogs.error("There was an error processing sync webhook: " + e.getMessage(), (Throwable)e);
        }
        return new WebServiceResponse((Object)Json.map(), ContentType.APPLICATION_JSON.toString());
    }
}

