/*
 * Decompiled with CFR 0.152.
 */
package io.slingr.service.http;

import io.slingr.service.http.Http;
import io.slingr.services.Service;
import io.slingr.services.framework.IHttpService;
import io.slingr.services.framework.IRunner;
import io.slingr.services.framework.RegisteredFunction;
import io.slingr.services.framework.RegisteredWebService;
import io.slingr.services.framework.annotations.classes.FunctionResponseType;
import io.slingr.services.framework.annotations.classes.MethodAccessorType;
import io.slingr.services.framework.annotations.classes.MethodParameterType;
import io.slingr.services.framework.annotations.classes.WebServiceResponseType;
import io.slingr.services.services.rest.RestMethod;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Runner
extends IRunner {
    private static final Logger logger = LoggerFactory.getLogger(Service.class);

    public static void main(String[] args) throws Exception {
        String configurationFile = Runner.extractArgument((String)"configurationFile", (String[])args);
        String defaultWebServiceUri = Runner.extractArgument((String)"defaultWebServiceUri", (String[])args);
        new Runner().startService(configurationFile, defaultWebServiceUri);
    }

    public Http createService() {
        return new Http();
    }

    public Http startService(Service serviceInstance, String configurationFile, String defaultWebServiceUri) throws Exception {
        boolean accessible;
        Field field;
        if (serviceInstance == null) {
            throw new IllegalStateException("Invalid service object");
        }
        if (!(serviceInstance instanceof Http)) {
            throw new IllegalStateException("Invalid service instance: expected [" + Http.class.getName() + "], current [" + serviceInstance.getClass().getName() + "]");
        }
        Http service = (Http)serviceInstance;
        service.configure(configurationFile);
        String serviceType = "http";
        if (!"http".equals(service.definitions().getType())) {
            throw new IllegalStateException(String.format("Invalid the defined service name [%s] on service instead to use the value of definitions [%s]", "http", service.definitions().getType()));
        }
        if (StringUtils.isNotBlank((CharSequence)defaultWebServiceUri)) {
            service.properties().setDefaultWebServicesUri(defaultWebServiceUri);
        }
        Class<Http> clazz = Http.class;
        try {
            field = clazz.getDeclaredField("appLogs");
            accessible = field.isAccessible();
            field.setAccessible(true);
            field.set((Object)service, service.appLogs());
            field.setAccessible(accessible);
        }
        catch (Exception ex) {
            logger.info("Exception when try to set [service.appLogs()] on [appLogs]: " + ex.getMessage());
            throw ex;
        }
        try {
            field = clazz.getDeclaredField("configuration");
            accessible = field.isAccessible();
            field.setAccessible(true);
            field.set((Object)service, service.properties().getServiceConfiguration());
            field.setAccessible(accessible);
        }
        catch (Exception ex) {
            logger.info("Exception when try to set [service.properties().getServiceConfiguration()] on [configuration]: " + ex.getMessage());
            throw ex;
        }
        try {
            field = clazz.getDeclaredField("baseUrl");
            accessible = field.isAccessible();
            field.setAccessible(true);
            field.set((Object)service, service.properties().getServiceConfiguration().string("baseUrl"));
            field.setAccessible(accessible);
        }
        catch (Exception ex) {
            logger.info("Exception when try to set [service.properties().getServiceConfiguration().string(\"baseUrl\")] on [baseUrl]: " + ex.getMessage());
            throw ex;
        }
        Method function = Service.class.getDeclaredMethod("internalRegisterFunction", RegisteredFunction.class, Boolean.class);
        function.setAccessible(true);
        function.invoke((Object)service, new RegisteredFunction("head", "defaultHeadRequest", MethodParameterType.REQUEST, FunctionResponseType.JSON, MethodAccessorType.PUBLIC, IHttpService.class), Boolean.FALSE);
        function.invoke((Object)service, new RegisteredFunction("patch", "defaultPatchRequest", MethodParameterType.REQUEST, FunctionResponseType.JSON, MethodAccessorType.PUBLIC, IHttpService.class), Boolean.FALSE);
        function.invoke((Object)service, new RegisteredFunction("post", "defaultPostRequest", MethodParameterType.REQUEST, FunctionResponseType.JSON, MethodAccessorType.PUBLIC, IHttpService.class), Boolean.FALSE);
        function.invoke((Object)service, new RegisteredFunction("get", "defaultGetRequest", MethodParameterType.REQUEST, FunctionResponseType.JSON, MethodAccessorType.PUBLIC, IHttpService.class), Boolean.FALSE);
        function.invoke((Object)service, new RegisteredFunction("options", "defaultOptionsRequest", MethodParameterType.REQUEST, FunctionResponseType.JSON, MethodAccessorType.PUBLIC, IHttpService.class), Boolean.FALSE);
        function.invoke((Object)service, new RegisteredFunction("delete", "defaultDeleteRequest", MethodParameterType.REQUEST, FunctionResponseType.JSON, MethodAccessorType.PUBLIC, IHttpService.class), Boolean.FALSE);
        function.invoke((Object)service, new RegisteredFunction("put", "defaultPutRequest", MethodParameterType.REQUEST, FunctionResponseType.JSON, MethodAccessorType.PUBLIC, IHttpService.class), Boolean.FALSE);
        function.setAccessible(false);
        Method webService = Service.class.getDeclaredMethod("internalRegisterWebService", RegisteredWebService.class);
        webService.setAccessible(true);
        webService.invoke((Object)service, new RegisteredWebService("/~pu", RestMethod.PUT, "/", "defaultWebhookProcessor", MethodParameterType.REQUEST, WebServiceResponseType.RESPONSE, MethodAccessorType.PUBLIC, IHttpService.class));
        webService.invoke((Object)service, new RegisteredWebService("/~pa", RestMethod.PATCH, "/", "defaultWebhookProcessor", MethodParameterType.REQUEST, WebServiceResponseType.RESPONSE, MethodAccessorType.PUBLIC, IHttpService.class));
        webService.invoke((Object)service, new RegisteredWebService("/~de", RestMethod.DELETE, "/", "defaultWebhookProcessor", MethodParameterType.REQUEST, WebServiceResponseType.RESPONSE, MethodAccessorType.PUBLIC, IHttpService.class));
        webService.invoke((Object)service, new RegisteredWebService("/~op", RestMethod.OPTIONS, "/", "defaultWebhookProcessor", MethodParameterType.REQUEST, WebServiceResponseType.RESPONSE, MethodAccessorType.PUBLIC, IHttpService.class));
        webService.invoke((Object)service, new RegisteredWebService("/~po", RestMethod.POST, "/", "defaultWebhookProcessor", MethodParameterType.REQUEST, WebServiceResponseType.RESPONSE, MethodAccessorType.PUBLIC, IHttpService.class));
        webService.invoke((Object)service, new RegisteredWebService("/~ge", RestMethod.GET, "/", "defaultWebhookProcessor", MethodParameterType.REQUEST, WebServiceResponseType.RESPONSE, MethodAccessorType.PUBLIC, IHttpService.class));
        webService.invoke((Object)service, new RegisteredWebService("/~he", RestMethod.HEAD, "/", "defaultWebhookProcessor", MethodParameterType.REQUEST, WebServiceResponseType.RESPONSE, MethodAccessorType.PUBLIC, IHttpService.class));
        webService.invoke((Object)service, new RegisteredWebService("/{externalservice}~de", RestMethod.DELETE, "/{externalService}/", "asyncWebhook", MethodParameterType.REQUEST, WebServiceResponseType.RESPONSE, MethodAccessorType.PUBLIC));
        webService.invoke((Object)service, new RegisteredWebService("/{externalservice}~ge", RestMethod.GET, "/{externalService}/", "asyncWebhook", MethodParameterType.REQUEST, WebServiceResponseType.RESPONSE, MethodAccessorType.PUBLIC));
        webService.invoke((Object)service, new RegisteredWebService("/{externalservice}~he", RestMethod.HEAD, "/{externalService}/", "asyncWebhook", MethodParameterType.REQUEST, WebServiceResponseType.RESPONSE, MethodAccessorType.PUBLIC));
        webService.invoke((Object)service, new RegisteredWebService("/{externalservice}~op", RestMethod.OPTIONS, "/{externalService}/", "asyncWebhook", MethodParameterType.REQUEST, WebServiceResponseType.RESPONSE, MethodAccessorType.PUBLIC));
        webService.invoke((Object)service, new RegisteredWebService("/{externalservice}~pa", RestMethod.PATCH, "/{externalService}/", "asyncWebhook", MethodParameterType.REQUEST, WebServiceResponseType.RESPONSE, MethodAccessorType.PUBLIC));
        webService.invoke((Object)service, new RegisteredWebService("/{externalservice}~po", RestMethod.POST, "/{externalService}/", "asyncWebhook", MethodParameterType.REQUEST, WebServiceResponseType.RESPONSE, MethodAccessorType.PUBLIC));
        webService.invoke((Object)service, new RegisteredWebService("/{externalservice}~pu", RestMethod.PUT, "/{externalService}/", "asyncWebhook", MethodParameterType.REQUEST, WebServiceResponseType.RESPONSE, MethodAccessorType.PUBLIC));
        webService.invoke((Object)service, new RegisteredWebService("/{externalservice}/sync~de", RestMethod.DELETE, "/{externalService}/sync/", "optionsLoad", MethodParameterType.REQUEST, WebServiceResponseType.RESPONSE, MethodAccessorType.PUBLIC));
        webService.invoke((Object)service, new RegisteredWebService("/{externalservice}/sync~ge", RestMethod.GET, "/{externalService}/sync/", "optionsLoad", MethodParameterType.REQUEST, WebServiceResponseType.RESPONSE, MethodAccessorType.PUBLIC));
        webService.invoke((Object)service, new RegisteredWebService("/{externalservice}/sync~he", RestMethod.HEAD, "/{externalService}/sync/", "optionsLoad", MethodParameterType.REQUEST, WebServiceResponseType.RESPONSE, MethodAccessorType.PUBLIC));
        webService.invoke((Object)service, new RegisteredWebService("/{externalservice}/sync~op", RestMethod.OPTIONS, "/{externalService}/sync/", "optionsLoad", MethodParameterType.REQUEST, WebServiceResponseType.RESPONSE, MethodAccessorType.PUBLIC));
        webService.invoke((Object)service, new RegisteredWebService("/{externalservice}/sync~pa", RestMethod.PATCH, "/{externalService}/sync/", "optionsLoad", MethodParameterType.REQUEST, WebServiceResponseType.RESPONSE, MethodAccessorType.PUBLIC));
        webService.invoke((Object)service, new RegisteredWebService("/{externalservice}/sync~po", RestMethod.POST, "/{externalService}/sync/", "optionsLoad", MethodParameterType.REQUEST, WebServiceResponseType.RESPONSE, MethodAccessorType.PUBLIC));
        webService.invoke((Object)service, new RegisteredWebService("/{externalservice}/sync~pu", RestMethod.PUT, "/{externalService}/sync/", "optionsLoad", MethodParameterType.REQUEST, WebServiceResponseType.RESPONSE, MethodAccessorType.PUBLIC));
        webService.setAccessible(false);
        Method startMethod = Service.class.getDeclaredMethod("finishedStart", new Class[0]);
        startMethod.setAccessible(true);
        startMethod.invoke((Object)service, new Object[0]);
        startMethod.setAccessible(false);
        return service;
    }
}

