goog.provide('uniformity.random');
/**
 * Generate an array of n cryptographically random bytes
 */
uniformity.random.random_bytes = (function uniformity$random$random_bytes(n){
if((n > (0))){
} else {
throw (new Error("Assert failed: (> n 0)"));
}

return uniformity.internals.rand_js.random_bytes(n);
});
/**
 * Returns a value between -2^31 and 2^31, exclusive of upper bound.
 *   Return value does not necessarily have int32 as its data type.
 *   When called with no argument, or one argument for upper bound, defaults to a lower bound of 0.
 */
uniformity.random.random_int32 = (function uniformity$random$random_int32(var_args){
var G__8255 = arguments.length;
switch (G__8255) {
case 0:
return uniformity.random.random_int32.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return uniformity.random.random_int32.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return uniformity.random.random_int32.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(uniformity.random.random_int32.cljs$core$IFn$_invoke$arity$0 = (function (){
return uniformity.internals.rand_js.random_int32.cljs$core$IFn$_invoke$arity$0();
}));

(uniformity.random.random_int32.cljs$core$IFn$_invoke$arity$1 = (function (max){
return uniformity.internals.rand_js.random_int32.cljs$core$IFn$_invoke$arity$1(max);
}));

(uniformity.random.random_int32.cljs$core$IFn$_invoke$arity$2 = (function (min,max){
if((min >= Math.pow((-2),(31)))){
} else {
throw (new Error("Assert failed: (>= min (Math/pow -2 31))"));
}

if((max <= Math.pow((2),(31)))){
} else {
throw (new Error("Assert failed: (<= max (Math/pow 2 31))"));
}

if((max > min)){
} else {
throw (new Error("Assert failed: (> max min)"));
}

return uniformity.internals.rand_js.random_int32.cljs$core$IFn$_invoke$arity$2(min,max);
}));

(uniformity.random.random_int32.cljs$lang$maxFixedArity = 2);

/**
 * Returns a cryptographically random boolean
 */
uniformity.random.random_bool = (function uniformity$random$random_bool(){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),uniformity.random.random_int32.cljs$core$IFn$_invoke$arity$1((2)));
});
/**
 * Generates hex-encoded string of n bytes
 */
uniformity.random.random_hex_string = (function uniformity$random$random_hex_string(n){
return uniformity.util.hex_encode(uniformity.random.random_bytes(n));
});
/**
 * Generates base64-encoded string of n bytes
 */
uniformity.random.random_base64_string = (function uniformity$random$random_base64_string(n){
return uniformity.util.base64_encode(uniformity.random.random_bytes(n));
});
/**
 * Generates URL-safe base64-encoded string of n bytes
 */
uniformity.random.urlsafe_token = (function uniformity$random$urlsafe_token(n){
return uniformity.util.base64_encode_urlsafe(uniformity.random.random_bytes(n));
});
/**
 * Returns a cryptographically random element from a collection, or a character from a string.
 *   Can take a count as the second argument to return a sequence of selections.
 */
uniformity.random.random_selection = (function uniformity$random$random_selection(var_args){
var G__8257 = arguments.length;
switch (G__8257) {
case 1:
return uniformity.random.random_selection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return uniformity.random.random_selection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(uniformity.random.random_selection.cljs$core$IFn$_invoke$arity$1 = (function (coll){
if((cljs.core.count(coll) > (0))){
} else {
throw (new Error("Assert failed: (> (count coll) 0)"));
}

if(((cljs.core.coll_QMARK_(coll)) || (typeof coll === 'string'))){
} else {
throw (new Error("Assert failed: (or (coll? coll) (string? coll))"));
}

return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,uniformity.random.random_int32.cljs$core$IFn$_invoke$arity$1(cljs.core.count(coll)));
}));

(uniformity.random.random_selection.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return uniformity.random.random_selection.cljs$core$IFn$_invoke$arity$1(coll);
}));
}));

(uniformity.random.random_selection.cljs$lang$maxFixedArity = 2);

/**
 * Generates password, either from a character mask (provided as string), or a collection of mask option keywords.
 *   Mask options:
 *  :upper adds A-Z
 *  :lower adds a-z
 *  :digits adds 0-9
 *  :special adds !@#$%^&*-_+=
 *  :non-ambiguous removes O01Il
 */
uniformity.random.password = (function uniformity$random$password(length,mask_or_opts){
if((length > (0))){
} else {
throw (new Error("Assert failed: (> length 0)"));
}

if((cljs.core.count(mask_or_opts) > (0))){
} else {
throw (new Error("Assert failed: (> (count mask-or-opts) 0)"));
}

if(((typeof mask_or_opts === 'string') || (cljs.core.coll_QMARK_(mask_or_opts)))){
} else {
throw (new Error("Assert failed: (or (string? mask-or-opts) (coll? mask-or-opts))"));
}

if(typeof mask_or_opts === 'string'){
var mask = mask_or_opts;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,uniformity.random.random_selection.cljs$core$IFn$_invoke$arity$2(mask,length));
} else {
var opts = cljs.core.set(mask_or_opts);
var mask = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core.str,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [((cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"upper","upper",246243906)))?"ABCDEFGHIJKLMNOPQRSTUVWXYZ":null),((cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"lower","lower",1120320821)))?"abcdefghijklmnopqrstuvwxyz":null),((cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"digits","digits",-1134635061)))?"0123456789":null),((cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"special","special",-1125941630)))?"!@#$%^&*-_+=":null)], null));
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"non-ambiguous","non-ambiguous",1328941802))){
var G__8266 = length;
var G__8267 = clojure.string.replace(mask,/[O01Il]/,"");
return (uniformity.random.password.cljs$core$IFn$_invoke$arity$2 ? uniformity.random.password.cljs$core$IFn$_invoke$arity$2(G__8266,G__8267) : uniformity.random.password.call(null,G__8266,G__8267));
} else {
return (uniformity.random.password.cljs$core$IFn$_invoke$arity$2 ? uniformity.random.password.cljs$core$IFn$_invoke$arity$2(length,mask) : uniformity.random.password.call(null,length,mask));
}
}
});
/**
 * Generates passphrase from a wordlist, optionally taking delimiter (defaults to -).
 */
uniformity.random.passphrase = (function uniformity$random$passphrase(var_args){
var G__8271 = arguments.length;
switch (G__8271) {
case 2:
return uniformity.random.passphrase.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return uniformity.random.passphrase.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(uniformity.random.passphrase.cljs$core$IFn$_invoke$arity$2 = (function (length,wordlist){
return uniformity.random.passphrase.cljs$core$IFn$_invoke$arity$3(length,wordlist,"-");
}));

(uniformity.random.passphrase.cljs$core$IFn$_invoke$arity$3 = (function (length,wordlist,delimiter){
if((length > (0))){
} else {
throw (new Error("Assert failed: (> length 0)"));
}

if(((cljs.core.coll_QMARK_(wordlist)) && ((cljs.core.count(wordlist) > (0))))){
} else {
throw (new Error("Assert failed: (and (coll? wordlist) (> (count wordlist) 0))"));
}

if(((typeof delimiter === 'string') || (cljs.core.char_QMARK_(delimiter)))){
} else {
throw (new Error("Assert failed: (or (string? delimiter) (char? delimiter))"));
}

return clojure.string.join.cljs$core$IFn$_invoke$arity$2(delimiter,uniformity.random.random_selection.cljs$core$IFn$_invoke$arity$2(wordlist,length));
}));

(uniformity.random.passphrase.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=uniformity.random.js.map
