goog.provide('shadow.test');
/**
 * like ct/test-vars-block but more generic
 * groups vars by namespace, executes fixtures
 */
shadow.test.test_vars_grouped_block = (function shadow$test$test_vars_grouped_block(vars){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p__10489){
var vec__10490 = p__10489;
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10490,(0),null);
var vars__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10490,(1),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-test-ns","begin-test-ns",-1701237033),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
}),(function (){
return cljs.test.block((function (){var env = cljs.test.get_current_env();
var once_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167),ns], null));
var each_fixtures = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977),ns], null));
var G__10494 = cljs.test.execution_strategy(once_fixtures,each_fixtures);
var G__10494__$1 = (((G__10494 instanceof cljs.core.Keyword))?G__10494.fqn:null);
switch (G__10494__$1) {
case "async":
return cljs.test.wrap_map_fixtures(once_fixtures,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.test.wrap_map_fixtures,each_fixtures),cljs.test.test_var_block),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),cljs.core.meta),vars__$1)], 0)));

break;
case "sync":
var each_fixture_fn = cljs.test.join_fixtures(each_fixtures);
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
var G__10501 = (function (){
var seq__10502 = cljs.core.seq(vars__$1);
var chunk__10503 = null;
var count__10504 = (0);
var i__10505 = (0);
while(true){
if((i__10505 < count__10504)){
var v = chunk__10503.cljs$core$IIndexed$_nth$arity$2(null,i__10505);
var temp__5753__auto___10722 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5753__auto___10722)){
var t_10723 = temp__5753__auto___10722;
var G__10576_10724 = ((function (seq__10502,chunk__10503,count__10504,i__10505,t_10723,temp__5753__auto___10722,v,each_fixture_fn,G__10494,G__10494__$1,env,once_fixtures,each_fixtures,vec__10490,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_10723)));
});})(seq__10502,chunk__10503,count__10504,i__10505,t_10723,temp__5753__auto___10722,v,each_fixture_fn,G__10494,G__10494__$1,env,once_fixtures,each_fixtures,vec__10490,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__10576_10724) : each_fixture_fn.call(null,G__10576_10724));
} else {
}


var G__10727 = seq__10502;
var G__10728 = chunk__10503;
var G__10729 = count__10504;
var G__10730 = (i__10505 + (1));
seq__10502 = G__10727;
chunk__10503 = G__10728;
count__10504 = G__10729;
i__10505 = G__10730;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__10502);
if(temp__5753__auto__){
var seq__10502__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10502__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__10502__$1);
var G__10731 = cljs.core.chunk_rest(seq__10502__$1);
var G__10732 = c__4638__auto__;
var G__10733 = cljs.core.count(c__4638__auto__);
var G__10734 = (0);
seq__10502 = G__10731;
chunk__10503 = G__10732;
count__10504 = G__10733;
i__10505 = G__10734;
continue;
} else {
var v = cljs.core.first(seq__10502__$1);
var temp__5753__auto___10735__$1 = new cljs.core.Keyword(null,"test","test",577538877).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(v));
if(cljs.core.truth_(temp__5753__auto___10735__$1)){
var t_10736 = temp__5753__auto___10735__$1;
var G__10607_10737 = ((function (seq__10502,chunk__10503,count__10504,i__10505,t_10736,temp__5753__auto___10735__$1,v,seq__10502__$1,temp__5753__auto__,each_fixture_fn,G__10494,G__10494__$1,env,once_fixtures,each_fixtures,vec__10490,ns,vars__$1){
return (function (){
return cljs.test.run_block(cljs.test.test_var_block_STAR_(v,cljs.test.disable_async(t_10736)));
});})(seq__10502,chunk__10503,count__10504,i__10505,t_10736,temp__5753__auto___10735__$1,v,seq__10502__$1,temp__5753__auto__,each_fixture_fn,G__10494,G__10494__$1,env,once_fixtures,each_fixtures,vec__10490,ns,vars__$1))
;
(each_fixture_fn.cljs$core$IFn$_invoke$arity$1 ? each_fixture_fn.cljs$core$IFn$_invoke$arity$1(G__10607_10737) : each_fixture_fn.call(null,G__10607_10737));
} else {
}


var G__10738 = cljs.core.next(seq__10502__$1);
var G__10739 = null;
var G__10740 = (0);
var G__10741 = (0);
seq__10502 = G__10738;
chunk__10503 = G__10739;
count__10504 = G__10740;
i__10505 = G__10741;
continue;
}
} else {
return null;
}
}
break;
}
});
var fexpr__10500 = cljs.test.join_fixtures(once_fixtures);
return (fexpr__10500.cljs$core$IFn$_invoke$arity$1 ? fexpr__10500.cljs$core$IFn$_invoke$arity$1(G__10501) : fexpr__10500.call(null,G__10501));
})], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__10494__$1)].join('')));

}
})());
}),(function (){
return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-test-ns","end-test-ns",1620675645),new cljs.core.Keyword(null,"ns","ns",441598760),ns], null));
})], null);
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.group_by((function (p1__10487_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__10487_SHARP_));
}),vars))], 0));
});
/**
 * Like test-ns, but returns a block for further composition and
 *   later execution.  Does not clear the current env.
 */
shadow.test.test_ns_block = (function shadow$test$test_ns_block(ns){
if((ns instanceof cljs.core.Symbol)){
} else {
throw (new Error("Assert failed: (symbol? ns)"));
}

var map__10614 = shadow.test.env.get_test_ns_info(ns);
var map__10614__$1 = cljs.core.__destructure_map(map__10614);
var test_ns = map__10614__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10614__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
if(cljs.core.not(test_ns)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns)," not found, no tests to run."].join('')], 0));
})], null);
} else {
return shadow.test.test_vars_grouped_block(vars);
}
});
shadow.test.prepare_test_run = (function shadow$test$prepare_test_run(p__10622,vars){
var map__10623 = p__10622;
var map__10623__$1 = cljs.core.__destructure_map(map__10623);
var env = map__10623__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10623__$1,new cljs.core.Keyword(null,"report-fn","report-fn",-549046115));
var orig_report = cljs.test.report;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){
cljs.test.set_env_BANG_(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061),orig_report));

if(cljs.core.truth_(report_fn)){
(cljs.test.report = report_fn);
} else {
}

var seq__10625_10742 = cljs.core.seq(shadow.test.env.get_tests());
var chunk__10627_10743 = null;
var count__10628_10744 = (0);
var i__10629_10745 = (0);
while(true){
if((i__10629_10745 < count__10628_10744)){
var vec__10652_10746 = chunk__10627_10743.cljs$core$IIndexed$_nth$arity$2(null,i__10629_10745);
var test_ns_10747 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10652_10746,(0),null);
var ns_info_10748 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10652_10746,(1),null);
var map__10655_10749 = ns_info_10748;
var map__10655_10750__$1 = cljs.core.__destructure_map(map__10655_10749);
var fixtures_10751 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10655_10750__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5753__auto___10770 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_10751);
if(cljs.core.truth_(temp__5753__auto___10770)){
var fix_10771 = temp__5753__auto___10770;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_10747,fix_10771], 0));
} else {
}

var temp__5753__auto___10773 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_10751);
if(cljs.core.truth_(temp__5753__auto___10773)){
var fix_10775 = temp__5753__auto___10773;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_10747,fix_10775], 0));
} else {
}


var G__10776 = seq__10625_10742;
var G__10777 = chunk__10627_10743;
var G__10778 = count__10628_10744;
var G__10779 = (i__10629_10745 + (1));
seq__10625_10742 = G__10776;
chunk__10627_10743 = G__10777;
count__10628_10744 = G__10778;
i__10629_10745 = G__10779;
continue;
} else {
var temp__5753__auto___10780 = cljs.core.seq(seq__10625_10742);
if(temp__5753__auto___10780){
var seq__10625_10781__$1 = temp__5753__auto___10780;
if(cljs.core.chunked_seq_QMARK_(seq__10625_10781__$1)){
var c__4638__auto___10782 = cljs.core.chunk_first(seq__10625_10781__$1);
var G__10783 = cljs.core.chunk_rest(seq__10625_10781__$1);
var G__10784 = c__4638__auto___10782;
var G__10785 = cljs.core.count(c__4638__auto___10782);
var G__10786 = (0);
seq__10625_10742 = G__10783;
chunk__10627_10743 = G__10784;
count__10628_10744 = G__10785;
i__10629_10745 = G__10786;
continue;
} else {
var vec__10664_10787 = cljs.core.first(seq__10625_10781__$1);
var test_ns_10788 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10664_10787,(0),null);
var ns_info_10789 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10664_10787,(1),null);
var map__10667_10790 = ns_info_10789;
var map__10667_10791__$1 = cljs.core.__destructure_map(map__10667_10790);
var fixtures_10792 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10667_10791__$1,new cljs.core.Keyword(null,"fixtures","fixtures",1009814994));
var temp__5753__auto___10793__$1 = new cljs.core.Keyword(null,"once","once",-262568523).cljs$core$IFn$_invoke$arity$1(fixtures_10792);
if(cljs.core.truth_(temp__5753__auto___10793__$1)){
var fix_10794 = temp__5753__auto___10793__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"once-fixtures","once-fixtures",1253947167)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_10788,fix_10794], 0));
} else {
}

var temp__5753__auto___10795__$1 = new cljs.core.Keyword(null,"each","each",940016129).cljs$core$IFn$_invoke$arity$1(fixtures_10792);
if(cljs.core.truth_(temp__5753__auto___10795__$1)){
var fix_10796 = temp__5753__auto___10795__$1;
cljs.test.update_current_env_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"each-fixtures","each-fixtures",802243977)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test_ns_10788,fix_10796], 0));
} else {
}


var G__10797 = cljs.core.next(seq__10625_10781__$1);
var G__10798 = null;
var G__10799 = (0);
var G__10800 = (0);
seq__10625_10742 = G__10797;
chunk__10627_10743 = G__10798;
count__10628_10744 = G__10799;
i__10629_10745 = G__10800;
continue;
}
} else {
}
}
break;
}

return cljs.test.report.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"begin-run-tests","begin-run-tests",309363062),new cljs.core.Keyword(null,"var-count","var-count",-1513152110),cljs.core.count(vars),new cljs.core.Keyword(null,"ns-count","ns-count",-1269070724),cljs.core.count(cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__10617_SHARP_){
return new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__10617_SHARP_));
}),vars)))], null));
})], null);
});
shadow.test.finish_test_run = (function shadow$test$finish_test_run(block){
if(cljs.core.vector_QMARK_(block)){
} else {
throw (new Error("Assert failed: (vector? block)"));
}

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(block,(function (){
var map__10674 = cljs.test.get_current_env();
var map__10674__$1 = cljs.core.__destructure_map(map__10674);
var env = map__10674__$1;
var report_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10674__$1,new cljs.core.Keyword("shadow.test","report-fn","shadow.test/report-fn",1075704061));
var report_counters = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10674__$1,new cljs.core.Keyword(null,"report-counters","report-counters",-1702609242));
cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"summary","summary",380847952)));

cljs.test.report.call(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(report_counters,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"end-run-tests","end-run-tests",267300563)));

return (cljs.test.report = report_fn);
}));
});
/**
 * tests all vars grouped by namespace, expects seq of test vars, can be obtained from env
 */
shadow.test.run_test_vars = (function shadow$test$run_test_vars(var_args){
var G__10679 = arguments.length;
switch (G__10679) {
case 1:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$1 = (function (test_vars){
return shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),test_vars);
}));

(shadow.test.run_test_vars.cljs$core$IFn$_invoke$arity$2 = (function (env,vars){
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_test_vars.cljs$lang$maxFixedArity = 2);

/**
 * test all vars for given namespace symbol
 */
shadow.test.test_ns = (function shadow$test$test_ns(var_args){
var G__10681 = arguments.length;
switch (G__10681) {
case 1:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$1 = (function (ns){
return shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),ns);
}));

(shadow.test.test_ns.cljs$core$IFn$_invoke$arity$2 = (function (env,ns){
var map__10682 = shadow.test.env.get_test_ns_info(ns);
var map__10682__$1 = cljs.core.__destructure_map(map__10682);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10682__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.test_ns.cljs$lang$maxFixedArity = 2);

/**
 * test all vars in specified namespace symbol set
 */
shadow.test.run_tests = (function shadow$test$run_tests(var_args){
var G__10689 = arguments.length;
switch (G__10689) {
case 0:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,shadow.test.env.get_test_namespaces());
}));

(shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,namespaces){
if(cljs.core.set_QMARK_(namespaces)){
} else {
throw (new Error("Assert failed: (set? namespaces)"));
}

var vars = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__10683_SHARP_){
return cljs.core.contains_QMARK_(namespaces,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(p1__10683_SHARP_)));
}),shadow.test.env.get_test_vars());
return cljs.test.run_block(shadow.test.finish_test_run(cljs.core.into.cljs$core$IFn$_invoke$arity$2(shadow.test.prepare_test_run(env,vars),shadow.test.test_vars_grouped_block(vars))));
}));

(shadow.test.run_tests.cljs$lang$maxFixedArity = 2);

/**
 * Runs all tests in all namespaces; prints results.
 *   Optional argument is a regular expression; only namespaces with
 *   names matching the regular expression (with re-matches) will be
 *   tested.
 */
shadow.test.run_all_tests = (function shadow$test$run_all_tests(var_args){
var G__10708 = arguments.length;
switch (G__10708) {
case 0:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$0 = (function (){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(cljs.test.empty_env.cljs$core$IFn$_invoke$arity$0(),null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$1 = (function (env){
return shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2(env,null);
}));

(shadow.test.run_all_tests.cljs$core$IFn$_invoke$arity$2 = (function (env,re){
return shadow.test.run_tests.cljs$core$IFn$_invoke$arity$2(env,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__10699_SHARP_){
var or__4212__auto__ = (re == null);
if(or__4212__auto__){
return or__4212__auto__;
} else {
return cljs.core.re_matches(re,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__10699_SHARP_));
}
}),shadow.test.env.get_test_namespaces())));
}));

(shadow.test.run_all_tests.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=shadow.test.js.map
